/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.AudioAttributes;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RotarySelector
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int HORIZONTAL = 0;
    public static int VERTICAL = 1;
    private static String LOG_TAG = "RotarySelector";
    private static boolean DBG = false;
    private static boolean VISUAL_DEBUG = false;
    private static AudioAttributes VIBRATION_ATTRIBUTES;
    private OnDialTriggerListener mOnDialTriggerListener;
    private float mDensity;
    private Bitmap mBackground;
    private Bitmap mDimple;
    private Bitmap mDimpleDim;
    private Bitmap mLeftHandleIcon;
    private Bitmap mRightHandleIcon;
    private Bitmap mArrowShortLeftAndRight;
    private Bitmap mArrowLongLeft;
    private Bitmap mArrowLongRight;
    private int mLeftHandleX;
    private int mRightHandleX;
    private int mRotaryOffsetX;
    private boolean mAnimating;
    private long mAnimationStartTime;
    private long mAnimationDuration;
    private int mAnimatingDeltaXStart;
    private int mAnimatingDeltaXEnd;
    private DecelerateInterpolator mInterpolator;
    private Paint mPaint;
    Matrix mBgMatrix;
    Matrix mArrowMatrix;
    private int mGrabbedState;
    public static int NOTHING_GRABBED = 0;
    public static int LEFT_HANDLE_GRABBED = 1;
    public static int RIGHT_HANDLE_GRABBED = 2;
    private boolean mTriggered;
    private Vibrator mVibrator;
    private static long VIBRATE_SHORT = 20L;
    private static long VIBRATE_LONG = 20L;
    private static int ARROW_SCRUNCH_DIP = 6;
    private static int EDGE_PADDING_DIP = 9;
    private static int EDGE_TRIGGER_DIP = 100;
    static int OUTER_ROTARY_RADIUS_DIP = 390;
    static int ROTARY_STROKE_WIDTH_DIP = 83;
    static int SNAP_BACK_ANIMATION_DURATION_MILLIS = 300;
    static int SPIN_ANIMATION_DURATION_MILLIS = 800;
    private int mEdgeTriggerThresh;
    private int mDimpleWidth;
    private int mBackgroundWidth;
    private int mBackgroundHeight;
    private int mOuterRadius;
    private int mInnerRadius;
    private int mDimpleSpacing;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mDimplesOfFling;
    private int mOrientation;

    private void $$robo$$com_android_internal_widget_RotarySelector$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_RotarySelector$__constructor__(Context context, AttributeSet attrs) {
        this.mRotaryOffsetX = 0;
        this.mAnimating = false;
        this.mPaint = new Paint();
        this.mBgMatrix = new Matrix();
        this.mArrowMatrix = new Matrix();
        this.mGrabbedState = 0;
        this.mTriggered = false;
        this.mDimplesOfFling = 0;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RotarySelector);
        this.mOrientation = a.getInt(0, 0);
        a.recycle();
        Resources r = this.getResources();
        this.mDensity = r.getDisplayMetrics().density;
        this.mBackground = this.getBitmapFor(17302623);
        this.mDimple = this.getBitmapFor(17302624);
        this.mDimpleDim = this.getBitmapFor(17302625);
        this.mArrowLongLeft = this.getBitmapFor(17302615);
        this.mArrowLongRight = this.getBitmapFor(17302618);
        this.mArrowShortLeftAndRight = this.getBitmapFor(17302621);
        this.mInterpolator = new DecelerateInterpolator(1.0f);
        this.mEdgeTriggerThresh = (int)(this.mDensity * 100.0f);
        this.mDimpleWidth = this.mDimple.getWidth();
        this.mBackgroundWidth = this.mBackground.getWidth();
        this.mBackgroundHeight = this.mBackground.getHeight();
        this.mOuterRadius = (int)(this.mDensity * 390.0f);
        this.mInnerRadius = (int)(307.0f * this.mDensity);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity() * 2;
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    private final Bitmap $$robo$$com_android_internal_widget_RotarySelector$getBitmapFor(int resId) {
        return BitmapFactory.decodeResource(this.getContext().getResources(), resId);
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int edgePadding = (int)(9.0f * this.mDensity);
        this.mLeftHandleX = edgePadding + this.mDimpleWidth / 2;
        int length = this.isHoriz() ? w : h;
        this.mRightHandleX = length - edgePadding - this.mDimpleWidth / 2;
        this.mDimpleSpacing = length / 2 - this.mLeftHandleX;
        this.mBgMatrix.setTranslate(0.0f, 0.0f);
        if (!this.isHoriz()) {
            int left = w - this.mBackgroundHeight;
            this.mBgMatrix.preRotate(-90.0f, 0.0f, 0.0f);
            this.mBgMatrix.postTranslate(left, h);
        } else {
            this.mBgMatrix.postTranslate(0.0f, h - this.mBackgroundHeight);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_RotarySelector$isHoriz() {
        return this.mOrientation == 0;
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$setLeftHandleResource(int resId) {
        if (resId != 0) {
            this.mLeftHandleIcon = this.getBitmapFor(resId);
        }
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$setRightHandleResource(int resId) {
        if (resId != 0) {
            this.mRightHandleIcon = this.getBitmapFor(resId);
        }
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int length = this.isHoriz() ? View.MeasureSpec.getSize(widthMeasureSpec) : View.MeasureSpec.getSize(heightMeasureSpec);
        int arrowScrunch = (int)(6.0f * this.mDensity);
        int arrowH = this.mArrowShortLeftAndRight.getHeight();
        int height = this.mBackgroundHeight + arrowH - arrowScrunch;
        if (this.isHoriz()) {
            this.setMeasuredDimension(length, height);
        } else {
            this.setMeasuredDimension(height, length);
        }
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$onDraw(Canvas canvas) {
        int y;
        super.onDraw(canvas);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mAnimating) {
            this.updateAnimation();
        }
        canvas.drawBitmap(this.mBackground, this.mBgMatrix, this.mPaint);
        this.mArrowMatrix.reset();
        switch (this.mGrabbedState) {
            case 0: {
                break;
            }
            case 1: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    this.mArrowMatrix.postTranslate(0.0f, height);
                }
                canvas.drawBitmap(this.mArrowLongLeft, this.mArrowMatrix, this.mPaint);
                break;
            }
            case 2: {
                this.mArrowMatrix.setTranslate(0.0f, 0.0f);
                if (!this.isHoriz()) {
                    this.mArrowMatrix.preRotate(-90.0f, 0.0f, 0.0f);
                    this.mArrowMatrix.postTranslate(0.0f, height + (this.mBackgroundWidth - height));
                }
                canvas.drawBitmap(this.mArrowLongRight, this.mArrowMatrix, this.mPaint);
                break;
            }
            default: {
                throw new IllegalStateException("invalid mGrabbedState: " + this.mGrabbedState);
            }
        }
        int bgHeight = this.mBackgroundHeight;
        int bgTop = this.isHoriz() ? height - bgHeight : width - bgHeight;
        int xOffset = this.mLeftHandleX + this.mRotaryOffsetX;
        int drawableY = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, xOffset);
        int x = this.isHoriz() ? xOffset : drawableY + bgTop;
        int n = y = this.isHoriz() ? drawableY + bgTop : height - xOffset;
        if (this.mGrabbedState != 2) {
            this.drawCentered(this.mDimple, canvas, x, y);
            this.drawCentered(this.mLeftHandleIcon, canvas, x, y);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, x, y);
        }
        xOffset = this.isHoriz() ? width / 2 + this.mRotaryOffsetX : height / 2 + this.mRotaryOffsetX;
        drawableY = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, xOffset);
        if (this.isHoriz()) {
            this.drawCentered(this.mDimpleDim, canvas, xOffset, drawableY + bgTop);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, drawableY + bgTop, height - xOffset);
        }
        xOffset = this.mRightHandleX + this.mRotaryOffsetX;
        drawableY = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, xOffset);
        x = this.isHoriz() ? xOffset : drawableY + bgTop;
        int n2 = y = this.isHoriz() ? drawableY + bgTop : height - xOffset;
        if (this.mGrabbedState != 1) {
            this.drawCentered(this.mDimple, canvas, x, y);
            this.drawCentered(this.mRightHandleIcon, canvas, x, y);
        } else {
            this.drawCentered(this.mDimpleDim, canvas, x, y);
        }
        int halfdimple = this.mDimpleWidth / 2;
        for (int dimpleLeft = this.mRotaryOffsetX + this.mLeftHandleX - this.mDimpleSpacing; dimpleLeft > -halfdimple; dimpleLeft -= this.mDimpleSpacing) {
            int drawableY2 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, dimpleLeft);
            if (this.isHoriz()) {
                this.drawCentered(this.mDimpleDim, canvas, dimpleLeft, drawableY2 + bgTop);
                continue;
            }
            this.drawCentered(this.mDimpleDim, canvas, drawableY2 + bgTop, height - dimpleLeft);
        }
        int rightThresh = this.mRight + halfdimple;
        for (int dimpleRight = this.mRotaryOffsetX + this.mRightHandleX + this.mDimpleSpacing; dimpleRight < rightThresh; dimpleRight += this.mDimpleSpacing) {
            int drawableY3 = this.getYOnArc(this.mBackgroundWidth, this.mInnerRadius, this.mOuterRadius, dimpleRight);
            if (this.isHoriz()) {
                this.drawCentered(this.mDimpleDim, canvas, dimpleRight, drawableY3 + bgTop);
                continue;
            }
            this.drawCentered(this.mDimpleDim, canvas, drawableY3 + bgTop, height - dimpleRight);
        }
    }

    private final int $$robo$$com_android_internal_widget_RotarySelector$getYOnArc(int backgroundWidth, int innerRadius, int outerRadius, int x) {
        int halfWidth = (outerRadius - innerRadius) / 2;
        int middleRadius = innerRadius + halfWidth;
        int triangleBottom = backgroundWidth / 2 - x;
        int triangleY = (int)Math.sqrt(middleRadius * middleRadius - triangleBottom * triangleBottom);
        return middleRadius - triangleY + halfWidth;
    }

    private final boolean $$robo$$com_android_internal_widget_RotarySelector$onTouchEvent(MotionEvent event) {
        if (this.mAnimating) {
            return true;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(event);
        int height = this.getHeight();
        int eventX = this.isHoriz() ? (int)event.getX() : height - (int)event.getY();
        int hitWindow = this.mDimpleWidth;
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.mTriggered = false;
                if (this.mGrabbedState != 0) {
                    this.reset();
                    this.invalidate();
                }
                if (eventX < this.mLeftHandleX + hitWindow) {
                    this.mRotaryOffsetX = eventX - this.mLeftHandleX;
                    this.setGrabbedState(1);
                    this.invalidate();
                    this.vibrate(20L);
                    break;
                }
                if (eventX <= this.mRightHandleX - hitWindow) break;
                this.mRotaryOffsetX = eventX - this.mRightHandleX;
                this.setGrabbedState(2);
                this.invalidate();
                this.vibrate(20L);
                break;
            }
            case 2: {
                if (this.mGrabbedState == 1) {
                    int rightThresh;
                    this.mRotaryOffsetX = eventX - this.mLeftHandleX;
                    this.invalidate();
                    int n = rightThresh = this.isHoriz() ? this.getRight() : height;
                    if (eventX < rightThresh - this.mEdgeTriggerThresh || this.mTriggered) break;
                    this.mTriggered = true;
                    this.dispatchTriggerEvent(1);
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                    int rawVelocity = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                    int velocity = Math.max(this.mMinimumVelocity, rawVelocity);
                    this.mDimplesOfFling = Math.max(8, Math.abs(velocity / this.mDimpleSpacing));
                    this.startAnimationWithVelocity(eventX - this.mLeftHandleX, this.mDimplesOfFling * this.mDimpleSpacing, velocity);
                    break;
                }
                if (this.mGrabbedState != 2) break;
                this.mRotaryOffsetX = eventX - this.mRightHandleX;
                this.invalidate();
                if (eventX > this.mEdgeTriggerThresh || this.mTriggered) break;
                this.mTriggered = true;
                this.dispatchTriggerEvent(2);
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int rawVelocity = this.isHoriz() ? (int)velocityTracker.getXVelocity() : -((int)velocityTracker.getYVelocity());
                int velocity = Math.min(-this.mMinimumVelocity, rawVelocity);
                this.mDimplesOfFling = Math.max(8, Math.abs(velocity / this.mDimpleSpacing));
                this.startAnimationWithVelocity(eventX - this.mRightHandleX, -(this.mDimplesOfFling * this.mDimpleSpacing), velocity);
                break;
            }
            case 1: {
                if (this.mGrabbedState == 1 && Math.abs(eventX - this.mLeftHandleX) > 5) {
                    this.startAnimation(eventX - this.mLeftHandleX, 0, 300);
                } else if (this.mGrabbedState == 2 && Math.abs(eventX - this.mRightHandleX) > 5) {
                    this.startAnimation(eventX - this.mRightHandleX, 0, 300);
                }
                this.mRotaryOffsetX = 0;
                this.setGrabbedState(0);
                this.invalidate();
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 3: {
                this.reset();
                this.invalidate();
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$startAnimation(int startX, int endX, int duration) {
        this.mAnimating = true;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = duration;
        this.mAnimatingDeltaXStart = startX;
        this.mAnimatingDeltaXEnd = endX;
        this.setGrabbedState(0);
        this.mDimplesOfFling = 0;
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$startAnimationWithVelocity(int startX, int endX, int pixelsPerSecond) {
        this.mAnimating = true;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationDuration = 1000 * (endX - startX) / pixelsPerSecond;
        this.mAnimatingDeltaXStart = startX;
        this.mAnimatingDeltaXEnd = endX;
        this.setGrabbedState(0);
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$updateAnimation() {
        boolean goingRight;
        long millisSoFar = AnimationUtils.currentAnimationTimeMillis() - this.mAnimationStartTime;
        long millisLeft = this.mAnimationDuration - millisSoFar;
        int totalDeltaX = this.mAnimatingDeltaXStart - this.mAnimatingDeltaXEnd;
        boolean bl = goingRight = totalDeltaX < 0;
        if (millisLeft <= 0L) {
            this.reset();
            return;
        }
        float interpolation = this.mInterpolator.getInterpolation((float)millisSoFar / (float)this.mAnimationDuration);
        int dx = (int)((float)totalDeltaX * (1.0f - interpolation));
        this.mRotaryOffsetX = this.mAnimatingDeltaXEnd + dx;
        if (this.mDimplesOfFling > 0) {
            if (!goingRight && this.mRotaryOffsetX < -3 * this.mDimpleSpacing) {
                this.mRotaryOffsetX += this.mDimplesOfFling * this.mDimpleSpacing;
            } else if (goingRight && this.mRotaryOffsetX > 3 * this.mDimpleSpacing) {
                this.mRotaryOffsetX -= this.mDimplesOfFling * this.mDimpleSpacing;
            }
        }
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$reset() {
        this.mAnimating = false;
        this.mRotaryOffsetX = 0;
        this.mDimplesOfFling = 0;
        this.setGrabbedState(0);
        this.mTriggered = false;
    }

    private final synchronized void $$robo$$com_android_internal_widget_RotarySelector$vibrate(long duration) {
        boolean hapticEnabled;
        boolean bl = hapticEnabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 1, -2) != 0;
        if (hapticEnabled) {
            if (this.mVibrator == null) {
                this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(duration, VIBRATION_ATTRIBUTES);
        }
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$drawCentered(Bitmap d, Canvas c, int x, int y) {
        int w = d.getWidth();
        int h = d.getHeight();
        c.drawBitmap(d, x - w / 2, y - h / 2, this.mPaint);
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$setOnDialTriggerListener(OnDialTriggerListener l) {
        this.mOnDialTriggerListener = l;
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$dispatchTriggerEvent(int whichHandle) {
        this.vibrate(20L);
        if (this.mOnDialTriggerListener != null) {
            this.mOnDialTriggerListener.onDialTrigger(this, whichHandle);
        }
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$setGrabbedState(int newState) {
        if (newState != this.mGrabbedState) {
            this.mGrabbedState = newState;
            if (this.mOnDialTriggerListener != null) {
                this.mOnDialTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_RotarySelector$log(String msg) {
        Log.d("RotarySelector", msg);
    }

    static void __staticInitializer__() {
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_RotarySelector$__constructor__(context);
    }

    public RotarySelector(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RotarySelector$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_RotarySelector$__constructor__(context, attributeSet);
    }

    public RotarySelector(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_RotarySelector$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private Bitmap getBitmapFor(int n) {
        return InvokeDynamicSupport.bootstrap("getBitmapFor", $$robo$$com_android_internal_widget_RotarySelector$getBitmapFor(int ), 0, this, n);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$com_android_internal_widget_RotarySelector$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    private boolean isHoriz() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHoriz", $$robo$$com_android_internal_widget_RotarySelector$isHoriz(), 0, this);
    }

    public void setLeftHandleResource(int n) {
        InvokeDynamicSupport.bootstrap("setLeftHandleResource", $$robo$$com_android_internal_widget_RotarySelector$setLeftHandleResource(int ), 0, this, n);
    }

    public void setRightHandleResource(int n) {
        InvokeDynamicSupport.bootstrap("setRightHandleResource", $$robo$$com_android_internal_widget_RotarySelector$setRightHandleResource(int ), 0, this, n);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_RotarySelector$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_RotarySelector$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private int getYOnArc(int n, int n2, int n3, int n4) {
        return (int)InvokeDynamicSupport.bootstrap("getYOnArc", $$robo$$com_android_internal_widget_RotarySelector$getYOnArc(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_RotarySelector$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void startAnimation(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$com_android_internal_widget_RotarySelector$startAnimation(int int int ), 0, this, n, n2, n3);
    }

    private void startAnimationWithVelocity(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("startAnimationWithVelocity", $$robo$$com_android_internal_widget_RotarySelector$startAnimationWithVelocity(int int int ), 0, this, n, n2, n3);
    }

    private void updateAnimation() {
        InvokeDynamicSupport.bootstrap("updateAnimation", $$robo$$com_android_internal_widget_RotarySelector$updateAnimation(), 0, this);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_RotarySelector$reset(), 0, this);
    }

    private synchronized void vibrate(long l) {
        InvokeDynamicSupport.bootstrap("vibrate", $$robo$$com_android_internal_widget_RotarySelector$vibrate(long ), 0, this, l);
    }

    private void drawCentered(Bitmap bitmap, Canvas canvas, int n, int n2) {
        InvokeDynamicSupport.bootstrap("drawCentered", $$robo$$com_android_internal_widget_RotarySelector$drawCentered(android.graphics.Bitmap android.graphics.Canvas int int ), 0, this, bitmap, canvas, n, n2);
    }

    public void setOnDialTriggerListener(OnDialTriggerListener onDialTriggerListener) {
        InvokeDynamicSupport.bootstrap("setOnDialTriggerListener", $$robo$$com_android_internal_widget_RotarySelector$setOnDialTriggerListener(com.android.internal.widget.RotarySelector$OnDialTriggerListener ), 0, this, onDialTriggerListener);
    }

    private void dispatchTriggerEvent(int n) {
        InvokeDynamicSupport.bootstrap("dispatchTriggerEvent", $$robo$$com_android_internal_widget_RotarySelector$dispatchTriggerEvent(int ), 0, this, n);
    }

    private void setGrabbedState(int n) {
        InvokeDynamicSupport.bootstrap("setGrabbedState", $$robo$$com_android_internal_widget_RotarySelector$setGrabbedState(int ), 0, this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_widget_RotarySelector$log(java.lang.String ), 0, this, string2);
    }

    static {
        RobolectricInternals.classInitializing(RotarySelector.class);
    }

    public /* synthetic */ RotarySelector() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RotarySelector)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnDialTriggerListener
    extends InstrumentedInterface {
        public static final int LEFT_HANDLE = 1;
        public static final int RIGHT_HANDLE = 2;

        public void onDialTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);
    }
}

