/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.StateSet;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.RemoteViews;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class SizeAdaptiveLayout
extends ViewGroup
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SizeAdaptiveLayout";
    private static boolean DEBUG = false;
    private static boolean REPORT_BAD_BOUNDS = true;
    private static long CROSSFADE_TIME = 250L;
    private static int MIN_VALID_HEIGHT = 1;
    private static int MAX_VALID_HEIGHT = 0;
    private View mActiveChild;
    private View mLastActive;
    private AnimatorSet mTransitionAnimation;
    private Animator.AnimatorListener mAnimatorListener;
    private ObjectAnimator mFadePanel;
    private ObjectAnimator mFadeView;
    private int mCanceledAnimationCount;
    private View mEnteringView;
    private View mLeavingView;
    private View mModestyPanel;
    private int mModestyPanelTop;

    private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.initialize();
    }

    private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$initialize() {
        this.mModestyPanel = new View(this.getContext());
        Drawable background = this.getBackground();
        if (background instanceof StateListDrawable) {
            StateListDrawable sld = (StateListDrawable)background;
            sld.setState(StateSet.WILD_CARD);
            background = sld.getCurrent();
        }
        if (background instanceof ColorDrawable) {
            this.mModestyPanel.setBackgroundDrawable(background);
        }
        LayoutParams layout2 = new LayoutParams(-1, -1);
        this.mModestyPanel.setLayoutParams(layout2);
        this.addView(this.mModestyPanel);
        this.mFadePanel = ObjectAnimator.ofFloat((Object)this.mModestyPanel, "alpha", 0.0f);
        this.mFadeView = ObjectAnimator.ofFloat(null, "alpha", 0.0f);
        this.mAnimatorListener = new BringToFrontOnEnd(this);
        this.mTransitionAnimation = new AnimatorSet();
        this.mTransitionAnimation.play(this.mFadeView).with(this.mFadePanel);
        this.mTransitionAnimation.setDuration(250L);
        this.mTransitionAnimation.addListener(this.mAnimatorListener);
    }

    private final Animator $$robo$$com_android_internal_widget_SizeAdaptiveLayout$getTransitionAnimation() {
        return this.mTransitionAnimation;
    }

    private final View $$robo$$com_android_internal_widget_SizeAdaptiveLayout$getModestyPanel() {
        return this.mModestyPanel;
    }

    private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$onAttachedToWindow() {
        this.mLastActive = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).setVisibility(8);
        }
    }

    private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View model = this.selectActiveChild(heightMeasureSpec);
        if (model == null) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        LayoutParams lp = (LayoutParams)model.getLayoutParams();
        this.measureChild(model, widthMeasureSpec, heightMeasureSpec);
        int childHeight = model.getMeasuredHeight();
        int childWidth = model.getMeasuredHeight();
        int childState = SizeAdaptiveLayout.combineMeasuredStates(0, model.getMeasuredState());
        int resolvedWidth = SizeAdaptiveLayout.resolveSizeAndState(childWidth, widthMeasureSpec, childState);
        int resolvedHeight = SizeAdaptiveLayout.resolveSizeAndState(childHeight, heightMeasureSpec, childState);
        int boundedHeight = this.clampSizeToBounds(resolvedHeight, model);
        this.setMeasuredDimension(resolvedWidth, boundedHeight);
    }

    private final int $$robo$$com_android_internal_widget_SizeAdaptiveLayout$clampSizeToBounds(int measuredHeight, View child) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int heightIn = 0xFFFFFF & measuredHeight;
        int height = Math.max(heightIn, lp.minHeight);
        if (lp.maxHeight != -1) {
            height = Math.min(height, lp.maxHeight);
        }
        if (heightIn != height) {
            Log.d("SizeAdaptiveLayout", this + "child view " + child + " " + "measured out of bounds at " + heightIn + "px " + "clamped to " + height + "px");
        }
        return height;
    }

    private final View $$robo$$com_android_internal_widget_SizeAdaptiveLayout$selectActiveChild(int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        View unboundedView = null;
        View tallestView = null;
        int tallestViewSize = 0;
        View smallestView = null;
        int smallestViewSize = Integer.MAX_VALUE;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == this.mModestyPanel) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.maxHeight == -1 && unboundedView == null) {
                unboundedView = child;
            }
            if (lp.maxHeight > tallestViewSize) {
                tallestViewSize = lp.maxHeight;
                tallestView = child;
            }
            if (lp.minHeight < smallestViewSize) {
                smallestViewSize = lp.minHeight;
                smallestView = child;
            }
            if (heightMode == 0 || heightSize < lp.minHeight || heightSize > lp.maxHeight) continue;
            return child;
        }
        if (unboundedView != null) {
            tallestView = unboundedView;
        }
        if (heightMode == 0 || heightSize > tallestViewSize) {
            return tallestView;
        }
        return smallestView;
    }

    private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mLastActive = this.mActiveChild;
        int measureSpec = View.MeasureSpec.makeMeasureSpec(bottom - top, 0x40000000);
        this.mActiveChild = this.selectActiveChild(measureSpec);
        if (this.mActiveChild == null) {
            return;
        }
        this.mActiveChild.setVisibility(0);
        if (this.mLastActive != this.mActiveChild && this.mLastActive != null) {
            this.mEnteringView = this.mActiveChild;
            this.mLeavingView = this.mLastActive;
            this.mEnteringView.setAlpha(1.0f);
            this.mModestyPanel.setAlpha(1.0f);
            this.mModestyPanel.bringToFront();
            this.mModestyPanelTop = this.mLeavingView.getHeight();
            this.mModestyPanel.setVisibility(0);
            this.mLeavingView.bringToFront();
            if (this.mTransitionAnimation.isRunning()) {
                this.mTransitionAnimation.cancel();
            }
            this.mFadeView.setTarget(this.mLeavingView);
            this.mFadeView.setFloatValues(0.0f);
            this.mFadePanel.setFloatValues(0.0f);
            this.mTransitionAnimation.setupStartValues();
            this.mTransitionAnimation.start();
        }
        int childWidth = this.mActiveChild.getMeasuredWidth();
        int childHeight = this.mActiveChild.getMeasuredHeight();
        this.mActiveChild.layout(0, 0, childWidth, childHeight);
        this.mModestyPanel.layout(0, this.mModestyPanelTop, childWidth, this.mModestyPanelTop + childHeight);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_SizeAdaptiveLayout$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_SizeAdaptiveLayout$generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private final LayoutParams $$robo$$com_android_internal_widget_SizeAdaptiveLayout$generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    private final boolean $$robo$$com_android_internal_widget_SizeAdaptiveLayout$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(context);
    }

    public SizeAdaptiveLayout(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(context, attributeSet);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(context, attributeSet, n);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(context, attributeSet, n, n2);
    }

    public SizeAdaptiveLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initialize() {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$initialize(), 0, this);
    }

    public Animator getTransitionAnimation() {
        return InvokeDynamicSupport.bootstrap("getTransitionAnimation", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$getTransitionAnimation(), 0, this);
    }

    public View getModestyPanel() {
        return InvokeDynamicSupport.bootstrap("getModestyPanel", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$getModestyPanel(), 0, this);
    }

    @Override
    public void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$onMeasure(int int ), 0, this, n, n2);
    }

    private int clampSizeToBounds(int n, View view) {
        return (int)InvokeDynamicSupport.bootstrap("clampSizeToBounds", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$clampSizeToBounds(int android.view.View ), 0, this, n, view);
    }

    private View selectActiveChild(int n) {
        return InvokeDynamicSupport.bootstrap("selectActiveChild", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$selectActiveChild(int ), 0, this, n);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$com_android_internal_widget_SizeAdaptiveLayout$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    public /* synthetic */ SizeAdaptiveLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SizeAdaptiveLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class BringToFrontOnEnd
    implements Animator.AnimatorListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ boolean $assertionsDisabled;
        /* synthetic */ SizeAdaptiveLayout this$0;

        private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$__constructor__(SizeAdaptiveLayout sizeAdaptiveLayout) {
        }

        private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationEnd(Animator animation) {
            if (this.this$0.mCanceledAnimationCount == 0) {
                this.this$0.mLeavingView.setVisibility(8);
                this.this$0.mModestyPanel.setVisibility(8);
                this.this$0.mEnteringView.bringToFront();
                this.this$0.mEnteringView = null;
                this.this$0.mLeavingView = null;
            } else {
                this.this$0.mCanceledAnimationCount--;
            }
        }

        private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationCancel(Animator animation) {
            this.this$0.mCanceledAnimationCount++;
        }

        private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationRepeat(Animator animation) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        private final void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationStart(Animator animation) {
        }

        static void __staticInitializer__() {
            $assertionsDisabled = !SizeAdaptiveLayout.class.desiredAssertionStatus();
        }

        private void __constructor__(SizeAdaptiveLayout sizeAdaptiveLayout) {
            this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$__constructor__(sizeAdaptiveLayout);
        }

        BringToFrontOnEnd(SizeAdaptiveLayout sizeAdaptiveLayout) {
            this.this$0 = sizeAdaptiveLayout;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$__constructor__(com.android.internal.widget.SizeAdaptiveLayout ), 0, this, sizeAdaptiveLayout);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_BringToFrontOnEnd$onAnimationStart(android.animation.Animator ), 0, this, animator2);
        }

        static {
            RobolectricInternals.classInitializing(BringToFrontOnEnd.class);
        }

        public /* synthetic */ BringToFrontOnEnd() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BringToFrontOnEnd)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty(category="layout")
        public int minHeight;
        @ViewDebug.ExportedProperty(category="layout")
        public int maxHeight;
        public static int UNBOUNDED = -1;

        private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.SizeAdaptiveLayout_Layout);
            this.minHeight = a.getDimensionPixelSize(1, 0);
            try {
                this.maxHeight = a.getLayoutDimension(0, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            a.recycle();
        }

        private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(int width, int height, int minHeight, int maxHeight) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(int width, int height) {
        }

        private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__() {
        }

        private void $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(ViewGroup.LayoutParams p) {
            this.minHeight = -1;
            this.maxHeight = -1;
        }

        private final String $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$debug(String output) {
            return output + "SizeAdaptiveLayout.LayoutParams={" + ", max=" + this.maxHeight + ", max=" + this.minHeight + "}";
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2, int n3, int n4) {
            this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(n, n2, n3, n4);
        }

        public LayoutParams(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(int int int int ), 0, this, n, n2, n3, n4);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            this(n, n2, -1, -1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__();
        }

        public LayoutParams() {
            this(0, 0);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(), 0, this);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        @Override
        public String debug(String string2) {
            return InvokeDynamicSupport.bootstrap("debug", $$robo$$com_android_internal_widget_SizeAdaptiveLayout_LayoutParams$debug(java.lang.String ), 0, this, string2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

