/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SwipeDismissLayout
extends FrameLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SwipeDismissLayout";
    private static float DISMISS_MIN_DRAG_WIDTH_RATIO = 0.33f;
    private int mSlop;
    private int mMinFlingVelocity;
    private int mMaxFlingVelocity;
    private long mAnimationTime;
    private TimeInterpolator mCancelInterpolator;
    private TimeInterpolator mDismissInterpolator;
    private int mActiveTouchId;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private boolean mDismissed;
    private boolean mDiscardIntercept;
    private VelocityTracker mVelocityTracker;
    private float mTranslationX;
    private OnDismissedListener mDismissedListener;
    private OnSwipeProgressChangedListener mProgressListener;
    private float mLastX;

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context) {
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context, AttributeSet attrs) {
        this.init(context);
    }

    private void $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.init(context);
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$init(Context context) {
        ViewConfiguration vc = ViewConfiguration.get(this.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = this.getContext().getResources().getInteger(0x10E0000);
        this.mCancelInterpolator = new DecelerateInterpolator(1.5f);
        this.mDismissInterpolator = new AccelerateInterpolator(1.5f);
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnDismissedListener(OnDismissedListener listener) {
        this.mDismissedListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener listener) {
        this.mProgressListener = listener;
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$onInterceptTouchEvent(MotionEvent ev) {
        ev.offsetLocation(this.mTranslationX, 0.0f);
        switch (ev.getActionMasked()) {
            case 0: {
                this.resetMembers();
                this.mDownX = ev.getRawX();
                this.mDownY = ev.getRawY();
                this.mActiveTouchId = ev.getPointerId(0);
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 5: {
                int actionIndex = ev.getActionIndex();
                this.mActiveTouchId = ev.getPointerId(actionIndex);
                break;
            }
            case 6: {
                int actionIndex = ev.getActionIndex();
                int pointerId = ev.getPointerId(actionIndex);
                if (pointerId != this.mActiveTouchId) break;
                int newActionIndex = actionIndex == 0 ? 1 : 0;
                this.mActiveTouchId = ev.getPointerId(newActionIndex);
                break;
            }
            case 1: 
            case 3: {
                this.resetMembers();
                break;
            }
            case 2: {
                if (this.mVelocityTracker == null || this.mDiscardIntercept) break;
                int pointerIndex = ev.findPointerIndex(this.mActiveTouchId);
                if (pointerIndex == -1) {
                    Log.e("SwipeDismissLayout", "Invalid pointer index: ignoring.");
                    this.mDiscardIntercept = true;
                    break;
                }
                float dx = ev.getRawX() - this.mDownX;
                float x = ev.getX(pointerIndex);
                float y = ev.getY(pointerIndex);
                if (dx != 0.0f && this.canScroll(this, false, dx, x, y)) {
                    this.mDiscardIntercept = true;
                    break;
                }
                this.updateSwiping(ev);
            }
        }
        return !this.mDiscardIntercept && this.mSwiping;
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$onTouchEvent(MotionEvent ev) {
        if (this.mVelocityTracker == null) {
            return super.onTouchEvent(ev);
        }
        switch (ev.getActionMasked()) {
            case 1: {
                this.updateDismiss(ev);
                if (this.mDismissed) {
                    this.dismiss();
                } else if (this.mSwiping) {
                    this.cancel();
                }
                this.resetMembers();
                break;
            }
            case 3: {
                this.cancel();
                this.resetMembers();
                break;
            }
            case 2: {
                this.mVelocityTracker.addMovement(ev);
                this.mLastX = ev.getRawX();
                this.updateSwiping(ev);
                if (!this.mSwiping) break;
                this.setProgress(ev.getRawX() - this.mDownX);
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$setProgress(float deltaX) {
        this.mTranslationX = deltaX;
        if (this.mProgressListener != null && deltaX >= 0.0f) {
            this.mProgressListener.onSwipeProgressChanged(this, deltaX / (float)this.getWidth(), deltaX);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$dismiss() {
        if (this.mDismissedListener != null) {
            this.mDismissedListener.onDismissed(this);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$cancel() {
        if (this.mProgressListener != null) {
            this.mProgressListener.onSwipeCancelled(this);
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$resetMembers() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = null;
        this.mTranslationX = 0.0f;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mSwiping = false;
        this.mDismissed = false;
        this.mDiscardIntercept = false;
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$updateSwiping(MotionEvent ev) {
        if (!this.mSwiping) {
            float deltaY;
            float deltaX = ev.getRawX() - this.mDownX;
            this.mSwiping = deltaX * deltaX + (deltaY = ev.getRawY() - this.mDownY) * deltaY > (float)(this.mSlop * this.mSlop) ? deltaX > (float)(this.mSlop * 2) && Math.abs(deltaY) < (float)(this.mSlop * 2) : false;
        }
    }

    private final void $$robo$$com_android_internal_widget_SwipeDismissLayout$updateDismiss(MotionEvent ev) {
        float deltaX = ev.getRawX() - this.mDownX;
        if (!this.mDismissed) {
            this.mVelocityTracker.addMovement(ev);
            this.mVelocityTracker.computeCurrentVelocity(1000);
            if (deltaX > (float)this.getWidth() * 0.33f && ev.getRawX() >= this.mLastX) {
                this.mDismissed = true;
            }
        }
        if (this.mDismissed && this.mSwiping && deltaX < (float)this.getWidth() * 0.33f) {
            this.mDismissed = false;
        }
    }

    private final boolean $$robo$$com_android_internal_widget_SwipeDismissLayout$canScroll(View v, boolean checkV, float dx, float x, float y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (!(x + (float)scrollX >= (float)child.getLeft()) || !(x + (float)scrollX < (float)child.getRight()) || !(y + (float)scrollY >= (float)child.getTop()) || !(y + (float)scrollY < (float)child.getBottom()) || !this.canScroll(child, true, dx, x + (float)scrollX - (float)child.getLeft(), y + (float)scrollY - (float)child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally((int)(-dx));
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context);
    }

    public SwipeDismissLayout(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context, attributeSet);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(context, attributeSet, n);
    }

    public SwipeDismissLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_SwipeDismissLayout$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void init(Context context) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$com_android_internal_widget_SwipeDismissLayout$init(android.content.Context ), 0, this, context);
    }

    public void setOnDismissedListener(OnDismissedListener onDismissedListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissedListener", $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnDismissedListener(com.android.internal.widget.SwipeDismissLayout$OnDismissedListener ), 0, this, onDismissedListener);
    }

    public void setOnSwipeProgressChangedListener(OnSwipeProgressChangedListener onSwipeProgressChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnSwipeProgressChangedListener", $$robo$$com_android_internal_widget_SwipeDismissLayout$setOnSwipeProgressChangedListener(com.android.internal.widget.SwipeDismissLayout$OnSwipeProgressChangedListener ), 0, this, onSwipeProgressChangedListener);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_SwipeDismissLayout$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_SwipeDismissLayout$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void setProgress(float f) {
        InvokeDynamicSupport.bootstrap("setProgress", $$robo$$com_android_internal_widget_SwipeDismissLayout$setProgress(float ), 0, this, f);
    }

    private void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_widget_SwipeDismissLayout$dismiss(), 0, this);
    }

    protected void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_widget_SwipeDismissLayout$cancel(), 0, this);
    }

    private void resetMembers() {
        InvokeDynamicSupport.bootstrap("resetMembers", $$robo$$com_android_internal_widget_SwipeDismissLayout$resetMembers(), 0, this);
    }

    private void updateSwiping(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("updateSwiping", $$robo$$com_android_internal_widget_SwipeDismissLayout$updateSwiping(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void updateDismiss(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("updateDismiss", $$robo$$com_android_internal_widget_SwipeDismissLayout$updateDismiss(android.view.MotionEvent ), 0, this, motionEvent);
    }

    protected boolean canScroll(View view, boolean bl, float f, float f2, float f3) {
        return (boolean)InvokeDynamicSupport.bootstrap("canScroll", $$robo$$com_android_internal_widget_SwipeDismissLayout$canScroll(android.view.View boolean float float float ), 0, this, view, bl, f, f2, f3);
    }

    public /* synthetic */ SwipeDismissLayout() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SwipeDismissLayout)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnSwipeProgressChangedListener
    extends InstrumentedInterface {
        public void onSwipeProgressChanged(SwipeDismissLayout var1, float var2, float var3);

        public void onSwipeCancelled(SwipeDismissLayout var1);
    }

    public static interface OnDismissedListener
    extends InstrumentedInterface {
        public void onDismissed(SwipeDismissLayout var1);
    }
}

