/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.media.AudioAttributes;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.widget.DrawableHolder;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WaveView
extends View
implements ValueAnimator.AnimatorUpdateListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WaveView";
    private static boolean DBG = false;
    private static int WAVE_COUNT = 20;
    private static long VIBRATE_SHORT = 20L;
    private static long VIBRATE_LONG = 20L;
    private static int STATE_RESET_LOCK = 0;
    private static int STATE_READY = 1;
    private static int STATE_START_ATTEMPT = 2;
    private static int STATE_ATTEMPTING = 3;
    private static int STATE_UNLOCK_ATTEMPT = 4;
    private static int STATE_UNLOCK_SUCCESS = 5;
    private static long DURATION = 300L;
    private static long FINAL_DURATION = 200L;
    private static long RING_DELAY = 1300L;
    private static long FINAL_DELAY = 200L;
    private static long SHORT_DELAY = 100L;
    private static long WAVE_DURATION = 2000L;
    private static long RESET_TIMEOUT = 3000L;
    private static long DELAY_INCREMENT = 15L;
    private static long DELAY_INCREMENT2 = 12L;
    private static long WAVE_DELAY = 100L;
    private static float GRAB_HANDLE_RADIUS_SCALE_ACCESSIBILITY_DISABLED = 0.5f;
    private static float GRAB_HANDLE_RADIUS_SCALE_ACCESSIBILITY_ENABLED = 1.0f;
    private static AudioAttributes VIBRATION_ATTRIBUTES;
    private Vibrator mVibrator;
    private OnTriggerListener mOnTriggerListener;
    private ArrayList<DrawableHolder> mDrawables;
    private ArrayList<DrawableHolder> mLightWaves;
    private boolean mFingerDown;
    private float mRingRadius;
    private int mSnapRadius;
    private int mWaveCount;
    private long mWaveTimerDelay;
    private int mCurrentWave;
    private float mLockCenterX;
    private float mLockCenterY;
    private float mMouseX;
    private float mMouseY;
    private DrawableHolder mUnlockRing;
    private DrawableHolder mUnlockDefault;
    private DrawableHolder mUnlockHalo;
    private int mLockState;
    private int mGrabbedState;
    private boolean mWavesRunning;
    private boolean mFinishWaves;
    private Runnable mLockTimerActions;
    private Runnable mAddWaveAction;

    private void $$robo$$com_android_internal_widget_WaveView$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_WaveView$__constructor__(Context context, AttributeSet attrs) {
        this.mDrawables = new ArrayList(3);
        this.mLightWaves = new ArrayList(20);
        this.mFingerDown = false;
        this.mRingRadius = 182.0f;
        this.mSnapRadius = 136;
        this.mWaveCount = 20;
        this.mWaveTimerDelay = 100L;
        this.mCurrentWave = 0;
        this.mLockState = 0;
        this.mGrabbedState = 0;
        this.mLockTimerActions = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ WaveView this$0;

            private void $$robo$$com_android_internal_widget_WaveView_1$__constructor__(WaveView waveView) {
            }

            private final void $$robo$$com_android_internal_widget_WaveView_1$run() {
                if (this.this$0.mLockState == 3) {
                    this.this$0.mLockState = 0;
                }
                if (this.this$0.mLockState == 5) {
                    this.this$0.mLockState = 0;
                }
                this.this$0.invalidate();
            }

            private void __constructor__(WaveView waveView) {
                this.$$robo$$com_android_internal_widget_WaveView_1$__constructor__(waveView);
            }
            {
                this.this$0 = waveView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_WaveView_1$__constructor__(com.android.internal.widget.WaveView ), 0, this, waveView);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_WaveView_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAddWaveAction = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ WaveView this$0;

            private void $$robo$$com_android_internal_widget_WaveView_2$__constructor__(WaveView waveView) {
            }

            private final void $$robo$$com_android_internal_widget_WaveView_2$run() {
                double distX = this.this$0.mMouseX - this.this$0.mLockCenterX;
                double distY = this.this$0.mMouseY - this.this$0.mLockCenterY;
                int dragDistance = (int)Math.ceil(Math.hypot(distX, distY));
                if (this.this$0.mLockState == 3 && dragDistance < this.this$0.mSnapRadius && this.this$0.mWaveTimerDelay >= 100L) {
                    this.this$0.mWaveTimerDelay = Math.min(2000L, this.this$0.mWaveTimerDelay + 15L);
                    DrawableHolder wave = (DrawableHolder)this.this$0.mLightWaves.get(this.this$0.mCurrentWave);
                    wave.setAlpha(0.0f);
                    wave.setScaleX(0.2f);
                    wave.setScaleY(0.2f);
                    wave.setX(this.this$0.mMouseX);
                    wave.setY(this.this$0.mMouseY);
                    wave.addAnimTo(2000L, 0L, "x", this.this$0.mLockCenterX, true);
                    wave.addAnimTo(2000L, 0L, "y", this.this$0.mLockCenterY, true);
                    wave.addAnimTo(1333L, 0L, "alpha", 1.0f, true);
                    wave.addAnimTo(2000L, 0L, "scaleX", 1.0f, true);
                    wave.addAnimTo(2000L, 0L, "scaleY", 1.0f, true);
                    wave.addAnimTo(1000L, 1300L, "alpha", 0.0f, false);
                    wave.startAnimations(this.this$0);
                    this.this$0.mCurrentWave = (this.this$0.mCurrentWave + 1) % this.this$0.mWaveCount;
                } else {
                    this.this$0.mWaveTimerDelay += 12L;
                }
                if (this.this$0.mFinishWaves) {
                    this.this$0.mWavesRunning = false;
                } else {
                    this.this$0.postDelayed(this.this$0.mAddWaveAction, this.this$0.mWaveTimerDelay);
                }
            }

            private void __constructor__(WaveView waveView) {
                this.$$robo$$com_android_internal_widget_WaveView_2$__constructor__(waveView);
            }
            {
                this.this$0 = waveView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_WaveView_2$__constructor__(com.android.internal.widget.WaveView ), 0, this, waveView);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_WaveView_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.initDrawables();
    }

    private final void $$robo$$com_android_internal_widget_WaveView$onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mLockCenterX = 0.5f * (float)w;
        this.mLockCenterY = 0.5f * (float)h;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private final int $$robo$$com_android_internal_widget_WaveView$getSuggestedMinimumWidth() {
        return this.mUnlockRing.getWidth() + this.mUnlockHalo.getWidth();
    }

    private final int $$robo$$com_android_internal_widget_WaveView$getSuggestedMinimumHeight() {
        return this.mUnlockRing.getHeight() + this.mUnlockHalo.getHeight();
    }

    private final void $$robo$$com_android_internal_widget_WaveView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int width = widthSpecMode == Integer.MIN_VALUE ? Math.min(widthSpecSize, this.getSuggestedMinimumWidth()) : (widthSpecMode == 0x40000000 ? widthSpecSize : this.getSuggestedMinimumWidth());
        int height = heightSpecMode == Integer.MIN_VALUE ? Math.min(heightSpecSize, this.getSuggestedMinimumWidth()) : (heightSpecMode == 0x40000000 ? heightSpecSize : this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(width, height);
    }

    private final void $$robo$$com_android_internal_widget_WaveView$initDrawables() {
        this.mUnlockRing = new DrawableHolder(this.createDrawable(17303374));
        this.mUnlockRing.setX(this.mLockCenterX);
        this.mUnlockRing.setY(this.mLockCenterY);
        this.mUnlockRing.setScaleX(0.1f);
        this.mUnlockRing.setScaleY(0.1f);
        this.mUnlockRing.setAlpha(0.0f);
        this.mDrawables.add(this.mUnlockRing);
        this.mUnlockDefault = new DrawableHolder(this.createDrawable(17303372));
        this.mUnlockDefault.setX(this.mLockCenterX);
        this.mUnlockDefault.setY(this.mLockCenterY);
        this.mUnlockDefault.setScaleX(0.1f);
        this.mUnlockDefault.setScaleY(0.1f);
        this.mUnlockDefault.setAlpha(0.0f);
        this.mDrawables.add(this.mUnlockDefault);
        this.mUnlockHalo = new DrawableHolder(this.createDrawable(17303373));
        this.mUnlockHalo.setX(this.mLockCenterX);
        this.mUnlockHalo.setY(this.mLockCenterY);
        this.mUnlockHalo.setScaleX(0.1f);
        this.mUnlockHalo.setScaleY(0.1f);
        this.mUnlockHalo.setAlpha(0.0f);
        this.mDrawables.add(this.mUnlockHalo);
        BitmapDrawable wave = this.createDrawable(17303375);
        for (int i = 0; i < this.mWaveCount; ++i) {
            DrawableHolder holder = new DrawableHolder(wave);
            this.mLightWaves.add(holder);
            holder.setAlpha(0.0f);
        }
    }

    private final void $$robo$$com_android_internal_widget_WaveView$waveUpdateFrame(float mouseX, float mouseY, boolean fingerDown) {
        double distX = mouseX - this.mLockCenterX;
        double distY = mouseY - this.mLockCenterY;
        int dragDistance = (int)Math.ceil(Math.hypot(distX, distY));
        double touchA = Math.atan2(distX, distY);
        float ringX = (float)((double)this.mLockCenterX + (double)this.mRingRadius * Math.sin(touchA));
        float ringY = (float)((double)this.mLockCenterY + (double)this.mRingRadius * Math.cos(touchA));
        switch (this.mLockState) {
            case 0: {
                int i;
                this.mWaveTimerDelay = 100L;
                for (i = 0; i < this.mLightWaves.size(); ++i) {
                    DrawableHolder holder = this.mLightWaves.get(i);
                    holder.addAnimTo(300L, 0L, "alpha", 0.0f, false);
                }
                for (i = 0; i < this.mLightWaves.size(); ++i) {
                    this.mLightWaves.get(i).startAnimations(this);
                }
                this.mUnlockRing.addAnimTo(300L, 0L, "x", this.mLockCenterX, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "y", this.mLockCenterY, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleX", 0.1f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleY", 0.1f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "alpha", 0.0f, true);
                this.mUnlockDefault.removeAnimationFor("x");
                this.mUnlockDefault.removeAnimationFor("y");
                this.mUnlockDefault.removeAnimationFor("scaleX");
                this.mUnlockDefault.removeAnimationFor("scaleY");
                this.mUnlockDefault.removeAnimationFor("alpha");
                this.mUnlockDefault.setX(this.mLockCenterX);
                this.mUnlockDefault.setY(this.mLockCenterY);
                this.mUnlockDefault.setScaleX(0.1f);
                this.mUnlockDefault.setScaleY(0.1f);
                this.mUnlockDefault.setAlpha(0.0f);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleX", 1.0f, true);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleY", 1.0f, true);
                this.mUnlockDefault.addAnimTo(300L, 100L, "alpha", 1.0f, true);
                this.mUnlockHalo.removeAnimationFor("x");
                this.mUnlockHalo.removeAnimationFor("y");
                this.mUnlockHalo.removeAnimationFor("scaleX");
                this.mUnlockHalo.removeAnimationFor("scaleY");
                this.mUnlockHalo.removeAnimationFor("alpha");
                this.mUnlockHalo.setX(this.mLockCenterX);
                this.mUnlockHalo.setY(this.mLockCenterY);
                this.mUnlockHalo.setScaleX(0.1f);
                this.mUnlockHalo.setScaleY(0.1f);
                this.mUnlockHalo.setAlpha(0.0f);
                this.mUnlockHalo.addAnimTo(300L, 100L, "x", this.mLockCenterX, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "y", this.mLockCenterY, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "scaleX", 1.0f, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "scaleY", 1.0f, true);
                this.mUnlockHalo.addAnimTo(300L, 100L, "alpha", 1.0f, true);
                this.removeCallbacks(this.mLockTimerActions);
                this.mLockState = 1;
                break;
            }
            case 1: {
                this.mWaveTimerDelay = 100L;
                break;
            }
            case 2: {
                this.mUnlockDefault.removeAnimationFor("x");
                this.mUnlockDefault.removeAnimationFor("y");
                this.mUnlockDefault.removeAnimationFor("scaleX");
                this.mUnlockDefault.removeAnimationFor("scaleY");
                this.mUnlockDefault.removeAnimationFor("alpha");
                this.mUnlockDefault.setX(this.mLockCenterX + 182.0f);
                this.mUnlockDefault.setY(this.mLockCenterY);
                this.mUnlockDefault.setScaleX(0.1f);
                this.mUnlockDefault.setScaleY(0.1f);
                this.mUnlockDefault.setAlpha(0.0f);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleX", 1.0f, false);
                this.mUnlockDefault.addAnimTo(300L, 100L, "scaleY", 1.0f, false);
                this.mUnlockDefault.addAnimTo(300L, 100L, "alpha", 1.0f, false);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleX", 1.0f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "scaleY", 1.0f, true);
                this.mUnlockRing.addAnimTo(300L, 0L, "alpha", 1.0f, true);
                this.mLockState = 3;
                break;
            }
            case 3: {
                if (dragDistance > this.mSnapRadius) {
                    this.mFinishWaves = true;
                    if (fingerDown) {
                        this.mUnlockHalo.addAnimTo(0L, 0L, "x", ringX, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "y", ringY, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "scaleX", 1.0f, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "scaleY", 1.0f, true);
                        this.mUnlockHalo.addAnimTo(0L, 0L, "alpha", 1.0f, true);
                        break;
                    }
                    this.mLockState = 4;
                    break;
                }
                if (!this.mWavesRunning) {
                    this.mWavesRunning = true;
                    this.mFinishWaves = false;
                    this.postDelayed(this.mAddWaveAction, this.mWaveTimerDelay);
                }
                this.mUnlockHalo.addAnimTo(0L, 0L, "x", mouseX, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "y", mouseY, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "scaleX", 1.0f, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "scaleY", 1.0f, true);
                this.mUnlockHalo.addAnimTo(0L, 0L, "alpha", 1.0f, true);
                break;
            }
            case 4: {
                if (dragDistance > this.mSnapRadius) {
                    for (int n = 0; n < this.mLightWaves.size(); ++n) {
                        DrawableHolder wave = this.mLightWaves.get(n);
                        long delay = 1000L * (long)(6 + n - this.mCurrentWave) / 10L;
                        wave.addAnimTo(200L, delay, "x", ringX, true);
                        wave.addAnimTo(200L, delay, "y", ringY, true);
                        wave.addAnimTo(200L, delay, "scaleX", 0.1f, true);
                        wave.addAnimTo(200L, delay, "scaleY", 0.1f, true);
                        wave.addAnimTo(200L, delay, "alpha", 0.0f, true);
                    }
                    for (int i = 0; i < this.mLightWaves.size(); ++i) {
                        this.mLightWaves.get(i).startAnimations(this);
                    }
                    this.mUnlockRing.addAnimTo(200L, 0L, "x", ringX, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "y", ringY, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "scaleX", 0.1f, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "scaleY", 0.1f, false);
                    this.mUnlockRing.addAnimTo(200L, 0L, "alpha", 0.0f, false);
                    this.mUnlockRing.addAnimTo(200L, 200L, "alpha", 0.0f, false);
                    this.mUnlockDefault.removeAnimationFor("x");
                    this.mUnlockDefault.removeAnimationFor("y");
                    this.mUnlockDefault.removeAnimationFor("scaleX");
                    this.mUnlockDefault.removeAnimationFor("scaleY");
                    this.mUnlockDefault.removeAnimationFor("alpha");
                    this.mUnlockDefault.setX(ringX);
                    this.mUnlockDefault.setY(ringY);
                    this.mUnlockDefault.setScaleX(0.1f);
                    this.mUnlockDefault.setScaleY(0.1f);
                    this.mUnlockDefault.setAlpha(0.0f);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "x", ringX, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "y", ringY, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "scaleX", 1.0f, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "scaleY", 1.0f, true);
                    this.mUnlockDefault.addAnimTo(200L, 0L, "alpha", 1.0f, true);
                    this.mUnlockDefault.addAnimTo(200L, 200L, "scaleX", 3.0f, false);
                    this.mUnlockDefault.addAnimTo(200L, 200L, "scaleY", 3.0f, false);
                    this.mUnlockDefault.addAnimTo(200L, 200L, "alpha", 0.0f, false);
                    this.mUnlockHalo.addAnimTo(200L, 0L, "x", ringX, false);
                    this.mUnlockHalo.addAnimTo(200L, 0L, "y", ringY, false);
                    this.mUnlockHalo.addAnimTo(200L, 200L, "scaleX", 3.0f, false);
                    this.mUnlockHalo.addAnimTo(200L, 200L, "scaleY", 3.0f, false);
                    this.mUnlockHalo.addAnimTo(200L, 200L, "alpha", 0.0f, false);
                    this.removeCallbacks(this.mLockTimerActions);
                    this.postDelayed(this.mLockTimerActions, 3000L);
                    this.dispatchTriggerEvent(10);
                    this.mLockState = 5;
                    break;
                }
                this.mLockState = 0;
                break;
            }
            case 5: {
                this.removeCallbacks(this.mAddWaveAction);
                break;
            }
        }
        this.mUnlockDefault.startAnimations(this);
        this.mUnlockHalo.startAnimations(this);
        this.mUnlockRing.startAnimations(this);
    }

    private final BitmapDrawable $$robo$$com_android_internal_widget_WaveView$createDrawable(int resId) {
        Resources res = this.getResources();
        Bitmap bitmap = BitmapFactory.decodeResource(res, resId);
        return new BitmapDrawable(res, bitmap);
    }

    private final void $$robo$$com_android_internal_widget_WaveView$onDraw(Canvas canvas) {
        int i;
        this.waveUpdateFrame(this.mMouseX, this.mMouseY, this.mFingerDown);
        for (i = 0; i < this.mDrawables.size(); ++i) {
            this.mDrawables.get(i).draw(canvas);
        }
        for (i = 0; i < this.mLightWaves.size(); ++i) {
            this.mLightWaves.get(i).draw(canvas);
        }
    }

    private final boolean $$robo$$com_android_internal_widget_WaveView$onHoverEvent(MotionEvent event) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            this.onTouchEvent(event);
            event.setAction(action);
        }
        return super.onHoverEvent(event);
    }

    private final boolean $$robo$$com_android_internal_widget_WaveView$onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        this.mMouseX = event.getX();
        this.mMouseY = event.getY();
        boolean handled = false;
        switch (action) {
            case 0: {
                this.removeCallbacks(this.mLockTimerActions);
                this.mFingerDown = true;
                this.tryTransitionToStartAttemptState(event);
                handled = true;
                break;
            }
            case 2: {
                this.tryTransitionToStartAttemptState(event);
                handled = true;
                break;
            }
            case 1: {
                this.mFingerDown = false;
                this.postDelayed(this.mLockTimerActions, 3000L);
                this.setGrabbedState(0);
                this.waveUpdateFrame(this.mMouseX, this.mMouseY, this.mFingerDown);
                handled = true;
                break;
            }
            case 3: {
                this.mFingerDown = false;
                handled = true;
            }
        }
        this.invalidate();
        return handled ? true : super.onTouchEvent(event);
    }

    private final void $$robo$$com_android_internal_widget_WaveView$tryTransitionToStartAttemptState(MotionEvent event) {
        float dy;
        float dx = event.getX() - this.mUnlockHalo.getX();
        float dist = (float)Math.hypot(dx, dy = event.getY() - this.mUnlockHalo.getY());
        if (dist <= this.getScaledGrabHandleRadius()) {
            this.setGrabbedState(10);
            if (this.mLockState == 1) {
                this.mLockState = 2;
                if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                    this.announceUnlockHandle();
                }
            }
        }
    }

    private final float $$robo$$com_android_internal_widget_WaveView$getScaledGrabHandleRadius() {
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return 1.0f * (float)this.mUnlockHalo.getWidth();
        }
        return 0.5f * (float)this.mUnlockHalo.getWidth();
    }

    private final void $$robo$$com_android_internal_widget_WaveView$announceUnlockHandle() {
        this.setContentDescription(this.mContext.getString(17040775));
        this.sendAccessibilityEvent(8);
        this.setContentDescription(null);
    }

    private final synchronized void $$robo$$com_android_internal_widget_WaveView$vibrate(long duration) {
        boolean hapticEnabled;
        boolean bl = hapticEnabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 1, -2) != 0;
        if (hapticEnabled) {
            if (this.mVibrator == null) {
                this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
            }
            this.mVibrator.vibrate(duration, VIBRATION_ATTRIBUTES);
        }
    }

    private final void $$robo$$com_android_internal_widget_WaveView$setOnTriggerListener(OnTriggerListener listener) {
        this.mOnTriggerListener = listener;
    }

    private final void $$robo$$com_android_internal_widget_WaveView$dispatchTriggerEvent(int whichHandle) {
        this.vibrate(20L);
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, whichHandle);
        }
    }

    private final void $$robo$$com_android_internal_widget_WaveView$setGrabbedState(int newState) {
        if (newState != this.mGrabbedState) {
            this.mGrabbedState = newState;
            if (this.mOnTriggerListener != null) {
                this.mOnTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_WaveView$onAnimationUpdate(ValueAnimator animation) {
        this.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_WaveView$reset() {
        this.mLockState = 0;
        this.invalidate();
    }

    static void __staticInitializer__() {
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_WaveView$__constructor__(context);
    }

    public WaveView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_WaveView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_WaveView$__constructor__(context, attributeSet);
    }

    public WaveView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_WaveView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$com_android_internal_widget_WaveView$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    protected int getSuggestedMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getSuggestedMinimumWidth", $$robo$$com_android_internal_widget_WaveView$getSuggestedMinimumWidth(), 0, this);
    }

    @Override
    protected int getSuggestedMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getSuggestedMinimumHeight", $$robo$$com_android_internal_widget_WaveView$getSuggestedMinimumHeight(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_WaveView$onMeasure(int int ), 0, this, n, n2);
    }

    private void initDrawables() {
        InvokeDynamicSupport.bootstrap("initDrawables", $$robo$$com_android_internal_widget_WaveView$initDrawables(), 0, this);
    }

    private void waveUpdateFrame(float f, float f2, boolean bl) {
        InvokeDynamicSupport.bootstrap("waveUpdateFrame", $$robo$$com_android_internal_widget_WaveView$waveUpdateFrame(float float boolean ), 0, this, f, f2, bl);
    }

    BitmapDrawable createDrawable(int n) {
        return InvokeDynamicSupport.bootstrap("createDrawable", $$robo$$com_android_internal_widget_WaveView$createDrawable(int ), 0, this, n);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_WaveView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onHoverEvent", $$robo$$com_android_internal_widget_WaveView$onHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_WaveView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void tryTransitionToStartAttemptState(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("tryTransitionToStartAttemptState", $$robo$$com_android_internal_widget_WaveView$tryTransitionToStartAttemptState(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private float getScaledGrabHandleRadius() {
        return (float)InvokeDynamicSupport.bootstrap("getScaledGrabHandleRadius", $$robo$$com_android_internal_widget_WaveView$getScaledGrabHandleRadius(), 0, this);
    }

    private void announceUnlockHandle() {
        InvokeDynamicSupport.bootstrap("announceUnlockHandle", $$robo$$com_android_internal_widget_WaveView$announceUnlockHandle(), 0, this);
    }

    private synchronized void vibrate(long l) {
        InvokeDynamicSupport.bootstrap("vibrate", $$robo$$com_android_internal_widget_WaveView$vibrate(long ), 0, this, l);
    }

    public void setOnTriggerListener(OnTriggerListener onTriggerListener) {
        InvokeDynamicSupport.bootstrap("setOnTriggerListener", $$robo$$com_android_internal_widget_WaveView$setOnTriggerListener(com.android.internal.widget.WaveView$OnTriggerListener ), 0, this, onTriggerListener);
    }

    private void dispatchTriggerEvent(int n) {
        InvokeDynamicSupport.bootstrap("dispatchTriggerEvent", $$robo$$com_android_internal_widget_WaveView$dispatchTriggerEvent(int ), 0, this, n);
    }

    private void setGrabbedState(int n) {
        InvokeDynamicSupport.bootstrap("setGrabbedState", $$robo$$com_android_internal_widget_WaveView$setGrabbedState(int ), 0, this, n);
    }

    @Override
    public void onAnimationUpdate(ValueAnimator valueAnimator) {
        InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_widget_WaveView$onAnimationUpdate(android.animation.ValueAnimator ), 0, this, valueAnimator);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_WaveView$reset(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WaveView.class);
    }

    public /* synthetic */ WaveView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaveView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnTriggerListener
    extends InstrumentedInterface {
        public static final int NO_HANDLE = 0;
        public static final int CENTER_HANDLE = 10;

        public void onTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);
    }
}

