/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.os.Bundle;
import android.os.Vibrator;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.R;
import com.android.internal.widget.multiwaveview.Ease;
import com.android.internal.widget.multiwaveview.PointCloud;
import com.android.internal.widget.multiwaveview.TargetDrawable;
import com.android.internal.widget.multiwaveview.Tweener;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GlowPadView
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GlowPadView";
    private static boolean DEBUG = false;
    private static int STATE_IDLE = 0;
    private static int STATE_START = 1;
    private static int STATE_FIRST_TOUCH = 2;
    private static int STATE_TRACKING = 3;
    private static int STATE_SNAP = 4;
    private static int STATE_FINISH = 5;
    private static float SNAP_MARGIN_DEFAULT = 20.0f;
    private static int WAVE_ANIMATION_DURATION = 1000;
    private static int RETURN_TO_HOME_DELAY = 1200;
    private static int RETURN_TO_HOME_DURATION = 200;
    private static int HIDE_ANIMATION_DELAY = 200;
    private static int HIDE_ANIMATION_DURATION = 200;
    private static int SHOW_ANIMATION_DURATION = 200;
    private static int SHOW_ANIMATION_DELAY = 50;
    private static int INITIAL_SHOW_HANDLE_DURATION = 200;
    private static int REVEAL_GLOW_DELAY = 0;
    private static int REVEAL_GLOW_DURATION = 0;
    private static float TAP_RADIUS_SCALE_ACCESSIBILITY_ENABLED = 1.3f;
    private static float TARGET_SCALE_EXPANDED = 1.0f;
    private static float TARGET_SCALE_COLLAPSED = 0.8f;
    private static float RING_SCALE_EXPANDED = 1.0f;
    private static float RING_SCALE_COLLAPSED = 0.5f;
    private static AudioAttributes VIBRATION_ATTRIBUTES;
    private ArrayList<TargetDrawable> mTargetDrawables;
    private AnimationBundle mWaveAnimations;
    private AnimationBundle mTargetAnimations;
    private AnimationBundle mGlowAnimations;
    private ArrayList<String> mTargetDescriptions;
    private ArrayList<String> mDirectionDescriptions;
    private OnTriggerListener mOnTriggerListener;
    private TargetDrawable mHandleDrawable;
    private TargetDrawable mOuterRing;
    private Vibrator mVibrator;
    private int mFeedbackCount;
    private int mVibrationDuration;
    private int mGrabbedState;
    private int mActiveTarget;
    private float mGlowRadius;
    private float mWaveCenterX;
    private float mWaveCenterY;
    private int mMaxTargetHeight;
    private int mMaxTargetWidth;
    private float mRingScaleFactor;
    private boolean mAllowScaling;
    private float mOuterRadius;
    private float mSnapMargin;
    private float mFirstItemOffset;
    private boolean mMagneticTargets;
    private boolean mDragging;
    private int mNewTargetResources;
    private Animator.AnimatorListener mResetListener;
    private Animator.AnimatorListener mResetListenerWithPing;
    private ValueAnimator.AnimatorUpdateListener mUpdateListener;
    private boolean mAnimatingTargets;
    private Animator.AnimatorListener mTargetUpdateListener;
    private int mTargetResourceId;
    private int mTargetDescriptionsResourceId;
    private int mDirectionDescriptionsResourceId;
    private boolean mAlwaysTrackFinger;
    private int mHorizontalInset;
    private int mVerticalInset;
    private int mGravity;
    private boolean mInitialLayout;
    private Tweener mBackgroundAnimator;
    private PointCloud mPointCloud;
    private float mInnerRadius;
    private int mPointerId;

    private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$__constructor__(Context context, AttributeSet attrs) {
        int resourceId;
        this.mTargetDrawables = new ArrayList();
        this.mWaveAnimations = new AnimationBundle(this);
        this.mTargetAnimations = new AnimationBundle(this);
        this.mGlowAnimations = new AnimationBundle(this);
        this.mFeedbackCount = 3;
        this.mVibrationDuration = 0;
        this.mActiveTarget = -1;
        this.mRingScaleFactor = 1.0f;
        this.mOuterRadius = 0.0f;
        this.mSnapMargin = 0.0f;
        this.mFirstItemOffset = 0.0f;
        this.mMagneticTargets = false;
        this.mResetListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlowPadView this$0;

            private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_1$__constructor__(GlowPadView glowPadView) {
            }

            private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_1$onAnimationEnd(Animator animator2) {
                this.this$0.switchToState(0, this.this$0.mWaveCenterX, this.this$0.mWaveCenterY);
                this.this$0.dispatchOnFinishFinalAnimation();
            }

            private void __constructor__(GlowPadView glowPadView) {
                this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView_1$__constructor__(glowPadView);
            }
            {
                this.this$0 = glowPadView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_1$__constructor__(com.android.internal.widget.multiwaveview.GlowPadView ), 0, this, glowPadView);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_1$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mResetListenerWithPing = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlowPadView this$0;

            private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_2$__constructor__(GlowPadView glowPadView) {
            }

            private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_2$onAnimationEnd(Animator animator2) {
                this.this$0.ping();
                this.this$0.switchToState(0, this.this$0.mWaveCenterX, this.this$0.mWaveCenterY);
                this.this$0.dispatchOnFinishFinalAnimation();
            }

            private void __constructor__(GlowPadView glowPadView) {
                this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView_2$__constructor__(glowPadView);
            }
            {
                this.this$0 = glowPadView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_2$__constructor__(com.android.internal.widget.multiwaveview.GlowPadView ), 0, this, glowPadView);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mUpdateListener = new ValueAnimator.AnimatorUpdateListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlowPadView this$0;

            private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_3$__constructor__(GlowPadView glowPadView) {
            }

            private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_3$onAnimationUpdate(ValueAnimator animation) {
                this.this$0.invalidate();
            }

            private void __constructor__(GlowPadView glowPadView) {
                this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView_3$__constructor__(glowPadView);
            }
            {
                this.this$0 = glowPadView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_3$__constructor__(com.android.internal.widget.multiwaveview.GlowPadView ), 0, this, glowPadView);
            }

            @Override
            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_3$onAnimationUpdate(android.animation.ValueAnimator ), 0, this, valueAnimator);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTargetUpdateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlowPadView this$0;

            private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_4$__constructor__(GlowPadView glowPadView) {
            }

            private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_4$onAnimationEnd(Animator animator2) {
                if (this.this$0.mNewTargetResources != 0) {
                    this.this$0.internalSetTargetResources(this.this$0.mNewTargetResources);
                    this.this$0.mNewTargetResources = 0;
                    this.this$0.hideTargets(false, false);
                }
                this.this$0.mAnimatingTargets = false;
            }

            private void __constructor__(GlowPadView glowPadView) {
                this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView_4$__constructor__(glowPadView);
            }
            {
                this.this$0 = glowPadView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_4$__constructor__(com.android.internal.widget.multiwaveview.GlowPadView ), 0, this, glowPadView);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_4$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mGravity = 48;
        this.mInitialLayout = true;
        Resources res = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GlowPadView);
        this.mInnerRadius = a.getDimension(1, this.mInnerRadius);
        this.mOuterRadius = a.getDimension(8, this.mOuterRadius);
        this.mSnapMargin = a.getDimension(11, this.mSnapMargin);
        this.mFirstItemOffset = (float)Math.toRadians(a.getFloat(14, (float)Math.toDegrees(this.mFirstItemOffset)));
        this.mVibrationDuration = a.getInt(10, this.mVibrationDuration);
        this.mFeedbackCount = a.getInt(12, this.mFeedbackCount);
        this.mAllowScaling = a.getBoolean(16, false);
        TypedValue handle = a.peekValue(5);
        this.mHandleDrawable = new TargetDrawable(res, handle != null ? handle.resourceId : 0);
        this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
        this.mOuterRing = new TargetDrawable(res, this.getResourceId(a, 6));
        this.mAlwaysTrackFinger = a.getBoolean(13, false);
        this.mMagneticTargets = a.getBoolean(15, this.mMagneticTargets);
        int pointId = this.getResourceId(a, 7);
        Drawable pointDrawable = pointId != 0 ? context.getDrawable(pointId) : null;
        this.mGlowRadius = a.getDimension(9, 0.0f);
        this.mPointCloud = new PointCloud(pointDrawable);
        this.mPointCloud.makePointCloud(this.mInnerRadius, this.mOuterRadius);
        this.mPointCloud.glowManager.setRadius(this.mGlowRadius);
        TypedValue outValue = new TypedValue();
        if (a.getValue(4, outValue)) {
            this.internalSetTargetResources(outValue.resourceId);
        }
        if (this.mTargetDrawables == null || this.mTargetDrawables.size() == 0) {
            throw new IllegalStateException("Must specify at least one target drawable");
        }
        if (a.getValue(2, outValue)) {
            resourceId = outValue.resourceId;
            if (resourceId == 0) {
                throw new IllegalStateException("Must specify target descriptions");
            }
            this.setTargetDescriptionsResourceId(resourceId);
        }
        if (a.getValue(3, outValue)) {
            resourceId = outValue.resourceId;
            if (resourceId == 0) {
                throw new IllegalStateException("Must specify direction descriptions");
            }
            this.setDirectionDescriptionsResourceId(resourceId);
        }
        this.mGravity = a.getInt(0, 48);
        a.recycle();
        this.setVibrateEnabled(this.mVibrationDuration > 0);
        this.assignDefaultsIfNeeded();
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getResourceId(TypedArray a, int id2) {
        TypedValue tv = a.peekValue(id2);
        return tv == null ? 0 : tv.resourceId;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dump() {
        Log.v("GlowPadView", "Outer Radius = " + this.mOuterRadius);
        Log.v("GlowPadView", "SnapMargin = " + this.mSnapMargin);
        Log.v("GlowPadView", "FeedbackCount = " + this.mFeedbackCount);
        Log.v("GlowPadView", "VibrationDuration = " + this.mVibrationDuration);
        Log.v("GlowPadView", "GlowRadius = " + this.mGlowRadius);
        Log.v("GlowPadView", "WaveCenterX = " + this.mWaveCenterX);
        Log.v("GlowPadView", "WaveCenterY = " + this.mWaveCenterY);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$suspendAnimations() {
        this.mWaveAnimations.setSuspended(true);
        this.mTargetAnimations.setSuspended(true);
        this.mGlowAnimations.setSuspended(true);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$resumeAnimations() {
        this.mWaveAnimations.setSuspended(false);
        this.mTargetAnimations.setSuspended(false);
        this.mGlowAnimations.setSuspended(false);
        this.mWaveAnimations.start();
        this.mTargetAnimations.start();
        this.mGlowAnimations.start();
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getSuggestedMinimumWidth() {
        return (int)(Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetWidth);
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getSuggestedMinimumHeight() {
        return (int)(Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetHeight);
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getScaledSuggestedMinimumWidth() {
        return (int)(this.mRingScaleFactor * Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetWidth);
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getScaledSuggestedMinimumHeight() {
        return (int)(this.mRingScaleFactor * Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius) + (float)this.mMaxTargetHeight);
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$resolveMeasured(int measureSpec, int desired) {
        int result = 0;
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (View.MeasureSpec.getMode(measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.min(specSize, desired);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$switchToState(int state, float x, float y) {
        switch (state) {
            case 0: {
                this.deactivateTargets();
                this.hideGlow(0, 0, 0.0f, null);
                this.startBackgroundAnimation(0, 0.0f);
                this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
                this.mHandleDrawable.setAlpha(1.0f);
                break;
            }
            case 1: {
                this.startBackgroundAnimation(0, 0.0f);
                break;
            }
            case 2: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.deactivateTargets();
                this.showTargets(true);
                this.startBackgroundAnimation(200, 1.0f);
                this.setGrabbedState(1);
                if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) break;
                this.announceTargets();
                break;
            }
            case 3: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.showGlow(0, 0, 1.0f, null);
                break;
            }
            case 4: {
                this.mHandleDrawable.setAlpha(0.0f);
                this.showGlow(0, 0, 0.0f, null);
                break;
            }
            case 5: {
                this.doFinish();
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$showGlow(int duration, int delay, float finalAlpha, Animator.AnimatorListener finishListener) {
        this.mGlowAnimations.cancel();
        this.mGlowAnimations.add(Tweener.to(this.mPointCloud.glowManager, duration, "ease", Ease.Cubic.easeIn, "delay", delay, "alpha", Float.valueOf(finalAlpha), "onUpdate", this.mUpdateListener, "onComplete", finishListener));
        this.mGlowAnimations.start();
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$hideGlow(int duration, int delay, float finalAlpha, Animator.AnimatorListener finishListener) {
        this.mGlowAnimations.cancel();
        this.mGlowAnimations.add(Tweener.to(this.mPointCloud.glowManager, duration, "ease", Ease.Quart.easeOut, "delay", delay, "alpha", Float.valueOf(finalAlpha), "x", Float.valueOf(0.0f), "y", Float.valueOf(0.0f), "onUpdate", this.mUpdateListener, "onComplete", finishListener));
        this.mGlowAnimations.start();
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$deactivateTargets() {
        int count = this.mTargetDrawables.size();
        for (int i = 0; i < count; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            target.setState(TargetDrawable.STATE_INACTIVE);
        }
        this.mActiveTarget = -1;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dispatchTriggerEvent(int whichTarget) {
        this.vibrate();
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, whichTarget);
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dispatchOnFinishFinalAnimation() {
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onFinishFinalAnimation();
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$doFinish() {
        boolean targetHit;
        int activeTarget = this.mActiveTarget;
        boolean bl = targetHit = activeTarget != -1;
        if (targetHit) {
            this.highlightSelected(activeTarget);
            this.hideGlow(200, 1200, 0.0f, this.mResetListener);
            this.dispatchTriggerEvent(activeTarget);
            if (!this.mAlwaysTrackFinger) {
                this.mTargetAnimations.stop();
            }
        } else {
            this.hideGlow(200, 0, 0.0f, this.mResetListenerWithPing);
            this.hideTargets(true, false);
        }
        this.setGrabbedState(0);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$highlightSelected(int activeTarget) {
        this.mTargetDrawables.get(activeTarget).setState(TargetDrawable.STATE_ACTIVE);
        this.hideUnselected(activeTarget);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$hideUnselected(int active) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            if (i == active) continue;
            this.mTargetDrawables.get(i).setAlpha(0.0f);
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$hideTargets(boolean animate, boolean expanded) {
        this.mTargetAnimations.cancel();
        this.mAnimatingTargets = animate;
        int duration = animate ? 200 : 0;
        int delay = animate ? 200 : 0;
        float targetScale = expanded ? 1.0f : 0.8f;
        int length = this.mTargetDrawables.size();
        TimeInterpolator interpolator2 = Ease.Cubic.easeOut;
        for (int i = 0; i < length; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            target.setState(TargetDrawable.STATE_INACTIVE);
            this.mTargetAnimations.add(Tweener.to(target, duration, "ease", interpolator2, "alpha", Float.valueOf(0.0f), "scaleX", Float.valueOf(targetScale), "scaleY", Float.valueOf(targetScale), "delay", delay, "onUpdate", this.mUpdateListener));
        }
        float ringScaleTarget = expanded ? 1.0f : 0.5f;
        this.mTargetAnimations.add(Tweener.to(this.mOuterRing, duration, "ease", interpolator2, "alpha", Float.valueOf(0.0f), "scaleX", Float.valueOf(ringScaleTarget *= this.mRingScaleFactor), "scaleY", Float.valueOf(ringScaleTarget), "delay", delay, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener));
        this.mTargetAnimations.start();
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$showTargets(boolean animate) {
        this.mTargetAnimations.stop();
        this.mAnimatingTargets = animate;
        int delay = animate ? 50 : 0;
        int duration = animate ? 200 : 0;
        int length = this.mTargetDrawables.size();
        for (int i = 0; i < length; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            target.setState(TargetDrawable.STATE_INACTIVE);
            this.mTargetAnimations.add(Tweener.to(target, duration, "ease", Ease.Cubic.easeOut, "alpha", Float.valueOf(1.0f), "scaleX", Float.valueOf(1.0f), "scaleY", Float.valueOf(1.0f), "delay", delay, "onUpdate", this.mUpdateListener));
        }
        float ringScale = this.mRingScaleFactor * 1.0f;
        this.mTargetAnimations.add(Tweener.to(this.mOuterRing, duration, "ease", Ease.Cubic.easeOut, "alpha", Float.valueOf(1.0f), "scaleX", Float.valueOf(ringScale), "scaleY", Float.valueOf(ringScale), "delay", delay, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener));
        this.mTargetAnimations.start();
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$vibrate() {
        boolean hapticEnabled;
        boolean bl = hapticEnabled = Settings.System.getIntForUser(this.mContext.getContentResolver(), "haptic_feedback_enabled", 1, -2) != 0;
        if (this.mVibrator != null && hapticEnabled) {
            this.mVibrator.vibrate(this.mVibrationDuration, VIBRATION_ATTRIBUTES);
        }
    }

    private final ArrayList<TargetDrawable> $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$loadDrawableArray(int resourceId) {
        Resources res = this.getContext().getResources();
        TypedArray array2 = res.obtainTypedArray(resourceId);
        int count = array2.length();
        ArrayList<TargetDrawable> drawables = new ArrayList<TargetDrawable>(count);
        for (int i = 0; i < count; ++i) {
            TypedValue value = array2.peekValue(i);
            TargetDrawable target = new TargetDrawable(res, value != null ? value.resourceId : 0);
            drawables.add(target);
        }
        array2.recycle();
        return drawables;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$internalSetTargetResources(int resourceId) {
        ArrayList<TargetDrawable> targets = this.loadDrawableArray(resourceId);
        this.mTargetDrawables = targets;
        this.mTargetResourceId = resourceId;
        int maxWidth = this.mHandleDrawable.getWidth();
        int maxHeight = this.mHandleDrawable.getHeight();
        int count = targets.size();
        for (int i = 0; i < count; ++i) {
            TargetDrawable target = targets.get(i);
            maxWidth = Math.max(maxWidth, target.getWidth());
            maxHeight = Math.max(maxHeight, target.getHeight());
        }
        if (this.mMaxTargetWidth != maxWidth || this.mMaxTargetHeight != maxHeight) {
            this.mMaxTargetWidth = maxWidth;
            this.mMaxTargetHeight = maxHeight;
            this.requestLayout();
        } else {
            this.updateTargetPositions(this.mWaveCenterX, this.mWaveCenterY);
            this.updatePointCloudPosition(this.mWaveCenterX, this.mWaveCenterY);
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setTargetResources(int resourceId) {
        if (this.mAnimatingTargets) {
            this.mNewTargetResources = resourceId;
        } else {
            this.internalSetTargetResources(resourceId);
        }
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetResourceId() {
        return this.mTargetResourceId;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setTargetDescriptionsResourceId(int resourceId) {
        this.mTargetDescriptionsResourceId = resourceId;
        if (this.mTargetDescriptions != null) {
            this.mTargetDescriptions.clear();
        }
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetDescriptionsResourceId() {
        return this.mTargetDescriptionsResourceId;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setDirectionDescriptionsResourceId(int resourceId) {
        this.mDirectionDescriptionsResourceId = resourceId;
        if (this.mDirectionDescriptions != null) {
            this.mDirectionDescriptions.clear();
        }
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getDirectionDescriptionsResourceId() {
        return this.mDirectionDescriptionsResourceId;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setVibrateEnabled(boolean enabled) {
        this.mVibrator = enabled && this.mVibrator == null ? (Vibrator)this.getContext().getSystemService("vibrator") : null;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$ping() {
        if (this.mFeedbackCount > 0) {
            long t;
            boolean doWaveAnimation = true;
            AnimationBundle waveAnimations = this.mWaveAnimations;
            if (waveAnimations.size() > 0 && ((Tweener)waveAnimations.get((int)0)).animator.isRunning() && (t = ((Tweener)waveAnimations.get((int)0)).animator.getCurrentPlayTime()) < 500L) {
                doWaveAnimation = false;
            }
            if (doWaveAnimation) {
                this.startWaveAnimation();
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$stopAndHideWaveAnimation() {
        this.mWaveAnimations.cancel();
        this.mPointCloud.waveManager.setAlpha(0.0f);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$startWaveAnimation() {
        this.mWaveAnimations.cancel();
        this.mPointCloud.waveManager.setAlpha(1.0f);
        this.mPointCloud.waveManager.setRadius((float)this.mHandleDrawable.getWidth() / 2.0f);
        this.mWaveAnimations.add(Tweener.to(this.mPointCloud.waveManager, 1000L, "ease", Ease.Quad.easeOut, "delay", 0, "radius", Float.valueOf(2.0f * this.mOuterRadius), "onUpdate", this.mUpdateListener, "onComplete", new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlowPadView this$0;

            private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_5$__constructor__(GlowPadView glowPadView) {
            }

            private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_5$onAnimationEnd(Animator animator2) {
                ((GlowPadView)this.this$0).mPointCloud.waveManager.setRadius(0.0f);
                ((GlowPadView)this.this$0).mPointCloud.waveManager.setAlpha(0.0f);
            }

            private void __constructor__(GlowPadView glowPadView) {
                this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView_5$__constructor__(glowPadView);
            }
            {
                this.this$0 = glowPadView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_5$__constructor__(com.android.internal.widget.multiwaveview.GlowPadView ), 0, this, glowPadView);
            }

            @Override
            public void onAnimationEnd(Animator animator2) {
                InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_5$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }));
        this.mWaveAnimations.start();
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$reset(boolean animate) {
        this.mGlowAnimations.stop();
        this.mTargetAnimations.stop();
        this.startBackgroundAnimation(0, 0.0f);
        this.stopAndHideWaveAnimation();
        this.hideTargets(animate, false);
        this.hideGlow(0, 0, 0.0f, null);
        Tweener.reset();
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$startBackgroundAnimation(int duration, float alpha) {
        Drawable background = this.getBackground();
        if (this.mAlwaysTrackFinger && background != null) {
            if (this.mBackgroundAnimator != null) {
                this.mBackgroundAnimator.animator.cancel();
            }
            this.mBackgroundAnimator = Tweener.to(background, duration, "ease", Ease.Cubic.easeIn, "alpha", (int)(255.0f * alpha), "delay", 50);
            this.mBackgroundAnimator.animator.start();
        }
    }

    private final boolean $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        boolean handled = false;
        switch (action) {
            case 0: 
            case 5: {
                this.handleDown(event);
                this.handleMove(event);
                handled = true;
                break;
            }
            case 2: {
                this.handleMove(event);
                handled = true;
                break;
            }
            case 1: 
            case 6: {
                this.handleMove(event);
                this.handleUp(event);
                handled = true;
                break;
            }
            case 3: {
                this.handleMove(event);
                this.handleCancel(event);
                handled = true;
            }
        }
        this.invalidate();
        return handled ? true : super.onTouchEvent(event);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateGlowPosition(float x, float y) {
        float dx = x - this.mOuterRing.getX();
        float dy = y - this.mOuterRing.getY();
        this.mPointCloud.glowManager.setX(this.mOuterRing.getX() + (dx *= 1.0f / this.mRingScaleFactor));
        this.mPointCloud.glowManager.setY(this.mOuterRing.getY() + (dy *= 1.0f / this.mRingScaleFactor));
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleDown(MotionEvent event) {
        int actionIndex = event.getActionIndex();
        float eventX = event.getX(actionIndex);
        float eventY = event.getY(actionIndex);
        this.switchToState(1, eventX, eventY);
        if (!this.trySwitchToFirstTouchState(eventX, eventY)) {
            this.mDragging = false;
        } else {
            this.mPointerId = event.getPointerId(actionIndex);
            this.updateGlowPosition(eventX, eventY);
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleUp(MotionEvent event) {
        int actionIndex = event.getActionIndex();
        if (event.getPointerId(actionIndex) == this.mPointerId) {
            this.switchToState(5, event.getX(actionIndex), event.getY(actionIndex));
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleCancel(MotionEvent event) {
        this.mActiveTarget = -1;
        int actionIndex = event.findPointerIndex(this.mPointerId);
        actionIndex = actionIndex == -1 ? 0 : actionIndex;
        this.switchToState(5, event.getX(actionIndex), event.getY(actionIndex));
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleMove(MotionEvent event) {
        int activeTarget = -1;
        int historySize = event.getHistorySize();
        ArrayList<TargetDrawable> targets = this.mTargetDrawables;
        int ntargets = targets.size();
        float x = 0.0f;
        float y = 0.0f;
        float activeAngle = 0.0f;
        int actionIndex = event.findPointerIndex(this.mPointerId);
        if (actionIndex == -1) {
            return;
        }
        for (int k = 0; k < historySize + 1; ++k) {
            float eventX = k < historySize ? event.getHistoricalX(actionIndex, k) : event.getX(actionIndex);
            float eventY = k < historySize ? event.getHistoricalY(actionIndex, k) : event.getY(actionIndex);
            float tx = eventX - this.mWaveCenterX;
            float ty = eventY - this.mWaveCenterY;
            float touchRadius = (float)Math.sqrt(this.dist2(tx, ty));
            float scale = touchRadius > this.mOuterRadius ? this.mOuterRadius / touchRadius : 1.0f;
            float limitX = tx * scale;
            float limitY = ty * scale;
            double angleRad = Math.atan2(-ty, tx);
            if (!this.mDragging) {
                this.trySwitchToFirstTouchState(eventX, eventY);
            }
            if (this.mDragging) {
                float snapRadius = this.mRingScaleFactor * this.mOuterRadius - this.mSnapMargin;
                float snapDistance2 = snapRadius * snapRadius;
                for (int i = 0; i < ntargets; ++i) {
                    boolean angleMatches;
                    TargetDrawable target = targets.get(i);
                    double targetMinRad = (double)this.mFirstItemOffset + ((double)i - 0.5) * 2.0 * Math.PI / (double)ntargets;
                    double targetMaxRad = (double)this.mFirstItemOffset + ((double)i + 0.5) * 2.0 * Math.PI / (double)ntargets;
                    if (!target.isEnabled()) continue;
                    boolean bl = angleMatches = angleRad > targetMinRad && angleRad <= targetMaxRad || angleRad + Math.PI * 2 > targetMinRad && angleRad + Math.PI * 2 <= targetMaxRad || angleRad - Math.PI * 2 > targetMinRad && angleRad - Math.PI * 2 <= targetMaxRad;
                    if (!angleMatches || !(this.dist2(tx, ty) > snapDistance2)) continue;
                    activeTarget = i;
                    activeAngle = (float)(-angleRad);
                }
            }
            x = limitX;
            y = limitY;
        }
        if (!this.mDragging) {
            return;
        }
        if (activeTarget != -1) {
            this.switchToState(4, x, y);
            this.updateGlowPosition(x, y);
        } else {
            this.switchToState(3, x, y);
            this.updateGlowPosition(x, y);
        }
        if (this.mActiveTarget != activeTarget) {
            if (this.mActiveTarget != -1) {
                TargetDrawable target = targets.get(this.mActiveTarget);
                if (target.hasState(TargetDrawable.STATE_FOCUSED)) {
                    target.setState(TargetDrawable.STATE_INACTIVE);
                }
                if (this.mMagneticTargets) {
                    this.updateTargetPosition(this.mActiveTarget, this.mWaveCenterX, this.mWaveCenterY);
                }
            }
            if (activeTarget != -1) {
                TargetDrawable target = targets.get(activeTarget);
                if (target.hasState(TargetDrawable.STATE_FOCUSED)) {
                    target.setState(TargetDrawable.STATE_FOCUSED);
                }
                if (this.mMagneticTargets) {
                    this.updateTargetPosition(activeTarget, this.mWaveCenterX, this.mWaveCenterY, activeAngle);
                }
                if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                    String targetContentDescription = this.getTargetDescription(activeTarget);
                    this.announceForAccessibility(targetContentDescription);
                }
            }
        }
        this.mActiveTarget = activeTarget;
    }

    private final boolean $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onHoverEvent(MotionEvent event) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            this.onTouchEvent(event);
            event.setAction(action);
        }
        super.onHoverEvent(event);
        return true;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setGrabbedState(int newState) {
        if (newState != this.mGrabbedState) {
            if (newState != 0) {
                this.vibrate();
            }
            this.mGrabbedState = newState;
            if (this.mOnTriggerListener != null) {
                if (newState == 0) {
                    this.mOnTriggerListener.onReleased(this, 1);
                } else {
                    this.mOnTriggerListener.onGrabbed(this, 1);
                }
                this.mOnTriggerListener.onGrabbedStateChange(this, newState);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$trySwitchToFirstTouchState(float x, float y) {
        float tx = x - this.mWaveCenterX;
        float ty = y - this.mWaveCenterY;
        if (this.mAlwaysTrackFinger || this.dist2(tx, ty) <= this.getScaledGlowRadiusSquared()) {
            this.switchToState(2, x, y);
            this.updateGlowPosition(tx, ty);
            this.mDragging = true;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$assignDefaultsIfNeeded() {
        if (this.mOuterRadius == 0.0f) {
            this.mOuterRadius = (float)Math.max(this.mOuterRing.getWidth(), this.mOuterRing.getHeight()) / 2.0f;
        }
        if (this.mSnapMargin == 0.0f) {
            this.mSnapMargin = TypedValue.applyDimension(1, 20.0f, this.getContext().getResources().getDisplayMetrics());
        }
        if (this.mInnerRadius == 0.0f) {
            this.mInnerRadius = (float)this.mHandleDrawable.getWidth() / 10.0f;
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$computeInsets(int dx, int dy) {
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        switch (absoluteGravity & 7) {
            case 3: {
                this.mHorizontalInset = 0;
                break;
            }
            case 5: {
                this.mHorizontalInset = dx;
                break;
            }
            default: {
                this.mHorizontalInset = dx / 2;
            }
        }
        switch (absoluteGravity & 0x70) {
            case 48: {
                this.mVerticalInset = 0;
                break;
            }
            case 80: {
                this.mVerticalInset = dy;
                break;
            }
            default: {
                this.mVerticalInset = dy / 2;
            }
        }
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$computeScaleFactor(int desiredWidth, int desiredHeight, int actualWidth, int actualHeight) {
        if (!this.mAllowScaling) {
            return 1.0f;
        }
        int layoutDirection = this.getLayoutDirection();
        int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        switch (absoluteGravity & 7) {
            case 3: 
            case 5: {
                break;
            }
            default: {
                if (desiredWidth <= actualWidth) break;
                scaleX = (1.0f * (float)actualWidth - (float)this.mMaxTargetWidth) / (float)(desiredWidth - this.mMaxTargetWidth);
            }
        }
        switch (absoluteGravity & 0x70) {
            case 48: 
            case 80: {
                break;
            }
            default: {
                if (desiredHeight <= actualHeight) break;
                scaleY = (1.0f * (float)actualHeight - (float)this.mMaxTargetHeight) / (float)(desiredHeight - this.mMaxTargetHeight);
            }
        }
        return Math.min(scaleX, scaleY);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        int computedWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        int computedHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        this.mRingScaleFactor = this.computeScaleFactor(minimumWidth, minimumHeight, computedWidth, computedHeight);
        int scaledWidth = this.getScaledSuggestedMinimumWidth();
        int scaledHeight = this.getScaledSuggestedMinimumHeight();
        this.computeInsets(computedWidth - scaledWidth, computedHeight - scaledHeight);
        this.setMeasuredDimension(computedWidth, computedHeight);
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getRingWidth() {
        return this.mRingScaleFactor * Math.max((float)this.mOuterRing.getWidth(), 2.0f * this.mOuterRadius);
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getRingHeight() {
        return this.mRingScaleFactor * Math.max((float)this.mOuterRing.getHeight(), 2.0f * this.mOuterRadius);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = right - left;
        int height = bottom - top;
        float placementWidth = this.getRingWidth();
        float placementHeight = this.getRingHeight();
        float newWaveCenterX = (float)this.mHorizontalInset + Math.max((float)width, (float)this.mMaxTargetWidth + placementWidth) / 2.0f;
        float newWaveCenterY = (float)this.mVerticalInset + Math.max((float)height, (float)this.mMaxTargetHeight + placementHeight) / 2.0f;
        if (this.mInitialLayout) {
            this.stopAndHideWaveAnimation();
            this.hideTargets(false, false);
            this.mInitialLayout = false;
        }
        this.mOuterRing.setPositionX(newWaveCenterX);
        this.mOuterRing.setPositionY(newWaveCenterY);
        this.mPointCloud.setScale(this.mRingScaleFactor);
        this.mHandleDrawable.setPositionX(newWaveCenterX);
        this.mHandleDrawable.setPositionY(newWaveCenterY);
        this.updateTargetPositions(newWaveCenterX, newWaveCenterY);
        this.updatePointCloudPosition(newWaveCenterX, newWaveCenterY);
        this.updateGlowPosition(newWaveCenterX, newWaveCenterY);
        this.mWaveCenterX = newWaveCenterX;
        this.mWaveCenterY = newWaveCenterY;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPosition(int i, float centerX, float centerY) {
        float angle = this.getAngle(this.getSliceAngle(), i);
        this.updateTargetPosition(i, centerX, centerY, angle);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPosition(int i, float centerX, float centerY, float angle) {
        float placementRadiusX = this.getRingWidth() / 2.0f;
        float placementRadiusY = this.getRingHeight() / 2.0f;
        if (i >= 0) {
            ArrayList<TargetDrawable> targets = this.mTargetDrawables;
            TargetDrawable targetIcon = targets.get(i);
            targetIcon.setPositionX(centerX);
            targetIcon.setPositionY(centerY);
            targetIcon.setX(placementRadiusX * (float)Math.cos(angle));
            targetIcon.setY(placementRadiusY * (float)Math.sin(angle));
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPositions(float centerX, float centerY) {
        this.updateTargetPositions(centerX, centerY, false);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPositions(float centerX, float centerY, boolean skipActive) {
        int size = this.mTargetDrawables.size();
        float alpha = this.getSliceAngle();
        for (int i = 0; i < size; ++i) {
            if (skipActive && i == this.mActiveTarget) continue;
            this.updateTargetPosition(i, centerX, centerY, this.getAngle(alpha, i));
        }
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getAngle(float alpha, int i) {
        return this.mFirstItemOffset + alpha * (float)i;
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getSliceAngle() {
        return (float)(Math.PI * -2 / (double)this.mTargetDrawables.size());
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updatePointCloudPosition(float centerX, float centerY) {
        this.mPointCloud.setCenter(centerX, centerY);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onDraw(Canvas canvas) {
        this.mPointCloud.draw(canvas);
        this.mOuterRing.draw(canvas);
        int ntargets = this.mTargetDrawables.size();
        for (int i = 0; i < ntargets; ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            if (target == null) continue;
            target.draw(canvas);
        }
        this.mHandleDrawable.draw(canvas);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setOnTriggerListener(OnTriggerListener listener) {
        this.mOnTriggerListener = listener;
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$square(float d) {
        return d * d;
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dist2(float dx, float dy) {
        return dx * dx + dy * dy;
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getScaledGlowRadiusSquared() {
        float scaledTapRadius = AccessibilityManager.getInstance(this.mContext).isEnabled() ? 1.3f * this.mGlowRadius : this.mGlowRadius;
        return this.square(scaledTapRadius);
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$announceTargets() {
        StringBuilder utterance = new StringBuilder();
        int targetCount = this.mTargetDrawables.size();
        for (int i = 0; i < targetCount; ++i) {
            String targetDescription = this.getTargetDescription(i);
            String directionDescription = this.getDirectionDescription(i);
            if (TextUtils.isEmpty(targetDescription) || TextUtils.isEmpty(directionDescription)) continue;
            String text = String.format(directionDescription, targetDescription);
            utterance.append(text);
        }
        if (utterance.length() > 0) {
            this.announceForAccessibility(utterance.toString());
        }
    }

    private final String $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetDescription(int index) {
        if (this.mTargetDescriptions == null || this.mTargetDescriptions.isEmpty()) {
            this.mTargetDescriptions = this.loadDescriptions(this.mTargetDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mTargetDescriptions.size()) {
                Log.w("GlowPadView", "The number of target drawables must be equal to the number of target descriptions.");
                return null;
            }
        }
        return this.mTargetDescriptions.get(index);
    }

    private final String $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getDirectionDescription(int index) {
        if (this.mDirectionDescriptions == null || this.mDirectionDescriptions.isEmpty()) {
            this.mDirectionDescriptions = this.loadDescriptions(this.mDirectionDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mDirectionDescriptions.size()) {
                Log.w("GlowPadView", "The number of target drawables must be equal to the number of direction descriptions.");
                return null;
            }
        }
        return this.mDirectionDescriptions.get(index);
    }

    private final ArrayList<String> $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$loadDescriptions(int resourceId) {
        TypedArray array2 = this.getContext().getResources().obtainTypedArray(resourceId);
        int count = array2.length();
        ArrayList<String> targetContentDescriptions = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String contentDescription = array2.getString(i);
            targetContentDescriptions.add(contentDescription);
        }
        array2.recycle();
        return targetContentDescriptions;
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getResourceIdForTarget(int index) {
        TargetDrawable drawable2 = this.mTargetDrawables.get(index);
        return drawable2 == null ? 0 : drawable2.getResourceId();
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setEnableTarget(int resourceId, boolean enabled) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            if (target.getResourceId() != resourceId) continue;
            target.setEnabled(enabled);
            break;
        }
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetPosition(int resourceId) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            TargetDrawable target = this.mTargetDrawables.get(i);
            if (target.getResourceId() != resourceId) continue;
            return i;
        }
        return -1;
    }

    private final boolean $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$replaceTargetDrawables(Resources res, int existingResourceId, int newResourceId) {
        if (existingResourceId == 0 || newResourceId == 0) {
            return false;
        }
        boolean result = false;
        ArrayList<TargetDrawable> drawables = this.mTargetDrawables;
        int size = drawables.size();
        for (int i = 0; i < size; ++i) {
            TargetDrawable target = drawables.get(i);
            if (target == null || target.getResourceId() != existingResourceId) continue;
            target.setDrawable(res, newResourceId);
            result = true;
        }
        if (result) {
            this.requestLayout();
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$replaceTargetDrawablesIfPresent(ComponentName component, String name, int existingResId) {
        if (existingResId == 0) {
            return false;
        }
        boolean replaced = false;
        if (component != null) {
            try {
                int iconResId;
                PackageManager packageManager = this.mContext.getPackageManager();
                Bundle metaData = packageManager.getActivityInfo((ComponentName)component, (int)128).metaData;
                if (metaData != null && (iconResId = metaData.getInt(name)) != 0) {
                    Resources res = packageManager.getResourcesForActivity(component);
                    replaced = this.replaceTargetDrawables(res, existingResId, iconResId);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("GlowPadView", "Failed to swap drawable; " + component.flattenToShortString() + " not found", e);
            }
            catch (Resources.NotFoundException nfe) {
                Log.w("GlowPadView", "Failed to swap drawable from " + component.flattenToShortString(), nfe);
            }
        }
        if (!replaced) {
            this.replaceTargetDrawables(this.mContext.getResources(), existingResId, existingResId);
        }
        return replaced;
    }

    static void __staticInitializer__() {
        VIBRATION_ATTRIBUTES = new AudioAttributes.Builder().setContentType(4).setUsage(13).build();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView$__constructor__(context);
    }

    public GlowPadView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView$__constructor__(context, attributeSet);
    }

    public GlowPadView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private int getResourceId(TypedArray typedArray, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceId", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getResourceId(android.content.res.TypedArray int ), 0, this, typedArray, n);
    }

    private void dump() {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dump(), 0, this);
    }

    public void suspendAnimations() {
        InvokeDynamicSupport.bootstrap("suspendAnimations", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$suspendAnimations(), 0, this);
    }

    public void resumeAnimations() {
        InvokeDynamicSupport.bootstrap("resumeAnimations", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$resumeAnimations(), 0, this);
    }

    @Override
    protected int getSuggestedMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getSuggestedMinimumWidth", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getSuggestedMinimumWidth(), 0, this);
    }

    @Override
    protected int getSuggestedMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getSuggestedMinimumHeight", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getSuggestedMinimumHeight(), 0, this);
    }

    protected int getScaledSuggestedMinimumWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledSuggestedMinimumWidth", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getScaledSuggestedMinimumWidth(), 0, this);
    }

    protected int getScaledSuggestedMinimumHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getScaledSuggestedMinimumHeight", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getScaledSuggestedMinimumHeight(), 0, this);
    }

    private int resolveMeasured(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("resolveMeasured", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$resolveMeasured(int int ), 0, this, n, n2);
    }

    private void switchToState(int n, float f, float f2) {
        InvokeDynamicSupport.bootstrap("switchToState", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$switchToState(int float float ), 0, this, n, f, f2);
    }

    private void showGlow(int n, int n2, float f, Animator.AnimatorListener animatorListener) {
        InvokeDynamicSupport.bootstrap("showGlow", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$showGlow(int int float android.animation.Animator$AnimatorListener ), 0, this, n, n2, f, animatorListener);
    }

    private void hideGlow(int n, int n2, float f, Animator.AnimatorListener animatorListener) {
        InvokeDynamicSupport.bootstrap("hideGlow", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$hideGlow(int int float android.animation.Animator$AnimatorListener ), 0, this, n, n2, f, animatorListener);
    }

    private void deactivateTargets() {
        InvokeDynamicSupport.bootstrap("deactivateTargets", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$deactivateTargets(), 0, this);
    }

    private void dispatchTriggerEvent(int n) {
        InvokeDynamicSupport.bootstrap("dispatchTriggerEvent", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dispatchTriggerEvent(int ), 0, this, n);
    }

    private void dispatchOnFinishFinalAnimation() {
        InvokeDynamicSupport.bootstrap("dispatchOnFinishFinalAnimation", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dispatchOnFinishFinalAnimation(), 0, this);
    }

    private void doFinish() {
        InvokeDynamicSupport.bootstrap("doFinish", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$doFinish(), 0, this);
    }

    private void highlightSelected(int n) {
        InvokeDynamicSupport.bootstrap("highlightSelected", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$highlightSelected(int ), 0, this, n);
    }

    private void hideUnselected(int n) {
        InvokeDynamicSupport.bootstrap("hideUnselected", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$hideUnselected(int ), 0, this, n);
    }

    private void hideTargets(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("hideTargets", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$hideTargets(boolean boolean ), 0, this, bl, bl2);
    }

    private void showTargets(boolean bl) {
        InvokeDynamicSupport.bootstrap("showTargets", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$showTargets(boolean ), 0, this, bl);
    }

    private void vibrate() {
        InvokeDynamicSupport.bootstrap("vibrate", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$vibrate(), 0, this);
    }

    private ArrayList<TargetDrawable> loadDrawableArray(int n) {
        return InvokeDynamicSupport.bootstrap("loadDrawableArray", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$loadDrawableArray(int ), 0, this, n);
    }

    private void internalSetTargetResources(int n) {
        InvokeDynamicSupport.bootstrap("internalSetTargetResources", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$internalSetTargetResources(int ), 0, this, n);
    }

    public void setTargetResources(int n) {
        InvokeDynamicSupport.bootstrap("setTargetResources", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setTargetResources(int ), 0, this, n);
    }

    public int getTargetResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getTargetResourceId", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetResourceId(), 0, this);
    }

    public void setTargetDescriptionsResourceId(int n) {
        InvokeDynamicSupport.bootstrap("setTargetDescriptionsResourceId", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setTargetDescriptionsResourceId(int ), 0, this, n);
    }

    public int getTargetDescriptionsResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getTargetDescriptionsResourceId", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetDescriptionsResourceId(), 0, this);
    }

    public void setDirectionDescriptionsResourceId(int n) {
        InvokeDynamicSupport.bootstrap("setDirectionDescriptionsResourceId", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setDirectionDescriptionsResourceId(int ), 0, this, n);
    }

    public int getDirectionDescriptionsResourceId() {
        return (int)InvokeDynamicSupport.bootstrap("getDirectionDescriptionsResourceId", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getDirectionDescriptionsResourceId(), 0, this);
    }

    public void setVibrateEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setVibrateEnabled", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setVibrateEnabled(boolean ), 0, this, bl);
    }

    public void ping() {
        InvokeDynamicSupport.bootstrap("ping", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$ping(), 0, this);
    }

    private void stopAndHideWaveAnimation() {
        InvokeDynamicSupport.bootstrap("stopAndHideWaveAnimation", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$stopAndHideWaveAnimation(), 0, this);
    }

    private void startWaveAnimation() {
        InvokeDynamicSupport.bootstrap("startWaveAnimation", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$startWaveAnimation(), 0, this);
    }

    public void reset(boolean bl) {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$reset(boolean ), 0, this, bl);
    }

    private void startBackgroundAnimation(int n, float f) {
        InvokeDynamicSupport.bootstrap("startBackgroundAnimation", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$startBackgroundAnimation(int float ), 0, this, n, f);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void updateGlowPosition(float f, float f2) {
        InvokeDynamicSupport.bootstrap("updateGlowPosition", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateGlowPosition(float float ), 0, this, f, f2);
    }

    private void handleDown(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("handleDown", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleDown(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void handleUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("handleUp", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleUp(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void handleCancel(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("handleCancel", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleCancel(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void handleMove(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("handleMove", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$handleMove(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onHoverEvent", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void setGrabbedState(int n) {
        InvokeDynamicSupport.bootstrap("setGrabbedState", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setGrabbedState(int ), 0, this, n);
    }

    private boolean trySwitchToFirstTouchState(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("trySwitchToFirstTouchState", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$trySwitchToFirstTouchState(float float ), 0, this, f, f2);
    }

    private void assignDefaultsIfNeeded() {
        InvokeDynamicSupport.bootstrap("assignDefaultsIfNeeded", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$assignDefaultsIfNeeded(), 0, this);
    }

    private void computeInsets(int n, int n2) {
        InvokeDynamicSupport.bootstrap("computeInsets", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$computeInsets(int int ), 0, this, n, n2);
    }

    private float computeScaleFactor(int n, int n2, int n3, int n4) {
        return (float)InvokeDynamicSupport.bootstrap("computeScaleFactor", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$computeScaleFactor(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onMeasure(int int ), 0, this, n, n2);
    }

    private float getRingWidth() {
        return (float)InvokeDynamicSupport.bootstrap("getRingWidth", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getRingWidth(), 0, this);
    }

    private float getRingHeight() {
        return (float)InvokeDynamicSupport.bootstrap("getRingHeight", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getRingHeight(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    private void updateTargetPosition(int n, float f, float f2) {
        InvokeDynamicSupport.bootstrap("updateTargetPosition", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPosition(int float float ), 0, this, n, f, f2);
    }

    private void updateTargetPosition(int n, float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrap("updateTargetPosition", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPosition(int float float float ), 0, this, n, f, f2, f3);
    }

    private void updateTargetPositions(float f, float f2) {
        InvokeDynamicSupport.bootstrap("updateTargetPositions", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPositions(float float ), 0, this, f, f2);
    }

    private void updateTargetPositions(float f, float f2, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateTargetPositions", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updateTargetPositions(float float boolean ), 0, this, f, f2, bl);
    }

    private float getAngle(float f, int n) {
        return (float)InvokeDynamicSupport.bootstrap("getAngle", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getAngle(float int ), 0, this, f, n);
    }

    private float getSliceAngle() {
        return (float)InvokeDynamicSupport.bootstrap("getSliceAngle", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getSliceAngle(), 0, this);
    }

    private void updatePointCloudPosition(float f, float f2) {
        InvokeDynamicSupport.bootstrap("updatePointCloudPosition", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$updatePointCloudPosition(float float ), 0, this, f, f2);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setOnTriggerListener(OnTriggerListener onTriggerListener) {
        InvokeDynamicSupport.bootstrap("setOnTriggerListener", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setOnTriggerListener(com.android.internal.widget.multiwaveview.GlowPadView$OnTriggerListener ), 0, this, onTriggerListener);
    }

    private float square(float f) {
        return (float)InvokeDynamicSupport.bootstrap("square", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$square(float ), 0, this, f);
    }

    private float dist2(float f, float f2) {
        return (float)InvokeDynamicSupport.bootstrap("dist2", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$dist2(float float ), 0, this, f, f2);
    }

    private float getScaledGlowRadiusSquared() {
        return (float)InvokeDynamicSupport.bootstrap("getScaledGlowRadiusSquared", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getScaledGlowRadiusSquared(), 0, this);
    }

    private void announceTargets() {
        InvokeDynamicSupport.bootstrap("announceTargets", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$announceTargets(), 0, this);
    }

    private String getTargetDescription(int n) {
        return InvokeDynamicSupport.bootstrap("getTargetDescription", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetDescription(int ), 0, this, n);
    }

    private String getDirectionDescription(int n) {
        return InvokeDynamicSupport.bootstrap("getDirectionDescription", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getDirectionDescription(int ), 0, this, n);
    }

    private ArrayList<String> loadDescriptions(int n) {
        return InvokeDynamicSupport.bootstrap("loadDescriptions", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$loadDescriptions(int ), 0, this, n);
    }

    public int getResourceIdForTarget(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getResourceIdForTarget", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getResourceIdForTarget(int ), 0, this, n);
    }

    public void setEnableTarget(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnableTarget", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$setEnableTarget(int boolean ), 0, this, n, bl);
    }

    public int getTargetPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getTargetPosition", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$getTargetPosition(int ), 0, this, n);
    }

    private boolean replaceTargetDrawables(Resources resources, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("replaceTargetDrawables", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$replaceTargetDrawables(android.content.res.Resources int int ), 0, this, resources, n, n2);
    }

    public boolean replaceTargetDrawablesIfPresent(ComponentName componentName, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("replaceTargetDrawablesIfPresent", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView$replaceTargetDrawablesIfPresent(android.content.ComponentName java.lang.String int ), 0, this, componentName, string2, n);
    }

    static {
        RobolectricInternals.classInitializing(GlowPadView.class);
    }

    public /* synthetic */ GlowPadView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GlowPadView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class AnimationBundle
    extends ArrayList<Tweener> {
        public transient /* synthetic */ Object __robo_data__;
        private static long serialVersionUID = -6319262269245852568L;
        private boolean mSuspended;
        /* synthetic */ GlowPadView this$0;

        private void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$__constructor__(GlowPadView glowPadView) {
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$start() {
            if (this.mSuspended) {
                return;
            }
            int count = this.size();
            for (int i = 0; i < count; ++i) {
                Tweener anim2 = (Tweener)this.get(i);
                anim2.animator.start();
            }
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$cancel() {
            int count = this.size();
            for (int i = 0; i < count; ++i) {
                Tweener anim2 = (Tweener)this.get(i);
                anim2.animator.cancel();
            }
            this.clear();
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$stop() {
            int count = this.size();
            for (int i = 0; i < count; ++i) {
                Tweener anim2 = (Tweener)this.get(i);
                anim2.animator.end();
            }
            this.clear();
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$setSuspended(boolean suspend) {
            this.mSuspended = suspend;
        }

        private /* synthetic */ void $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$__constructor__(GlowPadView x0, 1 x1) {
        }

        private void __constructor__(GlowPadView glowPadView) {
            this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$__constructor__(glowPadView);
        }

        private AnimationBundle(GlowPadView glowPadView) {
            this.this$0 = glowPadView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$__constructor__(com.android.internal.widget.multiwaveview.GlowPadView ), 0, this, glowPadView);
        }

        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$start(), 0, this);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$cancel(), 0, this);
        }

        public void stop() {
            InvokeDynamicSupport.bootstrap("stop", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$stop(), 0, this);
        }

        public void setSuspended(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSuspended", $$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$setSuspended(boolean ), 0, this, bl);
        }

        private /* synthetic */ void __constructor__(GlowPadView glowPadView, 1 var2_2) {
            this.$$robo$$com_android_internal_widget_multiwaveview_GlowPadView_AnimationBundle$__constructor__(glowPadView, var2_2);
        }

        public /* synthetic */ AnimationBundle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnimationBundle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnTriggerListener
    extends InstrumentedInterface {
        public static final int NO_HANDLE = 0;
        public static final int CENTER_HANDLE = 1;

        public void onGrabbed(View var1, int var2);

        public void onReleased(View var1, int var2);

        public void onTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);

        public void onFinishFinalAnimation();
    }
}

