/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.FloatMath;
import android.util.Log;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PointCloud
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float MIN_POINT_SIZE = 2.0f;
    private static float MAX_POINT_SIZE = 4.0f;
    private static int INNER_POINTS = 8;
    private static String TAG = "PointCloud";
    private ArrayList<Point> mPointCloud;
    private Drawable mDrawable;
    private float mCenterX;
    private float mCenterY;
    private Paint mPaint;
    private float mScale;
    private static float PI = (float)Math.PI;
    WaveManager waveManager;
    GlowManager glowManager;
    private float mOuterRadius;

    private void $$robo$$com_android_internal_widget_multiwaveview_PointCloud$__constructor__(Drawable drawable2) {
        this.mPointCloud = new ArrayList();
        this.mScale = 1.0f;
        this.waveManager = new WaveManager(this);
        this.glowManager = new GlowManager(this);
        this.mPaint = new Paint();
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setColor(Color.rgb(255, 255, 255));
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mDrawable = drawable2;
        if (this.mDrawable != null) {
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud$setCenter(float x, float y) {
        this.mCenterX = x;
        this.mCenterY = y;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud$makePointCloud(float innerRadius, float outerRadius) {
        if (innerRadius == 0.0f) {
            Log.w("PointCloud", "Must specify an inner radius");
            return;
        }
        this.mOuterRadius = outerRadius;
        this.mPointCloud.clear();
        float pointAreaRadius = outerRadius - innerRadius;
        float ds = (float)Math.PI * 2 * innerRadius / 8.0f;
        int bands = Math.round(pointAreaRadius / ds);
        float dr = pointAreaRadius / (float)bands;
        float r = innerRadius;
        int b = 0;
        while (b <= bands) {
            float circumference = (float)Math.PI * 2 * r;
            int pointsInBand = (int)(circumference / ds);
            float eta = 1.5707964f;
            float dEta = (float)Math.PI * 2 / (float)pointsInBand;
            for (int i = 0; i < pointsInBand; ++i) {
                float x = r * FloatMath.cos(eta);
                float y = r * FloatMath.sin(eta);
                eta += dEta;
                this.mPointCloud.add(new Point(this, x, y, r));
            }
            ++b;
            r += dr;
        }
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud$setScale(float scale) {
        this.mScale = scale;
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud$getScale() {
        return this.mScale;
    }

    private static final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud$hypot(float x, float y) {
        return FloatMath.sqrt(x * x + y * y);
    }

    private static final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud$max(float a, float b) {
        return a > b ? a : b;
    }

    private final int $$robo$$com_android_internal_widget_multiwaveview_PointCloud$getAlphaForPoint(Point point) {
        float glowDistance = PointCloud.hypot(this.glowManager.x - point.x, this.glowManager.y - point.y);
        float glowAlpha = 0.0f;
        if (glowDistance < this.glowManager.radius) {
            float cosf = FloatMath.cos(0.7853982f * glowDistance / this.glowManager.radius);
            glowAlpha = this.glowManager.alpha * PointCloud.max(0.0f, (float)Math.pow(cosf, 10.0));
        }
        float radius = PointCloud.hypot(point.x, point.y);
        float waveAlpha = 0.0f;
        if (radius < this.waveManager.radius * 2.0f) {
            float distanceToWaveRing = radius - this.waveManager.radius;
            float cosf = FloatMath.cos(1.5707964f * distanceToWaveRing / this.waveManager.radius);
            waveAlpha = this.waveManager.alpha * PointCloud.max(0.0f, (float)Math.pow(cosf, 6.0));
        }
        return (int)(PointCloud.max(glowAlpha, waveAlpha) * 255.0f);
    }

    private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud$interp(float min, float max, float f) {
        return min + (max - min) * f;
    }

    private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud$draw(Canvas canvas) {
        ArrayList<Point> points = this.mPointCloud;
        canvas.save(1);
        canvas.scale(this.mScale, this.mScale, this.mCenterX, this.mCenterY);
        for (int i = 0; i < points.size(); ++i) {
            Point point = points.get(i);
            float pointSize = this.interp(4.0f, 2.0f, point.radius / this.mOuterRadius);
            float px = point.x + this.mCenterX;
            float py = point.y + this.mCenterY;
            int alpha = this.getAlphaForPoint(point);
            if (alpha == 0) continue;
            if (this.mDrawable != null) {
                canvas.save(1);
                float cx = (float)this.mDrawable.getIntrinsicWidth() * 0.5f;
                float cy = (float)this.mDrawable.getIntrinsicHeight() * 0.5f;
                float s = pointSize / 4.0f;
                canvas.scale(s, s, px, py);
                canvas.translate(px - cx, py - cy);
                this.mDrawable.setAlpha(alpha);
                this.mDrawable.draw(canvas);
                canvas.restore();
                continue;
            }
            this.mPaint.setAlpha(alpha);
            canvas.drawCircle(px, py, pointSize, this.mPaint);
        }
        canvas.restore();
    }

    private void __constructor__(Drawable drawable2) {
        this.$$robo$$com_android_internal_widget_multiwaveview_PointCloud$__constructor__(drawable2);
    }

    public PointCloud(Drawable drawable2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$__constructor__(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setCenter(float f, float f2) {
        InvokeDynamicSupport.bootstrap("setCenter", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$setCenter(float float ), 0, this, f, f2);
    }

    public void makePointCloud(float f, float f2) {
        InvokeDynamicSupport.bootstrap("makePointCloud", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$makePointCloud(float float ), 0, this, f, f2);
    }

    public void setScale(float f) {
        InvokeDynamicSupport.bootstrap("setScale", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$setScale(float ), 0, this, f);
    }

    public float getScale() {
        return (float)InvokeDynamicSupport.bootstrap("getScale", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$getScale(), 0, this);
    }

    private static float hypot(float f, float f2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("hypot", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$hypot(float float ), 0, (float)f, (float)f2);
    }

    private static float max(float f, float f2) {
        return (float)InvokeDynamicSupport.bootstrapStatic("max", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$max(float float ), 0, (float)f, (float)f2);
    }

    public int getAlphaForPoint(Point point) {
        return (int)InvokeDynamicSupport.bootstrap("getAlphaForPoint", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$getAlphaForPoint(com.android.internal.widget.multiwaveview.PointCloud$Point ), 0, this, point);
    }

    private float interp(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrap("interp", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$interp(float float float ), 0, this, f, f2, f3);
    }

    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$com_android_internal_widget_multiwaveview_PointCloud$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    public /* synthetic */ PointCloud() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PointCloud)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Point
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float x;
        float y;
        float radius;
        /* synthetic */ PointCloud this$0;

        private void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_Point$__constructor__(PointCloud pointCloud, float x2, float y2, float r) {
            this.x = x2;
            this.y = y2;
            this.radius = r;
        }

        private void __constructor__(PointCloud pointCloud, float f, float f2, float f3) {
            this.$$robo$$com_android_internal_widget_multiwaveview_PointCloud_Point$__constructor__(pointCloud, f, f2, f3);
        }

        public Point(PointCloud pointCloud, float f, float f2, float f3) {
            this.this$0 = pointCloud;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_Point$__constructor__(com.android.internal.widget.multiwaveview.PointCloud float float float ), 0, this, pointCloud, f, f2, f3);
        }

        public /* synthetic */ Point() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Point)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class GlowManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float x;
        private float y;
        private float radius;
        private float alpha;
        /* synthetic */ PointCloud this$0;

        private void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$__constructor__(PointCloud pointCloud) {
            this.radius = 0.0f;
            this.alpha = 0.0f;
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setX(float x1) {
            this.x = x1;
        }

        private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getX() {
            return this.x;
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setY(float y1) {
            this.y = y1;
        }

        private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getY() {
            return this.y;
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setAlpha(float a) {
            this.alpha = a;
        }

        private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getAlpha() {
            return this.alpha;
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setRadius(float r) {
            this.radius = r;
        }

        private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getRadius() {
            return this.radius;
        }

        private void __constructor__(PointCloud pointCloud) {
            this.$$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$__constructor__(pointCloud);
        }

        public GlowManager(PointCloud pointCloud) {
            this.this$0 = pointCloud;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$__constructor__(com.android.internal.widget.multiwaveview.PointCloud ), 0, this, pointCloud);
        }

        public void setX(float f) {
            InvokeDynamicSupport.bootstrap("setX", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setX(float ), 0, this, f);
        }

        public float getX() {
            return (float)InvokeDynamicSupport.bootstrap("getX", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getX(), 0, this);
        }

        public void setY(float f) {
            InvokeDynamicSupport.bootstrap("setY", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setY(float ), 0, this, f);
        }

        public float getY() {
            return (float)InvokeDynamicSupport.bootstrap("getY", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getY(), 0, this);
        }

        public void setAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setAlpha(float ), 0, this, f);
        }

        public float getAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getAlpha(), 0, this);
        }

        public void setRadius(float f) {
            InvokeDynamicSupport.bootstrap("setRadius", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$setRadius(float ), 0, this, f);
        }

        public float getRadius() {
            return (float)InvokeDynamicSupport.bootstrap("getRadius", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_GlowManager$getRadius(), 0, this);
        }

        public /* synthetic */ GlowManager() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GlowManager)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class WaveManager
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float radius;
        private float alpha;
        /* synthetic */ PointCloud this$0;

        private void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$__constructor__(PointCloud pointCloud) {
            this.radius = 50.0f;
            this.alpha = 0.0f;
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$setRadius(float r) {
            this.radius = r;
        }

        private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$getRadius() {
            return this.radius;
        }

        private final void $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$setAlpha(float a) {
            this.alpha = a;
        }

        private final float $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$getAlpha() {
            return this.alpha;
        }

        private void __constructor__(PointCloud pointCloud) {
            this.$$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$__constructor__(pointCloud);
        }

        public WaveManager(PointCloud pointCloud) {
            this.this$0 = pointCloud;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$__constructor__(com.android.internal.widget.multiwaveview.PointCloud ), 0, this, pointCloud);
        }

        public void setRadius(float f) {
            InvokeDynamicSupport.bootstrap("setRadius", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$setRadius(float ), 0, this, f);
        }

        public float getRadius() {
            return (float)InvokeDynamicSupport.bootstrap("getRadius", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$getRadius(), 0, this);
        }

        public void setAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$setAlpha(float ), 0, this, f);
        }

        public float getAlpha() {
            return (float)InvokeDynamicSupport.bootstrap("getAlpha", $$robo$$com_android_internal_widget_multiwaveview_PointCloud_WaveManager$getAlpha(), 0, this);
        }

        public /* synthetic */ WaveManager() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaveManager)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

