/*
 * Decompiled with CFR 0.152.
 */
package com.android.okio;

import com.android.okio.BufferedSink;
import com.android.okio.Deadline;
import com.android.okio.OkBuffer;
import com.android.okio.Okio;
import com.android.okio.Segment;
import com.android.okio.SegmentPool;
import com.android.okio.Sink;
import com.android.okio.Util;
import java.io.IOException;
import java.util.zip.Deflater;

public final class DeflaterSink
implements Sink {
    private final BufferedSink sink;
    private final Deflater deflater;
    private boolean closed;

    public DeflaterSink(Sink sink, Deflater deflater) {
        this.sink = Okio.buffer(sink);
        this.deflater = deflater;
    }

    @Override
    public void write(OkBuffer source, long byteCount) throws IOException {
        Util.checkOffsetAndCount(source.size, 0L, byteCount);
        while (byteCount > 0L) {
            Segment head = source.head;
            int toDeflate = (int)Math.min(byteCount, (long)(head.limit - head.pos));
            this.deflater.setInput(head.data, head.pos, toDeflate);
            this.deflate(false);
            source.size -= (long)toDeflate;
            head.pos += toDeflate;
            if (head.pos == head.limit) {
                source.head = head.pop();
                SegmentPool.INSTANCE.recycle(head);
            }
            byteCount -= (long)toDeflate;
        }
    }

    private void deflate(boolean syncFlush) throws IOException {
        OkBuffer buffer = this.sink.buffer();
        while (true) {
            int deflated;
            Segment s = buffer.writableSegment(1);
            int n = deflated = syncFlush ? this.deflater.deflate(s.data, s.limit, 2048 - s.limit, 2) : this.deflater.deflate(s.data, s.limit, 2048 - s.limit);
            if (deflated > 0) {
                s.limit += deflated;
                buffer.size += (long)deflated;
                this.sink.emitCompleteSegments();
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
    }

    @Override
    public void flush() throws IOException {
        this.deflate(true);
        this.sink.flush();
    }

    @Override
    public void close() throws IOException {
        Throwable thrown;
        block9: {
            block8: {
                if (this.closed) {
                    return;
                }
                thrown = null;
                try {
                    this.deflater.finish();
                    this.deflate(false);
                }
                catch (Throwable e) {
                    thrown = e;
                }
                try {
                    this.deflater.end();
                }
                catch (Throwable e) {
                    if (thrown != null) break block8;
                    thrown = e;
                }
            }
            try {
                this.sink.close();
            }
            catch (Throwable e) {
                if (thrown != null) break block9;
                thrown = e;
            }
        }
        this.closed = true;
        if (thrown != null) {
            Util.sneakyRethrow(thrown);
        }
    }

    @Override
    public Sink deadline(Deadline deadline) {
        this.sink.deadline(deadline);
        return this;
    }

    public String toString() {
        return "DeflaterSink(" + this.sink + ")";
    }
}

