/*
 * Decompiled with CFR 0.152.
 */
package com.android.okio;

import com.android.okio.SegmentPool;

final class Segment {
    static final int SIZE = 2048;
    final byte[] data = new byte[2048];
    int pos;
    int limit;
    Segment next;
    Segment prev;

    Segment() {
    }

    public Segment pop() {
        Segment result = this.next != this ? this.next : null;
        this.prev.next = this.next;
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return result;
    }

    public Segment push(Segment segment) {
        segment.prev = this;
        segment.next = this.next;
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    public Segment split(int byteCount) {
        int aSize = byteCount;
        int bSize = this.limit - this.pos - byteCount;
        if (aSize <= 0 || bSize <= 0) {
            throw new IllegalArgumentException();
        }
        if (aSize < bSize) {
            Segment before = SegmentPool.INSTANCE.take();
            System.arraycopy((byte[])this.data, (int)this.pos, (byte[])before.data, (int)before.pos, (int)aSize);
            this.pos += aSize;
            before.limit += aSize;
            this.prev.push(before);
            return before;
        }
        Segment after = SegmentPool.INSTANCE.take();
        System.arraycopy((byte[])this.data, (int)(this.pos + aSize), (byte[])after.data, (int)after.pos, (int)bSize);
        this.limit -= bSize;
        after.limit += bSize;
        this.push(after);
        return this;
    }

    public void compact() {
        if (this.prev == this) {
            throw new IllegalStateException();
        }
        if (this.prev.limit - this.prev.pos + (this.limit - this.pos) > 2048) {
            return;
        }
        this.writeTo(this.prev, this.limit - this.pos);
        this.pop();
        SegmentPool.INSTANCE.recycle(this);
    }

    public void writeTo(Segment sink, int byteCount) {
        if (byteCount + (sink.limit - sink.pos) > 2048) {
            throw new IllegalArgumentException();
        }
        if (sink.limit + byteCount > 2048) {
            System.arraycopy((byte[])sink.data, (int)sink.pos, (byte[])sink.data, (int)0, (int)(sink.limit - sink.pos));
            sink.limit -= sink.pos;
            sink.pos = 0;
        }
        System.arraycopy((byte[])this.data, (int)this.pos, (byte[])sink.data, (int)sink.limit, (int)byteCount);
        sink.limit += byteCount;
        this.pos += byteCount;
    }
}

