/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.OpenSSLBIOInputStream;
import com.android.org.conscrypt.OpenSSLDigestContext;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.net.ssl.SSLException;
import javax.security.auth.x500.X500Principal;

public final class NativeCrypto {
    public static final int EC_CURVE_GFP = 1;
    public static final int EC_CURVE_GF2M = 2;
    public static final int OPENSSL_EC_NAMED_CURVE = 1;
    public static final int POINT_CONVERSION_COMPRESSED = 2;
    public static final int POINT_CONVERSION_UNCOMPRESSED = 4;
    public static final int POINT_CONVERSION_HYBRID = 4;
    public static final int RAND_SEED_LENGTH_IN_BYTES = 1024;
    public static final int GN_STACK_SUBJECT_ALT_NAME = 1;
    public static final int GN_STACK_ISSUER_ALT_NAME = 2;
    public static final int EXTENSION_TYPE_NON_CRITICAL = 0;
    public static final int EXTENSION_TYPE_CRITICAL = 1;
    public static final int EXFLAG_CA = 16;
    public static final int EXFLAG_CRITICAL = 512;
    public static final int PKCS7_CERTS = 1;
    public static final int PKCS7_CRLS = 2;
    private static final String SUPPORTED_PROTOCOL_SSLV3 = "SSLv3";
    private static final String SUPPORTED_PROTOCOL_TLSV1 = "TLSv1";
    private static final String SUPPORTED_PROTOCOL_TLSV1_1 = "TLSv1.1";
    private static final String SUPPORTED_PROTOCOL_TLSV1_2 = "TLSv1.2";
    public static final Map<String, String> OPENSSL_TO_STANDARD_CIPHER_SUITES;
    public static final Map<String, String> STANDARD_TO_OPENSSL_CIPHER_SUITES;
    public static final String TLS_EMPTY_RENEGOTIATION_INFO_SCSV = "TLS_EMPTY_RENEGOTIATION_INFO_SCSV";
    public static final String TLS_FALLBACK_SCSV = "TLS_FALLBACK_SCSV";
    private static final String[] SUPPORTED_CIPHER_SUITES;
    public static final int EVP_PKEY_RSA = 6;
    public static final int EVP_PKEY_DSA = 116;
    public static final int EVP_PKEY_DH = 28;
    public static final int EVP_PKEY_EC = 408;
    public static final int EVP_PKEY_HMAC = 855;
    public static final int EVP_PKEY_CMAC = 894;
    public static final int RSA_PKCS1_PADDING = 1;
    public static final int RSA_NO_PADDING = 3;
    public static final long SSL_MODE_HANDSHAKE_CUTTHROUGH = 128L;
    public static final long SSL_MODE_CBC_RECORD_SPLITTING = 256L;
    public static final long SSL_MODE_SEND_FALLBACK_SCSV = 512L;
    public static final long SSL_OP_TLSEXT_PADDING = 16L;
    public static final long SSL_OP_NO_TICKET = 16384L;
    public static final long SSL_OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 65536L;
    public static final long SSL_OP_NO_SSLv3 = 0x2000000L;
    public static final long SSL_OP_NO_TLSv1 = 0x4000000L;
    public static final long SSL_OP_NO_TLSv1_1 = 0x10000000L;
    public static final long SSL_OP_NO_TLSv1_2 = 0x8000000L;
    public static final byte TLS_CT_RSA_SIGN = 1;
    public static final byte TLS_CT_DSS_SIGN = 2;
    public static final byte TLS_CT_RSA_FIXED_DH = 3;
    public static final byte TLS_CT_DSS_FIXED_DH = 4;
    public static final byte TLS_CT_ECDSA_SIGN = 64;
    public static final byte TLS_CT_RSA_FIXED_ECDH = 65;
    public static final byte TLS_CT_ECDSA_FIXED_ECDH = 66;
    public static final int SSL_SENT_SHUTDOWN = 1;
    public static final int SSL_RECEIVED_SHUTDOWN = 2;
    static final String[] DEFAULT_X509_CIPHER_SUITES;
    static final String[] DEFAULT_PSK_CIPHER_SUITES;
    public static final String[] DEFAULT_PROTOCOLS;
    public static final int SSL_kRSA = 1;
    public static final int SSL_kDHr = 2;
    public static final int SSL_kDHd = 4;
    public static final int SSL_kEDH = 8;
    public static final int SSL_kKRB5 = 16;
    public static final int SSL_kECDHr = 32;
    public static final int SSL_kECDHe = 64;
    public static final int SSL_kEECDH = 128;
    public static final int SSL_kPSK = 256;
    public static final int SSL_kGOST = 512;
    public static final int SSL_kSRP = 1024;
    public static final int SSL_aRSA = 1;
    public static final int SSL_aDSS = 2;
    public static final int SSL_aNULL = 4;
    public static final int SSL_aDH = 8;
    public static final int SSL_aECDH = 16;
    public static final int SSL_aKRB5 = 32;
    public static final int SSL_aECDSA = 64;
    public static final int SSL_aPSK = 128;
    public static final int SSL_aGOST94 = 256;
    public static final int SSL_aGOST01 = 512;
    public static final int SSL_VERIFY_NONE = 0;
    public static final int SSL_VERIFY_PEER = 1;
    public static final int SSL_VERIFY_FAIL_IF_NO_PEER_CERT = 2;
    public static final int SSL_ST_CONNECT = 4096;
    public static final int SSL_ST_ACCEPT = 8192;
    public static final int SSL_ST_MASK = 4095;
    public static final int SSL_ST_INIT = 12288;
    public static final int SSL_ST_BEFORE = 16384;
    public static final int SSL_ST_OK = 3;
    public static final int SSL_ST_RENEGOTIATE = 12292;
    public static final int SSL_CB_LOOP = 1;
    public static final int SSL_CB_EXIT = 2;
    public static final int SSL_CB_READ = 4;
    public static final int SSL_CB_WRITE = 8;
    public static final int SSL_CB_ALERT = 16384;
    public static final int SSL_CB_READ_ALERT = 16388;
    public static final int SSL_CB_WRITE_ALERT = 16392;
    public static final int SSL_CB_ACCEPT_LOOP = 8193;
    public static final int SSL_CB_ACCEPT_EXIT = 8194;
    public static final int SSL_CB_CONNECT_LOOP = 4097;
    public static final int SSL_CB_CONNECT_EXIT = 4098;
    public static final int SSL_CB_HANDSHAKE_START = 16;
    public static final int SSL_CB_HANDSHAKE_DONE = 32;
    public static final int SSL3_RT_HEADER_LENGTH = 5;
    public static final int SSL_RT_MAX_CIPHER_BLOCK_SIZE = 16;
    public static final int SSL3_RT_MAX_MD_SIZE = 64;
    public static final int SSL3_RT_MAX_PLAIN_LENGTH = 16384;
    public static final int SSL3_RT_MAX_ENCRYPTED_OVERHEAD = 320;
    public static final int SSL3_RT_SEND_MAX_ENCRYPTED_OVERHEAD = 80;
    public static final int SSL3_RT_MAX_COMPRESSED_LENGTH = 16384;
    public static final int SSL3_RT_MAX_ENCRYPTED_LENGTH = 16704;
    public static final int SSL3_RT_MAX_PACKET_SIZE = 16709;

    private static native void clinit();

    public static native void ENGINE_load_dynamic();

    public static native long ENGINE_by_id(String var0);

    public static native int ENGINE_add(long var0);

    public static native int ENGINE_init(long var0);

    public static native int ENGINE_finish(long var0);

    public static native int ENGINE_free(long var0);

    public static native long ENGINE_load_private_key(long var0, String var2);

    public static native String ENGINE_get_id(long var0);

    public static native int ENGINE_ctrl_cmd_string(long var0, String var2, String var3, int var4);

    public static native long EVP_PKEY_new_DSA(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public static native long EVP_PKEY_new_RSA(byte[] var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7);

    public static native long EVP_PKEY_new_mac_key(int var0, byte[] var1);

    public static native int EVP_PKEY_size(long var0);

    public static native int EVP_PKEY_type(long var0);

    public static native String EVP_PKEY_print_public(long var0);

    public static native String EVP_PKEY_print_private(long var0);

    public static native void EVP_PKEY_free(long var0);

    public static native int EVP_PKEY_cmp(long var0, long var2);

    public static native byte[] i2d_PKCS8_PRIV_KEY_INFO(long var0);

    public static native long d2i_PKCS8_PRIV_KEY_INFO(byte[] var0);

    public static native byte[] i2d_PUBKEY(long var0);

    public static native long d2i_PUBKEY(byte[] var0);

    public static native long getRSAPrivateKeyWrapper(RSAPrivateKey var0, byte[] var1);

    public static native long getDSAPrivateKeyWrapper(DSAPrivateKey var0);

    public static native long getECPrivateKeyWrapper(ECPrivateKey var0, long var1);

    public static native long RSA_generate_key_ex(int var0, byte[] var1);

    public static native int RSA_size(long var0);

    public static native int RSA_private_encrypt(int var0, byte[] var1, byte[] var2, long var3, int var5);

    public static native int RSA_public_decrypt(int var0, byte[] var1, byte[] var2, long var3, int var5) throws BadPaddingException, SignatureException;

    public static native int RSA_public_encrypt(int var0, byte[] var1, byte[] var2, long var3, int var5);

    public static native int RSA_private_decrypt(int var0, byte[] var1, byte[] var2, long var3, int var5) throws BadPaddingException, SignatureException;

    public static native byte[][] get_RSA_public_params(long var0);

    public static native byte[][] get_RSA_private_params(long var0);

    public static native long DSA_generate_key(int var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public static native byte[][] get_DSA_params(long var0);

    public static native void set_DSA_flag_nonce_from_hash(long var0);

    public static native byte[] i2d_RSAPublicKey(long var0);

    public static native byte[] i2d_RSAPrivateKey(long var0);

    public static native byte[] i2d_DSAPublicKey(long var0);

    public static native byte[] i2d_DSAPrivateKey(long var0);

    public static native long EVP_PKEY_new_DH(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native long DH_generate_parameters_ex(int var0, long var1);

    public static native void DH_generate_key(long var0);

    public static native byte[][] get_DH_params(long var0);

    public static native long EVP_PKEY_new_EC_KEY(long var0, long var2, byte[] var4);

    public static native long EC_GROUP_new_by_curve_name(String var0);

    public static native long EC_GROUP_new_curve(int var0, byte[] var1, byte[] var2, byte[] var3);

    public static native long EC_GROUP_dup(long var0);

    public static native void EC_GROUP_set_asn1_flag(long var0, int var2);

    public static native void EC_GROUP_set_point_conversion_form(long var0, int var2);

    public static native String EC_GROUP_get_curve_name(long var0);

    public static native byte[][] EC_GROUP_get_curve(long var0);

    public static native void EC_GROUP_clear_free(long var0);

    public static native boolean EC_GROUP_cmp(long var0, long var2);

    public static native void EC_GROUP_set_generator(long var0, long var2, byte[] var4, byte[] var5);

    public static native long EC_GROUP_get_generator(long var0);

    public static native int get_EC_GROUP_type(long var0);

    public static native byte[] EC_GROUP_get_order(long var0);

    public static native int EC_GROUP_get_degree(long var0);

    public static native byte[] EC_GROUP_get_cofactor(long var0);

    public static native long EC_POINT_new(long var0);

    public static native void EC_POINT_clear_free(long var0);

    public static native boolean EC_POINT_cmp(long var0, long var2, long var4);

    public static native byte[][] EC_POINT_get_affine_coordinates(long var0, long var2);

    public static native void EC_POINT_set_affine_coordinates(long var0, long var2, byte[] var4, byte[] var5);

    public static native long EC_KEY_generate_key(long var0);

    public static native long EC_KEY_get0_group(long var0);

    public static native byte[] EC_KEY_get_private_key(long var0);

    public static native long EC_KEY_get_public_key(long var0);

    public static native void EC_KEY_set_nonce_from_hash(long var0, boolean var2);

    public static native int ECDH_compute_key(byte[] var0, int var1, long var2, long var4);

    public static native long EVP_get_digestbyname(String var0);

    public static native int EVP_MD_size(long var0);

    public static native int EVP_MD_block_size(long var0);

    public static native long EVP_MD_CTX_create();

    public static native void EVP_MD_CTX_init(OpenSSLDigestContext var0);

    public static native void EVP_MD_CTX_destroy(long var0);

    public static native int EVP_MD_CTX_copy(OpenSSLDigestContext var0, OpenSSLDigestContext var1);

    public static native int EVP_DigestInit(OpenSSLDigestContext var0, long var1);

    public static native void EVP_DigestUpdate(OpenSSLDigestContext var0, byte[] var1, int var2, int var3);

    public static native int EVP_DigestFinal(OpenSSLDigestContext var0, byte[] var1, int var2);

    public static native void EVP_DigestSignInit(OpenSSLDigestContext var0, long var1, long var3);

    public static native void EVP_DigestSignUpdate(OpenSSLDigestContext var0, byte[] var1);

    public static native byte[] EVP_DigestSignFinal(OpenSSLDigestContext var0);

    public static native int EVP_SignInit(OpenSSLDigestContext var0, long var1);

    public static native void EVP_SignUpdate(OpenSSLDigestContext var0, byte[] var1, int var2, int var3);

    public static native int EVP_SignFinal(OpenSSLDigestContext var0, byte[] var1, int var2, long var3);

    public static native int EVP_VerifyInit(OpenSSLDigestContext var0, long var1);

    public static native void EVP_VerifyUpdate(OpenSSLDigestContext var0, byte[] var1, int var2, int var3);

    public static native int EVP_VerifyFinal(OpenSSLDigestContext var0, byte[] var1, int var2, int var3, long var4);

    public static native long EVP_get_cipherbyname(String var0);

    public static native void EVP_CipherInit_ex(long var0, long var2, byte[] var4, byte[] var5, boolean var6);

    public static native int EVP_CipherUpdate(long var0, byte[] var2, int var3, byte[] var4, int var5, int var6);

    public static native int EVP_CipherFinal_ex(long var0, byte[] var2, int var3) throws BadPaddingException, IllegalBlockSizeException;

    public static native int EVP_CIPHER_iv_length(long var0);

    public static native long EVP_CIPHER_CTX_new();

    public static native int EVP_CIPHER_CTX_block_size(long var0);

    public static native int get_EVP_CIPHER_CTX_buf_len(long var0);

    public static native void EVP_CIPHER_CTX_set_padding(long var0, boolean var2);

    public static native void EVP_CIPHER_CTX_set_key_length(long var0, int var2);

    public static native void EVP_CIPHER_CTX_cleanup(long var0);

    public static native void RAND_seed(byte[] var0);

    public static native int RAND_load_file(String var0, long var1);

    public static native void RAND_bytes(byte[] var0);

    public static native int OBJ_txt2nid(String var0);

    public static native String OBJ_txt2nid_longName(String var0);

    public static native String OBJ_txt2nid_oid(String var0);

    public static int X509_NAME_hash(X500Principal principal) {
        return NativeCrypto.X509_NAME_hash(principal, "SHA1");
    }

    public static int X509_NAME_hash_old(X500Principal principal) {
        return NativeCrypto.X509_NAME_hash(principal, "MD5");
    }

    private static int X509_NAME_hash(X500Principal principal, String algorithm) {
        try {
            byte[] digest = MessageDigest.getInstance(algorithm).digest(principal.getEncoded());
            int offset = 0;
            return (digest[offset++] & 0xFF) << 0 | (digest[offset++] & 0xFF) << 8 | (digest[offset++] & 0xFF) << 16 | (digest[offset] & 0xFF) << 24;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static native String X509_NAME_print_ex(long var0, long var2);

    public static native long d2i_X509_bio(long var0);

    public static native long d2i_X509(byte[] var0);

    public static native long PEM_read_bio_X509(long var0);

    public static native byte[] i2d_X509(long var0);

    public static native byte[] i2d_X509_PUBKEY(long var0);

    public static native byte[] ASN1_seq_pack_X509(long[] var0);

    public static native long[] ASN1_seq_unpack_X509_bio(long var0);

    public static native void X509_free(long var0);

    public static native int X509_cmp(long var0, long var2);

    public static native int get_X509_hashCode(long var0);

    public static native void X509_print_ex(long var0, long var2, long var4, long var6);

    public static native byte[] X509_get_issuer_name(long var0);

    public static native byte[] X509_get_subject_name(long var0);

    public static native String get_X509_sig_alg_oid(long var0);

    public static native byte[] get_X509_sig_alg_parameter(long var0);

    public static native boolean[] get_X509_issuerUID(long var0);

    public static native boolean[] get_X509_subjectUID(long var0);

    public static native long X509_get_pubkey(long var0) throws NoSuchAlgorithmException;

    public static native String get_X509_pubkey_oid(long var0);

    public static native byte[] X509_get_ext_oid(long var0, String var2);

    public static native String[] get_X509_ext_oids(long var0, int var2);

    public static native Object[][] get_X509_GENERAL_NAME_stack(long var0, int var2) throws CertificateParsingException;

    public static native boolean[] get_X509_ex_kusage(long var0);

    public static native String[] get_X509_ex_xkusage(long var0);

    public static native int get_X509_ex_pathlen(long var0);

    public static native long X509_get_notBefore(long var0);

    public static native long X509_get_notAfter(long var0);

    public static native long X509_get_version(long var0);

    public static native byte[] X509_get_serialNumber(long var0);

    public static native void X509_verify(long var0, long var2) throws BadPaddingException;

    public static native byte[] get_X509_cert_info_enc(long var0);

    public static native byte[] get_X509_signature(long var0);

    public static native int get_X509_ex_flags(long var0);

    public static native int X509_check_issued(long var0, long var2);

    public static native long[] d2i_PKCS7_bio(long var0, int var2);

    public static native byte[] i2d_PKCS7(long[] var0);

    public static native long[] PEM_read_bio_PKCS7(long var0, int var2);

    public static native long d2i_X509_CRL_bio(long var0);

    public static native long PEM_read_bio_X509_CRL(long var0);

    public static native byte[] i2d_X509_CRL(long var0);

    public static native void X509_CRL_free(long var0);

    public static native void X509_CRL_print(long var0, long var2);

    public static native String get_X509_CRL_sig_alg_oid(long var0);

    public static native byte[] get_X509_CRL_sig_alg_parameter(long var0);

    public static native byte[] X509_CRL_get_issuer_name(long var0);

    public static native long X509_CRL_get0_by_cert(long var0, long var2);

    public static native long X509_CRL_get0_by_serial(long var0, byte[] var2);

    public static native long[] X509_CRL_get_REVOKED(long var0);

    public static native String[] get_X509_CRL_ext_oids(long var0, int var2);

    public static native byte[] X509_CRL_get_ext_oid(long var0, String var2);

    public static native long X509_CRL_get_version(long var0);

    public static native long X509_CRL_get_ext(long var0, String var2);

    public static native byte[] get_X509_CRL_signature(long var0);

    public static native void X509_CRL_verify(long var0, long var2);

    public static native byte[] get_X509_CRL_crl_enc(long var0);

    public static native long X509_CRL_get_lastUpdate(long var0);

    public static native long X509_CRL_get_nextUpdate(long var0);

    public static native long X509_REVOKED_dup(long var0);

    public static native byte[] i2d_X509_REVOKED(long var0);

    public static native String[] get_X509_REVOKED_ext_oids(long var0, int var2);

    public static native byte[] X509_REVOKED_get_ext_oid(long var0, String var2);

    public static native byte[] X509_REVOKED_get_serialNumber(long var0);

    public static native long X509_REVOKED_get_ext(long var0, String var2);

    public static native long get_X509_REVOKED_revocationDate(long var0);

    public static native void X509_REVOKED_print(long var0, long var2);

    public static native int X509_supported_extension(long var0);

    public static native void ASN1_TIME_to_Calendar(long var0, Calendar var2);

    public static native long create_BIO_InputStream(OpenSSLBIOInputStream var0);

    public static native long create_BIO_OutputStream(OutputStream var0);

    public static native int BIO_read(long var0, byte[] var2);

    public static native void BIO_write(long var0, byte[] var2, int var3, int var4) throws IOException;

    public static native void BIO_free_all(long var0);

    private static void add(String standard, String openssl) {
        OPENSSL_TO_STANDARD_CIPHER_SUITES.put(openssl, standard);
        STANDARD_TO_OPENSSL_CIPHER_SUITES.put(standard, openssl);
    }

    public static native long SSL_CTX_new();

    public static String[] getSupportedCipherSuites() {
        return (String[])SUPPORTED_CIPHER_SUITES.clone();
    }

    public static native void SSL_CTX_free(long var0);

    public static native void SSL_CTX_set_session_id_context(long var0, byte[] var2);

    public static native long SSL_new(long var0) throws SSLException;

    public static native void SSL_enable_tls_channel_id(long var0) throws SSLException;

    public static native byte[] SSL_get_tls_channel_id(long var0) throws SSLException;

    public static native void SSL_set1_tls_channel_id(long var0, long var2);

    public static native void SSL_use_certificate(long var0, long[] var2);

    public static native void SSL_use_PrivateKey(long var0, long var2);

    public static native void SSL_check_private_key(long var0) throws SSLException;

    public static native void SSL_set_client_CA_list(long var0, byte[][] var2);

    public static native long SSL_get_mode(long var0);

    public static native long SSL_set_mode(long var0, long var2);

    public static native long SSL_clear_mode(long var0, long var2);

    public static native long SSL_get_options(long var0);

    public static native long SSL_set_options(long var0, long var2);

    public static native long SSL_clear_options(long var0, long var2);

    public static native void SSL_use_psk_identity_hint(long var0, String var2) throws SSLException;

    public static native void set_SSL_psk_client_callback_enabled(long var0, boolean var2);

    public static native void set_SSL_psk_server_callback_enabled(long var0, boolean var2);

    public static String[] getSupportedProtocols() {
        return new String[]{SUPPORTED_PROTOCOL_SSLV3, SUPPORTED_PROTOCOL_TLSV1, SUPPORTED_PROTOCOL_TLSV1_1, SUPPORTED_PROTOCOL_TLSV1_2};
    }

    public static void setEnabledProtocols(long ssl, String[] protocols) {
        NativeCrypto.checkEnabledProtocols(protocols);
        long optionsToSet = 0x1E000000L;
        long optionsToClear = 0L;
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            if (protocol.equals(SUPPORTED_PROTOCOL_SSLV3)) {
                optionsToSet &= 0xFFFFFFFFFDFFFFFFL;
                optionsToClear |= 0x2000000L;
                continue;
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_TLSV1)) {
                optionsToSet &= 0xFFFFFFFFFBFFFFFFL;
                optionsToClear |= 0x4000000L;
                continue;
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_TLSV1_1)) {
                optionsToSet &= 0xFFFFFFFFEFFFFFFFL;
                optionsToClear |= 0x10000000L;
                continue;
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_TLSV1_2)) {
                optionsToSet &= 0xFFFFFFFFF7FFFFFFL;
                optionsToClear |= 0x8000000L;
                continue;
            }
            throw new IllegalStateException();
        }
        NativeCrypto.SSL_set_options(ssl, optionsToSet);
        NativeCrypto.SSL_clear_options(ssl, optionsToClear);
    }

    public static String[] checkEnabledProtocols(String[] protocols) {
        if (protocols == null) {
            throw new IllegalArgumentException("protocols == null");
        }
        for (int i = 0; i < protocols.length; ++i) {
            String protocol = protocols[i];
            if (protocol == null) {
                throw new IllegalArgumentException("protocols[" + i + "] == null");
            }
            if (protocol.equals(SUPPORTED_PROTOCOL_SSLV3) || protocol.equals(SUPPORTED_PROTOCOL_TLSV1) || protocol.equals(SUPPORTED_PROTOCOL_TLSV1_1) || protocol.equals(SUPPORTED_PROTOCOL_TLSV1_2)) continue;
            throw new IllegalArgumentException("protocol " + protocol + " is not supported");
        }
        return protocols;
    }

    public static native void SSL_set_cipher_lists(long var0, String[] var2);

    public static native long[] SSL_get_ciphers(long var0);

    public static native int get_SSL_CIPHER_algorithm_mkey(long var0);

    public static native int get_SSL_CIPHER_algorithm_auth(long var0);

    public static void setEnabledCipherSuites(long ssl, String[] cipherSuites) {
        NativeCrypto.checkEnabledCipherSuites(cipherSuites);
        ArrayList<String> opensslSuites = new ArrayList<String>();
        for (int i = 0; i < cipherSuites.length; ++i) {
            String cipherSuite = cipherSuites[i];
            if (cipherSuite.equals(TLS_EMPTY_RENEGOTIATION_INFO_SCSV)) continue;
            if (cipherSuite.equals(TLS_FALLBACK_SCSV)) {
                NativeCrypto.SSL_set_mode(ssl, 512L);
                continue;
            }
            String openssl = STANDARD_TO_OPENSSL_CIPHER_SUITES.get(cipherSuite);
            String cs = openssl == null ? cipherSuite : openssl;
            opensslSuites.add(cs);
        }
        NativeCrypto.SSL_set_cipher_lists(ssl, opensslSuites.toArray(new String[opensslSuites.size()]));
    }

    public static String[] checkEnabledCipherSuites(String[] cipherSuites) {
        if (cipherSuites == null) {
            throw new IllegalArgumentException("cipherSuites == null");
        }
        for (int i = 0; i < cipherSuites.length; ++i) {
            String cipherSuite = cipherSuites[i];
            if (cipherSuite == null) {
                throw new IllegalArgumentException("cipherSuites[" + i + "] == null");
            }
            if (cipherSuite.equals(TLS_EMPTY_RENEGOTIATION_INFO_SCSV) || cipherSuite.equals(TLS_FALLBACK_SCSV) || STANDARD_TO_OPENSSL_CIPHER_SUITES.containsKey(cipherSuite) || OPENSSL_TO_STANDARD_CIPHER_SUITES.containsKey(cipherSuite)) continue;
            throw new IllegalArgumentException("cipherSuite " + cipherSuite + " is not supported.");
        }
        return cipherSuites;
    }

    public static native void SSL_set_accept_state(long var0);

    public static native void SSL_set_connect_state(long var0);

    public static native void SSL_set_verify(long var0, int var2);

    public static native void SSL_set_session(long var0, long var2) throws SSLException;

    public static native void SSL_set_session_creation_enabled(long var0, boolean var2) throws SSLException;

    public static native void SSL_set_tlsext_host_name(long var0, String var2) throws SSLException;

    public static native String SSL_get_servername(long var0);

    public static native void SSL_CTX_enable_npn(long var0);

    public static native void SSL_CTX_disable_npn(long var0);

    public static native int SSL_set_alpn_protos(long var0, byte[] var2);

    public static native byte[] SSL_get0_alpn_selected(long var0);

    public static native long SSL_do_handshake(long var0, FileDescriptor var2, SSLHandshakeCallbacks var3, int var4, boolean var5, byte[] var6, byte[] var7) throws SSLException, SocketTimeoutException, CertificateException;

    public static native long SSL_do_handshake_bio(long var0, long var2, long var4, SSLHandshakeCallbacks var6, boolean var7, byte[] var8, byte[] var9) throws SSLException, SocketTimeoutException, CertificateException;

    public static native byte[] SSL_get_npn_negotiated_protocol(long var0);

    public static native void SSL_renegotiate(long var0) throws SSLException;

    public static native long[] SSL_get_certificate(long var0);

    public static native long[] SSL_get_peer_cert_chain(long var0);

    public static native int SSL_read(long var0, FileDescriptor var2, SSLHandshakeCallbacks var3, byte[] var4, int var5, int var6, int var7) throws IOException;

    public static native int SSL_read_BIO(long var0, byte[] var2, int var3, int var4, long var5, long var7, SSLHandshakeCallbacks var9) throws IOException;

    public static native void SSL_write(long var0, FileDescriptor var2, SSLHandshakeCallbacks var3, byte[] var4, int var5, int var6, int var7) throws IOException;

    public static native int SSL_write_BIO(long var0, byte[] var2, int var3, long var4, SSLHandshakeCallbacks var6) throws IOException;

    public static native void SSL_interrupt(long var0);

    public static native void SSL_shutdown(long var0, FileDescriptor var2, SSLHandshakeCallbacks var3) throws IOException;

    public static native void SSL_shutdown_BIO(long var0, long var2, long var4, SSLHandshakeCallbacks var6) throws IOException;

    public static native int SSL_get_shutdown(long var0);

    public static native void SSL_free(long var0);

    public static native byte[] SSL_SESSION_session_id(long var0);

    public static native long SSL_SESSION_get_time(long var0);

    public static native String SSL_SESSION_get_version(long var0);

    public static native String SSL_SESSION_cipher(long var0);

    public static native void SSL_SESSION_free(long var0);

    public static native byte[] i2d_SSL_SESSION(long var0);

    public static native long d2i_SSL_SESSION(byte[] var0);

    public static native long ERR_peek_last_error();

    static {
        if ("com.android.org.conscrypt".equals(NativeCrypto.class.getPackage().getName())) {
            System.loadLibrary("javacrypto");
        } else if ("com.google.android.gms.org.conscrypt".equals(NativeCrypto.class.getPackage().getName())) {
            System.loadLibrary("gmscore");
            System.loadLibrary("conscrypt_gmscore_jni");
        } else {
            System.loadLibrary("conscrypt_jni");
        }
        NativeCrypto.clinit();
        OPENSSL_TO_STANDARD_CIPHER_SUITES = new HashMap<String, String>();
        STANDARD_TO_OPENSSL_CIPHER_SUITES = new LinkedHashMap<String, String>();
        NativeCrypto.add("SSL_RSA_WITH_RC4_128_MD5", "RC4-MD5");
        NativeCrypto.add("SSL_RSA_WITH_RC4_128_SHA", "RC4-SHA");
        NativeCrypto.add("TLS_RSA_WITH_AES_128_CBC_SHA", "AES128-SHA");
        NativeCrypto.add("TLS_RSA_WITH_AES_256_CBC_SHA", "AES256-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_RC4_128_SHA", "ECDH-ECDSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA", "ECDH-ECDSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "ECDH-ECDSA-AES256-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_RC4_128_SHA", "ECDH-RSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA", "ECDH-RSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "ECDH-RSA-AES256-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "ECDHE-ECDSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "ECDHE-ECDSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "ECDHE-ECDSA-AES256-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_RC4_128_SHA", "ECDHE-RSA-RC4-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "ECDHE-RSA-AES128-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "ECDHE-RSA-AES256-SHA");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "DHE-RSA-AES128-SHA");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "DHE-RSA-AES256-SHA");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "DHE-DSS-AES128-SHA");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "DHE-DSS-AES256-SHA");
        NativeCrypto.add("SSL_RSA_WITH_3DES_EDE_CBC_SHA", "DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA", "ECDH-ECDSA-DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA", "ECDH-RSA-DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", "ECDHE-ECDSA-DES-CBC3-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", "ECDHE-RSA-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA", "EDH-RSA-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA", "EDH-DSS-DES-CBC3-SHA");
        NativeCrypto.add("SSL_RSA_WITH_DES_CBC_SHA", "DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_RSA_WITH_DES_CBC_SHA", "EDH-RSA-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_DSS_WITH_DES_CBC_SHA", "EDH-DSS-DES-CBC-SHA");
        NativeCrypto.add("SSL_RSA_EXPORT_WITH_RC4_40_MD5", "EXP-RC4-MD5");
        NativeCrypto.add("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-RSA-DES-CBC-SHA");
        NativeCrypto.add("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "EXP-EDH-DSS-DES-CBC-SHA");
        NativeCrypto.add("SSL_RSA_WITH_NULL_MD5", "NULL-MD5");
        NativeCrypto.add("SSL_RSA_WITH_NULL_SHA", "NULL-SHA");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_NULL_SHA", "ECDH-ECDSA-NULL-SHA");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_NULL_SHA", "ECDH-RSA-NULL-SHA");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_NULL_SHA", "ECDHE-ECDSA-NULL-SHA");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_NULL_SHA", "ECDHE-RSA-NULL-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_RC4_128_MD5", "ADH-RC4-MD5");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_128_CBC_SHA", "ADH-AES128-SHA");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_256_CBC_SHA", "ADH-AES256-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA", "ADH-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DH_anon_WITH_DES_CBC_SHA", "ADH-DES-CBC-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_RC4_128_SHA", "AECDH-RC4-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_AES_128_CBC_SHA", "AECDH-AES128-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_AES_256_CBC_SHA", "AECDH-AES256-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA", "AECDH-DES-CBC3-SHA");
        NativeCrypto.add("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5", "EXP-ADH-RC4-MD5");
        NativeCrypto.add("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA", "EXP-ADH-DES-CBC-SHA");
        NativeCrypto.add("TLS_ECDH_anon_WITH_NULL_SHA", "AECDH-NULL-SHA");
        NativeCrypto.add("TLS_RSA_WITH_NULL_SHA256", "NULL-SHA256");
        NativeCrypto.add("TLS_RSA_WITH_AES_128_CBC_SHA256", "AES128-SHA256");
        NativeCrypto.add("TLS_RSA_WITH_AES_256_CBC_SHA256", "AES256-SHA256");
        NativeCrypto.add("TLS_RSA_WITH_AES_128_GCM_SHA256", "AES128-GCM-SHA256");
        NativeCrypto.add("TLS_RSA_WITH_AES_256_GCM_SHA384", "AES256-GCM-SHA384");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "DHE-RSA-AES128-SHA256");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "DHE-RSA-AES256-SHA256");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "DHE-RSA-AES128-GCM-SHA256");
        NativeCrypto.add("TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "DHE-RSA-AES256-GCM-SHA384");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "DHE-DSS-AES128-SHA256");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", "DHE-DSS-AES256-SHA256");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "DHE-DSS-AES128-GCM-SHA256");
        NativeCrypto.add("TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "DHE-DSS-AES256-GCM-SHA384");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256", "ECDH-RSA-AES128-SHA256");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384", "ECDH-RSA-AES256-SHA384");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256", "ECDH-RSA-AES128-GCM-SHA256");
        NativeCrypto.add("TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384", "ECDH-RSA-AES256-GCM-SHA384");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256", "ECDH-ECDSA-AES128-SHA256");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384", "ECDH-ECDSA-AES256-SHA384");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256", "ECDH-ECDSA-AES128-GCM-SHA256");
        NativeCrypto.add("TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384", "ECDH-ECDSA-AES256-GCM-SHA384");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "ECDHE-RSA-AES128-SHA256");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "ECDHE-RSA-AES256-SHA384");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "ECDHE-RSA-AES128-GCM-SHA256");
        NativeCrypto.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "ECDHE-RSA-AES256-GCM-SHA384");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "ECDHE-ECDSA-AES128-SHA256");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "ECDHE-ECDSA-AES256-SHA384");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "ECDHE-ECDSA-AES128-GCM-SHA256");
        NativeCrypto.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "ECDHE-ECDSA-AES256-GCM-SHA384");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_128_CBC_SHA256", "ADH-AES128-SHA256");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_256_CBC_SHA256", "ADH-AES256-SHA256");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_128_GCM_SHA256", "ADH-AES128-GCM-SHA256");
        NativeCrypto.add("TLS_DH_anon_WITH_AES_256_GCM_SHA384", "ADH-AES256-GCM-SHA384");
        NativeCrypto.add("TLS_PSK_WITH_3DES_EDE_CBC_SHA", "PSK-3DES-EDE-CBC-SHA");
        NativeCrypto.add("TLS_PSK_WITH_AES_128_CBC_SHA", "PSK-AES128-CBC-SHA");
        NativeCrypto.add("TLS_PSK_WITH_AES_256_CBC_SHA", "PSK-AES256-CBC-SHA");
        NativeCrypto.add("TLS_PSK_WITH_RC4_128_SHA", "PSK-RC4-SHA");
        NativeCrypto.add("TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", "ECDHE-PSK-AES128-CBC-SHA");
        NativeCrypto.add("TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", "ECDHE-PSK-AES256-CBC-SHA");
        int size = STANDARD_TO_OPENSSL_CIPHER_SUITES.size();
        SUPPORTED_CIPHER_SUITES = new String[size + 2];
        STANDARD_TO_OPENSSL_CIPHER_SUITES.keySet().toArray(SUPPORTED_CIPHER_SUITES);
        NativeCrypto.SUPPORTED_CIPHER_SUITES[size] = TLS_EMPTY_RENEGOTIATION_INFO_SCSV;
        NativeCrypto.SUPPORTED_CIPHER_SUITES[size + 1] = TLS_FALLBACK_SCSV;
        DEFAULT_X509_CIPHER_SUITES = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", "TLS_ECDHE_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "SSL_RSA_WITH_RC4_128_SHA"};
        DEFAULT_PSK_CIPHER_SUITES = new String[]{"TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA", "TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA", "TLS_PSK_WITH_AES_128_CBC_SHA", "TLS_PSK_WITH_AES_256_CBC_SHA"};
        DEFAULT_PROTOCOLS = new String[]{SUPPORTED_PROTOCOL_SSLV3, SUPPORTED_PROTOCOL_TLSV1, SUPPORTED_PROTOCOL_TLSV1_1, SUPPORTED_PROTOCOL_TLSV1_2};
    }

    public static interface SSLHandshakeCallbacks {
        public void verifyCertificateChain(long var1, long[] var3, String var4) throws CertificateException;

        public void clientCertificateRequested(byte[] var1, byte[][] var2) throws CertificateEncodingException, SSLException;

        public int clientPSKKeyRequested(String var1, byte[] var2, byte[] var3);

        public int serverPSKKeyRequested(String var1, String var2, byte[] var3);

        public void onSSLStateChange(long var1, int var3, int var4);
    }
}

