/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLCipherContext;
import com.android.org.conscrypt.util.EmptyArray;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class OpenSSLCipher
extends CipherSpi {
    private OpenSSLCipherContext cipherCtx = new OpenSSLCipherContext(NativeCrypto.EVP_CIPHER_CTX_new());
    private Mode mode = Mode.ECB;
    private Padding padding = Padding.PKCS5PADDING;
    private byte[] encodedKey;
    private byte[] iv;
    private boolean encrypting;
    private int blockSize;
    private int modeBlockSize;
    private boolean calledUpdate;

    protected OpenSSLCipher() {
    }

    protected OpenSSLCipher(Mode mode, Padding padding) {
        this.mode = mode;
        this.padding = padding;
        this.blockSize = this.getCipherBlockSize();
    }

    protected abstract String getBaseCipherName();

    protected abstract String getCipherName(int var1, Mode var2);

    protected abstract void checkSupportedKeySize(int var1) throws InvalidKeyException;

    protected abstract void checkSupportedMode(Mode var1) throws NoSuchAlgorithmException;

    protected abstract void checkSupportedPadding(Padding var1) throws NoSuchPaddingException;

    protected abstract int getCipherBlockSize();

    protected boolean supportsVariableSizeKey() {
        return false;
    }

    @Override
    protected void engineSetMode(String modeStr) throws NoSuchAlgorithmException {
        Mode mode;
        try {
            mode = Mode.valueOf(modeStr.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            NoSuchAlgorithmException newE = new NoSuchAlgorithmException("No such mode: " + modeStr);
            newE.initCause(e);
            throw newE;
        }
        this.checkSupportedMode(mode);
        this.mode = mode;
    }

    @Override
    protected void engineSetPadding(String paddingStr) throws NoSuchPaddingException {
        Padding padding;
        String paddingStrUpper = paddingStr.toUpperCase(Locale.US);
        try {
            padding = Padding.valueOf(paddingStrUpper);
        }
        catch (IllegalArgumentException e) {
            NoSuchPaddingException newE = new NoSuchPaddingException("No such padding: " + paddingStr);
            newE.initCause(e);
            throw newE;
        }
        this.checkSupportedPadding(padding);
        this.padding = padding;
    }

    @Override
    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    private int getOutputSize(int inputLen) {
        if (this.modeBlockSize == 1) {
            return inputLen;
        }
        int buffered = NativeCrypto.get_EVP_CIPHER_CTX_buf_len(this.cipherCtx.getContext());
        if (this.padding == Padding.NOPADDING) {
            return buffered + inputLen;
        }
        int totalLen = inputLen + buffered + this.modeBlockSize;
        return totalLen - totalLen % this.modeBlockSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.getOutputSize(inputLen);
    }

    @Override
    protected byte[] engineGetIV() {
        return this.iv;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.iv != null && this.iv.length > 0) {
            try {
                AlgorithmParameters params = AlgorithmParameters.getInstance(this.getBaseCipherName());
                params.init(this.iv);
                return params;
            }
            catch (NoSuchAlgorithmException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    private void engineInitInternal(int opmode, Key key, byte[] iv, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opmode == 1 || opmode == 3) {
            this.encrypting = true;
        } else if (opmode == 2 || opmode == 4) {
            this.encrypting = false;
        } else {
            throw new InvalidParameterException("Unsupported opmode " + opmode);
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Only SecretKey is supported");
        }
        byte[] encodedKey = key.getEncoded();
        if (encodedKey == null) {
            throw new InvalidKeyException("key.getEncoded() == null");
        }
        this.checkSupportedKeySize(encodedKey.length);
        this.encodedKey = encodedKey;
        long cipherType = NativeCrypto.EVP_get_cipherbyname(this.getCipherName(encodedKey.length, this.mode));
        if (cipherType == 0L) {
            throw new InvalidAlgorithmParameterException("Cannot find name for key length = " + encodedKey.length * 8 + " and mode = " + (Object)((Object)this.mode));
        }
        int ivLength = NativeCrypto.EVP_CIPHER_iv_length(cipherType);
        if (iv == null && ivLength != 0) {
            iv = new byte[ivLength];
            if (this.encrypting) {
                if (random == null) {
                    random = new SecureRandom();
                }
                random.nextBytes(iv);
            }
        } else if (iv != null && iv.length != ivLength) {
            throw new InvalidAlgorithmParameterException("expected IV length of " + ivLength);
        }
        this.iv = iv;
        if (this.supportsVariableSizeKey()) {
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx.getContext(), cipherType, null, null, this.encrypting);
            NativeCrypto.EVP_CIPHER_CTX_set_key_length(this.cipherCtx.getContext(), encodedKey.length);
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx.getContext(), 0L, encodedKey, iv, this.encrypting);
        } else {
            NativeCrypto.EVP_CipherInit_ex(this.cipherCtx.getContext(), cipherType, encodedKey, iv, this.encrypting);
        }
        NativeCrypto.EVP_CIPHER_CTX_set_padding(this.cipherCtx.getContext(), this.padding == Padding.PKCS5PADDING);
        this.modeBlockSize = NativeCrypto.EVP_CIPHER_CTX_block_size(this.cipherCtx.getContext());
        this.calledUpdate = false;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInitInternal(opmode, key, null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] iv;
        if (params instanceof IvParameterSpec) {
            IvParameterSpec ivParams = (IvParameterSpec)params;
            iv = ivParams.getIV();
        } else {
            iv = null;
        }
        this.engineInitInternal(opmode, key, iv, random);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IvParameterSpec spec;
        if (params != null) {
            try {
                spec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
        } else {
            spec = null;
        }
        this.engineInit(opmode, key, spec, random);
    }

    private final int updateInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws ShortBufferException {
        int intialOutputOffset = outputOffset;
        int bytesLeft = output.length - outputOffset;
        if (bytesLeft < maximumLen) {
            throw new ShortBufferException("output buffer too small during update: " + bytesLeft + " < " + maximumLen);
        }
        outputOffset += NativeCrypto.EVP_CipherUpdate(this.cipherCtx.getContext(), output, outputOffset, input, inputOffset, inputLen);
        this.calledUpdate = true;
        return outputOffset - intialOutputOffset;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        int bytesWritten;
        int maximumLen = this.getOutputSize(inputLen);
        byte[] output = maximumLen > 0 ? new byte[maximumLen] : EmptyArray.BYTE;
        try {
            bytesWritten = this.updateInternal(input, inputOffset, inputLen, output, 0, maximumLen);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException("calculated buffer size was wrong: " + maximumLen);
        }
        if (output.length == bytesWritten) {
            return output;
        }
        if (bytesWritten == 0) {
            return EmptyArray.BYTE;
        }
        return Arrays.copyOfRange(output, 0, bytesWritten);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        int maximumLen = this.getOutputSize(inputLen);
        return this.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
    }

    private void reset() {
        NativeCrypto.EVP_CipherInit_ex(this.cipherCtx.getContext(), 0L, this.encodedKey, this.iv, this.encrypting);
        this.calledUpdate = false;
    }

    private int doFinalInternal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, int maximumLen) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        int writtenBytes;
        int initialOutputOffset = outputOffset;
        if (inputLen > 0) {
            int updateBytesWritten = this.updateInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
            outputOffset += updateBytesWritten;
            maximumLen -= updateBytesWritten;
        }
        if (!this.encrypting && !this.calledUpdate) {
            return 0;
        }
        int bytesLeft = output.length - outputOffset;
        if (bytesLeft >= maximumLen) {
            writtenBytes = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx.getContext(), output, outputOffset);
        } else {
            byte[] lastBlock = new byte[maximumLen];
            writtenBytes = NativeCrypto.EVP_CipherFinal_ex(this.cipherCtx.getContext(), lastBlock, 0);
            if (writtenBytes > bytesLeft) {
                throw new ShortBufferException("buffer is too short: " + writtenBytes + " > " + bytesLeft);
            }
            if (writtenBytes > 0) {
                System.arraycopy((byte[])lastBlock, (int)0, (byte[])output, (int)outputOffset, (int)writtenBytes);
            }
        }
        this.reset();
        return (outputOffset += writtenBytes) - initialOutputOffset;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        int bytesWritten;
        if (!this.encrypting && !this.calledUpdate && inputLen == 0) {
            this.reset();
            return null;
        }
        int maximumLen = this.getOutputSize(inputLen);
        byte[] output = new byte[maximumLen];
        try {
            bytesWritten = this.doFinalInternal(input, inputOffset, inputLen, output, 0, maximumLen);
        }
        catch (ShortBufferException e) {
            throw new RuntimeException("our calculated buffer was too small", e);
        }
        if (bytesWritten == output.length) {
            return output;
        }
        if (bytesWritten == 0) {
            return EmptyArray.BYTE;
        }
        return Arrays.copyOfRange(output, 0, bytesWritten);
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        if (output == null) {
            throw new NullPointerException("output == null");
        }
        int maximumLen = this.getOutputSize(inputLen);
        return this.doFinalInternal(input, inputOffset, inputLen, output, outputOffset, maximumLen);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        try {
            byte[] encoded = key.getEncoded();
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            IllegalBlockSizeException newE = new IllegalBlockSizeException();
            newE.initCause(e);
            throw newE;
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] encoded = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            if (wrappedKeyType == 1) {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                return keyFactory.generatePublic(new X509EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 2) {
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(encoded));
            }
            if (wrappedKeyType == 3) {
                return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
            }
            throw new UnsupportedOperationException("wrappedKeyType == " + wrappedKeyType);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException(e);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException(e);
        }
    }

    public static class ARC4
    extends OpenSSLCipher {
        @Override
        protected String getBaseCipherName() {
            return "ARCFOUR";
        }

        @Override
        protected String getCipherName(int keySize, Mode mode) {
            return "rc4";
        }

        @Override
        protected void checkSupportedKeySize(int keySize) throws InvalidKeyException {
        }

        @Override
        protected void checkSupportedMode(Mode mode) throws NoSuchAlgorithmException {
            throw new NoSuchAlgorithmException("ARC4 does not support modes");
        }

        @Override
        protected void checkSupportedPadding(Padding padding) throws NoSuchPaddingException {
            throw new NoSuchPaddingException("ARC4 does not support padding");
        }

        @Override
        protected int getCipherBlockSize() {
            return 0;
        }

        @Override
        protected boolean supportsVariableSizeKey() {
            return true;
        }
    }

    public static class DESEDE
    extends OpenSSLCipher {
        private static int DES_BLOCK_SIZE = 8;

        public DESEDE(Mode mode, Padding padding) {
            super(mode, padding);
        }

        @Override
        protected String getBaseCipherName() {
            return "DESede";
        }

        @Override
        protected String getCipherName(int keySize, Mode mode) {
            String baseCipherName = keySize == 16 ? "des-ede" : "des-ede3";
            if (mode == Mode.ECB) {
                return baseCipherName;
            }
            return baseCipherName + "-" + mode.toString().toLowerCase(Locale.US);
        }

        @Override
        protected void checkSupportedKeySize(int keySize) throws InvalidKeyException {
            if (keySize != 16 && keySize != 24) {
                throw new InvalidKeyException("key size must be 128 or 192 bits");
            }
        }

        @Override
        protected void checkSupportedMode(Mode mode) throws NoSuchAlgorithmException {
            switch (mode) {
                case CBC: 
                case CFB: 
                case CFB1: 
                case CFB8: 
                case ECB: 
                case OFB: {
                    return;
                }
            }
            throw new NoSuchAlgorithmException("Unsupported mode " + mode.toString());
        }

        @Override
        protected void checkSupportedPadding(Padding padding) throws NoSuchPaddingException {
            switch (padding) {
                case NOPADDING: 
                case PKCS5PADDING: {
                    return;
                }
            }
            throw new NoSuchPaddingException("Unsupported padding " + padding.toString());
        }

        @Override
        protected int getCipherBlockSize() {
            return DES_BLOCK_SIZE;
        }

        public static class OFB
        extends DESEDE {
            public OFB() {
                super(Mode.OFB, Padding.NOPADDING);
            }
        }

        public static class ECB
        extends DESEDE {
            public ECB(Padding padding) {
                super(Mode.ECB, padding);
            }

            public static class PKCS5Padding
            extends ECB {
                public PKCS5Padding() {
                    super(Padding.PKCS5PADDING);
                }
            }

            public static class NoPadding
            extends ECB {
                public NoPadding() {
                    super(Padding.NOPADDING);
                }
            }
        }

        public static class CFB
        extends DESEDE {
            public CFB() {
                super(Mode.CFB, Padding.NOPADDING);
            }
        }

        public static class CBC
        extends DESEDE {
            public CBC(Padding padding) {
                super(Mode.CBC, padding);
            }

            public static class PKCS5Padding
            extends CBC {
                public PKCS5Padding() {
                    super(Padding.PKCS5PADDING);
                }
            }

            public static class NoPadding
            extends CBC {
                public NoPadding() {
                    super(Padding.NOPADDING);
                }
            }
        }
    }

    public static class AES
    extends OpenSSLCipher {
        private static final int AES_BLOCK_SIZE = 16;

        protected AES(Mode mode, Padding padding) {
            super(mode, padding);
        }

        @Override
        protected void checkSupportedKeySize(int keyLength) throws InvalidKeyException {
            switch (keyLength) {
                case 16: 
                case 24: 
                case 32: {
                    return;
                }
            }
            throw new InvalidKeyException("Unsupported key size: " + keyLength + " bytes");
        }

        @Override
        protected void checkSupportedMode(Mode mode) throws NoSuchAlgorithmException {
            switch (mode) {
                case CBC: 
                case CFB: 
                case CFB1: 
                case CFB8: 
                case CFB128: 
                case CTR: 
                case ECB: 
                case OFB: {
                    return;
                }
            }
            throw new NoSuchAlgorithmException("Unsupported mode " + mode.toString());
        }

        @Override
        protected void checkSupportedPadding(Padding padding) throws NoSuchPaddingException {
            switch (padding) {
                case NOPADDING: 
                case PKCS5PADDING: {
                    return;
                }
            }
            throw new NoSuchPaddingException("Unsupported padding " + padding.toString());
        }

        @Override
        protected String getBaseCipherName() {
            return "AES";
        }

        @Override
        protected String getCipherName(int keyLength, Mode mode) {
            return "aes-" + keyLength * 8 + "-" + mode.toString().toLowerCase(Locale.US);
        }

        @Override
        protected int getCipherBlockSize() {
            return 16;
        }

        public static class OFB
        extends AES {
            public OFB() {
                super(Mode.OFB, Padding.NOPADDING);
            }
        }

        public static class ECB
        extends AES {
            public ECB(Padding padding) {
                super(Mode.ECB, padding);
            }

            public static class PKCS5Padding
            extends ECB {
                public PKCS5Padding() {
                    super(Padding.PKCS5PADDING);
                }
            }

            public static class NoPadding
            extends ECB {
                public NoPadding() {
                    super(Padding.NOPADDING);
                }
            }
        }

        public static class CTR
        extends AES {
            public CTR() {
                super(Mode.CTR, Padding.NOPADDING);
            }
        }

        public static class CFB
        extends AES {
            public CFB() {
                super(Mode.CFB, Padding.NOPADDING);
            }
        }

        public static class CBC
        extends AES {
            public CBC(Padding padding) {
                super(Mode.CBC, padding);
            }

            public static class PKCS5Padding
            extends CBC {
                public PKCS5Padding() {
                    super(Padding.PKCS5PADDING);
                }
            }

            public static class NoPadding
            extends CBC {
                public NoPadding() {
                    super(Padding.NOPADDING);
                }
            }
        }
    }

    protected static enum Padding {
        NOPADDING,
        PKCS5PADDING,
        ISO10126PADDING;

    }

    protected static enum Mode {
        CBC,
        CFB,
        CFB1,
        CFB8,
        CFB128,
        CTR,
        CTS,
        ECB,
        OFB,
        OFB64,
        OFB128,
        PCBC;

    }
}

