/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLKey;
import com.android.org.conscrypt.OpenSSLKeyHolder;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class OpenSSLDHPublicKey
implements DHPublicKey,
OpenSSLKeyHolder {
    private static final long serialVersionUID = 6123717708079837723L;
    private transient OpenSSLKey key;
    private transient byte[] p;
    private transient byte[] g;
    private transient byte[] y;
    private final transient Object mParamsLock = new Object();
    private transient boolean readParams;

    OpenSSLDHPublicKey(OpenSSLKey key) {
        this.key = key;
    }

    @Override
    public OpenSSLKey getOpenSSLKey() {
        return this.key;
    }

    OpenSSLDHPublicKey(DHPublicKeySpec dsaKeySpec) throws InvalidKeySpecException {
        try {
            this.key = new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DH(dsaKeySpec.getP().toByteArray(), dsaKeySpec.getG().toByteArray(), dsaKeySpec.getY().toByteArray(), null));
        }
        catch (Exception e) {
            throw new InvalidKeySpecException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureReadParams() {
        Object object = this.mParamsLock;
        synchronized (object) {
            if (this.readParams) {
                return;
            }
            byte[][] params = NativeCrypto.get_DH_params(this.key.getPkeyContext());
            this.p = params[0];
            this.g = params[1];
            this.y = params[2];
            this.readParams = true;
        }
    }

    static OpenSSLKey getInstance(DHPublicKey DHPublicKey2) throws InvalidKeyException {
        try {
            DHParameterSpec dhParams = DHPublicKey2.getParams();
            return new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DH(dhParams.getP().toByteArray(), dhParams.getG().toByteArray(), DHPublicKey2.getY().toByteArray(), null));
        }
        catch (Exception e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    public DHParameterSpec getParams() {
        this.ensureReadParams();
        return new DHParameterSpec(new BigInteger(this.p), new BigInteger(this.g));
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return NativeCrypto.i2d_PUBKEY(this.key.getPkeyContext());
    }

    @Override
    public BigInteger getY() {
        this.ensureReadParams();
        return new BigInteger(this.y);
    }

    public boolean equals(Object o) {
        DHPublicKey other;
        if (o == this) {
            return true;
        }
        if (o instanceof OpenSSLDHPublicKey && this.key.equals(((OpenSSLDHPublicKey)(other = (OpenSSLDHPublicKey)o)).getOpenSSLKey())) {
            return true;
        }
        if (!(o instanceof DHPublicKey)) {
            return false;
        }
        this.ensureReadParams();
        other = (DHPublicKey)o;
        if (!this.y.equals(other.getY())) {
            return false;
        }
        DHParameterSpec spec = other.getParams();
        return this.g.equals(spec.getG()) && this.p.equals(spec.getP());
    }

    public int hashCode() {
        this.ensureReadParams();
        int hash = 1;
        hash = hash * 3 + this.y.hashCode();
        hash = hash * 7 + this.p.hashCode();
        hash = hash * 13 + this.g.hashCode();
        return hash;
    }

    public String toString() {
        this.ensureReadParams();
        StringBuilder sb = new StringBuilder("OpenSSLDHPublicKey{");
        sb.append("Y=");
        sb.append(new BigInteger(this.y).toString(16));
        sb.append(',');
        sb.append("P=");
        sb.append(new BigInteger(this.p).toString(16));
        sb.append(',');
        sb.append("G=");
        sb.append(new BigInteger(this.g).toString(16));
        sb.append('}');
        return sb.toString();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        BigInteger g = (BigInteger)stream.readObject();
        BigInteger p = (BigInteger)stream.readObject();
        BigInteger y = (BigInteger)stream.readObject();
        this.key = new OpenSSLKey(NativeCrypto.EVP_PKEY_new_DH(p.toByteArray(), g.toByteArray(), y.toByteArray(), null));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        this.ensureReadParams();
        stream.writeObject(new BigInteger(this.g));
        stream.writeObject(new BigInteger(this.p));
        stream.writeObject(new BigInteger(this.y));
    }
}

