/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.Platform;
import java.security.Provider;

public final class OpenSSLProvider
extends Provider {
    private static final long serialVersionUID = 2996752495318905136L;
    public static final String PROVIDER_NAME = "AndroidOpenSSL";

    public OpenSSLProvider() {
        this(PROVIDER_NAME);
    }

    public OpenSSLProvider(String providerName) {
        super(providerName, 1.0, "Android's OpenSSL-backed security provider");
        Platform.setup();
        String prefix = this.getClass().getPackage().getName() + ".";
        String classOpenSSLContextImpl = prefix + "OpenSSLContextImpl";
        this.put("SSLContext.SSL", classOpenSSLContextImpl);
        this.put("SSLContext.SSLv3", classOpenSSLContextImpl);
        this.put("SSLContext.TLS", classOpenSSLContextImpl);
        this.put("SSLContext.TLSv1", classOpenSSLContextImpl);
        this.put("SSLContext.TLSv1.1", classOpenSSLContextImpl);
        this.put("SSLContext.TLSv1.2", classOpenSSLContextImpl);
        this.put("SSLContext.Default", prefix + "DefaultSSLContextImpl");
        this.put("MessageDigest.SHA-1", prefix + "OpenSSLMessageDigestJDK$SHA1");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        this.put("Alg.Alias.MessageDigest.SHA", "SHA-1");
        this.put("Alg.Alias.MessageDigest.1.3.14.3.2.26", "SHA-1");
        this.put("MessageDigest.SHA-224", prefix + "OpenSSLMessageDigestJDK$SHA224");
        this.put("Alg.Alias.MessageDigest.SHA224", "SHA-224");
        this.put("Alg.Alias.MessageDigest.2.16.840.1.101.3.4.2.4", "SHA-224");
        this.put("MessageDigest.SHA-256", prefix + "OpenSSLMessageDigestJDK$SHA256");
        this.put("Alg.Alias.MessageDigest.SHA256", "SHA-256");
        this.put("Alg.Alias.MessageDigest.2.16.840.1.101.3.4.2.1", "SHA-256");
        this.put("MessageDigest.SHA-384", prefix + "OpenSSLMessageDigestJDK$SHA384");
        this.put("Alg.Alias.MessageDigest.SHA384", "SHA-384");
        this.put("Alg.Alias.MessageDigest.2.16.840.1.101.3.4.2.2", "SHA-384");
        this.put("MessageDigest.SHA-512", prefix + "OpenSSLMessageDigestJDK$SHA512");
        this.put("Alg.Alias.MessageDigest.SHA512", "SHA-512");
        this.put("Alg.Alias.MessageDigest.2.16.840.1.101.3.4.2.3", "SHA-512");
        this.put("MessageDigest.MD5", prefix + "OpenSSLMessageDigestJDK$MD5");
        this.put("Alg.Alias.MessageDigest.1.2.840.113549.2.5", "MD5");
        this.put("KeyPairGenerator.RSA", prefix + "OpenSSLRSAKeyPairGenerator");
        this.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.1.1", "RSA");
        this.put("KeyPairGenerator.DH", prefix + "OpenSSLDHKeyPairGenerator");
        this.put("Alg.Alias.KeyPairGenerator.1.2.840.113549.1.3.1", "DH");
        this.put("KeyPairGenerator.DSA", prefix + "OpenSSLDSAKeyPairGenerator");
        this.put("KeyPairGenerator.EC", prefix + "OpenSSLECKeyPairGenerator");
        this.put("KeyFactory.RSA", prefix + "OpenSSLRSAKeyFactory");
        this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.1.1", "RSA");
        this.put("KeyFactory.DH", prefix + "OpenSSLDHKeyFactory");
        this.put("Alg.Alias.KeyFactory.1.2.840.113549.1.3.1", "DH");
        this.put("KeyFactory.DSA", prefix + "OpenSSLDSAKeyFactory");
        this.put("KeyFactory.EC", prefix + "OpenSSLECKeyFactory");
        this.put("KeyAgreement.ECDH", prefix + "OpenSSLECDHKeyAgreement");
        this.put("Signature.MD5WithRSA", prefix + "OpenSSLSignature$MD5RSA");
        this.put("Alg.Alias.Signature.MD5WithRSAEncryption", "MD5WithRSA");
        this.put("Alg.Alias.Signature.MD5/RSA", "MD5WithRSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.4", "MD5WithRSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.2.5with1.2.840.113549.1.1.1", "MD5WithRSA");
        this.put("Signature.SHA1WithRSA", prefix + "OpenSSLSignature$SHA1RSA");
        this.put("Alg.Alias.Signature.SHA1WithRSAEncryption", "SHA1WithRSA");
        this.put("Alg.Alias.Signature.SHA1/RSA", "SHA1WithRSA");
        this.put("Alg.Alias.Signature.SHA-1/RSA", "SHA1WithRSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.5", "SHA1WithRSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.1", "SHA1WithRSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.113549.1.1.5", "SHA1WithRSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.29", "SHA1WithRSA");
        this.put("Signature.SHA224WithRSA", prefix + "OpenSSLSignature$SHA224RSA");
        this.put("Alg.Alias.Signature.SHA224WithRSAEncryption", "SHA224WithRSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", "SHA224WithRSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.4with1.2.840.113549.1.1.1", "SHA224WithRSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.4with1.2.840.113549.1.1.11", "SHA224WithRSA");
        this.put("Signature.SHA256WithRSA", prefix + "OpenSSLSignature$SHA256RSA");
        this.put("Alg.Alias.Signature.SHA256WithRSAEncryption", "SHA256WithRSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.11", "SHA256WithRSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.1with1.2.840.113549.1.1.1", "SHA256WithRSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.1with1.2.840.113549.1.1.11", "SHA256WithRSA");
        this.put("Signature.SHA384WithRSA", prefix + "OpenSSLSignature$SHA384RSA");
        this.put("Alg.Alias.Signature.SHA384WithRSAEncryption", "SHA384WithRSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.12", "SHA384WithRSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.2with1.2.840.113549.1.1.1", "SHA384WithRSA");
        this.put("Signature.SHA512WithRSA", prefix + "OpenSSLSignature$SHA512RSA");
        this.put("Alg.Alias.Signature.SHA512WithRSAEncryption", "SHA512WithRSA");
        this.put("Alg.Alias.Signature.1.2.840.113549.1.1.13", "SHA512WithRSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.3with1.2.840.113549.1.1.1", "SHA512WithRSA");
        this.put("Signature.SHA1withDSA", prefix + "OpenSSLSignature$SHA1DSA");
        this.put("Alg.Alias.Signature.SHA/DSA", "SHA1withDSA");
        this.put("Alg.Alias.Signature.DSA", "SHA1withDSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.1", "SHA1withDSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10040.4.3", "SHA1withDSA");
        this.put("Alg.Alias.Signature.DSAWithSHA1", "SHA1withDSA");
        this.put("Alg.Alias.Signature.1.2.840.10040.4.3", "SHA1withDSA");
        this.put("Signature.NONEwithRSA", prefix + "OpenSSLSignatureRawRSA");
        this.put("Signature.ECDSA", prefix + "OpenSSLSignature$SHA1ECDSA");
        this.put("Alg.Alias.Signature.SHA1withECDSA", "ECDSA");
        this.put("Alg.Alias.Signature.ECDSAwithSHA1", "ECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.1", "ECDSA");
        this.put("Alg.Alias.Signature.1.3.14.3.2.26with1.2.840.10045.2.1", "ECDSA");
        this.put("Signature.SHA224withECDSA", prefix + "OpenSSLSignature$SHA224ECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.1", "SHA224withECDSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.4with1.2.840.10045.2.1", "SHA224withECDSA");
        this.put("Signature.SHA256withECDSA", prefix + "OpenSSLSignature$SHA256ECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.2", "SHA256withECDSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.1with1.2.840.10045.2.1", "SHA256withECDSA");
        this.put("Signature.SHA384withECDSA", prefix + "OpenSSLSignature$SHA384ECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.3", "SHA384withECDSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.2with1.2.840.10045.2.1", "SHA384withECDSA");
        this.put("Signature.SHA512withECDSA", prefix + "OpenSSLSignature$SHA512ECDSA");
        this.put("Alg.Alias.Signature.1.2.840.10045.4.3.4", "SHA512withECDSA");
        this.put("Alg.Alias.Signature.2.16.840.1.101.3.4.2.3with1.2.840.10045.2.1", "SHA512withECDSA");
        this.put("SecureRandom.SHA1PRNG", prefix + "OpenSSLRandom");
        this.put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
        this.put("Cipher.RSA/ECB/NoPadding", prefix + "OpenSSLCipherRSA$Raw");
        this.put("Alg.Alias.Cipher.RSA/None/NoPadding", "RSA/ECB/NoPadding");
        this.put("Cipher.RSA/ECB/PKCS1Padding", prefix + "OpenSSLCipherRSA$PKCS1");
        this.put("Alg.Alias.Cipher.RSA/None/PKCS1Padding", "RSA/ECB/PKCS1Padding");
        this.put("Cipher.AES/ECB/NoPadding", prefix + "OpenSSLCipher$AES$ECB$NoPadding");
        this.put("Cipher.AES/ECB/PKCS5Padding", prefix + "OpenSSLCipher$AES$ECB$PKCS5Padding");
        this.put("Alg.Alias.Cipher.AES/ECB/PKCS7Padding", "AES/ECB/PKCS5Padding");
        this.put("Cipher.AES/CBC/NoPadding", prefix + "OpenSSLCipher$AES$CBC$NoPadding");
        this.put("Cipher.AES/CBC/PKCS5Padding", prefix + "OpenSSLCipher$AES$CBC$PKCS5Padding");
        this.put("Alg.Alias.Cipher.AES/CBC/PKCS7Padding", "AES/CBC/PKCS5Padding");
        this.put("Cipher.AES/CFB/NoPadding", prefix + "OpenSSLCipher$AES$CFB");
        this.put("Cipher.AES/CTR/NoPadding", prefix + "OpenSSLCipher$AES$CTR");
        this.put("Cipher.AES/OFB/NoPadding", prefix + "OpenSSLCipher$AES$OFB");
        this.put("Cipher.DESEDE/ECB/NoPadding", prefix + "OpenSSLCipher$DESEDE$ECB$NoPadding");
        this.put("Cipher.DESEDE/ECB/PKCS5Padding", prefix + "OpenSSLCipher$DESEDE$ECB$PKCS5Padding");
        this.put("Alg.Alias.Cipher.DESEDE/ECB/PKCS7Padding", "DESEDE/ECB/PKCS5Padding");
        this.put("Cipher.DESEDE/CBC/NoPadding", prefix + "OpenSSLCipher$DESEDE$CBC$NoPadding");
        this.put("Cipher.DESEDE/CBC/PKCS5Padding", prefix + "OpenSSLCipher$DESEDE$CBC$PKCS5Padding");
        this.put("Alg.Alias.Cipher.DESEDE/CBC/PKCS7Padding", "DESEDE/CBC/PKCS5Padding");
        this.put("Cipher.DESEDE/CFB/NoPadding", prefix + "OpenSSLCipher$DESEDE$CFB");
        this.put("Cipher.DESEDE/OFB/NoPadding", prefix + "OpenSSLCipher$DESEDE$OFB");
        this.put("Cipher.ARC4", prefix + "OpenSSLCipher$ARC4");
        this.put("Mac.HmacMD5", prefix + "OpenSSLMac$HmacMD5");
        this.put("Mac.HmacSHA1", prefix + "OpenSSLMac$HmacSHA1");
        this.put("Alg.Alias.Mac.1.2.840.113549.2.7", "HmacSHA1");
        this.put("Alg.Alias.Mac.HMAC-SHA1", "HmacSHA1");
        this.put("Alg.Alias.Mac.HMAC/SHA1", "HmacSHA1");
        this.put("Mac.HmacSHA224", prefix + "OpenSSLMac$HmacSHA224");
        this.put("Alg.Alias.Mac.1.2.840.113549.2.9", "HmacSHA224");
        this.put("Alg.Alias.Mac.HMAC-SHA224", "HmacSHA224");
        this.put("Alg.Alias.Mac.HMAC/SHA224", "HmacSHA224");
        this.put("Mac.HmacSHA256", prefix + "OpenSSLMac$HmacSHA256");
        this.put("Alg.Alias.Mac.1.2.840.113549.2.9", "HmacSHA256");
        this.put("Alg.Alias.Mac.HMAC-SHA256", "HmacSHA256");
        this.put("Alg.Alias.Mac.HMAC/SHA256", "HmacSHA256");
        this.put("Mac.HmacSHA384", prefix + "OpenSSLMac$HmacSHA384");
        this.put("Alg.Alias.Mac.1.2.840.113549.2.10", "HmacSHA384");
        this.put("Alg.Alias.Mac.HMAC-SHA384", "HmacSHA384");
        this.put("Alg.Alias.Mac.HMAC/SHA384", "HmacSHA384");
        this.put("Mac.HmacSHA512", prefix + "OpenSSLMac$HmacSHA512");
        this.put("Alg.Alias.Mac.1.2.840.113549.2.11", "HmacSHA512");
        this.put("Alg.Alias.Mac.HMAC-SHA512", "HmacSHA512");
        this.put("Alg.Alias.Mac.HMAC/SHA512", "HmacSHA512");
        this.put("CertificateFactory.X509", prefix + "OpenSSLX509CertificateFactory");
        this.put("Alg.Alias.CertificateFactory.X.509", "X509");
    }
}

