/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import java.io.Serializable;
import java.security.SecureRandomSpi;

public class OpenSSLRandom
extends SecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 8506210602917522860L;
    private boolean mSeeded;

    @Override
    protected void engineSetSeed(byte[] seed) {
        this.selfSeedIfNotSeeded();
        NativeCrypto.RAND_seed(seed);
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        this.selfSeedIfNotSeeded();
        NativeCrypto.RAND_bytes(bytes);
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        this.selfSeedIfNotSeeded();
        byte[] output = new byte[numBytes];
        NativeCrypto.RAND_bytes(output);
        return output;
    }

    private void selfSeedIfNotSeeded() {
        if (this.mSeeded) {
            return;
        }
        OpenSSLRandom.seedOpenSSLPRNGFromLinuxRNG();
        this.mSeeded = true;
    }

    public static void seedOpenSSLPRNGFromLinuxRNG() {
        int seedLengthInBytes = 1024;
        int bytesRead = NativeCrypto.RAND_load_file("/dev/urandom", seedLengthInBytes);
        if (bytesRead != seedLengthInBytes) {
            throw new SecurityException("Failed to read sufficient bytes from /dev/urandom. Expected: " + seedLengthInBytes + ", actual: " + bytesRead);
        }
    }
}

