/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import com.android.internal.util.LocalLog;
import com.android.server.SystemService;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;

class AlarmManagerService
extends SystemService {
    private static final long LATE_ALARM_THRESHOLD = 10000L;
    private static final int RTC_WAKEUP_MASK = 1;
    private static final int RTC_MASK = 2;
    private static final int ELAPSED_REALTIME_WAKEUP_MASK = 4;
    private static final int ELAPSED_REALTIME_MASK = 8;
    static final int TIME_CHANGED_MASK = 65536;
    static final int IS_WAKEUP_MASK = 5;
    static final int TYPE_NONWAKEUP_MASK = 1;
    static final String TAG = "AlarmManager";
    static final String ClockReceiver_TAG = "ClockReceiver";
    static final boolean localLOGV = false;
    static final boolean DEBUG_BATCH = false;
    static final boolean DEBUG_VALIDATE = false;
    static final boolean DEBUG_ALARM_CLOCK = false;
    static final int ALARM_EVENT = 1;
    static final String TIMEZONE_PROPERTY = "persist.sys.timezone";
    static final Intent mBackgroundIntent = new Intent().addFlags(4);
    static final IncreasingTimeOrder sIncreasingTimeOrder = new IncreasingTimeOrder();
    static final boolean WAKEUP_STATS = false;
    private static final Intent NEXT_ALARM_CLOCK_CHANGED_INTENT = new Intent("android.app.action.NEXT_ALARM_CLOCK_CHANGED");
    final LocalLog mLog = new LocalLog("AlarmManager");
    final Object mLock = new Object();
    long mNativeData;
    private long mNextWakeup;
    private long mNextNonWakeup;
    int mBroadcastRefCount = 0;
    PowerManager.WakeLock mWakeLock;
    boolean mLastWakeLockUnimportantForLogging;
    ArrayList<Alarm> mPendingNonWakeupAlarms = new ArrayList();
    ArrayList<InFlight> mInFlight = new ArrayList();
    final AlarmHandler mHandler = new AlarmHandler();
    ClockReceiver mClockReceiver;
    InteractiveStateReceiver mInteractiveStateReceiver;
    private UninstallReceiver mUninstallReceiver;
    final ResultReceiver mResultReceiver = new ResultReceiver();
    PendingIntent mTimeTickSender;
    PendingIntent mDateChangeSender;
    boolean mInteractive = true;
    long mNonInteractiveStartTime;
    long mNonInteractiveTime;
    long mLastAlarmDeliveryTime;
    long mStartCurrentDelayTime;
    long mNextNonWakeupDeliveryTime;
    int mNumTimeChanged;
    private final SparseArray<AlarmManager.AlarmClockInfo> mNextAlarmClockForUser = new SparseArray();
    private final SparseArray<AlarmManager.AlarmClockInfo> mTmpSparseAlarmClockArray = new SparseArray();
    private final SparseBooleanArray mPendingSendNextAlarmClockChangedForUser = new SparseBooleanArray();
    private boolean mNextAlarmClockMayChange;
    private final SparseArray<AlarmManager.AlarmClockInfo> mHandlerSparseAlarmClockArray = new SparseArray();
    static final int PRIO_TICK = 0;
    static final int PRIO_WAKEUP = 1;
    static final int PRIO_NORMAL = 2;
    final HashMap<String, PriorityClass> mPriorities = new HashMap();
    int mCurrentSeq = 0;
    final LinkedList<WakeupEvent> mRecentWakeups = new LinkedList();
    final long RECENT_WAKEUP_PERIOD = 86400000L;
    final Comparator<Alarm> mAlarmDispatchComparator = new Comparator<Alarm>(){

        @Override
        public int compare(Alarm lhs, Alarm rhs) {
            if (lhs.priorityClass.priority < rhs.priorityClass.priority) {
                return -1;
            }
            if (lhs.priorityClass.priority > rhs.priorityClass.priority) {
                return 1;
            }
            if (lhs.whenElapsed < rhs.whenElapsed) {
                return -1;
            }
            if (lhs.whenElapsed > rhs.whenElapsed) {
                return 1;
            }
            return 0;
        }
    };
    static final long MIN_FUZZABLE_INTERVAL = 10000L;
    static final BatchTimeOrder sBatchOrder = new BatchTimeOrder();
    final ArrayList<Batch> mAlarmBatches = new ArrayList();
    final SparseArray<ArrayMap<String, BroadcastStats>> mBroadcastStats = new SparseArray();
    int mNumDelayedAlarms = 0;
    long mTotalDelayTime = 0L;
    long mMaxDelayTime = 0L;
    private final IBinder mService = new IAlarmManager.Stub(){

        @Override
        public void set(int type, long triggerAtTime, long windowLength, long interval, PendingIntent operation, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock) {
            if (workSource != null) {
                AlarmManagerService.this.getContext().enforceCallingPermission("android.permission.UPDATE_DEVICE_STATS", "AlarmManager.set");
            }
            AlarmManagerService.this.setImpl(type, triggerAtTime, windowLength, interval, operation, windowLength == 0L, workSource, alarmClock);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setTime(long millis) {
            AlarmManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.SET_TIME", "setTime");
            if (AlarmManagerService.this.mNativeData == 0L) {
                Slog.w(AlarmManagerService.TAG, "Not setting time since no alarm driver is available.");
                return false;
            }
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                return AlarmManagerService.this.setKernelTime(AlarmManagerService.this.mNativeData, millis) == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimeZone(String tz) {
            AlarmManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.SET_TIME_ZONE", "setTimeZone");
            long oldId = Binder.clearCallingIdentity();
            try {
                AlarmManagerService.this.setTimeZoneImpl(tz);
            }
            finally {
                Binder.restoreCallingIdentity(oldId);
            }
        }

        @Override
        public void remove(PendingIntent operation) {
            AlarmManagerService.this.removeImpl(operation);
        }

        @Override
        public AlarmManager.AlarmClockInfo getNextAlarmClock(int userId) {
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, false, "getNextAlarmClock", null);
            return AlarmManagerService.this.getNextAlarmClockImpl(userId);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (AlarmManagerService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump AlarmManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            AlarmManagerService.this.dumpImpl(pw);
        }
    };

    void calculateDeliveryPriorities(ArrayList<Alarm> alarms) {
        int N = alarms.size();
        for (int i = 0; i < N; ++i) {
            Alarm a = alarms.get(i);
            int alarmPrio = "android.intent.action.TIME_TICK".equals(a.operation.getIntent().getAction()) ? 0 : (a.wakeup ? 1 : 2);
            PriorityClass packagePrio = a.priorityClass;
            if (packagePrio == null) {
                packagePrio = this.mPriorities.get(a.operation.getCreatorPackage());
            }
            if (packagePrio == null) {
                packagePrio = a.priorityClass = new PriorityClass();
                this.mPriorities.put(a.operation.getCreatorPackage(), packagePrio);
            }
            a.priorityClass = packagePrio;
            if (packagePrio.seq != this.mCurrentSeq) {
                packagePrio.priority = alarmPrio;
                packagePrio.seq = this.mCurrentSeq;
                continue;
            }
            if (alarmPrio >= packagePrio.priority) continue;
            packagePrio.priority = alarmPrio;
        }
    }

    public AlarmManagerService(Context context) {
        super(context);
    }

    static long convertToElapsed(long when, int type) {
        boolean isRtc;
        boolean bl = isRtc = type == 1 || type == 0;
        if (isRtc) {
            when -= System.currentTimeMillis() - SystemClock.elapsedRealtime();
        }
        return when;
    }

    static long maxTriggerTime(long now, long triggerAtTime, long interval) {
        long futurity;
        long l = futurity = interval == 0L ? triggerAtTime - now : interval;
        if (futurity < 10000L) {
            futurity = 0L;
        }
        return triggerAtTime + (long)(0.75 * (double)futurity);
    }

    static boolean addBatchLocked(ArrayList<Batch> list, Batch newBatch) {
        int index = Collections.binarySearch(list, newBatch, sBatchOrder);
        if (index < 0) {
            index = 0 - index - 1;
        }
        list.add(index, newBatch);
        return index == 0;
    }

    int attemptCoalesceLocked(long whenElapsed, long maxWhen) {
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (b.standalone || !b.canHold(whenElapsed, maxWhen)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rebatchAllAlarms() {
        Object object = this.mLock;
        synchronized (object) {
            this.rebatchAllAlarmsLocked(true);
        }
    }

    void rebatchAllAlarmsLocked(boolean doValidate) {
        ArrayList oldSet = (ArrayList)this.mAlarmBatches.clone();
        this.mAlarmBatches.clear();
        long nowElapsed = SystemClock.elapsedRealtime();
        int oldBatches = oldSet.size();
        for (int batchNum = 0; batchNum < oldBatches; ++batchNum) {
            Batch batch = (Batch)oldSet.get(batchNum);
            int N = batch.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = batch.get(i);
                long whenElapsed = AlarmManagerService.convertToElapsed(a.when, a.type);
                long maxElapsed = a.whenElapsed == a.maxWhen ? whenElapsed : (a.windowLength > 0L ? whenElapsed + a.windowLength : AlarmManagerService.maxTriggerTime(nowElapsed, whenElapsed, a.repeatInterval));
                this.setImplLocked(a.type, a.when, whenElapsed, a.windowLength, maxElapsed, a.repeatInterval, a.operation, batch.standalone, doValidate, a.workSource, a.alarmClock, a.userId);
            }
        }
    }

    @Override
    public void onStart() {
        this.mNativeData = this.init();
        this.mNextNonWakeup = 0L;
        this.mNextWakeup = 0L;
        this.setTimeZoneImpl(SystemProperties.get(TIMEZONE_PROPERTY));
        PowerManager pm = (PowerManager)this.getContext().getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*alarm*");
        this.mTimeTickSender = PendingIntent.getBroadcastAsUser(this.getContext(), 0, new Intent("android.intent.action.TIME_TICK").addFlags(0x50000000), 0, UserHandle.ALL);
        Intent intent = new Intent("android.intent.action.DATE_CHANGED");
        intent.addFlags(0x20000000);
        this.mDateChangeSender = PendingIntent.getBroadcastAsUser(this.getContext(), 0, intent, 0x4000000, UserHandle.ALL);
        this.mClockReceiver = new ClockReceiver();
        this.mClockReceiver.scheduleTimeTickEvent();
        this.mClockReceiver.scheduleDateChangedEvent();
        this.mInteractiveStateReceiver = new InteractiveStateReceiver();
        this.mUninstallReceiver = new UninstallReceiver();
        if (this.mNativeData != 0L) {
            AlarmThread waitThread = new AlarmThread();
            waitThread.start();
        } else {
            Slog.w(TAG, "Failed to open alarm driver. Falling back to a handler.");
        }
        this.publishBinderService("alarm", this.mService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close(this.mNativeData);
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTimeZoneImpl(String tz) {
        if (TextUtils.isEmpty(tz)) {
            return;
        }
        TimeZone zone = TimeZone.getTimeZone(tz);
        boolean timeZoneWasChanged = false;
        AlarmManagerService alarmManagerService = this;
        synchronized (alarmManagerService) {
            String current = SystemProperties.get(TIMEZONE_PROPERTY);
            if (current == null || !current.equals(zone.getID())) {
                timeZoneWasChanged = true;
                SystemProperties.set(TIMEZONE_PROPERTY, zone.getID());
            }
            int gmtOffset = zone.getOffset(System.currentTimeMillis());
            this.setKernelTimezone(this.mNativeData, -(gmtOffset / 60000));
        }
        TimeZone.setDefault(null);
        if (timeZoneWasChanged) {
            Intent intent = new Intent("android.intent.action.TIMEZONE_CHANGED");
            intent.addFlags(0x20000000);
            intent.putExtra("time-zone", zone.getID());
            this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeImpl(PendingIntent operation) {
        if (operation == null) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.removeLocked(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setImpl(int type, long triggerAtTime, long windowLength, long interval, PendingIntent operation, boolean isStandalone, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock) {
        if (operation == null) {
            Slog.w(TAG, "set/setRepeating ignored because there is no intent");
            return;
        }
        if (windowLength > 43200000L) {
            Slog.w(TAG, "Window length " + windowLength + "ms suspiciously long; limiting to 1 hour");
            windowLength = 3600000L;
        }
        if (type < 0 || type > 3) {
            throw new IllegalArgumentException("Invalid alarm type " + type);
        }
        if (triggerAtTime < 0L) {
            long who = Binder.getCallingUid();
            long what = Binder.getCallingPid();
            Slog.w(TAG, "Invalid alarm trigger time! " + triggerAtTime + " from uid=" + who + " pid=" + what);
            triggerAtTime = 0L;
        }
        long nowElapsed = SystemClock.elapsedRealtime();
        long triggerElapsed = AlarmManagerService.convertToElapsed(triggerAtTime, type);
        long maxElapsed = windowLength == 0L ? triggerElapsed : (windowLength < 0L ? AlarmManagerService.maxTriggerTime(nowElapsed, triggerElapsed, interval) : triggerElapsed + windowLength);
        int userId = UserHandle.getCallingUserId();
        Object object = this.mLock;
        synchronized (object) {
            this.setImplLocked(type, triggerAtTime, triggerElapsed, windowLength, maxElapsed, interval, operation, isStandalone, true, workSource, alarmClock, userId);
        }
    }

    private void setImplLocked(int type, long when, long whenElapsed, long windowLength, long maxWhen, long interval, PendingIntent operation, boolean isStandalone, boolean doValidate, WorkSource workSource, AlarmManager.AlarmClockInfo alarmClock, int userId) {
        int whichBatch;
        Alarm a = new Alarm(type, when, whenElapsed, windowLength, maxWhen, interval, operation, workSource, alarmClock, userId);
        this.removeLocked(operation);
        int n = whichBatch = isStandalone ? -1 : this.attemptCoalesceLocked(whenElapsed, maxWhen);
        if (whichBatch < 0) {
            Batch batch = new Batch(a);
            batch.standalone = isStandalone;
            AlarmManagerService.addBatchLocked(this.mAlarmBatches, batch);
        } else {
            Batch batch = this.mAlarmBatches.get(whichBatch);
            if (batch.add(a)) {
                this.mAlarmBatches.remove(whichBatch);
                AlarmManagerService.addBatchLocked(this.mAlarmBatches, batch);
            }
        }
        if (alarmClock != null) {
            this.mNextAlarmClockMayChange = true;
            this.updateNextAlarmClockLocked();
        }
        this.rescheduleKernelAlarmsLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpImpl(PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Current Alarm Manager state:");
            long nowRTC = System.currentTimeMillis();
            long nowELAPSED = SystemClock.elapsedRealtime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            pw.print("nowRTC=");
            pw.print(nowRTC);
            pw.print("=");
            pw.print(sdf.format(new Date(nowRTC)));
            pw.print(" nowELAPSED=");
            TimeUtils.formatDuration(nowELAPSED, pw);
            pw.println();
            if (!this.mInteractive) {
                pw.print("Time since non-interactive: ");
                TimeUtils.formatDuration(nowELAPSED - this.mNonInteractiveStartTime, pw);
                pw.println();
                pw.print("Max wakeup delay: ");
                TimeUtils.formatDuration(this.currentNonWakeupFuzzLocked(nowELAPSED), pw);
                pw.println();
                pw.print("Time since last dispatch: ");
                TimeUtils.formatDuration(nowELAPSED - this.mLastAlarmDeliveryTime, pw);
                pw.println();
                pw.print("Next non-wakeup delivery time: ");
                TimeUtils.formatDuration(nowELAPSED - this.mNextNonWakeupDeliveryTime, pw);
                pw.println();
            }
            long nextWakeupRTC = this.mNextWakeup + (nowRTC - nowELAPSED);
            long nextNonWakeupRTC = this.mNextNonWakeup + (nowRTC - nowELAPSED);
            pw.print("Next non-wakeup alarm: ");
            TimeUtils.formatDuration(this.mNextNonWakeup, nowELAPSED, pw);
            pw.print(" = ");
            pw.println(sdf.format(new Date(nextNonWakeupRTC)));
            pw.print("Next wakeup: ");
            TimeUtils.formatDuration(this.mNextWakeup, nowELAPSED, pw);
            pw.print(" = ");
            pw.println(sdf.format(new Date(nextWakeupRTC)));
            pw.print("Num time change events: ");
            pw.println(this.mNumTimeChanged);
            if (this.mAlarmBatches.size() > 0) {
                pw.println();
                pw.print("Pending alarm batches: ");
                pw.println(this.mAlarmBatches.size());
                for (Batch b : this.mAlarmBatches) {
                    pw.print(b);
                    pw.println(':');
                    AlarmManagerService.dumpAlarmList(pw, b.alarms, "  ", nowELAPSED, nowRTC, sdf);
                }
            }
            pw.println();
            pw.print("Past-due non-wakeup alarms: ");
            if (this.mPendingNonWakeupAlarms.size() > 0) {
                pw.println(this.mPendingNonWakeupAlarms.size());
                AlarmManagerService.dumpAlarmList(pw, this.mPendingNonWakeupAlarms, "  ", nowELAPSED, nowRTC, sdf);
            } else {
                pw.println("(none)");
            }
            pw.print("  Number of delayed alarms: ");
            pw.print(this.mNumDelayedAlarms);
            pw.print(", total delay time: ");
            TimeUtils.formatDuration(this.mTotalDelayTime, pw);
            pw.println();
            pw.print("  Max delay time: ");
            TimeUtils.formatDuration(this.mMaxDelayTime, pw);
            pw.print(", max non-interactive time: ");
            TimeUtils.formatDuration(this.mNonInteractiveTime, pw);
            pw.println();
            pw.println();
            pw.print("  Broadcast ref count: ");
            pw.println(this.mBroadcastRefCount);
            pw.println();
            if (this.mLog.dump(pw, "  Recent problems", "    ")) {
                pw.println();
            }
            FilterStats[] topFilters = new FilterStats[10];
            Comparator<FilterStats> comparator = new Comparator<FilterStats>(){

                @Override
                public int compare(FilterStats lhs, FilterStats rhs) {
                    if (lhs.aggregateTime < rhs.aggregateTime) {
                        return 1;
                    }
                    if (lhs.aggregateTime > rhs.aggregateTime) {
                        return -1;
                    }
                    return 0;
                }
            };
            int len = 0;
            for (int iu = 0; iu < this.mBroadcastStats.size(); ++iu) {
                ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.valueAt(iu);
                for (int ip = 0; ip < uidStats.size(); ++ip) {
                    BroadcastStats bs = uidStats.valueAt(ip);
                    for (int is = 0; is < bs.filterStats.size(); ++is) {
                        int pos;
                        FilterStats fs = bs.filterStats.valueAt(is);
                        int n = pos = len > 0 ? Arrays.binarySearch(topFilters, 0, len, fs, comparator) : 0;
                        if (pos < 0) {
                            pos = -pos - 1;
                        }
                        if (pos >= topFilters.length) continue;
                        int copylen = topFilters.length - pos - 1;
                        if (copylen > 0) {
                            System.arraycopy(topFilters, pos, topFilters, pos + 1, copylen);
                        }
                        topFilters[pos] = fs;
                        if (len >= topFilters.length) continue;
                        ++len;
                    }
                }
            }
            if (len > 0) {
                pw.println("  Top Alarms:");
                for (int i = 0; i < len; ++i) {
                    FilterStats fs = topFilters[i];
                    pw.print("    ");
                    if (fs.nesting > 0) {
                        pw.print("*ACTIVE* ");
                    }
                    TimeUtils.formatDuration(fs.aggregateTime, pw);
                    pw.print(" running, ");
                    pw.print(fs.numWakeup);
                    pw.print(" wakeups, ");
                    pw.print(fs.count);
                    pw.print(" alarms: ");
                    UserHandle.formatUid(pw, fs.mBroadcastStats.mUid);
                    pw.print(":");
                    pw.print(fs.mBroadcastStats.mPackageName);
                    pw.println();
                    pw.print("      ");
                    pw.print(fs.mTag);
                    pw.println();
                }
            }
            pw.println(" ");
            pw.println("  Alarm Stats:");
            ArrayList<FilterStats> tmpFilters = new ArrayList<FilterStats>();
            for (int iu = 0; iu < this.mBroadcastStats.size(); ++iu) {
                ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.valueAt(iu);
                for (int ip = 0; ip < uidStats.size(); ++ip) {
                    BroadcastStats bs = uidStats.valueAt(ip);
                    pw.print("  ");
                    if (bs.nesting > 0) {
                        pw.print("*ACTIVE* ");
                    }
                    UserHandle.formatUid(pw, bs.mUid);
                    pw.print(":");
                    pw.print(bs.mPackageName);
                    pw.print(" ");
                    TimeUtils.formatDuration(bs.aggregateTime, pw);
                    pw.print(" running, ");
                    pw.print(bs.numWakeup);
                    pw.println(" wakeups:");
                    tmpFilters.clear();
                    for (int is = 0; is < bs.filterStats.size(); ++is) {
                        tmpFilters.add(bs.filterStats.valueAt(is));
                    }
                    Collections.sort(tmpFilters, comparator);
                    for (int i = 0; i < tmpFilters.size(); ++i) {
                        FilterStats fs = (FilterStats)tmpFilters.get(i);
                        pw.print("    ");
                        if (fs.nesting > 0) {
                            pw.print("*ACTIVE* ");
                        }
                        TimeUtils.formatDuration(fs.aggregateTime, pw);
                        pw.print(" ");
                        pw.print(fs.numWakeup);
                        pw.print(" wakes ");
                        pw.print(fs.count);
                        pw.print(" alarms: ");
                        pw.print(fs.mTag);
                        pw.println();
                    }
                }
            }
        }
    }

    private void logBatchesLocked(SimpleDateFormat sdf) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(2048);
        PrintWriter pw = new PrintWriter(bs);
        long nowRTC = System.currentTimeMillis();
        long nowELAPSED = SystemClock.elapsedRealtime();
        int NZ = this.mAlarmBatches.size();
        for (int iz = 0; iz < NZ; ++iz) {
            Batch bz = this.mAlarmBatches.get(iz);
            pw.append("Batch ");
            pw.print(iz);
            pw.append(": ");
            pw.println(bz);
            AlarmManagerService.dumpAlarmList(pw, bz.alarms, "  ", nowELAPSED, nowRTC, sdf);
            pw.flush();
            Slog.v(TAG, bs.toString());
            bs.reset();
        }
    }

    private boolean validateConsistencyLocked() {
        return true;
    }

    private Batch findFirstWakeupBatchLocked() {
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (!b.hasWakeups()) continue;
            return b;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AlarmManager.AlarmClockInfo getNextAlarmClockImpl(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mNextAlarmClockForUser.get(userId);
        }
    }

    private void updateNextAlarmClockLocked() {
        int userId;
        if (!this.mNextAlarmClockMayChange) {
            return;
        }
        this.mNextAlarmClockMayChange = false;
        SparseArray<AlarmManager.AlarmClockInfo> nextForUser = this.mTmpSparseAlarmClockArray;
        nextForUser.clear();
        int N = this.mAlarmBatches.size();
        for (int i = 0; i < N; ++i) {
            ArrayList<Alarm> alarms = this.mAlarmBatches.get((int)i).alarms;
            int M = alarms.size();
            for (int j = 0; j < M; ++j) {
                int userId2;
                Alarm a = alarms.get(j);
                if (a.alarmClock == null || nextForUser.get(userId2 = a.userId) != null) continue;
                nextForUser.put(userId2, a.alarmClock);
            }
        }
        int NN = nextForUser.size();
        for (int i = 0; i < NN; ++i) {
            AlarmManager.AlarmClockInfo currentAlarm;
            AlarmManager.AlarmClockInfo newAlarm = nextForUser.valueAt(i);
            if (newAlarm.equals(currentAlarm = this.mNextAlarmClockForUser.get(userId = nextForUser.keyAt(i)))) continue;
            this.updateNextAlarmInfoForUserLocked(userId, newAlarm);
        }
        int NNN = this.mNextAlarmClockForUser.size();
        for (int i = NNN - 1; i >= 0; --i) {
            userId = this.mNextAlarmClockForUser.keyAt(i);
            if (nextForUser.get(userId) != null) continue;
            this.updateNextAlarmInfoForUserLocked(userId, null);
        }
    }

    private void updateNextAlarmInfoForUserLocked(int userId, AlarmManager.AlarmClockInfo alarmClock) {
        if (alarmClock != null) {
            this.mNextAlarmClockForUser.put(userId, alarmClock);
        } else {
            this.mNextAlarmClockForUser.remove(userId);
        }
        this.mPendingSendNextAlarmClockChangedForUser.put(userId, true);
        this.mHandler.removeMessages(4);
        this.mHandler.sendEmptyMessage(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNextAlarmClockChanged() {
        SparseArray<AlarmManager.AlarmClockInfo> pendingUsers = this.mHandlerSparseAlarmClockArray;
        pendingUsers.clear();
        Object object = this.mLock;
        synchronized (object) {
            int N = this.mPendingSendNextAlarmClockChangedForUser.size();
            for (int i = 0; i < N; ++i) {
                int userId = this.mPendingSendNextAlarmClockChangedForUser.keyAt(i);
                pendingUsers.append(userId, this.mNextAlarmClockForUser.get(userId));
            }
            this.mPendingSendNextAlarmClockChangedForUser.clear();
        }
        int N = pendingUsers.size();
        for (int i = 0; i < N; ++i) {
            int userId = pendingUsers.keyAt(i);
            AlarmManager.AlarmClockInfo alarmClock = pendingUsers.valueAt(i);
            Settings.System.putStringForUser(this.getContext().getContentResolver(), "next_alarm_formatted", AlarmManagerService.formatNextAlarm(this.getContext(), alarmClock), userId);
            this.getContext().sendBroadcastAsUser(NEXT_ALARM_CLOCK_CHANGED_INTENT, new UserHandle(userId));
        }
    }

    private static String formatNextAlarm(Context context, AlarmManager.AlarmClockInfo info) {
        String skeleton = DateFormat.is24HourFormat(context) ? "EHm" : "Ehma";
        String pattern = DateFormat.getBestDateTimePattern(Locale.getDefault(), skeleton);
        return info == null ? "" : DateFormat.format((CharSequence)pattern, info.getTriggerTime()).toString();
    }

    void rescheduleKernelAlarmsLocked() {
        long nextNonWakeup = 0L;
        if (this.mAlarmBatches.size() > 0) {
            Batch firstWakeup = this.findFirstWakeupBatchLocked();
            Batch firstBatch = this.mAlarmBatches.get(0);
            if (firstWakeup != null && this.mNextWakeup != firstWakeup.start) {
                this.mNextWakeup = firstWakeup.start;
                this.setLocked(2, firstWakeup.start);
            }
            if (firstBatch != firstWakeup) {
                nextNonWakeup = firstBatch.start;
            }
        }
        if (this.mPendingNonWakeupAlarms.size() > 0 && (nextNonWakeup == 0L || this.mNextNonWakeupDeliveryTime < nextNonWakeup)) {
            nextNonWakeup = this.mNextNonWakeupDeliveryTime;
        }
        if (nextNonWakeup != 0L && this.mNextNonWakeup != nextNonWakeup) {
            this.mNextNonWakeup = nextNonWakeup;
            this.setLocked(3, nextNonWakeup);
        }
    }

    private void removeLocked(PendingIntent operation) {
        boolean didRemove = false;
        for (int i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(operation);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    void removeLocked(String packageName) {
        boolean didRemove = false;
        for (int i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(packageName);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    void removeUserLocked(int userHandle) {
        boolean didRemove = false;
        for (int i = this.mAlarmBatches.size() - 1; i >= 0; --i) {
            Batch b = this.mAlarmBatches.get(i);
            didRemove |= b.remove(userHandle);
            if (b.size() != 0) continue;
            this.mAlarmBatches.remove(i);
        }
        if (didRemove) {
            this.rebatchAllAlarmsLocked(true);
            this.rescheduleKernelAlarmsLocked();
            this.updateNextAlarmClockLocked();
        }
    }

    void interactiveStateChangedLocked(boolean interactive) {
        if (this.mInteractive != interactive) {
            this.mInteractive = interactive;
            long nowELAPSED = SystemClock.elapsedRealtime();
            if (interactive) {
                long dur;
                if (this.mPendingNonWakeupAlarms.size() > 0) {
                    long thisDelayTime = nowELAPSED - this.mStartCurrentDelayTime;
                    this.mTotalDelayTime += thisDelayTime;
                    if (this.mMaxDelayTime < thisDelayTime) {
                        this.mMaxDelayTime = thisDelayTime;
                    }
                    this.deliverAlarmsLocked(this.mPendingNonWakeupAlarms, nowELAPSED);
                    this.mPendingNonWakeupAlarms.clear();
                }
                if (this.mNonInteractiveStartTime > 0L && (dur = nowELAPSED - this.mNonInteractiveStartTime) > this.mNonInteractiveTime) {
                    this.mNonInteractiveTime = dur;
                }
            } else {
                this.mNonInteractiveStartTime = nowELAPSED;
            }
        }
    }

    boolean lookForPackageLocked(String packageName) {
        for (int i = 0; i < this.mAlarmBatches.size(); ++i) {
            Batch b = this.mAlarmBatches.get(i);
            if (!b.hasPackage(packageName)) continue;
            return true;
        }
        return false;
    }

    private void setLocked(int type, long when) {
        if (this.mNativeData != 0L) {
            long alarmNanoseconds;
            long alarmSeconds;
            if (when < 0L) {
                alarmSeconds = 0L;
                alarmNanoseconds = 0L;
            } else {
                alarmSeconds = when / 1000L;
                alarmNanoseconds = when % 1000L * 1000L * 1000L;
            }
            this.set(this.mNativeData, type, alarmSeconds, alarmNanoseconds);
        } else {
            Message msg = Message.obtain();
            msg.what = 1;
            this.mHandler.removeMessages(1);
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    private static final void dumpAlarmList(PrintWriter pw, ArrayList<Alarm> list, String prefix, String label, long nowRTC, long nowELAPSED, SimpleDateFormat sdf) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Alarm a = list.get(i);
            pw.print(prefix);
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(a);
            a.dump(pw, prefix + "  ", nowRTC, nowELAPSED, sdf);
        }
    }

    private static final String labelForType(int type) {
        switch (type) {
            case 1: {
                return "RTC";
            }
            case 0: {
                return "RTC_WAKEUP";
            }
            case 3: {
                return "ELAPSED";
            }
            case 2: {
                return "ELAPSED_WAKEUP";
            }
        }
        return "--unknown--";
    }

    private static final void dumpAlarmList(PrintWriter pw, ArrayList<Alarm> list, String prefix, long nowELAPSED, long nowRTC, SimpleDateFormat sdf) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Alarm a = list.get(i);
            String label = AlarmManagerService.labelForType(a.type);
            pw.print(prefix);
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(a);
            a.dump(pw, prefix + "  ", nowRTC, nowELAPSED, sdf);
        }
    }

    private native long init();

    private native void close(long var1);

    private native void set(long var1, int var3, long var4, long var6);

    private native int waitForAlarm(long var1);

    private native int setKernelTime(long var1, long var3);

    private native int setKernelTimezone(long var1, int var3);

    boolean triggerAlarmsLocked(ArrayList<Alarm> triggerList, long nowELAPSED, long nowRTC) {
        boolean hasWakeup = false;
        while (this.mAlarmBatches.size() > 0) {
            Batch batch = this.mAlarmBatches.get(0);
            if (batch.start > nowELAPSED) break;
            this.mAlarmBatches.remove(0);
            int N = batch.size();
            for (int i = 0; i < N; ++i) {
                Alarm alarm = batch.get(i);
                alarm.count = 1;
                triggerList.add(alarm);
                if (alarm.repeatInterval > 0L) {
                    alarm.count = (int)((long)alarm.count + (nowELAPSED - alarm.whenElapsed) / alarm.repeatInterval);
                    long delta = (long)alarm.count * alarm.repeatInterval;
                    long nextElapsed = alarm.whenElapsed + delta;
                    this.setImplLocked(alarm.type, alarm.when + delta, nextElapsed, alarm.windowLength, AlarmManagerService.maxTriggerTime(nowELAPSED, nextElapsed, alarm.repeatInterval), alarm.repeatInterval, alarm.operation, batch.standalone, true, alarm.workSource, alarm.alarmClock, alarm.userId);
                }
                if (alarm.wakeup) {
                    hasWakeup = true;
                }
                if (alarm.alarmClock == null) continue;
                this.mNextAlarmClockMayChange = true;
            }
        }
        ++this.mCurrentSeq;
        this.calculateDeliveryPriorities(triggerList);
        Collections.sort(triggerList, this.mAlarmDispatchComparator);
        return hasWakeup;
    }

    void recordWakeupAlarms(ArrayList<Batch> batches, long nowELAPSED, long nowRTC) {
        int numBatches = batches.size();
        for (int nextBatch = 0; nextBatch < numBatches; ++nextBatch) {
            Batch b = batches.get(nextBatch);
            if (b.start > nowELAPSED) break;
            int numAlarms = b.alarms.size();
            for (int nextAlarm = 0; nextAlarm < numAlarms; ++nextAlarm) {
                Alarm a = b.alarms.get(nextAlarm);
                WakeupEvent e = new WakeupEvent(nowRTC, a.operation.getCreatorUid(), a.operation.getIntent().getAction());
                this.mRecentWakeups.add(e);
            }
        }
    }

    long currentNonWakeupFuzzLocked(long nowELAPSED) {
        long timeSinceOn = nowELAPSED - this.mNonInteractiveStartTime;
        if (timeSinceOn < 300000L) {
            return 120000L;
        }
        if (timeSinceOn < 1800000L) {
            return 900000L;
        }
        return 3600000L;
    }

    boolean checkAllowNonWakeupDelayLocked(long nowELAPSED) {
        if (this.mInteractive) {
            return false;
        }
        if (this.mLastAlarmDeliveryTime <= 0L) {
            return false;
        }
        if (this.mPendingNonWakeupAlarms.size() > 0 && this.mNextNonWakeupDeliveryTime > nowELAPSED) {
            return false;
        }
        long timeSinceLast = nowELAPSED - this.mLastAlarmDeliveryTime;
        return timeSinceLast <= this.currentNonWakeupFuzzLocked(nowELAPSED);
    }

    void deliverAlarmsLocked(ArrayList<Alarm> triggerList, long nowELAPSED) {
        this.mLastAlarmDeliveryTime = nowELAPSED;
        for (int i = 0; i < triggerList.size(); ++i) {
            Alarm alarm = triggerList.get(i);
            try {
                alarm.operation.send(this.getContext(), 0, mBackgroundIntent.putExtra("android.intent.extra.ALARM_COUNT", alarm.count), this.mResultReceiver, this.mHandler);
                if (this.mBroadcastRefCount == 0) {
                    this.setWakelockWorkSource(alarm.operation, alarm.workSource, alarm.type, alarm.tag, true);
                    this.mWakeLock.acquire();
                }
                InFlight inflight = new InFlight(this, alarm.operation, alarm.workSource, alarm.type, alarm.tag);
                this.mInFlight.add(inflight);
                ++this.mBroadcastRefCount;
                BroadcastStats bs = inflight.mBroadcastStats;
                ++bs.count;
                if (bs.nesting == 0) {
                    bs.nesting = 1;
                    bs.startTime = nowELAPSED;
                } else {
                    ++bs.nesting;
                }
                FilterStats fs = inflight.mFilterStats;
                ++fs.count;
                if (fs.nesting == 0) {
                    fs.nesting = 1;
                    fs.startTime = nowELAPSED;
                } else {
                    ++fs.nesting;
                }
                if (alarm.type != 2 && alarm.type != 0) continue;
                ++bs.numWakeup;
                ++fs.numWakeup;
                if (alarm.workSource != null && alarm.workSource.size() > 0) {
                    for (int wi = 0; wi < alarm.workSource.size(); ++wi) {
                        ActivityManagerNative.noteWakeupAlarm(alarm.operation, alarm.workSource.get(wi), alarm.workSource.getName(wi));
                    }
                    continue;
                }
                ActivityManagerNative.noteWakeupAlarm(alarm.operation, -1, null);
                continue;
            }
            catch (PendingIntent.CanceledException e) {
                if (alarm.repeatInterval <= 0L) continue;
                this.removeImpl(alarm.operation);
                continue;
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Failure sending alarm.", e);
            }
        }
    }

    void setWakelockWorkSource(PendingIntent pi, WorkSource ws, int type, String tag, boolean first) {
        try {
            boolean unimportant = pi == this.mTimeTickSender;
            this.mWakeLock.setUnimportantForLogging(unimportant);
            if (first || this.mLastWakeLockUnimportantForLogging) {
                this.mWakeLock.setHistoryTag(tag);
            } else {
                this.mWakeLock.setHistoryTag(null);
            }
            this.mLastWakeLockUnimportantForLogging = unimportant;
            if (ws != null) {
                this.mWakeLock.setWorkSource(ws);
                return;
            }
            int uid = ActivityManagerNative.getDefault().getUidForIntentSender(pi.getTarget());
            if (uid >= 0) {
                this.mWakeLock.setWorkSource(new WorkSource(uid));
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mWakeLock.setWorkSource(null);
    }

    private final BroadcastStats getStatsLocked(PendingIntent pi) {
        BroadcastStats bs;
        String pkg = pi.getCreatorPackage();
        int uid = pi.getCreatorUid();
        ArrayMap<String, BroadcastStats> uidStats = this.mBroadcastStats.get(uid);
        if (uidStats == null) {
            uidStats = new ArrayMap();
            this.mBroadcastStats.put(uid, uidStats);
        }
        if ((bs = uidStats.get(pkg)) == null) {
            bs = new BroadcastStats(uid, pkg);
            uidStats.put(pkg, bs);
        }
        return bs;
    }

    class ResultReceiver
    implements PendingIntent.OnFinished {
        ResultReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSendFinished(PendingIntent pi, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                InFlight inflight = null;
                for (int i = 0; i < AlarmManagerService.this.mInFlight.size(); ++i) {
                    if (AlarmManagerService.this.mInFlight.get((int)i).mPendingIntent != pi) continue;
                    inflight = AlarmManagerService.this.mInFlight.remove(i);
                    break;
                }
                if (inflight != null) {
                    long nowELAPSED = SystemClock.elapsedRealtime();
                    BroadcastStats bs = inflight.mBroadcastStats;
                    --bs.nesting;
                    if (bs.nesting <= 0) {
                        bs.nesting = 0;
                        bs.aggregateTime += nowELAPSED - bs.startTime;
                    }
                    FilterStats fs = inflight.mFilterStats;
                    --fs.nesting;
                    if (fs.nesting <= 0) {
                        fs.nesting = 0;
                        fs.aggregateTime += nowELAPSED - fs.startTime;
                    }
                } else {
                    AlarmManagerService.this.mLog.w("No in-flight alarm for " + pi + " " + intent);
                }
                --AlarmManagerService.this.mBroadcastRefCount;
                if (AlarmManagerService.this.mBroadcastRefCount == 0) {
                    AlarmManagerService.this.mWakeLock.release();
                    if (AlarmManagerService.this.mInFlight.size() > 0) {
                        AlarmManagerService.this.mLog.w("Finished all broadcasts with " + AlarmManagerService.this.mInFlight.size() + " remaining inflights");
                        for (int i = 0; i < AlarmManagerService.this.mInFlight.size(); ++i) {
                            AlarmManagerService.this.mLog.w("  Remaining #" + i + ": " + AlarmManagerService.this.mInFlight.get(i));
                        }
                        AlarmManagerService.this.mInFlight.clear();
                    }
                } else if (AlarmManagerService.this.mInFlight.size() > 0) {
                    InFlight inFlight = AlarmManagerService.this.mInFlight.get(0);
                    AlarmManagerService.this.setWakelockWorkSource(inFlight.mPendingIntent, inFlight.mWorkSource, inFlight.mAlarmType, inFlight.mTag, false);
                } else {
                    AlarmManagerService.this.mLog.w("Alarm wakelock still held but sent queue empty");
                    AlarmManagerService.this.mWakeLock.setWorkSource(null);
                }
            }
        }
    }

    class UninstallReceiver
    extends BroadcastReceiver {
        public UninstallReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.PACKAGE_REMOVED");
            filter.addAction("android.intent.action.PACKAGE_RESTARTED");
            filter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
            filter.addDataScheme("package");
            AlarmManagerService.this.getContext().registerReceiver(this, filter);
            IntentFilter sdFilter = new IntentFilter();
            sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
            sdFilter.addAction("android.intent.action.USER_STOPPED");
            AlarmManagerService.this.getContext().registerReceiver(this, sdFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                String action = intent.getAction();
                String[] pkgList = null;
                if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
                    for (String packageName : pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES")) {
                        if (!AlarmManagerService.this.lookForPackageLocked(packageName)) continue;
                        this.setResultCode(-1);
                        return;
                    }
                    return;
                }
                if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                } else if ("android.intent.action.USER_STOPPED".equals(action)) {
                    int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                    if (userHandle >= 0) {
                        AlarmManagerService.this.removeUserLocked(userHandle);
                    }
                } else {
                    String pkg;
                    if ("android.intent.action.PACKAGE_REMOVED".equals(action) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                        return;
                    }
                    Uri data = intent.getData();
                    if (data != null && (pkg = data.getSchemeSpecificPart()) != null) {
                        pkgList = new String[]{pkg};
                    }
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkg : pkgList) {
                        AlarmManagerService.this.removeLocked(pkg);
                        AlarmManagerService.this.mPriorities.remove(pkg);
                        for (int i = AlarmManagerService.this.mBroadcastStats.size() - 1; i >= 0; --i) {
                            ArrayMap<String, BroadcastStats> uidStats = AlarmManagerService.this.mBroadcastStats.valueAt(i);
                            if (uidStats.remove(pkg) == null || uidStats.size() > 0) continue;
                            AlarmManagerService.this.mBroadcastStats.removeAt(i);
                        }
                    }
                }
            }
        }
    }

    class InteractiveStateReceiver
    extends BroadcastReceiver {
        public InteractiveStateReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.SCREEN_OFF");
            filter.addAction("android.intent.action.SCREEN_ON");
            filter.setPriority(1000);
            AlarmManagerService.this.getContext().registerReceiver(this, filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = AlarmManagerService.this.mLock;
            synchronized (object) {
                AlarmManagerService.this.interactiveStateChangedLocked("android.intent.action.SCREEN_ON".equals(intent.getAction()));
            }
        }
    }

    class ClockReceiver
    extends BroadcastReceiver {
        public ClockReceiver() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.DATE_CHANGED");
            AlarmManagerService.this.getContext().registerReceiver(this, filter);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.TIME_TICK")) {
                this.scheduleTimeTickEvent();
            } else if (intent.getAction().equals("android.intent.action.DATE_CHANGED")) {
                TimeZone zone = TimeZone.getTimeZone(SystemProperties.get(AlarmManagerService.TIMEZONE_PROPERTY));
                int gmtOffset = zone.getOffset(System.currentTimeMillis());
                AlarmManagerService.this.setKernelTimezone(AlarmManagerService.this.mNativeData, -(gmtOffset / 60000));
                this.scheduleDateChangedEvent();
            }
        }

        public void scheduleTimeTickEvent() {
            long currentTime = System.currentTimeMillis();
            long nextTime = 60000L * (currentTime / 60000L + 1L);
            long tickEventDelay = nextTime - currentTime;
            WorkSource workSource = null;
            AlarmManagerService.this.setImpl(3, SystemClock.elapsedRealtime() + tickEventDelay, 0L, 0L, AlarmManagerService.this.mTimeTickSender, true, workSource, null);
        }

        public void scheduleDateChangedEvent() {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(System.currentTimeMillis());
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(5, 1);
            WorkSource workSource = null;
            AlarmManagerService.this.setImpl(1, calendar.getTimeInMillis(), 0L, 0L, AlarmManagerService.this.mDateChangeSender, true, workSource, null);
        }
    }

    private class AlarmHandler
    extends Handler {
        public static final int ALARM_EVENT = 1;
        public static final int MINUTE_CHANGE_EVENT = 2;
        public static final int DATE_CHANGE_EVENT = 3;
        public static final int SEND_NEXT_ALARM_CLOCK_CHANGED = 4;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (msg.what == 1) {
                ArrayList<Alarm> triggerList = new ArrayList<Alarm>();
                Object object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    long nowRTC = System.currentTimeMillis();
                    long nowELAPSED = SystemClock.elapsedRealtime();
                    AlarmManagerService.this.triggerAlarmsLocked(triggerList, nowELAPSED, nowRTC);
                    AlarmManagerService.this.updateNextAlarmClockLocked();
                }
                for (int i = 0; i < triggerList.size(); ++i) {
                    Alarm alarm = triggerList.get(i);
                    try {
                        alarm.operation.send();
                        continue;
                    }
                    catch (PendingIntent.CanceledException e) {
                        if (alarm.repeatInterval <= 0L) continue;
                        AlarmManagerService.this.removeImpl(alarm.operation);
                    }
                }
            } else if (msg.what == 4) {
                AlarmManagerService.this.sendNextAlarmClockChanged();
            }
        }
    }

    private class AlarmThread
    extends Thread {
        public AlarmThread() {
            super(AlarmManagerService.TAG);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Alarm> triggerList = new ArrayList<Alarm>();
            while (true) {
                Object object;
                int result = AlarmManagerService.this.waitForAlarm(AlarmManagerService.this.mNativeData);
                triggerList.clear();
                if ((result & 0x10000) != 0) {
                    AlarmManagerService.this.removeImpl(AlarmManagerService.this.mTimeTickSender);
                    AlarmManagerService.this.rebatchAllAlarms();
                    AlarmManagerService.this.mClockReceiver.scheduleTimeTickEvent();
                    object = AlarmManagerService.this.mLock;
                    synchronized (object) {
                        ++AlarmManagerService.this.mNumTimeChanged;
                    }
                    Intent intent = new Intent("android.intent.action.TIME_SET");
                    intent.addFlags(0x24000000);
                    AlarmManagerService.this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL);
                }
                object = AlarmManagerService.this.mLock;
                synchronized (object) {
                    long nowRTC = System.currentTimeMillis();
                    long nowELAPSED = SystemClock.elapsedRealtime();
                    boolean hasWakeup = AlarmManagerService.this.triggerAlarmsLocked(triggerList, nowELAPSED, nowRTC);
                    if (!hasWakeup && AlarmManagerService.this.checkAllowNonWakeupDelayLocked(nowELAPSED)) {
                        if (AlarmManagerService.this.mPendingNonWakeupAlarms.size() == 0) {
                            AlarmManagerService.this.mStartCurrentDelayTime = nowELAPSED;
                            AlarmManagerService.this.mNextNonWakeupDeliveryTime = nowELAPSED + AlarmManagerService.this.currentNonWakeupFuzzLocked(nowELAPSED) * 3L / 2L;
                        }
                        AlarmManagerService.this.mPendingNonWakeupAlarms.addAll(triggerList);
                        AlarmManagerService.this.mNumDelayedAlarms += triggerList.size();
                        AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                        AlarmManagerService.this.updateNextAlarmClockLocked();
                    } else {
                        AlarmManagerService.this.rescheduleKernelAlarmsLocked();
                        AlarmManagerService.this.updateNextAlarmClockLocked();
                        if (AlarmManagerService.this.mPendingNonWakeupAlarms.size() > 0) {
                            AlarmManagerService.this.calculateDeliveryPriorities(AlarmManagerService.this.mPendingNonWakeupAlarms);
                            triggerList.addAll(AlarmManagerService.this.mPendingNonWakeupAlarms);
                            Collections.sort(triggerList, AlarmManagerService.this.mAlarmDispatchComparator);
                            long thisDelayTime = nowELAPSED - AlarmManagerService.this.mStartCurrentDelayTime;
                            AlarmManagerService.this.mTotalDelayTime += thisDelayTime;
                            if (AlarmManagerService.this.mMaxDelayTime < thisDelayTime) {
                                AlarmManagerService.this.mMaxDelayTime = thisDelayTime;
                            }
                            AlarmManagerService.this.mPendingNonWakeupAlarms.clear();
                        }
                        AlarmManagerService.this.deliverAlarmsLocked(triggerList, nowELAPSED);
                    }
                }
            }
        }
    }

    private static class Alarm {
        public final int type;
        public final boolean wakeup;
        public final PendingIntent operation;
        public final String tag;
        public final WorkSource workSource;
        public int count;
        public long when;
        public long windowLength;
        public long whenElapsed;
        public long maxWhen;
        public long repeatInterval;
        public final AlarmManager.AlarmClockInfo alarmClock;
        public final int userId;
        public PriorityClass priorityClass;

        public Alarm(int _type, long _when, long _whenElapsed, long _windowLength, long _maxWhen, long _interval, PendingIntent _op, WorkSource _ws, AlarmManager.AlarmClockInfo _info, int _userId) {
            this.type = _type;
            this.wakeup = _type == 2 || _type == 0;
            this.when = _when;
            this.whenElapsed = _whenElapsed;
            this.windowLength = _windowLength;
            this.maxWhen = _maxWhen;
            this.repeatInterval = _interval;
            this.operation = _op;
            this.tag = Alarm.makeTag(_op, _type);
            this.workSource = _ws;
            this.alarmClock = _info;
            this.userId = _userId;
        }

        public static String makeTag(PendingIntent pi, int type) {
            return pi.getTag(type == 2 || type == 0 ? "*walarm*:" : "*alarm*:");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Alarm{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" type ");
            sb.append(this.type);
            sb.append(" when ");
            sb.append(this.when);
            sb.append(" ");
            sb.append(this.operation.getTargetPackage());
            sb.append('}');
            return sb.toString();
        }

        public void dump(PrintWriter pw, String prefix, long nowRTC, long nowELAPSED, SimpleDateFormat sdf) {
            boolean isRtc = this.type == 1 || this.type == 0;
            pw.print(prefix);
            pw.print("tag=");
            pw.println(this.tag);
            pw.print(prefix);
            pw.print("type=");
            pw.print(this.type);
            pw.print(" whenElapsed=");
            TimeUtils.formatDuration(this.whenElapsed, nowELAPSED, pw);
            if (isRtc) {
                pw.print(" when=");
                pw.print(sdf.format(new Date(this.when)));
            } else {
                pw.print(" when=");
                TimeUtils.formatDuration(this.when, nowELAPSED, pw);
            }
            pw.println();
            pw.print(prefix);
            pw.print("window=");
            pw.print(this.windowLength);
            pw.print(" repeatInterval=");
            pw.print(this.repeatInterval);
            pw.print(" count=");
            pw.println(this.count);
            pw.print(prefix);
            pw.print("operation=");
            pw.println(this.operation);
        }
    }

    public static class IncreasingTimeOrder
    implements Comparator<Alarm> {
        @Override
        public int compare(Alarm a1, Alarm a2) {
            long when1 = a1.when;
            long when2 = a2.when;
            if (when1 - when2 > 0L) {
                return 1;
            }
            if (when1 - when2 < 0L) {
                return -1;
            }
            return 0;
        }
    }

    static final class BroadcastStats {
        final int mUid;
        final String mPackageName;
        long aggregateTime;
        int count;
        int numWakeup;
        long startTime;
        int nesting;
        final ArrayMap<String, FilterStats> filterStats = new ArrayMap();

        BroadcastStats(int uid, String packageName) {
            this.mUid = uid;
            this.mPackageName = packageName;
        }
    }

    static final class FilterStats {
        final BroadcastStats mBroadcastStats;
        final String mTag;
        long aggregateTime;
        int count;
        int numWakeup;
        long startTime;
        int nesting;

        FilterStats(BroadcastStats broadcastStats, String tag) {
            this.mBroadcastStats = broadcastStats;
            this.mTag = tag;
        }
    }

    static final class InFlight
    extends Intent {
        final PendingIntent mPendingIntent;
        final WorkSource mWorkSource;
        final String mTag;
        final BroadcastStats mBroadcastStats;
        final FilterStats mFilterStats;
        final int mAlarmType;

        InFlight(AlarmManagerService service, PendingIntent pendingIntent, WorkSource workSource, int alarmType, String tag) {
            this.mPendingIntent = pendingIntent;
            this.mWorkSource = workSource;
            this.mTag = tag;
            this.mBroadcastStats = service.getStatsLocked(pendingIntent);
            FilterStats fs = this.mBroadcastStats.filterStats.get(this.mTag);
            if (fs == null) {
                fs = new FilterStats(this.mBroadcastStats, this.mTag);
                this.mBroadcastStats.filterStats.put(this.mTag, fs);
            }
            this.mFilterStats = fs;
            this.mAlarmType = alarmType;
        }
    }

    static class BatchTimeOrder
    implements Comparator<Batch> {
        BatchTimeOrder() {
        }

        @Override
        public int compare(Batch b1, Batch b2) {
            long when1 = b1.start;
            long when2 = b2.start;
            if (when1 - when2 > 0L) {
                return 1;
            }
            if (when1 - when2 < 0L) {
                return -1;
            }
            return 0;
        }
    }

    final class Batch {
        long start;
        long end;
        boolean standalone;
        final ArrayList<Alarm> alarms = new ArrayList();

        Batch() {
            this.start = 0L;
            this.end = Long.MAX_VALUE;
        }

        Batch(Alarm seed) {
            this.start = seed.whenElapsed;
            this.end = seed.maxWhen;
            this.alarms.add(seed);
        }

        int size() {
            return this.alarms.size();
        }

        Alarm get(int index) {
            return this.alarms.get(index);
        }

        boolean canHold(long whenElapsed, long maxWhen) {
            return this.end >= whenElapsed && this.start <= maxWhen;
        }

        boolean add(Alarm alarm) {
            boolean newStart = false;
            int index = Collections.binarySearch(this.alarms, alarm, sIncreasingTimeOrder);
            if (index < 0) {
                index = 0 - index - 1;
            }
            this.alarms.add(index, alarm);
            if (alarm.whenElapsed > this.start) {
                this.start = alarm.whenElapsed;
                newStart = true;
            }
            if (alarm.maxWhen < this.end) {
                this.end = alarm.maxWhen;
            }
            return newStart;
        }

        boolean remove(PendingIntent operation) {
            boolean didRemove = false;
            long newStart = 0L;
            long newEnd = Long.MAX_VALUE;
            int i = 0;
            while (i < this.alarms.size()) {
                Alarm alarm = this.alarms.get(i);
                if (alarm.operation.equals(operation)) {
                    this.alarms.remove(i);
                    didRemove = true;
                    if (alarm.alarmClock == null) continue;
                    AlarmManagerService.this.mNextAlarmClockMayChange = true;
                    continue;
                }
                if (alarm.whenElapsed > newStart) {
                    newStart = alarm.whenElapsed;
                }
                if (alarm.maxWhen < newEnd) {
                    newEnd = alarm.maxWhen;
                }
                ++i;
            }
            if (didRemove) {
                this.start = newStart;
                this.end = newEnd;
            }
            return didRemove;
        }

        boolean remove(String packageName) {
            boolean didRemove = false;
            long newStart = 0L;
            long newEnd = Long.MAX_VALUE;
            int i = 0;
            while (i < this.alarms.size()) {
                Alarm alarm = this.alarms.get(i);
                if (alarm.operation.getTargetPackage().equals(packageName)) {
                    this.alarms.remove(i);
                    didRemove = true;
                    if (alarm.alarmClock == null) continue;
                    AlarmManagerService.this.mNextAlarmClockMayChange = true;
                    continue;
                }
                if (alarm.whenElapsed > newStart) {
                    newStart = alarm.whenElapsed;
                }
                if (alarm.maxWhen < newEnd) {
                    newEnd = alarm.maxWhen;
                }
                ++i;
            }
            if (didRemove) {
                this.start = newStart;
                this.end = newEnd;
            }
            return didRemove;
        }

        boolean remove(int userHandle) {
            boolean didRemove = false;
            long newStart = 0L;
            long newEnd = Long.MAX_VALUE;
            int i = 0;
            while (i < this.alarms.size()) {
                Alarm alarm = this.alarms.get(i);
                if (UserHandle.getUserId(alarm.operation.getCreatorUid()) == userHandle) {
                    this.alarms.remove(i);
                    didRemove = true;
                    if (alarm.alarmClock == null) continue;
                    AlarmManagerService.this.mNextAlarmClockMayChange = true;
                    continue;
                }
                if (alarm.whenElapsed > newStart) {
                    newStart = alarm.whenElapsed;
                }
                if (alarm.maxWhen < newEnd) {
                    newEnd = alarm.maxWhen;
                }
                ++i;
            }
            if (didRemove) {
                this.start = newStart;
                this.end = newEnd;
            }
            return didRemove;
        }

        boolean hasPackage(String packageName) {
            int N = this.alarms.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = this.alarms.get(i);
                if (!a.operation.getTargetPackage().equals(packageName)) continue;
                return true;
            }
            return false;
        }

        boolean hasWakeups() {
            int N = this.alarms.size();
            for (int i = 0; i < N; ++i) {
                Alarm a = this.alarms.get(i);
                if ((a.type & 1) != 0) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder b = new StringBuilder(40);
            b.append("Batch{");
            b.append(Integer.toHexString(this.hashCode()));
            b.append(" num=");
            b.append(this.size());
            b.append(" start=");
            b.append(this.start);
            b.append(" end=");
            b.append(this.end);
            if (this.standalone) {
                b.append(" STANDALONE");
            }
            b.append('}');
            return b.toString();
        }
    }

    class WakeupEvent {
        public long when;
        public int uid;
        public String action;

        public WakeupEvent(long theTime, int theUid, String theAction) {
            this.when = theTime;
            this.uid = theUid;
            this.action = theAction;
        }
    }

    class PriorityClass {
        int seq;
        int priority;

        PriorityClass() {
            this.seq = AlarmManagerService.this.mCurrentSeq - 1;
            this.priority = 2;
        }
    }
}

