/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.os.BatteryManagerInternal;
import android.os.BatteryProperties;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBatteryPropertiesListener;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UEventObserver;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import com.android.server.SystemService;
import com.android.server.am.BatteryStatsService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public final class BatteryService
extends SystemService {
    private static final String TAG = BatteryService.class.getSimpleName();
    private static final boolean DEBUG = false;
    private static final int BATTERY_SCALE = 100;
    private int mCriticalBatteryLevel;
    private static final int DUMP_MAX_LENGTH = 24576;
    private static final String[] DUMPSYS_ARGS = new String[]{"--checkin", "--unplugged"};
    private static final String DUMPSYS_DATA_PATH = "/data/system/";
    private static final int BATTERY_PLUGGED_NONE = 0;
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    private final Handler mHandler;
    private final Object mLock = new Object();
    private BatteryProperties mBatteryProps;
    private final BatteryProperties mLastBatteryProps = new BatteryProperties();
    private boolean mBatteryLevelCritical;
    private int mLastBatteryStatus;
    private int mLastBatteryHealth;
    private boolean mLastBatteryPresent;
    private int mLastBatteryLevel;
    private int mLastBatteryVoltage;
    private int mLastBatteryTemperature;
    private boolean mLastBatteryLevelCritical;
    private int mInvalidCharger;
    private int mLastInvalidCharger;
    private int mLowBatteryWarningLevel;
    private int mLowBatteryCloseWarningLevel;
    private int mShutdownBatteryTemperature;
    private int mPlugType;
    private int mLastPlugType = -1;
    private boolean mBatteryLevelLow;
    private long mDischargeStartTime;
    private int mDischargeStartLevel;
    private boolean mUpdatesStopped;
    private Led mLed;
    private boolean mSentLowBatteryBroadcast = false;
    private final UEventObserver mInvalidChargerObserver = new UEventObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUEvent(UEventObserver.UEvent event) {
            int invalidCharger = "1".equals(event.get("SWITCH_STATE")) ? 1 : 0;
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                if (BatteryService.this.mInvalidCharger != invalidCharger) {
                    BatteryService.this.mInvalidCharger = invalidCharger;
                }
            }
        }
    };

    public BatteryService(Context context) {
        super(context);
        this.mContext = context;
        this.mHandler = new Handler(true);
        this.mLed = new Led(context, this.getLocalService(LightsManager.class));
        this.mBatteryStats = BatteryStatsService.getService();
        this.mCriticalBatteryLevel = this.mContext.getResources().getInteger(17694781);
        this.mLowBatteryWarningLevel = this.mContext.getResources().getInteger(17694783);
        this.mLowBatteryCloseWarningLevel = this.mLowBatteryWarningLevel + this.mContext.getResources().getInteger(17694784);
        this.mShutdownBatteryTemperature = this.mContext.getResources().getInteger(17694782);
        if (new File("/sys/devices/virtual/switch/invalid_charger/state").exists()) {
            this.mInvalidChargerObserver.startObserving("DEVPATH=/devices/virtual/switch/invalid_charger");
        }
    }

    @Override
    public void onStart() {
        IBinder b = ServiceManager.getService("batteryproperties");
        IBatteryPropertiesRegistrar batteryPropertiesRegistrar = IBatteryPropertiesRegistrar.Stub.asInterface(b);
        try {
            batteryPropertiesRegistrar.registerListener(new BatteryListener());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.publishBinderService("battery", new BinderService());
        this.publishLocalService(BatteryManagerInternal.class, new LocalService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 550) {
            Object object = this.mLock;
            synchronized (object) {
                ContentObserver obs = new ContentObserver(this.mHandler){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onChange(boolean selfChange) {
                        Object object = BatteryService.this.mLock;
                        synchronized (object) {
                            BatteryService.this.updateBatteryWarningLevelLocked();
                        }
                    }
                };
                ContentResolver resolver = this.mContext.getContentResolver();
                resolver.registerContentObserver(Settings.Global.getUriFor("low_power_trigger_level"), false, obs, -1);
                this.updateBatteryWarningLevelLocked();
            }
        }
    }

    private void updateBatteryWarningLevelLocked() {
        ContentResolver resolver = this.mContext.getContentResolver();
        int defWarnLevel = this.mContext.getResources().getInteger(17694783);
        this.mLowBatteryWarningLevel = Settings.Global.getInt(resolver, "low_power_trigger_level", defWarnLevel);
        if (this.mLowBatteryWarningLevel == 0) {
            this.mLowBatteryWarningLevel = defWarnLevel;
        }
        if (this.mLowBatteryWarningLevel < this.mCriticalBatteryLevel) {
            this.mLowBatteryWarningLevel = this.mCriticalBatteryLevel;
        }
        this.mLowBatteryCloseWarningLevel = this.mLowBatteryWarningLevel + this.mContext.getResources().getInteger(17694784);
        this.processValuesLocked(true);
    }

    private boolean isPoweredLocked(int plugTypeSet) {
        if (this.mBatteryProps.batteryStatus == 1) {
            return true;
        }
        if ((plugTypeSet & 1) != 0 && this.mBatteryProps.chargerAcOnline) {
            return true;
        }
        if ((plugTypeSet & 2) != 0 && this.mBatteryProps.chargerUsbOnline) {
            return true;
        }
        return (plugTypeSet & 4) != 0 && this.mBatteryProps.chargerWirelessOnline;
    }

    private boolean shouldSendBatteryLowLocked() {
        boolean plugged = this.mPlugType != 0;
        boolean oldPlugged = this.mLastPlugType != 0;
        return !plugged && this.mBatteryProps.batteryStatus != 1 && this.mBatteryProps.batteryLevel <= this.mLowBatteryWarningLevel && (oldPlugged || this.mLastBatteryLevel > this.mLowBatteryWarningLevel);
    }

    private void shutdownIfNoPowerLocked() {
        if (this.mBatteryProps.batteryLevel == 0 && !this.isPoweredLocked(7)) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (ActivityManagerNative.isSystemReady()) {
                        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
                        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
                        intent.setFlags(0x10000000);
                        BatteryService.this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
                    }
                }
            });
        }
    }

    private void shutdownIfOverTempLocked() {
        if (this.mBatteryProps.batteryTemperature > this.mShutdownBatteryTemperature) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (ActivityManagerNative.isSystemReady()) {
                        Intent intent = new Intent("android.intent.action.ACTION_REQUEST_SHUTDOWN");
                        intent.putExtra("android.intent.extra.KEY_CONFIRM", false);
                        intent.setFlags(0x10000000);
                        BatteryService.this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(BatteryProperties props) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mUpdatesStopped) {
                this.mBatteryProps = props;
                this.processValuesLocked(false);
            } else {
                this.mLastBatteryProps.set(props);
            }
        }
    }

    private void processValuesLocked(boolean force) {
        boolean logOutlier = false;
        long dischargeDuration = 0L;
        boolean bl = this.mBatteryLevelCritical = this.mBatteryProps.batteryLevel <= this.mCriticalBatteryLevel;
        this.mPlugType = this.mBatteryProps.chargerAcOnline ? 1 : (this.mBatteryProps.chargerUsbOnline ? 2 : (this.mBatteryProps.chargerWirelessOnline ? 4 : 0));
        try {
            this.mBatteryStats.setBatteryState(this.mBatteryProps.batteryStatus, this.mBatteryProps.batteryHealth, this.mPlugType, this.mBatteryProps.batteryLevel, this.mBatteryProps.batteryTemperature, this.mBatteryProps.batteryVoltage);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.shutdownIfNoPowerLocked();
        this.shutdownIfOverTempLocked();
        if (force || this.mBatteryProps.batteryStatus != this.mLastBatteryStatus || this.mBatteryProps.batteryHealth != this.mLastBatteryHealth || this.mBatteryProps.batteryPresent != this.mLastBatteryPresent || this.mBatteryProps.batteryLevel != this.mLastBatteryLevel || this.mPlugType != this.mLastPlugType || this.mBatteryProps.batteryVoltage != this.mLastBatteryVoltage || this.mBatteryProps.batteryTemperature != this.mLastBatteryTemperature || this.mInvalidCharger != this.mLastInvalidCharger) {
            if (this.mPlugType != this.mLastPlugType) {
                if (this.mLastPlugType == 0) {
                    if (this.mDischargeStartTime != 0L && this.mDischargeStartLevel != this.mBatteryProps.batteryLevel) {
                        dischargeDuration = SystemClock.elapsedRealtime() - this.mDischargeStartTime;
                        logOutlier = true;
                        EventLog.writeEvent(2730, dischargeDuration, this.mDischargeStartLevel, this.mBatteryProps.batteryLevel);
                        this.mDischargeStartTime = 0L;
                    }
                } else if (this.mPlugType == 0) {
                    this.mDischargeStartTime = SystemClock.elapsedRealtime();
                    this.mDischargeStartLevel = this.mBatteryProps.batteryLevel;
                }
            }
            if (this.mBatteryProps.batteryStatus != this.mLastBatteryStatus || this.mBatteryProps.batteryHealth != this.mLastBatteryHealth || this.mBatteryProps.batteryPresent != this.mLastBatteryPresent || this.mPlugType != this.mLastPlugType) {
                EventLog.writeEvent(2723, this.mBatteryProps.batteryStatus, this.mBatteryProps.batteryHealth, this.mBatteryProps.batteryPresent ? 1 : 0, this.mPlugType, this.mBatteryProps.batteryTechnology);
            }
            if (this.mBatteryProps.batteryLevel != this.mLastBatteryLevel) {
                EventLog.writeEvent(2722, this.mBatteryProps.batteryLevel, this.mBatteryProps.batteryVoltage, this.mBatteryProps.batteryTemperature);
            }
            if (this.mBatteryLevelCritical && !this.mLastBatteryLevelCritical && this.mPlugType == 0) {
                dischargeDuration = SystemClock.elapsedRealtime() - this.mDischargeStartTime;
                logOutlier = true;
            }
            if (!this.mBatteryLevelLow) {
                if (this.mPlugType == 0 && this.mBatteryProps.batteryLevel <= this.mLowBatteryWarningLevel) {
                    this.mBatteryLevelLow = true;
                }
            } else if (this.mPlugType != 0) {
                this.mBatteryLevelLow = false;
            } else if (this.mBatteryProps.batteryLevel >= this.mLowBatteryCloseWarningLevel) {
                this.mBatteryLevelLow = false;
            } else if (force && this.mBatteryProps.batteryLevel >= this.mLowBatteryWarningLevel) {
                this.mBatteryLevelLow = false;
            }
            this.sendIntentLocked();
            if (this.mPlugType != 0 && this.mLastPlugType == 0) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Intent statusIntent = new Intent("android.intent.action.ACTION_POWER_CONNECTED");
                        statusIntent.setFlags(0x4000000);
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            } else if (this.mPlugType == 0 && this.mLastPlugType != 0) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Intent statusIntent = new Intent("android.intent.action.ACTION_POWER_DISCONNECTED");
                        statusIntent.setFlags(0x4000000);
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            }
            if (this.shouldSendBatteryLowLocked()) {
                this.mSentLowBatteryBroadcast = true;
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Intent statusIntent = new Intent("android.intent.action.BATTERY_LOW");
                        statusIntent.setFlags(0x4000000);
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            } else if (this.mSentLowBatteryBroadcast && this.mLastBatteryLevel >= this.mLowBatteryCloseWarningLevel) {
                this.mSentLowBatteryBroadcast = false;
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Intent statusIntent = new Intent("android.intent.action.BATTERY_OKAY");
                        statusIntent.setFlags(0x4000000);
                        BatteryService.this.mContext.sendBroadcastAsUser(statusIntent, UserHandle.ALL);
                    }
                });
            }
            this.mLed.updateLightsLocked();
            if (logOutlier && dischargeDuration != 0L) {
                this.logOutlierLocked(dischargeDuration);
            }
            this.mLastBatteryStatus = this.mBatteryProps.batteryStatus;
            this.mLastBatteryHealth = this.mBatteryProps.batteryHealth;
            this.mLastBatteryPresent = this.mBatteryProps.batteryPresent;
            this.mLastBatteryLevel = this.mBatteryProps.batteryLevel;
            this.mLastPlugType = this.mPlugType;
            this.mLastBatteryVoltage = this.mBatteryProps.batteryVoltage;
            this.mLastBatteryTemperature = this.mBatteryProps.batteryTemperature;
            this.mLastBatteryLevelCritical = this.mBatteryLevelCritical;
            this.mLastInvalidCharger = this.mInvalidCharger;
        }
    }

    private void sendIntentLocked() {
        final Intent intent = new Intent("android.intent.action.BATTERY_CHANGED");
        intent.addFlags(0x60000000);
        int icon = this.getIconLocked(this.mBatteryProps.batteryLevel);
        intent.putExtra("status", this.mBatteryProps.batteryStatus);
        intent.putExtra("health", this.mBatteryProps.batteryHealth);
        intent.putExtra("present", this.mBatteryProps.batteryPresent);
        intent.putExtra("level", this.mBatteryProps.batteryLevel);
        intent.putExtra("scale", 100);
        intent.putExtra("icon-small", icon);
        intent.putExtra("plugged", this.mPlugType);
        intent.putExtra("voltage", this.mBatteryProps.batteryVoltage);
        intent.putExtra("temperature", this.mBatteryProps.batteryTemperature);
        intent.putExtra("technology", this.mBatteryProps.batteryTechnology);
        intent.putExtra("invalid_charger", this.mInvalidCharger);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                ActivityManagerNative.broadcastStickyIntent(intent, null, -1);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logBatteryStatsLocked() {
        IBinder batteryInfoService = ServiceManager.getService("batterystats");
        if (batteryInfoService == null) {
            return;
        }
        DropBoxManager db = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (db == null || !db.isTagEnabled("BATTERY_DISCHARGE_INFO")) {
            return;
        }
        File dumpFile = null;
        FileOutputStream dumpStream = null;
        try {
            dumpFile = new File("/data/system/batterystats.dump");
            dumpStream = new FileOutputStream(dumpFile);
            batteryInfoService.dump(dumpStream.getFD(), DUMPSYS_ARGS);
            FileUtils.sync(dumpStream);
            db.addFile("BATTERY_DISCHARGE_INFO", dumpFile, 2);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "failed to dump battery service", e);
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to write dumpsys file", e);
        }
        finally {
            if (dumpStream != null) {
                try {
                    dumpStream.close();
                }
                catch (IOException e) {
                    Slog.e(TAG, "failed to close dumpsys output stream");
                }
            }
            if (dumpFile != null && !dumpFile.delete()) {
                Slog.e(TAG, "failed to delete temporary dumpsys file: " + dumpFile.getAbsolutePath());
            }
        }
    }

    private void logOutlierLocked(long duration) {
        ContentResolver cr = this.mContext.getContentResolver();
        String dischargeThresholdString = Settings.Global.getString(cr, "battery_discharge_threshold");
        String durationThresholdString = Settings.Global.getString(cr, "battery_discharge_duration_threshold");
        if (dischargeThresholdString != null && durationThresholdString != null) {
            try {
                long durationThreshold = Long.parseLong(durationThresholdString);
                int dischargeThreshold = Integer.parseInt(dischargeThresholdString);
                if (duration <= durationThreshold && this.mDischargeStartLevel - this.mBatteryProps.batteryLevel >= dischargeThreshold) {
                    this.logBatteryStatsLocked();
                }
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "Invalid DischargeThresholds GService string: " + durationThresholdString + " or " + dischargeThresholdString);
                return;
            }
        }
    }

    private int getIconLocked(int level) {
        if (this.mBatteryProps.batteryStatus == 2) {
            return 17303142;
        }
        if (this.mBatteryProps.batteryStatus == 3) {
            return 17303128;
        }
        if (this.mBatteryProps.batteryStatus == 4 || this.mBatteryProps.batteryStatus == 5) {
            if (this.isPoweredLocked(7) && this.mBatteryProps.batteryLevel >= 100) {
                return 17303142;
            }
            return 17303128;
        }
        return 17303156;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dumpInternal(PrintWriter pw, String[] args) {
        Object object = this.mLock;
        synchronized (object) {
            if (args == null || args.length == 0 || "-a".equals(args[0])) {
                pw.println("Current Battery Service state:");
                if (this.mUpdatesStopped) {
                    pw.println("  (UPDATES STOPPED -- use 'reset' to restart)");
                }
                pw.println("  AC powered: " + this.mBatteryProps.chargerAcOnline);
                pw.println("  USB powered: " + this.mBatteryProps.chargerUsbOnline);
                pw.println("  Wireless powered: " + this.mBatteryProps.chargerWirelessOnline);
                pw.println("  status: " + this.mBatteryProps.batteryStatus);
                pw.println("  health: " + this.mBatteryProps.batteryHealth);
                pw.println("  present: " + this.mBatteryProps.batteryPresent);
                pw.println("  level: " + this.mBatteryProps.batteryLevel);
                pw.println("  scale: 100");
                pw.println("  voltage: " + this.mBatteryProps.batteryVoltage);
                pw.println("  temperature: " + this.mBatteryProps.batteryTemperature);
                pw.println("  technology: " + this.mBatteryProps.batteryTechnology);
            } else if (args.length == 3 && "set".equals(args[0])) {
                String key = args[1];
                String value = args[2];
                try {
                    if (!this.mUpdatesStopped) {
                        this.mLastBatteryProps.set(this.mBatteryProps);
                    }
                    boolean update = true;
                    if ("ac".equals(key)) {
                        this.mBatteryProps.chargerAcOnline = Integer.parseInt(value) != 0;
                    } else if ("usb".equals(key)) {
                        this.mBatteryProps.chargerUsbOnline = Integer.parseInt(value) != 0;
                    } else if ("wireless".equals(key)) {
                        this.mBatteryProps.chargerWirelessOnline = Integer.parseInt(value) != 0;
                    } else if ("status".equals(key)) {
                        this.mBatteryProps.batteryStatus = Integer.parseInt(value);
                    } else if ("level".equals(key)) {
                        this.mBatteryProps.batteryLevel = Integer.parseInt(value);
                    } else if ("invalid".equals(key)) {
                        this.mInvalidCharger = Integer.parseInt(value);
                    } else {
                        pw.println("Unknown set option: " + key);
                        return;
                    }
                    if (!update) return;
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.mUpdatesStopped = true;
                        this.processValuesLocked(false);
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                catch (NumberFormatException ex) {
                    pw.println("Bad value: " + value);
                }
            } else if (args.length == 1 && "reset".equals(args[0])) {
                long ident = Binder.clearCallingIdentity();
                try {
                    if (!this.mUpdatesStopped) return;
                    this.mUpdatesStopped = false;
                    this.mBatteryProps.set(this.mLastBatteryProps);
                    this.processValuesLocked(false);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            } else {
                pw.println("Dump current battery state, or:");
                pw.println("  set [ac|usb|wireless|status|level|invalid] <value>");
                pw.println("  reset");
            }
            return;
        }
    }

    private final class LocalService
    extends BatteryManagerInternal {
        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPowered(int plugTypeSet) {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.isPoweredLocked(plugTypeSet);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getPlugType() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.mPlugType;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getBatteryLevel() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return ((BatteryService)BatteryService.this).mBatteryProps.batteryLevel;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getBatteryLevelLow() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.mBatteryLevelLow;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInvalidCharger() {
            Object object = BatteryService.this.mLock;
            synchronized (object) {
                return BatteryService.this.mInvalidCharger;
            }
        }
    }

    private final class BinderService
    extends Binder {
        private BinderService() {
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (BatteryService.this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump Battery service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            BatteryService.this.dumpInternal(pw, args);
        }
    }

    private final class BatteryListener
    extends IBatteryPropertiesListener.Stub {
        private BatteryListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void batteryPropertiesChanged(BatteryProperties props) {
            long identity = Binder.clearCallingIdentity();
            try {
                BatteryService.this.update(props);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private final class Led {
        private final Light mBatteryLight;
        private final int mBatteryLowARGB;
        private final int mBatteryMediumARGB;
        private final int mBatteryFullARGB;
        private final int mBatteryLedOn;
        private final int mBatteryLedOff;

        public Led(Context context, LightsManager lights) {
            this.mBatteryLight = lights.getLight(3);
            this.mBatteryLowARGB = context.getResources().getInteger(17694787);
            this.mBatteryMediumARGB = context.getResources().getInteger(17694788);
            this.mBatteryFullARGB = context.getResources().getInteger(17694789);
            this.mBatteryLedOn = context.getResources().getInteger(17694790);
            this.mBatteryLedOff = context.getResources().getInteger(17694791);
        }

        public void updateLightsLocked() {
            int level = ((BatteryService)BatteryService.this).mBatteryProps.batteryLevel;
            int status = ((BatteryService)BatteryService.this).mBatteryProps.batteryStatus;
            if (level < BatteryService.this.mLowBatteryWarningLevel) {
                if (status == 2) {
                    this.mBatteryLight.setColor(this.mBatteryLowARGB);
                } else {
                    this.mBatteryLight.setFlashing(this.mBatteryLowARGB, 1, this.mBatteryLedOn, this.mBatteryLedOff);
                }
            } else if (status == 2 || status == 5) {
                if (status == 5 || level >= 90) {
                    this.mBatteryLight.setColor(this.mBatteryFullARGB);
                } else {
                    this.mBatteryLight.setColor(this.mBatteryMediumARGB);
                }
            } else {
                this.mBatteryLight.turnOff();
            }
        }
    }
}

