/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.content.res.ObbInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.os.storage.IMountServiceListener;
import android.os.storage.IMountShutdownObserver;
import android.os.storage.IObbActionListener;
import android.os.storage.StorageVolume;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.EventLogTags;
import com.android.server.INativeDaemonConnectorCallbacks;
import com.android.server.IoThread;
import com.android.server.MountServiceIdler;
import com.android.server.NativeDaemonConnector;
import com.android.server.NativeDaemonConnectorException;
import com.android.server.NativeDaemonEvent;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.UserManagerService;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.xmlpull.v1.XmlPullParserException;

class MountService
extends IMountService.Stub
implements INativeDaemonConnectorCallbacks,
Watchdog.Monitor {
    static MountService sSelf = null;
    private static final boolean LOCAL_LOGD = false;
    private static final boolean DEBUG_UNMOUNT = false;
    private static final boolean DEBUG_EVENTS = false;
    private static final boolean DEBUG_OBB = false;
    private static final boolean WATCHDOG_ENABLE = false;
    private static final String TAG = "MountService";
    private static final String VOLD_TAG = "VoldConnector";
    private static final int MAX_CONTAINERS = 250;
    public static final String[] CRYPTO_TYPES = new String[]{"password", "default", "pattern", "pin"};
    private final Context mContext;
    private final NativeDaemonConnector mConnector;
    private final Object mVolumesLock = new Object();
    private StorageVolume mEmulatedTemplate;
    @GuardedBy(value="mVolumesLock")
    private final ArrayList<StorageVolume> mVolumes = Lists.newArrayList();
    @GuardedBy(value="mVolumesLock")
    private final HashMap<String, StorageVolume> mVolumesByPath = Maps.newHashMap();
    @GuardedBy(value="mVolumesLock")
    private final HashMap<String, String> mVolumeStates = Maps.newHashMap();
    private volatile boolean mSystemReady = false;
    private PackageManagerService mPms;
    private boolean mUmsEnabling;
    private boolean mUmsAvailable = false;
    private final ArrayList<MountServiceBinderListener> mListeners = new ArrayList();
    private final CountDownLatch mConnectedSignal = new CountDownLatch(1);
    private final CountDownLatch mAsecsScanned = new CountDownLatch(1);
    private boolean mSendUmsConnectedOnBoot = false;
    private final HashSet<String> mAsecMountSet = new HashSet();
    private static final int CRYPTO_ALGORITHM_KEY_SIZE = 128;
    private static final int PBKDF2_HASH_ROUNDS = 1024;
    private final Map<IBinder, List<ObbState>> mObbMounts = new HashMap<IBinder, List<ObbState>>();
    private final Map<String, ObbState> mObbPathToStateMap = new HashMap<String, ObbState>();
    private final ObbActionHandler mObbActionHandler;
    private static final int OBB_RUN_ACTION = 1;
    private static final int OBB_MCS_BOUND = 2;
    private static final int OBB_MCS_UNBIND = 3;
    private static final int OBB_MCS_RECONNECT = 4;
    private static final int OBB_FLUSH_MOUNT_STATE = 5;
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    private IMediaContainerService mContainerService = null;
    private static final String LAST_FSTRIM_FILE = "last-fstrim";
    private final File mLastMaintenanceFile;
    private long mLastMaintenance;
    private static final int H_UNMOUNT_PM_UPDATE = 1;
    private static final int H_UNMOUNT_PM_DONE = 2;
    private static final int H_UNMOUNT_MS = 3;
    private static final int H_SYSTEM_READY = 4;
    private static final int H_FSTRIM = 5;
    private static final int RETRY_UNMOUNT_DELAY = 30;
    private static final int MAX_UNMOUNT_RETRIES = 4;
    private final Handler mHandler;
    private final BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if (userId == -1) {
                return;
            }
            UserHandle user = new UserHandle(userId);
            String action = intent.getAction();
            if ("android.intent.action.USER_ADDED".equals(action)) {
                Object object = MountService.this.mVolumesLock;
                synchronized (object) {
                    MountService.this.createEmulatedVolumeForUserLocked(user);
                }
            }
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                Object object = MountService.this.mVolumesLock;
                synchronized (object) {
                    ArrayList<StorageVolume> toRemove = Lists.newArrayList();
                    for (StorageVolume volume : MountService.this.mVolumes) {
                        if (!user.equals(volume.getOwner())) continue;
                        toRemove.add(volume);
                    }
                    for (StorageVolume volume : toRemove) {
                        MountService.this.removeVolumeLocked(volume);
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            boolean available = intent.getBooleanExtra("connected", false) && intent.getBooleanExtra("mass_storage", false);
            MountService.this.notifyShareAvailabilityChange(available);
        }
    };
    private static final String TAG_STORAGE_LIST = "StorageList";
    private static final String TAG_STORAGE = "storage";

    void waitForAsecScan() {
        this.waitForLatch(this.mAsecsScanned);
    }

    private void waitForReady() {
        this.waitForLatch(this.mConnectedSignal);
    }

    private void waitForLatch(CountDownLatch latch) {
        while (true) {
            try {
                while (true) {
                    if (latch.await(5000L, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                    Slog.w(TAG, "Thread " + Thread.currentThread().getName() + " still waiting for MountService ready...");
                }
            }
            catch (InterruptedException e) {
                Slog.w(TAG, "Interrupt while waiting for MountService to be ready.");
                continue;
            }
            break;
        }
    }

    private boolean isReady() {
        try {
            return this.mConnectedSignal.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSystemReady() {
        HashMap<String, String> snapshot;
        Object object = this.mVolumesLock;
        synchronized (object) {
            snapshot = new HashMap<String, String>(this.mVolumeStates);
        }
        for (Map.Entry<String, String> entry : snapshot.entrySet()) {
            String path = entry.getKey();
            String state = entry.getValue();
            if (state.equals("unmounted")) {
                int rc = this.doMountVolume(path);
                if (rc == 0) continue;
                Slog.e(TAG, String.format("Boot-time mount failed (%d)", rc));
                continue;
            }
            if (!state.equals("shared")) continue;
            this.notifyVolumeStateChange(null, path, 0, 7);
        }
        object = this.mVolumesLock;
        synchronized (object) {
            for (StorageVolume volume : this.mVolumes) {
                if (!volume.isEmulated()) continue;
                this.updatePublicVolumeState(volume, "mounted");
            }
        }
        if (this.mSendUmsConnectedOnBoot) {
            this.sendUmsIntent(true);
            this.mSendUmsConnectedOnBoot = false;
        }
        MountServiceIdler.scheduleIdlePass(this.mContext);
    }

    void runIdleMaintenance(Runnable callback) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, callback));
    }

    @Override
    public void runMaintenance() {
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.runIdleMaintenance(null);
    }

    @Override
    public long lastMaintenance() {
        return this.mLastMaintenance;
    }

    private void doShareUnshareVolume(String path, String method, boolean enable) {
        if (!method.equals("ums")) {
            throw new IllegalArgumentException(String.format("Method %s not supported", method));
        }
        try {
            this.mConnector.execute("volume", enable ? "share" : "unshare", path, method);
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to share/unshare", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePublicVolumeState(StorageVolume volume, String state) {
        String oldState;
        String path = volume.getPath();
        ArrayList<MountServiceBinderListener> arrayList = this.mVolumesLock;
        synchronized (arrayList) {
            oldState = this.mVolumeStates.put(path, state);
            volume.setState(state);
        }
        if (state.equals(oldState)) {
            Slog.w(TAG, String.format("Duplicate state transition (%s -> %s) for %s", state, state, path));
            return;
        }
        Slog.d(TAG, "volume state changed for " + path + " (" + oldState + " -> " + state + ")");
        if (volume.isPrimary() && !volume.isEmulated()) {
            if ("unmounted".equals(state)) {
                this.mPms.updateExternalMediaStatus(false, false);
                this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(5, path));
            } else if ("mounted".equals(state)) {
                this.mPms.updateExternalMediaStatus(true, false);
            }
        }
        arrayList = this.mListeners;
        synchronized (arrayList) {
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                MountServiceBinderListener bl = this.mListeners.get(i);
                try {
                    bl.mListener.onStorageStateChanged(path, oldState, state);
                    continue;
                }
                catch (RemoteException rex) {
                    Slog.e(TAG, "Listener dead");
                    this.mListeners.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    Slog.e(TAG, "Listener failed", ex);
                }
            }
        }
    }

    @Override
    public void onDaemonConnected() {
        new Thread("MountService#onDaemonConnected"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block15: {
                    try {
                        String[] vols;
                        for (String volstr : vols = NativeDaemonEvent.filterMessageList(MountService.this.mConnector.executeForList("volume", "list", "broadcast"), 110)) {
                            StorageVolume volume;
                            String[] tok = volstr.split(" ");
                            String path = tok[1];
                            String state = "removed";
                            Object object = MountService.this.mVolumesLock;
                            synchronized (object) {
                                volume = (StorageVolume)MountService.this.mVolumesByPath.get(path);
                            }
                            int st = Integer.parseInt(tok[2]);
                            if (st == 0) {
                                state = "removed";
                            } else if (st == 1) {
                                state = "unmounted";
                            } else if (st == 4) {
                                state = "mounted";
                                Slog.i(MountService.TAG, "Media already mounted on daemon connection");
                            } else if (st == 7) {
                                state = "shared";
                                Slog.i(MountService.TAG, "Media shared on daemon connection");
                            } else {
                                throw new Exception(String.format("Unexpected state %d", st));
                            }
                            if (state == null) continue;
                            MountService.this.updatePublicVolumeState(volume, state);
                        }
                    }
                    catch (Exception e) {
                        Slog.e(MountService.TAG, "Error processing initial volume state", e);
                        StorageVolume primary = MountService.this.getPrimaryPhysicalVolume();
                        if (primary == null) break block15;
                        MountService.this.updatePublicVolumeState(primary, "removed");
                    }
                }
                MountService.this.mConnectedSignal.countDown();
                if ("".equals(SystemProperties.get("vold.encrypt_progress"))) {
                    MountService.this.copyLocaleFromMountService();
                }
                MountService.this.mPms.scanAvailableAsecs();
                MountService.this.mAsecsScanned.countDown();
            }
        }.start();
    }

    private void copyLocaleFromMountService() {
        String systemLocale;
        try {
            systemLocale = this.getField("SystemLocale");
        }
        catch (RemoteException e) {
            return;
        }
        if (TextUtils.isEmpty(systemLocale)) {
            return;
        }
        Slog.d(TAG, "Got locale " + systemLocale + " from mount service");
        Locale locale = Locale.forLanguageTag(systemLocale);
        Configuration config = new Configuration();
        config.setLocale(locale);
        try {
            ActivityManagerNative.getDefault().updateConfiguration(config);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Error setting system locale from mount service", e);
        }
        Slog.d(TAG, "Setting system properties to " + systemLocale + " from mount service");
        SystemProperties.set("persist.sys.language", locale.getLanguage());
        SystemProperties.set("persist.sys.country", locale.getCountry());
    }

    @Override
    public boolean onCheckHoldWakeLock(int code) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onEvent(int code, String raw2, String[] cooked) {
        if (code == 605) {
            this.notifyVolumeStateChange(cooked[2], cooked[3], Integer.parseInt(cooked[7]), Integer.parseInt(cooked[10]));
        } else if (code == 613) {
            String path = cooked[2];
            String uuid = cooked.length > 3 ? cooked[3] : null;
            StorageVolume vol = this.mVolumesByPath.get(path);
            if (vol != null) {
                vol.setUuid(uuid);
            }
        } else if (code == 614) {
            String path = cooked[2];
            String userLabel = cooked.length > 3 ? cooked[3] : null;
            StorageVolume vol = this.mVolumesByPath.get(path);
            if (vol != null) {
                vol.setUserLabel(userLabel);
            }
        } else if (code == 630 || code == 631 || code == 632) {
            StorageVolume volume;
            String action = null;
            String label = cooked[2];
            final String path = cooked[3];
            int major = -1;
            int minor = -1;
            try {
                String devComp = cooked[6].substring(1, cooked[6].length() - 1);
                String[] devTok = devComp.split(":");
                major = Integer.parseInt(devTok[0]);
                minor = Integer.parseInt(devTok[1]);
            }
            catch (Exception ex) {
                Slog.e(TAG, "Failed to parse major/minor", ex);
            }
            Object object = this.mVolumesLock;
            synchronized (object) {
                volume = this.mVolumesByPath.get(path);
                String state = this.mVolumeStates.get(path);
            }
            if (code == 630) {
                new Thread("MountService#VolumeDiskInserted"){

                    @Override
                    public void run() {
                        try {
                            int rc = MountService.this.doMountVolume(path);
                            if (rc != 0) {
                                Slog.w(MountService.TAG, String.format("Insertion mount failed (%d)", rc));
                            }
                        }
                        catch (Exception ex) {
                            Slog.w(MountService.TAG, "Failed to mount media on insertion", ex);
                        }
                    }
                }.start();
            } else if (code == 631) {
                if (this.getVolumeState(path).equals("bad_removal")) {
                    return true;
                }
                this.updatePublicVolumeState(volume, "unmounted");
                this.sendStorageIntent("android.intent.action.MEDIA_UNMOUNTED", volume, UserHandle.ALL);
                this.updatePublicVolumeState(volume, "removed");
                action = "android.intent.action.MEDIA_REMOVED";
            } else if (code == 632) {
                this.updatePublicVolumeState(volume, "unmounted");
                this.sendStorageIntent("android.intent.action.MEDIA_UNMOUNTED", volume, UserHandle.ALL);
                this.updatePublicVolumeState(volume, "bad_removal");
                action = "android.intent.action.MEDIA_BAD_REMOVAL";
            } else if (code == 700) {
                EventLogTags.writeFstrimFinish(SystemClock.elapsedRealtime());
            } else {
                Slog.e(TAG, String.format("Unknown code {%d}", code));
            }
            if (action != null) {
                this.sendStorageIntent(action, volume, UserHandle.ALL);
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyVolumeStateChange(String label, String path, int oldState, int newState) {
        String state;
        StorageVolume volume;
        Object object = this.mVolumesLock;
        synchronized (object) {
            volume = this.mVolumesByPath.get(path);
            state = this.getVolumeState(path);
        }
        String action = null;
        if (oldState == 7 && newState != oldState) {
            this.sendStorageIntent("android.intent.action.MEDIA_UNSHARED", volume, UserHandle.ALL);
        }
        if (newState != -1 && newState != 0) {
            if (newState == 1) {
                if (!(state.equals("bad_removal") || state.equals("nofs") || state.equals("unmountable") || this.getUmsEnabling())) {
                    this.updatePublicVolumeState(volume, "unmounted");
                    action = "android.intent.action.MEDIA_UNMOUNTED";
                }
            } else if (newState != 2) {
                if (newState == 3) {
                    this.updatePublicVolumeState(volume, "checking");
                    action = "android.intent.action.MEDIA_CHECKING";
                } else if (newState == 4) {
                    this.updatePublicVolumeState(volume, "mounted");
                    action = "android.intent.action.MEDIA_MOUNTED";
                } else if (newState == 5) {
                    action = "android.intent.action.MEDIA_EJECT";
                } else if (newState != 6) {
                    if (newState == 7) {
                        this.updatePublicVolumeState(volume, "unmounted");
                        this.sendStorageIntent("android.intent.action.MEDIA_UNMOUNTED", volume, UserHandle.ALL);
                        this.updatePublicVolumeState(volume, "shared");
                        action = "android.intent.action.MEDIA_SHARED";
                    } else {
                        if (newState == 8) {
                            Slog.e(TAG, "Live shared mounts not supported yet!");
                            return;
                        }
                        Slog.e(TAG, "Unhandled VolumeState {" + newState + "}");
                    }
                }
            }
        }
        if (action != null) {
            this.sendStorageIntent(action, volume, UserHandle.ALL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doMountVolume(String path) {
        int rc;
        block12: {
            StorageVolume volume;
            rc = 0;
            Object object = this.mVolumesLock;
            synchronized (object) {
                volume = this.mVolumesByPath.get(path);
            }
            if (!volume.isEmulated() && this.hasUserRestriction("no_physical_media")) {
                Slog.w(TAG, "User has restriction DISALLOW_MOUNT_PHYSICAL_MEDIA; cannot mount volume.");
                return -1;
            }
            try {
                this.mConnector.execute("volume", "mount", path);
            }
            catch (NativeDaemonConnectorException e) {
                String action = null;
                int code = e.getCode();
                if (code == 401) {
                    rc = -2;
                } else if (code == 402) {
                    this.updatePublicVolumeState(volume, "nofs");
                    action = "android.intent.action.MEDIA_NOFS";
                    rc = -3;
                } else if (code == 403) {
                    this.updatePublicVolumeState(volume, "unmountable");
                    action = "android.intent.action.MEDIA_UNMOUNTABLE";
                    rc = -4;
                } else {
                    rc = -1;
                }
                if (action == null) break block12;
                this.sendStorageIntent(action, volume, UserHandle.ALL);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doUnmountVolume(String path, boolean force, boolean removeEncryption) {
        if (!this.getVolumeState(path).equals("mounted")) {
            return 404;
        }
        Runtime.getRuntime().gc();
        this.mPms.updateExternalMediaStatus(false, false);
        try {
            NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("volume", "unmount", path);
            if (removeEncryption) {
                cmd.appendArg("force_and_revert");
            } else if (force) {
                cmd.appendArg("force");
            }
            this.mConnector.execute(cmd);
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                this.mAsecMountSet.clear();
            }
            return 0;
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 404) {
                return -5;
            }
            if (code == 405) {
                return -7;
            }
            return -1;
        }
    }

    private int doFormatVolume(String path) {
        try {
            this.mConnector.execute("volume", "format", path);
            return 0;
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 401) {
                return -2;
            }
            if (code == 403) {
                return -4;
            }
            return -1;
        }
    }

    private boolean doGetVolumeShared(String path, String method) {
        NativeDaemonEvent event;
        try {
            event = this.mConnector.execute("volume", "shared", path, method);
        }
        catch (NativeDaemonConnectorException ex) {
            Slog.e(TAG, "Failed to read response to volume shared " + path + " " + method);
            return false;
        }
        if (event.getCode() == 212) {
            return event.getMessage().endsWith("enabled");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyShareAvailabilityChange(boolean avail) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mUmsAvailable = avail;
            for (int i = this.mListeners.size() - 1; i >= 0; --i) {
                MountServiceBinderListener bl = this.mListeners.get(i);
                try {
                    bl.mListener.onUsbMassStorageConnectionChanged(avail);
                    continue;
                }
                catch (RemoteException rex) {
                    Slog.e(TAG, "Listener dead");
                    this.mListeners.remove(i);
                    continue;
                }
                catch (Exception ex) {
                    Slog.e(TAG, "Listener failed", ex);
                }
            }
        }
        if (this.mSystemReady) {
            this.sendUmsIntent(avail);
        } else {
            this.mSendUmsConnectedOnBoot = avail;
        }
        StorageVolume primary = this.getPrimaryPhysicalVolume();
        if (!avail && primary != null && "shared".equals(this.getVolumeState(primary.getPath()))) {
            final String path = primary.getPath();
            new Thread("MountService#AvailabilityChange"){

                @Override
                public void run() {
                    try {
                        Slog.w(MountService.TAG, "Disabling UMS after cable disconnect");
                        MountService.this.doShareUnshareVolume(path, "ums", false);
                        int rc = MountService.this.doMountVolume(path);
                        if (rc != 0) {
                            Slog.e(MountService.TAG, String.format("Failed to remount {%s} on UMS enabled-disconnect (%d)", path, rc));
                        }
                    }
                    catch (Exception ex) {
                        Slog.w(MountService.TAG, "Failed to mount media on UMS enabled-disconnect", ex);
                    }
                }
            }.start();
        }
    }

    private void sendStorageIntent(String action, StorageVolume volume, UserHandle user) {
        Intent intent = new Intent(action, Uri.parse("file://" + volume.getPath()));
        intent.putExtra("storage_volume", volume);
        intent.addFlags(0x4000000);
        Slog.d(TAG, "sendStorageIntent " + intent + " to " + user);
        this.mContext.sendBroadcastAsUser(intent, user);
    }

    private void sendUmsIntent(boolean c) {
        this.mContext.sendBroadcastAsUser(new Intent(c ? "android.intent.action.UMS_CONNECTED" : "android.intent.action.UMS_DISCONNECTED"), UserHandle.ALL);
    }

    private void validatePermission(String perm) {
        if (this.mContext.checkCallingOrSelfPermission(perm) != 0) {
            throw new SecurityException(String.format("Requires %s permission", perm));
        }
    }

    private boolean hasUserRestriction(String restriction) {
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        return um.hasUserRestriction(restriction, Binder.getCallingUserHandle());
    }

    private void validateUserRestriction(String restriction) {
        if (this.hasUserRestriction(restriction)) {
            throw new SecurityException("User has restriction " + restriction);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readStorageListLocked() {
        int n;
        XmlResourceParser parser;
        block18: {
            this.mVolumes.clear();
            this.mVolumeStates.clear();
            Resources resources = this.mContext.getResources();
            int id2 = 0x1110012;
            parser = resources.getXml(id2);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            try {
                block17: {
                    XmlUtils.beginDocument(parser, TAG_STORAGE_LIST);
                    while (true) {
                        XmlUtils.nextElement(parser);
                        String element = parser.getName();
                        if (element == null) {
                            if (this.isExternalStorageEmulated()) {
                                break;
                            }
                            break block17;
                        }
                        if (!TAG_STORAGE.equals(element)) continue;
                        TypedArray a = resources.obtainAttributes(attrs, R.styleable.Storage);
                        String path = a.getString(0);
                        int descriptionId = a.getResourceId(1, -1);
                        CharSequence description = a.getText(1);
                        boolean primary = a.getBoolean(2, false);
                        boolean removable = a.getBoolean(3, false);
                        boolean emulated = a.getBoolean(4, false);
                        int mtpReserve = a.getInt(5, 0);
                        boolean allowMassStorage = a.getBoolean(6, false);
                        long maxFileSize = (long)a.getInt(7, 0) * 1024L * 1024L;
                        Slog.d(TAG, "got storage path: " + path + " description: " + description + " primary: " + primary + " removable: " + removable + " emulated: " + emulated + " mtpReserve: " + mtpReserve + " allowMassStorage: " + allowMassStorage + " maxFileSize: " + maxFileSize);
                        if (emulated) {
                            this.mEmulatedTemplate = new StorageVolume(null, descriptionId, true, false, true, mtpReserve, false, maxFileSize, null);
                            UserManagerService userManager = UserManagerService.getInstance();
                            for (UserInfo user : userManager.getUsers(false)) {
                                this.createEmulatedVolumeForUserLocked(user.getUserHandle());
                            }
                        } else if (path == null || description == null) {
                            Slog.e(TAG, "Missing storage path or description in readStorageList");
                        } else {
                            StorageVolume volume = new StorageVolume(new File(path), descriptionId, primary, removable, emulated, mtpReserve, allowMassStorage, maxFileSize, null);
                            this.addVolumeLocked(volume);
                            this.mVolumeStates.put(volume.getPath(), "unmounted");
                            volume.setState("unmounted");
                        }
                        a.recycle();
                    }
                    n = 1;
                    break block18;
                }
                n = 0;
            }
            catch (XmlPullParserException e) {
                try {
                    throw new RuntimeException(e);
                    catch (IOException e2) {
                        throw new RuntimeException(e2);
                    }
                }
                catch (Throwable throwable) {
                    int index = this.isExternalStorageEmulated() ? 1 : 0;
                    Iterator<StorageVolume> i$ = this.mVolumes.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            parser.close();
                            throw throwable;
                        }
                        StorageVolume volume = i$.next();
                        if (volume.isEmulated()) continue;
                        volume.setStorageId(index++);
                    }
                }
            }
        }
        int index = n;
        Iterator<StorageVolume> i$ = this.mVolumes.iterator();
        while (true) {
            if (!i$.hasNext()) {
                parser.close();
                return;
            }
            StorageVolume volume = i$.next();
            if (volume.isEmulated()) continue;
            volume.setStorageId(index++);
        }
    }

    private void createEmulatedVolumeForUserLocked(UserHandle user) {
        if (this.mEmulatedTemplate == null) {
            throw new IllegalStateException("Missing emulated volume multi-user template");
        }
        Environment.UserEnvironment userEnv = new Environment.UserEnvironment(user.getIdentifier());
        File path = userEnv.getExternalStorageDirectory();
        StorageVolume volume = StorageVolume.fromTemplate(this.mEmulatedTemplate, path, user);
        volume.setStorageId(0);
        this.addVolumeLocked(volume);
        if (this.mSystemReady) {
            this.updatePublicVolumeState(volume, "mounted");
        } else {
            this.mVolumeStates.put(volume.getPath(), "mounted");
            volume.setState("mounted");
        }
    }

    private void addVolumeLocked(StorageVolume volume) {
        Slog.d(TAG, "addVolumeLocked() " + volume);
        this.mVolumes.add(volume);
        StorageVolume existing = this.mVolumesByPath.put(volume.getPath(), volume);
        if (existing != null) {
            throw new IllegalStateException("Volume at " + volume.getPath() + " already exists: " + existing);
        }
    }

    private void removeVolumeLocked(StorageVolume volume) {
        Slog.d(TAG, "removeVolumeLocked() " + volume);
        this.mVolumes.remove(volume);
        this.mVolumesByPath.remove(volume.getPath());
        this.mVolumeStates.remove(volume.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StorageVolume getPrimaryPhysicalVolume() {
        Object object = this.mVolumesLock;
        synchronized (object) {
            for (StorageVolume volume : this.mVolumes) {
                if (!volume.isPrimary() || volume.isEmulated()) continue;
                return volume;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MountService(Context context) {
        sSelf = this;
        this.mContext = context;
        Object object = this.mVolumesLock;
        synchronized (object) {
            this.readStorageListLocked();
        }
        this.mPms = (PackageManagerService)ServiceManager.getService("package");
        HandlerThread hthread = new HandlerThread(TAG);
        hthread.start();
        this.mHandler = new MountServiceHandler(hthread.getLooper());
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_ADDED");
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
        StorageVolume primary = this.getPrimaryPhysicalVolume();
        if (primary != null && primary.allowMassStorage()) {
            this.mContext.registerReceiver(this.mUsbReceiver, new IntentFilter("android.hardware.usb.action.USB_STATE"), null, this.mHandler);
        }
        this.mObbActionHandler = new ObbActionHandler(IoThread.get().getLooper());
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        this.mLastMaintenanceFile = new File(systemDir, LAST_FSTRIM_FILE);
        if (!this.mLastMaintenanceFile.exists()) {
            try {
                new FileOutputStream(this.mLastMaintenanceFile).close();
            }
            catch (IOException e) {
                Slog.e(TAG, "Unable to create fstrim record " + this.mLastMaintenanceFile.getPath());
            }
        } else {
            this.mLastMaintenance = this.mLastMaintenanceFile.lastModified();
        }
        this.mConnector = new NativeDaemonConnector(this, "vold", 500, VOLD_TAG, 25, null);
        Thread thread = new Thread((Runnable)this.mConnector, VOLD_TAG);
        thread.start();
    }

    public void systemReady() {
        this.mSystemReady = true;
        this.mHandler.obtainMessage(4).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(IMountServiceListener listener) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            MountServiceBinderListener bl = new MountServiceBinderListener(listener);
            try {
                listener.asBinder().linkToDeath(bl, 0);
                this.mListeners.add(bl);
            }
            catch (RemoteException rex) {
                Slog.e(TAG, "Failed to link to listener death");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(IMountServiceListener listener) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            for (MountServiceBinderListener bl : this.mListeners) {
                if (bl.mListener.asBinder() != listener.asBinder()) continue;
                this.mListeners.remove(this.mListeners.indexOf(bl));
                listener.asBinder().unlinkToDeath(bl, 0);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(IMountShutdownObserver observer) {
        this.validatePermission("android.permission.SHUTDOWN");
        Slog.i(TAG, "Shutting down");
        Object object = this.mVolumesLock;
        synchronized (object) {
            MountShutdownLatch mountShutdownLatch = new MountShutdownLatch(observer, this.mVolumeStates.size());
            for (String path : this.mVolumeStates.keySet()) {
                String state = this.mVolumeStates.get(path);
                if (state.equals("shared")) {
                    this.setUsbMassStorageEnabled(false);
                } else if (state.equals("checking")) {
                    int retries = 30;
                    while (state.equals("checking") && retries-- >= 0) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException iex) {
                            Slog.e(TAG, "Interrupted while waiting for media", iex);
                            break;
                        }
                        state = Environment.getExternalStorageState();
                    }
                    if (retries == 0) {
                        Slog.e(TAG, "Timed out waiting for media to check");
                    }
                }
                if (state.equals("mounted")) {
                    ShutdownCallBack ucb = new ShutdownCallBack(path, mountShutdownLatch);
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(1, ucb));
                    continue;
                }
                if (observer == null) continue;
                mountShutdownLatch.countDown();
                Slog.i(TAG, "Unmount completed: " + path + ", result code: " + 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getUmsEnabling() {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            return this.mUmsEnabling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUmsEnabling(boolean enable) {
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            this.mUmsEnabling = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUsbMassStorageConnected() {
        this.waitForReady();
        if (this.getUmsEnabling()) {
            return true;
        }
        ArrayList<MountServiceBinderListener> arrayList = this.mListeners;
        synchronized (arrayList) {
            return this.mUmsAvailable;
        }
    }

    @Override
    public void setUsbMassStorageEnabled(boolean enable) {
        this.waitForReady();
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.validateUserRestriction("no_usb_file_transfer");
        StorageVolume primary = this.getPrimaryPhysicalVolume();
        if (primary == null) {
            return;
        }
        String path = primary.getPath();
        String vs = this.getVolumeState(path);
        String method = "ums";
        if (enable && vs.equals("mounted")) {
            this.setUmsEnabling(enable);
            UmsEnableCallBack umscb = new UmsEnableCallBack(path, method, true);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(1, umscb));
            this.setUmsEnabling(false);
        }
        if (!enable) {
            this.doShareUnshareVolume(path, method, enable);
            if (this.doMountVolume(path) != 0) {
                Slog.e(TAG, "Failed to remount " + path + " after disabling share method " + method);
            }
        }
    }

    @Override
    public boolean isUsbMassStorageEnabled() {
        this.waitForReady();
        StorageVolume primary = this.getPrimaryPhysicalVolume();
        if (primary != null) {
            return this.doGetVolumeShared(primary.getPath(), "ums");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVolumeState(String mountPoint) {
        Object object = this.mVolumesLock;
        synchronized (object) {
            String state = this.mVolumeStates.get(mountPoint);
            if (state == null) {
                Slog.w(TAG, "getVolumeState(" + mountPoint + "): Unknown volume");
                if (SystemProperties.get("vold.encrypt_progress").length() != 0) {
                    state = "removed";
                } else {
                    throw new IllegalArgumentException();
                }
            }
            return state;
        }
    }

    @Override
    public boolean isExternalStorageEmulated() {
        return this.mEmulatedTemplate != null;
    }

    @Override
    public int mountVolume(String path) {
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.waitForReady();
        return this.doMountVolume(path);
    }

    @Override
    public void unmountVolume(String path, boolean force, boolean removeEncryption) {
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.waitForReady();
        String volState = this.getVolumeState(path);
        if ("unmounted".equals(volState) || "removed".equals(volState) || "shared".equals(volState) || "unmountable".equals(volState)) {
            return;
        }
        UnmountCallBack ucb = new UnmountCallBack(path, force, removeEncryption);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, ucb));
    }

    @Override
    public int formatVolume(String path) {
        this.validatePermission("android.permission.MOUNT_FORMAT_FILESYSTEMS");
        this.waitForReady();
        return this.doFormatVolume(path);
    }

    @Override
    public int[] getStorageUsers(String path) {
        this.validatePermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS");
        this.waitForReady();
        try {
            String[] r = NativeDaemonEvent.filterMessageList(this.mConnector.executeForList(TAG_STORAGE, "users", path), 112);
            int[] data = new int[r.length];
            for (int i = 0; i < r.length; ++i) {
                String[] tok = r[i].split(" ");
                try {
                    data[i] = Integer.parseInt(tok[0]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    Slog.e(TAG, String.format("Error parsing pid %s", tok[0]));
                    return new int[0];
                }
            }
            return data;
        }
        catch (NativeDaemonConnectorException e) {
            Slog.e(TAG, "Failed to retrieve storage users list", e);
            return new int[0];
        }
    }

    private void warnOnNotMounted() {
        StorageVolume primary = this.getPrimaryPhysicalVolume();
        if (primary != null) {
            boolean mounted = false;
            try {
                mounted = "mounted".equals(this.getVolumeState(primary.getPath()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!mounted) {
                Slog.w(TAG, "getSecureContainerList() called when storage not mounted");
            }
        }
    }

    @Override
    public String[] getSecureContainerList() {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        try {
            return NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("asec", "list"), 111);
        }
        catch (NativeDaemonConnectorException e) {
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createSecureContainer(String id2, int sizeMb, String fstype, String key, int ownerUid, boolean external) {
        this.validatePermission("android.permission.ASEC_CREATE");
        this.waitForReady();
        this.warnOnNotMounted();
        int rc = 0;
        try {
            this.mConnector.execute("asec", "create", id2, sizeMb, fstype, new NativeDaemonConnector.SensitiveArg(key), ownerUid, external ? "1" : "0");
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        if (rc == 0) {
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                this.mAsecMountSet.add(id2);
            }
        }
        return rc;
    }

    @Override
    public int resizeSecureContainer(String id2, int sizeMb, String key) {
        this.validatePermission("android.permission.ASEC_CREATE");
        this.waitForReady();
        this.warnOnNotMounted();
        int rc = 0;
        try {
            this.mConnector.execute("asec", "resize", id2, sizeMb, new NativeDaemonConnector.SensitiveArg(key));
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        return rc;
    }

    @Override
    public int finalizeSecureContainer(String id2) {
        this.validatePermission("android.permission.ASEC_CREATE");
        this.warnOnNotMounted();
        int rc = 0;
        try {
            this.mConnector.execute("asec", "finalize", id2);
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        return rc;
    }

    @Override
    public int fixPermissionsSecureContainer(String id2, int gid, String filename) {
        this.validatePermission("android.permission.ASEC_CREATE");
        this.warnOnNotMounted();
        int rc = 0;
        try {
            this.mConnector.execute("asec", "fixperms", id2, gid, filename);
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int destroySecureContainer(String id2, boolean force) {
        this.validatePermission("android.permission.ASEC_DESTROY");
        this.waitForReady();
        this.warnOnNotMounted();
        Runtime.getRuntime().gc();
        int rc = 0;
        try {
            NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("asec", "destroy", id2);
            if (force) {
                cmd.appendArg("force");
            }
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            rc = code == 405 ? -7 : -1;
        }
        if (rc == 0) {
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                if (this.mAsecMountSet.contains(id2)) {
                    this.mAsecMountSet.remove(id2);
                }
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int mountSecureContainer(String id2, String key, int ownerUid, boolean readOnly) {
        int rc;
        block10: {
            this.validatePermission("android.permission.ASEC_MOUNT_UNMOUNT");
            this.waitForReady();
            this.warnOnNotMounted();
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                if (this.mAsecMountSet.contains(id2)) {
                    return -6;
                }
            }
            rc = 0;
            try {
                this.mConnector.execute("asec", "mount", id2, new NativeDaemonConnector.SensitiveArg(key), ownerUid, readOnly ? "ro" : "rw");
            }
            catch (NativeDaemonConnectorException e) {
                int code = e.getCode();
                if (code == 405) break block10;
                rc = -1;
            }
        }
        if (rc == 0) {
            HashSet<String> hashSet = this.mAsecMountSet;
            synchronized (hashSet) {
                this.mAsecMountSet.add(id2);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int unmountSecureContainer(String id2, boolean force) {
        this.validatePermission("android.permission.ASEC_MOUNT_UNMOUNT");
        this.waitForReady();
        this.warnOnNotMounted();
        HashSet<String> hashSet = this.mAsecMountSet;
        synchronized (hashSet) {
            if (!this.mAsecMountSet.contains(id2)) {
                return -5;
            }
        }
        Runtime.getRuntime().gc();
        int rc = 0;
        try {
            NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("asec", "unmount", id2);
            if (force) {
                cmd.appendArg("force");
            }
            this.mConnector.execute(cmd);
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            rc = code == 405 ? -7 : -1;
        }
        if (rc == 0) {
            HashSet<String> hashSet2 = this.mAsecMountSet;
            synchronized (hashSet2) {
                this.mAsecMountSet.remove(id2);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSecureContainerMounted(String id2) {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        HashSet<String> hashSet = this.mAsecMountSet;
        synchronized (hashSet) {
            return this.mAsecMountSet.contains(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int renameSecureContainer(String oldId, String newId) {
        this.validatePermission("android.permission.ASEC_RENAME");
        this.waitForReady();
        this.warnOnNotMounted();
        HashSet<String> hashSet = this.mAsecMountSet;
        synchronized (hashSet) {
            if (this.mAsecMountSet.contains(oldId) || this.mAsecMountSet.contains(newId)) {
                return -6;
            }
        }
        int rc = 0;
        try {
            this.mConnector.execute("asec", "rename", oldId, newId);
        }
        catch (NativeDaemonConnectorException e) {
            rc = -1;
        }
        return rc;
    }

    @Override
    public String getSecureContainerPath(String id2) {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        try {
            NativeDaemonEvent event = this.mConnector.execute("asec", "path", id2);
            event.checkCode(211);
            return event.getMessage();
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 406) {
                Slog.i(TAG, String.format("Container '%s' not found", id2));
                return null;
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
    }

    @Override
    public String getSecureContainerFilesystemPath(String id2) {
        this.validatePermission("android.permission.ASEC_ACCESS");
        this.waitForReady();
        this.warnOnNotMounted();
        try {
            NativeDaemonEvent event = this.mConnector.execute("asec", "fspath", id2);
            event.checkCode(211);
            return event.getMessage();
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 406) {
                Slog.i(TAG, String.format("Container '%s' not found", id2));
                return null;
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
    }

    @Override
    public void finishMediaUpdate() {
        this.mHandler.sendEmptyMessage(2);
    }

    private boolean isUidOwnerOfPackageOrSystem(String packageName, int callerUid) {
        if (callerUid == 1000) {
            return true;
        }
        if (packageName == null) {
            return false;
        }
        int packageUid = this.mPms.getPackageUid(packageName, UserHandle.getUserId(callerUid));
        return callerUid == packageUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMountedObbPath(String rawPath) {
        ObbState state;
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        this.waitForReady();
        this.warnOnNotMounted();
        Map<String, ObbState> map = this.mObbPathToStateMap;
        synchronized (map) {
            state = this.mObbPathToStateMap.get(rawPath);
        }
        if (state == null) {
            Slog.w(TAG, "Failed to find OBB mounted at " + rawPath);
            return null;
        }
        try {
            NativeDaemonEvent event = this.mConnector.execute("obb", "path", state.voldPath);
            event.checkCode(211);
            return event.getMessage();
        }
        catch (NativeDaemonConnectorException e) {
            int code = e.getCode();
            if (code == 406) {
                return null;
            }
            throw new IllegalStateException(String.format("Unexpected response code %d", code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isObbMounted(String rawPath) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Map<IBinder, List<ObbState>> map = this.mObbMounts;
        synchronized (map) {
            return this.mObbPathToStateMap.containsKey(rawPath);
        }
    }

    @Override
    public void mountObb(String rawPath, String canonicalPath, String key, IObbActionListener token, int nonce) {
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Preconditions.checkNotNull(canonicalPath, "canonicalPath cannot be null");
        Preconditions.checkNotNull(token, "token cannot be null");
        int callingUid = Binder.getCallingUid();
        ObbState obbState = new ObbState(rawPath, canonicalPath, callingUid, token, nonce);
        MountObbAction action = new MountObbAction(obbState, key, callingUid);
        this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(1, action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unmountObb(String rawPath, boolean force, IObbActionListener token, int nonce) {
        ObbState existingState;
        Preconditions.checkNotNull(rawPath, "rawPath cannot be null");
        Map<String, ObbState> map = this.mObbPathToStateMap;
        synchronized (map) {
            existingState = this.mObbPathToStateMap.get(rawPath);
        }
        if (existingState != null) {
            int callingUid = Binder.getCallingUid();
            ObbState newState = new ObbState(rawPath, existingState.canonicalPath, callingUid, token, nonce);
            UnmountObbAction action = new UnmountObbAction(newState, force);
            this.mObbActionHandler.sendMessage(this.mObbActionHandler.obtainMessage(1, action));
        } else {
            Slog.w(TAG, "Unknown OBB mount at " + rawPath);
        }
    }

    @Override
    public int getEncryptionState() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "cryptocomplete");
            return Integer.parseInt(event.getMessage());
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Unable to parse result from cryptfs cryptocomplete");
            return -1;
        }
        catch (NativeDaemonConnectorException e) {
            Slog.w(TAG, "Error in communicating with cryptfs in validating");
            return -1;
        }
    }

    private String toHex(String password) {
        if (password == null) {
            return new String();
        }
        byte[] bytes = password.getBytes(StandardCharsets.UTF_8);
        return new String(Hex.encodeHex(bytes));
    }

    private String fromHex(String hexPassword) {
        if (hexPassword == null) {
            return null;
        }
        try {
            byte[] bytes = Hex.decodeHex(hexPassword.toCharArray());
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (DecoderException e) {
            return null;
        }
    }

    @Override
    public int decryptStorage(String password) {
        if (TextUtils.isEmpty(password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "checkpw", new NativeDaemonConnector.SensitiveArg(this.toHex(password)));
            int code = Integer.parseInt(event.getMessage());
            if (code == 0) {
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            MountService.this.mConnector.execute("cryptfs", "restart");
                        }
                        catch (NativeDaemonConnectorException e) {
                            Slog.e(MountService.TAG, "problem executing in background", e);
                        }
                    }
                }, 1000L);
            }
            return code;
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
    }

    @Override
    public int encryptStorage(int type, String password) {
        if (TextUtils.isEmpty(password) && type != 1) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            this.mConnector.execute("cryptfs", "enablecrypto", "inplace", CRYPTO_TYPES[type], new NativeDaemonConnector.SensitiveArg(this.toHex(password)));
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
        return 0;
    }

    @Override
    public int changeEncryptionPassword(int type, String password) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        this.waitForReady();
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "changepw", CRYPTO_TYPES[type], new NativeDaemonConnector.SensitiveArg(this.toHex(password)));
            return Integer.parseInt(event.getMessage());
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
    }

    @Override
    public int verifyEncryptionPassword(String password) throws RemoteException {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("no permission to access the crypt keeper");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.CRYPT_KEEPER", "no permission to access the crypt keeper");
        if (TextUtils.isEmpty(password)) {
            throw new IllegalArgumentException("password cannot be empty");
        }
        this.waitForReady();
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "verifypw", new NativeDaemonConnector.SensitiveArg(this.toHex(password)));
            Slog.i(TAG, "cryptfs verifypw => " + event.getMessage());
            return Integer.parseInt(event.getMessage());
        }
        catch (NativeDaemonConnectorException e) {
            return e.getCode();
        }
    }

    @Override
    public int getPasswordType() {
        this.waitForReady();
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "getpwtype");
            for (int i = 0; i < CRYPTO_TYPES.length; ++i) {
                if (!CRYPTO_TYPES[i].equals(event.getMessage())) continue;
                return i;
            }
            throw new IllegalStateException("unexpected return from cryptfs");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void setField(String field, String contents) throws RemoteException {
        this.waitForReady();
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "setfield", field, contents);
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public String getField(String field) throws RemoteException {
        this.waitForReady();
        try {
            String[] contents = NativeDaemonEvent.filterMessageList(this.mConnector.executeForList("cryptfs", "getfield", field), 113);
            String result = new String();
            for (String content : contents) {
                result = result + content;
            }
            return result;
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public String getPassword() throws RemoteException {
        if (!this.isReady()) {
            return new String();
        }
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "getpw");
            return this.fromHex(event.getMessage());
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public void clearPassword() throws RemoteException {
        if (!this.isReady()) {
            return;
        }
        try {
            NativeDaemonEvent event = this.mConnector.execute("cryptfs", "clearpw");
        }
        catch (NativeDaemonConnectorException e) {
            throw e.rethrowAsParcelableException();
        }
    }

    @Override
    public int mkdirs(String callingPkg, String appPath) {
        String voldPath;
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        Environment.UserEnvironment userEnv = new Environment.UserEnvironment(userId);
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        appOps.checkPackage(Binder.getCallingUid(), callingPkg);
        try {
            appPath = new File(appPath).getCanonicalPath();
        }
        catch (IOException e) {
            Slog.e(TAG, "Failed to resolve " + appPath + ": " + e);
            return -1;
        }
        if (!appPath.endsWith("/")) {
            appPath = appPath + "/";
        }
        if ((voldPath = MountService.maybeTranslatePathForVold(appPath, userEnv.buildExternalStorageAppDataDirs(callingPkg), userEnv.buildExternalStorageAppDataDirsForVold(callingPkg))) != null) {
            try {
                this.mConnector.execute("volume", "mkdirs", voldPath);
                return 0;
            }
            catch (NativeDaemonConnectorException e) {
                return e.getCode();
            }
        }
        voldPath = MountService.maybeTranslatePathForVold(appPath, userEnv.buildExternalStorageAppObbDirs(callingPkg), userEnv.buildExternalStorageAppObbDirsForVold(callingPkg));
        if (voldPath != null) {
            try {
                this.mConnector.execute("volume", "mkdirs", voldPath);
                return 0;
            }
            catch (NativeDaemonConnectorException e) {
                return e.getCode();
            }
        }
        voldPath = MountService.maybeTranslatePathForVold(appPath, userEnv.buildExternalStorageAppMediaDirs(callingPkg), userEnv.buildExternalStorageAppMediaDirsForVold(callingPkg));
        if (voldPath != null) {
            try {
                this.mConnector.execute("volume", "mkdirs", voldPath);
                return 0;
            }
            catch (NativeDaemonConnectorException e) {
                return e.getCode();
            }
        }
        throw new SecurityException("Invalid mkdirs path: " + appPath);
    }

    public static String maybeTranslatePathForVold(String path, File[] appPaths, File[] voldPaths) {
        if (appPaths.length != voldPaths.length) {
            throw new IllegalStateException("Paths must be 1:1 mapping");
        }
        for (int i = 0; i < appPaths.length; ++i) {
            String appPath = appPaths[i].getAbsolutePath() + "/";
            if (!path.startsWith(appPath)) continue;
            if (!(path = new File(voldPaths[i], path.substring(appPath.length())).getAbsolutePath()).endsWith("/")) {
                path = path + "/";
            }
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageVolume[] getVolumeList() {
        int callingUserId = UserHandle.getCallingUserId();
        boolean accessAll = this.mContext.checkPermission("android.permission.ACCESS_ALL_EXTERNAL_STORAGE", Binder.getCallingPid(), Binder.getCallingUid()) == 0;
        Object object = this.mVolumesLock;
        synchronized (object) {
            ArrayList<StorageVolume> filtered = Lists.newArrayList();
            for (StorageVolume volume : this.mVolumes) {
                boolean ownerMatch;
                UserHandle owner = volume.getOwner();
                boolean bl = ownerMatch = owner == null || owner.getIdentifier() == callingUserId;
                if (!accessAll && !ownerMatch) continue;
                filtered.add(volume);
            }
            return filtered.toArray(new StorageVolume[filtered.size()]);
        }
    }

    private void addObbStateLocked(ObbState obbState) throws RemoteException {
        IBinder binder = obbState.getBinder();
        List<ObbState> obbStates = this.mObbMounts.get(binder);
        if (obbStates == null) {
            obbStates = new ArrayList<ObbState>();
            this.mObbMounts.put(binder, obbStates);
        } else {
            for (ObbState o : obbStates) {
                if (!o.rawPath.equals(obbState.rawPath)) continue;
                throw new IllegalStateException("Attempt to add ObbState twice. This indicates an error in the MountService logic.");
            }
        }
        obbStates.add(obbState);
        try {
            obbState.link();
        }
        catch (RemoteException e) {
            obbStates.remove(obbState);
            if (obbStates.isEmpty()) {
                this.mObbMounts.remove(binder);
            }
            throw e;
        }
        this.mObbPathToStateMap.put(obbState.rawPath, obbState);
    }

    private void removeObbStateLocked(ObbState obbState) {
        IBinder binder = obbState.getBinder();
        List<ObbState> obbStates = this.mObbMounts.get(binder);
        if (obbStates != null) {
            if (obbStates.remove(obbState)) {
                obbState.unlink();
            }
            if (obbStates.isEmpty()) {
                this.mObbMounts.remove(binder);
            }
        }
        this.mObbPathToStateMap.remove(obbState.rawPath);
    }

    public static String buildObbPath(String canonicalPath, int userId, boolean forVold) {
        if (!Environment.isExternalStorageEmulated()) {
            return canonicalPath;
        }
        String path = canonicalPath.toString();
        Environment.UserEnvironment userEnv = new Environment.UserEnvironment(userId);
        String externalPath = userEnv.getExternalStorageDirectory().getAbsolutePath();
        String legacyExternalPath = Environment.getLegacyExternalStorageDirectory().getAbsolutePath();
        if (path.startsWith(externalPath)) {
            path = path.substring(externalPath.length() + 1);
        } else if (path.startsWith(legacyExternalPath)) {
            path = path.substring(legacyExternalPath.length() + 1);
        } else {
            return canonicalPath;
        }
        String obbPath = "Android/obb";
        if (path.startsWith("Android/obb")) {
            path = path.substring("Android/obb".length() + 1);
            if (forVold) {
                return new File(Environment.getEmulatedStorageObbSource(), path).getAbsolutePath();
            }
            Environment.UserEnvironment ownerEnv = new Environment.UserEnvironment(0);
            return new File(ownerEnv.buildExternalStorageAndroidObbDirs()[0], path).getAbsolutePath();
        }
        if (forVold) {
            return new File(Environment.getEmulatedStorageSource(userId), path).getAbsolutePath();
        }
        return new File(userEnv.getExternalDirsForApp()[0], path).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        IndentingPrintWriter pw = new IndentingPrintWriter(writer, "  ", 160);
        Object object = this.mObbMounts;
        synchronized (object) {
            pw.println("mObbMounts:");
            pw.increaseIndent();
            for (Map.Entry<IBinder, List<ObbState>> e : this.mObbMounts.entrySet()) {
                pw.println(e.getKey() + ":");
                pw.increaseIndent();
                List<ObbState> obbStates = e.getValue();
                for (ObbState obbState : obbStates) {
                    pw.println(obbState);
                }
                pw.decreaseIndent();
            }
            pw.decreaseIndent();
            pw.println();
            pw.println("mObbPathToStateMap:");
            pw.increaseIndent();
            for (Map.Entry<String, ObbState> e : this.mObbPathToStateMap.entrySet()) {
                pw.print(e.getKey());
                pw.print(" -> ");
                pw.println(e.getValue());
            }
            pw.decreaseIndent();
        }
        object = this.mVolumesLock;
        synchronized (object) {
            pw.println();
            pw.println("mVolumes:");
            pw.increaseIndent();
            for (StorageVolume volume : this.mVolumes) {
                pw.println(volume);
                pw.increaseIndent();
                pw.println("Current state: " + this.mVolumeStates.get(volume.getPath()));
                pw.decreaseIndent();
            }
            pw.decreaseIndent();
        }
        pw.println();
        pw.println("mConnection:");
        pw.increaseIndent();
        this.mConnector.dump(fd, pw, args);
        pw.decreaseIndent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        pw.println();
        pw.print("Last maintenance: ");
        pw.println(sdf.format(new Date(this.mLastMaintenance)));
    }

    @Override
    public void monitor() {
        if (this.mConnector != null) {
            this.mConnector.monitor();
        }
    }

    class UnmountObbAction
    extends ObbAction {
        private final boolean mForceUnmount;

        UnmountObbAction(ObbState obbState, boolean force) {
            super(obbState);
            this.mForceUnmount = force;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleExecute() throws IOException {
            ObbState existingState;
            MountService.this.waitForReady();
            MountService.this.warnOnNotMounted();
            ObbInfo obbInfo = this.getObbInfo();
            Map map = MountService.this.mObbMounts;
            synchronized (map) {
                existingState = (ObbState)MountService.this.mObbPathToStateMap.get(this.mObbState.rawPath);
            }
            if (existingState == null) {
                this.sendNewStatusOrIgnore(23);
                return;
            }
            if (existingState.ownerGid != this.mObbState.ownerGid) {
                Slog.w(MountService.TAG, "Permission denied attempting to unmount OBB " + existingState.rawPath + " (owned by GID " + existingState.ownerGid + ")");
                this.sendNewStatusOrIgnore(25);
                return;
            }
            int rc = 0;
            try {
                NativeDaemonConnector.Command cmd = new NativeDaemonConnector.Command("obb", "unmount", this.mObbState.voldPath);
                if (this.mForceUnmount) {
                    cmd.appendArg("force");
                }
                MountService.this.mConnector.execute(cmd);
            }
            catch (NativeDaemonConnectorException e) {
                int code = e.getCode();
                rc = code == 405 ? -7 : (code == 406 ? 0 : -1);
            }
            if (rc == 0) {
                Map map2 = MountService.this.mObbMounts;
                synchronized (map2) {
                    MountService.this.removeObbStateLocked(existingState);
                }
                this.sendNewStatusOrIgnore(2);
            } else {
                Slog.w(MountService.TAG, "Could not unmount OBB: " + existingState);
                this.sendNewStatusOrIgnore(22);
            }
        }

        @Override
        public void handleError() {
            this.sendNewStatusOrIgnore(20);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("UnmountObbAction{");
            sb.append(this.mObbState);
            sb.append(",force=");
            sb.append(this.mForceUnmount);
            sb.append('}');
            return sb.toString();
        }
    }

    class MountObbAction
    extends ObbAction {
        private final String mKey;
        private final int mCallingUid;

        MountObbAction(ObbState obbState, String key, int callingUid) {
            super(obbState);
            this.mKey = key;
            this.mCallingUid = callingUid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleExecute() throws IOException, RemoteException {
            int rc;
            block17: {
                String hashedKey;
                boolean isMounted;
                MountService.this.waitForReady();
                MountService.this.warnOnNotMounted();
                ObbInfo obbInfo = this.getObbInfo();
                if (!MountService.this.isUidOwnerOfPackageOrSystem(obbInfo.packageName, this.mCallingUid)) {
                    Slog.w(MountService.TAG, "Denied attempt to mount OBB " + obbInfo.filename + " which is owned by " + obbInfo.packageName);
                    this.sendNewStatusOrIgnore(25);
                    return;
                }
                Map map = MountService.this.mObbMounts;
                synchronized (map) {
                    isMounted = MountService.this.mObbPathToStateMap.containsKey(this.mObbState.rawPath);
                }
                if (isMounted) {
                    Slog.w(MountService.TAG, "Attempt to mount OBB which is already mounted: " + obbInfo.filename);
                    this.sendNewStatusOrIgnore(24);
                    return;
                }
                if (this.mKey == null) {
                    hashedKey = "none";
                } else {
                    try {
                        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                        PBEKeySpec ks = new PBEKeySpec(this.mKey.toCharArray(), obbInfo.salt, 1024, 128);
                        SecretKey key = factory.generateSecret(ks);
                        BigInteger bi = new BigInteger(key.getEncoded());
                        hashedKey = bi.toString(16);
                    }
                    catch (NoSuchAlgorithmException e) {
                        Slog.e(MountService.TAG, "Could not load PBKDF2 algorithm", e);
                        this.sendNewStatusOrIgnore(20);
                        return;
                    }
                    catch (InvalidKeySpecException e) {
                        Slog.e(MountService.TAG, "Invalid key spec when loading PBKDF2 algorithm", e);
                        this.sendNewStatusOrIgnore(20);
                        return;
                    }
                }
                rc = 0;
                try {
                    MountService.this.mConnector.execute("obb", "mount", this.mObbState.voldPath, new NativeDaemonConnector.SensitiveArg(hashedKey), this.mObbState.ownerGid);
                }
                catch (NativeDaemonConnectorException e) {
                    int code = e.getCode();
                    if (code == 405) break block17;
                    rc = -1;
                }
            }
            if (rc == 0) {
                Map map = MountService.this.mObbMounts;
                synchronized (map) {
                    MountService.this.addObbStateLocked(this.mObbState);
                }
                this.sendNewStatusOrIgnore(1);
            } else {
                Slog.e(MountService.TAG, "Couldn't mount OBB file: " + rc);
                this.sendNewStatusOrIgnore(21);
            }
        }

        @Override
        public void handleError() {
            this.sendNewStatusOrIgnore(20);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("MountObbAction{");
            sb.append(this.mObbState);
            sb.append('}');
            return sb.toString();
        }
    }

    abstract class ObbAction {
        private static final int MAX_RETRIES = 3;
        private int mRetries;
        ObbState mObbState;

        ObbAction(ObbState obbState) {
            this.mObbState = obbState;
        }

        public void execute(ObbActionHandler handler) {
            try {
                ++this.mRetries;
                if (this.mRetries > 3) {
                    Slog.w(MountService.TAG, "Failed to invoke remote methods on default container service. Giving up");
                    MountService.this.mObbActionHandler.sendEmptyMessage(3);
                    this.handleError();
                    return;
                }
                this.handleExecute();
                MountService.this.mObbActionHandler.sendEmptyMessage(3);
            }
            catch (RemoteException e) {
                MountService.this.mObbActionHandler.sendEmptyMessage(4);
            }
            catch (Exception e) {
                this.handleError();
                MountService.this.mObbActionHandler.sendEmptyMessage(3);
            }
        }

        abstract void handleExecute() throws RemoteException, IOException;

        abstract void handleError();

        protected ObbInfo getObbInfo() throws IOException {
            ObbInfo obbInfo;
            try {
                obbInfo = MountService.this.mContainerService.getObbInfo(this.mObbState.ownerPath);
            }
            catch (RemoteException e) {
                Slog.d(MountService.TAG, "Couldn't call DefaultContainerService to fetch OBB info for " + this.mObbState.ownerPath);
                obbInfo = null;
            }
            if (obbInfo == null) {
                throw new IOException("Couldn't read OBB file: " + this.mObbState.ownerPath);
            }
            return obbInfo;
        }

        protected void sendNewStatusOrIgnore(int status) {
            if (this.mObbState == null || this.mObbState.token == null) {
                return;
            }
            try {
                this.mObbState.token.onObbResult(this.mObbState.rawPath, this.mObbState.nonce, status);
            }
            catch (RemoteException e) {
                Slog.w(MountService.TAG, "MountServiceListener went away while calling onObbStateChanged");
            }
        }
    }

    private class ObbActionHandler
    extends Handler {
        private boolean mBound;
        private final List<ObbAction> mActions;

        ObbActionHandler(Looper l) {
            super(l);
            this.mBound = false;
            this.mActions = new LinkedList<ObbAction>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ObbAction action = (ObbAction)msg.obj;
                    if (!this.mBound && !this.connectToService()) {
                        Slog.e(MountService.TAG, "Failed to bind to media container service");
                        action.handleError();
                        return;
                    }
                    this.mActions.add(action);
                    break;
                }
                case 2: {
                    if (msg.obj != null) {
                        MountService.this.mContainerService = (IMediaContainerService)msg.obj;
                    }
                    if (MountService.this.mContainerService == null) {
                        Slog.e(MountService.TAG, "Cannot bind to media container service");
                        for (ObbAction action : this.mActions) {
                            action.handleError();
                        }
                        this.mActions.clear();
                        break;
                    }
                    if (this.mActions.size() > 0) {
                        ObbAction action = this.mActions.get(0);
                        if (action == null) break;
                        action.execute(this);
                        break;
                    }
                    Slog.w(MountService.TAG, "Empty queue");
                    break;
                }
                case 4: {
                    if (this.mActions.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e(MountService.TAG, "Failed to bind to media container service");
                    for (ObbAction action : this.mActions) {
                        action.handleError();
                    }
                    this.mActions.clear();
                    break;
                }
                case 3: {
                    if (this.mActions.size() > 0) {
                        this.mActions.remove(0);
                    }
                    if (this.mActions.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    MountService.this.mObbActionHandler.sendEmptyMessage(2);
                    break;
                }
                case 5: {
                    String path = (String)msg.obj;
                    Map map = MountService.this.mObbMounts;
                    synchronized (map) {
                        LinkedList<ObbState> obbStatesToRemove = new LinkedList<ObbState>();
                        for (ObbState state : MountService.this.mObbPathToStateMap.values()) {
                            if (!state.canonicalPath.startsWith(path)) continue;
                            obbStatesToRemove.add(state);
                        }
                        for (ObbState obbState : obbStatesToRemove) {
                            MountService.this.removeObbStateLocked(obbState);
                            try {
                                obbState.token.onObbResult(obbState.rawPath, obbState.nonce, 2);
                            }
                            catch (RemoteException e) {
                                Slog.i(MountService.TAG, "Couldn't send unmount notification for  OBB: " + obbState.rawPath);
                            }
                        }
                        break;
                    }
                }
            }
        }

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            if (MountService.this.mContext.bindService(service, MountService.this.mDefContainerConn, 1)) {
                this.mBound = true;
                return true;
            }
            return false;
        }

        private void disconnectService() {
            MountService.this.mContainerService = null;
            this.mBound = false;
            MountService.this.mContext.unbindService(MountService.this.mDefContainerConn);
        }
    }

    private final class MountServiceBinderListener
    implements IBinder.DeathRecipient {
        final IMountServiceListener mListener;

        MountServiceBinderListener(IMountServiceListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ArrayList arrayList = MountService.this.mListeners;
            synchronized (arrayList) {
                MountService.this.mListeners.remove(this);
                this.mListener.asBinder().unlinkToDeath(this, 0);
            }
        }
    }

    class MountServiceHandler
    extends Handler {
        ArrayList<UnmountCallBack> mForceUnmounts;
        boolean mUpdatingStatus;

        MountServiceHandler(Looper l) {
            super(l);
            this.mForceUnmounts = new ArrayList();
            this.mUpdatingStatus = false;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    UnmountCallBack ucb = (UnmountCallBack)msg.obj;
                    this.mForceUnmounts.add(ucb);
                    if (this.mUpdatingStatus) break;
                    this.mUpdatingStatus = true;
                    MountService.this.mPms.updateExternalMediaStatus(false, true);
                    break;
                }
                case 2: {
                    int i;
                    this.mUpdatingStatus = false;
                    int size = this.mForceUnmounts.size();
                    int[] sizeArr = new int[size];
                    int sizeArrN = 0;
                    ActivityManagerService ams = (ActivityManagerService)ServiceManager.getService("activity");
                    for (i = 0; i < size; ++i) {
                        UnmountCallBack ucb = this.mForceUnmounts.get(i);
                        String path = ucb.path;
                        boolean done = false;
                        if (!ucb.force) {
                            done = true;
                        } else {
                            int[] pids = MountService.this.getStorageUsers(path);
                            if (pids == null || pids.length == 0) {
                                done = true;
                            } else {
                                ams.killPids(pids, "unmount media", true);
                                pids = MountService.this.getStorageUsers(path);
                                if (pids == null || pids.length == 0) {
                                    done = true;
                                }
                            }
                        }
                        if (!done && ucb.retries < 4) {
                            Slog.i(MountService.TAG, "Retrying to kill storage users again");
                            MountService.this.mHandler.sendMessageDelayed(MountService.this.mHandler.obtainMessage(2, ucb.retries++), 30L);
                            continue;
                        }
                        if (ucb.retries >= 4) {
                            Slog.i(MountService.TAG, "Failed to unmount media inspite of 4 retries. Forcibly killing processes now");
                        }
                        sizeArr[sizeArrN++] = i;
                        MountService.this.mHandler.sendMessage(MountService.this.mHandler.obtainMessage(3, ucb));
                    }
                    for (i = sizeArrN - 1; i >= 0; --i) {
                        this.mForceUnmounts.remove(sizeArr[i]);
                    }
                    break;
                }
                case 3: {
                    UnmountCallBack ucb = (UnmountCallBack)msg.obj;
                    ucb.handleFinished();
                    break;
                }
                case 4: {
                    try {
                        MountService.this.handleSystemReady();
                    }
                    catch (Exception ex) {
                        Slog.e(MountService.TAG, "Boot-time mount exception", ex);
                    }
                    break;
                }
                case 5: {
                    MountService.this.waitForReady();
                    Slog.i(MountService.TAG, "Running fstrim idle maintenance");
                    try {
                        MountService.this.mLastMaintenance = System.currentTimeMillis();
                        MountService.this.mLastMaintenanceFile.setLastModified(MountService.this.mLastMaintenance);
                    }
                    catch (Exception e) {
                        Slog.e(MountService.TAG, "Unable to record last fstrim!");
                    }
                    try {
                        MountService.this.mConnector.execute("fstrim", "dotrim");
                        EventLogTags.writeFstrimStart(SystemClock.elapsedRealtime());
                    }
                    catch (NativeDaemonConnectorException ndce) {
                        Slog.e(MountService.TAG, "Failed to run fstrim!");
                    }
                    Runnable callback = (Runnable)msg.obj;
                    if (callback == null) break;
                    callback.run();
                    break;
                }
            }
        }
    }

    static class MountShutdownLatch {
        private IMountShutdownObserver mObserver;
        private AtomicInteger mCount;

        MountShutdownLatch(IMountShutdownObserver observer, int count) {
            this.mObserver = observer;
            this.mCount = new AtomicInteger(count);
        }

        void countDown() {
            boolean sendShutdown = false;
            if (this.mCount.decrementAndGet() == 0) {
                sendShutdown = true;
            }
            if (sendShutdown && this.mObserver != null) {
                try {
                    this.mObserver.onShutDownComplete(0);
                }
                catch (RemoteException e) {
                    Slog.w(MountService.TAG, "RemoteException when shutting down");
                }
            }
        }
    }

    class ShutdownCallBack
    extends UnmountCallBack {
        MountShutdownLatch mMountShutdownLatch;

        ShutdownCallBack(String path, MountShutdownLatch mountShutdownLatch) {
            super(path, true, false);
            this.mMountShutdownLatch = mountShutdownLatch;
        }

        @Override
        void handleFinished() {
            int ret = MountService.this.doUnmountVolume(this.path, true, this.removeEncryption);
            Slog.i(MountService.TAG, "Unmount completed: " + this.path + ", result code: " + ret);
            this.mMountShutdownLatch.countDown();
        }
    }

    class UmsEnableCallBack
    extends UnmountCallBack {
        final String method;

        UmsEnableCallBack(String path, String method, boolean force) {
            super(path, force, false);
            this.method = method;
        }

        @Override
        void handleFinished() {
            super.handleFinished();
            MountService.this.doShareUnshareVolume(this.path, this.method, true);
        }
    }

    class UnmountCallBack {
        final String path;
        final boolean force;
        final boolean removeEncryption;
        int retries = 0;

        UnmountCallBack(String path, boolean force, boolean removeEncryption) {
            this.path = path;
            this.force = force;
            this.removeEncryption = removeEncryption;
        }

        void handleFinished() {
            MountService.this.doUnmountVolume(this.path, true, this.removeEncryption);
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface(service);
            MountService.this.mObbActionHandler.sendMessage(MountService.this.mObbActionHandler.obtainMessage(2, imcs));
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    class ObbState
    implements IBinder.DeathRecipient {
        final String rawPath;
        final String canonicalPath;
        final String ownerPath;
        final String voldPath;
        final int ownerGid;
        final IObbActionListener token;
        final int nonce;

        public ObbState(String rawPath, String canonicalPath, int callingUid, IObbActionListener token, int nonce) {
            this.rawPath = rawPath;
            this.canonicalPath = canonicalPath.toString();
            int userId = UserHandle.getUserId(callingUid);
            this.ownerPath = MountService.buildObbPath(canonicalPath, userId, false);
            this.voldPath = MountService.buildObbPath(canonicalPath, userId, true);
            this.ownerGid = UserHandle.getSharedAppGid(callingUid);
            this.token = token;
            this.nonce = nonce;
        }

        public IBinder getBinder() {
            return this.token.asBinder();
        }

        @Override
        public void binderDied() {
            UnmountObbAction action = new UnmountObbAction(this, true);
            MountService.this.mObbActionHandler.sendMessage(MountService.this.mObbActionHandler.obtainMessage(1, action));
        }

        public void link() throws RemoteException {
            this.getBinder().linkToDeath(this, 0);
        }

        public void unlink() {
            this.getBinder().unlinkToDeath(this, 0);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ObbState{");
            sb.append("rawPath=").append(this.rawPath);
            sb.append(",canonicalPath=").append(this.canonicalPath);
            sb.append(",ownerPath=").append(this.ownerPath);
            sb.append(",voldPath=").append(this.voldPath);
            sb.append(",ownerGid=").append(this.ownerGid);
            sb.append(",token=").append(this.token);
            sb.append(",binder=").append(this.getBinder());
            sb.append('}');
            return sb.toString();
        }
    }

    class VoldResponseCode {
        public static final int VolumeListResult = 110;
        public static final int AsecListResult = 111;
        public static final int StorageUsersListResult = 112;
        public static final int CryptfsGetfieldResult = 113;
        public static final int ShareStatusResult = 210;
        public static final int AsecPathResult = 211;
        public static final int ShareEnabledResult = 212;
        public static final int OpFailedNoMedia = 401;
        public static final int OpFailedMediaBlank = 402;
        public static final int OpFailedMediaCorrupt = 403;
        public static final int OpFailedVolNotMounted = 404;
        public static final int OpFailedStorageBusy = 405;
        public static final int OpFailedStorageNotFound = 406;
        public static final int VolumeStateChange = 605;
        public static final int VolumeUuidChange = 613;
        public static final int VolumeUserLabelChange = 614;
        public static final int VolumeDiskInserted = 630;
        public static final int VolumeDiskRemoved = 631;
        public static final int VolumeBadRemoval = 632;
        public static final int FstrimCompleted = 700;

        VoldResponseCode() {
        }
    }

    class VolumeState {
        public static final int Init = -1;
        public static final int NoMedia = 0;
        public static final int Idle = 1;
        public static final int Pending = 2;
        public static final int Checking = 3;
        public static final int Mounted = 4;
        public static final int Unmounting = 5;
        public static final int Formatting = 6;
        public static final int Shared = 7;
        public static final int SharedMnt = 8;

        VolumeState() {
        }
    }
}

