/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.service.persistentdata.IPersistentDataBlockService;
import android.util.Slog;
import com.android.server.SystemService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import libcore.io.IoUtils;

public class PersistentDataBlockService
extends SystemService {
    private static final String TAG = PersistentDataBlockService.class.getSimpleName();
    private static final String PERSISTENT_DATA_BLOCK_PROP = "ro.frp.pst";
    private static final int HEADER_SIZE = 8;
    private static final int PARTITION_TYPE_MARKER = 6544;
    private static final int MAX_DATA_BLOCK_SIZE = 102400;
    private final Context mContext;
    private final String mDataBlockFile;
    private final Object mLock = new Object();
    private int mAllowedAppId = -1;
    private final Object mOemLock = new Object();
    private long mBlockDeviceSize;
    private final IBinder mService = new IPersistentDataBlockService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(byte[] data) throws RemoteException {
            DataOutputStream outputStream;
            PersistentDataBlockService.this.enforceUid(Binder.getCallingUid());
            long maxBlockSize = PersistentDataBlockService.this.getBlockDeviceSize() - 8L - 1L;
            if ((long)data.length > maxBlockSize) {
                return (int)(-maxBlockSize);
            }
            try {
                outputStream = new DataOutputStream(new FileOutputStream(new File(PersistentDataBlockService.this.mDataBlockFile)));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "partition not available?", e);
                return -1;
            }
            ByteBuffer headerAndData = ByteBuffer.allocate(data.length + 8);
            headerAndData.putInt(6544);
            headerAndData.putInt(data.length);
            headerAndData.put(data);
            try {
                Object object = PersistentDataBlockService.this.mLock;
                synchronized (object) {
                    try {
                        outputStream.write(headerAndData.array());
                        int n = data.length;
                        return n;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (IOException e) {
                            Slog.e(TAG, "failed writing to the persistent data block", e);
                            int n = -1;
                            return n;
                        }
                    }
                }
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    Slog.e(TAG, "failed closing output stream", e);
                }
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public byte[] read() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wipe() {
            PersistentDataBlockService.this.enforceOemUnlockPermission();
            Object object = PersistentDataBlockService.this.mLock;
            synchronized (object) {
                int ret = PersistentDataBlockService.this.nativeWipe(PersistentDataBlockService.this.mDataBlockFile);
                if (ret < 0) {
                    Slog.e(TAG, "failed to wipe persistent partition");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOemUnlockEnabled(boolean enabled) {
            FileOutputStream outputStream;
            if (ActivityManager.isUserAMonkey()) {
                return;
            }
            PersistentDataBlockService.this.enforceOemUnlockPermission();
            try {
                outputStream = new FileOutputStream(new File(PersistentDataBlockService.this.mDataBlockFile));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "parition not available", e);
                return;
            }
            try {
                FileChannel channel = outputStream.getChannel();
                channel.position(PersistentDataBlockService.this.getBlockDeviceSize() - 1L);
                ByteBuffer data = ByteBuffer.allocate(1);
                data.put(enabled ? (byte)1 : 0);
                data.flip();
                Object object = PersistentDataBlockService.this.mOemLock;
                synchronized (object) {
                    channel.write(data);
                }
            }
            catch (IOException e) {
                Slog.e(TAG, "unable to access persistent partition", e);
            }
            finally {
                IoUtils.closeQuietly(outputStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getOemUnlockEnabled() {
            DataInputStream inputStream;
            PersistentDataBlockService.this.enforceOemUnlockPermission();
            try {
                inputStream = new DataInputStream(new FileInputStream(new File(PersistentDataBlockService.this.mDataBlockFile)));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "partition not available");
                return false;
            }
            try {
                inputStream.skip(PersistentDataBlockService.this.getBlockDeviceSize() - 1L);
                Object e = PersistentDataBlockService.this.mOemLock;
                synchronized (e) {
                    try {
                        boolean bl = inputStream.readByte() != 0;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (IOException e2) {
                            Slog.e(TAG, "unable to access persistent partition", e2);
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            finally {
                IoUtils.closeQuietly(inputStream);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDataBlockSize() {
            DataInputStream inputStream;
            PersistentDataBlockService.this.enforceUid(Binder.getCallingUid());
            try {
                inputStream = new DataInputStream(new FileInputStream(new File(PersistentDataBlockService.this.mDataBlockFile)));
            }
            catch (FileNotFoundException e) {
                Slog.e(TAG, "partition not available");
                return 0;
            }
            try {
                Object e = PersistentDataBlockService.this.mLock;
                synchronized (e) {
                    try {
                        int n = PersistentDataBlockService.this.getTotalDataSizeLocked(inputStream);
                        return n;
                    }
                    catch (Throwable throwable) {
                        try {
                            throw throwable;
                        }
                        catch (IOException e2) {
                            Slog.e(TAG, "error reading data block size");
                            int n = 0;
                            return n;
                        }
                    }
                }
            }
            finally {
                IoUtils.closeQuietly(inputStream);
            }
        }

        @Override
        public long getMaximumDataBlockSize() {
            long actualSize = PersistentDataBlockService.this.getBlockDeviceSize() - 8L - 1L;
            return actualSize <= 102400L ? actualSize : 102400L;
        }
    };

    public PersistentDataBlockService(Context context) {
        super(context);
        this.mContext = context;
        this.mDataBlockFile = SystemProperties.get(PERSISTENT_DATA_BLOCK_PROP);
        this.mBlockDeviceSize = -1L;
        this.mAllowedAppId = this.getAllowedAppId(0);
    }

    private int getAllowedAppId(int userHandle) {
        String allowedPackage = this.mContext.getResources().getString(17039429);
        PackageManager pm = this.mContext.getPackageManager();
        int allowedUid = -1;
        try {
            allowedUid = pm.getPackageUid(allowedPackage, userHandle);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "not able to find package " + allowedPackage, e);
        }
        return UserHandle.getAppId(allowedUid);
    }

    @Override
    public void onStart() {
        this.publishBinderService("persistent_data_block", this.mService);
    }

    private void enforceOemUnlockPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.OEM_UNLOCK_STATE", "Can't access OEM unlock state");
    }

    private void enforceUid(int callingUid) {
        if (UserHandle.getAppId(callingUid) != this.mAllowedAppId) {
            throw new SecurityException("uid " + callingUid + " not allowed to access PST");
        }
    }

    private int getTotalDataSizeLocked(DataInputStream inputStream) throws IOException {
        int blockId = inputStream.readInt();
        int totalDataSize = blockId == 6544 ? inputStream.readInt() : 0;
        return totalDataSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getBlockDeviceSize() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBlockDeviceSize == -1L) {
                this.mBlockDeviceSize = this.nativeGetBlockDeviceSize(this.mDataBlockFile);
            }
        }
        return this.mBlockDeviceSize;
    }

    private native long nativeGetBlockDeviceSize(String var1);

    private native int nativeWipe(String var1);
}

