/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.AppOpsManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.hardware.input.InputManager;
import android.media.AudioAttributes;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IVibratorService;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.Vibrator;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.Slog;
import android.view.InputDevice;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.server.LocalServices;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class VibratorService
extends IVibratorService.Stub
implements InputManager.InputDeviceListener {
    private static final String TAG = "VibratorService";
    private static final boolean DEBUG = false;
    private final LinkedList<Vibration> mVibrations;
    private Vibration mCurrentVibration;
    private final WorkSource mTmpWorkSource = new WorkSource();
    private final Handler mH = new Handler();
    private final Context mContext;
    private final PowerManager.WakeLock mWakeLock;
    private final IAppOpsService mAppOpsService;
    private final IBatteryStats mBatteryStatsService;
    private PowerManagerInternal mPowerManagerInternal;
    private InputManager mIm;
    volatile VibrateThread mThread;
    private final ArrayList<Vibrator> mInputDeviceVibrators = new ArrayList();
    private boolean mVibrateInputDevicesSetting;
    private boolean mInputDeviceListenerRegistered;
    private int mCurVibUid = -1;
    private boolean mLowPowerMode;
    private SettingsObserver mSettingObserver;
    private final Runnable mVibrationRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = VibratorService.this.mVibrations;
            synchronized (linkedList) {
                VibratorService.this.doCancelVibrateLocked();
                VibratorService.this.startNextVibrationLocked();
            }
        }
    };
    BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                LinkedList linkedList = VibratorService.this.mVibrations;
                synchronized (linkedList) {
                    if (VibratorService.this.mCurrentVibration != null && !VibratorService.this.mCurrentVibration.isSystemHapticFeedback()) {
                        VibratorService.this.doCancelVibrateLocked();
                    }
                    Iterator it = VibratorService.this.mVibrations.iterator();
                    while (it.hasNext()) {
                        Vibration vibration = (Vibration)it.next();
                        if (vibration == VibratorService.this.mCurrentVibration) continue;
                        VibratorService.this.unlinkVibration(vibration);
                        it.remove();
                    }
                }
            }
        }
    };

    static native boolean vibratorExists();

    static native void vibratorOn(long var0);

    static native void vibratorOff();

    VibratorService(Context context) {
        VibratorService.vibratorOff();
        this.mContext = context;
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "*vibrator*");
        this.mWakeLock.setReferenceCounted(true);
        this.mAppOpsService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        this.mBatteryStatsService = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mVibrations = new LinkedList();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_OFF");
        context.registerReceiver(this.mIntentReceiver, filter);
    }

    public void systemReady() {
        this.mIm = (InputManager)this.mContext.getSystemService("input");
        this.mSettingObserver = new SettingsObserver(this.mH);
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

            @Override
            public void onLowPowerModeChanged(boolean enabled) {
                VibratorService.this.updateInputDeviceVibrators();
            }
        });
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor("vibrate_input_devices"), true, this.mSettingObserver, -1);
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                VibratorService.this.updateInputDeviceVibrators();
            }
        }, new IntentFilter("android.intent.action.USER_SWITCHED"), null, this.mH);
        this.updateInputDeviceVibrators();
    }

    @Override
    public boolean hasVibrator() {
        return this.doVibratorExists();
    }

    private void verifyIncomingUid(int uid) {
        if (uid == Binder.getCallingUid()) {
            return;
        }
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_APP_OPS_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vibrate(int uid, String opPkg, long milliseconds, int usageHint, IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.VIBRATE") != 0) {
            throw new SecurityException("Requires VIBRATE permission");
        }
        this.verifyIncomingUid(uid);
        if (milliseconds <= 0L || this.mCurrentVibration != null && this.mCurrentVibration.hasLongerTimeout(milliseconds)) {
            return;
        }
        Vibration vib = new Vibration(token, milliseconds, usageHint, uid, opPkg);
        long ident = Binder.clearCallingIdentity();
        try {
            LinkedList<Vibration> linkedList = this.mVibrations;
            synchronized (linkedList) {
                this.removeVibrationLocked(token);
                this.doCancelVibrateLocked();
                this.mCurrentVibration = vib;
                this.startVibrationLocked(vib);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private boolean isAll0(long[] pattern) {
        int N = pattern.length;
        for (int i = 0; i < N; ++i) {
            if (pattern[i] == 0L) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vibratePattern(int uid, String packageName, long[] pattern, int repeat, int usageHint, IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.VIBRATE") != 0) {
            throw new SecurityException("Requires VIBRATE permission");
        }
        this.verifyIncomingUid(uid);
        long identity = Binder.clearCallingIdentity();
        try {
            if (pattern == null || pattern.length == 0 || this.isAll0(pattern) || repeat >= pattern.length || token == null) {
                return;
            }
            Vibration vib = new Vibration(token, pattern, repeat, usageHint, uid, packageName);
            try {
                token.linkToDeath(vib, 0);
            }
            catch (RemoteException e) {
                Binder.restoreCallingIdentity(identity);
                return;
            }
            LinkedList<Vibration> linkedList = this.mVibrations;
            synchronized (linkedList) {
                this.removeVibrationLocked(token);
                this.doCancelVibrateLocked();
                if (repeat >= 0) {
                    this.mVibrations.addFirst(vib);
                    this.startNextVibrationLocked();
                } else {
                    this.mCurrentVibration = vib;
                    this.startVibrationLocked(vib);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelVibrate(IBinder token) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.VIBRATE", "cancelVibrate");
        long identity = Binder.clearCallingIdentity();
        try {
            LinkedList<Vibration> linkedList = this.mVibrations;
            synchronized (linkedList) {
                Vibration vib = this.removeVibrationLocked(token);
                if (vib == this.mCurrentVibration) {
                    this.doCancelVibrateLocked();
                    this.startNextVibrationLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCancelVibrateLocked() {
        if (this.mThread != null) {
            VibrateThread vibrateThread = this.mThread;
            synchronized (vibrateThread) {
                this.mThread.mDone = true;
                this.mThread.notify();
            }
            this.mThread = null;
        }
        this.doVibratorOff();
        this.mH.removeCallbacks(this.mVibrationRunnable);
        this.reportFinishVibrationLocked();
    }

    private void startNextVibrationLocked() {
        if (this.mVibrations.size() <= 0) {
            this.reportFinishVibrationLocked();
            this.mCurrentVibration = null;
            return;
        }
        this.mCurrentVibration = this.mVibrations.getFirst();
        this.startVibrationLocked(this.mCurrentVibration);
    }

    private void startVibrationLocked(Vibration vib) {
        try {
            if (this.mLowPowerMode && vib.mUsageHint != 6) {
                return;
            }
            int mode = this.mAppOpsService.checkAudioOperation(3, vib.mUsageHint, vib.mUid, vib.mOpPkg);
            if (mode == 0) {
                mode = this.mAppOpsService.startOperation(AppOpsManager.getToken(this.mAppOpsService), 3, vib.mUid, vib.mOpPkg);
            }
            if (mode != 0) {
                if (mode == 2) {
                    Slog.w(TAG, "Would be an error: vibrate from uid " + vib.mUid);
                }
                this.mH.post(this.mVibrationRunnable);
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (vib.mTimeout != 0L) {
            this.doVibratorOn(vib.mTimeout, vib.mUid, vib.mUsageHint);
            this.mH.postDelayed(this.mVibrationRunnable, vib.mTimeout);
        } else {
            this.mThread = new VibrateThread(vib);
            this.mThread.start();
        }
    }

    private void reportFinishVibrationLocked() {
        if (this.mCurrentVibration != null) {
            try {
                this.mAppOpsService.finishOperation(AppOpsManager.getToken(this.mAppOpsService), 3, this.mCurrentVibration.mUid, this.mCurrentVibration.mOpPkg);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mCurrentVibration = null;
        }
    }

    private Vibration removeVibrationLocked(IBinder token) {
        ListIterator<Vibration> iter = this.mVibrations.listIterator(0);
        while (iter.hasNext()) {
            Vibration vib = iter.next();
            if (vib.mToken != token) continue;
            iter.remove();
            this.unlinkVibration(vib);
            return vib;
        }
        if (this.mCurrentVibration != null && this.mCurrentVibration.mToken == token) {
            this.unlinkVibration(this.mCurrentVibration);
            return this.mCurrentVibration;
        }
        return null;
    }

    private void unlinkVibration(Vibration vib) {
        if (vib.mPattern != null) {
            vib.mToken.unlinkToDeath(vib, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInputDeviceVibrators() {
        LinkedList<Vibration> linkedList = this.mVibrations;
        synchronized (linkedList) {
            this.doCancelVibrateLocked();
            ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
            synchronized (arrayList) {
                this.mVibrateInputDevicesSetting = false;
                try {
                    this.mVibrateInputDevicesSetting = Settings.System.getIntForUser(this.mContext.getContentResolver(), "vibrate_input_devices", -2) > 0;
                }
                catch (Settings.SettingNotFoundException settingNotFoundException) {
                    // empty catch block
                }
                this.mLowPowerMode = this.mPowerManagerInternal.getLowPowerModeEnabled();
                if (this.mVibrateInputDevicesSetting) {
                    if (!this.mInputDeviceListenerRegistered) {
                        this.mInputDeviceListenerRegistered = true;
                        this.mIm.registerInputDeviceListener(this, this.mH);
                    }
                } else if (this.mInputDeviceListenerRegistered) {
                    this.mInputDeviceListenerRegistered = false;
                    this.mIm.unregisterInputDeviceListener(this);
                }
                this.mInputDeviceVibrators.clear();
                if (this.mVibrateInputDevicesSetting) {
                    int[] ids = this.mIm.getInputDeviceIds();
                    for (int i = 0; i < ids.length; ++i) {
                        InputDevice device = this.mIm.getInputDevice(ids[i]);
                        Vibrator vibrator = device.getVibrator();
                        if (!vibrator.hasVibrator()) continue;
                        this.mInputDeviceVibrators.add(vibrator);
                    }
                }
            }
            this.startNextVibrationLocked();
        }
    }

    @Override
    public void onInputDeviceAdded(int deviceId) {
        this.updateInputDeviceVibrators();
    }

    @Override
    public void onInputDeviceChanged(int deviceId) {
        this.updateInputDeviceVibrators();
    }

    @Override
    public void onInputDeviceRemoved(int deviceId) {
        this.updateInputDeviceVibrators();
    }

    private boolean doVibratorExists() {
        return VibratorService.vibratorExists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOn(long millis, int uid, int usageHint) {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            try {
                this.mBatteryStatsService.noteVibratorOn(uid, millis);
                this.mCurVibUid = uid;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            int vibratorCount = this.mInputDeviceVibrators.size();
            if (vibratorCount != 0) {
                AudioAttributes attributes = new AudioAttributes.Builder().setUsage(usageHint).build();
                for (int i = 0; i < vibratorCount; ++i) {
                    this.mInputDeviceVibrators.get(i).vibrate(millis, attributes);
                }
            } else {
                VibratorService.vibratorOn(millis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVibratorOff() {
        ArrayList<Vibrator> arrayList = this.mInputDeviceVibrators;
        synchronized (arrayList) {
            int vibratorCount;
            if (this.mCurVibUid >= 0) {
                try {
                    this.mBatteryStatsService.noteVibratorOff(this.mCurVibUid);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.mCurVibUid = -1;
            }
            if ((vibratorCount = this.mInputDeviceVibrators.size()) != 0) {
                for (int i = 0; i < vibratorCount; ++i) {
                    this.mInputDeviceVibrators.get(i).cancel();
                }
            } else {
                VibratorService.vibratorOff();
            }
        }
    }

    private class VibrateThread
    extends Thread {
        final Vibration mVibration;
        boolean mDone;

        VibrateThread(Vibration vib) {
            this.mVibration = vib;
            VibratorService.this.mTmpWorkSource.set(vib.mUid);
            VibratorService.this.mWakeLock.setWorkSource(VibratorService.this.mTmpWorkSource);
            VibratorService.this.mWakeLock.acquire();
        }

        private void delay(long duration) {
            if (duration > 0L) {
                long bedtime = duration + SystemClock.uptimeMillis();
                do {
                    try {
                        this.wait(duration);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!this.mDone && (duration = bedtime - SystemClock.uptimeMillis()) > 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Process.setThreadPriority(-8);
            Object object = this;
            synchronized (object) {
                long[] pattern = this.mVibration.mPattern;
                int len = pattern.length;
                int repeat = this.mVibration.mRepeat;
                int uid = this.mVibration.mUid;
                int usageHint = this.mVibration.mUsageHint;
                int index = 0;
                long duration = 0L;
                while (!this.mDone) {
                    if (index < len) {
                        duration += pattern[index++];
                    }
                    this.delay(duration);
                    if (this.mDone) break;
                    if (index < len) {
                        if ((duration = pattern[index++]) <= 0L) continue;
                        VibratorService.this.doVibratorOn(duration, uid, usageHint);
                        continue;
                    }
                    if (repeat < 0) break;
                    index = repeat;
                    duration = 0L;
                }
                VibratorService.this.mWakeLock.release();
            }
            object = VibratorService.this.mVibrations;
            synchronized (object) {
                if (VibratorService.this.mThread == this) {
                    VibratorService.this.mThread = null;
                }
                if (!this.mDone) {
                    VibratorService.this.mVibrations.remove(this.mVibration);
                    VibratorService.this.unlinkVibration(this.mVibration);
                    VibratorService.this.startNextVibrationLocked();
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean SelfChange) {
            VibratorService.this.updateInputDeviceVibrators();
        }
    }

    private class Vibration
    implements IBinder.DeathRecipient {
        private final IBinder mToken;
        private final long mTimeout;
        private final long mStartTime;
        private final long[] mPattern;
        private final int mRepeat;
        private final int mUsageHint;
        private final int mUid;
        private final String mOpPkg;

        Vibration(IBinder token, long millis, int usageHint, int uid, String opPkg) {
            this(token, millis, null, 0, usageHint, uid, opPkg);
        }

        Vibration(IBinder token, long[] pattern, int repeat, int usageHint, int uid, String opPkg) {
            this(token, 0L, pattern, repeat, usageHint, uid, opPkg);
        }

        private Vibration(IBinder token, long millis, long[] pattern, int repeat, int usageHint, int uid, String opPkg) {
            this.mToken = token;
            this.mTimeout = millis;
            this.mStartTime = SystemClock.uptimeMillis();
            this.mPattern = pattern;
            this.mRepeat = repeat;
            this.mUsageHint = usageHint;
            this.mUid = uid;
            this.mOpPkg = opPkg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            LinkedList linkedList = VibratorService.this.mVibrations;
            synchronized (linkedList) {
                VibratorService.this.mVibrations.remove(this);
                if (this == VibratorService.this.mCurrentVibration) {
                    VibratorService.this.doCancelVibrateLocked();
                    VibratorService.this.startNextVibrationLocked();
                }
            }
        }

        public boolean hasLongerTimeout(long millis) {
            if (this.mTimeout == 0L) {
                return false;
            }
            return this.mStartTime + this.mTimeout >= SystemClock.uptimeMillis() + millis;
        }

        public boolean isSystemHapticFeedback() {
            return (this.mUid == 1000 || this.mUid == 0) && this.mRepeat < 0;
        }
    }
}

