/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.Slog;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import com.android.server.LocalServices;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public final class BatteryStatsService
extends IBatteryStats.Stub
implements PowerManagerInternal.LowPowerModeListener {
    static final String TAG = "BatteryStatsService";
    static IBatteryStats sService;
    final BatteryStatsImpl mStats;
    Context mContext;
    private boolean mBluetoothPendingStats;
    private BluetoothHeadset mBluetoothHeadset;
    PowerManagerInternal mPowerManagerInternal;
    private BluetoothProfile.ServiceListener mBluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            BatteryStatsService.this.mBluetoothHeadset = (BluetoothHeadset)proxy;
            BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
            synchronized (batteryStatsImpl) {
                if (BatteryStatsService.this.mBluetoothPendingStats) {
                    BatteryStatsService.this.mStats.noteBluetoothOnLocked();
                    BatteryStatsService.this.mStats.setBtHeadset(BatteryStatsService.this.mBluetoothHeadset);
                    BatteryStatsService.this.mBluetoothPendingStats = false;
                }
            }
        }

        @Override
        public void onServiceDisconnected(int profile) {
            BatteryStatsService.this.mBluetoothHeadset = null;
        }
    };

    BatteryStatsService(File systemDir, Handler handler) {
        this.mStats = new BatteryStatsImpl(systemDir, handler);
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService("batterystats", this.asBinder());
        this.mStats.setNumSpeedSteps(new PowerProfile(this.mContext).getNumSpeedSteps());
        this.mStats.setRadioScanningTimeout((long)this.mContext.getResources().getInteger(17694732) * 1000L);
    }

    public void initPowerManagement() {
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mPowerManagerInternal.registerLowPowerModeObserver(this);
        this.mStats.noteLowPowerMode(this.mPowerManagerInternal.getLowPowerModeEnabled());
        new WakeupReasonThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w("BatteryStats", "Writing battery stats before shutdown...");
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.shutdownLocked();
        }
    }

    public static IBatteryStats getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("batterystats");
        sService = BatteryStatsService.asInterface(b);
        return sService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLowPowerModeChanged(boolean enabled) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteLowPowerMode(enabled);
        }
    }

    public BatteryStatsImpl getActiveStatistics() {
        return this.mStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.addIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.removeIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessStart(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessState(String name, int uid, int state) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessStateLocked(name, uid, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessFinish(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessFinishLocked(name, uid);
        }
    }

    @Override
    public byte[] getStatistics() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.mStats.writeToParcel(out, 0);
        byte[] data = out.marshall();
        out.recycle();
        return data;
    }

    @Override
    public ParcelFileDescriptor getStatisticsStream() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.mStats.writeToParcel(out, 0);
        byte[] data = out.marshall();
        out.recycle();
        try {
            return ParcelFileDescriptor.fromData(data, "battery-stats");
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to create shared memory", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeBatteryTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeChargeTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteEvent(int code, String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteEventLocked(code, name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelock(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeLocked(uid, pid, name, historyName, type, unimportantForLogging, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelock(int uid, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeLocked(uid, pid, name, historyName, type, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeFromSourceLocked(ws, pid, name, historyName, type, unimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteChangeWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteChangeWakelockFromSourceLocked(ws, pid, name, historyName, type, newWs, newPid, newName, newHistoryName, newType, newUnimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeFromSourceLocked(ws, pid, name, historyName, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOn(int uid, long durationMillis) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOnLocked(uid, durationMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOff(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenState(int state) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenStateLocked(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenBrightness(int brightness) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenBrightnessLocked(brightness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteUserActivity(int uid, int event) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteUserActivityLocked(uid, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteInteractive(boolean interactive) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteInteractiveLocked(interactive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteMobileRadioPowerState(int powerState, long timestampNs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteMobileRadioPowerState(powerState, timestampNs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneSignalStrength(SignalStrength signalStrength) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneSignalStrengthLocked(signalStrength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneDataConnectionState(int dataType, boolean hasData) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneDataConnectionStateLocked(dataType, hasData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneState(int state) {
        this.enforceCallingPermission();
        int simState = TelephonyManager.getDefault().getSimState();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneStateLocked(state, simState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetAudio() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetAudioLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetVideo() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetVideoLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunning(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunningChanged(WorkSource oldWs, WorkSource newWs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningChangedLocked(oldWs, newWs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiStopped(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStoppedLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiState(int wifiState, String accessPoint) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStateLocked(wifiState, accessPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiSupplicantStateChanged(int supplState, boolean failedAuth) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiSupplicantStateChangedLocked(supplState, failedAuth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRssiChanged(int newRssi) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRssiChangedLocked(newRssi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBluetoothOn() {
        this.enforceCallingPermission();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            adapter.getProfileProxy(this.mContext, this.mBluetoothProfileServiceListener, 1);
        }
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            if (this.mBluetoothHeadset != null) {
                this.mStats.noteBluetoothOnLocked();
                this.mStats.setBtHeadset(this.mBluetoothHeadset);
            } else {
                this.mBluetoothPendingStats = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBluetoothOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mBluetoothPendingStats = false;
            this.mStats.noteBluetoothOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteBluetoothState(int bluetoothState) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteBluetoothStateLocked(bluetoothState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquired(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleased(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStarted(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStopped(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastEnabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastDisabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquiredFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleasedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStartedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStartedFromSource(WorkSource ws, int csph) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStartedFromSourceLocked(ws, csph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastEnabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastDisabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteNetworkInterfaceType(String iface, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteNetworkInterfaceTypeLocked(iface, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteNetworkStatsEnabled() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteNetworkStatsEnabledLocked();
        }
    }

    public boolean isOnBattery() {
        return this.mStats.isOnBattery();
    }

    @Override
    public void setBatteryState(int status, int health, int plugType, int level, int temp, int volt) {
        this.enforceCallingPermission();
        this.mStats.setBatteryState(status, health, plugType, level, temp, volt);
    }

    @Override
    public long getAwakeTimeBattery() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimeBattery();
    }

    @Override
    public long getAwakeTimePlugged() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimePlugged();
    }

    public void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private static native int nativeWaitWakeup(int[] var0, String[] var1);

    private void dumpHelp(PrintWriter pw) {
        pw.println("Battery stats (batterystats) dump options:");
        pw.println("  [--checkin] [--history] [--history-start] [--unplugged] [--charged] [-c]");
        pw.println("  [--reset] [--write] [-h] [<package.name>]");
        pw.println("  --checkin: format output for a checkin report.");
        pw.println("  --history: show only history data.");
        pw.println("  --history-start <num>: show only history data starting at given time offset.");
        pw.println("  --unplugged: only output data since last unplugged.");
        pw.println("  --charged: only output data since last charged.");
        pw.println("  --reset: reset the stats, clearing all current data.");
        pw.println("  --write: force write current collected stats to disk.");
        pw.println("  <package.name>: optional name of package to filter output by.");
        pw.println("  -h: print this help text.");
        pw.println("Battery stats (batterystats) commands:");
        pw.println("  enable|disable <option>");
        pw.println("    Enable or disable a running option.  Option state is not saved across boots.");
        pw.println("    Options are:");
        pw.println("      full-history: include additional detailed events in battery history:");
        pw.println("          wake_lock_in and proc events");
        pw.println("      no-auto-reset: don't automatically reset stats when unplugged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnableOrDisable(PrintWriter pw, int i, String[] args, boolean enable) {
        if (++i >= args.length) {
            pw.println("Missing option argument for " + (enable ? "--enable" : "--disable"));
            this.dumpHelp(pw);
            return -1;
        }
        if ("full-wake-history".equals(args[i]) || "full-history".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setRecordAllHistoryLocked(enable);
            }
        } else if ("no-auto-reset".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setNoAutoReset(enable);
            }
        } else {
            pw.println("Unknown enable/disable option: " + args[i]);
            this.dumpHelp(pw);
            return -1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump BatteryStats from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        int flags = 0;
        boolean useCheckinFormat = false;
        boolean isRealCheckin = false;
        boolean noOutput = false;
        boolean writeData = false;
        long historyStart = -1L;
        int reqUid = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                BatteryStatsImpl batteryStatsImpl;
                String arg = args[i];
                if ("--checkin".equals(arg)) {
                    useCheckinFormat = true;
                    isRealCheckin = true;
                    continue;
                }
                if ("--history".equals(arg)) {
                    flags |= 4;
                    continue;
                }
                if ("--history-start".equals(arg)) {
                    flags |= 4;
                    if (++i >= args.length) {
                        pw.println("Missing time argument for --history-since");
                        this.dumpHelp(pw);
                        return;
                    }
                    historyStart = Long.parseLong(args[i]);
                    writeData = true;
                    continue;
                }
                if ("-c".equals(arg)) {
                    useCheckinFormat = true;
                    flags |= 8;
                    continue;
                }
                if ("--unplugged".equals(arg)) {
                    flags |= 1;
                    continue;
                }
                if ("--charged".equals(arg)) {
                    flags |= 2;
                    continue;
                }
                if ("--reset".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.resetAllStatsCmdLocked();
                        pw.println("Battery stats reset.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--write".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.writeSyncLocked();
                        pw.println("Battery stats written.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--enable".equals(arg) || "enable".equals(arg)) {
                    if ((i = this.doEnableOrDisable(pw, i, args, true)) < 0) {
                        return;
                    }
                    pw.println("Enabled: " + args[i]);
                    return;
                }
                if ("--disable".equals(arg) || "disable".equals(arg)) {
                    if ((i = this.doEnableOrDisable(pw, i, args, false)) < 0) {
                        return;
                    }
                    pw.println("Disabled: " + args[i]);
                    return;
                }
                if ("-h".equals(arg)) {
                    this.dumpHelp(pw);
                    return;
                }
                if ("-a".equals(arg)) {
                    flags |= 0x10;
                    continue;
                }
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    this.dumpHelp(pw);
                    return;
                }
                try {
                    reqUid = this.mContext.getPackageManager().getPackageUid(arg, UserHandle.getCallingUserId());
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    pw.println("Unknown package: " + arg);
                    this.dumpHelp(pw);
                    return;
                }
            }
        }
        if (noOutput) {
            return;
        }
        if (BatteryStatsHelper.checkWifiOnly(this.mContext)) {
            flags |= 0x20;
        }
        if (reqUid >= 0 && (flags & 7) == 0) {
            flags |= 2;
            flags &= 0xFFFFFFF7;
        }
        if (useCheckinFormat) {
            Object object;
            List<ApplicationInfo> apps = this.mContext.getPackageManager().getInstalledApplications(0);
            if (isRealCheckin) {
                object = this.mStats.mCheckinFile;
                synchronized (object) {
                    if (this.mStats.mCheckinFile.exists()) {
                        try {
                            byte[] raw2 = this.mStats.mCheckinFile.readFully();
                            if (raw2 != null) {
                                Parcel in = Parcel.obtain();
                                in.unmarshall(raw2, 0, raw2.length);
                                in.setDataPosition(0);
                                BatteryStatsImpl checkinStats = new BatteryStatsImpl(null, this.mStats.mHandler);
                                checkinStats.readSummaryFromParcel(in);
                                in.recycle();
                                checkinStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                                this.mStats.mCheckinFile.delete();
                                return;
                            }
                        }
                        catch (IOException e) {
                            Slog.w(TAG, "Failure reading checkin file " + this.mStats.mCheckinFile.getBaseFile(), e);
                        }
                    }
                }
            }
            object = this.mStats;
            synchronized (object) {
                this.mStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                if (writeData) {
                    this.mStats.writeAsyncLocked();
                }
            }
        }
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.dumpLocked(this.mContext, pw, flags, reqUid, historyStart);
            if (writeData) {
                this.mStats.writeAsyncLocked();
            }
        }
    }

    final class WakeupReasonThread
    extends Thread {
        final int[] mIrqs;
        final String[] mReasons;

        WakeupReasonThread() {
            super("BatteryStats_wakeupReason");
            this.mIrqs = new int[32];
            this.mReasons = new String[32];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Process.setThreadPriority(-2);
            try {
                int num;
                while ((num = BatteryStatsService.nativeWaitWakeup(this.mIrqs, this.mReasons)) >= 0) {
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                    synchronized (batteryStatsImpl) {
                        if (num > 0) {
                            for (int i = 0; i < num; ++i) {
                                BatteryStatsService.this.mStats.noteWakeupReasonLocked(this.mReasons[i]);
                            }
                        } else {
                            BatteryStatsService.this.mStats.noteWakeupReasonLocked("unknown");
                        }
                    }
                }
                return;
            }
            catch (RuntimeException e) {
                Slog.e(BatteryStatsService.TAG, "Failure reading wakeup reasons", e);
            }
        }
    }
}

