/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Slog;
import android.view.accessibility.AccessibilityManager;
import android.widget.CheckBox;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternUtilsCache;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.TaskRecord;

public class LockToAppRequestDialog
implements DialogInterface.OnClickListener {
    private static final String TAG = "ActivityManager";
    private final Context mContext;
    private final ActivityManagerService mService;
    private AlertDialog mDialog;
    private TaskRecord mRequestedTask;
    private CheckBox mCheckbox;
    private ILockSettings mLockSettingsService;
    private AccessibilityManager mAccessibilityService;

    public LockToAppRequestDialog(Context context, ActivityManagerService activityManagerService) {
        this.mContext = context;
        this.mAccessibilityService = (AccessibilityManager)this.mContext.getSystemService("accessibility");
        this.mService = activityManagerService;
    }

    private ILockSettings getLockSettings() {
        if (this.mLockSettingsService == null) {
            this.mLockSettingsService = LockPatternUtilsCache.getInstance(ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings")));
        }
        return this.mLockSettingsService;
    }

    private int getLockString(int userId) {
        try {
            int quality = (int)this.getLockSettings().getLong("lockscreen.password_type", 0L, userId);
            switch (quality) {
                case 131072: 
                case 196608: {
                    return 17041020;
                }
                case 262144: 
                case 327680: 
                case 393216: {
                    return 17041022;
                }
                case 65536: {
                    if (!this.getLockSettings().getBoolean("lock_pattern_autolock", false, userId)) break;
                    return 17041021;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return 0;
    }

    public void clearPrompt() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
        }
    }

    public void showLockTaskPrompt(TaskRecord task) {
        this.clearPrompt();
        this.mRequestedTask = task;
        int unlockStringId = this.getLockString(task.userId);
        Resources r = Resources.getSystem();
        String description = r.getString(this.mAccessibilityService.isEnabled() ? 17041015 : 17041014);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.mContext).setTitle(r.getString(17041013)).setMessage(description).setPositiveButton(r.getString(17041017), (DialogInterface.OnClickListener)this).setNegativeButton(r.getString(17041016), (DialogInterface.OnClickListener)this);
        if (unlockStringId != 0) {
            builder.setView(17367147);
        }
        this.mDialog = builder.create();
        this.mDialog.getWindow().setType(2003);
        this.mDialog.getWindow().getAttributes().privateFlags |= 0x10;
        this.mDialog.show();
        if (unlockStringId != 0) {
            String unlockString = this.mContext.getString(unlockStringId);
            this.mCheckbox = (CheckBox)this.mDialog.findViewById(16909084);
            this.mCheckbox.setText(unlockString);
            try {
                boolean useLock = Settings.System.getInt(this.mContext.getContentResolver(), "lock_to_app_exit_locked") != 0;
                this.mCheckbox.setChecked(useLock);
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {}
        } else {
            this.mCheckbox = null;
        }
    }

    @Override
    public void onClick(DialogInterface dialog, int which) {
        if (-1 == which) {
            Slog.d(TAG, "accept lock-to-app request");
            Settings.System.putInt(this.mContext.getContentResolver(), "lock_to_app_exit_locked", this.mCheckbox != null && this.mCheckbox.isChecked() ? 1 : 0);
            this.mService.startLockTaskMode(this.mRequestedTask);
        } else {
            Slog.d(TAG, "ignore lock-to-app request");
        }
    }
}

