/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.res.Resources;
import android.graphics.Point;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Build;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.util.MemInfoReader;
import com.android.server.wm.WindowManagerService;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

final class ProcessList {
    static final int MIN_CRASH_INTERVAL = 60000;
    static final int UNKNOWN_ADJ = 16;
    static final int CACHED_APP_MAX_ADJ = 15;
    static final int CACHED_APP_MIN_ADJ = 9;
    static final int SERVICE_B_ADJ = 8;
    static final int PREVIOUS_APP_ADJ = 7;
    static final int HOME_APP_ADJ = 6;
    static final int SERVICE_ADJ = 5;
    static final int HEAVY_WEIGHT_APP_ADJ = 4;
    static final int BACKUP_APP_ADJ = 3;
    static final int PERCEPTIBLE_APP_ADJ = 2;
    static final int VISIBLE_APP_ADJ = 1;
    static final int FOREGROUND_APP_ADJ = 0;
    static final int PERSISTENT_SERVICE_ADJ = -11;
    static final int PERSISTENT_PROC_ADJ = -12;
    static final int SYSTEM_ADJ = -16;
    static final int NATIVE_ADJ = -17;
    static final int PAGE_SIZE = 4096;
    static final int MIN_CACHED_APPS = 2;
    static final int MAX_CACHED_APPS = 32;
    static final long MAX_EMPTY_TIME = 1800000L;
    private static final int MAX_EMPTY_APPS = ProcessList.computeEmptyProcessLimit(32);
    static final int TRIM_EMPTY_APPS = MAX_EMPTY_APPS / 2;
    static final int TRIM_CACHED_APPS = (32 - MAX_EMPTY_APPS) / 3;
    static final int TRIM_CRITICAL_THRESHOLD = 3;
    static final int TRIM_LOW_THRESHOLD = 5;
    static final byte LMK_TARGET = 0;
    static final byte LMK_PROCPRIO = 1;
    static final byte LMK_PROCREMOVE = 2;
    private final int[] mOomAdj = new int[]{0, 1, 2, 3, 9, 15};
    private final int[] mOomMinFreeLow = new int[]{12288, 18432, 24576, 36864, 43008, 49152};
    private final int[] mOomMinFreeHigh = new int[]{73728, 92160, 110592, 129024, 225000, 325000};
    private final int[] mOomMinFree = new int[this.mOomAdj.length];
    private final long mTotalMemMb;
    private long mCachedRestoreLevel;
    private boolean mHaveDisplaySize;
    private static LocalSocket sLmkdSocket;
    private static OutputStream sLmkdOutputStream;
    public static final int PSS_MIN_TIME_FROM_STATE_CHANGE = 15000;
    public static final int PSS_MAX_INTERVAL = 1800000;
    public static final int PSS_ALL_INTERVAL = 600000;
    private static final int PSS_SHORT_INTERVAL = 120000;
    private static final int PSS_FIRST_TOP_INTERVAL = 10000;
    private static final int PSS_FIRST_BACKGROUND_INTERVAL = 20000;
    private static final int PSS_FIRST_CACHED_INTERVAL = 30000;
    private static final int PSS_SAME_IMPORTANT_INTERVAL = 900000;
    private static final int PSS_SAME_SERVICE_INTERVAL = 1200000;
    private static final int PSS_SAME_CACHED_INTERVAL = 1800000;
    public static final int PROC_MEM_PERSISTENT = 0;
    public static final int PROC_MEM_TOP = 1;
    public static final int PROC_MEM_IMPORTANT = 2;
    public static final int PROC_MEM_SERVICE = 3;
    public static final int PROC_MEM_CACHED = 4;
    private static final int[] sProcStateToProcMem;
    private static final long[] sFirstAwakePssTimes;
    private static final long[] sSameAwakePssTimes;

    ProcessList() {
        MemInfoReader minfo = new MemInfoReader();
        minfo.readMemInfo();
        this.mTotalMemMb = minfo.getTotalSize() / 0x100000L;
        this.updateOomLevels(0, 0, false);
    }

    void applyDisplaySize(WindowManagerService wm) {
        if (!this.mHaveDisplaySize) {
            Point p = new Point();
            wm.getBaseDisplaySize(0, p);
            if (p.x != 0 && p.y != 0) {
                this.updateOomLevels(p.x, p.y, true);
                this.mHaveDisplaySize = true;
            }
        }
    }

    private void updateOomLevels(int displayWidth, int displayHeight, boolean write) {
        int i;
        float scale;
        float scaleMem = (float)(this.mTotalMemMb - 300L) / 400.0f;
        int minSize = 384000;
        int maxSize = 1024000;
        float scaleDisp = ((float)(displayWidth * displayHeight) - (float)minSize) / (float)(maxSize - minSize);
        float f = scale = scaleMem > scaleDisp ? scaleMem : scaleDisp;
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 1.0f) {
            scale = 1.0f;
        }
        int minfree_adj = Resources.getSystem().getInteger(17694729);
        int minfree_abs = Resources.getSystem().getInteger(17694728);
        if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
            this.mOomMinFreeHigh[4] = 225000;
            this.mOomMinFreeHigh[5] = 325000;
        }
        for (i = 0; i < this.mOomAdj.length; ++i) {
            int low = this.mOomMinFreeLow[i];
            int high = this.mOomMinFreeHigh[i];
            this.mOomMinFree[i] = (int)((float)low + (float)(high - low) * scale);
        }
        if (minfree_abs >= 0) {
            for (i = 0; i < this.mOomAdj.length; ++i) {
                this.mOomMinFree[i] = (int)((float)minfree_abs * (float)this.mOomMinFree[i] / (float)this.mOomMinFree[this.mOomAdj.length - 1]);
            }
        }
        if (minfree_adj != 0) {
            for (i = 0; i < this.mOomAdj.length; ++i) {
                int n = i;
                this.mOomMinFree[n] = this.mOomMinFree[n] + (int)((float)minfree_adj * (float)this.mOomMinFree[i] / (float)this.mOomMinFree[this.mOomAdj.length - 1]);
                if (this.mOomMinFree[i] >= 0) continue;
                this.mOomMinFree[i] = 0;
            }
        }
        this.mCachedRestoreLevel = this.getMemLevel(15) / 1024L / 3L;
        int reserve = displayWidth * displayHeight * 4 * 3 / 1024;
        int reserve_adj = Resources.getSystem().getInteger(17694731);
        int reserve_abs = Resources.getSystem().getInteger(17694730);
        if (reserve_abs >= 0) {
            reserve = reserve_abs;
        }
        if (reserve_adj != 0 && (reserve += reserve_adj) < 0) {
            reserve = 0;
        }
        if (write) {
            ByteBuffer buf = ByteBuffer.allocate(4 * (2 * this.mOomAdj.length + 1));
            buf.putInt(0);
            for (int i2 = 0; i2 < this.mOomAdj.length; ++i2) {
                buf.putInt(this.mOomMinFree[i2] * 1024 / 4096);
                buf.putInt(this.mOomAdj[i2]);
            }
            ProcessList.writeLmkd(buf);
            SystemProperties.set("sys.sysctl.extra_free_kbytes", Integer.toString(reserve));
        }
    }

    public static int computeEmptyProcessLimit(int totalProcessLimit) {
        return totalProcessLimit / 2;
    }

    private static String buildOomTag(String prefix, String space, int val, int base) {
        if (val == base) {
            if (space == null) {
                return prefix;
            }
            return prefix + "  ";
        }
        return prefix + "+" + Integer.toString(val - base);
    }

    public static String makeOomAdjString(int setAdj) {
        if (setAdj >= 9) {
            return ProcessList.buildOomTag("cch", "  ", setAdj, 9);
        }
        if (setAdj >= 8) {
            return ProcessList.buildOomTag("svcb ", null, setAdj, 8);
        }
        if (setAdj >= 7) {
            return ProcessList.buildOomTag("prev ", null, setAdj, 7);
        }
        if (setAdj >= 6) {
            return ProcessList.buildOomTag("home ", null, setAdj, 6);
        }
        if (setAdj >= 5) {
            return ProcessList.buildOomTag("svc  ", null, setAdj, 5);
        }
        if (setAdj >= 4) {
            return ProcessList.buildOomTag("hvy  ", null, setAdj, 4);
        }
        if (setAdj >= 3) {
            return ProcessList.buildOomTag("bkup ", null, setAdj, 3);
        }
        if (setAdj >= 2) {
            return ProcessList.buildOomTag("prcp ", null, setAdj, 2);
        }
        if (setAdj >= 1) {
            return ProcessList.buildOomTag("vis  ", null, setAdj, 1);
        }
        if (setAdj >= 0) {
            return ProcessList.buildOomTag("fore ", null, setAdj, 0);
        }
        if (setAdj >= -11) {
            return ProcessList.buildOomTag("psvc ", null, setAdj, -11);
        }
        if (setAdj >= -12) {
            return ProcessList.buildOomTag("pers ", null, setAdj, -12);
        }
        if (setAdj >= -16) {
            return ProcessList.buildOomTag("sys  ", null, setAdj, -16);
        }
        if (setAdj >= -17) {
            return ProcessList.buildOomTag("ntv  ", null, setAdj, -17);
        }
        return Integer.toString(setAdj);
    }

    public static String makeProcStateString(int curProcState) {
        String procState;
        switch (curProcState) {
            case -1: {
                procState = "N ";
                break;
            }
            case 0: {
                procState = "P ";
                break;
            }
            case 1: {
                procState = "PU";
                break;
            }
            case 2: {
                procState = "T ";
                break;
            }
            case 3: {
                procState = "IF";
                break;
            }
            case 4: {
                procState = "IB";
                break;
            }
            case 5: {
                procState = "BU";
                break;
            }
            case 6: {
                procState = "HW";
                break;
            }
            case 7: {
                procState = "S ";
                break;
            }
            case 8: {
                procState = "R ";
                break;
            }
            case 9: {
                procState = "HO";
                break;
            }
            case 10: {
                procState = "LA";
                break;
            }
            case 11: {
                procState = "CA";
                break;
            }
            case 12: {
                procState = "Ca";
                break;
            }
            case 13: {
                procState = "CE";
                break;
            }
            default: {
                procState = "??";
            }
        }
        return procState;
    }

    public static void appendRamKb(StringBuilder sb, long ramKb) {
        int j = 0;
        int fact = 10;
        while (j < 6) {
            if (ramKb < (long)fact) {
                sb.append(' ');
            }
            ++j;
            fact *= 10;
        }
        sb.append(ramKb);
    }

    public static boolean procStatesDifferForMem(int procState1, int procState2) {
        return sProcStateToProcMem[procState1] != sProcStateToProcMem[procState2];
    }

    public static long computeNextPssTime(int procState, boolean first, boolean sleeping, long now) {
        long[] table = sleeping ? (first ? sFirstAwakePssTimes : sSameAwakePssTimes) : (first ? sFirstAwakePssTimes : sSameAwakePssTimes);
        return now + table[procState];
    }

    long getMemLevel(int adjustment) {
        for (int i = 0; i < this.mOomAdj.length; ++i) {
            if (adjustment > this.mOomAdj[i]) continue;
            return this.mOomMinFree[i] * 1024;
        }
        return this.mOomMinFree[this.mOomAdj.length - 1] * 1024;
    }

    long getCachedRestoreThresholdKb() {
        return this.mCachedRestoreLevel;
    }

    public static final void setOomAdj(int pid, int uid, int amt) {
        if (amt == 16) {
            return;
        }
        long start = SystemClock.elapsedRealtime();
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.putInt(1);
        buf.putInt(pid);
        buf.putInt(uid);
        buf.putInt(amt);
        ProcessList.writeLmkd(buf);
        long now = SystemClock.elapsedRealtime();
        if (now - start > 250L) {
            Slog.w("ActivityManager", "SLOW OOM ADJ: " + (now - start) + "ms for pid " + pid + " = " + amt);
        }
    }

    public static final void remove(int pid) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(2);
        buf.putInt(pid);
        ProcessList.writeLmkd(buf);
    }

    private static boolean openLmkdSocket() {
        try {
            sLmkdSocket = new LocalSocket(3);
            sLmkdSocket.connect(new LocalSocketAddress("lmkd", LocalSocketAddress.Namespace.RESERVED));
            sLmkdOutputStream = sLmkdSocket.getOutputStream();
        }
        catch (IOException ex) {
            Slog.w("ActivityManager", "lowmemorykiller daemon socket open failed");
            sLmkdSocket = null;
            return false;
        }
        return true;
    }

    private static void writeLmkd(ByteBuffer buf) {
        for (int i = 0; i < 3; ++i) {
            if (sLmkdSocket == null && !ProcessList.openLmkdSocket()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                sLmkdOutputStream.write(buf.array(), 0, buf.position());
                return;
            }
            catch (IOException ex) {
                Slog.w("ActivityManager", "Error writing to lowmemorykiller socket");
                try {
                    sLmkdSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                sLmkdSocket = null;
            }
        }
    }

    static {
        sProcStateToProcMem = new int[]{0, 0, 1, 2, 2, 2, 2, 3, 4, 4, 4, 4, 4, 4};
        sFirstAwakePssTimes = new long[]{120000L, 120000L, 10000L, 20000L, 20000L, 20000L, 20000L, 20000L, 30000L, 30000L, 30000L, 30000L, 30000L, 30000L};
        sSameAwakePssTimes = new long[]{900000L, 900000L, 120000L, 900000L, 900000L, 900000L, 900000L, 1200000L, 1200000L, 1800000L, 1800000L, 1800000L, 1800000L, 1800000L};
    }
}

