/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.Dialog;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IUiAutomationConnection;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.app.ProcessStats;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.am.ActivityRecord;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.ProcessStatsService;
import com.android.server.am.ReceiverList;
import com.android.server.am.ServiceRecord;
import java.io.PrintWriter;
import java.util.ArrayList;

final class ProcessRecord {
    private final BatteryStatsImpl mBatteryStats;
    final ApplicationInfo info;
    final boolean isolated;
    final int uid;
    final int userId;
    final String processName;
    final ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList = new ArrayMap();
    ArraySet<String> pkgDeps;
    IApplicationThread thread;
    ProcessStats.ProcessState baseProcessTracker;
    BatteryStatsImpl.Uid.Proc curProcBatteryStats;
    int pid;
    boolean starting;
    long lastActivityTime;
    long lastPssTime;
    long nextPssTime;
    long lastStateTime;
    long initialIdlePss;
    long lastPss;
    long lastCachedPss;
    int maxAdj;
    int curRawAdj;
    int setRawAdj;
    int curAdj;
    int setAdj;
    int curSchedGroup;
    int setSchedGroup;
    int trimMemoryLevel;
    int curProcState = -1;
    int repProcState = -1;
    int setProcState = -1;
    int pssProcState = -1;
    boolean serviceb;
    boolean serviceHighRam;
    boolean setIsForeground;
    boolean notCachedSinceIdle;
    boolean hasClientActivities;
    boolean hasStartedServices;
    boolean foregroundServices;
    boolean foregroundActivities;
    boolean repForegroundActivities;
    boolean systemNoUi;
    boolean hasShownUi;
    boolean pendingUiClean;
    boolean hasAboveClient;
    boolean treatLikeActivity;
    boolean bad;
    boolean killedByAm;
    boolean killed;
    boolean procStateChanged;
    String waitingToKill;
    IBinder forcingToForeground;
    int adjSeq;
    int lruSeq;
    CompatibilityInfo compat;
    IBinder.DeathRecipient deathRecipient;
    ComponentName instrumentationClass;
    ApplicationInfo instrumentationInfo;
    String instrumentationProfileFile;
    IInstrumentationWatcher instrumentationWatcher;
    IUiAutomationConnection instrumentationUiAutomationConnection;
    Bundle instrumentationArguments;
    ComponentName instrumentationResultClass;
    boolean usingWrapper;
    BroadcastRecord curReceiver;
    long lastWakeTime;
    long lastCpuTime;
    long curCpuTime;
    long lastRequestedGc;
    long lastLowMemory;
    boolean reportLowMemory;
    boolean empty;
    boolean cached;
    String adjType;
    int adjTypeCode;
    Object adjSource;
    int adjSourceProcState;
    Object adjTarget;
    Runnable crashHandler;
    final ArrayList<ActivityRecord> activities = new ArrayList();
    final ArraySet<ServiceRecord> services = new ArraySet();
    final ArraySet<ServiceRecord> executingServices = new ArraySet();
    final ArraySet<ConnectionRecord> connections = new ArraySet();
    final ArraySet<ReceiverList> receivers = new ArraySet();
    final ArrayMap<String, ContentProviderRecord> pubProviders = new ArrayMap();
    final ArrayList<ContentProviderConnection> conProviders = new ArrayList();
    boolean execServicesFg;
    boolean persistent;
    boolean crashing;
    Dialog crashDialog;
    boolean forceCrashReport;
    boolean notResponding;
    Dialog anrDialog;
    boolean removed;
    boolean debugging;
    boolean waitedForDebugger;
    Dialog waitDialog;
    String shortStringName;
    String stringName;
    ActivityManager.ProcessErrorStateInfo crashingReport;
    ActivityManager.ProcessErrorStateInfo notRespondingReport;
    ComponentName errorReportReceiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintWriter pw, String prefix) {
        int i;
        long now = SystemClock.uptimeMillis();
        pw.print(prefix);
        pw.print("user #");
        pw.print(this.userId);
        pw.print(" uid=");
        pw.print(this.info.uid);
        if (this.uid != this.info.uid) {
            pw.print(" ISOLATED uid=");
            pw.print(this.uid);
        }
        pw.println();
        if (this.info.className != null) {
            pw.print(prefix);
            pw.print("class=");
            pw.println(this.info.className);
        }
        if (this.info.manageSpaceActivityName != null) {
            pw.print(prefix);
            pw.print("manageSpaceActivityName=");
            pw.println(this.info.manageSpaceActivityName);
        }
        pw.print(prefix);
        pw.print("dir=");
        pw.print(this.info.sourceDir);
        pw.print(" publicDir=");
        pw.print(this.info.publicSourceDir);
        pw.print(" data=");
        pw.println(this.info.dataDir);
        pw.print(prefix);
        pw.print("packageList={");
        for (i = 0; i < this.pkgList.size(); ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.pkgList.keyAt(i));
        }
        pw.println("}");
        if (this.pkgDeps != null) {
            pw.print(prefix);
            pw.print("packageDependencies={");
            for (i = 0; i < this.pkgDeps.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.pkgDeps.valueAt(i));
            }
            pw.println("}");
        }
        pw.print(prefix);
        pw.print("compat=");
        pw.println(this.compat);
        if (this.instrumentationClass != null || this.instrumentationProfileFile != null || this.instrumentationArguments != null) {
            pw.print(prefix);
            pw.print("instrumentationClass=");
            pw.print(this.instrumentationClass);
            pw.print(" instrumentationProfileFile=");
            pw.println(this.instrumentationProfileFile);
            pw.print(prefix);
            pw.print("instrumentationArguments=");
            pw.println(this.instrumentationArguments);
            pw.print(prefix);
            pw.print("instrumentationInfo=");
            pw.println(this.instrumentationInfo);
            if (this.instrumentationInfo != null) {
                this.instrumentationInfo.dump(new PrintWriterPrinter(pw), prefix + "  ");
            }
        }
        pw.print(prefix);
        pw.print("thread=");
        pw.println(this.thread);
        pw.print(prefix);
        pw.print("pid=");
        pw.print(this.pid);
        pw.print(" starting=");
        pw.println(this.starting);
        pw.print(prefix);
        pw.print("lastActivityTime=");
        TimeUtils.formatDuration(this.lastActivityTime, now, pw);
        pw.print(" lastPssTime=");
        TimeUtils.formatDuration(this.lastPssTime, now, pw);
        pw.print(" nextPssTime=");
        TimeUtils.formatDuration(this.nextPssTime, now, pw);
        pw.println();
        pw.print(prefix);
        pw.print("adjSeq=");
        pw.print(this.adjSeq);
        pw.print(" lruSeq=");
        pw.print(this.lruSeq);
        pw.print(" lastPss=");
        pw.print(this.lastPss);
        pw.print(" lastCachedPss=");
        pw.println(this.lastCachedPss);
        pw.print(prefix);
        pw.print("cached=");
        pw.print(this.cached);
        pw.print(" empty=");
        pw.println(this.empty);
        if (this.serviceb) {
            pw.print(prefix);
            pw.print("serviceb=");
            pw.print(this.serviceb);
            pw.print(" serviceHighRam=");
            pw.println(this.serviceHighRam);
        }
        if (this.notCachedSinceIdle) {
            pw.print(prefix);
            pw.print("notCachedSinceIdle=");
            pw.print(this.notCachedSinceIdle);
            pw.print(" initialIdlePss=");
            pw.println(this.initialIdlePss);
        }
        pw.print(prefix);
        pw.print("oom: max=");
        pw.print(this.maxAdj);
        pw.print(" curRaw=");
        pw.print(this.curRawAdj);
        pw.print(" setRaw=");
        pw.print(this.setRawAdj);
        pw.print(" cur=");
        pw.print(this.curAdj);
        pw.print(" set=");
        pw.println(this.setAdj);
        pw.print(prefix);
        pw.print("curSchedGroup=");
        pw.print(this.curSchedGroup);
        pw.print(" setSchedGroup=");
        pw.print(this.setSchedGroup);
        pw.print(" systemNoUi=");
        pw.print(this.systemNoUi);
        pw.print(" trimMemoryLevel=");
        pw.println(this.trimMemoryLevel);
        pw.print(prefix);
        pw.print("curProcState=");
        pw.print(this.curProcState);
        pw.print(" repProcState=");
        pw.print(this.repProcState);
        pw.print(" pssProcState=");
        pw.print(this.pssProcState);
        pw.print(" setProcState=");
        pw.print(this.setProcState);
        pw.print(" lastStateTime=");
        TimeUtils.formatDuration(this.lastStateTime, now, pw);
        pw.println();
        if (this.hasShownUi || this.pendingUiClean || this.hasAboveClient || this.treatLikeActivity) {
            pw.print(prefix);
            pw.print("hasShownUi=");
            pw.print(this.hasShownUi);
            pw.print(" pendingUiClean=");
            pw.print(this.pendingUiClean);
            pw.print(" hasAboveClient=");
            pw.print(this.hasAboveClient);
            pw.print(" treatLikeActivity=");
            pw.println(this.treatLikeActivity);
        }
        if (this.setIsForeground || this.foregroundServices || this.forcingToForeground != null) {
            pw.print(prefix);
            pw.print("setIsForeground=");
            pw.print(this.setIsForeground);
            pw.print(" foregroundServices=");
            pw.print(this.foregroundServices);
            pw.print(" forcingToForeground=");
            pw.println(this.forcingToForeground);
        }
        if (this.persistent || this.removed) {
            pw.print(prefix);
            pw.print("persistent=");
            pw.print(this.persistent);
            pw.print(" removed=");
            pw.println(this.removed);
        }
        if (this.hasClientActivities || this.foregroundActivities || this.repForegroundActivities) {
            pw.print(prefix);
            pw.print("hasClientActivities=");
            pw.print(this.hasClientActivities);
            pw.print(" foregroundActivities=");
            pw.print(this.foregroundActivities);
            pw.print(" (rep=");
            pw.print(this.repForegroundActivities);
            pw.println(")");
        }
        if (this.hasStartedServices) {
            pw.print(prefix);
            pw.print("hasStartedServices=");
            pw.println(this.hasStartedServices);
        }
        if (this.setProcState >= 7) {
            long wtime;
            BatteryStatsImpl batteryStatsImpl = this.mBatteryStats;
            synchronized (batteryStatsImpl) {
                wtime = this.mBatteryStats.getProcessWakeTime(this.info.uid, this.pid, SystemClock.elapsedRealtime());
            }
            pw.print(prefix);
            pw.print("lastWakeTime=");
            pw.print(this.lastWakeTime);
            pw.print(" timeUsed=");
            TimeUtils.formatDuration(wtime - this.lastWakeTime, pw);
            pw.println("");
            pw.print(prefix);
            pw.print("lastCpuTime=");
            pw.print(this.lastCpuTime);
            pw.print(" timeUsed=");
            TimeUtils.formatDuration(this.curCpuTime - this.lastCpuTime, pw);
            pw.println("");
        }
        pw.print(prefix);
        pw.print("lastRequestedGc=");
        TimeUtils.formatDuration(this.lastRequestedGc, now, pw);
        pw.print(" lastLowMemory=");
        TimeUtils.formatDuration(this.lastLowMemory, now, pw);
        pw.print(" reportLowMemory=");
        pw.println(this.reportLowMemory);
        if (this.killed || this.killedByAm || this.waitingToKill != null) {
            pw.print(prefix);
            pw.print("killed=");
            pw.print(this.killed);
            pw.print(" killedByAm=");
            pw.print(this.killedByAm);
            pw.print(" waitingToKill=");
            pw.println(this.waitingToKill);
        }
        if (this.debugging || this.crashing || this.crashDialog != null || this.notResponding || this.anrDialog != null || this.bad) {
            pw.print(prefix);
            pw.print("debugging=");
            pw.print(this.debugging);
            pw.print(" crashing=");
            pw.print(this.crashing);
            pw.print(" ");
            pw.print(this.crashDialog);
            pw.print(" notResponding=");
            pw.print(this.notResponding);
            pw.print(" ");
            pw.print(this.anrDialog);
            pw.print(" bad=");
            pw.print(this.bad);
            if (this.errorReportReceiver != null) {
                pw.print(" errorReportReceiver=");
                pw.print(this.errorReportReceiver.flattenToShortString());
            }
            pw.println();
        }
        if (this.activities.size() > 0) {
            pw.print(prefix);
            pw.println("Activities:");
            for (int i2 = 0; i2 < this.activities.size(); ++i2) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.activities.get(i2));
            }
        }
        if (this.services.size() > 0) {
            pw.print(prefix);
            pw.println("Services:");
            for (int i3 = 0; i3 < this.services.size(); ++i3) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.services.valueAt(i3));
            }
        }
        if (this.executingServices.size() > 0) {
            pw.print(prefix);
            pw.print("Executing Services (fg=");
            pw.print(this.execServicesFg);
            pw.println(")");
            for (int i4 = 0; i4 < this.executingServices.size(); ++i4) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.executingServices.valueAt(i4));
            }
        }
        if (this.connections.size() > 0) {
            pw.print(prefix);
            pw.println("Connections:");
            for (int i5 = 0; i5 < this.connections.size(); ++i5) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.connections.valueAt(i5));
            }
        }
        if (this.pubProviders.size() > 0) {
            pw.print(prefix);
            pw.println("Published Providers:");
            for (int i6 = 0; i6 < this.pubProviders.size(); ++i6) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.pubProviders.keyAt(i6));
                pw.print(prefix);
                pw.print("    -> ");
                pw.println(this.pubProviders.valueAt(i6));
            }
        }
        if (this.conProviders.size() > 0) {
            pw.print(prefix);
            pw.println("Connected Providers:");
            for (int i7 = 0; i7 < this.conProviders.size(); ++i7) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.conProviders.get(i7).toShortString());
            }
        }
        if (this.curReceiver != null) {
            pw.print(prefix);
            pw.print("curReceiver=");
            pw.println(this.curReceiver);
        }
        if (this.receivers.size() > 0) {
            pw.print(prefix);
            pw.println("Receivers:");
            for (int i8 = 0; i8 < this.receivers.size(); ++i8) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.receivers.valueAt(i8));
            }
        }
    }

    ProcessRecord(BatteryStatsImpl _batteryStats, ApplicationInfo _info, String _processName, int _uid) {
        this.mBatteryStats = _batteryStats;
        this.info = _info;
        this.isolated = _info.uid != _uid;
        this.uid = _uid;
        this.userId = UserHandle.getUserId(_uid);
        this.processName = _processName;
        this.pkgList.put(_info.packageName, new ProcessStats.ProcessStateHolder(_info.versionCode));
        this.maxAdj = 16;
        this.setRawAdj = -100;
        this.curRawAdj = -100;
        this.setAdj = -100;
        this.curAdj = -100;
        this.persistent = false;
        this.removed = false;
        this.lastPssTime = this.nextPssTime = SystemClock.uptimeMillis();
        this.lastStateTime = this.nextPssTime;
    }

    public void setPid(int _pid) {
        this.pid = _pid;
        this.shortStringName = null;
        this.stringName = null;
    }

    public void makeActive(IApplicationThread _thread, ProcessStatsService tracker) {
        if (this.thread == null) {
            ProcessStats.ProcessState origBase = this.baseProcessTracker;
            if (origBase != null) {
                origBase.setState(-1, tracker.getMemFactorLocked(), SystemClock.uptimeMillis(), this.pkgList);
                origBase.makeInactive();
            }
            this.baseProcessTracker = tracker.getProcessStateLocked(this.info.packageName, this.info.uid, this.info.versionCode, this.processName);
            this.baseProcessTracker.makeActive();
            for (int i = 0; i < this.pkgList.size(); ++i) {
                ProcessStats.ProcessStateHolder holder = this.pkgList.valueAt(i);
                if (holder.state != null && holder.state != origBase) {
                    holder.state.makeInactive();
                }
                holder.state = tracker.getProcessStateLocked(this.pkgList.keyAt(i), this.info.uid, this.info.versionCode, this.processName);
                if (holder.state == this.baseProcessTracker) continue;
                holder.state.makeActive();
            }
        }
        this.thread = _thread;
    }

    public void makeInactive(ProcessStatsService tracker) {
        this.thread = null;
        ProcessStats.ProcessState origBase = this.baseProcessTracker;
        if (origBase != null) {
            if (origBase != null) {
                origBase.setState(-1, tracker.getMemFactorLocked(), SystemClock.uptimeMillis(), this.pkgList);
                origBase.makeInactive();
            }
            this.baseProcessTracker = null;
            for (int i = 0; i < this.pkgList.size(); ++i) {
                ProcessStats.ProcessStateHolder holder = this.pkgList.valueAt(i);
                if (holder.state != null && holder.state != origBase) {
                    holder.state.makeInactive();
                }
                holder.state = null;
            }
        }
    }

    public boolean isInterestingToUserLocked() {
        int size = this.activities.size();
        for (int i = 0; i < size; ++i) {
            ActivityRecord r = this.activities.get(i);
            if (!r.isInterestingToUserLocked()) continue;
            return true;
        }
        return false;
    }

    public void stopFreezingAllLocked() {
        int i = this.activities.size();
        while (i > 0) {
            this.activities.get(--i).stopFreezingScreenLocked(true);
        }
    }

    public void unlinkDeathRecipient() {
        if (this.deathRecipient != null && this.thread != null) {
            this.thread.asBinder().unlinkToDeath(this.deathRecipient, 0);
        }
        this.deathRecipient = null;
    }

    void updateHasAboveClientLocked() {
        this.hasAboveClient = false;
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            ConnectionRecord cr = this.connections.valueAt(i);
            if ((cr.flags & 8) == 0) continue;
            this.hasAboveClient = true;
            break;
        }
    }

    int modifyRawOomAdj(int adj) {
        if (this.hasAboveClient && adj >= 0) {
            if (adj < 1) {
                adj = 1;
            } else if (adj < 2) {
                adj = 2;
            } else if (adj < 9) {
                adj = 9;
            } else if (adj < 15) {
                ++adj;
            }
        }
        return adj;
    }

    void kill(String reason, boolean noisy) {
        if (!this.killedByAm) {
            if (noisy) {
                Slog.i("ActivityManager", "Killing " + this.toShortString() + " (adj " + this.setAdj + "): " + reason);
            }
            EventLog.writeEvent(30023, this.userId, this.pid, this.processName, this.setAdj, reason);
            Process.killProcessQuiet(this.pid);
            Process.killProcessGroup(this.info.uid, this.pid);
            if (!this.persistent) {
                this.killed = true;
                this.killedByAm = true;
            }
        }
    }

    public String toShortString() {
        if (this.shortStringName != null) {
            return this.shortStringName;
        }
        StringBuilder sb = new StringBuilder(128);
        this.toShortString(sb);
        this.shortStringName = sb.toString();
        return this.shortStringName;
    }

    void toShortString(StringBuilder sb) {
        sb.append(this.pid);
        sb.append(':');
        sb.append(this.processName);
        sb.append('/');
        if (this.info.uid < 10000) {
            sb.append(this.uid);
        } else {
            sb.append('u');
            sb.append(this.userId);
            int appId = UserHandle.getAppId(this.info.uid);
            if (appId >= 10000) {
                sb.append('a');
                sb.append(appId - 10000);
            } else {
                sb.append('s');
                sb.append(appId);
            }
            if (this.uid != this.info.uid) {
                sb.append('i');
                sb.append(UserHandle.getAppId(this.uid) - 99000);
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ProcessRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        this.toShortString(sb);
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public String makeAdjReason() {
        if (this.adjSource != null || this.adjTarget != null) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(' ');
            if (this.adjTarget instanceof ComponentName) {
                sb.append(((ComponentName)this.adjTarget).flattenToShortString());
            } else if (this.adjTarget != null) {
                sb.append(this.adjTarget.toString());
            } else {
                sb.append("{null}");
            }
            sb.append("<=");
            if (this.adjSource instanceof ProcessRecord) {
                sb.append("Proc{");
                sb.append(((ProcessRecord)this.adjSource).toShortString());
                sb.append("}");
            } else if (this.adjSource != null) {
                sb.append(this.adjSource.toString());
            } else {
                sb.append("{null}");
            }
            return sb.toString();
        }
        return null;
    }

    public boolean addPackage(String pkg, int versionCode, ProcessStatsService tracker) {
        if (!this.pkgList.containsKey(pkg)) {
            ProcessStats.ProcessStateHolder holder = new ProcessStats.ProcessStateHolder(versionCode);
            if (this.baseProcessTracker != null) {
                holder.state = tracker.getProcessStateLocked(pkg, this.info.uid, versionCode, this.processName);
                this.pkgList.put(pkg, holder);
                if (holder.state != this.baseProcessTracker) {
                    holder.state.makeActive();
                }
            } else {
                this.pkgList.put(pkg, holder);
            }
            return true;
        }
        return false;
    }

    public int getSetAdjWithServices() {
        if (this.setAdj >= 9 && this.hasStartedServices) {
            return 8;
        }
        return this.setAdj;
    }

    public void forceProcessStateUpTo(int newState) {
        if (this.repProcState > newState) {
            this.curProcState = this.repProcState = newState;
        }
    }

    public void resetPackageList(ProcessStatsService tracker) {
        int N = this.pkgList.size();
        if (this.baseProcessTracker != null) {
            long now = SystemClock.uptimeMillis();
            this.baseProcessTracker.setState(-1, tracker.getMemFactorLocked(), now, this.pkgList);
            if (N != 1) {
                ProcessStats.ProcessStateHolder holder;
                for (int i = 0; i < N; ++i) {
                    holder = this.pkgList.valueAt(i);
                    if (holder.state == null || holder.state == this.baseProcessTracker) continue;
                    holder.state.makeInactive();
                }
                this.pkgList.clear();
                ProcessStats.ProcessState ps = tracker.getProcessStateLocked(this.info.packageName, this.info.uid, this.info.versionCode, this.processName);
                holder = new ProcessStats.ProcessStateHolder(this.info.versionCode);
                holder.state = ps;
                this.pkgList.put(this.info.packageName, holder);
                if (ps != this.baseProcessTracker) {
                    ps.makeActive();
                }
            }
        } else if (N != 1) {
            this.pkgList.clear();
            this.pkgList.put(this.info.packageName, new ProcessStats.ProcessStateHolder(this.info.versionCode));
        }
    }

    public String[] getPackageList() {
        int size = this.pkgList.size();
        if (size == 0) {
            return null;
        }
        String[] list = new String[size];
        for (int i = 0; i < this.pkgList.size(); ++i) {
            list[i] = this.pkgList.keyAt(i);
        }
        return list;
    }
}

