/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.SystemClock;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.TaskRecord;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TaskPersister {
    static final String TAG = "TaskPersister";
    static final boolean DEBUG = false;
    private static final long INTER_WRITE_DELAY_MS = 500L;
    private static final long PRE_TASK_DELAY_MS = 3000L;
    private static final int MAX_WRITE_QUEUE_LENGTH = 6;
    private static final long FLUSH_QUEUE = -1L;
    private static final String RECENTS_FILENAME = "_task";
    private static final String TASKS_DIRNAME = "recent_tasks";
    private static final String TASK_EXTENSION = ".xml";
    private static final String IMAGES_DIRNAME = "recent_images";
    static final String IMAGE_EXTENSION = ".png";
    private static final String TAG_TASK = "task";
    static File sImagesDir;
    static File sTasksDir;
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private long mNextWriteTime = 0L;
    private final LazyTaskWriterThread mLazyTaskWriterThread;
    ArrayList<WriteQueueItem> mWriteQueue = new ArrayList();

    TaskPersister(File systemDir, ActivityStackSupervisor stackSupervisor) {
        sTasksDir = new File(systemDir, TASKS_DIRNAME);
        if (!sTasksDir.exists() && !sTasksDir.mkdir()) {
            Slog.e(TAG, "Failure creating tasks directory " + sTasksDir);
        }
        if (!(sImagesDir = new File(systemDir, IMAGES_DIRNAME)).exists() && !sImagesDir.mkdir()) {
            Slog.e(TAG, "Failure creating images directory " + sImagesDir);
        }
        this.mStackSupervisor = stackSupervisor;
        this.mService = stackSupervisor.mService;
        this.mLazyTaskWriterThread = new LazyTaskWriterThread("LazyTaskWriterThread");
    }

    void startPersisting() {
        this.mLazyTaskWriterThread.start();
    }

    private void removeThumbnails(TaskRecord task) {
        String taskString = Integer.toString(task.taskId);
        for (int queueNdx = this.mWriteQueue.size() - 1; queueNdx >= 0; --queueNdx) {
            WriteQueueItem item = this.mWriteQueue.get(queueNdx);
            if (!(item instanceof ImageWriteQueueItem) || !((ImageWriteQueueItem)item).mFilename.startsWith(taskString)) continue;
            this.mWriteQueue.remove(queueNdx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void yieldIfQueueTooDeep() {
        boolean stall = false;
        TaskPersister taskPersister = this;
        synchronized (taskPersister) {
            if (this.mNextWriteTime == -1L) {
                stall = true;
            }
        }
        if (stall) {
            Thread.yield();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeup(TaskRecord task, boolean flush) {
        TaskPersister taskPersister = this;
        synchronized (taskPersister) {
            if (task != null) {
                int queueNdx;
                for (queueNdx = this.mWriteQueue.size() - 1; queueNdx >= 0; --queueNdx) {
                    WriteQueueItem item = this.mWriteQueue.get(queueNdx);
                    if (!(item instanceof TaskWriteQueueItem) || ((TaskWriteQueueItem)item).mTask != task) continue;
                    if (task.inRecents) break;
                    this.removeThumbnails(task);
                    break;
                }
                if (queueNdx < 0) {
                    this.mWriteQueue.add(new TaskWriteQueueItem(task));
                }
            } else {
                this.mWriteQueue.add(new WriteQueueItem());
            }
            if (flush || this.mWriteQueue.size() > 6) {
                this.mNextWriteTime = -1L;
            } else if (this.mNextWriteTime == 0L) {
                this.mNextWriteTime = SystemClock.uptimeMillis() + 3000L;
            }
            this.notifyAll();
        }
        this.yieldIfQueueTooDeep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        TaskPersister taskPersister = this;
        synchronized (taskPersister) {
            this.mNextWriteTime = -1L;
            this.notifyAll();
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (this.mNextWriteTime == -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveImage(Bitmap image, String filename) {
        TaskPersister taskPersister = this;
        synchronized (taskPersister) {
            int queueNdx;
            for (queueNdx = this.mWriteQueue.size() - 1; queueNdx >= 0; --queueNdx) {
                WriteQueueItem item = this.mWriteQueue.get(queueNdx);
                if (!(item instanceof ImageWriteQueueItem)) continue;
                ImageWriteQueueItem imageWriteQueueItem = (ImageWriteQueueItem)item;
                if (!imageWriteQueueItem.mFilename.equals(filename)) continue;
                imageWriteQueueItem.mImage = image;
                break;
            }
            if (queueNdx < 0) {
                this.mWriteQueue.add(new ImageWriteQueueItem(filename, image));
            }
            if (this.mWriteQueue.size() > 6) {
                this.mNextWriteTime = -1L;
            } else if (this.mNextWriteTime == 0L) {
                this.mNextWriteTime = SystemClock.uptimeMillis() + 3000L;
            }
            this.notifyAll();
        }
        this.yieldIfQueueTooDeep();
    }

    Bitmap getTaskDescriptionIcon(String filename) {
        Bitmap icon = this.getImageFromWriteQueue(filename);
        if (icon != null) {
            return icon;
        }
        return TaskPersister.restoreImage(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap getImageFromWriteQueue(String filename) {
        TaskPersister taskPersister = this;
        synchronized (taskPersister) {
            for (int queueNdx = this.mWriteQueue.size() - 1; queueNdx >= 0; --queueNdx) {
                WriteQueueItem item = this.mWriteQueue.get(queueNdx);
                if (!(item instanceof ImageWriteQueueItem)) continue;
                ImageWriteQueueItem imageWriteQueueItem = (ImageWriteQueueItem)item;
                if (!imageWriteQueueItem.mFilename.equals(filename)) continue;
                return imageWriteQueueItem.mImage;
            }
            return null;
        }
    }

    private StringWriter saveToXml(TaskRecord task) throws IOException, XmlPullParserException {
        FastXmlSerializer xmlSerializer = new FastXmlSerializer();
        StringWriter stringWriter = new StringWriter();
        xmlSerializer.setOutput(stringWriter);
        xmlSerializer.startDocument(null, true);
        xmlSerializer.startTag(null, TAG_TASK);
        task.saveToXml(xmlSerializer);
        xmlSerializer.endTag(null, TAG_TASK);
        xmlSerializer.endDocument();
        xmlSerializer.flush();
        return stringWriter;
    }

    private String fileToString(File file) {
        String newline = System.lineSeparator();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer sb = new StringBuffer((int)file.length() * 2);
            while ((line = reader.readLine()) != null) {
                sb.append(line + newline);
            }
            reader.close();
            return sb.toString();
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Couldn't read file " + file.getName());
            return null;
        }
    }

    private TaskRecord taskIdToTask(int taskId, ArrayList<TaskRecord> tasks) {
        if (taskId < 0) {
            return null;
        }
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            if (task.taskId != taskId) continue;
            return task;
        }
        Slog.e(TAG, "Restore affiliation error looking for taskId=" + taskId);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<TaskRecord> restoreTasksLocked() {
        int taskNdx;
        ArrayList<TaskRecord> tasks = new ArrayList<TaskRecord>();
        ArraySet<Integer> recoveredTaskIds = new ArraySet<Integer>();
        File[] recentFiles = sTasksDir.listFiles();
        if (recentFiles == null) {
            Slog.e(TAG, "Unable to list files from " + sTasksDir);
            return tasks;
        }
        for (taskNdx = 0; taskNdx < recentFiles.length; ++taskNdx) {
            File taskFile = recentFiles[taskNdx];
            BufferedReader reader = null;
            boolean deleteFile = false;
            try {
                int event;
                reader = new BufferedReader(new FileReader(taskFile));
                XmlPullParser in = Xml.newPullParser();
                in.setInput(reader);
                while ((event = in.next()) != 1 && event != 3) {
                    String name = in.getName();
                    if (event == 2) {
                        if (TAG_TASK.equals(name)) {
                            TaskRecord task = TaskRecord.restoreFromXml(in, this.mStackSupervisor);
                            if (task != null) {
                                task.isPersistable = true;
                                tasks.add(task);
                                int taskId = task.taskId;
                                recoveredTaskIds.add(taskId);
                                this.mStackSupervisor.setNextTaskId(taskId);
                            } else {
                                Slog.e(TAG, "Unable to restore taskFile=" + taskFile + ": " + this.fileToString(taskFile));
                            }
                        } else {
                            Slog.wtf(TAG, "restoreTasksLocked Unknown xml event=" + event + " name=" + name);
                        }
                    }
                    XmlUtils.skipCurrentTag(in);
                }
                continue;
            }
            catch (Exception e) {
                Slog.wtf(TAG, "Unable to parse " + taskFile + ". Error ", e);
                Slog.e(TAG, "Failing file: " + this.fileToString(taskFile));
                deleteFile = true;
                continue;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (deleteFile) {
                    Slog.d(TAG, "Deleting file=" + taskFile.getName());
                    taskFile.delete();
                }
            }
        }
        this.removeObsoleteFiles(recoveredTaskIds);
        for (taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            task.setPrevAffiliate(this.taskIdToTask(task.mPrevAffiliateTaskId, tasks));
            task.setNextAffiliate(this.taskIdToTask(task.mNextAffiliateTaskId, tasks));
        }
        TaskRecord[] tasksArray = new TaskRecord[tasks.size()];
        tasks.toArray(tasksArray);
        Arrays.sort(tasksArray, new Comparator<TaskRecord>(){

            @Override
            public int compare(TaskRecord lhs, TaskRecord rhs) {
                long diff = rhs.mLastTimeMoved - lhs.mLastTimeMoved;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        });
        return new ArrayList<TaskRecord>(Arrays.asList(tasksArray));
    }

    private static void removeObsoleteFiles(ArraySet<Integer> persistentTaskIds, File[] files) {
        if (files == null) {
            Slog.e(TAG, "File error accessing recents directory (too many files open?).");
            return;
        }
        for (int fileNdx = 0; fileNdx < files.length; ++fileNdx) {
            int taskId;
            File file = files[fileNdx];
            String filename = file.getName();
            int taskIdEnd = filename.indexOf(95);
            if (taskIdEnd <= 0) continue;
            try {
                taskId = Integer.valueOf(filename.substring(0, taskIdEnd));
            }
            catch (Exception e) {
                Slog.wtf(TAG, "removeObsoleteFile: Can't parse file=" + file.getName());
                file.delete();
                continue;
            }
            if (persistentTaskIds.contains(taskId)) continue;
            Slog.d(TAG, "removeObsoleteFile: deleting file=" + file.getName());
            file.delete();
        }
    }

    private void removeObsoleteFiles(ArraySet<Integer> persistentTaskIds) {
        TaskPersister.removeObsoleteFiles(persistentTaskIds, sTasksDir.listFiles());
        TaskPersister.removeObsoleteFiles(persistentTaskIds, sImagesDir.listFiles());
    }

    static Bitmap restoreImage(String filename) {
        return BitmapFactory.decodeFile(sImagesDir + File.separator + filename);
    }

    static /* synthetic */ ActivityManagerService access$100(TaskPersister x0) {
        return x0.mService;
    }

    static /* synthetic */ void access$200(TaskPersister x0, ArraySet x1) {
        x0.removeObsoleteFiles(x1);
    }

    static /* synthetic */ long access$300(TaskPersister x0) {
        return x0.mNextWriteTime;
    }

    static /* synthetic */ long access$302(TaskPersister x0, long x1) {
        x0.mNextWriteTime = x1;
        return x0.mNextWriteTime;
    }

    static /* synthetic */ StringWriter access$400(TaskPersister x0, TaskRecord x1) throws IOException, XmlPullParserException {
        return x0.saveToXml(x1);
    }

    private class LazyTaskWriterThread
    extends Thread {
        LazyTaskWriterThread(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            persistentTaskIds = new ArraySet<Integer>();
            while (true) lbl-1000:
            // 10 sources

            {
                var3_3 = TaskPersister.this;
                synchronized (var3_3) {
                    probablyDone = TaskPersister.this.mWriteQueue.isEmpty();
                }
                if (probablyDone) {
                    persistentTaskIds.clear();
                    var3_3 = TaskPersister.access$100(TaskPersister.this);
                    synchronized (var3_3) {
                        tasks = TaskPersister.access$100((TaskPersister)TaskPersister.this).mRecentTasks;
                        for (taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                            task = (TaskRecord)tasks.get(taskNdx);
                            if (!task.isPersistable || task.stack.isHomeStack()) continue;
                            persistentTaskIds.add(task.taskId);
                        }
                    }
                    TaskPersister.access$200(TaskPersister.this, persistentTaskIds);
                }
                tasks = TaskPersister.this;
                synchronized (tasks) {
                    if (TaskPersister.access$300(TaskPersister.this) != -1L) {
                        TaskPersister.access$302(TaskPersister.this, SystemClock.uptimeMillis() + 500L);
                    }
                    while (TaskPersister.this.mWriteQueue.isEmpty()) {
                        if (TaskPersister.access$300(TaskPersister.this) != 0L) {
                            TaskPersister.access$302(TaskPersister.this, 0L);
                            TaskPersister.this.notifyAll();
                        }
                        try {
                            TaskPersister.this.wait();
                        }
                        catch (InterruptedException taskNdx) {}
                    }
                    item = TaskPersister.this.mWriteQueue.remove(0);
                    now = SystemClock.uptimeMillis();
                    while (now < TaskPersister.access$300(TaskPersister.this)) {
                        try {
                            TaskPersister.this.wait(TaskPersister.access$300(TaskPersister.this) - now);
                        }
                        catch (InterruptedException var7_14) {
                            // empty catch block
                        }
                        now = SystemClock.uptimeMillis();
                    }
                }
                if (item instanceof ImageWriteQueueItem) {
                    imageWriteQueueItem = (ImageWriteQueueItem)item;
                    filename = imageWriteQueueItem.mFilename;
                    bitmap = imageWriteQueueItem.mImage;
                    imageFile = null;
                    try {
                        imageFile = new FileOutputStream(new File(TaskPersister.sImagesDir, filename));
                        bitmap.compress(Bitmap.CompressFormat.PNG, 100, imageFile);
                    }
                    catch (Exception e) {
                        Slog.e("TaskPersister", "saveImage: unable to save " + filename, e);
                    }
                    finally {
                        if (imageFile == null) ** GOTO lbl-1000
                        try {
                            imageFile.close();
                        }
                        catch (IOException e) {}
                    }
                    continue;
                }
                if (!(item instanceof TaskWriteQueueItem)) continue;
                stringWriter = null;
                task = ((TaskWriteQueueItem)item).mTask;
                bitmap = TaskPersister.access$100(TaskPersister.this);
                synchronized (bitmap) {
                    if (task.inRecents) {
                        try {
                            stringWriter = TaskPersister.access$400(TaskPersister.this, task);
                        }
                        catch (IOException imageFile) {
                        }
                        catch (XmlPullParserException imageFile) {
                            // empty catch block
                        }
                    }
                }
                if (stringWriter == null) continue;
                file = null;
                atomicFile = null;
                try {
                    atomicFile = new AtomicFile(new File(TaskPersister.sTasksDir, String.valueOf(task.taskId) + "_task" + ".xml"));
                    file = atomicFile.startWrite();
                    file.write(stringWriter.toString().getBytes());
                    file.write(10);
                    atomicFile.finishWrite(file);
                    continue;
                }
                catch (IOException e) {
                    if (file != null) {
                        atomicFile.failWrite(file);
                    }
                    Slog.e("TaskPersister", "Unable to open " + atomicFile + " for persisting. " + e);
                    continue;
                }
                break;
            }
        }
    }

    private static class ImageWriteQueueItem
    extends WriteQueueItem {
        final String mFilename;
        Bitmap mImage;

        ImageWriteQueueItem(String filename, Bitmap image) {
            this.mFilename = filename;
            this.mImage = image;
        }
    }

    private static class TaskWriteQueueItem
    extends WriteQueueItem {
        final TaskRecord mTask;

        TaskWriteQueueItem(TaskRecord task) {
            this.mTask = task;
        }
    }

    private static class WriteQueueItem {
        private WriteQueueItem() {
        }
    }
}

