/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import android.service.voice.IVoiceInteractionSession;
import android.util.Slog;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.util.XmlUtils;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.TaskPersister;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class TaskRecord {
    private static final String ATTR_TASKID = "task_id";
    private static final String TAG_INTENT = "intent";
    private static final String TAG_AFFINITYINTENT = "affinity_intent";
    private static final String ATTR_REALACTIVITY = "real_activity";
    private static final String ATTR_ORIGACTIVITY = "orig_activity";
    private static final String TAG_ACTIVITY = "activity";
    private static final String ATTR_AFFINITY = "affinity";
    private static final String ATTR_ROOT_AFFINITY = "root_affinity";
    private static final String ATTR_ROOTHASRESET = "root_has_reset";
    private static final String ATTR_AUTOREMOVERECENTS = "auto_remove_recents";
    private static final String ATTR_ASKEDCOMPATMODE = "asked_compat_mode";
    private static final String ATTR_USERID = "user_id";
    private static final String ATTR_EFFECTIVE_UID = "effective_uid";
    private static final String ATTR_TASKTYPE = "task_type";
    private static final String ATTR_FIRSTACTIVETIME = "first_active_time";
    private static final String ATTR_LASTACTIVETIME = "last_active_time";
    private static final String ATTR_LASTDESCRIPTION = "last_description";
    private static final String ATTR_LASTTIMEMOVED = "last_time_moved";
    private static final String ATTR_NEVERRELINQUISH = "never_relinquish_identity";
    private static final String ATTR_TASK_AFFILIATION = "task_affiliation";
    private static final String ATTR_PREV_AFFILIATION = "prev_affiliation";
    private static final String ATTR_NEXT_AFFILIATION = "next_affiliation";
    private static final String ATTR_TASK_AFFILIATION_COLOR = "task_affiliation_color";
    private static final String ATTR_CALLING_UID = "calling_uid";
    private static final String ATTR_CALLING_PACKAGE = "calling_package";
    private static final String TASK_THUMBNAIL_SUFFIX = "_task_thumbnail";
    static final boolean IGNORE_RETURN_TO_RECENTS = true;
    final int taskId;
    String affinity;
    String rootAffinity;
    final IVoiceInteractionSession voiceSession;
    final IVoiceInteractor voiceInteractor;
    Intent intent;
    Intent affinityIntent;
    int effectiveUid;
    ComponentName origActivity;
    ComponentName realActivity;
    long firstActiveTime;
    long lastActiveTime;
    boolean inRecents;
    boolean isAvailable;
    boolean rootWasReset;
    boolean autoRemoveRecents;
    boolean askedCompatMode;
    boolean hasBeenVisible;
    String stringName;
    int userId;
    int creatorUid;
    int numFullscreen;
    ActivityManager.TaskDescription lastTaskDescription = new ActivityManager.TaskDescription();
    final ArrayList<ActivityRecord> mActivities;
    ActivityStack stack;
    int taskType;
    boolean isPersistable = false;
    int maxRecents;
    long mLastTimeMoved = System.currentTimeMillis();
    private int mTaskToReturnTo = 0;
    boolean mNeverRelinquishIdentity = true;
    boolean mReuseTask = false;
    private Bitmap mLastThumbnail;
    private final File mLastThumbnailFile;
    private final String mFilename;
    CharSequence lastDescription;
    int mAffiliatedTaskId;
    int mAffiliatedTaskColor;
    TaskRecord mPrevAffiliate;
    int mPrevAffiliateTaskId = -1;
    TaskRecord mNextAffiliate;
    int mNextAffiliateTaskId = -1;
    int mCallingUid;
    String mCallingPackage;
    final ActivityManagerService mService;

    TaskRecord(ActivityManagerService service, int _taskId, ActivityInfo info, Intent _intent, IVoiceInteractionSession _voiceSession, IVoiceInteractor _voiceInteractor) {
        this.mService = service;
        this.mFilename = String.valueOf(_taskId) + TASK_THUMBNAIL_SUFFIX + ".png";
        this.mLastThumbnailFile = new File(TaskPersister.sImagesDir, this.mFilename);
        this.taskId = _taskId;
        this.mAffiliatedTaskId = _taskId;
        this.voiceSession = _voiceSession;
        this.voiceInteractor = _voiceInteractor;
        this.isAvailable = true;
        this.mActivities = new ArrayList();
        this.setIntent(_intent, info);
    }

    TaskRecord(ActivityManagerService service, int _taskId, ActivityInfo info, Intent _intent, ActivityManager.TaskDescription _taskDescription) {
        this.mService = service;
        this.mFilename = String.valueOf(_taskId) + TASK_THUMBNAIL_SUFFIX + ".png";
        this.mLastThumbnailFile = new File(TaskPersister.sImagesDir, this.mFilename);
        this.taskId = _taskId;
        this.mAffiliatedTaskId = _taskId;
        this.voiceSession = null;
        this.voiceInteractor = null;
        this.isAvailable = true;
        this.mActivities = new ArrayList();
        this.setIntent(_intent, info);
        this.taskType = 0;
        this.isPersistable = true;
        this.mCallingUid = info.applicationInfo.uid;
        this.mCallingPackage = info.packageName;
        this.maxRecents = Math.min(Math.max(info.maxRecents, 1), ActivityManager.getMaxAppRecentsLimitStatic());
        this.taskType = 0;
        this.mTaskToReturnTo = 1;
        this.userId = UserHandle.getUserId(info.applicationInfo.uid);
        this.lastTaskDescription = _taskDescription;
        this.mCallingUid = info.applicationInfo.uid;
        this.mCallingPackage = info.packageName;
    }

    TaskRecord(ActivityManagerService service, int _taskId, Intent _intent, Intent _affinityIntent, String _affinity, String _rootAffinity, ComponentName _realActivity, ComponentName _origActivity, boolean _rootWasReset, boolean _autoRemoveRecents, boolean _askedCompatMode, int _taskType, int _userId, int _effectiveUid, String _lastDescription, ArrayList<ActivityRecord> activities, long _firstActiveTime, long _lastActiveTime, long lastTimeMoved, boolean neverRelinquishIdentity, ActivityManager.TaskDescription _lastTaskDescription, int taskAffiliation, int prevTaskId, int nextTaskId, int taskAffiliationColor, int callingUid, String callingPackage) {
        this.mService = service;
        this.mFilename = String.valueOf(_taskId) + TASK_THUMBNAIL_SUFFIX + ".png";
        this.mLastThumbnailFile = new File(TaskPersister.sImagesDir, this.mFilename);
        this.taskId = _taskId;
        this.intent = _intent;
        this.affinityIntent = _affinityIntent;
        this.affinity = _affinity;
        this.rootAffinity = _affinity;
        this.voiceSession = null;
        this.voiceInteractor = null;
        this.realActivity = _realActivity;
        this.origActivity = _origActivity;
        this.rootWasReset = _rootWasReset;
        this.isAvailable = true;
        this.autoRemoveRecents = _autoRemoveRecents;
        this.askedCompatMode = _askedCompatMode;
        this.taskType = _taskType;
        this.mTaskToReturnTo = 1;
        this.userId = _userId;
        this.effectiveUid = _effectiveUid;
        this.firstActiveTime = _firstActiveTime;
        this.lastActiveTime = _lastActiveTime;
        this.lastDescription = _lastDescription;
        this.mActivities = activities;
        this.mLastTimeMoved = lastTimeMoved;
        this.mNeverRelinquishIdentity = neverRelinquishIdentity;
        this.lastTaskDescription = _lastTaskDescription;
        this.mAffiliatedTaskId = taskAffiliation;
        this.mAffiliatedTaskColor = taskAffiliationColor;
        this.mPrevAffiliateTaskId = prevTaskId;
        this.mNextAffiliateTaskId = nextTaskId;
        this.mCallingUid = callingUid;
        this.mCallingPackage = callingPackage;
    }

    void touchActiveTime() {
        this.lastActiveTime = System.currentTimeMillis();
        if (this.firstActiveTime == 0L) {
            this.firstActiveTime = this.lastActiveTime;
        }
    }

    long getInactiveDuration() {
        return System.currentTimeMillis() - this.lastActiveTime;
    }

    void setIntent(ActivityRecord r) {
        this.setIntent(r.intent, r.info);
        this.mCallingUid = r.launchedFromUid;
        this.mCallingPackage = r.launchedFromPackage;
    }

    private void setIntent(Intent _intent, ActivityInfo info) {
        int intentFlags;
        if (this.intent == null) {
            this.mNeverRelinquishIdentity = (info.flags & 0x1000) == 0;
        } else if (this.mNeverRelinquishIdentity) {
            return;
        }
        this.affinity = info.taskAffinity;
        if (this.intent == null) {
            this.rootAffinity = this.affinity;
        }
        this.effectiveUid = info.applicationInfo.uid;
        this.stringName = null;
        if (info.targetActivity == null) {
            if (_intent != null && (_intent.getSelector() != null || _intent.getSourceBounds() != null)) {
                _intent = new Intent(_intent);
                _intent.setSelector(null);
                _intent.setSourceBounds(null);
            }
            this.intent = _intent;
            this.realActivity = _intent != null ? _intent.getComponent() : null;
            this.origActivity = null;
        } else {
            ComponentName targetComponent = new ComponentName(info.packageName, info.targetActivity);
            if (_intent != null) {
                Intent targetIntent = new Intent(_intent);
                targetIntent.setComponent(targetComponent);
                targetIntent.setSelector(null);
                targetIntent.setSourceBounds(null);
                this.intent = targetIntent;
                this.realActivity = targetComponent;
                this.origActivity = _intent.getComponent();
            } else {
                this.intent = null;
                this.realActivity = targetComponent;
                this.origActivity = new ComponentName(info.packageName, info.name);
            }
        }
        int n = intentFlags = this.intent == null ? 0 : this.intent.getFlags();
        if ((intentFlags & 0x200000) != 0) {
            this.rootWasReset = true;
        }
        this.userId = UserHandle.getUserId(info.applicationInfo.uid);
        this.autoRemoveRecents = (info.flags & 0x2000) != 0 ? true : ((intentFlags & 0x82000) == 524288 ? info.documentLaunchMode == 0 : false);
    }

    void setTaskToReturnTo(int taskToReturnTo) {
        if (taskToReturnTo == 2) {
            taskToReturnTo = 1;
        }
        this.mTaskToReturnTo = taskToReturnTo;
    }

    int getTaskToReturnTo() {
        return this.mTaskToReturnTo;
    }

    void setPrevAffiliate(TaskRecord prevAffiliate) {
        this.mPrevAffiliate = prevAffiliate;
        this.mPrevAffiliateTaskId = prevAffiliate == null ? -1 : prevAffiliate.taskId;
    }

    void setNextAffiliate(TaskRecord nextAffiliate) {
        this.mNextAffiliate = nextAffiliate;
        this.mNextAffiliateTaskId = nextAffiliate == null ? -1 : nextAffiliate.taskId;
    }

    void closeRecentsChain() {
        if (this.mPrevAffiliate != null) {
            this.mPrevAffiliate.setNextAffiliate(this.mNextAffiliate);
        }
        if (this.mNextAffiliate != null) {
            this.mNextAffiliate.setPrevAffiliate(this.mPrevAffiliate);
        }
        this.setPrevAffiliate(null);
        this.setNextAffiliate(null);
    }

    void removedFromRecents(TaskPersister persister) {
        this.disposeThumbnail();
        this.closeRecentsChain();
        if (this.inRecents) {
            this.inRecents = false;
            persister.wakeup(this, false);
        }
    }

    void setTaskToAffiliateWith(TaskRecord taskToAffiliateWith) {
        this.closeRecentsChain();
        this.mAffiliatedTaskId = taskToAffiliateWith.mAffiliatedTaskId;
        this.mAffiliatedTaskColor = taskToAffiliateWith.mAffiliatedTaskColor;
        while (taskToAffiliateWith.mNextAffiliate != null) {
            TaskRecord nextRecents = taskToAffiliateWith.mNextAffiliate;
            if (nextRecents.mAffiliatedTaskId != this.mAffiliatedTaskId) {
                Slog.e("ActivityManager", "setTaskToAffiliateWith: nextRecents=" + nextRecents + " affilTaskId=" + nextRecents.mAffiliatedTaskId + " should be " + this.mAffiliatedTaskId);
                if (nextRecents.mPrevAffiliate == taskToAffiliateWith) {
                    nextRecents.setPrevAffiliate(null);
                }
                taskToAffiliateWith.setNextAffiliate(null);
                break;
            }
            taskToAffiliateWith = nextRecents;
        }
        taskToAffiliateWith.setNextAffiliate(this);
        this.setPrevAffiliate(taskToAffiliateWith);
        this.setNextAffiliate(null);
    }

    boolean setLastThumbnail(Bitmap thumbnail) {
        if (this.mLastThumbnail != thumbnail) {
            this.mLastThumbnail = thumbnail;
            if (thumbnail == null) {
                if (this.mLastThumbnailFile != null) {
                    this.mLastThumbnailFile.delete();
                }
            } else {
                this.mService.mTaskPersister.saveImage(thumbnail, this.mFilename);
            }
            return true;
        }
        return false;
    }

    void getLastThumbnail(ActivityManager.TaskThumbnail thumbs) {
        thumbs.mainThumbnail = this.mLastThumbnail;
        thumbs.thumbnailFileDescriptor = null;
        if (this.mLastThumbnail == null) {
            thumbs.mainThumbnail = this.mService.mTaskPersister.getImageFromWriteQueue(this.mFilename);
        }
        if (thumbs.mainThumbnail == null && this.mLastThumbnailFile.exists()) {
            try {
                thumbs.thumbnailFileDescriptor = ParcelFileDescriptor.open(this.mLastThumbnailFile, 0x10000000);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void freeLastThumbnail() {
        this.mLastThumbnail = null;
    }

    void disposeThumbnail() {
        this.mLastThumbnail = null;
        this.lastDescription = null;
    }

    Intent getBaseIntent() {
        return this.intent != null ? this.intent : this.affinityIntent;
    }

    ActivityRecord getRootActivity() {
        for (int i = 0; i < this.mActivities.size(); ++i) {
            ActivityRecord r = this.mActivities.get(i);
            if (r.finishing) continue;
            return r;
        }
        return null;
    }

    ActivityRecord getTopActivity() {
        for (int i = this.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord r = this.mActivities.get(i);
            if (r.finishing) continue;
            return r;
        }
        return null;
    }

    ActivityRecord topRunningActivityLocked(ActivityRecord notTop) {
        for (int activityNdx = this.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (r.finishing || r == notTop || !this.stack.okToShowLocked(r)) continue;
            return r;
        }
        return null;
    }

    final void setFrontOfTask() {
        boolean foundFront = false;
        int numActivities = this.mActivities.size();
        for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (foundFront || r.finishing) {
                r.frontOfTask = false;
                continue;
            }
            r.frontOfTask = true;
            foundFront = true;
        }
        if (!foundFront && numActivities > 0) {
            this.mActivities.get((int)0).frontOfTask = true;
        }
    }

    final void moveActivityToFrontLocked(ActivityRecord newTop) {
        this.mActivities.remove(newTop);
        this.mActivities.add(newTop);
        this.updateEffectiveIntent();
        this.setFrontOfTask();
    }

    void addActivityAtBottom(ActivityRecord r) {
        this.addActivityAtIndex(0, r);
    }

    void addActivityToTop(ActivityRecord r) {
        this.addActivityAtIndex(this.mActivities.size(), r);
    }

    void addActivityAtIndex(int index, ActivityRecord r) {
        if (!this.mActivities.remove(r) && r.fullscreen) {
            ++this.numFullscreen;
        }
        if (this.mActivities.isEmpty()) {
            this.taskType = r.mActivityType;
            this.isPersistable = r.isPersistable();
            this.mCallingUid = r.launchedFromUid;
            this.mCallingPackage = r.launchedFromPackage;
            this.maxRecents = Math.min(Math.max(r.info.maxRecents, 1), ActivityManager.getMaxAppRecentsLimitStatic());
        } else {
            r.mActivityType = this.taskType;
        }
        this.mActivities.add(index, r);
        this.updateEffectiveIntent();
        if (r.isPersistable()) {
            this.mService.notifyTaskPersisterLocked(this, false);
        }
    }

    boolean removeActivity(ActivityRecord r) {
        if (this.mActivities.remove(r) && r.fullscreen) {
            --this.numFullscreen;
        }
        if (r.isPersistable()) {
            this.mService.notifyTaskPersisterLocked(this, false);
        }
        if (this.mActivities.isEmpty()) {
            return !this.mReuseTask;
        }
        this.updateEffectiveIntent();
        return false;
    }

    boolean autoRemoveFromRecents() {
        return this.autoRemoveRecents || this.mActivities.isEmpty() && !this.hasBeenVisible;
    }

    final void performClearTaskAtIndexLocked(int activityNdx) {
        int numActivities = this.mActivities.size();
        while (activityNdx < numActivities) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (!r.finishing) {
                if (this.stack == null) {
                    r.takeFromHistory();
                    this.mActivities.remove(activityNdx);
                    --activityNdx;
                    --numActivities;
                } else if (this.stack.finishActivityLocked(r, 0, null, "clear", false)) {
                    --activityNdx;
                    --numActivities;
                }
            }
            ++activityNdx;
        }
    }

    final void performClearTaskLocked() {
        this.mReuseTask = true;
        this.performClearTaskAtIndexLocked(0);
        this.mReuseTask = false;
    }

    final ActivityRecord performClearTaskLocked(ActivityRecord newR, int launchFlags) {
        int numActivities = this.mActivities.size();
        for (int activityNdx = numActivities - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (r.finishing || !r.realActivity.equals(newR.realActivity)) continue;
            ActivityRecord ret = r;
            ++activityNdx;
            while (activityNdx < numActivities) {
                r = this.mActivities.get(activityNdx);
                if (!r.finishing) {
                    ActivityOptions opts = r.takeOptionsLocked();
                    if (opts != null) {
                        ret.updateOptionsLocked(opts);
                    }
                    if (this.stack.finishActivityLocked(r, 0, null, "clear", false)) {
                        --activityNdx;
                        --numActivities;
                    }
                }
                ++activityNdx;
            }
            if (ret.launchMode == 0 && (launchFlags & 0x20000000) == 0 && !ret.finishing) {
                this.stack.finishActivityLocked(ret, 0, null, "clear", false);
                return null;
            }
            return ret;
        }
        return null;
    }

    public ActivityManager.TaskThumbnail getTaskThumbnailLocked() {
        ActivityRecord resumedActivity;
        if (this.stack != null && (resumedActivity = this.stack.mResumedActivity) != null && resumedActivity.task == this) {
            Bitmap thumbnail = this.stack.screenshotActivities(resumedActivity);
            this.setLastThumbnail(thumbnail);
        }
        ActivityManager.TaskThumbnail taskThumbnail = new ActivityManager.TaskThumbnail();
        this.getLastThumbnail(taskThumbnail);
        return taskThumbnail;
    }

    public void removeTaskActivitiesLocked() {
        this.performClearTaskAtIndexLocked(0);
    }

    boolean isHomeTask() {
        return this.taskType == 1;
    }

    boolean isApplicationTask() {
        return this.taskType == 0;
    }

    boolean isOverHomeStack() {
        return this.mTaskToReturnTo == 1 || this.mTaskToReturnTo == 2;
    }

    final ActivityRecord findActivityInHistoryLocked(ActivityRecord r) {
        ComponentName realActivity = r.realActivity;
        for (int activityNdx = this.mActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord candidate = this.mActivities.get(activityNdx);
            if (candidate.finishing || !candidate.realActivity.equals(realActivity)) continue;
            return candidate;
        }
        return null;
    }

    void updateTaskDescription() {
        int activityNdx;
        int numActivities = this.mActivities.size();
        boolean relinquish = numActivities == 0 ? false : (this.mActivities.get((int)0).info.flags & 0x1000) != 0;
        for (activityNdx = Math.min(numActivities, 1); activityNdx < numActivities; ++activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (relinquish && (r.info.flags & 0x1000) == 0) {
                ++activityNdx;
                break;
            }
            if (r.intent != null && (r.intent.getFlags() & 0x80000) != 0) break;
        }
        if (activityNdx > 0) {
            String label = null;
            String iconFilename = null;
            int colorPrimary = 0;
            --activityNdx;
            while (activityNdx >= 0) {
                ActivityRecord r = this.mActivities.get(activityNdx);
                if (r.taskDescription != null) {
                    if (label == null) {
                        label = r.taskDescription.getLabel();
                    }
                    if (iconFilename == null) {
                        iconFilename = r.taskDescription.getIconFilename();
                    }
                    if (colorPrimary == 0) {
                        colorPrimary = r.taskDescription.getPrimaryColor();
                    }
                }
                --activityNdx;
            }
            this.lastTaskDescription = new ActivityManager.TaskDescription(label, colorPrimary, iconFilename);
            if (this.taskId == this.mAffiliatedTaskId) {
                this.mAffiliatedTaskColor = this.lastTaskDescription.getPrimaryColor();
            }
        }
    }

    int findEffectiveRootIndex() {
        int effectiveNdx = 0;
        int topActivityNdx = this.mActivities.size() - 1;
        for (int activityNdx = 0; activityNdx <= topActivityNdx; ++activityNdx) {
            ActivityRecord r = this.mActivities.get(activityNdx);
            if (r.finishing) continue;
            effectiveNdx = activityNdx;
            if ((r.info.flags & 0x1000) == 0) break;
        }
        return effectiveNdx;
    }

    void updateEffectiveIntent() {
        int effectiveRootIndex = this.findEffectiveRootIndex();
        ActivityRecord r = this.mActivities.get(effectiveRootIndex);
        this.setIntent(r);
    }

    void saveToXml(XmlSerializer out) throws IOException, XmlPullParserException {
        out.attribute(null, ATTR_TASKID, String.valueOf(this.taskId));
        if (this.realActivity != null) {
            out.attribute(null, ATTR_REALACTIVITY, this.realActivity.flattenToShortString());
        }
        if (this.origActivity != null) {
            out.attribute(null, ATTR_ORIGACTIVITY, this.origActivity.flattenToShortString());
        }
        if (this.affinity != null) {
            out.attribute(null, ATTR_AFFINITY, this.affinity);
            if (!this.affinity.equals(this.rootAffinity)) {
                out.attribute(null, ATTR_ROOT_AFFINITY, this.rootAffinity != null ? this.rootAffinity : "@");
            }
        } else if (this.rootAffinity != null) {
            out.attribute(null, ATTR_ROOT_AFFINITY, this.rootAffinity != null ? this.rootAffinity : "@");
        }
        out.attribute(null, ATTR_ROOTHASRESET, String.valueOf(this.rootWasReset));
        out.attribute(null, ATTR_AUTOREMOVERECENTS, String.valueOf(this.autoRemoveRecents));
        out.attribute(null, ATTR_ASKEDCOMPATMODE, String.valueOf(this.askedCompatMode));
        out.attribute(null, ATTR_USERID, String.valueOf(this.userId));
        out.attribute(null, ATTR_EFFECTIVE_UID, String.valueOf(this.effectiveUid));
        out.attribute(null, ATTR_TASKTYPE, String.valueOf(this.taskType));
        out.attribute(null, ATTR_FIRSTACTIVETIME, String.valueOf(this.firstActiveTime));
        out.attribute(null, ATTR_LASTACTIVETIME, String.valueOf(this.lastActiveTime));
        out.attribute(null, ATTR_LASTTIMEMOVED, String.valueOf(this.mLastTimeMoved));
        out.attribute(null, ATTR_NEVERRELINQUISH, String.valueOf(this.mNeverRelinquishIdentity));
        if (this.lastDescription != null) {
            out.attribute(null, ATTR_LASTDESCRIPTION, this.lastDescription.toString());
        }
        if (this.lastTaskDescription != null) {
            this.lastTaskDescription.saveToXml(out);
        }
        out.attribute(null, ATTR_TASK_AFFILIATION_COLOR, String.valueOf(this.mAffiliatedTaskColor));
        out.attribute(null, ATTR_TASK_AFFILIATION, String.valueOf(this.mAffiliatedTaskId));
        out.attribute(null, ATTR_PREV_AFFILIATION, String.valueOf(this.mPrevAffiliateTaskId));
        out.attribute(null, ATTR_NEXT_AFFILIATION, String.valueOf(this.mNextAffiliateTaskId));
        out.attribute(null, ATTR_CALLING_UID, String.valueOf(this.mCallingUid));
        out.attribute(null, ATTR_CALLING_PACKAGE, this.mCallingPackage == null ? "" : this.mCallingPackage);
        if (this.affinityIntent != null) {
            out.startTag(null, TAG_AFFINITYINTENT);
            this.affinityIntent.saveToXml(out);
            out.endTag(null, TAG_AFFINITYINTENT);
        }
        out.startTag(null, TAG_INTENT);
        this.intent.saveToXml(out);
        out.endTag(null, TAG_INTENT);
        ArrayList<ActivityRecord> activities = this.mActivities;
        int numActivities = activities.size();
        for (int activityNdx = 0; activityNdx < numActivities; ++activityNdx) {
            ActivityRecord r = activities.get(activityNdx);
            if (r.info.persistableMode == 0 || !r.isPersistable() || (r.intent.getFlags() & 0x80000) != 0 && activityNdx > 0) break;
            out.startTag(null, TAG_ACTIVITY);
            r.saveToXml(out);
            out.endTag(null, TAG_ACTIVITY);
        }
    }

    static TaskRecord restoreFromXml(XmlPullParser in, ActivityStackSupervisor stackSupervisor) throws IOException, XmlPullParserException {
        int event;
        Intent intent = null;
        Intent affinityIntent = null;
        ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>();
        ComponentName realActivity = null;
        ComponentName origActivity = null;
        String affinity = null;
        String rootAffinity = null;
        boolean hasRootAffinity = false;
        boolean rootHasReset = false;
        boolean autoRemoveRecents = false;
        boolean askedCompatMode = false;
        int taskType = 0;
        int userId = 0;
        int effectiveUid = -1;
        String lastDescription = null;
        long firstActiveTime = -1L;
        long lastActiveTime = -1L;
        long lastTimeOnTop = 0L;
        boolean neverRelinquishIdentity = true;
        int taskId = -1;
        int outerDepth = in.getDepth();
        ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription();
        int taskAffiliation = -1;
        int taskAffiliationColor = 0;
        int prevTaskId = -1;
        int nextTaskId = -1;
        int callingUid = -1;
        String callingPackage = "";
        for (int attrNdx = in.getAttributeCount() - 1; attrNdx >= 0; --attrNdx) {
            String attrName = in.getAttributeName(attrNdx);
            String attrValue = in.getAttributeValue(attrNdx);
            if (ATTR_TASKID.equals(attrName)) {
                taskId = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_REALACTIVITY.equals(attrName)) {
                realActivity = ComponentName.unflattenFromString(attrValue);
                continue;
            }
            if (ATTR_ORIGACTIVITY.equals(attrName)) {
                origActivity = ComponentName.unflattenFromString(attrValue);
                continue;
            }
            if (ATTR_AFFINITY.equals(attrName)) {
                affinity = attrValue;
                continue;
            }
            if (ATTR_ROOT_AFFINITY.equals(attrName)) {
                rootAffinity = attrValue;
                hasRootAffinity = true;
                continue;
            }
            if (ATTR_ROOTHASRESET.equals(attrName)) {
                rootHasReset = Boolean.valueOf(attrValue);
                continue;
            }
            if (ATTR_AUTOREMOVERECENTS.equals(attrName)) {
                autoRemoveRecents = Boolean.valueOf(attrValue);
                continue;
            }
            if (ATTR_ASKEDCOMPATMODE.equals(attrName)) {
                askedCompatMode = Boolean.valueOf(attrValue);
                continue;
            }
            if (ATTR_USERID.equals(attrName)) {
                userId = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_EFFECTIVE_UID.equals(attrName)) {
                effectiveUid = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_TASKTYPE.equals(attrName)) {
                taskType = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_FIRSTACTIVETIME.equals(attrName)) {
                firstActiveTime = Long.valueOf(attrValue);
                continue;
            }
            if (ATTR_LASTACTIVETIME.equals(attrName)) {
                lastActiveTime = Long.valueOf(attrValue);
                continue;
            }
            if (ATTR_LASTDESCRIPTION.equals(attrName)) {
                lastDescription = attrValue;
                continue;
            }
            if (ATTR_LASTTIMEMOVED.equals(attrName)) {
                lastTimeOnTop = Long.valueOf(attrValue);
                continue;
            }
            if (ATTR_NEVERRELINQUISH.equals(attrName)) {
                neverRelinquishIdentity = Boolean.valueOf(attrValue);
                continue;
            }
            if (attrName.startsWith("task_description_")) {
                taskDescription.restoreFromXml(attrName, attrValue);
                continue;
            }
            if (ATTR_TASK_AFFILIATION.equals(attrName)) {
                taskAffiliation = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_PREV_AFFILIATION.equals(attrName)) {
                prevTaskId = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_NEXT_AFFILIATION.equals(attrName)) {
                nextTaskId = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_TASK_AFFILIATION_COLOR.equals(attrName)) {
                taskAffiliationColor = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_CALLING_UID.equals(attrName)) {
                callingUid = Integer.valueOf(attrValue);
                continue;
            }
            if (ATTR_CALLING_PACKAGE.equals(attrName)) {
                callingPackage = attrValue;
                continue;
            }
            Slog.w("ActivityManager", "TaskRecord: Unknown attribute=" + attrName);
        }
        while ((event = in.next()) != 1 && (event != 3 || in.getDepth() < outerDepth)) {
            if (event != 2) continue;
            String name = in.getName();
            if (TAG_AFFINITYINTENT.equals(name)) {
                affinityIntent = Intent.restoreFromXml(in);
                continue;
            }
            if (TAG_INTENT.equals(name)) {
                intent = Intent.restoreFromXml(in);
                continue;
            }
            if (TAG_ACTIVITY.equals(name)) {
                ActivityRecord activity = ActivityRecord.restoreFromXml(in, taskId, stackSupervisor);
                if (activity == null) continue;
                activities.add(activity);
                continue;
            }
            Slog.e("ActivityManager", "restoreTask: Unexpected name=" + name);
            XmlUtils.skipCurrentTag(in);
        }
        if (!hasRootAffinity) {
            rootAffinity = affinity;
        } else if ("@".equals(rootAffinity)) {
            rootAffinity = null;
        }
        if (effectiveUid <= 0) {
            Intent checkIntent = intent != null ? intent : affinityIntent;
            effectiveUid = 0;
            if (checkIntent != null) {
                IPackageManager pm = AppGlobals.getPackageManager();
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(checkIntent.getComponent().getPackageName(), 8704, userId);
                    if (ai != null) {
                        effectiveUid = ai.uid;
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            Slog.w("ActivityManager", "Updating task #" + taskId + " for " + checkIntent + ": effectiveUid=" + effectiveUid);
        }
        TaskRecord task = new TaskRecord(stackSupervisor.mService, taskId, intent, affinityIntent, affinity, rootAffinity, realActivity, origActivity, rootHasReset, autoRemoveRecents, askedCompatMode, taskType, userId, effectiveUid, lastDescription, activities, firstActiveTime, lastActiveTime, lastTimeOnTop, neverRelinquishIdentity, taskDescription, taskAffiliation, prevTaskId, nextTaskId, taskAffiliationColor, callingUid, callingPackage);
        for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
            activities.get((int)activityNdx).task = task;
        }
        return task;
    }

    void dump(PrintWriter pw, String prefix) {
        StringBuilder sb;
        pw.print(prefix);
        pw.print("userId=");
        pw.print(this.userId);
        pw.print(" effectiveUid=");
        UserHandle.formatUid(pw, this.effectiveUid);
        pw.print(" mCallingUid=");
        UserHandle.formatUid(pw, this.mCallingUid);
        pw.print(" mCallingPackage=");
        pw.println(this.mCallingPackage);
        if (this.affinity != null || this.rootAffinity != null) {
            pw.print(prefix);
            pw.print("affinity=");
            pw.print(this.affinity);
            if (this.affinity == null || !this.affinity.equals(this.rootAffinity)) {
                pw.print(" root=");
                pw.println(this.rootAffinity);
            } else {
                pw.println();
            }
        }
        if (this.voiceSession != null || this.voiceInteractor != null) {
            pw.print(prefix);
            pw.print("VOICE: session=0x");
            pw.print(Integer.toHexString(System.identityHashCode(this.voiceSession)));
            pw.print(" interactor=0x");
            pw.println(Integer.toHexString(System.identityHashCode(this.voiceInteractor)));
        }
        if (this.intent != null) {
            sb = new StringBuilder(128);
            sb.append(prefix);
            sb.append("intent={");
            this.intent.toShortString(sb, false, true, false, true);
            sb.append('}');
            pw.println(sb.toString());
        }
        if (this.affinityIntent != null) {
            sb = new StringBuilder(128);
            sb.append(prefix);
            sb.append("affinityIntent={");
            this.affinityIntent.toShortString(sb, false, true, false, true);
            sb.append('}');
            pw.println(sb.toString());
        }
        if (this.origActivity != null) {
            pw.print(prefix);
            pw.print("origActivity=");
            pw.println(this.origActivity.flattenToShortString());
        }
        if (this.realActivity != null) {
            pw.print(prefix);
            pw.print("realActivity=");
            pw.println(this.realActivity.flattenToShortString());
        }
        if (this.autoRemoveRecents || this.isPersistable || this.taskType != 0 || this.mTaskToReturnTo != 0 || this.numFullscreen != 0) {
            pw.print(prefix);
            pw.print("autoRemoveRecents=");
            pw.print(this.autoRemoveRecents);
            pw.print(" isPersistable=");
            pw.print(this.isPersistable);
            pw.print(" numFullscreen=");
            pw.print(this.numFullscreen);
            pw.print(" taskType=");
            pw.print(this.taskType);
            pw.print(" mTaskToReturnTo=");
            pw.println(this.mTaskToReturnTo);
        }
        if (this.rootWasReset || this.mNeverRelinquishIdentity || this.mReuseTask) {
            pw.print(prefix);
            pw.print("rootWasReset=");
            pw.print(this.rootWasReset);
            pw.print(" mNeverRelinquishIdentity=");
            pw.print(this.mNeverRelinquishIdentity);
            pw.print(" mReuseTask=");
            pw.println(this.mReuseTask);
        }
        if (this.mAffiliatedTaskId != this.taskId || this.mPrevAffiliateTaskId != -1 || this.mPrevAffiliate != null || this.mNextAffiliateTaskId != -1 || this.mNextAffiliate != null) {
            pw.print(prefix);
            pw.print("affiliation=");
            pw.print(this.mAffiliatedTaskId);
            pw.print(" prevAffiliation=");
            pw.print(this.mPrevAffiliateTaskId);
            pw.print(" (");
            if (this.mPrevAffiliate == null) {
                pw.print("null");
            } else {
                pw.print(Integer.toHexString(System.identityHashCode(this.mPrevAffiliate)));
            }
            pw.print(") nextAffiliation=");
            pw.print(this.mNextAffiliateTaskId);
            pw.print(" (");
            if (this.mNextAffiliate == null) {
                pw.print("null");
            } else {
                pw.print(Integer.toHexString(System.identityHashCode(this.mNextAffiliate)));
            }
            pw.println(")");
        }
        pw.print(prefix);
        pw.print("Activities=");
        pw.println(this.mActivities);
        if (!(this.askedCompatMode && this.inRecents && this.isAvailable)) {
            pw.print(prefix);
            pw.print("askedCompatMode=");
            pw.print(this.askedCompatMode);
            pw.print(" inRecents=");
            pw.print(this.inRecents);
            pw.print(" isAvailable=");
            pw.println(this.isAvailable);
        }
        pw.print(prefix);
        pw.print("lastThumbnail=");
        pw.print(this.mLastThumbnail);
        pw.print(" lastThumbnailFile=");
        pw.println(this.mLastThumbnailFile);
        if (this.lastDescription != null) {
            pw.print(prefix);
            pw.print("lastDescription=");
            pw.println(this.lastDescription);
        }
        pw.print(prefix);
        pw.print("hasBeenVisible=");
        pw.print(this.hasBeenVisible);
        pw.print(" firstActiveTime=");
        pw.print(this.lastActiveTime);
        pw.print(" lastActiveTime=");
        pw.print(this.lastActiveTime);
        pw.print(" (inactive for ");
        pw.print(this.getInactiveDuration() / 1000L);
        pw.println("s)");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        if (this.stringName != null) {
            sb.append(this.stringName);
            sb.append(" U=");
            sb.append(this.userId);
            sb.append(" sz=");
            sb.append(this.mActivities.size());
            sb.append('}');
            return sb.toString();
        }
        sb.append("TaskRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" #");
        sb.append(this.taskId);
        if (this.affinity != null) {
            sb.append(" A=");
            sb.append(this.affinity);
        } else if (this.intent != null) {
            sb.append(" I=");
            sb.append(this.intent.getComponent().flattenToShortString());
        } else if (this.affinityIntent != null) {
            sb.append(" aI=");
            sb.append(this.affinityIntent.getComponent().flattenToShortString());
        } else {
            sb.append(" ??");
        }
        this.stringName = sb.toString();
        return this.toString();
    }
}

