/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IBackupAgent;
import android.app.PendingIntent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.app.backup.FullBackup;
import android.app.backup.IBackupManager;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreDescription;
import android.app.backup.RestoreSet;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageInstallObserver;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.system.ErrnoException;
import android.system.Os;
import android.util.ArrayMap;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.StringBuilderPrinter;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.backup.IObbBackupService;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.SystemService;
import com.android.server.backup.FullBackupJob;
import com.android.server.backup.PackageManagerBackupAgent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import libcore.io.IoUtils;

public class BackupManagerService
extends IBackupManager.Stub {
    private static final String TAG = "BackupManagerService";
    private static final boolean DEBUG = true;
    private static final boolean MORE_DEBUG = false;
    private static final boolean DEBUG_SCHEDULING = true;
    static final String KEY_WIDGET_STATE = "\uffed\uffedwidget";
    static final String PBKDF_CURRENT = "PBKDF2WithHmacSHA1";
    static final String PBKDF_FALLBACK = "PBKDF2WithHmacSHA1And8bit";
    static final String BACKUP_MANIFEST_FILENAME = "_manifest";
    static final int BACKUP_MANIFEST_VERSION = 1;
    static final int BACKUP_FILE_VERSION = 3;
    static final String BACKUP_FILE_HEADER_MAGIC = "ANDROID BACKUP\n";
    static final int BACKUP_PW_FILE_VERSION = 2;
    static final String BACKUP_METADATA_FILENAME = "_meta";
    static final int BACKUP_METADATA_VERSION = 1;
    static final int BACKUP_WIDGET_METADATA_TOKEN = 33549569;
    static final boolean COMPRESS_FULL_BACKUPS = true;
    static final String SETTINGS_PACKAGE = "com.android.providers.settings";
    static final String SHARED_BACKUP_AGENT_PACKAGE = "com.android.sharedstoragebackup";
    static final String SERVICE_ACTION_TRANSPORT_HOST = "android.backup.TRANSPORT_HOST";
    private static final long BACKUP_INTERVAL = 3600000L;
    private static final int FUZZ_MILLIS = 300000;
    private static final long FIRST_BACKUP_INTERVAL = 43200000L;
    private static final long TRANSPORT_RETRY_INTERVAL = 3600000L;
    private static final String RUN_BACKUP_ACTION = "android.app.backup.intent.RUN";
    private static final String RUN_INITIALIZE_ACTION = "android.app.backup.intent.INIT";
    private static final String RUN_CLEAR_ACTION = "android.app.backup.intent.CLEAR";
    private static final int MSG_RUN_BACKUP = 1;
    private static final int MSG_RUN_ADB_BACKUP = 2;
    private static final int MSG_RUN_RESTORE = 3;
    private static final int MSG_RUN_CLEAR = 4;
    private static final int MSG_RUN_INITIALIZE = 5;
    private static final int MSG_RUN_GET_RESTORE_SETS = 6;
    private static final int MSG_TIMEOUT = 7;
    private static final int MSG_RESTORE_TIMEOUT = 8;
    private static final int MSG_FULL_CONFIRMATION_TIMEOUT = 9;
    private static final int MSG_RUN_ADB_RESTORE = 10;
    private static final int MSG_RETRY_INIT = 11;
    private static final int MSG_RETRY_CLEAR = 12;
    private static final int MSG_WIDGET_BROADCAST = 13;
    private static final int MSG_RUN_FULL_TRANSPORT_BACKUP = 14;
    static final int MSG_BACKUP_RESTORE_STEP = 20;
    static final int MSG_OP_COMPLETE = 21;
    static final long TIMEOUT_INTERVAL = 10000L;
    static final long TIMEOUT_BACKUP_INTERVAL = 30000L;
    static final long TIMEOUT_FULL_BACKUP_INTERVAL = 300000L;
    static final long TIMEOUT_SHARED_BACKUP_INTERVAL = 1800000L;
    static final long TIMEOUT_RESTORE_INTERVAL = 60000L;
    static final long TIMEOUT_RESTORE_FINISHED_INTERVAL = 30000L;
    static final long TIMEOUT_FULL_CONFIRMATION = 60000L;
    static final long MIN_FULL_BACKUP_INTERVAL = 86400000L;
    Context mContext;
    private PackageManager mPackageManager;
    IPackageManager mPackageManagerBinder;
    private IActivityManager mActivityManager;
    private PowerManager mPowerManager;
    private AlarmManager mAlarmManager;
    private IMountService mMountService;
    IBackupManager mBackupManagerBinder;
    boolean mEnabled;
    boolean mProvisioned;
    boolean mAutoRestore;
    PowerManager.WakeLock mWakelock;
    HandlerThread mHandlerThread;
    BackupHandler mBackupHandler;
    PendingIntent mRunBackupIntent;
    PendingIntent mRunInitIntent;
    BroadcastReceiver mRunBackupReceiver;
    BroadcastReceiver mRunInitReceiver;
    final SparseArray<HashSet<String>> mBackupParticipants = new SparseArray();
    HashMap<String, BackupRequest> mPendingBackups = new HashMap();
    static final String PACKAGE_MANAGER_SENTINEL = "@pm@";
    final Object mQueueLock = new Object();
    final Object mAgentConnectLock = new Object();
    IBackupAgent mConnectedAgent;
    volatile boolean mBackupRunning;
    volatile boolean mConnecting;
    volatile long mLastBackupPass;
    volatile long mNextBackupPass;
    static final boolean DEBUG_BACKUP_TRACE = true;
    final List<String> mBackupTrace = new ArrayList<String>();
    final Object mClearDataLock = new Object();
    volatile boolean mClearingData;
    final Intent mTransportServiceIntent = new Intent("android.backup.TRANSPORT_HOST");
    final ArrayMap<String, String> mTransportNames = new ArrayMap();
    final ArrayMap<String, IBackupTransport> mTransports = new ArrayMap();
    final ArrayMap<String, TransportConnection> mTransportConnections = new ArrayMap();
    String mCurrentTransport;
    ActiveRestoreSession mActiveRestoreSession;
    ContentObserver mProvisionedObserver;
    static BackupManagerService sInstance;
    static final int OP_PENDING = 0;
    static final int OP_ACKNOWLEDGED = 1;
    static final int OP_TIMEOUT = -1;
    final SparseArray<Operation> mCurrentOperations = new SparseArray();
    final Object mCurrentOpLock = new Object();
    final Random mTokenGenerator = new Random();
    final SparseArray<FullParams> mFullConfirmations = new SparseArray();
    File mBaseStateDir;
    File mDataDir;
    File mJournalDir;
    File mJournal;
    private final SecureRandom mRng = new SecureRandom();
    private String mPasswordHash;
    private File mPasswordHashFile;
    private int mPasswordVersion;
    private File mPasswordVersionFile;
    private byte[] mPasswordSalt;
    static final int PBKDF2_HASH_ROUNDS = 10000;
    static final int PBKDF2_KEY_SIZE = 256;
    static final int PBKDF2_SALT_SIZE = 512;
    static final String ENCRYPTION_ALGORITHM_NAME = "AES-256";
    private File mEverStored;
    HashSet<String> mEverStoredApps = new HashSet();
    static final int CURRENT_ANCESTRAL_RECORD_VERSION = 1;
    File mTokenFile;
    Set<String> mAncestralPackages = null;
    long mAncestralToken = 0L;
    long mCurrentToken = 0L;
    static final String INIT_SENTINEL_FILE_NAME = "_need_init_";
    HashSet<String> mPendingInits = new HashSet();
    static final int SCHEDULE_FILE_VERSION = 1;
    File mFullBackupScheduleFile;
    PerformFullTransportBackupTask mRunningFullBackupTask;
    ArrayList<FullBackupEntry> mFullBackupQueue;
    Runnable mFullBackupScheduleWriter = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                try {
                    ByteArrayOutputStream bufStream = new ByteArrayOutputStream(4096);
                    DataOutputStream bufOut = new DataOutputStream(bufStream);
                    bufOut.writeInt(1);
                    int N = BackupManagerService.this.mFullBackupQueue.size();
                    bufOut.writeInt(N);
                    for (int i = 0; i < N; ++i) {
                        FullBackupEntry entry = BackupManagerService.this.mFullBackupQueue.get(i);
                        bufOut.writeUTF(entry.packageName);
                        bufOut.writeLong(entry.lastBackup);
                    }
                    bufOut.flush();
                    AtomicFile af = new AtomicFile(BackupManagerService.this.mFullBackupScheduleFile);
                    FileOutputStream out = af.startWrite();
                    out.write(bufStream.toByteArray());
                    af.finishWrite(out);
                }
                catch (Exception e) {
                    Slog.e(BackupManagerService.TAG, "Unable to write backup schedule!", e);
                }
            }
        }
    };
    BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object pkgName;
            Slog.d(BackupManagerService.TAG, "Received broadcast " + intent);
            String action = intent.getAction();
            boolean replacing = false;
            boolean added = false;
            boolean changed = false;
            Bundle extras = intent.getExtras();
            String[] pkgList = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                Uri uri = intent.getData();
                if (uri == null) {
                    return;
                }
                pkgName = uri.getSchemeSpecificPart();
                if (pkgName != null) {
                    pkgList = new String[]{pkgName};
                }
                if (changed = "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                    try {
                        ArrayMap<String, IBackupTransport> arrayMap = BackupManagerService.this.mTransports;
                        synchronized (arrayMap) {
                            TransportConnection conn = BackupManagerService.this.mTransportConnections.get(pkgName);
                            if (conn != null) {
                                ServiceInfo svc = conn.mTransport;
                                ComponentName svcName = new ComponentName(svc.packageName, svc.name);
                                String flatName = svcName.flattenToShortString();
                                Slog.i(BackupManagerService.TAG, "Unbinding " + svcName);
                                BackupManagerService.this.mContext.unbindService(conn);
                                BackupManagerService.this.mTransportConnections.remove(pkgName);
                                BackupManagerService.this.mTransports.remove(BackupManagerService.this.mTransportNames.get(flatName));
                                BackupManagerService.this.mTransportNames.remove(flatName);
                            }
                        }
                        PackageInfo app = BackupManagerService.this.mPackageManager.getPackageInfo((String)pkgName, 0);
                        BackupManagerService.this.checkForTransportAndBind(app);
                    }
                    catch (PackageManager.NameNotFoundException app) {
                        // empty catch block
                    }
                    return;
                }
                added = "android.intent.action.PACKAGE_ADDED".equals(action);
                replacing = extras.getBoolean("android.intent.extra.REPLACING", false);
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
                added = true;
                pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                added = false;
                pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (pkgList == null || pkgList.length == 0) {
                return;
            }
            int uid = extras.getInt("android.intent.extra.UID");
            if (added) {
                pkgName = BackupManagerService.this.mBackupParticipants;
                synchronized (pkgName) {
                    if (replacing) {
                        BackupManagerService.this.removePackageParticipantsLocked(pkgList, uid);
                    }
                    BackupManagerService.this.addPackageParticipantsLocked(pkgList);
                }
                for (String packageName : pkgList) {
                    try {
                        PackageInfo app = BackupManagerService.this.mPackageManager.getPackageInfo(packageName, 0);
                        long now = System.currentTimeMillis();
                        if (BackupManagerService.appGetsFullBackup(app)) {
                            BackupManagerService.this.enqueueFullBackup(packageName, now);
                            BackupManagerService.this.scheduleNextFullBackupJob();
                        }
                        ArrayMap<String, IBackupTransport> arrayMap = BackupManagerService.this.mTransports;
                        synchronized (arrayMap) {
                            TransportConnection conn = BackupManagerService.this.mTransportConnections.get(packageName);
                            if (conn != null) {
                                BackupManagerService.this.bindTransport(conn.mTransport);
                            } else {
                                BackupManagerService.this.checkForTransportAndBind(app);
                            }
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.i(BackupManagerService.TAG, "Can't resolve new app " + packageName);
                    }
                }
            } else if (!replacing) {
                SparseArray<HashSet<String>> sparseArray = BackupManagerService.this.mBackupParticipants;
                synchronized (sparseArray) {
                    BackupManagerService.this.removePackageParticipantsLocked(pkgList, uid);
                }
            }
        }
    };

    static BackupManagerService getInstance() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int generateToken() {
        int token;
        do {
            Random random = this.mTokenGenerator;
            synchronized (random) {
                token = this.mTokenGenerator.nextInt();
            }
        } while (token < 0);
        return token;
    }

    public static boolean appIsEligibleForBackup(ApplicationInfo app) {
        if ((app.flags & 0x8000) == 0) {
            return false;
        }
        if (app.uid < 10000 && app.backupAgentName == null) {
            return false;
        }
        return !app.packageName.equals(SHARED_BACKUP_AGENT_PACKAGE);
    }

    public static boolean appGetsFullBackup(PackageInfo pkg) {
        if (pkg.applicationInfo.backupAgentName != null) {
            return (pkg.applicationInfo.flags & 0x4000000) != 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addBackupTrace(String s) {
        List<String> list = this.mBackupTrace;
        synchronized (list) {
            this.mBackupTrace.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBackupTrace() {
        List<String> list = this.mBackupTrace;
        synchronized (list) {
            this.mBackupTrace.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupManagerService(Context context) {
        Object salt;
        FilterInputStream in;
        FileInputStream fin;
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mPackageManagerBinder = AppGlobals.getPackageManager();
        this.mActivityManager = ActivityManagerNative.getDefault();
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mMountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        this.mBackupManagerBinder = BackupManagerService.asInterface(this.asBinder());
        this.mHandlerThread = new HandlerThread("backup", 10);
        this.mHandlerThread.start();
        this.mBackupHandler = new BackupHandler(this.mHandlerThread.getLooper());
        ContentResolver resolver = context.getContentResolver();
        this.mProvisioned = Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
        this.mAutoRestore = Settings.Secure.getInt(resolver, "backup_auto_restore", 1) != 0;
        this.mProvisionedObserver = new ProvisionedObserver(this.mBackupHandler);
        resolver.registerContentObserver(Settings.Global.getUriFor("device_provisioned"), false, this.mProvisionedObserver);
        this.mBaseStateDir = new File(Environment.getSecureDataDirectory(), "backup");
        this.mBaseStateDir.mkdirs();
        if (!SELinux.restorecon(this.mBaseStateDir)) {
            Slog.e(TAG, "SELinux restorecon failed on " + this.mBaseStateDir);
        }
        this.mDataDir = Environment.getDownloadCacheDirectory();
        this.mPasswordVersion = 1;
        this.mPasswordVersionFile = new File(this.mBaseStateDir, "pwversion");
        if (this.mPasswordVersionFile.exists()) {
            fin = null;
            in = null;
            try {
                fin = new FileInputStream(this.mPasswordVersionFile);
                in = new DataInputStream(fin);
                this.mPasswordVersion = ((DataInputStream)in).readInt();
            }
            catch (IOException e) {
                Slog.e(TAG, "Unable to read backup pw version");
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    Slog.w(TAG, "Error closing pw version files");
                }
            }
        }
        this.mPasswordHashFile = new File(this.mBaseStateDir, "pwhash");
        if (this.mPasswordHashFile.exists()) {
            fin = null;
            in = null;
            try {
                fin = new FileInputStream(this.mPasswordHashFile);
                in = new DataInputStream(new BufferedInputStream(fin));
                int saltLen = ((DataInputStream)in).readInt();
                salt = new byte[saltLen];
                ((DataInputStream)in).readFully((byte[])salt);
                this.mPasswordHash = ((DataInputStream)in).readUTF();
                this.mPasswordSalt = salt;
            }
            catch (IOException e) {
                Slog.e(TAG, "Unable to read saved backup pw hash");
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (IOException e) {
                    Slog.w(TAG, "Unable to close streams");
                }
            }
        }
        this.mRunBackupReceiver = new RunBackupReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(RUN_BACKUP_ACTION);
        context.registerReceiver(this.mRunBackupReceiver, filter, "android.permission.BACKUP", null);
        this.mRunInitReceiver = new RunInitializeReceiver();
        filter = new IntentFilter();
        filter.addAction(RUN_INITIALIZE_ACTION);
        context.registerReceiver(this.mRunInitReceiver, filter, "android.permission.BACKUP", null);
        Intent backupIntent = new Intent(RUN_BACKUP_ACTION);
        backupIntent.addFlags(0x40000000);
        this.mRunBackupIntent = PendingIntent.getBroadcast(context, 1, backupIntent, 0);
        Intent initIntent = new Intent(RUN_INITIALIZE_ACTION);
        backupIntent.addFlags(0x40000000);
        this.mRunInitIntent = PendingIntent.getBroadcast(context, 5, initIntent, 0);
        this.mJournalDir = new File(this.mBaseStateDir, "pending");
        this.mJournalDir.mkdirs();
        this.mJournal = null;
        this.mFullBackupScheduleFile = new File(this.mBaseStateDir, "fb-schedule");
        this.initPackageTracking();
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        salt = sparseArray;
        synchronized (sparseArray) {
            this.addPackageParticipantsLocked(null);
            // ** MonitorExit[salt /* !! */ ] (shouldn't be in output)
            this.mCurrentTransport = Settings.Secure.getString(context.getContentResolver(), "backup_transport");
            if ("".equals(this.mCurrentTransport)) {
                this.mCurrentTransport = null;
            }
            Slog.v(TAG, "Starting with transport " + this.mCurrentTransport);
            List<ResolveInfo> hosts = this.mPackageManager.queryIntentServicesAsUser(this.mTransportServiceIntent, 0, 0);
            Slog.v(TAG, "Found transports: " + (hosts == null ? "null" : Integer.valueOf(hosts.size())));
            if (hosts != null) {
                for (int i = 0; i < hosts.size(); ++i) {
                    ServiceInfo transport = hosts.get((int)i).serviceInfo;
                    this.tryBindTransport(transport);
                }
            }
            this.parseLeftoverJournals();
            this.mWakelock = this.mPowerManager.newWakeLock(1, "*backup*");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPackageTracking() {
        this.mTokenFile = new File(this.mBaseStateDir, "ancestral");
        try {
            RandomAccessFile tf = new RandomAccessFile(this.mTokenFile, "r");
            int version = tf.readInt();
            if (version == 1) {
                this.mAncestralToken = tf.readLong();
                this.mCurrentToken = tf.readLong();
                int numPackages = tf.readInt();
                if (numPackages >= 0) {
                    this.mAncestralPackages = new HashSet<String>();
                    for (int i = 0; i < numPackages; ++i) {
                        String pkgName = tf.readUTF();
                        this.mAncestralPackages.add(pkgName);
                    }
                }
            }
            tf.close();
        }
        catch (FileNotFoundException fnf) {
            Slog.v(TAG, "No ancestral data");
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to read token file", e);
        }
        this.mEverStored = new File(this.mBaseStateDir, "processed");
        File tempProcessedFile = new File(this.mBaseStateDir, "processed.new");
        if (tempProcessedFile.exists()) {
            tempProcessedFile.delete();
        }
        if (this.mEverStored.exists()) {
            RandomAccessFile temp = null;
            RandomAccessFile in = null;
            try {
                temp = new RandomAccessFile(tempProcessedFile, "rws");
                in = new RandomAccessFile(this.mEverStored, "r");
                while (true) {
                    String pkg = in.readUTF();
                    try {
                        PackageInfo info = this.mPackageManager.getPackageInfo(pkg, 0);
                        this.mEverStoredApps.add(pkg);
                        temp.writeUTF(pkg);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {}
                }
            }
            catch (EOFException e2) {
                if (!tempProcessedFile.renameTo(this.mEverStored)) {
                    Slog.e(TAG, "Error renaming " + tempProcessedFile + " to " + this.mEverStored);
                }
                try {
                    if (temp != null) {
                        temp.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e2) {}
            }
            catch (IOException e) {
                try {
                    Slog.e(TAG, "Error in processed file", e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (temp != null) {
                            temp.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        this.mFullBackupQueue = this.readFullBackupSchedule();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mBroadcastReceiver, sdFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<FullBackupEntry> readFullBackupSchedule() {
        ArrayList<FullBackupEntry> schedule = null;
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mFullBackupScheduleFile.exists()) {
                DataInputStream in;
                BufferedInputStream bufStream;
                FileInputStream fstream;
                block12: {
                    fstream = null;
                    bufStream = null;
                    in = null;
                    fstream = new FileInputStream(this.mFullBackupScheduleFile);
                    bufStream = new BufferedInputStream(fstream);
                    in = new DataInputStream(bufStream);
                    int version = in.readInt();
                    if (version == 1) break block12;
                    Slog.e(TAG, "Unknown backup schedule version " + version);
                    ArrayList<FullBackupEntry> arrayList = null;
                    IoUtils.closeQuietly(in);
                    IoUtils.closeQuietly(bufStream);
                    IoUtils.closeQuietly(fstream);
                    return arrayList;
                }
                try {
                    int N = in.readInt();
                    schedule = new ArrayList(N);
                    for (int i = 0; i < N; ++i) {
                        String pkgName = in.readUTF();
                        long lastBackup = in.readLong();
                        schedule.add(new FullBackupEntry(pkgName, lastBackup));
                    }
                    Collections.sort(schedule);
                }
                catch (Exception e) {
                    try {
                        Slog.e(TAG, "Unable to read backup schedule", e);
                        this.mFullBackupScheduleFile.delete();
                        schedule = null;
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(in);
                        IoUtils.closeQuietly(bufStream);
                        IoUtils.closeQuietly(fstream);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(in);
                    IoUtils.closeQuietly(bufStream);
                    IoUtils.closeQuietly(fstream);
                }
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(bufStream);
                IoUtils.closeQuietly(fstream);
            }
            if (schedule != null) return schedule;
            List<PackageInfo> apps = PackageManagerBackupAgent.getStorableApplications(this.mPackageManager);
            int N = apps.size();
            schedule = new ArrayList<FullBackupEntry>(N);
            int i = 0;
            while (true) {
                if (i >= N) {
                    this.writeFullBackupScheduleAsync();
                    return schedule;
                }
                PackageInfo info = apps.get(i);
                if (BackupManagerService.appGetsFullBackup(info)) {
                    schedule.add(new FullBackupEntry(info.packageName, 0L));
                }
                ++i;
            }
        }
    }

    private void writeFullBackupScheduleAsync() {
        this.mBackupHandler.removeCallbacks(this.mFullBackupScheduleWriter);
        this.mBackupHandler.post(this.mFullBackupScheduleWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseLeftoverJournals() {
        for (File f : this.mJournalDir.listFiles()) {
            if (this.mJournal != null && f.compareTo(this.mJournal) == 0) continue;
            RandomAccessFile in = null;
            try {
                Slog.i(TAG, "Found stale backup journal, scheduling");
                in = new RandomAccessFile(f, "r");
                while (true) {
                    String packageName2 = in.readUTF();
                    this.dataChangedImpl(packageName2);
                }
            }
            catch (EOFException packageName2) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException packageName2) {
                    // empty catch block
                }
                f.delete();
            }
            catch (Exception e) {
                try {
                    Slog.e(TAG, "Can't read " + f, e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException iOException) {}
                    f.delete();
                }
            }
        }
    }

    private SecretKey buildPasswordKey(String algorithm, String pw, byte[] salt, int rounds) {
        return this.buildCharArrayKey(algorithm, pw.toCharArray(), salt, rounds);
    }

    private SecretKey buildCharArrayKey(String algorithm, char[] pwArray, byte[] salt, int rounds) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            PBEKeySpec ks = new PBEKeySpec(pwArray, salt, rounds, 256);
            return keyFactory.generateSecret(ks);
        }
        catch (InvalidKeySpecException e) {
            Slog.e(TAG, "Invalid key spec for PBKDF2!");
        }
        catch (NoSuchAlgorithmException e) {
            Slog.e(TAG, "PBKDF2 unavailable!");
        }
        return null;
    }

    private String buildPasswordHash(String algorithm, String pw, byte[] salt, int rounds) {
        SecretKey key = this.buildPasswordKey(algorithm, pw, salt, rounds);
        if (key != null) {
            return this.byteArrayToHex(key.getEncoded());
        }
        return null;
    }

    private String byteArrayToHex(byte[] data) {
        StringBuilder buf = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            buf.append(Byte.toHexString((byte)data[i], (boolean)true));
        }
        return buf.toString();
    }

    private byte[] hexToByteArray(String digits) {
        int bytes = digits.length() / 2;
        if (2 * bytes != digits.length()) {
            throw new IllegalArgumentException("Hex string must have an even number of digits");
        }
        byte[] result = new byte[bytes];
        for (int i = 0; i < digits.length(); i += 2) {
            result[i / 2] = (byte)Integer.parseInt(digits.substring(i, i + 2), 16);
        }
        return result;
    }

    private byte[] makeKeyChecksum(String algorithm, byte[] pwBytes, byte[] salt, int rounds) {
        char[] mkAsChar = new char[pwBytes.length];
        for (int i = 0; i < pwBytes.length; ++i) {
            mkAsChar[i] = (char)pwBytes[i];
        }
        SecretKey checksum = this.buildCharArrayKey(algorithm, mkAsChar, salt, rounds);
        return checksum.getEncoded();
    }

    private byte[] randomBytes(int bits) {
        byte[] array2 = new byte[bits / 8];
        this.mRng.nextBytes(array2);
        return array2;
    }

    boolean passwordMatchesSaved(String algorithm, String candidatePw, int rounds) {
        String currentPwHash;
        return this.mPasswordHash == null ? candidatePw == null || "".equals(candidatePw) : candidatePw != null && candidatePw.length() > 0 && this.mPasswordHash.equalsIgnoreCase(currentPwHash = this.buildPasswordHash(algorithm, candidatePw, this.mPasswordSalt, rounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBackupPassword(String currentPw, String newPw) {
        boolean bl;
        OutputStream buffer;
        FileOutputStream pwf;
        block27: {
            boolean pbkdf2Fallback;
            this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupPassword");
            boolean bl2 = pbkdf2Fallback = this.mPasswordVersion < 2;
            if (!(this.passwordMatchesSaved(PBKDF_CURRENT, currentPw, 10000) || pbkdf2Fallback && this.passwordMatchesSaved(PBKDF_FALLBACK, currentPw, 10000))) {
                return false;
            }
            this.mPasswordVersion = 2;
            FileOutputStream pwFout = null;
            FilterOutputStream pwOut = null;
            try {
                pwFout = new FileOutputStream(this.mPasswordVersionFile);
                pwOut = new DataOutputStream(pwFout);
                ((DataOutputStream)pwOut).writeInt(this.mPasswordVersion);
            }
            catch (IOException e) {
                Slog.e(TAG, "Unable to write backup pw version; password not changed");
                boolean bl3 = false;
                return bl3;
            }
            finally {
                try {
                    if (pwOut != null) {
                        pwOut.close();
                    }
                    if (pwFout != null) {
                        pwFout.close();
                    }
                }
                catch (IOException e) {
                    Slog.w(TAG, "Unable to close pw version record");
                }
            }
            if (newPw == null || newPw.isEmpty()) {
                if (this.mPasswordHashFile.exists() && !this.mPasswordHashFile.delete()) {
                    Slog.e(TAG, "Unable to clear backup password");
                    return false;
                }
                this.mPasswordHash = null;
                this.mPasswordSalt = null;
                return true;
            }
            byte[] salt = this.randomBytes(512);
            String newPwHash = this.buildPasswordHash(PBKDF_CURRENT, newPw, salt, 10000);
            pwf = null;
            buffer = null;
            FilterOutputStream out = null;
            try {
                pwf = new FileOutputStream(this.mPasswordHashFile);
                buffer = new BufferedOutputStream(pwf);
                out = new DataOutputStream(buffer);
                ((DataOutputStream)out).writeInt(salt.length);
                out.write(salt);
                ((DataOutputStream)out).writeUTF(newPwHash);
                ((DataOutputStream)out).flush();
                this.mPasswordHash = newPwHash;
                this.mPasswordSalt = salt;
                bl = true;
                if (out == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (buffer != null) {
                        buffer.close();
                    }
                    if (pwf != null) {
                        ((OutputStream)pwf).close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Slog.e(TAG, "Unable to set backup password");
                    return false;
                }
            }
            out.close();
        }
        if (buffer != null) {
            buffer.close();
        }
        if (pwf != null) {
            ((OutputStream)pwf).close();
        }
        return bl;
    }

    @Override
    public boolean hasBackupPassword() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "hasBackupPassword");
        return this.mPasswordHash != null && this.mPasswordHash.length() > 0;
    }

    private boolean backupPasswordMatches(String currentPw) {
        if (this.hasBackupPassword()) {
            boolean pbkdf2Fallback;
            boolean bl = pbkdf2Fallback = this.mPasswordVersion < 2;
            if (!(this.passwordMatchesSaved(PBKDF_CURRENT, currentPw, 10000) || pbkdf2Fallback && this.passwordMatchesSaved(PBKDF_FALLBACK, currentPw, 10000))) {
                Slog.w(TAG, "Backup password mismatch; aborting");
                return false;
            }
        }
        return true;
    }

    void recordInitPendingLocked(boolean isPending, String transportName) {
        Slog.i(TAG, "recordInitPendingLocked: " + isPending + " on transport " + transportName);
        this.mBackupHandler.removeMessages(11);
        try {
            IBackupTransport transport = this.getTransport(transportName);
            if (transport != null) {
                String transportDirName = transport.transportDirName();
                File stateDir = new File(this.mBaseStateDir, transportDirName);
                File initPendingFile = new File(stateDir, INIT_SENTINEL_FILE_NAME);
                if (isPending) {
                    this.mPendingInits.add(transportName);
                    try {
                        new FileOutputStream(initPendingFile).close();
                    }
                    catch (IOException iOException) {}
                } else {
                    initPendingFile.delete();
                    this.mPendingInits.remove(transportName);
                }
                return;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (isPending) {
            this.mPendingInits.add(transportName);
            this.mBackupHandler.sendMessageDelayed(this.mBackupHandler.obtainMessage(11, isPending ? 1 : 0, 0, transportName), 3600000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBackupState(File stateFileDir) {
        SparseArray<HashSet<String>> sparseArray = this.mQueueLock;
        synchronized (sparseArray) {
            this.mEverStoredApps.clear();
            this.mEverStored.delete();
            this.mCurrentToken = 0L;
            this.writeRestoreTokens();
            for (File sf : stateFileDir.listFiles()) {
                if (sf.getName().equals(INIT_SENTINEL_FILE_NAME)) continue;
                sf.delete();
            }
        }
        sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            int N = this.mBackupParticipants.size();
            for (int i = 0; i < N; ++i) {
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                if (participants == null) continue;
                for (String packageName : participants) {
                    this.dataChangedImpl(packageName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTransport(String name, String component, IBackupTransport transport) {
        block9: {
            ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
            synchronized (arrayMap) {
                Slog.v(TAG, "Registering transport " + component + "::" + name + " = " + transport);
                if (transport == null) {
                    this.mTransports.remove(this.mTransportNames.get(component));
                    this.mTransportNames.remove(component);
                    return;
                }
                this.mTransports.put(name, transport);
                this.mTransportNames.put(component, name);
            }
            try {
                String transportName = transport.transportDirName();
                File stateDir = new File(this.mBaseStateDir, transportName);
                stateDir.mkdirs();
                File initSentinel = new File(stateDir, INIT_SENTINEL_FILE_NAME);
                if (!initSentinel.exists()) break block9;
                Object object = this.mQueueLock;
                synchronized (object) {
                    this.mPendingInits.add(transportName);
                    long delay = 60000L;
                    this.mAlarmManager.set(0, System.currentTimeMillis() + delay, this.mRunInitIntent);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to register transport as " + name);
                this.mTransportNames.remove(component);
                this.mTransports.remove(name);
            }
        }
    }

    void checkForTransportAndBind(PackageInfo pkgInfo) {
        Intent intent = new Intent(this.mTransportServiceIntent).setPackage(pkgInfo.packageName);
        List<ResolveInfo> hosts = this.mPackageManager.queryIntentServicesAsUser(intent, 0, 0);
        int N = hosts.size();
        for (int i = 0; i < N; ++i) {
            ServiceInfo info = hosts.get((int)i).serviceInfo;
            this.tryBindTransport(info);
        }
    }

    boolean tryBindTransport(ServiceInfo info) {
        try {
            PackageInfo packInfo = this.mPackageManager.getPackageInfo(info.packageName, 0);
            if ((packInfo.applicationInfo.flags & 0x40000000) != 0) {
                return this.bindTransport(info);
            }
            Slog.w(TAG, "Transport package " + info.packageName + " not privileged");
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Problem resolving transport package " + info.packageName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean bindTransport(ServiceInfo transport) {
        TransportConnection connection;
        ComponentName svcName = new ComponentName(transport.packageName, transport.name);
        Slog.i(TAG, "Binding to transport host " + svcName);
        Intent intent = new Intent(this.mTransportServiceIntent);
        intent.setComponent(svcName);
        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
        synchronized (arrayMap) {
            connection = this.mTransportConnections.get(transport.packageName);
            if (null == connection) {
                connection = new TransportConnection(transport);
                this.mTransportConnections.put(transport.packageName, connection);
            } else {
                this.mContext.unbindService(connection);
            }
        }
        return this.mContext.bindServiceAsUser(intent, connection, 1, UserHandle.OWNER);
    }

    void addPackageParticipantsLocked(String[] packageNames) {
        List<PackageInfo> targetApps = this.allAgentPackages();
        if (packageNames != null) {
            for (String packageName : packageNames) {
                this.addPackageParticipantsLockedInner(packageName, targetApps);
            }
        } else {
            this.addPackageParticipantsLockedInner(null, targetApps);
        }
    }

    private void addPackageParticipantsLockedInner(String packageName, List<PackageInfo> targetPkgs) {
        for (PackageInfo pkg : targetPkgs) {
            if (packageName != null && !pkg.packageName.equals(packageName)) continue;
            int uid = pkg.applicationInfo.uid;
            HashSet<String> set = this.mBackupParticipants.get(uid);
            if (set == null) {
                set = new HashSet();
                this.mBackupParticipants.put(uid, set);
            }
            set.add(pkg.packageName);
            this.dataChangedImpl(pkg.packageName);
        }
    }

    void removePackageParticipantsLocked(String[] packageNames, int oldUid) {
        if (packageNames == null) {
            Slog.w(TAG, "removePackageParticipants with null list");
            return;
        }
        for (String pkg : packageNames) {
            HashSet<String> set = this.mBackupParticipants.get(oldUid);
            if (set == null || !set.contains(pkg)) continue;
            this.removePackageFromSetLocked(set, pkg);
            if (!set.isEmpty()) continue;
            this.mBackupParticipants.remove(oldUid);
        }
    }

    private void removePackageFromSetLocked(HashSet<String> set, String packageName) {
        if (set.contains(packageName)) {
            set.remove(packageName);
            this.mPendingBackups.remove(packageName);
        }
    }

    List<PackageInfo> allAgentPackages() {
        int flags = 64;
        List<PackageInfo> packages = this.mPackageManager.getInstalledPackages(flags);
        int N = packages.size();
        for (int a = N - 1; a >= 0; --a) {
            PackageInfo pkg = packages.get(a);
            try {
                ApplicationInfo app = pkg.applicationInfo;
                if ((app.flags & 0x8000) == 0 || app.backupAgentName == null) {
                    packages.remove(a);
                    continue;
                }
                app = this.mPackageManager.getApplicationInfo(pkg.packageName, 1024);
                pkg.applicationInfo.sharedLibraryFiles = app.sharedLibraryFiles;
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                packages.remove(a);
            }
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logBackupComplete(String packageName) {
        if (packageName.equals(PACKAGE_MANAGER_SENTINEL)) {
            return;
        }
        HashSet<String> hashSet = this.mEverStoredApps;
        synchronized (hashSet) {
            if (!this.mEverStoredApps.add(packageName)) {
                return;
            }
            RandomAccessFile out = null;
            try {
                out = new RandomAccessFile(this.mEverStored, "rws");
                out.seek(out.length());
                out.writeUTF(packageName);
            }
            catch (IOException e) {
                Slog.e(TAG, "Can't log backup of " + packageName + " to " + this.mEverStored);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEverBackedUp(String packageName) {
        Slog.v(TAG, "Removing backed-up knowledge of " + packageName);
        HashSet<String> hashSet = this.mEverStoredApps;
        synchronized (hashSet) {
            File tempKnownFile = new File(this.mBaseStateDir, "processed.new");
            RandomAccessFile known = null;
            try {
                known = new RandomAccessFile(tempKnownFile, "rws");
                this.mEverStoredApps.remove(packageName);
                for (String s : this.mEverStoredApps) {
                    known.writeUTF(s);
                }
                known.close();
                known = null;
                if (!tempKnownFile.renameTo(this.mEverStored)) {
                    throw new IOException("Can't rename " + tempKnownFile + " to " + this.mEverStored);
                }
            }
            catch (IOException e) {
                Slog.w(TAG, "Error rewriting " + this.mEverStored, e);
                this.mEverStoredApps.clear();
                tempKnownFile.delete();
                this.mEverStored.delete();
            }
            finally {
                try {
                    if (known != null) {
                        known.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    void writeRestoreTokens() {
        try {
            RandomAccessFile af = new RandomAccessFile(this.mTokenFile, "rwd");
            af.writeInt(1);
            af.writeLong(this.mAncestralToken);
            af.writeLong(this.mCurrentToken);
            if (this.mAncestralPackages == null) {
                af.writeInt(-1);
            } else {
                af.writeInt(this.mAncestralPackages.size());
                Slog.v(TAG, "Ancestral packages:  " + this.mAncestralPackages.size());
                for (String pkgName : this.mAncestralPackages) {
                    af.writeUTF(pkgName);
                }
            }
            af.close();
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to write token file:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBackupTransport getTransport(String transportName) {
        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
        synchronized (arrayMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport == null) {
                Slog.w(TAG, "Requested unavailable transport: " + transportName);
            }
            return transport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBackupAgent bindToAgentSynchronous(ApplicationInfo app, int mode) {
        IBackupAgent agent = null;
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            this.mConnecting = true;
            this.mConnectedAgent = null;
            try {
                if (this.mActivityManager.bindBackupAgent(app, mode)) {
                    Slog.d(TAG, "awaiting agent for " + app);
                    long timeoutMark = System.currentTimeMillis() + 10000L;
                    while (this.mConnecting && this.mConnectedAgent == null && System.currentTimeMillis() < timeoutMark) {
                        try {
                            this.mAgentConnectLock.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            Slog.w(TAG, "Interrupted: " + e);
                            this.mActivityManager.clearPendingBackup();
                            return null;
                        }
                    }
                    if (this.mConnecting) {
                        Slog.w(TAG, "Timeout waiting for agent " + app);
                        this.mActivityManager.clearPendingBackup();
                        return null;
                    }
                    Slog.i(TAG, "got agent " + this.mConnectedAgent);
                    agent = this.mConnectedAgent;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearApplicationDataSynchronous(String packageName) {
        try {
            PackageInfo info = this.mPackageManager.getPackageInfo(packageName, 0);
            if ((info.applicationInfo.flags & 0x40) == 0) {
                return;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Tried to clear data for " + packageName + " but not found");
            return;
        }
        ClearDataObserver observer = new ClearDataObserver();
        Object object = this.mClearDataLock;
        synchronized (object) {
            this.mClearingData = true;
            try {
                this.mActivityManager.clearApplicationUserData(packageName, observer, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            long timeoutMark = System.currentTimeMillis() + 10000L;
            while (this.mClearingData && System.currentTimeMillis() < timeoutMark) {
                try {
                    this.mClearDataLock.wait(5000L);
                }
                catch (InterruptedException e) {
                    this.mClearingData = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getAvailableRestoreToken(String packageName) {
        long token = this.mAncestralToken;
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mEverStoredApps.contains(packageName)) {
                token = this.mCurrentToken;
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareOperationTimeout(int token, long interval, BackupRestoreTask callback) {
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            this.mCurrentOperations.put(token, new Operation(0, callback));
            Message msg = this.mBackupHandler.obtainMessage(7, token, 0, callback);
            this.mBackupHandler.sendMessageDelayed(msg, interval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitUntilOperationComplete(int token) {
        int finalState = 0;
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            while ((op = this.mCurrentOperations.get(token)) != null) {
                if (op.state == 0) {
                    try {
                        this.mCurrentOpLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                finalState = op.state;
                break;
            }
        }
        this.mBackupHandler.removeMessages(7);
        return finalState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleTimeout(int token, Object obj) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            int state;
            op = this.mCurrentOperations.get(token);
            int n = state = op != null ? op.state : -1;
            if (state == 0) {
                Slog.v(TAG, "TIMEOUT: token=" + Integer.toHexString(token));
                op.state = -1;
                this.mCurrentOperations.put(token, op);
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            op.callback.handleTimeout();
        }
    }

    private void routeSocketDataToOutput(ParcelFileDescriptor inPipe, OutputStream out) throws IOException {
        int chunkTotal;
        FileInputStream raw2 = new FileInputStream(inPipe.getFileDescriptor());
        DataInputStream in = new DataInputStream(raw2);
        byte[] buffer = new byte[32768];
        while ((chunkTotal = in.readInt()) > 0) {
            while (chunkTotal > 0) {
                int toRead = chunkTotal > buffer.length ? buffer.length : chunkTotal;
                int nRead = in.read(buffer, 0, toRead);
                out.write(buffer, 0, nRead);
                chunkTotal -= nRead;
            }
        }
    }

    boolean deviceIsEncrypted() {
        try {
            return this.mMountService.getEncryptionState() != 1 && this.mMountService.getPasswordType() != 1;
        }
        catch (Exception e) {
            Slog.e(TAG, "Unable to communicate with mount service: " + e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleNextFullBackupJob() {
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mFullBackupQueue.size() > 0) {
                long upcomingLastBackup = this.mFullBackupQueue.get((int)0).lastBackup;
                long timeSinceLast = System.currentTimeMillis() - upcomingLastBackup;
                final long latency = timeSinceLast < 86400000L ? 86400000L - timeSinceLast : 0L;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FullBackupJob.schedule(BackupManagerService.this.mContext, latency);
                    }
                };
                this.mBackupHandler.postDelayed(r, 2500L);
            } else {
                Slog.i(TAG, "Full backup queue empty; not scheduling");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueFullBackup(String packageName, long lastBackedUp) {
        FullBackupEntry newEntry = new FullBackupEntry(packageName, lastBackedUp);
        Object object = this.mQueueLock;
        synchronized (object) {
            int which;
            int N = this.mFullBackupQueue.size();
            for (int i = N - 1; i >= 0; --i) {
                FullBackupEntry e = this.mFullBackupQueue.get(i);
                if (!packageName.equals(e.packageName)) continue;
                Slog.w(TAG, "Removing schedule queue dupe of " + packageName);
                this.mFullBackupQueue.remove(i);
            }
            for (which = this.mFullBackupQueue.size() - 1; which >= 0; --which) {
                FullBackupEntry entry = this.mFullBackupQueue.get(which);
                if (entry.lastBackup > lastBackedUp) continue;
                this.mFullBackupQueue.add(which + 1, newEntry);
                break;
            }
            if (which < 0) {
                this.mFullBackupQueue.add(0, newEntry);
            }
        }
        this.writeFullBackupScheduleAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean beginFullBackup(FullBackupJob scheduledJob) {
        long now = System.currentTimeMillis();
        FullBackupEntry entry = null;
        Slog.i(TAG, "Beginning scheduled full backup operation");
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mRunningFullBackupTask != null) {
                Slog.e(TAG, "Backup triggered but one already/still running!");
                return false;
            }
            if (this.mFullBackupQueue.size() == 0) {
                Slog.i(TAG, "Backup queue empty; doing nothing");
                return false;
            }
            entry = this.mFullBackupQueue.get(0);
            long timeSinceRun = now - entry.lastBackup;
            if (timeSinceRun < 86400000L) {
                final long latency = 86400000L - timeSinceRun;
                this.mBackupHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        FullBackupJob.schedule(BackupManagerService.this.mContext, latency);
                    }
                });
                return false;
            }
            this.mFullBackupQueue.remove(0);
            AtomicBoolean latch = new AtomicBoolean(false);
            String[] pkg = new String[]{entry.packageName};
            this.mRunningFullBackupTask = new PerformFullTransportBackupTask(null, pkg, true, scheduledJob, latch);
            new Thread(this.mRunningFullBackupTask).start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endFullBackup() {
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mRunningFullBackupTask != null) {
                Slog.i(TAG, "Telling running backup to stop");
                this.mRunningFullBackupTask.setRunning(false);
            }
        }
    }

    static boolean signaturesMatch(ArrayList<byte[]> storedSigHashes, PackageInfo target) {
        if (target == null) {
            return false;
        }
        if ((target.applicationInfo.flags & 1) != 0) {
            Slog.v(TAG, "System app " + target.packageName + " - skipping sig check");
            return true;
        }
        Signature[] deviceSigs = target.signatures;
        if (!(storedSigHashes != null && storedSigHashes.size() != 0 || deviceSigs != null && deviceSigs.length != 0)) {
            return true;
        }
        if (storedSigHashes == null || deviceSigs == null) {
            return false;
        }
        int nStored = storedSigHashes.size();
        int nDevice = deviceSigs.length;
        ArrayList<byte[]> deviceHashes = new ArrayList<byte[]>(nDevice);
        for (int i = 0; i < nDevice; ++i) {
            deviceHashes.add(BackupManagerService.hashSignature(deviceSigs[i]));
        }
        for (int n = 0; n < nStored; ++n) {
            boolean match = false;
            byte[] storedHash = storedSigHashes.get(n);
            for (int i = 0; i < nDevice; ++i) {
                if (!Arrays.equals(storedHash, (byte[])deviceHashes.get(i))) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    static byte[] hashSignature(Signature sig) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(sig.toByteArray());
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            Slog.w(TAG, "No SHA-256 algorithm found!");
            return null;
        }
    }

    static boolean signaturesMatch(Signature[] storedSigs, PackageInfo target) {
        if (target == null) {
            return false;
        }
        if ((target.applicationInfo.flags & 1) != 0) {
            Slog.v(TAG, "System app " + target.packageName + " - skipping sig check");
            return true;
        }
        Signature[] deviceSigs = target.signatures;
        if (!(storedSigs != null && storedSigs.length != 0 || deviceSigs != null && deviceSigs.length != 0)) {
            return true;
        }
        if (storedSigs == null || deviceSigs == null) {
            return false;
        }
        int nStored = storedSigs.length;
        int nDevice = deviceSigs.length;
        for (int i = 0; i < nStored; ++i) {
            boolean match = false;
            for (int j = 0; j < nDevice; ++j) {
                if (!storedSigs[i].equals(deviceSigs[j])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    void restoreWidgetData(String packageName, byte[] widgetData) {
        AppWidgetBackupBridge.restoreWidgetState(packageName, widgetData, 0);
    }

    private void dataChangedImpl(String packageName) {
        HashSet<String> targets = this.dataChangedTargets(packageName);
        this.dataChangedImpl(packageName, targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataChangedImpl(String packageName, HashSet<String> targets) {
        EventLog.writeEvent(2820, packageName);
        if (targets == null) {
            Slog.w(TAG, "dataChanged but no participant pkg='" + packageName + "'" + " uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mQueueLock;
        synchronized (object) {
            BackupRequest req;
            if (targets.contains(packageName) && this.mPendingBackups.put(packageName, req = new BackupRequest(packageName)) == null) {
                Slog.d(TAG, "Now staging backup of " + packageName);
                this.writeToJournalLocked(packageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> dataChangedTargets(String packageName) {
        if (this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1) {
            SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
            synchronized (sparseArray) {
                return this.mBackupParticipants.get(Binder.getCallingUid());
            }
        }
        HashSet<String> targets = new HashSet<String>();
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            int N = this.mBackupParticipants.size();
            for (int i = 0; i < N; ++i) {
                HashSet<String> s = this.mBackupParticipants.valueAt(i);
                if (s == null) continue;
                targets.addAll(s);
            }
        }
        return targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToJournalLocked(String str) {
        RandomAccessFile out = null;
        try {
            if (this.mJournal == null) {
                this.mJournal = File.createTempFile("journal", null, this.mJournalDir);
            }
            out = new RandomAccessFile(this.mJournal, "rws");
            out.seek(out.length());
            out.writeUTF(str);
        }
        catch (IOException e) {
            Slog.e(TAG, "Can't write " + str + " to backup journal", e);
            this.mJournal = null;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void dataChanged(final String packageName) {
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            return;
        }
        final HashSet<String> targets = this.dataChangedTargets(packageName);
        if (targets == null) {
            Slog.w(TAG, "dataChanged but no participant pkg='" + packageName + "'" + " uid=" + Binder.getCallingUid());
            return;
        }
        this.mBackupHandler.post(new Runnable(){

            @Override
            public void run() {
                BackupManagerService.this.dataChangedImpl(packageName, targets);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackupData(String transportName, String packageName) {
        HashSet<String> apps;
        PackageInfo info;
        Slog.v(TAG, "clearBackupData() of " + packageName + " on " + transportName);
        try {
            info = this.mPackageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.d(TAG, "No such package '" + packageName + "' - not clearing backup data");
            return;
        }
        if (this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1) {
            apps = this.mBackupParticipants.get(Binder.getCallingUid());
        } else {
            Slog.v(TAG, "Privileged caller, allowing clear of other apps");
            apps = new HashSet();
            int N = this.mBackupParticipants.size();
            for (int i = 0; i < N; ++i) {
                HashSet<String> s = this.mBackupParticipants.valueAt(i);
                if (s == null) continue;
                apps.addAll(s);
            }
        }
        if (apps.contains(packageName)) {
            Slog.v(TAG, "Found the app - running clear process");
            this.mBackupHandler.removeMessages(12);
            Object object = this.mQueueLock;
            synchronized (object) {
                IBackupTransport transport = this.getTransport(transportName);
                if (transport == null) {
                    Message msg = this.mBackupHandler.obtainMessage(12, new ClearRetryParams(transportName, packageName));
                    this.mBackupHandler.sendMessageDelayed(msg, 3600000L);
                    return;
                }
                long oldId = Binder.clearCallingIdentity();
                this.mWakelock.acquire();
                Message msg = this.mBackupHandler.obtainMessage(4, new ClearParams(transport, info));
                this.mBackupHandler.sendMessage(msg);
                Binder.restoreCallingIdentity(oldId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupNow() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "backupNow");
        Slog.v(TAG, "Scheduling immediate backup pass");
        Object object = this.mQueueLock;
        synchronized (object) {
            this.startBackupAlarmsLocked(3600000L);
            try {
                this.mRunBackupIntent.send();
            }
            catch (PendingIntent.CanceledException e) {
                Slog.e(TAG, "run-backup intent cancelled!");
            }
        }
    }

    boolean deviceIsProvisioned() {
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fullBackup(ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean doAllApps, boolean includeSystem, boolean compress, String[] pkgList) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "fullBackup");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Backup supported only for the device owner");
        }
        if (!(doAllApps || includeShared || pkgList != null && pkgList.length != 0)) {
            throw new IllegalArgumentException("Backup requested but neither shared nor any apps named");
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            if (!this.deviceIsProvisioned()) {
                Slog.i(TAG, "Full backup not supported before setup");
                return;
            }
            Slog.v(TAG, "Requesting full backup: apks=" + includeApks + " obb=" + includeObbs + " shared=" + includeShared + " all=" + doAllApps + " system=" + includeSystem + " pkgs=" + pkgList);
            Slog.i(TAG, "Beginning full backup...");
            FullBackupParams params = new FullBackupParams(fd, includeApks, includeObbs, includeShared, doWidgets, doAllApps, includeSystem, compress, pkgList);
            int token = this.generateToken();
            SparseArray<FullParams> sparseArray = this.mFullConfirmations;
            synchronized (sparseArray) {
                this.mFullConfirmations.put(token, params);
            }
            Slog.d(TAG, "Starting backup confirmation UI, token=" + token);
            if (!this.startConfirmationUi(token, "fullback")) {
                Slog.e(TAG, "Unable to launch full backup confirmation");
                this.mFullConfirmations.delete(token);
                return;
            }
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
            this.startConfirmationTimeout(token, params);
            Slog.d(TAG, "Waiting for full backup completion...");
            this.waitForCompletion(params);
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException iOException) {}
            Binder.restoreCallingIdentity(oldId);
            Slog.d(TAG, "Full backup processing complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fullTransportBackup(String[] pkgNames) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "fullTransportBackup");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Restore supported only for the device owner");
        }
        Slog.d(TAG, "fullTransportBackup()");
        AtomicBoolean latch = new AtomicBoolean(false);
        PerformFullTransportBackupTask task = new PerformFullTransportBackupTask(null, pkgNames, false, null, latch);
        new Thread((Runnable)task, "full-transport-master").start();
        AtomicBoolean atomicBoolean = latch;
        synchronized (atomicBoolean) {
            try {
                while (!latch.get()) {
                    latch.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Slog.d(TAG, "Done with full transport backup.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fullRestore(ParcelFileDescriptor fd) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "fullRestore");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Restore supported only for the device owner");
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            if (!this.deviceIsProvisioned()) {
                Slog.i(TAG, "Full restore not permitted before setup");
                return;
            }
            Slog.i(TAG, "Beginning full restore...");
            FullRestoreParams params = new FullRestoreParams(fd);
            int token = this.generateToken();
            SparseArray<FullParams> sparseArray = this.mFullConfirmations;
            synchronized (sparseArray) {
                this.mFullConfirmations.put(token, params);
            }
            Slog.d(TAG, "Starting restore confirmation UI, token=" + token);
            if (!this.startConfirmationUi(token, "fullrest")) {
                Slog.e(TAG, "Unable to launch full restore confirmation");
                this.mFullConfirmations.delete(token);
                return;
            }
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), false);
            this.startConfirmationTimeout(token, params);
            Slog.d(TAG, "Waiting for full restore completion...");
            this.waitForCompletion(params);
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException e) {
                Slog.w(TAG, "Error trying to close fd after full restore: " + e);
            }
            Binder.restoreCallingIdentity(oldId);
            Slog.i(TAG, "Full restore processing complete.");
        }
    }

    boolean startConfirmationUi(int token, String action) {
        try {
            Intent confIntent = new Intent(action);
            confIntent.setClassName("com.android.backupconfirm", "com.android.backupconfirm.BackupRestoreConfirmation");
            confIntent.putExtra("conftoken", token);
            confIntent.addFlags(0x10000000);
            this.mContext.startActivity(confIntent);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    void startConfirmationTimeout(int token, FullParams params) {
        Message msg = this.mBackupHandler.obtainMessage(9, token, 0, params);
        this.mBackupHandler.sendMessageDelayed(msg, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForCompletion(FullParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            while (!params.latch.get()) {
                try {
                    params.latch.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalFullBackupRestoreCompletion(FullParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            params.latch.set(true);
            params.latch.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encPpassword, IFullBackupRestoreObserver observer) {
        Slog.d(TAG, "acknowledgeFullBackupOrRestore : token=" + token + " allow=" + allow);
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "acknowledgeFullBackupOrRestore");
        long oldId = Binder.clearCallingIdentity();
        try {
            SparseArray<FullParams> sparseArray = this.mFullConfirmations;
            synchronized (sparseArray) {
                FullParams params = this.mFullConfirmations.get(token);
                if (params != null) {
                    this.mBackupHandler.removeMessages(9, params);
                    this.mFullConfirmations.delete(token);
                    if (allow) {
                        int verb = params instanceof FullBackupParams ? 2 : 10;
                        params.observer = observer;
                        params.curPassword = curPassword;
                        params.encryptPassword = encPpassword;
                        Slog.d(TAG, "Sending conf message with verb " + verb);
                        this.mWakelock.acquire();
                        Message msg = this.mBackupHandler.obtainMessage(verb, params);
                        this.mBackupHandler.sendMessage(msg);
                    } else {
                        Slog.w(TAG, "User rejected full backup/restore operation");
                        this.signalFullBackupRestoreCompletion(params);
                    }
                } else {
                    Slog.w(TAG, "Attempted to ack full backup/restore with invalid token");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackupEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupEnabled");
        Slog.i(TAG, "Backup enabled => " + enable);
        long oldId = Binder.clearCallingIdentity();
        try {
            boolean wasEnabled = this.mEnabled;
            Object object = this;
            synchronized (object) {
                Settings.Secure.putInt(this.mContext.getContentResolver(), "backup_enabled", enable ? 1 : 0);
                this.mEnabled = enable;
            }
            object = this.mQueueLock;
            synchronized (object) {
                if (enable && !wasEnabled && this.mProvisioned) {
                    this.startBackupAlarmsLocked(3600000L);
                    this.scheduleNextFullBackupJob();
                } else if (!enable) {
                    Slog.i(TAG, "Opting out of backup");
                    this.mAlarmManager.cancel(this.mRunBackupIntent);
                    if (wasEnabled && this.mProvisioned) {
                        HashSet<String> allTransports;
                        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
                        synchronized (arrayMap) {
                            allTransports = new HashSet<String>(this.mTransports.keySet());
                        }
                        for (String transport : allTransports) {
                            this.recordInitPendingLocked(true, transport);
                        }
                        this.mAlarmManager.set(0, System.currentTimeMillis(), this.mRunInitIntent);
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoRestore(boolean doAutoRestore) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setAutoRestore");
        Slog.i(TAG, "Auto restore => " + doAutoRestore);
        long oldId = Binder.clearCallingIdentity();
        try {
            BackupManagerService backupManagerService = this;
            synchronized (backupManagerService) {
                Settings.Secure.putInt(this.mContext.getContentResolver(), "backup_auto_restore", doAutoRestore ? 1 : 0);
                this.mAutoRestore = doAutoRestore;
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    @Override
    public void setBackupProvisioned(boolean available) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupProvisioned");
    }

    private void startBackupAlarmsLocked(long delayBeforeFirstBackup) {
        Random random = new Random();
        long when = System.currentTimeMillis() + delayBeforeFirstBackup + (long)random.nextInt(300000);
        this.mAlarmManager.setRepeating(0, when, 3600000L + (long)random.nextInt(300000), this.mRunBackupIntent);
        this.mNextBackupPass = when;
    }

    @Override
    public boolean isBackupEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "isBackupEnabled");
        return this.mEnabled;
    }

    @Override
    public String getCurrentTransport() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getCurrentTransport");
        return this.mCurrentTransport;
    }

    @Override
    public String[] listAllTransports() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "listAllTransports");
        String[] list = null;
        ArrayList<String> known = new ArrayList<String>();
        for (Map.Entry<String, IBackupTransport> entry : this.mTransports.entrySet()) {
            if (entry.getValue() == null) continue;
            known.add(entry.getKey());
        }
        if (known.size() > 0) {
            list = new String[known.size()];
            known.toArray(list);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String selectBackupTransport(String transport) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "selectBackupTransport");
        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
        synchronized (arrayMap) {
            String string2;
            long oldId = Binder.clearCallingIdentity();
            try {
                String prevTransport = this.mCurrentTransport;
                this.mCurrentTransport = transport;
                Settings.Secure.putString(this.mContext.getContentResolver(), "backup_transport", transport);
                Slog.v(TAG, "selectBackupTransport() set " + this.mCurrentTransport + " returning " + prevTransport);
                string2 = prevTransport;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(oldId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(oldId);
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent getConfigurationIntent(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getConfigurationIntent");
        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
        synchronized (arrayMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport != null) {
                try {
                    Intent intent = transport.configurationIntent();
                    return intent;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDestinationString(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDestinationString");
        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
        synchronized (arrayMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport != null) {
                try {
                    String text = transport.currentDestinationString();
                    return text;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent getDataManagementIntent(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDataManagementIntent");
        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
        synchronized (arrayMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport != null) {
                try {
                    Intent intent = transport.dataManagementIntent();
                    return intent;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataManagementLabel(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDataManagementLabel");
        ArrayMap<String, IBackupTransport> arrayMap = this.mTransports;
        synchronized (arrayMap) {
            IBackupTransport transport = this.mTransports.get(transportName);
            if (transport != null) {
                try {
                    String text = transport.dataManagementLabel();
                    return text;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentConnected(String packageName, IBinder agentBinder) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                IBackupAgent agent;
                Slog.d(TAG, "agentConnected pkg=" + packageName + " agent=" + agentBinder);
                this.mConnectedAgent = agent = IBackupAgent.Stub.asInterface(agentBinder);
                this.mConnecting = false;
            } else {
                Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " claiming agent connected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentDisconnected(String packageName) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                this.mConnectedAgent = null;
                this.mConnecting = false;
            } else {
                Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " claiming agent disconnected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    @Override
    public void restoreAtInstall(String packageName, int token) {
        IBackupTransport transport;
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " attemping install-time restore");
            return;
        }
        boolean skip = false;
        long restoreSet = this.getAvailableRestoreToken(packageName);
        Slog.v(TAG, "restoreAtInstall pkg=" + packageName + " token=" + Integer.toHexString(token) + " restoreSet=" + Long.toHexString(restoreSet));
        if (restoreSet == 0L) {
            skip = true;
        }
        if ((transport = this.getTransport(this.mCurrentTransport)) == null) {
            Slog.w(TAG, "No transport");
            skip = true;
        }
        if (!this.mAutoRestore) {
            Slog.w(TAG, "Non-restorable state: auto=" + this.mAutoRestore);
            skip = true;
        }
        if (!skip) {
            try {
                String dirName = transport.transportDirName();
                PackageInfo pkg = new PackageInfo();
                pkg.packageName = packageName;
                this.mWakelock.acquire();
                Message msg = this.mBackupHandler.obtainMessage(3);
                msg.obj = new RestoreParams(transport, dirName, null, restoreSet, pkg, token);
                this.mBackupHandler.sendMessage(msg);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to contact transport");
                skip = true;
            }
        }
        if (skip) {
            Slog.v(TAG, "Finishing install immediately");
            try {
                this.mPackageManagerBinder.finishPackageInstall(token);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRestoreSession beginRestoreSession(String packageName, String transport) {
        Slog.v(TAG, "beginRestoreSession: pkg=" + packageName + " transport=" + transport);
        boolean needPermission = true;
        if (transport == null) {
            transport = this.mCurrentTransport;
            if (packageName != null) {
                PackageInfo app = null;
                try {
                    app = this.mPackageManager.getPackageInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException nnf) {
                    Slog.w(TAG, "Asked to restore nonexistent pkg " + packageName);
                    throw new IllegalArgumentException("Package " + packageName + " not found");
                }
                if (app.applicationInfo.uid == Binder.getCallingUid()) {
                    needPermission = false;
                }
            }
        }
        if (needPermission) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "beginRestoreSession");
        } else {
            Slog.d(TAG, "restoring self on current transport; no permission needed");
        }
        BackupManagerService backupManagerService = this;
        synchronized (backupManagerService) {
            if (this.mActiveRestoreSession != null) {
                Slog.d(TAG, "Restore session requested but one already active");
                return null;
            }
            this.mActiveRestoreSession = new ActiveRestoreSession(packageName, transport);
            this.mBackupHandler.sendEmptyMessageDelayed(8, 60000L);
        }
        return this.mActiveRestoreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRestoreSession(ActiveRestoreSession currentSession) {
        BackupManagerService backupManagerService = this;
        synchronized (backupManagerService) {
            if (currentSession != this.mActiveRestoreSession) {
                Slog.e(TAG, "ending non-current restore session");
            } else {
                Slog.v(TAG, "Clearing restore session and halting timeout");
                this.mActiveRestoreSession = null;
                this.mBackupHandler.removeMessages(8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opComplete(int token) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            op = this.mCurrentOperations.get(token);
            if (op != null) {
                op.state = 1;
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            Message msg = this.mBackupHandler.obtainMessage(21, op.callback);
            this.mBackupHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        long identityToken = Binder.clearCallingIdentity();
        try {
            if (args != null) {
                for (String arg : args) {
                    if ("-h".equals(arg)) {
                        pw.println("'dumpsys backup' optional arguments:");
                        pw.println("  -h       : this help text");
                        pw.println("  a[gents] : dump information about defined backup agents");
                        return;
                    }
                    if (!"agents".startsWith(arg)) continue;
                    this.dumpAgents(pw);
                    return;
                }
            }
            this.dumpInternal(pw);
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
    }

    private void dumpAgents(PrintWriter pw) {
        List<PackageInfo> agentPackages = this.allAgentPackages();
        pw.println("Defined backup agents:");
        for (PackageInfo pkg : agentPackages) {
            pw.print("  ");
            pw.print(pkg.packageName);
            pw.println(':');
            pw.print("      ");
            pw.println(pkg.applicationInfo.backupAgentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(PrintWriter pw) {
        Object object = this.mQueueLock;
        synchronized (object) {
            pw.println("Backup Manager is " + (this.mEnabled ? "enabled" : "disabled") + " / " + (!this.mProvisioned ? "not " : "") + "provisioned / " + (this.mPendingInits.size() == 0 ? "not " : "") + "pending init");
            pw.println("Auto-restore is " + (this.mAutoRestore ? "enabled" : "disabled"));
            if (this.mBackupRunning) {
                pw.println("Backup currently running");
            }
            pw.println("Last backup pass started: " + this.mLastBackupPass + " (now = " + System.currentTimeMillis() + ')');
            pw.println("  next scheduled: " + this.mNextBackupPass);
            pw.println("Available transports:");
            String[] transports = this.listAllTransports();
            if (transports != null) {
                for (String t : this.listAllTransports()) {
                    pw.println((t.equals(this.mCurrentTransport) ? "  * " : "    ") + t);
                    try {
                        IBackupTransport transport = this.getTransport(t);
                        File dir = new File(this.mBaseStateDir, transport.transportDirName());
                        pw.println("       destination: " + transport.currentDestinationString());
                        pw.println("       intent: " + transport.configurationIntent());
                        for (File f : dir.listFiles()) {
                            pw.println("       " + f.getName() + " - " + f.length() + " state bytes");
                        }
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Error in transport", e);
                        pw.println("        Error: " + e);
                    }
                }
            }
            pw.println("Pending init: " + this.mPendingInits.size());
            for (String s : this.mPendingInits) {
                pw.println("    " + s);
            }
            List<String> i$ = this.mBackupTrace;
            synchronized (i$) {
                if (!this.mBackupTrace.isEmpty()) {
                    pw.println("Most recent backup trace:");
                    for (String s : this.mBackupTrace) {
                        pw.println("   " + s);
                    }
                }
            }
            int N = this.mBackupParticipants.size();
            pw.println("Participants:");
            for (int i = 0; i < N; ++i) {
                int uid = this.mBackupParticipants.keyAt(i);
                pw.print("  uid: ");
                pw.println(uid);
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                for (String app : participants) {
                    pw.println("    " + app);
                }
            }
            pw.println("Ancestral packages: " + (this.mAncestralPackages == null ? "none" : Integer.valueOf(this.mAncestralPackages.size())));
            if (this.mAncestralPackages != null) {
                for (String pkg : this.mAncestralPackages) {
                    pw.println("    " + pkg);
                }
            }
            pw.println("Ever backed up: " + this.mEverStoredApps.size());
            for (String pkg : this.mEverStoredApps) {
                pw.println("    " + pkg);
            }
            pw.println("Pending key/value backup: " + this.mPendingBackups.size());
            for (BackupRequest req : this.mPendingBackups.values()) {
                pw.println("    " + req);
            }
            pw.println("Full backup queue:" + this.mFullBackupQueue.size());
            for (FullBackupEntry entry : this.mFullBackupQueue) {
                pw.print("    ");
                pw.print(entry.lastBackup);
                pw.print(" : ");
                pw.println(entry.packageName);
            }
        }
    }

    class ActiveRestoreSession
    extends IRestoreSession.Stub {
        private static final String TAG = "RestoreSession";
        private String mPackageName;
        private IBackupTransport mRestoreTransport = null;
        RestoreSet[] mRestoreSets = null;
        boolean mEnded = false;
        boolean mTimedOut = false;

        ActiveRestoreSession(String packageName, String transport) {
            this.mPackageName = packageName;
            this.mRestoreTransport = BackupManagerService.this.getTransport(transport);
        }

        public void markTimedOut() {
            this.mTimedOut = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int getAvailableRestoreSets(IRestoreObserver observer) {
            BackupManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getAvailableRestoreSets");
            if (observer == null) {
                throw new IllegalArgumentException("Observer must not be null");
            }
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            if (this.mTimedOut) {
                Slog.i(TAG, "Session already timed out");
                return -1;
            }
            long oldId = Binder.clearCallingIdentity();
            try {
                if (this.mRestoreTransport == null) {
                    Slog.w(TAG, "Null transport getting restore sets");
                    int n = -1;
                    return n;
                }
                BackupManagerService.this.mBackupHandler.removeMessages(8);
                BackupManagerService.this.mWakelock.acquire();
                Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(6, new RestoreGetSetsParams(this.mRestoreTransport, this, observer));
                BackupManagerService.this.mBackupHandler.sendMessage(msg);
                int n = 0;
                return n;
            }
            catch (Exception e) {
                Slog.e(TAG, "Error in getAvailableRestoreSets", e);
                int n = -1;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(oldId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int restoreAll(long token, IRestoreObserver observer) {
            String dirName;
            BackupManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
            Slog.d(TAG, "restoreAll token=" + Long.toHexString(token) + " observer=" + observer);
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            if (this.mTimedOut) {
                Slog.i(TAG, "Session already timed out");
                return -1;
            }
            if (this.mRestoreTransport == null || this.mRestoreSets == null) {
                Slog.e(TAG, "Ignoring restoreAll() with no restore set");
                return -1;
            }
            if (this.mPackageName != null) {
                Slog.e(TAG, "Ignoring restoreAll() on single-package session");
                return -1;
            }
            try {
                dirName = this.mRestoreTransport.transportDirName();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to contact transport for restore");
                return -1;
            }
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                for (int i = 0; i < this.mRestoreSets.length; ++i) {
                    if (token != this.mRestoreSets[i].token) continue;
                    BackupManagerService.this.mBackupHandler.removeMessages(8);
                    long oldId = Binder.clearCallingIdentity();
                    BackupManagerService.this.mWakelock.acquire();
                    Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(3);
                    msg.obj = new RestoreParams(this.mRestoreTransport, dirName, observer, token);
                    BackupManagerService.this.mBackupHandler.sendMessage(msg);
                    Binder.restoreCallingIdentity(oldId);
                    return 0;
                }
            }
            Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized int restoreSome(long token, IRestoreObserver observer, String[] packages) {
            String dirName;
            BackupManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
            StringBuilder b = new StringBuilder(128);
            b.append("restoreSome token=");
            b.append(Long.toHexString(token));
            b.append(" observer=");
            b.append(observer.toString());
            b.append(" packages=");
            if (packages == null) {
                b.append("null");
            } else {
                b.append('{');
                boolean first = true;
                for (String s : packages) {
                    if (!first) {
                        b.append(", ");
                    } else {
                        first = false;
                    }
                    b.append(s);
                }
                b.append('}');
            }
            Slog.d(TAG, b.toString());
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            if (this.mTimedOut) {
                Slog.i(TAG, "Session already timed out");
                return -1;
            }
            if (this.mRestoreTransport == null || this.mRestoreSets == null) {
                Slog.e(TAG, "Ignoring restoreAll() with no restore set");
                return -1;
            }
            if (this.mPackageName != null) {
                Slog.e(TAG, "Ignoring restoreAll() on single-package session");
                return -1;
            }
            try {
                dirName = this.mRestoreTransport.transportDirName();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to contact transport for restore");
                return -1;
            }
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                for (int i = 0; i < this.mRestoreSets.length; ++i) {
                    if (token != this.mRestoreSets[i].token) continue;
                    BackupManagerService.this.mBackupHandler.removeMessages(8);
                    long oldId = Binder.clearCallingIdentity();
                    BackupManagerService.this.mWakelock.acquire();
                    Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(3);
                    msg.obj = new RestoreParams(this.mRestoreTransport, dirName, observer, token, packages, packages.length > 1);
                    BackupManagerService.this.mBackupHandler.sendMessage(msg);
                    Binder.restoreCallingIdentity(oldId);
                    return 0;
                }
            }
            Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
            return -1;
        }

        @Override
        public synchronized int restorePackage(String packageName, IRestoreObserver observer) {
            String dirName;
            Slog.v(TAG, "restorePackage pkg=" + packageName + " obs=" + observer);
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            if (this.mTimedOut) {
                Slog.i(TAG, "Session already timed out");
                return -1;
            }
            if (this.mPackageName != null && !this.mPackageName.equals(packageName)) {
                Slog.e(TAG, "Ignoring attempt to restore pkg=" + packageName + " on session for package " + this.mPackageName);
                return -1;
            }
            PackageInfo app = null;
            try {
                app = BackupManagerService.this.mPackageManager.getPackageInfo(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException nnf) {
                Slog.w(TAG, "Asked to restore nonexistent pkg " + packageName);
                return -1;
            }
            int perm = BackupManagerService.this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid());
            if (perm == -1 && app.applicationInfo.uid != Binder.getCallingUid()) {
                Slog.w(TAG, "restorePackage: bad packageName=" + packageName + " or calling uid=" + Binder.getCallingUid());
                throw new SecurityException("No permission to restore other packages");
            }
            long token = BackupManagerService.this.getAvailableRestoreToken(packageName);
            if (token == 0L) {
                Slog.w(TAG, "No data available for this package; not restoring");
                return -1;
            }
            try {
                dirName = this.mRestoreTransport.transportDirName();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Unable to contact transport for restore");
                return -1;
            }
            BackupManagerService.this.mBackupHandler.removeMessages(8);
            long oldId = Binder.clearCallingIdentity();
            BackupManagerService.this.mWakelock.acquire();
            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(3);
            msg.obj = new RestoreParams(this.mRestoreTransport, dirName, observer, token, app, 0);
            BackupManagerService.this.mBackupHandler.sendMessage(msg);
            Binder.restoreCallingIdentity(oldId);
            return 0;
        }

        @Override
        public synchronized void endRestoreSession() {
            Slog.d(TAG, "endRestoreSession");
            if (this.mTimedOut) {
                Slog.i(TAG, "Session already timed out");
                return;
            }
            if (this.mEnded) {
                throw new IllegalStateException("Restore session already ended");
            }
            BackupManagerService.this.mBackupHandler.post(new EndRestoreRunnable(BackupManagerService.this, this));
        }

        class EndRestoreRunnable
        implements Runnable {
            BackupManagerService mBackupManager;
            ActiveRestoreSession mSession;

            EndRestoreRunnable(BackupManagerService manager, ActiveRestoreSession session) {
                this.mBackupManager = manager;
                this.mSession = session;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ActiveRestoreSession activeRestoreSession = this.mSession;
                synchronized (activeRestoreSession) {
                    try {
                        if (this.mSession.mRestoreTransport != null) {
                            this.mSession.mRestoreTransport.finishRestore();
                        }
                    }
                    catch (Exception e) {
                        Slog.e(ActiveRestoreSession.TAG, "Error in finishRestore", e);
                    }
                    finally {
                        this.mSession.mRestoreTransport = null;
                        this.mSession.mEnded = true;
                    }
                }
                this.mBackupManager.clearRestoreSession(this.mSession);
            }
        }
    }

    class PerformInitializeTask
    implements Runnable {
        HashSet<String> mQueue;

        PerformInitializeTask(HashSet<String> transportNames) {
            this.mQueue = transportNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (String transportName : this.mQueue) {
                    IBackupTransport transport = BackupManagerService.this.getTransport(transportName);
                    if (transport == null) {
                        Slog.e(BackupManagerService.TAG, "Requested init for " + transportName + " but not found");
                        continue;
                    }
                    Slog.i(BackupManagerService.TAG, "Initializing (wiping) backup transport storage: " + transportName);
                    EventLog.writeEvent(2821, transport.transportDirName());
                    long startRealtime = SystemClock.elapsedRealtime();
                    int status = transport.initializeDevice();
                    if (status == 0) {
                        status = transport.finishBackup();
                    }
                    if (status == 0) {
                        Slog.i(BackupManagerService.TAG, "Device init successful");
                        int millis = (int)(SystemClock.elapsedRealtime() - startRealtime);
                        EventLog.writeEvent(2827, new Object[0]);
                        BackupManagerService.this.resetBackupState(new File(BackupManagerService.this.mBaseStateDir, transport.transportDirName()));
                        EventLog.writeEvent(2825, 0, millis);
                        Object object = BackupManagerService.this.mQueueLock;
                        synchronized (object) {
                            BackupManagerService.this.recordInitPendingLocked(false, transportName);
                            continue;
                        }
                    }
                    Slog.e(BackupManagerService.TAG, "Transport error in initializeDevice()");
                    EventLog.writeEvent(2822, "(initialize)");
                    Object millis = BackupManagerService.this.mQueueLock;
                    synchronized (millis) {
                        BackupManagerService.this.recordInitPendingLocked(true, transportName);
                    }
                    long delay = transport.requestBackupTime();
                    Slog.w(BackupManagerService.TAG, "init failed on " + transportName + " resched in " + delay);
                    BackupManagerService.this.mAlarmManager.set(0, System.currentTimeMillis() + delay, BackupManagerService.this.mRunInitIntent);
                }
            }
            catch (RemoteException i$) {
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Unexpected error performing init", e);
            }
            finally {
                BackupManagerService.this.mWakelock.release();
            }
        }
    }

    class PerformClearTask
    implements Runnable {
        IBackupTransport mTransport;
        PackageInfo mPackage;

        PerformClearTask(IBackupTransport transport, PackageInfo packageInfo) {
            this.mTransport = transport;
            this.mPackage = packageInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                File stateDir = new File(BackupManagerService.this.mBaseStateDir, this.mTransport.transportDirName());
                File stateFile = new File(stateDir, this.mPackage.packageName);
                stateFile.delete();
                this.mTransport.clearBackupData(this.mPackage);
            }
            catch (RemoteException stateDir) {
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Transport threw attempting to clear data for " + this.mPackage);
            }
            finally {
                try {
                    this.mTransport.finishBackup();
                }
                catch (RemoteException remoteException) {}
                BackupManagerService.this.mWakelock.release();
            }
        }
    }

    class PerformUnifiedRestoreTask
    implements BackupRestoreTask {
        private IBackupTransport mTransport;
        File mStateDir;
        private IRestoreObserver mObserver;
        private long mToken;
        private int mPmToken;
        private boolean mIsSystemRestore;
        private PackageInfo mTargetPackage;
        private List<PackageInfo> mAcceptSet;
        private PackageManagerBackupAgent mPmAgent;
        private IBackupAgent mAgent;
        private RestoreDescription mRestoreDescription;
        private PackageInfo mCurrentPackage;
        private byte[] mWidgetData;
        private int mCount;
        private long mStartRealtime;
        private UnifiedRestoreState mState = UnifiedRestoreState.INITIAL;
        private int mStatus;
        private boolean mFinished;
        private File mBackupDataName;
        private File mStageName;
        private File mSavedStateName;
        private File mNewStateName;
        ParcelFileDescriptor mBackupData;
        ParcelFileDescriptor mNewState;

        PerformUnifiedRestoreTask(IBackupTransport transport, IRestoreObserver observer, long restoreSetToken, PackageInfo targetPackage, int pmToken, boolean isFullSystemRestore, String[] filterSet) {
            this.mStartRealtime = SystemClock.elapsedRealtime();
            this.mTransport = transport;
            this.mObserver = observer;
            this.mToken = restoreSetToken;
            this.mPmToken = pmToken;
            this.mTargetPackage = targetPackage;
            this.mIsSystemRestore = isFullSystemRestore;
            this.mFinished = false;
            if (targetPackage != null) {
                this.mAcceptSet = new ArrayList<PackageInfo>();
                this.mAcceptSet.add(targetPackage);
            } else {
                if (filterSet == null) {
                    List<PackageInfo> apps = PackageManagerBackupAgent.getStorableApplications(BackupManagerService.this.mPackageManager);
                    filterSet = this.packagesToNames(apps);
                    Slog.i(BackupManagerService.TAG, "Full restore; asking for " + filterSet.length + " apps");
                }
                this.mAcceptSet = new ArrayList<PackageInfo>(filterSet.length);
                boolean hasSystem = false;
                boolean hasSettings = false;
                for (int i = 0; i < filterSet.length; ++i) {
                    try {
                        PackageInfo info = BackupManagerService.this.mPackageManager.getPackageInfo(filterSet[i], 0);
                        if ("android".equals(info.packageName)) {
                            hasSystem = true;
                            continue;
                        }
                        if (BackupManagerService.SETTINGS_PACKAGE.equals(info.packageName)) {
                            hasSettings = true;
                            continue;
                        }
                        if (!BackupManagerService.appIsEligibleForBackup(info.applicationInfo)) continue;
                        this.mAcceptSet.add(info);
                        continue;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                if (hasSystem) {
                    try {
                        this.mAcceptSet.add(0, BackupManagerService.this.mPackageManager.getPackageInfo("android", 0));
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                if (hasSettings) {
                    try {
                        this.mAcceptSet.add(BackupManagerService.this.mPackageManager.getPackageInfo(BackupManagerService.SETTINGS_PACKAGE, 0));
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }

        private String[] packagesToNames(List<PackageInfo> apps) {
            int N = apps.size();
            String[] names = new String[N];
            for (int i = 0; i < N; ++i) {
                names[i] = apps.get((int)i).packageName;
            }
            return names;
        }

        @Override
        public void execute() {
            switch (this.mState) {
                case INITIAL: {
                    this.startRestore();
                    break;
                }
                case RUNNING_QUEUE: {
                    this.dispatchNextRestore();
                    break;
                }
                case RESTORE_KEYVALUE: {
                    this.restoreKeyValue();
                    break;
                }
                case RESTORE_FULL: {
                    this.restoreFull();
                    break;
                }
                case RESTORE_FINISHED: {
                    this.restoreFinished();
                    break;
                }
                case FINAL: {
                    if (!this.mFinished) {
                        this.finalizeRestore();
                    } else {
                        Slog.e(BackupManagerService.TAG, "Duplicate finish");
                    }
                    this.mFinished = true;
                }
            }
        }

        private void startRestore() {
            this.sendStartRestore(this.mAcceptSet.size());
            if (this.mIsSystemRestore) {
                AppWidgetBackupBridge.restoreStarting(0);
            }
            try {
                String transportDir = this.mTransport.transportDirName();
                this.mStateDir = new File(BackupManagerService.this.mBaseStateDir, transportDir);
                PackageInfo pmPackage = new PackageInfo();
                pmPackage.packageName = BackupManagerService.PACKAGE_MANAGER_SENTINEL;
                this.mAcceptSet.add(0, pmPackage);
                PackageInfo[] packages = this.mAcceptSet.toArray(new PackageInfo[0]);
                this.mStatus = this.mTransport.startRestore(this.mToken, packages);
                if (this.mStatus != 0) {
                    Slog.e(BackupManagerService.TAG, "Transport error " + this.mStatus + "; no restore possible");
                    this.mStatus = -1000;
                    this.executeNextState(UnifiedRestoreState.FINAL);
                    return;
                }
                RestoreDescription desc = this.mTransport.nextRestorePackage();
                if (desc == null) {
                    Slog.e(BackupManagerService.TAG, "No restore metadata available; halting");
                    this.mStatus = -1000;
                    this.executeNextState(UnifiedRestoreState.FINAL);
                    return;
                }
                if (!BackupManagerService.PACKAGE_MANAGER_SENTINEL.equals(desc.getPackageName())) {
                    Slog.e(BackupManagerService.TAG, "Required metadata but got " + desc.getPackageName());
                    this.mStatus = -1000;
                    this.executeNextState(UnifiedRestoreState.FINAL);
                    return;
                }
                this.mCurrentPackage = new PackageInfo();
                this.mCurrentPackage.packageName = BackupManagerService.PACKAGE_MANAGER_SENTINEL;
                this.mPmAgent = new PackageManagerBackupAgent(BackupManagerService.this.mPackageManager, null);
                this.mAgent = IBackupAgent.Stub.asInterface(this.mPmAgent.onBind());
                this.initiateOneRestore(this.mCurrentPackage, 0);
                if (!this.mPmAgent.hasMetadata()) {
                    Slog.e(BackupManagerService.TAG, "No restore metadata available, so not restoring");
                    EventLog.writeEvent(2832, BackupManagerService.PACKAGE_MANAGER_SENTINEL, "Package manager restore metadata missing");
                    this.mStatus = -1000;
                    BackupManagerService.this.mBackupHandler.removeMessages(20, this);
                    this.executeNextState(UnifiedRestoreState.FINAL);
                    return;
                }
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Unable to contact transport for restore");
                this.mStatus = -1000;
                BackupManagerService.this.mBackupHandler.removeMessages(20, this);
                this.executeNextState(UnifiedRestoreState.FINAL);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchNextRestore() {
            block19: {
                UnifiedRestoreState nextState = UnifiedRestoreState.FINAL;
                try {
                    String pkgName;
                    this.mRestoreDescription = this.mTransport.nextRestorePackage();
                    String string2 = pkgName = this.mRestoreDescription != null ? this.mRestoreDescription.getPackageName() : null;
                    if (pkgName == null) {
                        Slog.e(BackupManagerService.TAG, "Failure getting next package name");
                        EventLog.writeEvent(2831, new Object[0]);
                        nextState = UnifiedRestoreState.FINAL;
                        return;
                    }
                    if (this.mRestoreDescription == RestoreDescription.NO_MORE_PACKAGES) {
                        Slog.v(BackupManagerService.TAG, "No more packages; finishing restore");
                        int millis = (int)(SystemClock.elapsedRealtime() - this.mStartRealtime);
                        EventLog.writeEvent(2834, this.mCount, millis);
                        nextState = UnifiedRestoreState.FINAL;
                        return;
                    }
                    Slog.i(BackupManagerService.TAG, "Next restore package: " + this.mRestoreDescription);
                    this.sendOnRestorePackage(pkgName);
                    PackageManagerBackupAgent.Metadata metaInfo = this.mPmAgent.getRestoredMetadata(pkgName);
                    if (metaInfo == null) {
                        Slog.e(BackupManagerService.TAG, "No metadata for " + pkgName);
                        EventLog.writeEvent(2832, pkgName, "Package metadata missing");
                        nextState = UnifiedRestoreState.RUNNING_QUEUE;
                        return;
                    }
                    try {
                        this.mCurrentPackage = BackupManagerService.this.mPackageManager.getPackageInfo(pkgName, 64);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.e(BackupManagerService.TAG, "Package not present: " + pkgName);
                        EventLog.writeEvent(2832, pkgName, "Package missing on device");
                        nextState = UnifiedRestoreState.RUNNING_QUEUE;
                        this.executeNextState(nextState);
                        return;
                    }
                    if (metaInfo.versionCode > this.mCurrentPackage.versionCode) {
                        if ((this.mCurrentPackage.applicationInfo.flags & 0x20000) == 0) {
                            String message = "Version " + metaInfo.versionCode + " > installed version " + this.mCurrentPackage.versionCode;
                            Slog.w(BackupManagerService.TAG, "Package " + pkgName + ": " + message);
                            EventLog.writeEvent(2832, pkgName, message);
                            nextState = UnifiedRestoreState.RUNNING_QUEUE;
                            return;
                        }
                        Slog.v(BackupManagerService.TAG, "Version " + metaInfo.versionCode + " > installed " + this.mCurrentPackage.versionCode + " but restoreAnyVersion");
                    }
                    Slog.v(BackupManagerService.TAG, "Package " + pkgName + " restore version [" + metaInfo.versionCode + "] is compatible with installed version [" + this.mCurrentPackage.versionCode + "]");
                    this.mWidgetData = null;
                    int type = this.mRestoreDescription.getDataType();
                    if (type == 1) {
                        nextState = UnifiedRestoreState.RESTORE_KEYVALUE;
                        break block19;
                    }
                    if (type == 2) {
                        nextState = UnifiedRestoreState.RESTORE_FULL;
                        break block19;
                    }
                    Slog.e(BackupManagerService.TAG, "Unrecognized restore type " + type);
                    nextState = UnifiedRestoreState.RUNNING_QUEUE;
                    return;
                }
                catch (RemoteException e) {
                    Slog.e(BackupManagerService.TAG, "Can't get next target from transport; ending restore");
                    EventLog.writeEvent(2831, new Object[0]);
                    nextState = UnifiedRestoreState.FINAL;
                    return;
                }
                finally {
                    this.executeNextState(nextState);
                }
            }
        }

        private void restoreKeyValue() {
            String packageName = this.mCurrentPackage.packageName;
            if (this.mCurrentPackage.applicationInfo.backupAgentName == null || "".equals(this.mCurrentPackage.applicationInfo.backupAgentName)) {
                Slog.i(BackupManagerService.TAG, "Data exists for package " + packageName + " but app has no agent; skipping");
                EventLog.writeEvent(2832, packageName, "Package has no agent");
                this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
                return;
            }
            PackageManagerBackupAgent.Metadata metaInfo = this.mPmAgent.getRestoredMetadata(packageName);
            if (!BackupManagerService.signaturesMatch(metaInfo.sigHashes, this.mCurrentPackage)) {
                Slog.w(BackupManagerService.TAG, "Signature mismatch restoring " + packageName);
                EventLog.writeEvent(2832, packageName, "Signature mismatch");
                this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
                return;
            }
            this.mAgent = BackupManagerService.this.bindToAgentSynchronous(this.mCurrentPackage.applicationInfo, 0);
            if (this.mAgent == null) {
                Slog.w(BackupManagerService.TAG, "Can't find backup agent for " + packageName);
                EventLog.writeEvent(2832, packageName, "Restore agent missing");
                this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
                return;
            }
            try {
                this.initiateOneRestore(this.mCurrentPackage, metaInfo.versionCode);
                ++this.mCount;
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Error when attempting restore: " + e.toString());
                this.keyValueAgentErrorCleanup();
                this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
            }
        }

        void initiateOneRestore(PackageInfo app, int appVersionCode) {
            String packageName = app.packageName;
            Slog.d(BackupManagerService.TAG, "initiateOneRestore packageName=" + packageName);
            this.mBackupDataName = new File(BackupManagerService.this.mDataDir, packageName + ".restore");
            this.mStageName = new File(BackupManagerService.this.mDataDir, packageName + ".stage");
            this.mNewStateName = new File(this.mStateDir, packageName + ".new");
            this.mSavedStateName = new File(this.mStateDir, packageName);
            boolean staging = !packageName.equals("android");
            File downloadFile = staging ? this.mStageName : this.mBackupDataName;
            int token = BackupManagerService.this.generateToken();
            try {
                ParcelFileDescriptor stage = ParcelFileDescriptor.open(downloadFile, 0x3C000000);
                if (!SELinux.restorecon(this.mBackupDataName)) {
                    Slog.e(BackupManagerService.TAG, "SElinux restorecon failed for " + downloadFile);
                }
                if (this.mTransport.getRestoreData(stage) != 0) {
                    Slog.e(BackupManagerService.TAG, "Error getting restore data for " + packageName);
                    EventLog.writeEvent(2831, new Object[0]);
                    stage.close();
                    downloadFile.delete();
                    this.executeNextState(UnifiedRestoreState.FINAL);
                    return;
                }
                if (staging) {
                    stage.close();
                    stage = ParcelFileDescriptor.open(downloadFile, 0x10000000);
                    this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x3C000000);
                    BackupDataInput in = new BackupDataInput(stage.getFileDescriptor());
                    BackupDataOutput out = new BackupDataOutput(this.mBackupData.getFileDescriptor());
                    byte[] buffer = new byte[8192];
                    while (in.readNextHeader()) {
                        String key = in.getKey();
                        int size = in.getDataSize();
                        if (key.equals(BackupManagerService.KEY_WIDGET_STATE)) {
                            Slog.i(BackupManagerService.TAG, "Restoring widget state for " + packageName);
                            this.mWidgetData = new byte[size];
                            in.readEntityData(this.mWidgetData, 0, size);
                            continue;
                        }
                        if (size > buffer.length) {
                            buffer = new byte[size];
                        }
                        in.readEntityData(buffer, 0, size);
                        out.writeEntityHeader(key, size);
                        out.writeEntityData(buffer, size);
                    }
                    this.mBackupData.close();
                }
                stage.close();
                this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
                this.mNewState = ParcelFileDescriptor.open(this.mNewStateName, 0x3C000000);
                BackupManagerService.this.prepareOperationTimeout(token, 60000L, this);
                this.mAgent.doRestore(this.mBackupData, appVersionCode, this.mNewState, token, BackupManagerService.this.mBackupManagerBinder);
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Unable to call app for restore: " + packageName, e);
                EventLog.writeEvent(2832, packageName, e.toString());
                this.keyValueAgentErrorCleanup();
                this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
            }
        }

        private void restoreFull() {
            try {
                StreamFeederThread feeder = new StreamFeederThread();
                Slog.i(BackupManagerService.TAG, "Spinning threads for stream restore of " + this.mCurrentPackage.packageName);
                new Thread((Runnable)feeder, "unified-stream-feeder").start();
            }
            catch (IOException e) {
                Slog.e(BackupManagerService.TAG, "Unable to construct pipes for stream restore!");
                this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
            }
        }

        private void restoreFinished() {
            try {
                int token = BackupManagerService.this.generateToken();
                BackupManagerService.this.prepareOperationTimeout(token, 30000L, this);
                this.mAgent.doRestoreFinished(token, BackupManagerService.this.mBackupManagerBinder);
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Unable to finalize restore of " + this.mCurrentPackage.packageName);
                this.executeNextState(UnifiedRestoreState.FINAL);
            }
        }

        private void finalizeRestore() {
            try {
                this.mTransport.finishRestore();
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Error finishing restore", e);
            }
            if (this.mObserver != null) {
                try {
                    this.mObserver.restoreFinished(this.mStatus);
                }
                catch (RemoteException e) {
                    Slog.d(BackupManagerService.TAG, "Restore observer died at restoreFinished");
                }
            }
            BackupManagerService.this.mBackupHandler.removeMessages(8);
            if (this.mPmToken > 0) {
                try {
                    BackupManagerService.this.mPackageManagerBinder.finishPackageInstall(this.mPmToken);
                }
                catch (RemoteException remoteException) {}
            } else {
                BackupManagerService.this.mBackupHandler.sendEmptyMessageDelayed(8, 60000L);
            }
            AppWidgetBackupBridge.restoreFinished(0);
            if (this.mIsSystemRestore) {
                BackupManagerService.this.mAncestralPackages = this.mPmAgent.getRestoredPackages();
                BackupManagerService.this.mAncestralToken = this.mToken;
                BackupManagerService.this.writeRestoreTokens();
            }
            Slog.i(BackupManagerService.TAG, "Restore complete.");
            BackupManagerService.this.mWakelock.release();
        }

        void keyValueAgentErrorCleanup() {
            BackupManagerService.this.clearApplicationDataSynchronous(this.mCurrentPackage.packageName);
            this.keyValueAgentCleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void keyValueAgentCleanup() {
            this.mBackupDataName.delete();
            this.mStageName.delete();
            try {
                if (this.mBackupData != null) {
                    this.mBackupData.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.mNewState != null) {
                    this.mNewState.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mNewState = null;
            this.mBackupData = null;
            this.mNewStateName.delete();
            if (this.mCurrentPackage.applicationInfo != null) {
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(this.mCurrentPackage.applicationInfo);
                    if (this.mTargetPackage == null && (this.mCurrentPackage.applicationInfo.flags & 0x10000) != 0) {
                        Slog.d(BackupManagerService.TAG, "Restore complete, killing host process of " + this.mCurrentPackage.applicationInfo.processName);
                        BackupManagerService.this.mActivityManager.killApplicationProcess(this.mCurrentPackage.applicationInfo.processName, this.mCurrentPackage.applicationInfo.uid);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            BackupManagerService.this.mBackupHandler.removeMessages(7, this);
            Object object = BackupManagerService.this.mCurrentOpLock;
            synchronized (object) {
                BackupManagerService.this.mCurrentOperations.clear();
            }
        }

        @Override
        public void operationComplete() {
            UnifiedRestoreState nextState;
            switch (this.mState) {
                case INITIAL: {
                    nextState = UnifiedRestoreState.RUNNING_QUEUE;
                    break;
                }
                case RESTORE_KEYVALUE: 
                case RESTORE_FULL: {
                    nextState = UnifiedRestoreState.RESTORE_FINISHED;
                    break;
                }
                case RESTORE_FINISHED: {
                    int size = (int)this.mBackupDataName.length();
                    EventLog.writeEvent(2833, this.mCurrentPackage.packageName, size);
                    this.keyValueAgentCleanup();
                    if (this.mWidgetData != null) {
                        BackupManagerService.this.restoreWidgetData(this.mCurrentPackage.packageName, this.mWidgetData);
                    }
                    nextState = UnifiedRestoreState.RUNNING_QUEUE;
                    break;
                }
                default: {
                    Slog.e(BackupManagerService.TAG, "Unexpected restore callback into state " + (Object)((Object)this.mState));
                    this.keyValueAgentErrorCleanup();
                    nextState = UnifiedRestoreState.FINAL;
                }
            }
            this.executeNextState(nextState);
        }

        @Override
        public void handleTimeout() {
            Slog.e(BackupManagerService.TAG, "Timeout restoring application " + this.mCurrentPackage.packageName);
            EventLog.writeEvent(2832, this.mCurrentPackage.packageName, "restore timeout");
            this.keyValueAgentErrorCleanup();
            this.executeNextState(UnifiedRestoreState.RUNNING_QUEUE);
        }

        void executeNextState(UnifiedRestoreState nextState) {
            this.mState = nextState;
            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(20, this);
            BackupManagerService.this.mBackupHandler.sendMessage(msg);
        }

        void sendStartRestore(int numPackages) {
            if (this.mObserver != null) {
                try {
                    this.mObserver.restoreStarting(numPackages);
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "Restore observer went away: startRestore");
                    this.mObserver = null;
                }
            }
        }

        void sendOnRestorePackage(String name) {
            if (this.mObserver != null && this.mObserver != null) {
                try {
                    this.mObserver.onUpdate(this.mCount, name);
                }
                catch (RemoteException e) {
                    Slog.d(BackupManagerService.TAG, "Restore observer died in onUpdate");
                    this.mObserver = null;
                }
            }
        }

        void sendEndRestore() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.restoreFinished(this.mStatus);
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "Restore observer went away: endRestore");
                    this.mObserver = null;
                }
            }
        }

        class EngineThread
        implements Runnable {
            FullRestoreEngine mEngine;
            FileInputStream mEngineStream;

            EngineThread(FullRestoreEngine engine, ParcelFileDescriptor engineSocket) {
                this.mEngine = engine;
                engine.setRunning(true);
                this.mEngineStream = new FileInputStream(engineSocket.getFileDescriptor());
            }

            public boolean isRunning() {
                return this.mEngine.isRunning();
            }

            public int waitForResult() {
                return this.mEngine.waitForResult();
            }

            @Override
            public void run() {
                while (this.mEngine.isRunning()) {
                    this.mEngine.restoreOneFile(this.mEngineStream);
                }
            }
        }

        class StreamFeederThread
        extends RestoreEngine
        implements Runnable {
            final String TAG = "StreamFeederThread";
            FullRestoreEngine mEngine;
            ParcelFileDescriptor[] mTransportPipes;
            ParcelFileDescriptor[] mEnginePipes;

            public StreamFeederThread() throws IOException {
                this.TAG = "StreamFeederThread";
                this.mTransportPipes = ParcelFileDescriptor.createPipe();
                this.mEnginePipes = ParcelFileDescriptor.createPipe();
                this.setRunning(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                UnifiedRestoreState nextState = UnifiedRestoreState.RUNNING_QUEUE;
                int status = 0;
                EventLog.writeEvent(2844, ((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                this.mEngine = new FullRestoreEngine(null, PerformUnifiedRestoreTask.this.mCurrentPackage, false, false);
                EngineThread eThread = new EngineThread(this.mEngine, this.mEnginePipes[0]);
                ParcelFileDescriptor eWriteEnd = this.mEnginePipes[1];
                ParcelFileDescriptor tReadEnd = this.mTransportPipes[0];
                ParcelFileDescriptor tWriteEnd = this.mTransportPipes[1];
                int bufferSize = 32768;
                byte[] buffer = new byte[bufferSize];
                FileOutputStream engineOut = new FileOutputStream(eWriteEnd.getFileDescriptor());
                FileInputStream transportIn = new FileInputStream(tReadEnd.getFileDescriptor());
                new Thread((Runnable)eThread, "unified-restore-engine").start();
                try {
                    block15: while (status == 0) {
                        int result = PerformUnifiedRestoreTask.this.mTransport.getNextFullRestoreDataChunk(tWriteEnd);
                        if (result > 0) {
                            if (result > bufferSize) {
                                bufferSize = result;
                                buffer = new byte[bufferSize];
                            }
                            int toCopy = result;
                            while (true) {
                                if (toCopy <= 0) continue block15;
                                int n = transportIn.read(buffer, 0, toCopy);
                                engineOut.write(buffer, 0, n);
                                toCopy -= n;
                            }
                        }
                        if (result == -1) {
                            status = 0;
                            return;
                        }
                        Slog.e("StreamFeederThread", "Error " + result + " streaming restore for " + ((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                        EventLog.writeEvent(2831, new Object[0]);
                        status = result;
                    }
                    return;
                }
                catch (IOException e) {
                    Slog.e("StreamFeederThread", "Unable to route data for restore");
                    EventLog.writeEvent(2832, ((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName, "I/O error on pipes");
                    status = -1003;
                    return;
                }
                catch (RemoteException e) {
                    Slog.e("StreamFeederThread", "Transport failed during restore");
                    EventLog.writeEvent(2831, new Object[0]);
                    status = -1000;
                    return;
                }
                finally {
                    IoUtils.closeQuietly(this.mEnginePipes[1]);
                    IoUtils.closeQuietly(this.mTransportPipes[0]);
                    IoUtils.closeQuietly(this.mTransportPipes[1]);
                    eThread.waitForResult();
                    IoUtils.closeQuietly(this.mEnginePipes[0]);
                    if (status == 0) {
                        nextState = UnifiedRestoreState.RUNNING_QUEUE;
                    } else {
                        try {
                            PerformUnifiedRestoreTask.this.mTransport.abortFullRestore();
                        }
                        catch (RemoteException e) {
                            status = -1000;
                        }
                        BackupManagerService.this.clearApplicationDataSynchronous(((PerformUnifiedRestoreTask)PerformUnifiedRestoreTask.this).mCurrentPackage.packageName);
                        nextState = status == -1000 ? UnifiedRestoreState.FINAL : UnifiedRestoreState.RUNNING_QUEUE;
                    }
                    PerformUnifiedRestoreTask.this.executeNextState(nextState);
                    this.setRunning(false);
                }
            }
        }
    }

    static enum UnifiedRestoreState {
        INITIAL,
        RUNNING_QUEUE,
        RESTORE_KEYVALUE,
        RESTORE_FULL,
        RESTORE_FINISHED,
        FINAL;

    }

    class PerformAdbRestoreTask
    implements Runnable {
        ParcelFileDescriptor mInputFile;
        String mCurrentPassword;
        String mDecryptPassword;
        IFullBackupRestoreObserver mObserver;
        AtomicBoolean mLatchObject;
        IBackupAgent mAgent;
        String mAgentPackage;
        ApplicationInfo mTargetApp;
        FullBackupObbConnection mObbConnection = null;
        ParcelFileDescriptor[] mPipes = null;
        byte[] mWidgetData = null;
        long mBytes;
        final HashMap<String, RestorePolicy> mPackagePolicies = new HashMap();
        final HashMap<String, String> mPackageInstallers = new HashMap();
        final HashMap<String, Signature[]> mManifestSignatures = new HashMap();
        final HashSet<String> mClearedPackages = new HashSet();
        final RestoreInstallObserver mInstallObserver = new RestoreInstallObserver();
        final RestoreDeleteObserver mDeleteObserver = new RestoreDeleteObserver();

        PerformAdbRestoreTask(ParcelFileDescriptor fd, String curPassword, String decryptPassword, IFullBackupRestoreObserver observer, AtomicBoolean latch) {
            this.mInputFile = fd;
            this.mCurrentPassword = curPassword;
            this.mDecryptPassword = decryptPassword;
            this.mObserver = observer;
            this.mLatchObject = latch;
            this.mAgent = null;
            this.mAgentPackage = null;
            this.mTargetApp = null;
            this.mObbConnection = new FullBackupObbConnection();
            this.mClearedPackages.add("android");
            this.mClearedPackages.add(BackupManagerService.SETTINGS_PACKAGE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Slog.i(BackupManagerService.TAG, "--- Performing full-dataset restore ---");
            this.mObbConnection.establish();
            this.sendStartRestore();
            if (Environment.getExternalStorageState().equals("mounted")) {
                this.mPackagePolicies.put(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE, RestorePolicy.ACCEPT);
            }
            FileInputStream rawInStream = null;
            FilterInputStream rawDataIn = null;
            try {
                boolean didRestore;
                InputStream in;
                if (!BackupManagerService.this.backupPasswordMatches(this.mCurrentPassword)) {
                    Slog.w(BackupManagerService.TAG, "Backup password mismatch; aborting");
                    return;
                }
                this.mBytes = 0L;
                byte[] buffer = new byte[32768];
                rawInStream = new FileInputStream(this.mInputFile.getFileDescriptor());
                rawDataIn = new DataInputStream(rawInStream);
                boolean compressed = false;
                InputStream preCompressStream = rawInStream;
                boolean okay = false;
                int headerLen = BackupManagerService.BACKUP_FILE_HEADER_MAGIC.length();
                byte[] streamHeader = new byte[headerLen];
                ((DataInputStream)rawDataIn).readFully(streamHeader);
                byte[] magicBytes = BackupManagerService.BACKUP_FILE_HEADER_MAGIC.getBytes("UTF-8");
                if (Arrays.equals(magicBytes, streamHeader)) {
                    String s = this.readHeaderLine(rawInStream);
                    int archiveVersion = Integer.parseInt(s);
                    if (archiveVersion <= 3) {
                        boolean pbkdf2Fallback = archiveVersion == 1;
                        s = this.readHeaderLine(rawInStream);
                        compressed = Integer.parseInt(s) != 0;
                        s = this.readHeaderLine(rawInStream);
                        if (s.equals("none")) {
                            okay = true;
                        } else if (this.mDecryptPassword != null && this.mDecryptPassword.length() > 0) {
                            preCompressStream = this.decodeAesHeaderAndInitialize(s, pbkdf2Fallback, rawInStream);
                            if (preCompressStream != null) {
                                okay = true;
                            }
                        } else {
                            Slog.w(BackupManagerService.TAG, "Archive is encrypted but no password given");
                        }
                    } else {
                        Slog.w(BackupManagerService.TAG, "Wrong header version: " + s);
                    }
                } else {
                    Slog.w(BackupManagerService.TAG, "Didn't read the right header magic");
                }
                if (!okay) {
                    Slog.w(BackupManagerService.TAG, "Invalid restore data; aborting.");
                    return;
                }
                InputStream inputStream = in = compressed ? new InflaterInputStream(preCompressStream) : preCompressStream;
                while (didRestore = this.restoreOneFile(in, buffer)) {
                }
            }
            catch (IOException e) {
                Slog.e(BackupManagerService.TAG, "Unable to read restore input");
            }
            finally {
                this.tearDownPipes();
                this.tearDownAgent(this.mTargetApp);
                try {
                    if (rawDataIn != null) {
                        rawDataIn.close();
                    }
                    if (rawInStream != null) {
                        rawInStream.close();
                    }
                    this.mInputFile.close();
                }
                catch (IOException e) {
                    Slog.w(BackupManagerService.TAG, "Close of restore data pipe threw", e);
                }
                Object object = BackupManagerService.this.mCurrentOpLock;
                synchronized (object) {
                    BackupManagerService.this.mCurrentOperations.clear();
                }
                object = this.mLatchObject;
                synchronized (object) {
                    this.mLatchObject.set(true);
                    this.mLatchObject.notifyAll();
                }
                this.mObbConnection.tearDown();
                this.sendEndRestore();
                Slog.d(BackupManagerService.TAG, "Full restore pass complete.");
                BackupManagerService.this.mWakelock.release();
            }
        }

        String readHeaderLine(InputStream in) throws IOException {
            int c;
            StringBuilder buffer = new StringBuilder(80);
            while ((c = in.read()) >= 0 && c != 10) {
                buffer.append((char)c);
            }
            return buffer.toString();
        }

        InputStream attemptMasterKeyDecryption(String algorithm, byte[] userSalt, byte[] ckSalt, int rounds, String userIvHex, String masterKeyBlobHex, InputStream rawInStream, boolean doLog) {
            CipherInputStream result;
            block15: {
                result = null;
                try {
                    Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
                    SecretKey userKey = BackupManagerService.this.buildPasswordKey(algorithm, this.mDecryptPassword, userSalt, rounds);
                    byte[] IV = BackupManagerService.this.hexToByteArray(userIvHex);
                    IvParameterSpec ivSpec = new IvParameterSpec(IV);
                    c.init(2, (Key)new SecretKeySpec(userKey.getEncoded(), "AES"), ivSpec);
                    byte[] mkCipher = BackupManagerService.this.hexToByteArray(masterKeyBlobHex);
                    byte[] mkBlob = c.doFinal(mkCipher);
                    int offset = 0;
                    byte len = mkBlob[offset++];
                    IV = Arrays.copyOfRange(mkBlob, offset, offset + len);
                    offset += len;
                    len = mkBlob[offset++];
                    byte[] mk = Arrays.copyOfRange(mkBlob, offset, offset + len);
                    offset += len;
                    len = mkBlob[offset++];
                    byte[] mkChecksum = Arrays.copyOfRange(mkBlob, offset, offset + len);
                    byte[] calculatedCk = BackupManagerService.this.makeKeyChecksum(algorithm, mk, ckSalt, rounds);
                    if (Arrays.equals(calculatedCk, mkChecksum)) {
                        ivSpec = new IvParameterSpec(IV);
                        c.init(2, (Key)new SecretKeySpec(mk, "AES"), ivSpec);
                        result = new CipherInputStream(rawInStream, c);
                    } else if (doLog) {
                        Slog.w(BackupManagerService.TAG, "Incorrect password");
                    }
                }
                catch (InvalidAlgorithmParameterException e) {
                    if (doLog) {
                        Slog.e(BackupManagerService.TAG, "Needed parameter spec unavailable!", e);
                    }
                }
                catch (BadPaddingException e) {
                    if (doLog) {
                        Slog.w(BackupManagerService.TAG, "Incorrect password");
                    }
                }
                catch (IllegalBlockSizeException e) {
                    if (doLog) {
                        Slog.w(BackupManagerService.TAG, "Invalid block size in master key");
                    }
                }
                catch (NoSuchAlgorithmException e) {
                    if (doLog) {
                        Slog.e(BackupManagerService.TAG, "Needed decryption algorithm unavailable!");
                    }
                }
                catch (NoSuchPaddingException e) {
                    if (doLog) {
                        Slog.e(BackupManagerService.TAG, "Needed padding mechanism unavailable!");
                    }
                }
                catch (InvalidKeyException e) {
                    if (!doLog) break block15;
                    Slog.w(BackupManagerService.TAG, "Illegal password; aborting");
                }
            }
            return result;
        }

        InputStream decodeAesHeaderAndInitialize(String encryptionName, boolean pbkdf2Fallback, InputStream rawInStream) {
            InputStream result = null;
            try {
                if (encryptionName.equals(BackupManagerService.ENCRYPTION_ALGORITHM_NAME)) {
                    String masterKeyBlobHex;
                    String userIvHex;
                    int rounds;
                    String ckSaltHex;
                    byte[] ckSalt;
                    String userSaltHex = this.readHeaderLine(rawInStream);
                    byte[] userSalt = BackupManagerService.this.hexToByteArray(userSaltHex);
                    result = this.attemptMasterKeyDecryption(BackupManagerService.PBKDF_CURRENT, userSalt, ckSalt = BackupManagerService.this.hexToByteArray(ckSaltHex = this.readHeaderLine(rawInStream)), rounds = Integer.parseInt(this.readHeaderLine(rawInStream)), userIvHex = this.readHeaderLine(rawInStream), masterKeyBlobHex = this.readHeaderLine(rawInStream), rawInStream, false);
                    if (result == null && pbkdf2Fallback) {
                        result = this.attemptMasterKeyDecryption(BackupManagerService.PBKDF_FALLBACK, userSalt, ckSalt, rounds, userIvHex, masterKeyBlobHex, rawInStream, true);
                    }
                } else {
                    Slog.w(BackupManagerService.TAG, "Unsupported encryption method: " + encryptionName);
                }
            }
            catch (NumberFormatException e) {
                Slog.w(BackupManagerService.TAG, "Can't parse restore data header");
            }
            catch (IOException e) {
                Slog.w(BackupManagerService.TAG, "Can't read input header");
            }
            return result;
        }

        boolean restoreOneFile(InputStream instream, byte[] buffer) {
            FileMetadata info;
            block42: {
                try {
                    long nRead;
                    info = this.readTarHeaders(instream);
                    if (info == null) break block42;
                    String pkg = info.packageName;
                    if (!pkg.equals(this.mAgentPackage)) {
                        if (!this.mPackagePolicies.containsKey(pkg)) {
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                        if (this.mAgent != null) {
                            Slog.d(BackupManagerService.TAG, "Saw new package; finalizing old one");
                            this.tearDownPipes();
                            this.tearDownAgent(this.mTargetApp);
                            this.mTargetApp = null;
                            this.mAgentPackage = null;
                        }
                    }
                    if (info.path.equals(BackupManagerService.BACKUP_MANIFEST_FILENAME)) {
                        this.mPackagePolicies.put(pkg, this.readAppManifest(info, instream));
                        this.mPackageInstallers.put(pkg, info.installerPackageName);
                        this.skipTarPadding(info.size, instream);
                        this.sendOnRestorePackage(pkg);
                        break block42;
                    }
                    if (info.path.equals(BackupManagerService.BACKUP_METADATA_FILENAME)) {
                        this.readMetadata(info, instream);
                        this.skipTarPadding(info.size, instream);
                        break block42;
                    }
                    boolean okay = true;
                    RestorePolicy policy = this.mPackagePolicies.get(pkg);
                    switch (policy) {
                        case IGNORE: {
                            okay = false;
                            break;
                        }
                        case ACCEPT_IF_APK: {
                            if (info.domain.equals("a")) {
                                Slog.d(BackupManagerService.TAG, "APK file; installing");
                                String installerName = this.mPackageInstallers.get(pkg);
                                okay = this.installApk(info, installerName, instream);
                                this.mPackagePolicies.put(pkg, okay ? RestorePolicy.ACCEPT : RestorePolicy.IGNORE);
                                this.skipTarPadding(info.size, instream);
                                return true;
                            }
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                            okay = false;
                            break;
                        }
                        case ACCEPT: {
                            if (!info.domain.equals("a")) break;
                            Slog.d(BackupManagerService.TAG, "apk present but ACCEPT");
                            okay = false;
                            break;
                        }
                        default: {
                            Slog.e(BackupManagerService.TAG, "Invalid policy from manifest");
                            okay = false;
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (info.path.contains("..") || info.path.contains("//")) {
                        okay = false;
                    }
                    if (okay && this.mAgent != null) {
                        Slog.i(BackupManagerService.TAG, "Reusing existing agent instance");
                    }
                    if (okay && this.mAgent == null) {
                        Slog.d(BackupManagerService.TAG, "Need to launch agent for " + pkg);
                        try {
                            this.mTargetApp = BackupManagerService.this.mPackageManager.getApplicationInfo(pkg, 0);
                            if (!this.mClearedPackages.contains(pkg)) {
                                if (this.mTargetApp.backupAgentName == null) {
                                    Slog.d(BackupManagerService.TAG, "Clearing app data preparatory to full restore");
                                    BackupManagerService.this.clearApplicationDataSynchronous(pkg);
                                } else {
                                    Slog.d(BackupManagerService.TAG, "backup agent (" + this.mTargetApp.backupAgentName + ") => no clear");
                                }
                                this.mClearedPackages.add(pkg);
                            } else {
                                Slog.d(BackupManagerService.TAG, "We've initialized this app already; no clear required");
                            }
                            this.setUpPipes();
                            this.mAgent = BackupManagerService.this.bindToAgentSynchronous(this.mTargetApp, 3);
                            this.mAgentPackage = pkg;
                        }
                        catch (IOException installerName) {
                        }
                        catch (PackageManager.NameNotFoundException installerName) {
                            // empty catch block
                        }
                        if (this.mAgent == null) {
                            Slog.d(BackupManagerService.TAG, "Unable to create agent for " + pkg);
                            okay = false;
                            this.tearDownPipes();
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (okay && !pkg.equals(this.mAgentPackage)) {
                        Slog.e(BackupManagerService.TAG, "Restoring data for " + pkg + " but agent is for " + this.mAgentPackage);
                        okay = false;
                    }
                    if (okay) {
                        boolean agentSuccess = true;
                        long toCopy = info.size;
                        int token = BackupManagerService.this.generateToken();
                        try {
                            BackupManagerService.this.prepareOperationTimeout(token, 300000L, null);
                            if (info.domain.equals("obb")) {
                                Slog.d(BackupManagerService.TAG, "Restoring OBB file for " + pkg + " : " + info.path);
                                this.mObbConnection.restoreObbFile(pkg, this.mPipes[0], info.size, info.type, info.path, info.mode, info.mtime, token, BackupManagerService.this.mBackupManagerBinder);
                            } else {
                                Slog.d(BackupManagerService.TAG, "Invoking agent to restore file " + info.path);
                                if (this.mTargetApp.processName.equals("system")) {
                                    Slog.d(BackupManagerService.TAG, "system process agent - spinning a thread");
                                    RestoreFileRunnable runner = new RestoreFileRunnable(this.mAgent, info, this.mPipes[0], token);
                                    new Thread((Runnable)runner, "restore-sys-runner").start();
                                } else {
                                    this.mAgent.doRestoreFile(this.mPipes[0], info.size, info.type, info.domain, info.path, info.mode, info.mtime, token, BackupManagerService.this.mBackupManagerBinder);
                                }
                            }
                        }
                        catch (IOException e) {
                            Slog.d(BackupManagerService.TAG, "Couldn't establish restore");
                            agentSuccess = false;
                            okay = false;
                        }
                        catch (RemoteException e) {
                            Slog.e(BackupManagerService.TAG, "Agent crashed during full restore");
                            agentSuccess = false;
                            okay = false;
                        }
                        if (okay) {
                            boolean pipeOkay = true;
                            FileOutputStream pipe = new FileOutputStream(this.mPipes[1].getFileDescriptor());
                            while (toCopy > 0L) {
                                int toRead = toCopy > (long)buffer.length ? buffer.length : (int)toCopy;
                                int nRead2 = instream.read(buffer, 0, toRead);
                                if (nRead2 >= 0) {
                                    this.mBytes += (long)nRead2;
                                }
                                if (nRead2 <= 0) break;
                                toCopy -= (long)nRead2;
                                if (!pipeOkay) continue;
                                try {
                                    pipe.write(buffer, 0, nRead2);
                                }
                                catch (IOException e) {
                                    Slog.e(BackupManagerService.TAG, "Failed to write to restore pipe", e);
                                    pipeOkay = false;
                                }
                            }
                            this.skipTarPadding(info.size, instream);
                            agentSuccess = BackupManagerService.this.waitUntilOperationComplete(token);
                        }
                        if (!agentSuccess) {
                            BackupManagerService.this.mBackupHandler.removeMessages(7);
                            this.tearDownPipes();
                            this.tearDownAgent(this.mTargetApp);
                            this.mAgent = null;
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (okay) break block42;
                    Slog.d(BackupManagerService.TAG, "[discarding file content]");
                    for (long bytesToConsume = info.size + 511L & 0xFFFFFFFFFFFFFE00L; bytesToConsume > 0L; bytesToConsume -= nRead) {
                        int toRead = bytesToConsume > (long)buffer.length ? buffer.length : (int)bytesToConsume;
                        nRead = instream.read(buffer, 0, toRead);
                        if (nRead >= 0L) {
                            this.mBytes += nRead;
                        }
                        if (nRead > 0L) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    Slog.w(BackupManagerService.TAG, "io exception on restore socket read", e);
                    info = null;
                }
            }
            return info != null;
        }

        void setUpPipes() throws IOException {
            this.mPipes = ParcelFileDescriptor.createPipe();
        }

        void tearDownPipes() {
            if (this.mPipes != null) {
                try {
                    this.mPipes[0].close();
                    this.mPipes[0] = null;
                    this.mPipes[1].close();
                    this.mPipes[1] = null;
                }
                catch (IOException e) {
                    Slog.w(BackupManagerService.TAG, "Couldn't close agent pipes", e);
                }
                this.mPipes = null;
            }
        }

        void tearDownAgent(ApplicationInfo app) {
            if (this.mAgent != null) {
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(app);
                    if (app.uid != 1000 && !app.packageName.equals("com.android.backupconfirm")) {
                        Slog.d(BackupManagerService.TAG, "Killing host process");
                        BackupManagerService.this.mActivityManager.killApplicationProcess(app.processName, app.uid);
                    } else {
                        Slog.d(BackupManagerService.TAG, "Not killing after full restore");
                    }
                }
                catch (RemoteException e) {
                    Slog.d(BackupManagerService.TAG, "Lost app trying to shut down");
                }
                this.mAgent = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean installApk(FileMetadata info, String installerPackage, InputStream instream) {
            boolean okay;
            block19: {
                okay = true;
                Slog.d(BackupManagerService.TAG, "Installing from backup: " + info.packageName);
                File apkFile = new File(BackupManagerService.this.mDataDir, info.packageName);
                try {
                    int didRead;
                    FileOutputStream apkStream = new FileOutputStream(apkFile);
                    byte[] buffer = new byte[32768];
                    for (long size = info.size; size > 0L; size -= (long)didRead) {
                        long toRead = (long)buffer.length < size ? (long)buffer.length : size;
                        didRead = instream.read(buffer, 0, (int)toRead);
                        if (didRead >= 0) {
                            this.mBytes += (long)didRead;
                        }
                        apkStream.write(buffer, 0, didRead);
                    }
                    apkStream.close();
                    apkFile.setReadable(true, false);
                    Uri packageUri = Uri.fromFile(apkFile);
                    this.mInstallObserver.reset();
                    BackupManagerService.this.mPackageManager.installPackage(packageUri, this.mInstallObserver, 34, installerPackage);
                    this.mInstallObserver.waitForCompletion();
                    if (this.mInstallObserver.getResult() != 1) {
                        if (this.mPackagePolicies.get(info.packageName) != RestorePolicy.ACCEPT) {
                            okay = false;
                        }
                        break block19;
                    }
                    boolean uninstall = false;
                    if (!this.mInstallObserver.mPackageName.equals(info.packageName)) {
                        Slog.w(BackupManagerService.TAG, "Restore stream claimed to include apk for " + info.packageName + " but apk was really " + this.mInstallObserver.mPackageName);
                        okay = false;
                        uninstall = true;
                    } else {
                        try {
                            PackageInfo pkg = BackupManagerService.this.mPackageManager.getPackageInfo(info.packageName, 64);
                            if ((pkg.applicationInfo.flags & 0x8000) == 0) {
                                Slog.w(BackupManagerService.TAG, "Restore stream contains apk of package " + info.packageName + " but it disallows backup/restore");
                                okay = false;
                            } else {
                                Signature[] sigs = this.mManifestSignatures.get(info.packageName);
                                if (BackupManagerService.signaturesMatch(sigs, pkg)) {
                                    if (pkg.applicationInfo.uid < 10000 && pkg.applicationInfo.backupAgentName == null) {
                                        Slog.w(BackupManagerService.TAG, "Installed app " + info.packageName + " has restricted uid and no agent");
                                        okay = false;
                                    }
                                } else {
                                    Slog.w(BackupManagerService.TAG, "Installed app " + info.packageName + " signatures do not match restore manifest");
                                    okay = false;
                                    uninstall = true;
                                }
                            }
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            Slog.w(BackupManagerService.TAG, "Install of package " + info.packageName + " succeeded but now not found");
                            okay = false;
                        }
                    }
                    if (uninstall) {
                        this.mDeleteObserver.reset();
                        BackupManagerService.this.mPackageManager.deletePackage(this.mInstallObserver.mPackageName, this.mDeleteObserver, 0);
                        this.mDeleteObserver.waitForCompletion();
                    }
                }
                catch (IOException e) {
                    Slog.e(BackupManagerService.TAG, "Unable to transcribe restored apk for install");
                    okay = false;
                }
                finally {
                    apkFile.delete();
                }
            }
            return okay;
        }

        void skipTarPadding(long size, InputStream instream) throws IOException {
            long partial = (size + 512L) % 512L;
            if (partial > 0L) {
                int needed = 512 - (int)partial;
                byte[] buffer = new byte[needed];
                if (this.readExactly(instream, buffer, 0, needed) == needed) {
                    this.mBytes += (long)needed;
                } else {
                    throw new IOException("Unexpected EOF in padding");
                }
            }
        }

        void readMetadata(FileMetadata info, InputStream instream) throws IOException {
            if (info.size > 65536L) {
                throw new IOException("Metadata too big; corrupt? size=" + info.size);
            }
            byte[] buffer = new byte[(int)info.size];
            if ((long)this.readExactly(instream, buffer, 0, (int)info.size) == info.size) {
                this.mBytes += info.size;
            } else {
                throw new IOException("Unexpected EOF in widget data");
            }
            String[] str = new String[1];
            int offset = this.extractLine(buffer, 0, str);
            int version = Integer.parseInt(str[0]);
            if (version == 1) {
                offset = this.extractLine(buffer, offset, str);
                String pkg = str[0];
                if (info.packageName.equals(pkg)) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(buffer, offset, buffer.length - offset);
                    DataInputStream in = new DataInputStream(bin);
                    block3: while (bin.available() > 0) {
                        int token = in.readInt();
                        int size = in.readInt();
                        if (size > 65536) {
                            throw new IOException("Datum " + Integer.toHexString(token) + " too big; corrupt? size=" + info.size);
                        }
                        switch (token) {
                            case 33549569: {
                                this.mWidgetData = new byte[size];
                                in.read(this.mWidgetData);
                                continue block3;
                            }
                        }
                        Slog.i(BackupManagerService.TAG, "Ignoring metadata blob " + Integer.toHexString(token) + " for " + info.packageName);
                        in.skipBytes(size);
                    }
                } else {
                    Slog.w(BackupManagerService.TAG, "Metadata mismatch: package " + info.packageName + " but widget data for " + pkg);
                }
            } else {
                Slog.w(BackupManagerService.TAG, "Unsupported metadata version " + version);
            }
        }

        RestorePolicy readAppManifest(FileMetadata info, InputStream instream) throws IOException {
            RestorePolicy policy;
            block21: {
                if (info.size > 65536L) {
                    throw new IOException("Restore manifest too big; corrupt? size=" + info.size);
                }
                byte[] buffer = new byte[(int)info.size];
                if ((long)this.readExactly(instream, buffer, 0, (int)info.size) == info.size) {
                    this.mBytes += info.size;
                } else {
                    throw new IOException("Unexpected EOF in manifest");
                }
                policy = RestorePolicy.IGNORE;
                String[] str = new String[1];
                int offset = 0;
                try {
                    offset = this.extractLine(buffer, offset, str);
                    int version = Integer.parseInt(str[0]);
                    if (version == 1) {
                        offset = this.extractLine(buffer, offset, str);
                        String manifestPackage = str[0];
                        if (manifestPackage.equals(info.packageName)) {
                            offset = this.extractLine(buffer, offset, str);
                            version = Integer.parseInt(str[0]);
                            offset = this.extractLine(buffer, offset, str);
                            int platformVersion = Integer.parseInt(str[0]);
                            offset = this.extractLine(buffer, offset, str);
                            info.installerPackageName = str[0].length() > 0 ? str[0] : null;
                            offset = this.extractLine(buffer, offset, str);
                            boolean hasApk = str[0].equals("1");
                            offset = this.extractLine(buffer, offset, str);
                            int numSigs = Integer.parseInt(str[0]);
                            if (numSigs > 0) {
                                Signature[] sigs = new Signature[numSigs];
                                for (int i = 0; i < numSigs; ++i) {
                                    offset = this.extractLine(buffer, offset, str);
                                    sigs[i] = new Signature(str[0]);
                                }
                                this.mManifestSignatures.put(info.packageName, sigs);
                                try {
                                    PackageInfo pkgInfo = BackupManagerService.this.mPackageManager.getPackageInfo(info.packageName, 64);
                                    int flags = pkgInfo.applicationInfo.flags;
                                    if ((flags & 0x8000) != 0) {
                                        if (pkgInfo.applicationInfo.uid >= 10000 || pkgInfo.applicationInfo.backupAgentName != null) {
                                            if (BackupManagerService.signaturesMatch(sigs, pkgInfo)) {
                                                if (pkgInfo.versionCode >= version) {
                                                    Slog.i(BackupManagerService.TAG, "Sig + version match; taking data");
                                                    policy = RestorePolicy.ACCEPT;
                                                } else {
                                                    Slog.d(BackupManagerService.TAG, "Data version " + version + " is newer than installed version " + pkgInfo.versionCode + " - requiring apk");
                                                    policy = RestorePolicy.ACCEPT_IF_APK;
                                                }
                                            } else {
                                                Slog.w(BackupManagerService.TAG, "Restore manifest signatures do not match installed application for " + info.packageName);
                                            }
                                        } else {
                                            Slog.w(BackupManagerService.TAG, "Package " + info.packageName + " is system level with no agent");
                                        }
                                    } else {
                                        Slog.i(BackupManagerService.TAG, "Restore manifest from " + info.packageName + " but allowBackup=false");
                                    }
                                }
                                catch (PackageManager.NameNotFoundException e) {
                                    Slog.i(BackupManagerService.TAG, "Package " + info.packageName + " not installed; requiring apk in dataset");
                                    policy = RestorePolicy.ACCEPT_IF_APK;
                                }
                                if (policy == RestorePolicy.ACCEPT_IF_APK && !hasApk) {
                                    Slog.i(BackupManagerService.TAG, "Cannot restore package " + info.packageName + " without the matching .apk");
                                }
                                break block21;
                            }
                            Slog.i(BackupManagerService.TAG, "Missing signature on backed-up package " + info.packageName);
                            break block21;
                        }
                        Slog.i(BackupManagerService.TAG, "Expected package " + info.packageName + " but restore manifest claims " + manifestPackage);
                        break block21;
                    }
                    Slog.i(BackupManagerService.TAG, "Unknown restore manifest version " + version + " for package " + info.packageName);
                }
                catch (NumberFormatException e) {
                    Slog.w(BackupManagerService.TAG, "Corrupt restore manifest for package " + info.packageName);
                }
                catch (IllegalArgumentException e) {
                    Slog.w(BackupManagerService.TAG, e.getMessage());
                }
            }
            return policy;
        }

        int extractLine(byte[] buffer, int offset, String[] outStr) throws IOException {
            byte c;
            int pos;
            int end = buffer.length;
            if (offset >= end) {
                throw new IOException("Incomplete data");
            }
            for (pos = offset; pos < end && (c = buffer[pos]) != 10; ++pos) {
            }
            outStr[0] = new String(buffer, offset, pos - offset);
            return ++pos;
        }

        void dumpFileMetadata(FileMetadata info) {
            StringBuilder b = new StringBuilder(128);
            b.append(info.type == 2 ? (char)'d' : '-');
            b.append((info.mode & 0x100L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 0x80L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 0x40L) != 0L ? (char)'x' : '-');
            b.append((info.mode & 0x20L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 0x10L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 8L) != 0L ? (char)'x' : '-');
            b.append((info.mode & 4L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 2L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 1L) != 0L ? (char)'x' : '-');
            b.append(String.format(" %9d ", info.size));
            Date stamp = new Date(info.mtime);
            b.append(new SimpleDateFormat("MMM dd HH:mm:ss ").format(stamp));
            b.append(info.packageName);
            b.append(" :: ");
            b.append(info.domain);
            b.append(" :: ");
            b.append(info.path);
            Slog.i(BackupManagerService.TAG, b.toString());
        }

        FileMetadata readTarHeaders(InputStream instream) throws IOException {
            byte[] block = new byte[512];
            FileMetadata info = null;
            boolean gotHeader = this.readTarHeader(instream, block);
            if (gotHeader) {
                try {
                    byte typeChar;
                    info = new FileMetadata();
                    info.size = this.extractRadix(block, 124, 12, 8);
                    info.mtime = this.extractRadix(block, 136, 12, 8);
                    info.mode = this.extractRadix(block, 100, 8, 8);
                    info.path = this.extractString(block, 345, 155);
                    String path = this.extractString(block, 0, 100);
                    if (path.length() > 0) {
                        if (info.path.length() > 0) {
                            info.path = info.path + '/';
                        }
                        info.path = info.path + path;
                    }
                    if ((typeChar = block[156]) == 120) {
                        gotHeader = this.readPaxExtendedHeader(instream, info);
                        if (gotHeader) {
                            gotHeader = this.readTarHeader(instream, block);
                        }
                        if (!gotHeader) {
                            throw new IOException("Bad or missing pax header");
                        }
                        typeChar = block[156];
                    }
                    switch (typeChar) {
                        case 48: {
                            info.type = 1;
                            break;
                        }
                        case 53: {
                            info.type = 2;
                            if (info.size == 0L) break;
                            Slog.w(BackupManagerService.TAG, "Directory entry with nonzero size in header");
                            info.size = 0L;
                            break;
                        }
                        case 0: {
                            Slog.w(BackupManagerService.TAG, "Saw type=0 in tar header block, info=" + info);
                            return null;
                        }
                        default: {
                            Slog.e(BackupManagerService.TAG, "Unknown tar entity type: " + typeChar);
                            throw new IOException("Unknown entity type " + typeChar);
                        }
                    }
                    if ("shared/".regionMatches(0, info.path, 0, "shared/".length())) {
                        info.path = info.path.substring("shared/".length());
                        info.packageName = BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE;
                        info.domain = "shared";
                        Slog.i(BackupManagerService.TAG, "File in shared storage: " + info.path);
                    } else if ("apps/".regionMatches(0, info.path, 0, "apps/".length())) {
                        info.path = info.path.substring("apps/".length());
                        int slash = info.path.indexOf(47);
                        if (slash < 0) {
                            throw new IOException("Illegal semantic path in " + info.path);
                        }
                        info.packageName = info.path.substring(0, slash);
                        info.path = info.path.substring(slash + 1);
                        if (!info.path.equals(BackupManagerService.BACKUP_MANIFEST_FILENAME) && !info.path.equals(BackupManagerService.BACKUP_METADATA_FILENAME)) {
                            slash = info.path.indexOf(47);
                            if (slash < 0) {
                                throw new IOException("Illegal semantic path in non-manifest " + info.path);
                            }
                            info.domain = info.path.substring(0, slash);
                            info.path = info.path.substring(slash + 1);
                        }
                    }
                }
                catch (IOException e) {
                    Slog.e(BackupManagerService.TAG, "Parse error in header: " + e.getMessage());
                    this.HEXLOG(block);
                    throw e;
                }
            }
            return info;
        }

        private void HEXLOG(byte[] block) {
            int offset = 0;
            int todo = block.length;
            StringBuilder buf = new StringBuilder(64);
            while (todo > 0) {
                buf.append(String.format("%04x   ", offset));
                int numThisLine = todo > 16 ? 16 : todo;
                for (int i = 0; i < numThisLine; ++i) {
                    buf.append(String.format("%02x ", block[offset + i]));
                }
                Slog.i("hexdump", buf.toString());
                buf.setLength(0);
                todo -= numThisLine;
                offset += numThisLine;
            }
        }

        int readExactly(InputStream in, byte[] buffer, int offset, int size) throws IOException {
            int soFar;
            int nRead;
            if (size <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            for (soFar = 0; soFar < size && (nRead = in.read(buffer, offset + soFar, size - soFar)) > 0; soFar += nRead) {
            }
            return soFar;
        }

        boolean readTarHeader(InputStream instream, byte[] block) throws IOException {
            int got = this.readExactly(instream, block, 0, 512);
            if (got == 0) {
                return false;
            }
            if (got < 512) {
                throw new IOException("Unable to read full block header");
            }
            this.mBytes += 512L;
            return true;
        }

        boolean readPaxExtendedHeader(InputStream instream, FileMetadata info) throws IOException {
            int linelen;
            if (info.size > 32768L) {
                Slog.w(BackupManagerService.TAG, "Suspiciously large pax header size " + info.size + " - aborting");
                throw new IOException("Sanity failure: pax header size " + info.size);
            }
            int numBlocks = (int)(info.size + 511L >> 9);
            byte[] data = new byte[numBlocks * 512];
            if (this.readExactly(instream, data, 0, data.length) < data.length) {
                throw new IOException("Unable to read full pax header");
            }
            this.mBytes += (long)data.length;
            int contentSize = (int)info.size;
            int offset = 0;
            do {
                int value;
                int eol;
                for (eol = offset + 1; eol < contentSize && data[eol] != 32; ++eol) {
                }
                if (eol >= contentSize) {
                    throw new IOException("Invalid pax data");
                }
                linelen = (int)this.extractRadix(data, offset, eol - offset, 10);
                int key = eol + 1;
                eol = offset + linelen - 1;
                for (value = key + 1; data[value] != 61 && value <= eol; ++value) {
                }
                if (value > eol) {
                    throw new IOException("Invalid pax declaration");
                }
                String keyStr = new String(data, key, value - key, "UTF-8");
                String valStr = new String(data, value + 1, eol - value - 1, "UTF-8");
                if ("path".equals(keyStr)) {
                    info.path = valStr;
                    continue;
                }
                if ("size".equals(keyStr)) {
                    info.size = Long.parseLong(valStr);
                    continue;
                }
                Slog.i(BackupManagerService.TAG, "Unhandled pax key: " + key);
            } while ((offset += linelen) < contentSize);
            return true;
        }

        long extractRadix(byte[] data, int offset, int maxChars, int radix) throws IOException {
            byte b;
            long value = 0L;
            int end = offset + maxChars;
            for (int i = offset; i < end && (b = data[i]) != 0 && b != 32; ++i) {
                if (b < 48 || b > 48 + radix - 1) {
                    throw new IOException("Invalid number in header: '" + (char)b + "' for radix " + radix);
                }
                value = (long)radix * value + (long)(b - 48);
            }
            return value;
        }

        String extractString(byte[] data, int offset, int maxChars) throws IOException {
            int eos;
            int end = offset + maxChars;
            for (eos = offset; eos < end && data[eos] != 0; ++eos) {
            }
            return new String(data, offset, eos - offset, "US-ASCII");
        }

        void sendStartRestore() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onStartRestore();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full restore observer went away: startRestore");
                    this.mObserver = null;
                }
            }
        }

        void sendOnRestorePackage(String name) {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onRestorePackage(name);
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full restore observer went away: restorePackage");
                    this.mObserver = null;
                }
            }
        }

        void sendEndRestore() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onEndRestore();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full restore observer went away: endRestore");
                    this.mObserver = null;
                }
            }
        }

        class RestoreDeleteObserver
        extends IPackageDeleteObserver.Stub {
            final AtomicBoolean mDone = new AtomicBoolean();
            int mResult;

            RestoreDeleteObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mDone.set(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForCompletion() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    while (!this.mDone.get()) {
                        try {
                            this.mDone.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void packageDeleted(String packageName, int returnCode) throws RemoteException {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mResult = returnCode;
                    this.mDone.set(true);
                    this.mDone.notifyAll();
                }
            }
        }

        class RestoreInstallObserver
        extends IPackageInstallObserver.Stub {
            final AtomicBoolean mDone = new AtomicBoolean();
            String mPackageName;
            int mResult;

            RestoreInstallObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mDone.set(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForCompletion() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    while (!this.mDone.get()) {
                        try {
                            this.mDone.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            int getResult() {
                return this.mResult;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void packageInstalled(String packageName, int returnCode) throws RemoteException {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mResult = returnCode;
                    this.mPackageName = packageName;
                    this.mDone.set(true);
                    this.mDone.notifyAll();
                }
            }
        }

        class RestoreFileRunnable
        implements Runnable {
            IBackupAgent mAgent;
            FileMetadata mInfo;
            ParcelFileDescriptor mSocket;
            int mToken;

            RestoreFileRunnable(IBackupAgent agent, FileMetadata info, ParcelFileDescriptor socket, int token) throws IOException {
                this.mAgent = agent;
                this.mInfo = info;
                this.mToken = token;
                this.mSocket = ParcelFileDescriptor.dup(socket.getFileDescriptor());
            }

            @Override
            public void run() {
                try {
                    this.mAgent.doRestoreFile(this.mSocket, this.mInfo.size, this.mInfo.type, this.mInfo.domain, this.mInfo.path, this.mInfo.mode, this.mInfo.mtime, this.mToken, BackupManagerService.this.mBackupManagerBinder);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    class FullRestoreEngine
    extends RestoreEngine {
        IFullBackupRestoreObserver mObserver;
        IBackupAgent mAgent;
        PackageInfo mOnlyPackage;
        boolean mAllowApks;
        boolean mAllowObbs;
        String mAgentPackage;
        ApplicationInfo mTargetApp;
        FullBackupObbConnection mObbConnection;
        final HashMap<String, RestorePolicy> mPackagePolicies;
        final HashMap<String, String> mPackageInstallers;
        final HashMap<String, Signature[]> mManifestSignatures;
        final HashSet<String> mClearedPackages;
        long mBytes;
        byte[] mBuffer;
        ParcelFileDescriptor[] mPipes;
        byte[] mWidgetData;
        final RestoreInstallObserver mInstallObserver;
        final RestoreDeleteObserver mDeleteObserver;

        public FullRestoreEngine(IFullBackupRestoreObserver observer, PackageInfo onlyPackage, boolean allowApks, boolean allowObbs) {
            this.mObbConnection = null;
            this.mPackagePolicies = new HashMap();
            this.mPackageInstallers = new HashMap();
            this.mManifestSignatures = new HashMap();
            this.mClearedPackages = new HashSet();
            this.mPipes = null;
            this.mWidgetData = null;
            this.mInstallObserver = new RestoreInstallObserver();
            this.mDeleteObserver = new RestoreDeleteObserver();
            this.mObserver = observer;
            this.mOnlyPackage = onlyPackage;
            this.mAllowApks = allowApks;
            this.mAllowObbs = allowObbs;
            this.mBuffer = new byte[32768];
            this.mBytes = 0L;
        }

        public boolean restoreOneFile(InputStream instream) {
            FileMetadata info;
            block46: {
                if (!this.isRunning()) {
                    Slog.w("RestoreEngine", "Restore engine used after halting");
                    return false;
                }
                try {
                    long nRead;
                    info = this.readTarHeaders(instream);
                    if (info == null) break block46;
                    String pkg = info.packageName;
                    if (!pkg.equals(this.mAgentPackage)) {
                        if (this.mOnlyPackage != null && !pkg.equals(this.mOnlyPackage.packageName)) {
                            Slog.w("RestoreEngine", "Expected data for " + this.mOnlyPackage + " but saw " + pkg);
                            this.setResult(-3);
                            this.setRunning(false);
                            return false;
                        }
                        if (!this.mPackagePolicies.containsKey(pkg)) {
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                        if (this.mAgent != null) {
                            Slog.d("RestoreEngine", "Saw new package; finalizing old one");
                            this.tearDownPipes();
                            this.tearDownAgent(this.mTargetApp);
                            this.mTargetApp = null;
                            this.mAgentPackage = null;
                        }
                    }
                    if (info.path.equals(BackupManagerService.BACKUP_MANIFEST_FILENAME)) {
                        this.mPackagePolicies.put(pkg, this.readAppManifest(info, instream));
                        this.mPackageInstallers.put(pkg, info.installerPackageName);
                        this.skipTarPadding(info.size, instream);
                        this.sendOnRestorePackage(pkg);
                        break block46;
                    }
                    if (info.path.equals(BackupManagerService.BACKUP_METADATA_FILENAME)) {
                        this.readMetadata(info, instream);
                        this.skipTarPadding(info.size, instream);
                        break block46;
                    }
                    boolean okay = true;
                    RestorePolicy policy = this.mPackagePolicies.get(pkg);
                    switch (policy) {
                        case IGNORE: {
                            okay = false;
                            break;
                        }
                        case ACCEPT_IF_APK: {
                            if (info.domain.equals("a")) {
                                Slog.d("RestoreEngine", "APK file; installing");
                                String installerName = this.mPackageInstallers.get(pkg);
                                okay = this.installApk(info, installerName, instream);
                                this.mPackagePolicies.put(pkg, okay ? RestorePolicy.ACCEPT : RestorePolicy.IGNORE);
                                this.skipTarPadding(info.size, instream);
                                return true;
                            }
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                            okay = false;
                            break;
                        }
                        case ACCEPT: {
                            if (!info.domain.equals("a")) break;
                            Slog.d("RestoreEngine", "apk present but ACCEPT");
                            okay = false;
                            break;
                        }
                        default: {
                            Slog.e("RestoreEngine", "Invalid policy from manifest");
                            okay = false;
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (!this.isRestorableFile(info)) {
                        okay = false;
                    }
                    if (okay && this.mAgent != null) {
                        Slog.i("RestoreEngine", "Reusing existing agent instance");
                    }
                    if (okay && this.mAgent == null) {
                        Slog.d("RestoreEngine", "Need to launch agent for " + pkg);
                        try {
                            this.mTargetApp = BackupManagerService.this.mPackageManager.getApplicationInfo(pkg, 0);
                            if (!this.mClearedPackages.contains(pkg)) {
                                if (this.mTargetApp.backupAgentName == null) {
                                    Slog.d("RestoreEngine", "Clearing app data preparatory to full restore");
                                    BackupManagerService.this.clearApplicationDataSynchronous(pkg);
                                } else {
                                    Slog.d("RestoreEngine", "backup agent (" + this.mTargetApp.backupAgentName + ") => no clear");
                                }
                                this.mClearedPackages.add(pkg);
                            } else {
                                Slog.d("RestoreEngine", "We've initialized this app already; no clear required");
                            }
                            this.setUpPipes();
                            this.mAgent = BackupManagerService.this.bindToAgentSynchronous(this.mTargetApp, 3);
                            this.mAgentPackage = pkg;
                        }
                        catch (IOException installerName) {
                        }
                        catch (PackageManager.NameNotFoundException installerName) {
                            // empty catch block
                        }
                        if (this.mAgent == null) {
                            Slog.d("RestoreEngine", "Unable to create agent for " + pkg);
                            okay = false;
                            this.tearDownPipes();
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                        }
                    }
                    if (okay && !pkg.equals(this.mAgentPackage)) {
                        Slog.e("RestoreEngine", "Restoring data for " + pkg + " but agent is for " + this.mAgentPackage);
                        okay = false;
                    }
                    if (okay) {
                        boolean agentSuccess = true;
                        long toCopy = info.size;
                        int token = BackupManagerService.this.generateToken();
                        try {
                            BackupManagerService.this.prepareOperationTimeout(token, 300000L, null);
                            if (info.domain.equals("obb")) {
                                Slog.d("RestoreEngine", "Restoring OBB file for " + pkg + " : " + info.path);
                                this.mObbConnection.restoreObbFile(pkg, this.mPipes[0], info.size, info.type, info.path, info.mode, info.mtime, token, BackupManagerService.this.mBackupManagerBinder);
                            } else {
                                Slog.d("RestoreEngine", "Invoking agent to restore file " + info.path);
                                if (this.mTargetApp.processName.equals("system")) {
                                    Slog.d("RestoreEngine", "system process agent - spinning a thread");
                                    RestoreFileRunnable runner = new RestoreFileRunnable(this.mAgent, info, this.mPipes[0], token);
                                    new Thread((Runnable)runner, "restore-sys-runner").start();
                                } else {
                                    this.mAgent.doRestoreFile(this.mPipes[0], info.size, info.type, info.domain, info.path, info.mode, info.mtime, token, BackupManagerService.this.mBackupManagerBinder);
                                }
                            }
                        }
                        catch (IOException e) {
                            Slog.d("RestoreEngine", "Couldn't establish restore");
                            agentSuccess = false;
                            okay = false;
                        }
                        catch (RemoteException e) {
                            Slog.e("RestoreEngine", "Agent crashed during full restore");
                            agentSuccess = false;
                            okay = false;
                        }
                        if (okay) {
                            boolean pipeOkay = true;
                            FileOutputStream pipe = new FileOutputStream(this.mPipes[1].getFileDescriptor());
                            while (toCopy > 0L) {
                                int toRead = toCopy > (long)this.mBuffer.length ? this.mBuffer.length : (int)toCopy;
                                int nRead2 = instream.read(this.mBuffer, 0, toRead);
                                if (nRead2 >= 0) {
                                    this.mBytes += (long)nRead2;
                                }
                                if (nRead2 <= 0) break;
                                toCopy -= (long)nRead2;
                                if (!pipeOkay) continue;
                                try {
                                    pipe.write(this.mBuffer, 0, nRead2);
                                }
                                catch (IOException e) {
                                    Slog.e("RestoreEngine", "Failed to write to restore pipe", e);
                                    pipeOkay = false;
                                }
                            }
                            this.skipTarPadding(info.size, instream);
                            agentSuccess = BackupManagerService.this.waitUntilOperationComplete(token);
                        }
                        if (!agentSuccess) {
                            Slog.i("RestoreEngine", "Agent failure; ending restore");
                            BackupManagerService.this.mBackupHandler.removeMessages(7);
                            this.tearDownPipes();
                            this.tearDownAgent(this.mTargetApp);
                            this.mAgent = null;
                            this.mPackagePolicies.put(pkg, RestorePolicy.IGNORE);
                            if (this.mOnlyPackage != null) {
                                this.setResult(-2);
                                this.setRunning(false);
                                return false;
                            }
                        }
                    }
                    if (okay) break block46;
                    Slog.d("RestoreEngine", "[discarding file content]");
                    for (long bytesToConsume = info.size + 511L & 0xFFFFFFFFFFFFFE00L; bytesToConsume > 0L; bytesToConsume -= nRead) {
                        int toRead = bytesToConsume > (long)this.mBuffer.length ? this.mBuffer.length : (int)bytesToConsume;
                        nRead = instream.read(this.mBuffer, 0, toRead);
                        if (nRead >= 0L) {
                            this.mBytes += nRead;
                        }
                        if (nRead > 0L) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    Slog.w("RestoreEngine", "io exception on restore socket read", e);
                    this.setResult(-3);
                    info = null;
                }
            }
            if (info == null) {
                this.tearDownPipes();
                this.tearDownAgent(this.mTargetApp);
                this.setRunning(false);
            }
            return info != null;
        }

        void setUpPipes() throws IOException {
            this.mPipes = ParcelFileDescriptor.createPipe();
        }

        void tearDownPipes() {
            if (this.mPipes != null) {
                try {
                    this.mPipes[0].close();
                    this.mPipes[0] = null;
                    this.mPipes[1].close();
                    this.mPipes[1] = null;
                }
                catch (IOException e) {
                    Slog.w("RestoreEngine", "Couldn't close agent pipes", e);
                }
                this.mPipes = null;
            }
        }

        void tearDownAgent(ApplicationInfo app) {
            if (this.mAgent != null) {
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(app);
                    if (app.uid != 1000 && !app.packageName.equals("com.android.backupconfirm")) {
                        Slog.d("RestoreEngine", "Killing host process");
                        BackupManagerService.this.mActivityManager.killApplicationProcess(app.processName, app.uid);
                    } else {
                        Slog.d("RestoreEngine", "Not killing after full restore");
                    }
                }
                catch (RemoteException e) {
                    Slog.d("RestoreEngine", "Lost app trying to shut down");
                }
                this.mAgent = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean installApk(FileMetadata info, String installerPackage, InputStream instream) {
            boolean okay;
            block19: {
                okay = true;
                Slog.d("RestoreEngine", "Installing from backup: " + info.packageName);
                File apkFile = new File(BackupManagerService.this.mDataDir, info.packageName);
                try {
                    int didRead;
                    FileOutputStream apkStream = new FileOutputStream(apkFile);
                    byte[] buffer = new byte[32768];
                    for (long size = info.size; size > 0L; size -= (long)didRead) {
                        long toRead = (long)buffer.length < size ? (long)buffer.length : size;
                        didRead = instream.read(buffer, 0, (int)toRead);
                        if (didRead >= 0) {
                            this.mBytes += (long)didRead;
                        }
                        apkStream.write(buffer, 0, didRead);
                    }
                    apkStream.close();
                    apkFile.setReadable(true, false);
                    Uri packageUri = Uri.fromFile(apkFile);
                    this.mInstallObserver.reset();
                    BackupManagerService.this.mPackageManager.installPackage(packageUri, this.mInstallObserver, 34, installerPackage);
                    this.mInstallObserver.waitForCompletion();
                    if (this.mInstallObserver.getResult() != 1) {
                        if (this.mPackagePolicies.get(info.packageName) != RestorePolicy.ACCEPT) {
                            okay = false;
                        }
                        break block19;
                    }
                    boolean uninstall = false;
                    if (!this.mInstallObserver.mPackageName.equals(info.packageName)) {
                        Slog.w("RestoreEngine", "Restore stream claimed to include apk for " + info.packageName + " but apk was really " + this.mInstallObserver.mPackageName);
                        okay = false;
                        uninstall = true;
                    } else {
                        try {
                            PackageInfo pkg = BackupManagerService.this.mPackageManager.getPackageInfo(info.packageName, 64);
                            if ((pkg.applicationInfo.flags & 0x8000) == 0) {
                                Slog.w("RestoreEngine", "Restore stream contains apk of package " + info.packageName + " but it disallows backup/restore");
                                okay = false;
                            } else {
                                Signature[] sigs = this.mManifestSignatures.get(info.packageName);
                                if (BackupManagerService.signaturesMatch(sigs, pkg)) {
                                    if (pkg.applicationInfo.uid < 10000 && pkg.applicationInfo.backupAgentName == null) {
                                        Slog.w("RestoreEngine", "Installed app " + info.packageName + " has restricted uid and no agent");
                                        okay = false;
                                    }
                                } else {
                                    Slog.w("RestoreEngine", "Installed app " + info.packageName + " signatures do not match restore manifest");
                                    okay = false;
                                    uninstall = true;
                                }
                            }
                        }
                        catch (PackageManager.NameNotFoundException e) {
                            Slog.w("RestoreEngine", "Install of package " + info.packageName + " succeeded but now not found");
                            okay = false;
                        }
                    }
                    if (uninstall) {
                        this.mDeleteObserver.reset();
                        BackupManagerService.this.mPackageManager.deletePackage(this.mInstallObserver.mPackageName, this.mDeleteObserver, 0);
                        this.mDeleteObserver.waitForCompletion();
                    }
                }
                catch (IOException e) {
                    Slog.e("RestoreEngine", "Unable to transcribe restored apk for install");
                    okay = false;
                }
                finally {
                    apkFile.delete();
                }
            }
            return okay;
        }

        void skipTarPadding(long size, InputStream instream) throws IOException {
            long partial = (size + 512L) % 512L;
            if (partial > 0L) {
                int needed = 512 - (int)partial;
                byte[] buffer = new byte[needed];
                if (this.readExactly(instream, buffer, 0, needed) == needed) {
                    this.mBytes += (long)needed;
                } else {
                    throw new IOException("Unexpected EOF in padding");
                }
            }
        }

        void readMetadata(FileMetadata info, InputStream instream) throws IOException {
            if (info.size > 65536L) {
                throw new IOException("Metadata too big; corrupt? size=" + info.size);
            }
            byte[] buffer = new byte[(int)info.size];
            if ((long)this.readExactly(instream, buffer, 0, (int)info.size) == info.size) {
                this.mBytes += info.size;
            } else {
                throw new IOException("Unexpected EOF in widget data");
            }
            String[] str = new String[1];
            int offset = this.extractLine(buffer, 0, str);
            int version = Integer.parseInt(str[0]);
            if (version == 1) {
                offset = this.extractLine(buffer, offset, str);
                String pkg = str[0];
                if (info.packageName.equals(pkg)) {
                    ByteArrayInputStream bin = new ByteArrayInputStream(buffer, offset, buffer.length - offset);
                    DataInputStream in = new DataInputStream(bin);
                    block3: while (bin.available() > 0) {
                        int token = in.readInt();
                        int size = in.readInt();
                        if (size > 65536) {
                            throw new IOException("Datum " + Integer.toHexString(token) + " too big; corrupt? size=" + info.size);
                        }
                        switch (token) {
                            case 33549569: {
                                this.mWidgetData = new byte[size];
                                in.read(this.mWidgetData);
                                continue block3;
                            }
                        }
                        Slog.i("RestoreEngine", "Ignoring metadata blob " + Integer.toHexString(token) + " for " + info.packageName);
                        in.skipBytes(size);
                    }
                } else {
                    Slog.w("RestoreEngine", "Metadata mismatch: package " + info.packageName + " but widget data for " + pkg);
                }
            } else {
                Slog.w("RestoreEngine", "Unsupported metadata version " + version);
            }
        }

        RestorePolicy readAppManifest(FileMetadata info, InputStream instream) throws IOException {
            RestorePolicy policy;
            block24: {
                if (info.size > 65536L) {
                    throw new IOException("Restore manifest too big; corrupt? size=" + info.size);
                }
                byte[] buffer = new byte[(int)info.size];
                if ((long)this.readExactly(instream, buffer, 0, (int)info.size) == info.size) {
                    this.mBytes += info.size;
                } else {
                    throw new IOException("Unexpected EOF in manifest");
                }
                policy = RestorePolicy.IGNORE;
                String[] str = new String[1];
                int offset = 0;
                try {
                    offset = this.extractLine(buffer, offset, str);
                    int version = Integer.parseInt(str[0]);
                    if (version == 1) {
                        offset = this.extractLine(buffer, offset, str);
                        String manifestPackage = str[0];
                        if (manifestPackage.equals(info.packageName)) {
                            offset = this.extractLine(buffer, offset, str);
                            version = Integer.parseInt(str[0]);
                            offset = this.extractLine(buffer, offset, str);
                            int platformVersion = Integer.parseInt(str[0]);
                            offset = this.extractLine(buffer, offset, str);
                            info.installerPackageName = str[0].length() > 0 ? str[0] : null;
                            offset = this.extractLine(buffer, offset, str);
                            boolean hasApk = str[0].equals("1");
                            offset = this.extractLine(buffer, offset, str);
                            int numSigs = Integer.parseInt(str[0]);
                            if (numSigs > 0) {
                                Signature[] sigs = new Signature[numSigs];
                                for (int i = 0; i < numSigs; ++i) {
                                    offset = this.extractLine(buffer, offset, str);
                                    sigs[i] = new Signature(str[0]);
                                }
                                this.mManifestSignatures.put(info.packageName, sigs);
                                try {
                                    PackageInfo pkgInfo = BackupManagerService.this.mPackageManager.getPackageInfo(info.packageName, 64);
                                    int flags = pkgInfo.applicationInfo.flags;
                                    if ((flags & 0x8000) != 0) {
                                        if (pkgInfo.applicationInfo.uid >= 10000 || pkgInfo.applicationInfo.backupAgentName != null) {
                                            if (BackupManagerService.signaturesMatch(sigs, pkgInfo)) {
                                                if (pkgInfo.versionCode >= version) {
                                                    Slog.i("RestoreEngine", "Sig + version match; taking data");
                                                    policy = RestorePolicy.ACCEPT;
                                                } else if (this.mAllowApks) {
                                                    Slog.i("RestoreEngine", "Data version " + version + " is newer than installed version " + pkgInfo.versionCode + " - requiring apk");
                                                    policy = RestorePolicy.ACCEPT_IF_APK;
                                                } else {
                                                    Slog.i("RestoreEngine", "Data requires newer version " + version + "; ignoring");
                                                    policy = RestorePolicy.IGNORE;
                                                }
                                            } else {
                                                Slog.w("RestoreEngine", "Restore manifest signatures do not match installed application for " + info.packageName);
                                            }
                                        } else {
                                            Slog.w("RestoreEngine", "Package " + info.packageName + " is system level with no agent");
                                        }
                                    } else {
                                        Slog.i("RestoreEngine", "Restore manifest from " + info.packageName + " but allowBackup=false");
                                    }
                                }
                                catch (PackageManager.NameNotFoundException e) {
                                    if (this.mAllowApks) {
                                        Slog.i("RestoreEngine", "Package " + info.packageName + " not installed; requiring apk in dataset");
                                        policy = RestorePolicy.ACCEPT_IF_APK;
                                    }
                                    policy = RestorePolicy.IGNORE;
                                }
                                if (policy == RestorePolicy.ACCEPT_IF_APK && !hasApk) {
                                    Slog.i("RestoreEngine", "Cannot restore package " + info.packageName + " without the matching .apk");
                                }
                                break block24;
                            }
                            Slog.i("RestoreEngine", "Missing signature on backed-up package " + info.packageName);
                            break block24;
                        }
                        Slog.i("RestoreEngine", "Expected package " + info.packageName + " but restore manifest claims " + manifestPackage);
                        break block24;
                    }
                    Slog.i("RestoreEngine", "Unknown restore manifest version " + version + " for package " + info.packageName);
                }
                catch (NumberFormatException e) {
                    Slog.w("RestoreEngine", "Corrupt restore manifest for package " + info.packageName);
                }
                catch (IllegalArgumentException e) {
                    Slog.w("RestoreEngine", e.getMessage());
                }
            }
            return policy;
        }

        int extractLine(byte[] buffer, int offset, String[] outStr) throws IOException {
            byte c;
            int pos;
            int end = buffer.length;
            if (offset >= end) {
                throw new IOException("Incomplete data");
            }
            for (pos = offset; pos < end && (c = buffer[pos]) != 10; ++pos) {
            }
            outStr[0] = new String(buffer, offset, pos - offset);
            return ++pos;
        }

        void dumpFileMetadata(FileMetadata info) {
            StringBuilder b = new StringBuilder(128);
            b.append(info.type == 2 ? (char)'d' : '-');
            b.append((info.mode & 0x100L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 0x80L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 0x40L) != 0L ? (char)'x' : '-');
            b.append((info.mode & 0x20L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 0x10L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 8L) != 0L ? (char)'x' : '-');
            b.append((info.mode & 4L) != 0L ? (char)'r' : '-');
            b.append((info.mode & 2L) != 0L ? (char)'w' : '-');
            b.append((info.mode & 1L) != 0L ? (char)'x' : '-');
            b.append(String.format(" %9d ", info.size));
            Date stamp = new Date(info.mtime);
            b.append(new SimpleDateFormat("MMM dd HH:mm:ss ").format(stamp));
            b.append(info.packageName);
            b.append(" :: ");
            b.append(info.domain);
            b.append(" :: ");
            b.append(info.path);
            Slog.i("RestoreEngine", b.toString());
        }

        FileMetadata readTarHeaders(InputStream instream) throws IOException {
            byte[] block = new byte[512];
            FileMetadata info = null;
            boolean gotHeader = this.readTarHeader(instream, block);
            if (gotHeader) {
                try {
                    byte typeChar;
                    info = new FileMetadata();
                    info.size = this.extractRadix(block, 124, 12, 8);
                    info.mtime = this.extractRadix(block, 136, 12, 8);
                    info.mode = this.extractRadix(block, 100, 8, 8);
                    info.path = this.extractString(block, 345, 155);
                    String path = this.extractString(block, 0, 100);
                    if (path.length() > 0) {
                        if (info.path.length() > 0) {
                            info.path = info.path + '/';
                        }
                        info.path = info.path + path;
                    }
                    if ((typeChar = block[156]) == 120) {
                        gotHeader = this.readPaxExtendedHeader(instream, info);
                        if (gotHeader) {
                            gotHeader = this.readTarHeader(instream, block);
                        }
                        if (!gotHeader) {
                            throw new IOException("Bad or missing pax header");
                        }
                        typeChar = block[156];
                    }
                    switch (typeChar) {
                        case 48: {
                            info.type = 1;
                            break;
                        }
                        case 53: {
                            info.type = 2;
                            if (info.size == 0L) break;
                            Slog.w("RestoreEngine", "Directory entry with nonzero size in header");
                            info.size = 0L;
                            break;
                        }
                        case 0: {
                            Slog.w("RestoreEngine", "Saw type=0 in tar header block, info=" + info);
                            return null;
                        }
                        default: {
                            Slog.e("RestoreEngine", "Unknown tar entity type: " + typeChar);
                            throw new IOException("Unknown entity type " + typeChar);
                        }
                    }
                    if ("shared/".regionMatches(0, info.path, 0, "shared/".length())) {
                        info.path = info.path.substring("shared/".length());
                        info.packageName = BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE;
                        info.domain = "shared";
                        Slog.i("RestoreEngine", "File in shared storage: " + info.path);
                    } else if ("apps/".regionMatches(0, info.path, 0, "apps/".length())) {
                        info.path = info.path.substring("apps/".length());
                        int slash = info.path.indexOf(47);
                        if (slash < 0) {
                            throw new IOException("Illegal semantic path in " + info.path);
                        }
                        info.packageName = info.path.substring(0, slash);
                        info.path = info.path.substring(slash + 1);
                        if (!info.path.equals(BackupManagerService.BACKUP_MANIFEST_FILENAME) && !info.path.equals(BackupManagerService.BACKUP_METADATA_FILENAME)) {
                            slash = info.path.indexOf(47);
                            if (slash < 0) {
                                throw new IOException("Illegal semantic path in non-manifest " + info.path);
                            }
                            info.domain = info.path.substring(0, slash);
                            info.path = info.path.substring(slash + 1);
                        }
                    }
                }
                catch (IOException e) {
                    Slog.e("RestoreEngine", "Parse error in header: " + e.getMessage());
                    this.HEXLOG(block);
                    throw e;
                }
            }
            return info;
        }

        private boolean isRestorableFile(FileMetadata info) {
            if ("c".equals(info.domain)) {
                return false;
            }
            if ("r".equals(info.domain) && info.path.startsWith("no_backup/")) {
                return false;
            }
            return !info.path.contains("..") && !info.path.contains("//");
        }

        private void HEXLOG(byte[] block) {
            int offset = 0;
            int todo = block.length;
            StringBuilder buf = new StringBuilder(64);
            while (todo > 0) {
                buf.append(String.format("%04x   ", offset));
                int numThisLine = todo > 16 ? 16 : todo;
                for (int i = 0; i < numThisLine; ++i) {
                    buf.append(String.format("%02x ", block[offset + i]));
                }
                Slog.i("hexdump", buf.toString());
                buf.setLength(0);
                todo -= numThisLine;
                offset += numThisLine;
            }
        }

        int readExactly(InputStream in, byte[] buffer, int offset, int size) throws IOException {
            int soFar;
            int nRead;
            if (size <= 0) {
                throw new IllegalArgumentException("size must be > 0");
            }
            for (soFar = 0; soFar < size && (nRead = in.read(buffer, offset + soFar, size - soFar)) > 0; soFar += nRead) {
            }
            return soFar;
        }

        boolean readTarHeader(InputStream instream, byte[] block) throws IOException {
            int got = this.readExactly(instream, block, 0, 512);
            if (got == 0) {
                return false;
            }
            if (got < 512) {
                throw new IOException("Unable to read full block header");
            }
            this.mBytes += 512L;
            return true;
        }

        boolean readPaxExtendedHeader(InputStream instream, FileMetadata info) throws IOException {
            int linelen;
            if (info.size > 32768L) {
                Slog.w("RestoreEngine", "Suspiciously large pax header size " + info.size + " - aborting");
                throw new IOException("Sanity failure: pax header size " + info.size);
            }
            int numBlocks = (int)(info.size + 511L >> 9);
            byte[] data = new byte[numBlocks * 512];
            if (this.readExactly(instream, data, 0, data.length) < data.length) {
                throw new IOException("Unable to read full pax header");
            }
            this.mBytes += (long)data.length;
            int contentSize = (int)info.size;
            int offset = 0;
            do {
                int value;
                int eol;
                for (eol = offset + 1; eol < contentSize && data[eol] != 32; ++eol) {
                }
                if (eol >= contentSize) {
                    throw new IOException("Invalid pax data");
                }
                linelen = (int)this.extractRadix(data, offset, eol - offset, 10);
                int key = eol + 1;
                eol = offset + linelen - 1;
                for (value = key + 1; data[value] != 61 && value <= eol; ++value) {
                }
                if (value > eol) {
                    throw new IOException("Invalid pax declaration");
                }
                String keyStr = new String(data, key, value - key, "UTF-8");
                String valStr = new String(data, value + 1, eol - value - 1, "UTF-8");
                if ("path".equals(keyStr)) {
                    info.path = valStr;
                    continue;
                }
                if ("size".equals(keyStr)) {
                    info.size = Long.parseLong(valStr);
                    continue;
                }
                Slog.i("RestoreEngine", "Unhandled pax key: " + key);
            } while ((offset += linelen) < contentSize);
            return true;
        }

        long extractRadix(byte[] data, int offset, int maxChars, int radix) throws IOException {
            byte b;
            long value = 0L;
            int end = offset + maxChars;
            for (int i = offset; i < end && (b = data[i]) != 0 && b != 32; ++i) {
                if (b < 48 || b > 48 + radix - 1) {
                    throw new IOException("Invalid number in header: '" + (char)b + "' for radix " + radix);
                }
                value = (long)radix * value + (long)(b - 48);
            }
            return value;
        }

        String extractString(byte[] data, int offset, int maxChars) throws IOException {
            int eos;
            int end = offset + maxChars;
            for (eos = offset; eos < end && data[eos] != 0; ++eos) {
            }
            return new String(data, offset, eos - offset, "US-ASCII");
        }

        void sendStartRestore() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onStartRestore();
                }
                catch (RemoteException e) {
                    Slog.w("RestoreEngine", "full restore observer went away: startRestore");
                    this.mObserver = null;
                }
            }
        }

        void sendOnRestorePackage(String name) {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onRestorePackage(name);
                }
                catch (RemoteException e) {
                    Slog.w("RestoreEngine", "full restore observer went away: restorePackage");
                    this.mObserver = null;
                }
            }
        }

        void sendEndRestore() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onEndRestore();
                }
                catch (RemoteException e) {
                    Slog.w("RestoreEngine", "full restore observer went away: endRestore");
                    this.mObserver = null;
                }
            }
        }

        class RestoreDeleteObserver
        extends IPackageDeleteObserver.Stub {
            final AtomicBoolean mDone = new AtomicBoolean();
            int mResult;

            RestoreDeleteObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mDone.set(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForCompletion() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    while (!this.mDone.get()) {
                        try {
                            this.mDone.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void packageDeleted(String packageName, int returnCode) throws RemoteException {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mResult = returnCode;
                    this.mDone.set(true);
                    this.mDone.notifyAll();
                }
            }
        }

        class RestoreInstallObserver
        extends IPackageInstallObserver.Stub {
            final AtomicBoolean mDone = new AtomicBoolean();
            String mPackageName;
            int mResult;

            RestoreInstallObserver() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void reset() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mDone.set(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForCompletion() {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    while (!this.mDone.get()) {
                        try {
                            this.mDone.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            int getResult() {
                return this.mResult;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void packageInstalled(String packageName, int returnCode) throws RemoteException {
                AtomicBoolean atomicBoolean = this.mDone;
                synchronized (atomicBoolean) {
                    this.mResult = returnCode;
                    this.mPackageName = packageName;
                    this.mDone.set(true);
                    this.mDone.notifyAll();
                }
            }
        }

        class RestoreFileRunnable
        implements Runnable {
            IBackupAgent mAgent;
            FileMetadata mInfo;
            ParcelFileDescriptor mSocket;
            int mToken;

            RestoreFileRunnable(IBackupAgent agent, FileMetadata info, ParcelFileDescriptor socket, int token) throws IOException {
                this.mAgent = agent;
                this.mInfo = info;
                this.mToken = token;
                this.mSocket = ParcelFileDescriptor.dup(socket.getFileDescriptor());
            }

            @Override
            public void run() {
                try {
                    this.mAgent.doRestoreFile(this.mSocket, this.mInfo.size, this.mInfo.type, this.mInfo.domain, this.mInfo.path, this.mInfo.mode, this.mInfo.mtime, this.mToken, BackupManagerService.this.mBackupManagerBinder);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    static enum RestorePolicy {
        IGNORE,
        ACCEPT,
        ACCEPT_IF_APK;

    }

    static class FileMetadata {
        String packageName;
        String installerPackageName;
        int type;
        String domain;
        String path;
        long mode;
        long mtime;
        long size;

        FileMetadata() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("FileMetadata{");
            sb.append(this.packageName);
            sb.append(',');
            sb.append(this.type);
            sb.append(',');
            sb.append(this.domain);
            sb.append(':');
            sb.append(this.path);
            sb.append(',');
            sb.append(this.size);
            sb.append('}');
            return sb.toString();
        }
    }

    abstract class RestoreEngine {
        static final String TAG = "RestoreEngine";
        public static final int SUCCESS = 0;
        public static final int TARGET_FAILURE = -2;
        public static final int TRANSPORT_FAILURE = -3;
        private AtomicBoolean mRunning = new AtomicBoolean(false);
        private AtomicInteger mResult = new AtomicInteger(0);

        RestoreEngine() {
        }

        public boolean isRunning() {
            return this.mRunning.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRunning(boolean stillRunning) {
            AtomicBoolean atomicBoolean = this.mRunning;
            synchronized (atomicBoolean) {
                this.mRunning.set(stillRunning);
                this.mRunning.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitForResult() {
            AtomicBoolean atomicBoolean = this.mRunning;
            synchronized (atomicBoolean) {
                while (this.isRunning()) {
                    try {
                        this.mRunning.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return this.getResult();
        }

        public int getResult() {
            return this.mResult.get();
        }

        public void setResult(int result) {
            this.mResult.set(result);
        }
    }

    class PerformFullTransportBackupTask
    extends FullBackupTask {
        static final String TAG = "PFTBT";
        ArrayList<PackageInfo> mPackages;
        boolean mUpdateSchedule;
        AtomicBoolean mLatch;
        AtomicBoolean mKeepRunning;
        FullBackupJob mJob;

        PerformFullTransportBackupTask(IFullBackupRestoreObserver observer, String[] whichPackages, boolean updateSchedule, FullBackupJob runningJob, AtomicBoolean latch) {
            super(observer);
            this.mUpdateSchedule = updateSchedule;
            this.mLatch = latch;
            this.mKeepRunning = new AtomicBoolean(true);
            this.mJob = runningJob;
            this.mPackages = new ArrayList(whichPackages.length);
            for (String pkg : whichPackages) {
                try {
                    PackageInfo info = BackupManagerService.this.mPackageManager.getPackageInfo(pkg, 64);
                    if ((info.applicationInfo.flags & 0x8000) == 0 || pkg.equals(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE) || info.applicationInfo.uid < 10000 && info.applicationInfo.backupAgentName == null) continue;
                    this.mPackages.add(info);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.i(TAG, "Requested package " + pkg + " not found; ignoring");
                }
            }
        }

        public void setRunning(boolean running) {
            this.mKeepRunning.set(running);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block43: {
                enginePipes = null;
                transportPipes = null;
                try {
                    transport = BackupManagerService.access$100(BackupManagerService.this, BackupManagerService.this.mCurrentTransport);
                    if (transport == null) {
                        Slog.w("PFTBT", "Transport not present; full data backup not performed");
                        return;
                    }
                    N = this.mPackages.size();
                    i = 0;
lbl11:
                    // 2 sources

                    while (true) {
                        if (i < N) {
                            currentPackage = this.mPackages.get(i);
                            Slog.i("PFTBT", "Initiating full-data transport backup of " + currentPackage.packageName);
                            EventLog.writeEvent(2840, currentPackage.packageName);
                            transportPipes = ParcelFileDescriptor.createPipe();
                            result = transport.performFullBackup(currentPackage, transportPipes[0]);
                            if (result != 0) break block43;
                            transportPipes[0].close();
                            transportPipes[0] = null;
                            enginePipes = ParcelFileDescriptor.createPipe();
                            runnerLatch = new AtomicBoolean(false);
                            backupRunner = new SinglePackageBackupRunner(enginePipes[1], currentPackage, runnerLatch);
                            enginePipes[1].close();
                            enginePipes[1] = null;
                            new Thread((Runnable)backupRunner, "package-backup-bridge").start();
                            in = new FileInputStream(enginePipes[0].getFileDescriptor());
                            out = new FileOutputStream(transportPipes[1].getFileDescriptor());
                            buffer = new byte[8192];
                            nRead = 0;
                            break;
                        }
                        Slog.i("PFTBT", "Full backup completed.");
                        return;
                    }
                }
                catch (Exception e) {
                    Slog.w("PFTBT", "Exception trying full transport backup", e);
                    return;
                }
                finally {
                    this.cleanUpPipes(transportPipes);
                    this.cleanUpPipes(enginePipes);
                    if (this.mJob != null) {
                        this.mJob.finishBackupPass();
                    }
                    var4_5 = BackupManagerService.this.mQueueLock;
                    synchronized (var4_5) {
                        BackupManagerService.this.mRunningFullBackupTask = null;
                    }
                    var4_5 = this.mLatch;
                    synchronized (var4_5) {
                        this.mLatch.set(true);
                        this.mLatch.notifyAll();
                        ** if (!this.mUpdateSchedule) goto lbl55
                    }
lbl-1000:
                    // 1 sources

                    {
                        BackupManagerService.this.scheduleNextFullBackupJob();
                    }
lbl55:
                    // 2 sources

                }
                do {
                    if (!this.mKeepRunning.get()) {
                        Slog.i("PFTBT", "Full backup task told to stop");
                        break;
                    }
                    nRead = in.read(buffer);
                    if (nRead <= 0) continue;
                    out.write(buffer, 0, nRead);
                    result = transport.sendBackupData(nRead);
                } while (nRead > 0 && result == 0);
                if (!this.mKeepRunning.get()) {
                    result = -1000;
                    transport.cancelFullBackup();
                } else {
                    finishResult = transport.finishBackup();
                    if (result == 0) {
                        result = finishResult;
                    }
                }
                if (result != 0) {
                    Slog.e("PFTBT", "Error " + result + " backing up " + currentPackage.packageName);
                }
            }
            if (this.mUpdateSchedule) {
                BackupManagerService.this.enqueueFullBackup(currentPackage.packageName, System.currentTimeMillis());
            }
            if (result == -1002) {
                Slog.i("PFTBT", "Transport rejected backup of " + currentPackage.packageName + ", skipping");
                EventLog.writeEvent(2841, new Object[]{currentPackage.packageName, "transport rejected"});
            } else {
                if (result != 0) {
                    Slog.i("PFTBT", "Transport failed; aborting backup: " + result);
                    EventLog.writeEvent(2842, new Object[0]);
                    this.cleanUpPipes(transportPipes);
                    this.cleanUpPipes(enginePipes);
                    if (this.mJob != null) {
                        this.mJob.finishBackupPass();
                    }
                    var8_11 = BackupManagerService.this.mQueueLock;
                    synchronized (var8_11) {
                        BackupManagerService.this.mRunningFullBackupTask = null;
                    }
                    var8_11 = this.mLatch;
                    synchronized (var8_11) {
                        this.mLatch.set(true);
                        this.mLatch.notifyAll();
                    }
                    if (this.mUpdateSchedule == false) return;
                    BackupManagerService.this.scheduleNextFullBackupJob();
                    return;
                }
                EventLog.writeEvent(2843, currentPackage.packageName);
                BackupManagerService.this.logBackupComplete(currentPackage.packageName);
            }
            this.cleanUpPipes(transportPipes);
            this.cleanUpPipes(enginePipes);
            currentPackage = null;
            ++i;
            ** while (true)
        }

        void cleanUpPipes(ParcelFileDescriptor[] pipes) {
            if (pipes != null) {
                ParcelFileDescriptor fd;
                if (pipes[0] != null) {
                    fd = pipes[0];
                    pipes[0] = null;
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        Slog.w(TAG, "Unable to close pipe!");
                    }
                }
                if (pipes[1] != null) {
                    fd = pipes[1];
                    pipes[1] = null;
                    try {
                        fd.close();
                    }
                    catch (IOException e) {
                        Slog.w(TAG, "Unable to close pipe!");
                    }
                }
            }
        }

        class SinglePackageBackupRunner
        implements Runnable {
            final ParcelFileDescriptor mOutput;
            final PackageInfo mTarget;
            final AtomicBoolean mLatch;

            SinglePackageBackupRunner(ParcelFileDescriptor output, PackageInfo target, AtomicBoolean latch) throws IOException {
                int oldfd = output.getFd();
                this.mOutput = ParcelFileDescriptor.dup(output.getFileDescriptor());
                this.mTarget = target;
                this.mLatch = latch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    FileOutputStream out = new FileOutputStream(this.mOutput.getFileDescriptor());
                    FullBackupEngine engine = new FullBackupEngine(out, this.mTarget.packageName, false);
                    engine.backupOnePackage(this.mTarget);
                }
                catch (Exception e) {
                    Slog.e(PerformFullTransportBackupTask.TAG, "Exception during full package backup of " + this.mTarget);
                }
                finally {
                    AtomicBoolean e = this.mLatch;
                    synchronized (e) {
                        this.mLatch.set(true);
                        this.mLatch.notifyAll();
                    }
                    try {
                        this.mOutput.close();
                    }
                    catch (IOException e2) {
                        Slog.w(PerformFullTransportBackupTask.TAG, "Error closing transport pipe in runner");
                    }
                }
            }
        }
    }

    class PerformAdbBackupTask
    extends FullBackupTask {
        FullBackupEngine mBackupEngine;
        final AtomicBoolean mLatch;
        ParcelFileDescriptor mOutputFile;
        DeflaterOutputStream mDeflater;
        boolean mIncludeApks;
        boolean mIncludeObbs;
        boolean mIncludeShared;
        boolean mDoWidgets;
        boolean mAllApps;
        boolean mIncludeSystem;
        boolean mCompress;
        ArrayList<String> mPackages;
        String mCurrentPassword;
        String mEncryptPassword;

        PerformAdbBackupTask(ParcelFileDescriptor fd, IFullBackupRestoreObserver observer, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, String curPassword, String encryptPassword, boolean doAllApps, boolean doSystem, boolean doCompress, String[] packages, AtomicBoolean latch) {
            super(observer);
            this.mLatch = latch;
            this.mOutputFile = fd;
            this.mIncludeApks = includeApks;
            this.mIncludeObbs = includeObbs;
            this.mIncludeShared = includeShared;
            this.mDoWidgets = doWidgets;
            this.mAllApps = doAllApps;
            this.mIncludeSystem = doSystem;
            this.mPackages = packages == null ? new ArrayList() : new ArrayList<String>(Arrays.asList(packages));
            this.mCurrentPassword = curPassword;
            this.mEncryptPassword = encryptPassword == null || "".equals(encryptPassword) ? curPassword : encryptPassword;
            this.mCompress = doCompress;
        }

        void addPackagesToSet(TreeMap<String, PackageInfo> set, List<String> pkgNames) {
            for (String pkgName : pkgNames) {
                if (set.containsKey(pkgName)) continue;
                try {
                    PackageInfo info = BackupManagerService.this.mPackageManager.getPackageInfo(pkgName, 64);
                    set.put(pkgName, info);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.w(BackupManagerService.TAG, "Unknown package " + pkgName + ", skipping");
                }
            }
        }

        private OutputStream emitAesBackupHeader(StringBuilder headerbuf, OutputStream ofstream) throws Exception {
            byte[] newUserSalt = BackupManagerService.this.randomBytes(512);
            SecretKey userKey = BackupManagerService.this.buildPasswordKey(BackupManagerService.PBKDF_CURRENT, this.mEncryptPassword, newUserSalt, 10000);
            byte[] masterPw = new byte[32];
            BackupManagerService.this.mRng.nextBytes(masterPw);
            byte[] checksumSalt = BackupManagerService.this.randomBytes(512);
            Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec masterKeySpec = new SecretKeySpec(masterPw, "AES");
            c.init(1, masterKeySpec);
            CipherOutputStream finalOutput = new CipherOutputStream(ofstream, c);
            headerbuf.append(BackupManagerService.ENCRYPTION_ALGORITHM_NAME);
            headerbuf.append('\n');
            headerbuf.append(BackupManagerService.this.byteArrayToHex(newUserSalt));
            headerbuf.append('\n');
            headerbuf.append(BackupManagerService.this.byteArrayToHex(checksumSalt));
            headerbuf.append('\n');
            headerbuf.append(10000);
            headerbuf.append('\n');
            Cipher mkC = Cipher.getInstance("AES/CBC/PKCS5Padding");
            mkC.init(1, userKey);
            byte[] IV = mkC.getIV();
            headerbuf.append(BackupManagerService.this.byteArrayToHex(IV));
            headerbuf.append('\n');
            IV = c.getIV();
            byte[] mk = masterKeySpec.getEncoded();
            byte[] checksum = BackupManagerService.this.makeKeyChecksum(BackupManagerService.PBKDF_CURRENT, masterKeySpec.getEncoded(), checksumSalt, 10000);
            ByteArrayOutputStream blob = new ByteArrayOutputStream(IV.length + mk.length + checksum.length + 3);
            DataOutputStream mkOut = new DataOutputStream(blob);
            mkOut.writeByte(IV.length);
            mkOut.write(IV);
            mkOut.writeByte(mk.length);
            mkOut.write(mk);
            mkOut.writeByte(checksum.length);
            mkOut.write(checksum);
            mkOut.flush();
            byte[] encryptedMk = mkC.doFinal(blob.toByteArray());
            headerbuf.append(BackupManagerService.this.byteArrayToHex(encryptedMk));
            headerbuf.append('\n');
            return finalOutput;
        }

        private void finalizeBackup(OutputStream out) {
            try {
                byte[] eof = new byte[1024];
                out.write(eof);
            }
            catch (IOException e) {
                Slog.w(BackupManagerService.TAG, "Error attempting to finalize backup stream");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List<String> pkgs;
            Slog.i(BackupManagerService.TAG, "--- Performing full-dataset adb backup ---");
            TreeMap<String, PackageInfo> packagesToBackup = new TreeMap<String, PackageInfo>();
            FullBackupObbConnection obbConnection = new FullBackupObbConnection();
            obbConnection.establish();
            this.sendStartBackup();
            if (this.mAllApps) {
                List<PackageInfo> allPackages = BackupManagerService.this.mPackageManager.getInstalledPackages(64);
                for (int i = 0; i < allPackages.size(); ++i) {
                    PackageInfo pkg = allPackages.get(i);
                    if (!this.mIncludeSystem && (pkg.applicationInfo.flags & 1) != 0) continue;
                    packagesToBackup.put(pkg.packageName, pkg);
                }
            }
            if (this.mDoWidgets && (pkgs = AppWidgetBackupBridge.getWidgetParticipants(0)) != null) {
                this.addPackagesToSet(packagesToBackup, pkgs);
            }
            if (this.mPackages != null) {
                this.addPackagesToSet(packagesToBackup, this.mPackages);
            }
            Iterator iter = packagesToBackup.entrySet().iterator();
            while (iter.hasNext()) {
                PackageInfo pkg = (PackageInfo)iter.next().getValue();
                if (BackupManagerService.appIsEligibleForBackup(pkg.applicationInfo)) continue;
                iter.remove();
            }
            ArrayList backupQueue = new ArrayList(packagesToBackup.values());
            FileOutputStream ofstream = new FileOutputStream(this.mOutputFile.getFileDescriptor());
            OutputStream out = null;
            PackageInfo pkg = null;
            try {
                boolean encrypting;
                boolean bl = encrypting = this.mEncryptPassword != null && this.mEncryptPassword.length() > 0;
                if (BackupManagerService.this.deviceIsEncrypted() && !encrypting) {
                    Slog.e(BackupManagerService.TAG, "Unencrypted backup of encrypted device; aborting");
                    return;
                }
                OutputStream finalOutput = ofstream;
                if (!BackupManagerService.this.backupPasswordMatches(this.mCurrentPassword)) {
                    Slog.w(BackupManagerService.TAG, "Backup password mismatch; aborting");
                    return;
                }
                StringBuilder headerbuf = new StringBuilder(1024);
                headerbuf.append(BackupManagerService.BACKUP_FILE_HEADER_MAGIC);
                headerbuf.append(3);
                headerbuf.append(this.mCompress ? "\n1\n" : "\n0\n");
                try {
                    if (encrypting) {
                        finalOutput = this.emitAesBackupHeader(headerbuf, finalOutput);
                    } else {
                        headerbuf.append("none\n");
                    }
                    byte[] header = headerbuf.toString().getBytes("UTF-8");
                    ofstream.write(header);
                    if (this.mCompress) {
                        Deflater deflater = new Deflater(9);
                        finalOutput = new DeflaterOutputStream(finalOutput, deflater, true);
                    }
                    out = finalOutput;
                }
                catch (Exception e) {
                    Slog.e(BackupManagerService.TAG, "Unable to emit archive header", e);
                    try {
                        if (out != null) {
                            out.close();
                        }
                        this.mOutputFile.close();
                    }
                    catch (IOException deflater) {
                        // empty catch block
                    }
                    Object deflater = BackupManagerService.this.mCurrentOpLock;
                    synchronized (deflater) {
                        BackupManagerService.this.mCurrentOperations.clear();
                    }
                    deflater = this.mLatch;
                    synchronized (deflater) {
                        this.mLatch.set(true);
                        this.mLatch.notifyAll();
                    }
                    this.sendEndBackup();
                    obbConnection.tearDown();
                    Slog.d(BackupManagerService.TAG, "Full backup pass complete.");
                    BackupManagerService.this.mWakelock.release();
                    return;
                }
                if (this.mIncludeShared) {
                    try {
                        pkg = BackupManagerService.this.mPackageManager.getPackageInfo(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE, 0);
                        backupQueue.add(pkg);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.e(BackupManagerService.TAG, "Unable to find shared-storage backup handler");
                    }
                }
                int N = backupQueue.size();
                for (int i = 0; i < N; ++i) {
                    boolean obbOkay;
                    pkg = (PackageInfo)backupQueue.get(i);
                    boolean isSharedStorage = pkg.packageName.equals(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE);
                    this.mBackupEngine = new FullBackupEngine(out, pkg.packageName, this.mIncludeApks);
                    this.sendOnBackupPackage(isSharedStorage ? "Shared storage" : pkg.packageName);
                    this.mBackupEngine.backupOnePackage(pkg);
                    if (!this.mIncludeObbs || (obbOkay = obbConnection.backupObbs(pkg, out))) continue;
                    throw new RuntimeException("Failure writing OBB stack for " + pkg);
                }
                this.finalizeBackup(out);
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "App died during full backup");
            }
            catch (Exception e) {
                Slog.e(BackupManagerService.TAG, "Internal exception during full backup", e);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                    this.mOutputFile.close();
                }
                catch (IOException e) {}
                Object e = BackupManagerService.this.mCurrentOpLock;
                synchronized (e) {
                    BackupManagerService.this.mCurrentOperations.clear();
                }
                e = this.mLatch;
                synchronized (e) {
                    this.mLatch.set(true);
                    this.mLatch.notifyAll();
                }
                this.sendEndBackup();
                obbConnection.tearDown();
                Slog.d(BackupManagerService.TAG, "Full backup pass complete.");
                BackupManagerService.this.mWakelock.release();
            }
        }
    }

    abstract class FullBackupTask
    implements Runnable {
        IFullBackupRestoreObserver mObserver;

        FullBackupTask(IFullBackupRestoreObserver observer) {
            this.mObserver = observer;
        }

        final void sendStartBackup() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onStartBackup();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full backup observer went away: startBackup");
                    this.mObserver = null;
                }
            }
        }

        final void sendOnBackupPackage(String name) {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onBackupPackage(name);
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full backup observer went away: backupPackage");
                    this.mObserver = null;
                }
            }
        }

        final void sendEndBackup() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onEndBackup();
                }
                catch (RemoteException e) {
                    Slog.w(BackupManagerService.TAG, "full backup observer went away: endBackup");
                    this.mObserver = null;
                }
            }
        }
    }

    class FullBackupEngine {
        OutputStream mOutput;
        IFullBackupRestoreObserver mObserver;
        File mFilesDir;
        File mManifestFile;
        File mMetadataFile;
        boolean mIncludeApks;

        FullBackupEngine(OutputStream output, String packageName, boolean alsoApks) {
            this.mOutput = output;
            this.mIncludeApks = alsoApks;
            this.mFilesDir = new File("/data/system");
            this.mManifestFile = new File(this.mFilesDir, BackupManagerService.BACKUP_MANIFEST_FILENAME);
            this.mMetadataFile = new File(this.mFilesDir, BackupManagerService.BACKUP_METADATA_FILENAME);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int backupOnePackage(PackageInfo pkg) throws RemoteException {
            int result = 0;
            Slog.d(BackupManagerService.TAG, "Binding to full backup agent : " + pkg.packageName);
            IBackupAgent agent = BackupManagerService.this.bindToAgentSynchronous(pkg.applicationInfo, 1);
            if (agent != null) {
                ParcelFileDescriptor[] pipes = null;
                try {
                    pipes = ParcelFileDescriptor.createPipe();
                    ApplicationInfo app = pkg.applicationInfo;
                    boolean isSharedStorage = pkg.packageName.equals(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE);
                    boolean sendApk = this.mIncludeApks && !isSharedStorage && (app.flags & 0x20000000) == 0 && ((app.flags & 1) == 0 || (app.flags & 0x80) != 0);
                    byte[] widgetBlob = AppWidgetBackupBridge.getWidgetState(pkg.packageName, 0);
                    int token = BackupManagerService.this.generateToken();
                    FullBackupRunner runner = new FullBackupRunner(pkg, agent, pipes[1], token, sendApk, !isSharedStorage, widgetBlob);
                    pipes[1].close();
                    pipes[1] = null;
                    Thread t = new Thread((Runnable)runner, "app-data-runner");
                    t.start();
                    try {
                        BackupManagerService.this.routeSocketDataToOutput(pipes[0], this.mOutput);
                    }
                    catch (IOException e) {
                        Slog.i(BackupManagerService.TAG, "Caught exception reading from agent", e);
                        result = -1003;
                    }
                    if (!BackupManagerService.this.waitUntilOperationComplete(token)) {
                        Slog.e(BackupManagerService.TAG, "Full backup failed on package " + pkg.packageName);
                        result = -1003;
                    }
                    Slog.d(BackupManagerService.TAG, "Full package backup success: " + pkg.packageName);
                }
                catch (IOException e) {
                    Slog.e(BackupManagerService.TAG, "Error backing up " + pkg.packageName, e);
                    result = -1003;
                }
                finally {
                    try {
                        this.mOutput.flush();
                        if (pipes != null) {
                            if (pipes[0] != null) {
                                pipes[0].close();
                            }
                            if (pipes[1] != null) {
                                pipes[1].close();
                            }
                        }
                    }
                    catch (IOException e) {
                        Slog.w(BackupManagerService.TAG, "Error bringing down backup stack");
                        result = -1000;
                    }
                }
            } else {
                Slog.w(BackupManagerService.TAG, "Unable to bind to full agent for " + pkg.packageName);
                result = -1003;
            }
            this.tearDown(pkg);
            return result;
        }

        private void writeApkToBackup(PackageInfo pkg, BackupDataOutput output) {
            File[] obbFiles;
            String appSourceDir = pkg.applicationInfo.getBaseCodePath();
            String apkDir = new File(appSourceDir).getParent();
            FullBackup.backupToTar(pkg.packageName, "a", null, apkDir, appSourceDir, output);
            Environment.UserEnvironment userEnv = new Environment.UserEnvironment(0);
            File obbDir = userEnv.buildExternalStorageAppObbDirs(pkg.packageName)[0];
            if (obbDir != null && (obbFiles = obbDir.listFiles()) != null) {
                String obbDirName = obbDir.getAbsolutePath();
                for (File obb : obbFiles) {
                    FullBackup.backupToTar(pkg.packageName, "obb", null, obbDirName, obb.getAbsolutePath(), output);
                }
            }
        }

        private void writeAppManifest(PackageInfo pkg, File manifestFile, boolean withApk, boolean withWidgets) throws IOException {
            StringBuilder builder = new StringBuilder(4096);
            StringBuilderPrinter printer = new StringBuilderPrinter(builder);
            printer.println(Integer.toString(1));
            printer.println(pkg.packageName);
            printer.println(Integer.toString(pkg.versionCode));
            printer.println(Integer.toString(Build.VERSION.SDK_INT));
            String installerName = BackupManagerService.this.mPackageManager.getInstallerPackageName(pkg.packageName);
            printer.println(installerName != null ? installerName : "");
            printer.println(withApk ? "1" : "0");
            if (pkg.signatures == null) {
                printer.println("0");
            } else {
                printer.println(Integer.toString(pkg.signatures.length));
                for (Signature sig : pkg.signatures) {
                    printer.println(sig.toCharsString());
                }
            }
            FileOutputStream outstream = new FileOutputStream(manifestFile);
            outstream.write(builder.toString().getBytes());
            outstream.close();
            manifestFile.setLastModified(0L);
        }

        private void writeMetadata(PackageInfo pkg, File destination, byte[] widgetData) throws IOException {
            StringBuilder b = new StringBuilder(512);
            StringBuilderPrinter printer = new StringBuilderPrinter(b);
            printer.println(Integer.toString(1));
            printer.println(pkg.packageName);
            FileOutputStream fout = new FileOutputStream(destination);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            DataOutputStream out = new DataOutputStream(bout);
            bout.write(b.toString().getBytes());
            if (widgetData != null && widgetData.length > 0) {
                out.writeInt(33549569);
                out.writeInt(widgetData.length);
                out.write(widgetData);
            }
            bout.flush();
            out.close();
            destination.setLastModified(0L);
        }

        private void tearDown(PackageInfo pkg) {
            ApplicationInfo app;
            if (pkg != null && (app = pkg.applicationInfo) != null) {
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(app);
                    if (app.uid != 1000 && app.uid != 1001) {
                        BackupManagerService.this.mActivityManager.killApplicationProcess(app.processName, app.uid);
                    }
                }
                catch (RemoteException e) {
                    Slog.d(BackupManagerService.TAG, "Lost app trying to shut down");
                }
            }
        }

        class FullBackupRunner
        implements Runnable {
            PackageInfo mPackage;
            byte[] mWidgetData;
            IBackupAgent mAgent;
            ParcelFileDescriptor mPipe;
            int mToken;
            boolean mSendApk;
            boolean mWriteManifest;

            FullBackupRunner(PackageInfo pack, IBackupAgent agent, ParcelFileDescriptor pipe, int token, boolean sendApk, boolean writeManifest, byte[] widgetData) throws IOException {
                this.mPackage = pack;
                this.mWidgetData = widgetData;
                this.mAgent = agent;
                this.mPipe = ParcelFileDescriptor.dup(pipe.getFileDescriptor());
                this.mToken = token;
                this.mSendApk = sendApk;
                this.mWriteManifest = writeManifest;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BackupDataOutput output = new BackupDataOutput(this.mPipe.getFileDescriptor());
                    if (this.mWriteManifest) {
                        boolean writeWidgetData = this.mWidgetData != null;
                        FullBackupEngine.this.writeAppManifest(this.mPackage, FullBackupEngine.this.mManifestFile, this.mSendApk, writeWidgetData);
                        FullBackup.backupToTar(this.mPackage.packageName, null, null, FullBackupEngine.this.mFilesDir.getAbsolutePath(), FullBackupEngine.this.mManifestFile.getAbsolutePath(), output);
                        FullBackupEngine.this.mManifestFile.delete();
                        if (writeWidgetData) {
                            FullBackupEngine.this.writeMetadata(this.mPackage, FullBackupEngine.this.mMetadataFile, this.mWidgetData);
                            FullBackup.backupToTar(this.mPackage.packageName, null, null, FullBackupEngine.this.mFilesDir.getAbsolutePath(), FullBackupEngine.this.mMetadataFile.getAbsolutePath(), output);
                            FullBackupEngine.this.mMetadataFile.delete();
                        }
                    }
                    if (this.mSendApk) {
                        FullBackupEngine.this.writeApkToBackup(this.mPackage, output);
                    }
                    Slog.d(BackupManagerService.TAG, "Calling doFullBackup() on " + this.mPackage.packageName);
                    BackupManagerService.this.prepareOperationTimeout(this.mToken, 300000L, null);
                    this.mAgent.doFullBackup(this.mPipe, this.mToken, BackupManagerService.this.mBackupManagerBinder);
                }
                catch (IOException e) {
                    Slog.e(BackupManagerService.TAG, "Error running full backup for " + this.mPackage.packageName);
                }
                catch (RemoteException e) {
                    Slog.e(BackupManagerService.TAG, "Remote agent vanished during full backup of " + this.mPackage.packageName);
                }
                finally {
                    try {
                        this.mPipe.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    class FullBackupObbConnection
    implements ServiceConnection {
        volatile IObbBackupService mService = null;

        FullBackupObbConnection() {
        }

        public void establish() {
            Slog.i(BackupManagerService.TAG, "Initiating bind of OBB service on " + this);
            Intent obbIntent = new Intent().setComponent(new ComponentName(BackupManagerService.SHARED_BACKUP_AGENT_PACKAGE, "com.android.sharedstoragebackup.ObbBackupService"));
            BackupManagerService.this.mContext.bindService(obbIntent, this, 1);
        }

        public void tearDown() {
            BackupManagerService.this.mContext.unbindService(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean backupObbs(PackageInfo pkg, OutputStream out) {
            boolean success = false;
            this.waitForConnection();
            ParcelFileDescriptor[] pipes = null;
            try {
                pipes = ParcelFileDescriptor.createPipe();
                int token = BackupManagerService.this.generateToken();
                BackupManagerService.this.prepareOperationTimeout(token, 300000L, null);
                this.mService.backupObbs(pkg.packageName, pipes[1], token, BackupManagerService.this.mBackupManagerBinder);
                BackupManagerService.this.routeSocketDataToOutput(pipes[0], out);
                success = BackupManagerService.this.waitUntilOperationComplete(token);
            }
            catch (Exception e) {
                Slog.w(BackupManagerService.TAG, "Unable to back up OBBs for " + pkg, e);
            }
            finally {
                try {
                    out.flush();
                    if (pipes != null) {
                        if (pipes[0] != null) {
                            pipes[0].close();
                        }
                        if (pipes[1] != null) {
                            pipes[1].close();
                        }
                    }
                }
                catch (IOException e) {
                    Slog.w(BackupManagerService.TAG, "I/O error closing down OBB backup", e);
                }
            }
            return success;
        }

        public void restoreObbFile(String pkgName, ParcelFileDescriptor data, long fileSize, int type, String path, long mode, long mtime, int token, IBackupManager callbackBinder) {
            this.waitForConnection();
            try {
                this.mService.restoreObbFile(pkgName, data, fileSize, type, path, mode, mtime, token, callbackBinder);
            }
            catch (Exception e) {
                Slog.w(BackupManagerService.TAG, "Unable to restore OBBs for " + pkgName, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForConnection() {
            FullBackupObbConnection fullBackupObbConnection = this;
            synchronized (fullBackupObbConnection) {
                while (this.mService == null) {
                    Slog.i(BackupManagerService.TAG, "...waiting for OBB service binding...");
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Slog.i(BackupManagerService.TAG, "Connected to OBB service; continuing");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            FullBackupObbConnection fullBackupObbConnection = this;
            synchronized (fullBackupObbConnection) {
                this.mService = IObbBackupService.Stub.asInterface(service);
                Slog.i(BackupManagerService.TAG, "OBB service connection " + this.mService + " connected on " + this);
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            FullBackupObbConnection fullBackupObbConnection = this;
            synchronized (fullBackupObbConnection) {
                this.mService = null;
                Slog.i(BackupManagerService.TAG, "OBB service connection disconnected on " + this);
                this.notifyAll();
            }
        }
    }

    class PerformBackupTask
    implements BackupRestoreTask {
        private static final String TAG = "PerformBackupTask";
        IBackupTransport mTransport;
        ArrayList<BackupRequest> mQueue;
        ArrayList<BackupRequest> mOriginalQueue;
        File mStateDir;
        File mJournal;
        BackupState mCurrentState;
        IBackupAgent mAgentBinder;
        PackageInfo mCurrentPackage;
        File mSavedStateName;
        File mBackupDataName;
        File mNewStateName;
        ParcelFileDescriptor mSavedState;
        ParcelFileDescriptor mBackupData;
        ParcelFileDescriptor mNewState;
        int mStatus;
        boolean mFinished;

        public PerformBackupTask(IBackupTransport transport, String dirName, ArrayList<BackupRequest> queue, File journal) {
            this.mTransport = transport;
            this.mOriginalQueue = queue;
            this.mJournal = journal;
            this.mStateDir = new File(BackupManagerService.this.mBaseStateDir, dirName);
            this.mCurrentState = BackupState.INITIAL;
            this.mFinished = false;
            BackupManagerService.this.addBackupTrace("STATE => INITIAL");
        }

        @Override
        public void execute() {
            switch (this.mCurrentState) {
                case INITIAL: {
                    this.beginBackup();
                    break;
                }
                case RUNNING_QUEUE: {
                    this.invokeNextAgent();
                    break;
                }
                case FINAL: {
                    if (!this.mFinished) {
                        this.finalizeBackup();
                    } else {
                        Slog.e(TAG, "Duplicate finish");
                    }
                    this.mFinished = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void beginBackup() {
            BackupManagerService.this.clearBackupTrace();
            StringBuilder b = new StringBuilder(256);
            b.append("beginBackup: [");
            for (BackupRequest req : this.mOriginalQueue) {
                b.append(' ');
                b.append(req.packageName);
            }
            b.append(" ]");
            BackupManagerService.this.addBackupTrace(b.toString());
            this.mAgentBinder = null;
            this.mStatus = 0;
            if (this.mOriginalQueue.isEmpty()) {
                Slog.w(TAG, "Backup begun with an empty queue - nothing to do.");
                BackupManagerService.this.addBackupTrace("queue empty at begin");
                this.executeNextState(BackupState.FINAL);
                return;
            }
            this.mQueue = (ArrayList)this.mOriginalQueue.clone();
            Slog.v(TAG, "Beginning backup of " + this.mQueue.size() + " targets");
            File pmState = new File(this.mStateDir, BackupManagerService.PACKAGE_MANAGER_SENTINEL);
            try {
                String transportName = this.mTransport.transportDirName();
                EventLog.writeEvent(2821, transportName);
                if (this.mStatus == 0 && pmState.length() <= 0L) {
                    Slog.i(TAG, "Initializing (wiping) backup state and transport storage");
                    BackupManagerService.this.addBackupTrace("initializing transport " + transportName);
                    BackupManagerService.this.resetBackupState(this.mStateDir);
                    this.mStatus = this.mTransport.initializeDevice();
                    BackupManagerService.this.addBackupTrace("transport.initializeDevice() == " + this.mStatus);
                    if (this.mStatus == 0) {
                        EventLog.writeEvent(2827, new Object[0]);
                    } else {
                        EventLog.writeEvent(2822, "(initialize)");
                        Slog.e(TAG, "Transport error in initializeDevice()");
                    }
                }
                if (this.mStatus == 0) {
                    PackageManagerBackupAgent pmAgent = new PackageManagerBackupAgent(BackupManagerService.this.mPackageManager);
                    this.mStatus = this.invokeAgentForBackup(BackupManagerService.PACKAGE_MANAGER_SENTINEL, IBackupAgent.Stub.asInterface(pmAgent.onBind()), this.mTransport);
                    BackupManagerService.this.addBackupTrace("PMBA invoke: " + this.mStatus);
                    BackupManagerService.this.mBackupHandler.removeMessages(7);
                }
                if (this.mStatus == -1001) {
                    EventLog.writeEvent(2826, this.mTransport.transportDirName());
                }
            }
            catch (Exception e) {
                Slog.e(TAG, "Error in backup thread", e);
                BackupManagerService.this.addBackupTrace("Exception in backup thread: " + e);
                this.mStatus = -1000;
            }
            finally {
                BackupManagerService.this.addBackupTrace("exiting prelim: " + this.mStatus);
                if (this.mStatus != 0) {
                    BackupManagerService.this.resetBackupState(this.mStateDir);
                    this.executeNextState(BackupState.FINAL);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invokeNextAgent() {
            block20: {
                this.mStatus = 0;
                BackupManagerService.this.addBackupTrace("invoke q=" + this.mQueue.size());
                if (this.mQueue.isEmpty()) {
                    Slog.i(TAG, "queue now empty");
                    this.executeNextState(BackupState.FINAL);
                    return;
                }
                BackupRequest request = this.mQueue.get(0);
                this.mQueue.remove(0);
                Slog.d(TAG, "starting agent for backup of " + request);
                BackupManagerService.this.addBackupTrace("launch agent for " + request.packageName);
                try {
                    this.mCurrentPackage = BackupManagerService.this.mPackageManager.getPackageInfo(request.packageName, 64);
                    if (this.mCurrentPackage.applicationInfo.backupAgentName == null) {
                        Slog.i(TAG, "Package " + request.packageName + " no longer supports backup; skipping");
                        BackupManagerService.this.addBackupTrace("skipping - no agent, completion is noop");
                        this.executeNextState(BackupState.RUNNING_QUEUE);
                        return;
                    }
                    if ((this.mCurrentPackage.applicationInfo.flags & 0x200000) != 0) {
                        BackupManagerService.this.addBackupTrace("skipping - stopped");
                        this.executeNextState(BackupState.RUNNING_QUEUE);
                        return;
                    }
                    IBackupAgent agent = null;
                    try {
                        BackupManagerService.this.mWakelock.setWorkSource(new WorkSource(this.mCurrentPackage.applicationInfo.uid));
                        agent = BackupManagerService.this.bindToAgentSynchronous(this.mCurrentPackage.applicationInfo, 0);
                        BackupManagerService.this.addBackupTrace("agent bound; a? = " + (agent != null));
                        if (agent != null) {
                            this.mAgentBinder = agent;
                            this.mStatus = this.invokeAgentForBackup(request.packageName, agent, this.mTransport);
                            break block20;
                        }
                        this.mStatus = -1003;
                    }
                    catch (SecurityException ex) {
                        Slog.d(TAG, "error in bind/backup", ex);
                        this.mStatus = -1003;
                        BackupManagerService.this.addBackupTrace("agent SE");
                    }
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.d(TAG, "Package does not exist; skipping");
                    BackupManagerService.this.addBackupTrace("no such package");
                    this.mStatus = -1004;
                }
                finally {
                    BackupManagerService.this.mWakelock.setWorkSource(null);
                    if (this.mStatus != 0) {
                        BackupState nextState = BackupState.RUNNING_QUEUE;
                        this.mAgentBinder = null;
                        if (this.mStatus == -1003) {
                            BackupManagerService.this.dataChangedImpl(request.packageName);
                            this.mStatus = 0;
                            if (this.mQueue.isEmpty()) {
                                nextState = BackupState.FINAL;
                            }
                        } else if (this.mStatus == -1004) {
                            this.mStatus = 0;
                        } else {
                            this.revertAndEndBackup();
                            nextState = BackupState.FINAL;
                        }
                        this.executeNextState(nextState);
                    } else {
                        BackupManagerService.this.addBackupTrace("expecting completion/timeout callback");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void finalizeBackup() {
            BackupManagerService.this.addBackupTrace("finishing");
            if (this.mJournal != null && !this.mJournal.delete()) {
                Slog.e(TAG, "Unable to remove backup journal file " + this.mJournal);
            }
            if (BackupManagerService.this.mCurrentToken == 0L && this.mStatus == 0) {
                BackupManagerService.this.addBackupTrace("success; recording token");
                try {
                    BackupManagerService.this.mCurrentToken = this.mTransport.getCurrentRestoreSet();
                    BackupManagerService.this.writeRestoreTokens();
                }
                catch (RemoteException e) {
                    BackupManagerService.this.addBackupTrace("transport threw returning token");
                }
            }
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                BackupManagerService.this.mBackupRunning = false;
                if (this.mStatus == -1001) {
                    this.clearMetadata();
                    Slog.d(TAG, "Server requires init; rerunning");
                    BackupManagerService.this.addBackupTrace("init required; rerunning");
                    BackupManagerService.this.backupNow();
                }
            }
            BackupManagerService.this.clearBackupTrace();
            Slog.i(BackupManagerService.TAG, "Backup pass finished.");
            BackupManagerService.this.mWakelock.release();
        }

        void clearMetadata() {
            File pmState = new File(this.mStateDir, BackupManagerService.PACKAGE_MANAGER_SENTINEL);
            if (pmState.exists()) {
                pmState.delete();
            }
        }

        int invokeAgentForBackup(String packageName, IBackupAgent agent, IBackupTransport transport) {
            Slog.d(TAG, "invokeAgentForBackup on " + packageName);
            BackupManagerService.this.addBackupTrace("invoking " + packageName);
            this.mSavedStateName = new File(this.mStateDir, packageName);
            this.mBackupDataName = new File(BackupManagerService.this.mDataDir, packageName + ".data");
            this.mNewStateName = new File(this.mStateDir, packageName + ".new");
            this.mSavedState = null;
            this.mBackupData = null;
            this.mNewState = null;
            int token = BackupManagerService.this.generateToken();
            try {
                if (packageName.equals(BackupManagerService.PACKAGE_MANAGER_SENTINEL)) {
                    this.mCurrentPackage = new PackageInfo();
                    this.mCurrentPackage.packageName = packageName;
                }
                this.mSavedState = ParcelFileDescriptor.open(this.mSavedStateName, 0x18000000);
                this.mBackupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x3C000000);
                if (!SELinux.restorecon(this.mBackupDataName)) {
                    Slog.e(TAG, "SELinux restorecon failed on " + this.mBackupDataName);
                }
                this.mNewState = ParcelFileDescriptor.open(this.mNewStateName, 0x3C000000);
                BackupManagerService.this.addBackupTrace("setting timeout");
                BackupManagerService.this.prepareOperationTimeout(token, 30000L, this);
                BackupManagerService.this.addBackupTrace("calling agent doBackup()");
                agent.doBackup(this.mSavedState, this.mBackupData, this.mNewState, token, BackupManagerService.this.mBackupManagerBinder);
            }
            catch (Exception e) {
                Slog.e(TAG, "Error invoking for backup on " + packageName);
                BackupManagerService.this.addBackupTrace("exception: " + e);
                EventLog.writeEvent(2823, packageName, e.toString());
                this.agentErrorCleanup();
                return -1003;
            }
            BackupManagerService.this.addBackupTrace("invoke success");
            return 0;
        }

        public void failAgent(IBackupAgent agent, String message) {
            try {
                agent.fail(message);
            }
            catch (Exception e) {
                Slog.w(TAG, "Error conveying failure to " + this.mCurrentPackage.packageName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationComplete() {
            BackupState nextState;
            String pkgName = this.mCurrentPackage.packageName;
            long filepos = this.mBackupDataName.length();
            FileDescriptor fd = this.mBackupData.getFileDescriptor();
            try {
                if (this.mCurrentPackage.applicationInfo != null && (this.mCurrentPackage.applicationInfo.flags & 1) == 0) {
                    ParcelFileDescriptor readFd = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
                    BackupDataInput in = new BackupDataInput(readFd.getFileDescriptor());
                    try {
                        while (in.readNextHeader()) {
                            String key = in.getKey();
                            if (key != null && key.charAt(0) >= '\uff00') {
                                this.failAgent(this.mAgentBinder, "Illegal backup key: " + key);
                                BackupManagerService.this.addBackupTrace("illegal key " + key + " from " + pkgName);
                                EventLog.writeEvent(2823, pkgName, "bad key");
                                BackupManagerService.this.mBackupHandler.removeMessages(7);
                                this.agentErrorCleanup();
                                return;
                            }
                            in.skipEntityData();
                        }
                    }
                    finally {
                        if (readFd != null) {
                            readFd.close();
                        }
                    }
                }
                BackupDataOutput out = new BackupDataOutput(fd);
                byte[] widgetState = AppWidgetBackupBridge.getWidgetState(pkgName, 0);
                if (widgetState != null) {
                    out.writeEntityHeader(BackupManagerService.KEY_WIDGET_STATE, widgetState.length);
                    out.writeEntityData(widgetState, widgetState.length);
                } else {
                    out.writeEntityHeader(BackupManagerService.KEY_WIDGET_STATE, -1);
                }
            }
            catch (IOException e) {
                Slog.w(TAG, "Unable to save widget state for " + pkgName);
                try {
                    Os.ftruncate(fd, filepos);
                }
                catch (ErrnoException ee) {
                    Slog.w(TAG, "Unable to roll back!");
                }
            }
            BackupManagerService.this.mBackupHandler.removeMessages(7);
            this.clearAgentState();
            BackupManagerService.this.addBackupTrace("operation complete");
            ParcelFileDescriptor backupData = null;
            this.mStatus = 0;
            try {
                int size = (int)this.mBackupDataName.length();
                if (size > 0) {
                    if (this.mStatus == 0) {
                        backupData = ParcelFileDescriptor.open(this.mBackupDataName, 0x10000000);
                        BackupManagerService.this.addBackupTrace("sending data to transport");
                        this.mStatus = this.mTransport.performBackup(this.mCurrentPackage, backupData);
                    }
                    BackupManagerService.this.addBackupTrace("data delivered: " + this.mStatus);
                    if (this.mStatus == 0) {
                        BackupManagerService.this.addBackupTrace("finishing op on transport");
                        this.mStatus = this.mTransport.finishBackup();
                        BackupManagerService.this.addBackupTrace("finished: " + this.mStatus);
                    }
                } else {
                    Slog.i(TAG, "no backup data written; not calling transport");
                    BackupManagerService.this.addBackupTrace("no data to send");
                }
                if (this.mStatus == 0) {
                    this.mBackupDataName.delete();
                    this.mNewStateName.renameTo(this.mSavedStateName);
                    EventLog.writeEvent(2824, pkgName, size);
                    BackupManagerService.this.logBackupComplete(pkgName);
                } else {
                    EventLog.writeEvent(2822, pkgName);
                }
            }
            catch (Exception e) {
                Slog.e(TAG, "Transport error backing up " + pkgName, e);
                EventLog.writeEvent(2822, pkgName);
                this.mStatus = -1000;
            }
            finally {
                try {
                    if (backupData != null) {
                        backupData.close();
                    }
                }
                catch (IOException e) {}
            }
            if (this.mStatus != 0) {
                this.revertAndEndBackup();
                nextState = BackupState.FINAL;
            } else {
                nextState = this.mQueue.isEmpty() ? BackupState.FINAL : BackupState.RUNNING_QUEUE;
            }
            this.executeNextState(nextState);
        }

        @Override
        public void handleTimeout() {
            Slog.e(TAG, "Timeout backing up " + this.mCurrentPackage.packageName);
            EventLog.writeEvent(2823, this.mCurrentPackage.packageName, "timeout");
            BackupManagerService.this.addBackupTrace("timeout of " + this.mCurrentPackage.packageName);
            this.agentErrorCleanup();
            BackupManagerService.this.dataChangedImpl(this.mCurrentPackage.packageName);
        }

        void revertAndEndBackup() {
            BackupManagerService.this.addBackupTrace("transport error; reverting");
            for (BackupRequest request : this.mOriginalQueue) {
                BackupManagerService.this.dataChangedImpl(request.packageName);
            }
            this.restartBackupAlarm();
        }

        void agentErrorCleanup() {
            this.mBackupDataName.delete();
            this.mNewStateName.delete();
            this.clearAgentState();
            this.executeNextState(this.mQueue.isEmpty() ? BackupState.FINAL : BackupState.RUNNING_QUEUE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clearAgentState() {
            try {
                if (this.mSavedState != null) {
                    this.mSavedState.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.mBackupData != null) {
                    this.mBackupData.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (this.mNewState != null) {
                    this.mNewState.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Object object = BackupManagerService.this.mCurrentOpLock;
            synchronized (object) {
                BackupManagerService.this.mCurrentOperations.clear();
                this.mNewState = null;
                this.mBackupData = null;
                this.mSavedState = null;
            }
            if (this.mCurrentPackage.applicationInfo != null) {
                BackupManagerService.this.addBackupTrace("unbinding " + this.mCurrentPackage.packageName);
                try {
                    BackupManagerService.this.mActivityManager.unbindBackupAgent(this.mCurrentPackage.applicationInfo);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void restartBackupAlarm() {
            BackupManagerService.this.addBackupTrace("setting backup trigger");
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                try {
                    BackupManagerService.this.startBackupAlarmsLocked(this.mTransport.requestBackupTime());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        void executeNextState(BackupState nextState) {
            BackupManagerService.this.addBackupTrace("executeNextState => " + (Object)((Object)nextState));
            this.mCurrentState = nextState;
            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(20, this);
            BackupManagerService.this.mBackupHandler.sendMessage(msg);
        }
    }

    static enum BackupState {
        INITIAL,
        RUNNING_QUEUE,
        FINAL;

    }

    static interface BackupRestoreTask {
        public void execute();

        public void operationComplete();

        public void handleTimeout();
    }

    class ClearDataObserver
    extends IPackageDataObserver.Stub {
        ClearDataObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRemoveCompleted(String packageName, boolean succeeded) {
            Object object = BackupManagerService.this.mClearDataLock;
            synchronized (object) {
                BackupManagerService.this.mClearingData = false;
                BackupManagerService.this.mClearDataLock.notifyAll();
            }
        }
    }

    class TransportConnection
    implements ServiceConnection {
        ServiceInfo mTransport;

        public TransportConnection(ServiceInfo transport) {
            this.mTransport = transport;
        }

        @Override
        public void onServiceConnected(ComponentName component, IBinder service) {
            Slog.v(BackupManagerService.TAG, "Connected to transport " + component);
            String name = component.flattenToShortString();
            try {
                IBackupTransport transport = IBackupTransport.Stub.asInterface(service);
                BackupManagerService.this.registerTransport(transport.name(), name, transport);
                EventLog.writeEvent(2850, name, 1);
            }
            catch (RemoteException e) {
                Slog.e(BackupManagerService.TAG, "Unable to register transport " + component);
                EventLog.writeEvent(2850, name, 0);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName component) {
            Slog.v(BackupManagerService.TAG, "Disconnected from transport " + component);
            String name = component.flattenToShortString();
            EventLog.writeEvent(2850, name, 0);
            BackupManagerService.this.registerTransport(null, name, null);
        }
    }

    private class RunInitializeReceiver
    extends BroadcastReceiver {
        private RunInitializeReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (BackupManagerService.RUN_INITIALIZE_ACTION.equals(intent.getAction())) {
                Object object = BackupManagerService.this.mQueueLock;
                synchronized (object) {
                    Slog.v(BackupManagerService.TAG, "Running a device init");
                    BackupManagerService.this.mWakelock.acquire();
                    Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(5);
                    BackupManagerService.this.mBackupHandler.sendMessage(msg);
                }
            }
        }
    }

    private class RunBackupReceiver
    extends BroadcastReceiver {
        private RunBackupReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (BackupManagerService.RUN_BACKUP_ACTION.equals(intent.getAction())) {
                Object object = BackupManagerService.this.mQueueLock;
                synchronized (object) {
                    if (BackupManagerService.this.mPendingInits.size() > 0) {
                        Slog.v(BackupManagerService.TAG, "Init pending at scheduled backup");
                        try {
                            BackupManagerService.this.mAlarmManager.cancel(BackupManagerService.this.mRunInitIntent);
                            BackupManagerService.this.mRunInitIntent.send();
                        }
                        catch (PendingIntent.CanceledException ce) {
                            Slog.e(BackupManagerService.TAG, "Run init intent cancelled");
                        }
                    } else if (BackupManagerService.this.mEnabled && BackupManagerService.this.mProvisioned) {
                        if (!BackupManagerService.this.mBackupRunning) {
                            Slog.v(BackupManagerService.TAG, "Running a backup pass");
                            BackupManagerService.this.mBackupRunning = true;
                            BackupManagerService.this.mWakelock.acquire();
                            Message msg = BackupManagerService.this.mBackupHandler.obtainMessage(1);
                            BackupManagerService.this.mBackupHandler.sendMessage(msg);
                        } else {
                            Slog.i(BackupManagerService.TAG, "Backup time but one already running");
                        }
                    } else {
                        Slog.w(BackupManagerService.TAG, "Backup pass but e=" + BackupManagerService.this.mEnabled + " p=" + BackupManagerService.this.mProvisioned);
                    }
                }
            }
        }
    }

    private class BackupHandler
    extends Handler {
        public BackupHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    BackupManagerService.this.mLastBackupPass = System.currentTimeMillis();
                    BackupManagerService.this.mNextBackupPass = BackupManagerService.this.mLastBackupPass + 3600000L;
                    IBackupTransport transport = BackupManagerService.this.getTransport(BackupManagerService.this.mCurrentTransport);
                    if (transport == null) {
                        Slog.v(BackupManagerService.TAG, "Backup requested but no transport available");
                        Object object = BackupManagerService.this.mQueueLock;
                        synchronized (object) {
                            BackupManagerService.this.mBackupRunning = false;
                        }
                        BackupManagerService.this.mWakelock.release();
                        break;
                    }
                    ArrayList<BackupRequest> queue = new ArrayList<BackupRequest>();
                    File oldJournal = BackupManagerService.this.mJournal;
                    Object object = BackupManagerService.this.mQueueLock;
                    synchronized (object) {
                        if (BackupManagerService.this.mPendingBackups.size() > 0) {
                            for (BackupRequest b : BackupManagerService.this.mPendingBackups.values()) {
                                queue.add(b);
                            }
                            Slog.v(BackupManagerService.TAG, "clearing pending backups");
                            BackupManagerService.this.mPendingBackups.clear();
                            BackupManagerService.this.mJournal = null;
                        }
                    }
                    boolean staged = true;
                    if (queue.size() > 0) {
                        try {
                            String dirName = transport.transportDirName();
                            PerformBackupTask pbt = new PerformBackupTask(transport, dirName, queue, oldJournal);
                            Message pbtMessage = this.obtainMessage(20, pbt);
                            this.sendMessage(pbtMessage);
                        }
                        catch (RemoteException e) {
                            Slog.e(BackupManagerService.TAG, "Transport became unavailable attempting backup");
                            staged = false;
                        }
                    } else {
                        Slog.v(BackupManagerService.TAG, "Backup requested but nothing pending");
                        staged = false;
                    }
                    if (staged) break;
                    Object object2 = BackupManagerService.this.mQueueLock;
                    synchronized (object2) {
                        BackupManagerService.this.mBackupRunning = false;
                    }
                    BackupManagerService.this.mWakelock.release();
                    break;
                }
                case 20: {
                    try {
                        BackupRestoreTask task = (BackupRestoreTask)msg.obj;
                        task.execute();
                    }
                    catch (ClassCastException e) {
                        Slog.e(BackupManagerService.TAG, "Invalid backup task in flight, obj=" + msg.obj);
                    }
                    break;
                }
                case 21: {
                    try {
                        BackupRestoreTask task = (BackupRestoreTask)msg.obj;
                        task.operationComplete();
                    }
                    catch (ClassCastException e) {
                        Slog.e(BackupManagerService.TAG, "Invalid completion in flight, obj=" + msg.obj);
                    }
                    break;
                }
                case 2: {
                    FullBackupParams params = (FullBackupParams)msg.obj;
                    PerformAdbBackupTask task = new PerformAdbBackupTask(params.fd, params.observer, params.includeApks, params.includeObbs, params.includeShared, params.doWidgets, params.curPassword, params.encryptPassword, params.allApps, params.includeSystem, params.doCompress, params.packages, params.latch);
                    new Thread((Runnable)task, "adb-backup").start();
                    break;
                }
                case 14: {
                    PerformFullTransportBackupTask task = (PerformFullTransportBackupTask)msg.obj;
                    new Thread((Runnable)task, "transport-backup").start();
                    break;
                }
                case 3: {
                    RestoreParams params = (RestoreParams)msg.obj;
                    Slog.d(BackupManagerService.TAG, "MSG_RUN_RESTORE observer=" + params.observer);
                    PerformUnifiedRestoreTask task = new PerformUnifiedRestoreTask(params.transport, params.observer, params.token, params.pkgInfo, params.pmToken, params.isSystemRestore, params.filterSet);
                    Message restoreMsg = this.obtainMessage(20, task);
                    this.sendMessage(restoreMsg);
                    break;
                }
                case 10: {
                    FullRestoreParams params = (FullRestoreParams)msg.obj;
                    PerformAdbRestoreTask task = new PerformAdbRestoreTask(params.fd, params.curPassword, params.encryptPassword, params.observer, params.latch);
                    new Thread((Runnable)task, "adb-restore").start();
                    break;
                }
                case 4: {
                    ClearParams params = (ClearParams)msg.obj;
                    new PerformClearTask(params.transport, params.packageInfo).run();
                    break;
                }
                case 12: {
                    ClearRetryParams params = (ClearRetryParams)msg.obj;
                    BackupManagerService.this.clearBackupData(params.transportName, params.packageName);
                    break;
                }
                case 5: {
                    HashSet<String> queue;
                    Object task = BackupManagerService.this.mQueueLock;
                    synchronized (task) {
                        queue = new HashSet<String>(BackupManagerService.this.mPendingInits);
                        BackupManagerService.this.mPendingInits.clear();
                    }
                    new PerformInitializeTask(queue).run();
                    break;
                }
                case 11: {
                    Object queue = BackupManagerService.this.mQueueLock;
                    synchronized (queue) {
                        BackupManagerService.this.recordInitPendingLocked(msg.arg1 != 0, (String)msg.obj);
                        BackupManagerService.this.mAlarmManager.set(0, System.currentTimeMillis(), BackupManagerService.this.mRunInitIntent);
                        break;
                    }
                }
                case 6: {
                    RestoreSet[] sets = null;
                    RestoreGetSetsParams params = (RestoreGetSetsParams)msg.obj;
                    try {
                        sets = params.transport.getAvailableRestoreSets();
                        ActiveRestoreSession restoreMsg = params.session;
                        synchronized (restoreMsg) {
                            params.session.mRestoreSets = sets;
                        }
                        if (sets != null) break;
                        EventLog.writeEvent(2831, new Object[0]);
                        break;
                    }
                    catch (Exception e) {
                        Slog.e(BackupManagerService.TAG, "Error from transport getting set list");
                        break;
                    }
                    finally {
                        if (params.observer != null) {
                            try {
                                params.observer.restoreSetsAvailable(sets);
                            }
                            catch (RemoteException re) {
                                Slog.e(BackupManagerService.TAG, "Unable to report listing to observer");
                            }
                            catch (Exception e) {
                                Slog.e(BackupManagerService.TAG, "Restore observer threw", e);
                            }
                        }
                        this.removeMessages(8);
                        this.sendEmptyMessageDelayed(8, 60000L);
                        BackupManagerService.this.mWakelock.release();
                    }
                }
                case 7: {
                    BackupManagerService.this.handleTimeout(msg.arg1, msg.obj);
                    break;
                }
                case 8: {
                    BackupManagerService sets = BackupManagerService.this;
                    synchronized (sets) {
                        if (BackupManagerService.this.mActiveRestoreSession != null) {
                            Slog.w(BackupManagerService.TAG, "Restore session timed out; aborting");
                            BackupManagerService.this.mActiveRestoreSession.markTimedOut();
                            ActiveRestoreSession activeRestoreSession = BackupManagerService.this.mActiveRestoreSession;
                            activeRestoreSession.getClass();
                            this.post(activeRestoreSession.new ActiveRestoreSession.EndRestoreRunnable(BackupManagerService.this, BackupManagerService.this.mActiveRestoreSession));
                        }
                        break;
                    }
                }
                case 9: {
                    SparseArray<FullParams> sets = BackupManagerService.this.mFullConfirmations;
                    synchronized (sets) {
                        FullParams params = BackupManagerService.this.mFullConfirmations.get(msg.arg1);
                        if (params != null) {
                            Slog.i(BackupManagerService.TAG, "Full backup/restore timed out waiting for user confirmation");
                            BackupManagerService.this.signalFullBackupRestoreCompletion(params);
                            BackupManagerService.this.mFullConfirmations.delete(msg.arg1);
                            if (params.observer != null) {
                                try {
                                    params.observer.onTimeout();
                                }
                                catch (RemoteException remoteException) {}
                            }
                        } else {
                            Slog.d(BackupManagerService.TAG, "couldn't find params for token " + msg.arg1);
                        }
                        break;
                    }
                }
                case 13: {
                    Intent intent = (Intent)msg.obj;
                    BackupManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER);
                    break;
                }
            }
        }
    }

    class FullBackupEntry
    implements Comparable<FullBackupEntry> {
        String packageName;
        long lastBackup;

        FullBackupEntry(String pkg, long when) {
            this.packageName = pkg;
            this.lastBackup = when;
        }

        @Override
        public int compareTo(FullBackupEntry other) {
            if (this.lastBackup < other.lastBackup) {
                return -1;
            }
            if (this.lastBackup > other.lastBackup) {
                return 1;
            }
            return 0;
        }
    }

    class Operation {
        public int state;
        public BackupRestoreTask callback;

        Operation(int initialState, BackupRestoreTask callbackObj) {
            this.state = initialState;
            this.callback = callbackObj;
        }
    }

    class FullRestoreParams
    extends FullParams {
        FullRestoreParams(ParcelFileDescriptor input) {
            this.fd = input;
        }
    }

    class FullBackupParams
    extends FullParams {
        public boolean includeApks;
        public boolean includeObbs;
        public boolean includeShared;
        public boolean doWidgets;
        public boolean allApps;
        public boolean includeSystem;
        public boolean doCompress;
        public String[] packages;

        FullBackupParams(ParcelFileDescriptor output, boolean saveApks, boolean saveObbs, boolean saveShared, boolean alsoWidgets, boolean doAllApps, boolean doSystem, boolean compress, String[] pkgList) {
            this.fd = output;
            this.includeApks = saveApks;
            this.includeObbs = saveObbs;
            this.includeShared = saveShared;
            this.doWidgets = alsoWidgets;
            this.allApps = doAllApps;
            this.includeSystem = doSystem;
            this.doCompress = compress;
            this.packages = pkgList;
        }
    }

    class FullParams {
        public ParcelFileDescriptor fd;
        public final AtomicBoolean latch = new AtomicBoolean(false);
        public IFullBackupRestoreObserver observer;
        public String curPassword;
        public String encryptPassword;

        FullParams() {
        }
    }

    class ClearRetryParams {
        public String transportName;
        public String packageName;

        ClearRetryParams(String transport, String pkg) {
            this.transportName = transport;
            this.packageName = pkg;
        }
    }

    class ClearParams {
        public IBackupTransport transport;
        public PackageInfo packageInfo;

        ClearParams(IBackupTransport _transport, PackageInfo _info) {
            this.transport = _transport;
            this.packageInfo = _info;
        }
    }

    class RestoreParams {
        public IBackupTransport transport;
        public String dirName;
        public IRestoreObserver observer;
        public long token;
        public PackageInfo pkgInfo;
        public int pmToken;
        public boolean isSystemRestore;
        public String[] filterSet;

        RestoreParams(IBackupTransport _transport, String _dirName, IRestoreObserver _obs, long _token, PackageInfo _pkg, int _pmToken) {
            this.transport = _transport;
            this.dirName = _dirName;
            this.observer = _obs;
            this.token = _token;
            this.pkgInfo = _pkg;
            this.pmToken = _pmToken;
            this.isSystemRestore = false;
            this.filterSet = null;
        }

        RestoreParams(IBackupTransport _transport, String _dirName, IRestoreObserver _obs, long _token) {
            this.transport = _transport;
            this.dirName = _dirName;
            this.observer = _obs;
            this.token = _token;
            this.pkgInfo = null;
            this.pmToken = 0;
            this.isSystemRestore = true;
            this.filterSet = null;
        }

        RestoreParams(IBackupTransport _transport, String _dirName, IRestoreObserver _obs, long _token, String[] _filterSet, boolean _isSystemRestore) {
            this.transport = _transport;
            this.dirName = _dirName;
            this.observer = _obs;
            this.token = _token;
            this.pkgInfo = null;
            this.pmToken = 0;
            this.isSystemRestore = _isSystemRestore;
            this.filterSet = _filterSet;
        }
    }

    class RestoreGetSetsParams {
        public IBackupTransport transport;
        public ActiveRestoreSession session;
        public IRestoreObserver observer;

        RestoreGetSetsParams(IBackupTransport _transport, ActiveRestoreSession _session, IRestoreObserver _observer) {
            this.transport = _transport;
            this.session = _session;
            this.observer = _observer;
        }
    }

    class ProvisionedObserver
    extends ContentObserver {
        public ProvisionedObserver(Handler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange) {
            boolean wasProvisioned = BackupManagerService.this.mProvisioned;
            boolean isProvisioned = BackupManagerService.this.deviceIsProvisioned();
            BackupManagerService.this.mProvisioned = wasProvisioned || isProvisioned;
            Object object = BackupManagerService.this.mQueueLock;
            synchronized (object) {
                if (BackupManagerService.this.mProvisioned && !wasProvisioned && BackupManagerService.this.mEnabled) {
                    BackupManagerService.this.startBackupAlarmsLocked(43200000L);
                }
            }
        }
    }

    public static final class Lifecycle
    extends SystemService {
        public Lifecycle(Context context) {
            super(context);
            sInstance = new BackupManagerService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("backup", sInstance);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 600) {
                ContentResolver r = BackupManagerService.sInstance.mContext.getContentResolver();
                boolean areEnabled = Settings.Secure.getInt(r, "backup_enabled", 0) != 0;
                sInstance.setBackupEnabled(areEnabled);
            }
        }
    }

    class BackupRequest {
        public String packageName;

        BackupRequest(String pkgName) {
            this.packageName = pkgName;
        }

        public String toString() {
            return "BackupRequest{pkg=" + this.packageName + "}";
        }
    }
}

