/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import com.android.server.backup.BackupManagerService;

public class FullBackupJob
extends JobService {
    private static final String TAG = "FullBackupJob";
    private static final boolean DEBUG = true;
    private static ComponentName sIdleService = new ComponentName("android", FullBackupJob.class.getName());
    private static final int JOB_ID = 20536;
    JobParameters mParams;

    public static void schedule(Context ctx, long minDelay) {
        JobScheduler js = (JobScheduler)ctx.getSystemService("jobscheduler");
        JobInfo.Builder builder = new JobInfo.Builder(20536, sIdleService).setRequiresDeviceIdle(true).setRequiredNetworkType(2).setRequiresCharging(true);
        if (minDelay > 0L) {
            builder.setMinimumLatency(minDelay);
        }
        js.schedule(builder.build());
    }

    public void finishBackupPass() {
        if (this.mParams != null) {
            this.jobFinished(this.mParams, false);
            this.mParams = null;
        }
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        this.mParams = params;
        BackupManagerService service = BackupManagerService.getInstance();
        return service.beginFullBackup(this);
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        if (this.mParams != null) {
            this.mParams = null;
            BackupManagerService service = BackupManagerService.getInstance();
            service.endFullBackup();
        }
        return false;
    }
}

