/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Messenger;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import com.android.server.connectivity.NetworkMonitor;
import java.util.ArrayList;

public class NetworkAgentInfo {
    public NetworkInfo networkInfo;
    public Network network;
    public LinkProperties linkProperties;
    public NetworkCapabilities networkCapabilities;
    public final NetworkMonitor networkMonitor;
    public final NetworkMisc networkMisc;
    public boolean created;
    public boolean validated;
    private int currentScore;
    private static final int UNVALIDATED_SCORE_PENALTY = 40;
    private static final int EXPLICITLY_SELECTED_NETWORK_SCORE = 100;
    public final SparseArray<NetworkRequest> networkRequests = new SparseArray();
    public final ArrayList<NetworkRequest> networkLingered = new ArrayList();
    public final Messenger messenger;
    public final AsyncChannel asyncChannel;

    public NetworkAgentInfo(Messenger messenger, AsyncChannel ac, NetworkInfo info, LinkProperties lp, NetworkCapabilities nc, int score, Context context, Handler handler, NetworkMisc misc) {
        this.messenger = messenger;
        this.asyncChannel = ac;
        this.network = null;
        this.networkInfo = info;
        this.linkProperties = lp;
        this.networkCapabilities = nc;
        this.currentScore = score;
        this.networkMonitor = new NetworkMonitor(context, handler, this);
        this.networkMisc = misc;
        this.created = false;
        this.validated = false;
    }

    public void addRequest(NetworkRequest networkRequest) {
        this.networkRequests.put(networkRequest.requestId, networkRequest);
    }

    public boolean isVPN() {
        return this.networkCapabilities.hasTransport(4);
    }

    public int getCurrentScore() {
        int score = this.currentScore;
        if (!this.validated) {
            score -= 40;
        }
        if (score < 0) {
            score = 0;
        }
        if (this.networkMisc.explicitlySelected) {
            score = 100;
        }
        return score;
    }

    public void setCurrentScore(int newScore) {
        this.currentScore = newScore;
    }

    public String toString() {
        return "NetworkAgentInfo{ ni{" + this.networkInfo + "}  network{" + this.network + "}  lp{" + this.linkProperties + "}  nc{" + this.networkCapabilities + "}  Score{" + this.getCurrentScore() + "} " + "validated{" + this.validated + "} created{" + this.created + "} " + "explicitlySelected{" + this.networkMisc.explicitlySelected + "} }";
    }

    public String name() {
        return "NetworkAgentInfo [" + this.networkInfo.getTypeName() + " (" + this.networkInfo.getSubtypeName() + ") - " + (this.network == null ? "null" : this.network.toString()) + "]";
    }
}

