/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.TrafficStats;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.TelephonyManager;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.android.server.connectivity.NetworkAgentInfo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;

public class NetworkMonitor
extends StateMachine {
    private static final boolean DBG = true;
    private static final String TAG = "NetworkMonitor";
    private static final String DEFAULT_SERVER = "clients3.google.com";
    private static final int SOCKET_TIMEOUT_MS = 10000;
    public static final String ACTION_NETWORK_CONDITIONS_MEASURED = "android.net.conn.NETWORK_CONDITIONS_MEASURED";
    public static final String EXTRA_CONNECTIVITY_TYPE = "extra_connectivity_type";
    public static final String EXTRA_NETWORK_TYPE = "extra_network_type";
    public static final String EXTRA_RESPONSE_RECEIVED = "extra_response_received";
    public static final String EXTRA_IS_CAPTIVE_PORTAL = "extra_is_captive_portal";
    public static final String EXTRA_CELL_ID = "extra_cellid";
    public static final String EXTRA_SSID = "extra_ssid";
    public static final String EXTRA_BSSID = "extra_bssid";
    public static final String EXTRA_REQUEST_TIMESTAMP_MS = "extra_request_timestamp_ms";
    public static final String EXTRA_RESPONSE_TIMESTAMP_MS = "extra_response_timestamp_ms";
    private static final String PERMISSION_ACCESS_NETWORK_CONDITIONS = "android.permission.ACCESS_NETWORK_CONDITIONS";
    private static final String ACTION_CAPTIVE_PORTAL_LOGGED_IN = "android.net.netmon.captive_portal_logged_in";
    private static final String LOGGED_IN_RESULT = "result";
    public static final int NETWORK_TEST_RESULT_VALID = 0;
    public static final int NETWORK_TEST_RESULT_INVALID = 1;
    private static final int BASE = 532480;
    public static final int CMD_NETWORK_CONNECTED = 532481;
    public static final int EVENT_NETWORK_TESTED = 532482;
    public static final int CMD_NETWORK_LINGER = 532483;
    private static final int CMD_LINGER_EXPIRED = 532484;
    public static final int EVENT_NETWORK_LINGER_COMPLETE = 532485;
    private static final int CMD_REEVALUATE = 532486;
    public static final int CMD_NETWORK_DISCONNECTED = 532487;
    public static final int CMD_FORCE_REEVALUATION = 532488;
    private static final int CMD_CAPTIVE_PORTAL_LOGGED_IN = 532489;
    private static final int CMD_USER_WANTS_SIGN_IN = 532490;
    public static final int EVENT_PROVISIONING_NOTIFICATION = 532491;
    private static final int EVENT_APP_BYPASSED_CAPTIVE_PORTAL = 532492;
    private static final int EVENT_NO_APP_RESPONSE = 532493;
    private static final int EVENT_APP_INDICATES_SIGN_IN_IMPOSSIBLE = 532494;
    private static final String LINGER_DELAY_PROPERTY = "persist.netmon.linger";
    private static final int DEFAULT_LINGER_DELAY_MS = 30000;
    private final int mLingerDelayMs;
    private int mLingerToken = 0;
    private static final String REEVALUATE_DELAY_PROPERTY = "persist.netmon.reeval_delay";
    private static final int DEFAULT_REEVALUATE_DELAY_MS = 5000;
    private static final int MAX_RETRIES = 10;
    private final int mReevaluateDelayMs;
    private int mReevaluateToken = 0;
    private static final int INVALID_UID = -1;
    private int mUidResponsibleForReeval = -1;
    private int mCaptivePortalLoggedInToken = 0;
    private int mUserPromptedToken = 0;
    private final Context mContext;
    private final Handler mConnectivityServiceHandler;
    private final NetworkAgentInfo mNetworkAgentInfo;
    private final TelephonyManager mTelephonyManager;
    private final WifiManager mWifiManager;
    private final AlarmManager mAlarmManager;
    private String mServer;
    private boolean mIsCaptivePortalCheckEnabled = false;
    private boolean mUserDoesNotWant = false;
    public boolean systemReady = false;
    private State mDefaultState = new DefaultState();
    private State mOfflineState = new OfflineState();
    private State mValidatedState = new ValidatedState();
    private State mEvaluatingState = new EvaluatingState();
    private State mUserPromptedState = new UserPromptedState();
    private State mCaptivePortalState = new CaptivePortalState();
    private State mLingeringState = new LingeringState();

    public NetworkMonitor(Context context, Handler handler, NetworkAgentInfo networkAgentInfo) {
        super(TAG + networkAgentInfo.name());
        this.mContext = context;
        this.mConnectivityServiceHandler = handler;
        this.mNetworkAgentInfo = networkAgentInfo;
        this.mTelephonyManager = (TelephonyManager)context.getSystemService("phone");
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        this.addState(this.mDefaultState);
        this.addState(this.mOfflineState, this.mDefaultState);
        this.addState(this.mValidatedState, this.mDefaultState);
        this.addState(this.mEvaluatingState, this.mDefaultState);
        this.addState(this.mUserPromptedState, this.mDefaultState);
        this.addState(this.mCaptivePortalState, this.mDefaultState);
        this.addState(this.mLingeringState, this.mDefaultState);
        this.setInitialState(this.mDefaultState);
        this.mServer = Settings.Global.getString(this.mContext.getContentResolver(), "captive_portal_server");
        if (this.mServer == null) {
            this.mServer = DEFAULT_SERVER;
        }
        this.mLingerDelayMs = SystemProperties.getInt(LINGER_DELAY_PROPERTY, 30000);
        this.mReevaluateDelayMs = SystemProperties.getInt(REEVALUATE_DELAY_PROPERTY, 5000);
        this.mIsCaptivePortalCheckEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "captive_portal_detection_enabled", 1) == 1;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int isCaptivePortal() {
        if (!this.mIsCaptivePortalCheckEnabled) {
            return 204;
        }
        HttpURLConnection urlConnection = null;
        int httpResponseCode = 599;
        try {
            URL url = new URL("http", this.mServer, "/generate_204");
            this.log("Checking " + url.toString() + " on " + this.mNetworkAgentInfo.networkInfo.getExtraInfo());
            urlConnection = (HttpURLConnection)this.mNetworkAgentInfo.network.openConnection(url);
            urlConnection.setInstanceFollowRedirects(false);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setReadTimeout(10000);
            urlConnection.setUseCaches(false);
            long requestTimestamp = SystemClock.elapsedRealtime();
            urlConnection.getInputStream();
            long responseTimestamp = SystemClock.elapsedRealtime();
            httpResponseCode = urlConnection.getResponseCode();
            this.log("isCaptivePortal: ret=" + httpResponseCode + " headers=" + urlConnection.getHeaderFields());
            if (httpResponseCode == 200 && urlConnection.getContentLength() == 0) {
                this.log("Empty 200 response interpreted as 204 response.");
                httpResponseCode = 204;
            }
            this.sendNetworkConditionsBroadcast(true, httpResponseCode == 204, requestTimestamp, responseTimestamp);
        }
        catch (IOException e) {
            this.log("Probably not a portal: exception " + e);
            if (httpResponseCode == 599) {
                // empty if block
            }
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return httpResponseCode;
    }

    private void sendNetworkConditionsBroadcast(boolean responseReceived, boolean isCaptivePortal, long requestTimestampMs, long responseTimestampMs) {
        if (Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_scan_always_enabled", 0) == 0) {
            this.log("Don't send network conditions - lacking user consent.");
            return;
        }
        if (!this.systemReady) {
            return;
        }
        Intent latencyBroadcast = new Intent(ACTION_NETWORK_CONDITIONS_MEASURED);
        switch (this.mNetworkAgentInfo.networkInfo.getType()) {
            case 1: {
                WifiInfo currentWifiInfo = this.mWifiManager.getConnectionInfo();
                if (currentWifiInfo != null) {
                    latencyBroadcast.putExtra(EXTRA_SSID, currentWifiInfo.getSSID());
                    latencyBroadcast.putExtra(EXTRA_BSSID, currentWifiInfo.getBSSID());
                    break;
                }
                this.logw("network info is TYPE_WIFI but no ConnectionInfo found");
                return;
            }
            case 0: {
                latencyBroadcast.putExtra(EXTRA_NETWORK_TYPE, this.mTelephonyManager.getNetworkType());
                List<CellInfo> info = this.mTelephonyManager.getAllCellInfo();
                if (info == null) {
                    return;
                }
                int numRegisteredCellInfo = 0;
                for (CellInfo cellInfo : info) {
                    Parcelable cellId;
                    if (!cellInfo.isRegistered()) continue;
                    if (++numRegisteredCellInfo > 1) {
                        this.log("more than one registered CellInfo.  Can't tell which is active.  Bailing.");
                        return;
                    }
                    if (cellInfo instanceof CellInfoCdma) {
                        cellId = ((CellInfoCdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoGsm) {
                        cellId = ((CellInfoGsm)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoLte) {
                        cellId = ((CellInfoLte)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    if (cellInfo instanceof CellInfoWcdma) {
                        cellId = ((CellInfoWcdma)cellInfo).getCellIdentity();
                        latencyBroadcast.putExtra(EXTRA_CELL_ID, cellId);
                        continue;
                    }
                    this.logw("Registered cellinfo is unrecognized");
                    return;
                }
                break;
            }
            default: {
                return;
            }
        }
        latencyBroadcast.putExtra(EXTRA_CONNECTIVITY_TYPE, this.mNetworkAgentInfo.networkInfo.getType());
        latencyBroadcast.putExtra(EXTRA_RESPONSE_RECEIVED, responseReceived);
        latencyBroadcast.putExtra(EXTRA_REQUEST_TIMESTAMP_MS, requestTimestampMs);
        if (responseReceived) {
            latencyBroadcast.putExtra(EXTRA_IS_CAPTIVE_PORTAL, isCaptivePortal);
            latencyBroadcast.putExtra(EXTRA_RESPONSE_TIMESTAMP_MS, responseTimestampMs);
        }
        this.mContext.sendBroadcastAsUser(latencyBroadcast, UserHandle.CURRENT, PERMISSION_ACCESS_NETWORK_CONDITIONS);
    }

    private class LingeringState
    extends State {
        private static final String ACTION_LINGER_EXPIRED = "android.net.netmon.lingerExpired";
        private CustomIntentReceiver mBroadcastReceiver;
        private PendingIntent mIntent;

        private LingeringState() {
        }

        @Override
        public void enter() {
            this.mBroadcastReceiver = new CustomIntentReceiver(ACTION_LINGER_EXPIRED, ++NetworkMonitor.this.mLingerToken, 532484);
            this.mIntent = this.mBroadcastReceiver.getPendingIntent();
            long wakeupTime = SystemClock.elapsedRealtime() + (long)NetworkMonitor.this.mLingerDelayMs;
            NetworkMonitor.this.mAlarmManager.setWindow(2, wakeupTime, NetworkMonitor.this.mLingerDelayMs / 6, this.mIntent);
        }

        @Override
        public boolean processMessage(Message message) {
            NetworkMonitor.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 532481: {
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    return true;
                }
                case 532484: {
                    if (message.arg1 != NetworkMonitor.this.mLingerToken) {
                        return true;
                    }
                    NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532485, NetworkMonitor.this.mNetworkAgentInfo));
                    return true;
                }
                case 532488: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            NetworkMonitor.this.mAlarmManager.cancel(this.mIntent);
            NetworkMonitor.this.mContext.unregisterReceiver(this.mBroadcastReceiver);
        }
    }

    private class CaptivePortalState
    extends State {
        private CaptivePortalLoggedInBroadcastReceiver mCaptivePortalLoggedInBroadcastReceiver;

        private CaptivePortalState() {
        }

        @Override
        public void enter() {
            Intent intent = new Intent("android.intent.action.SEND");
            intent.putExtra("android.intent.extra.TEXT", String.valueOf(((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId));
            intent.setType("text/plain");
            intent.setComponent(new ComponentName("com.android.captiveportallogin", "com.android.captiveportallogin.CaptivePortalLoginActivity"));
            intent.setFlags(0x10400000);
            this.mCaptivePortalLoggedInBroadcastReceiver = new CaptivePortalLoggedInBroadcastReceiver(++NetworkMonitor.this.mCaptivePortalLoggedInToken);
            IntentFilter filter = new IntentFilter(NetworkMonitor.ACTION_CAPTIVE_PORTAL_LOGGED_IN);
            NetworkMonitor.this.mContext.registerReceiver(this.mCaptivePortalLoggedInBroadcastReceiver, filter);
            NetworkMonitor.this.mContext.startActivityAsUser(intent, UserHandle.CURRENT);
        }

        @Override
        public boolean processMessage(Message message) {
            NetworkMonitor.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 532489: {
                    if (message.arg1 != NetworkMonitor.this.mCaptivePortalLoggedInToken) {
                        return true;
                    }
                    if (message.arg2 == 0) {
                        NetworkMonitor.this.mUserDoesNotWant = true;
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mOfflineState);
                    } else {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            NetworkMonitor.this.mContext.unregisterReceiver(this.mCaptivePortalLoggedInBroadcastReceiver);
            this.mCaptivePortalLoggedInBroadcastReceiver = null;
        }

        private class CaptivePortalLoggedInBroadcastReceiver
        extends BroadcastReceiver {
            private final int mToken;

            CaptivePortalLoggedInBroadcastReceiver(int token) {
                this.mToken = token;
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                if (Integer.parseInt(intent.getStringExtra("android.intent.extra.TEXT")) == ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId) {
                    NetworkMonitor.this.sendMessage(NetworkMonitor.this.obtainMessage(532489, this.mToken, Integer.parseInt(intent.getStringExtra(NetworkMonitor.LOGGED_IN_RESULT))));
                }
            }
        }
    }

    private class UserPromptedState
    extends State {
        private static final String ACTION_SIGN_IN_REQUESTED = "android.net.netmon.sign_in_requested";
        private CustomIntentReceiver mUserRespondedBroadcastReceiver;

        private UserPromptedState() {
        }

        @Override
        public void enter() {
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 1, 0, NetworkMonitor.this.mNetworkAgentInfo));
            this.mUserRespondedBroadcastReceiver = new CustomIntentReceiver(ACTION_SIGN_IN_REQUESTED, ++NetworkMonitor.this.mUserPromptedToken, 532490);
            Message message = NetworkMonitor.this.obtainMessage(532491, 1, ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId, this.mUserRespondedBroadcastReceiver.getPendingIntent());
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(message);
        }

        @Override
        public boolean processMessage(Message message) {
            NetworkMonitor.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 532490: {
                    if (message.arg1 != NetworkMonitor.this.mUserPromptedToken) {
                        return true;
                    }
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mCaptivePortalState);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            Message message = NetworkMonitor.this.obtainMessage(532491, 0, ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId, null);
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(message);
            NetworkMonitor.this.mContext.unregisterReceiver(this.mUserRespondedBroadcastReceiver);
            this.mUserRespondedBroadcastReceiver = null;
        }
    }

    private class CustomIntentReceiver
    extends BroadcastReceiver {
        private final Message mMessage;
        private final String mAction;

        CustomIntentReceiver(String action, int token, int message) {
            this.mMessage = NetworkMonitor.this.obtainMessage(message, token);
            this.mAction = action + "_" + ((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.network.netId + "_" + token;
            NetworkMonitor.this.mContext.registerReceiver(this, new IntentFilter(this.mAction));
        }

        public PendingIntent getPendingIntent() {
            return PendingIntent.getBroadcast(NetworkMonitor.this.mContext, 0, new Intent(this.mAction), 0);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(this.mAction)) {
                NetworkMonitor.this.sendMessage(this.mMessage);
            }
        }
    }

    private class EvaluatingState
    extends State {
        private int mRetries;

        private EvaluatingState() {
        }

        @Override
        public void enter() {
            this.mRetries = 0;
            NetworkMonitor.this.sendMessage(532486, ++NetworkMonitor.this.mReevaluateToken, 0);
            if (NetworkMonitor.this.mUidResponsibleForReeval != -1) {
                TrafficStats.setThreadStatsUid(NetworkMonitor.this.mUidResponsibleForReeval);
                NetworkMonitor.this.mUidResponsibleForReeval = -1;
            }
        }

        @Override
        public boolean processMessage(Message message) {
            NetworkMonitor.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 532486: {
                    if (message.arg1 != NetworkMonitor.this.mReevaluateToken) {
                        return true;
                    }
                    if (NetworkMonitor.this.mNetworkAgentInfo.isVPN()) {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                        return true;
                    }
                    if (!((NetworkMonitor)NetworkMonitor.this).mNetworkAgentInfo.networkCapabilities.hasCapability(12)) {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                        return true;
                    }
                    int httpResponseCode = NetworkMonitor.this.isCaptivePortal();
                    if (httpResponseCode == 204) {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    } else if (httpResponseCode >= 200 && httpResponseCode <= 399) {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mUserPromptedState);
                    } else if (++this.mRetries > 10) {
                        NetworkMonitor.this.transitionTo(NetworkMonitor.this.mOfflineState);
                    } else if (NetworkMonitor.this.mReevaluateDelayMs >= 0) {
                        Message msg = NetworkMonitor.this.obtainMessage(532486, ++NetworkMonitor.this.mReevaluateToken, 0);
                        NetworkMonitor.this.sendMessageDelayed(msg, (long)NetworkMonitor.this.mReevaluateDelayMs);
                    }
                    return true;
                }
                case 532488: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void exit() {
            TrafficStats.clearThreadStatsUid();
        }
    }

    private class ValidatedState
    extends State {
        private ValidatedState() {
        }

        @Override
        public void enter() {
            NetworkMonitor.this.log("Validated");
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 0, 0, NetworkMonitor.this.mNetworkAgentInfo));
        }

        @Override
        public boolean processMessage(Message message) {
            NetworkMonitor.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 532481: {
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mValidatedState);
                    return true;
                }
            }
            return false;
        }
    }

    private class OfflineState
    extends State {
        private OfflineState() {
        }

        @Override
        public void enter() {
            NetworkMonitor.this.mConnectivityServiceHandler.sendMessage(NetworkMonitor.this.obtainMessage(532482, 1, 0, NetworkMonitor.this.mNetworkAgentInfo));
        }

        @Override
        public boolean processMessage(Message message) {
            NetworkMonitor.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 532488: {
                    return NetworkMonitor.this.mUserDoesNotWant;
                }
            }
            return false;
        }
    }

    private class DefaultState
    extends State {
        private DefaultState() {
        }

        @Override
        public boolean processMessage(Message message) {
            NetworkMonitor.this.log(this.getName() + message.toString());
            switch (message.what) {
                case 532483: {
                    NetworkMonitor.this.log("Lingering");
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mLingeringState);
                    return true;
                }
                case 532481: {
                    NetworkMonitor.this.log("Connected");
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                    return true;
                }
                case 532487: {
                    NetworkMonitor.this.log("Disconnected - quitting");
                    NetworkMonitor.this.quit();
                    return true;
                }
                case 532488: {
                    NetworkMonitor.this.log("Forcing reevaluation");
                    NetworkMonitor.this.mUidResponsibleForReeval = message.arg1;
                    NetworkMonitor.this.transitionTo(NetworkMonitor.this.mEvaluatingState);
                    return true;
                }
            }
            return true;
        }
    }
}

