/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.net.NetworkAgent;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.RouteInfo;
import android.net.UidRange;
import android.os.Binder;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemService;
import android.os.UserHandle;
import android.os.UserManager;
import android.security.KeyStore;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnProfile;
import com.android.server.net.BaseNetworkObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;

public class Vpn {
    private static final String NETWORKTYPE = "VPN";
    private static final String TAG = "Vpn";
    private static final boolean LOGD = true;
    private Context mContext;
    private NetworkInfo mNetworkInfo;
    private String mPackage;
    private int mOwnerUID;
    private String mInterface;
    private Connection mConnection;
    private LegacyVpnRunner mLegacyVpnRunner;
    private PendingIntent mStatusIntent;
    private volatile boolean mEnableTeardown = true;
    private final IConnectivityManager mConnService;
    private final INetworkManagementService mNetd;
    private VpnConfig mConfig;
    private NetworkAgent mNetworkAgent;
    private final Looper mLooper;
    private final NetworkCapabilities mNetworkCapabilities;
    @GuardedBy(value="this")
    private List<UidRange> mVpnUsers = null;
    private BroadcastReceiver mUserIntentReceiver = null;
    private final int mUserHandle;
    private INetworkManagementEventObserver mObserver = new BaseNetworkObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interfaceStatusChanged(String interfaze, boolean up) {
            Vpn vpn = Vpn.this;
            synchronized (vpn) {
                if (!up && Vpn.this.mLegacyVpnRunner != null) {
                    Vpn.this.mLegacyVpnRunner.check(interfaze);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void interfaceRemoved(String interfaze) {
            Vpn vpn = Vpn.this;
            synchronized (vpn) {
                if (interfaze.equals(Vpn.this.mInterface) && Vpn.this.jniCheck(interfaze) == 0) {
                    Vpn.this.mStatusIntent = null;
                    Vpn.this.mVpnUsers = null;
                    Vpn.this.mInterface = null;
                    if (Vpn.this.mConnection != null) {
                        Vpn.this.mContext.unbindService(Vpn.this.mConnection);
                        Vpn.this.mConnection = null;
                        Vpn.this.agentDisconnect();
                    } else if (Vpn.this.mLegacyVpnRunner != null) {
                        Vpn.this.mLegacyVpnRunner.exit();
                        Vpn.this.mLegacyVpnRunner = null;
                    }
                }
            }
        }
    };

    public Vpn(Looper looper, Context context, INetworkManagementService netService, IConnectivityManager connService, int userHandle) {
        this.mContext = context;
        this.mNetd = netService;
        this.mConnService = connService;
        this.mUserHandle = userHandle;
        this.mLooper = looper;
        this.mPackage = "[Legacy VPN]";
        this.mOwnerUID = this.getAppUid(this.mPackage, this.mUserHandle);
        try {
            netService.registerObserver(this.mObserver);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Problem registering observer", e);
        }
        if (userHandle == 0) {
            this.mUserIntentReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    String action = intent.getAction();
                    int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                    if (userHandle == -10000) {
                        return;
                    }
                    if ("android.intent.action.USER_ADDED".equals(action)) {
                        Vpn.this.onUserAdded(userHandle);
                    } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                        Vpn.this.onUserRemoved(userHandle);
                    }
                }
            };
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.USER_ADDED");
            intentFilter.addAction("android.intent.action.USER_REMOVED");
            this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        }
        this.mNetworkInfo = new NetworkInfo(17, 0, NETWORKTYPE, "");
        this.mNetworkCapabilities = new NetworkCapabilities();
        this.mNetworkCapabilities.addTransportType(4);
        this.mNetworkCapabilities.removeCapability(15);
    }

    public void setEnableTeardown(boolean enableTeardown) {
        this.mEnableTeardown = enableTeardown;
    }

    private void updateState(NetworkInfo.DetailedState detailedState, String reason) {
        Log.d(TAG, "setting state=" + (Object)((Object)detailedState) + ", reason=" + reason);
        this.mNetworkInfo.setDetailedState(detailedState, reason, null);
        if (this.mNetworkAgent != null) {
            this.mNetworkAgent.sendNetworkInfo(this.mNetworkInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean prepare(String oldPackage, String newPackage) {
        if (oldPackage != null && !oldPackage.equals(this.mPackage)) {
            if (!oldPackage.equals("[Legacy VPN]") && this.isVpnUserPreConsented(oldPackage)) {
                long token = Binder.clearCallingIdentity();
                try {
                    this.prepare(null, oldPackage);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
                return true;
            }
            return false;
        }
        if (newPackage == null || newPackage.equals(this.mPackage) && !newPackage.equals("[Legacy VPN]")) {
            return true;
        }
        this.enforceControlPermission();
        if (this.mInterface != null) {
            this.mStatusIntent = null;
            this.agentDisconnect();
            this.jniReset(this.mInterface);
            this.mInterface = null;
            this.mVpnUsers = null;
        }
        if (this.mConnection != null) {
            try {
                this.mConnection.mService.transact(0xFFFFFF, Parcel.obtain(), null, 1);
            }
            catch (Exception token) {
                // empty catch block
            }
            this.mContext.unbindService(this.mConnection);
            this.mConnection = null;
        } else if (this.mLegacyVpnRunner != null) {
            this.mLegacyVpnRunner.exit();
            this.mLegacyVpnRunner = null;
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetd.denyProtect(this.mOwnerUID);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to disallow UID " + this.mOwnerUID + " to call protect() " + e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        Log.i(TAG, "Switched from " + this.mPackage + " to " + newPackage);
        this.mPackage = newPackage;
        this.mOwnerUID = this.getAppUid(newPackage, this.mUserHandle);
        token = Binder.clearCallingIdentity();
        try {
            this.mNetd.allowProtect(this.mOwnerUID);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to allow UID " + this.mOwnerUID + " to call protect() " + e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        this.mConfig = null;
        this.updateState(NetworkInfo.DetailedState.IDLE, "prepare");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPackageAuthorization(boolean authorized) {
        this.enforceControlPermission();
        if (this.mPackage == null || "[Legacy VPN]".equals(this.mPackage)) {
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
            appOps.setMode(47, this.mOwnerUID, this.mPackage, authorized ? 0 : 1);
        }
        catch (Exception e) {
            Log.wtf(TAG, "Failed to set app ops for package " + this.mPackage, e);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean isVpnUserPreConsented(String packageName) {
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        return appOps.noteOpNoThrow(47, Binder.getCallingUid(), packageName) == 0;
    }

    private int getAppUid(String app, int userHandle) {
        int result;
        if ("[Legacy VPN]".equals(app)) {
            return Process.myUid();
        }
        PackageManager pm = this.mContext.getPackageManager();
        try {
            result = pm.getPackageUid(app, userHandle);
        }
        catch (PackageManager.NameNotFoundException e) {
            result = -1;
        }
        return result;
    }

    public NetworkInfo getNetworkInfo() {
        return this.mNetworkInfo;
    }

    private LinkProperties makeLinkProperties() {
        InetAddress address;
        boolean allowIPv4 = this.mConfig.allowIPv4;
        boolean allowIPv6 = this.mConfig.allowIPv6;
        LinkProperties lp = new LinkProperties();
        lp.setInterfaceName(this.mInterface);
        if (this.mConfig.addresses != null) {
            for (LinkAddress address2 : this.mConfig.addresses) {
                lp.addLinkAddress(address2);
                allowIPv4 |= address2.getAddress() instanceof Inet4Address;
                allowIPv6 |= address2.getAddress() instanceof Inet6Address;
            }
        }
        if (this.mConfig.routes != null) {
            for (RouteInfo route : this.mConfig.routes) {
                lp.addRoute(route);
                address = route.getDestination().getAddress();
                allowIPv4 |= address instanceof Inet4Address;
                allowIPv6 |= address instanceof Inet6Address;
            }
        }
        if (this.mConfig.dnsServers != null) {
            for (String dnsServer : this.mConfig.dnsServers) {
                address = InetAddress.parseNumericAddress(dnsServer);
                lp.addDnsServer(address);
                allowIPv4 |= address instanceof Inet4Address;
                allowIPv6 |= address instanceof Inet6Address;
            }
        }
        if (!allowIPv4) {
            lp.addRoute(new RouteInfo(new IpPrefix(Inet4Address.ANY, 0), 7));
        }
        if (!allowIPv6) {
            lp.addRoute(new RouteInfo(new IpPrefix(Inet6Address.ANY, 0), 7));
        }
        StringBuilder buffer = new StringBuilder();
        if (this.mConfig.searchDomains != null) {
            for (String domain : this.mConfig.searchDomains) {
                buffer.append(domain).append(' ');
            }
        }
        lp.setDomains(buffer.toString().trim());
        return lp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void agentConnect() {
        LinkProperties lp = this.makeLinkProperties();
        if (lp.hasIPv4DefaultRoute() || lp.hasIPv6DefaultRoute()) {
            this.mNetworkCapabilities.addCapability(12);
        } else {
            this.mNetworkCapabilities.removeCapability(12);
        }
        this.mNetworkInfo.setIsAvailable(true);
        this.mNetworkInfo.setDetailedState(NetworkInfo.DetailedState.CONNECTED, null, null);
        NetworkMisc networkMisc = new NetworkMisc();
        networkMisc.allowBypass = this.mConfig.allowBypass;
        long token = Binder.clearCallingIdentity();
        try {
            this.mNetworkAgent = new NetworkAgent(this.mLooper, this.mContext, NETWORKTYPE, this.mNetworkInfo, this.mNetworkCapabilities, lp, 0, networkMisc){

                @Override
                public void unwanted() {
                }
            };
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        this.addVpnUserLocked(this.mUserHandle);
        if (this.mUserHandle == 0) {
            List<UserInfo> users;
            token = Binder.clearCallingIdentity();
            try {
                users = UserManager.get(this.mContext).getUsers();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            for (UserInfo user : users) {
                if (!user.isRestricted()) continue;
                this.addVpnUserLocked(user.id);
            }
        }
        this.mNetworkAgent.addUidRanges(this.mVpnUsers.toArray(new UidRange[this.mVpnUsers.size()]));
    }

    private void agentDisconnect(NetworkInfo networkInfo, NetworkAgent networkAgent) {
        networkInfo.setIsAvailable(false);
        networkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
        if (networkAgent != null) {
            networkAgent.sendNetworkInfo(networkInfo);
        }
    }

    private void agentDisconnect(NetworkAgent networkAgent) {
        NetworkInfo networkInfo = new NetworkInfo(this.mNetworkInfo);
        this.agentDisconnect(networkInfo, networkAgent);
    }

    private void agentDisconnect() {
        if (this.mNetworkInfo.isConnected()) {
            this.agentDisconnect(this.mNetworkInfo, this.mNetworkAgent);
            this.mNetworkAgent = null;
        }
    }

    public synchronized ParcelFileDescriptor establish(VpnConfig config) {
        UserManager mgr = UserManager.get(this.mContext);
        if (Binder.getCallingUid() != this.mOwnerUID) {
            return null;
        }
        Intent intent = new Intent("android.net.VpnService");
        intent.setClassName(this.mPackage, config.user);
        long token = Binder.clearCallingIdentity();
        try {
            UserInfo user = mgr.getUserInfo(this.mUserHandle);
            if (user.isRestricted() || mgr.hasUserRestriction("no_config_vpn")) {
                throw new SecurityException("Restricted users cannot establish VPNs");
            }
            ResolveInfo info = AppGlobals.getPackageManager().resolveService(intent, null, 0, this.mUserHandle);
            if (info == null) {
                throw new SecurityException("Cannot find " + config.user);
            }
            if (!"android.permission.BIND_VPN_SERVICE".equals(info.serviceInfo.permission)) {
                throw new SecurityException(config.user + " does not require " + "android.permission.BIND_VPN_SERVICE");
            }
        }
        catch (RemoteException e) {
            throw new SecurityException("Cannot find " + config.user);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        VpnConfig oldConfig = this.mConfig;
        String oldInterface = this.mInterface;
        Connection oldConnection = this.mConnection;
        NetworkAgent oldNetworkAgent = this.mNetworkAgent;
        this.mNetworkAgent = null;
        List<UidRange> oldUsers = this.mVpnUsers;
        ParcelFileDescriptor tun = ParcelFileDescriptor.adoptFd(this.jniCreate(config.mtu));
        try {
            this.updateState(NetworkInfo.DetailedState.CONNECTING, "establish");
            String interfaze = this.jniGetName(tun.getFd());
            StringBuilder builder = new StringBuilder();
            for (LinkAddress address : config.addresses) {
                builder.append(" " + address);
            }
            if (this.jniSetAddresses(interfaze, builder.toString()) < 1) {
                throw new IllegalArgumentException("At least one address must be specified");
            }
            Connection connection = new Connection();
            if (!this.mContext.bindServiceAsUser(intent, connection, 1, new UserHandle(this.mUserHandle))) {
                throw new IllegalStateException("Cannot bind " + config.user);
            }
            this.mConnection = connection;
            this.mInterface = interfaze;
            config.user = this.mPackage;
            config.interfaze = this.mInterface;
            config.startTime = SystemClock.elapsedRealtime();
            this.mConfig = config;
            this.mVpnUsers = new ArrayList<UidRange>();
            this.agentConnect();
            if (oldConnection != null) {
                this.mContext.unbindService(oldConnection);
            }
            this.agentDisconnect(oldNetworkAgent);
            if (oldInterface != null && !oldInterface.equals(interfaze)) {
                this.jniReset(oldInterface);
            }
            try {
                IoUtils.setBlocking(tun.getFileDescriptor(), config.blocking);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot set tunnel's fd as blocking=" + config.blocking, e);
            }
        }
        catch (RuntimeException e) {
            IoUtils.closeQuietly(tun);
            this.agentDisconnect();
            this.mConfig = oldConfig;
            this.mConnection = oldConnection;
            this.mVpnUsers = oldUsers;
            this.mNetworkAgent = oldNetworkAgent;
            this.mInterface = oldInterface;
            throw e;
        }
        Log.i(TAG, "Established by " + config.user + " on " + this.mInterface);
        return tun;
    }

    private boolean isRunningLocked() {
        return this.mVpnUsers != null;
    }

    private SortedSet<Integer> getAppsUids(List<String> packageNames, int userHandle) {
        TreeSet<Integer> uids = new TreeSet<Integer>();
        for (String app : packageNames) {
            int uid = this.getAppUid(app, userHandle);
            if (uid == -1) continue;
            uids.add(uid);
        }
        return uids;
    }

    private void addVpnUserLocked(int userHandle) {
        if (!this.isRunningLocked()) {
            throw new IllegalStateException("VPN is not active");
        }
        if (this.mConfig.allowedApplications != null) {
            int start = -1;
            int stop = -1;
            Iterator i$ = this.getAppsUids(this.mConfig.allowedApplications, userHandle).iterator();
            while (i$.hasNext()) {
                int uid = (Integer)i$.next();
                if (start == -1) {
                    start = uid;
                } else if (uid != stop + 1) {
                    this.mVpnUsers.add(new UidRange(start, stop));
                    start = uid;
                }
                stop = uid;
            }
            if (start != -1) {
                this.mVpnUsers.add(new UidRange(start, stop));
            }
        } else if (this.mConfig.disallowedApplications != null) {
            UidRange userRange = UidRange.createForUser(userHandle);
            int start = userRange.start;
            Iterator i$ = this.getAppsUids(this.mConfig.disallowedApplications, userHandle).iterator();
            while (i$.hasNext()) {
                int uid = (Integer)i$.next();
                if (uid == start) {
                    ++start;
                    continue;
                }
                this.mVpnUsers.add(new UidRange(start, uid - 1));
                start = uid + 1;
            }
            if (start <= userRange.stop) {
                this.mVpnUsers.add(new UidRange(start, userRange.stop));
            }
        } else {
            this.mVpnUsers.add(UidRange.createForUser(userHandle));
        }
        this.prepareStatusIntent();
    }

    private List<UidRange> uidRangesForUser(int userHandle) {
        UidRange userRange = UidRange.createForUser(userHandle);
        ArrayList<UidRange> ranges = new ArrayList<UidRange>();
        for (UidRange range : this.mVpnUsers) {
            if (range.start < userRange.start || range.stop > userRange.stop) continue;
            ranges.add(range);
        }
        return ranges;
    }

    private void removeVpnUserLocked(int userHandle) {
        if (!this.isRunningLocked()) {
            throw new IllegalStateException("VPN is not active");
        }
        List<UidRange> ranges = this.uidRangesForUser(userHandle);
        if (this.mNetworkAgent != null) {
            this.mNetworkAgent.removeUidRanges(ranges.toArray(new UidRange[ranges.size()]));
        }
        this.mVpnUsers.removeAll(ranges);
        this.mStatusIntent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserAdded(int userHandle) {
        Vpn vpn = this;
        synchronized (vpn) {
            UserManager mgr = UserManager.get(this.mContext);
            UserInfo user = mgr.getUserInfo(userHandle);
            if (user.isRestricted()) {
                try {
                    this.addVpnUserLocked(userHandle);
                    if (this.mNetworkAgent != null) {
                        List<UidRange> ranges = this.uidRangesForUser(userHandle);
                        this.mNetworkAgent.addUidRanges(ranges.toArray(new UidRange[ranges.size()]));
                    }
                }
                catch (Exception e) {
                    Log.wtf(TAG, "Failed to add restricted user to owner", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(int userHandle) {
        Vpn vpn = this;
        synchronized (vpn) {
            UserManager mgr = UserManager.get(this.mContext);
            UserInfo user = mgr.getUserInfo(userHandle);
            if (user.isRestricted()) {
                try {
                    this.removeVpnUserLocked(userHandle);
                }
                catch (Exception e) {
                    Log.wtf(TAG, "Failed to remove restricted user to owner", e);
                }
            }
        }
    }

    public VpnConfig getVpnConfig() {
        this.enforceControlPermission();
        return this.mConfig;
    }

    @Deprecated
    public synchronized void interfaceStatusChanged(String iface, boolean up) {
        try {
            this.mObserver.interfaceStatusChanged(iface, up);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceControlPermission() {
        if (Binder.getCallingUid() == 1000) {
            return;
        }
        int appId = UserHandle.getAppId(Binder.getCallingUid());
        long token = Binder.clearCallingIdentity();
        try {
            PackageManager pm = this.mContext.getPackageManager();
            ApplicationInfo app = pm.getApplicationInfo("com.android.vpndialogs", 0);
            if ((app.flags & 1) != 0 && appId == app.uid) {
                return;
            }
            ApplicationInfo sysUiApp = pm.getApplicationInfo("com.android.systemui", 0);
            if ((sysUiApp.flags & 1) != 0 && appId == sysUiApp.uid) {
                return;
            }
        }
        catch (Exception exception) {
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        throw new SecurityException("Unauthorized Caller");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareStatusIntent() {
        long token = Binder.clearCallingIdentity();
        try {
            this.mStatusIntent = VpnConfig.getIntentForStatusPanel(this.mContext);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    public synchronized boolean addAddress(String address, int prefixLength) {
        if (Binder.getCallingUid() != this.mOwnerUID || this.mInterface == null || this.mNetworkAgent == null) {
            return false;
        }
        boolean success = this.jniAddAddress(this.mInterface, address, prefixLength);
        if (this.mNetworkAgent != null) {
            this.mNetworkAgent.sendLinkProperties(this.makeLinkProperties());
        }
        return success;
    }

    public synchronized boolean removeAddress(String address, int prefixLength) {
        if (Binder.getCallingUid() != this.mOwnerUID || this.mInterface == null || this.mNetworkAgent == null) {
            return false;
        }
        boolean success = this.jniDelAddress(this.mInterface, address, prefixLength);
        if (this.mNetworkAgent != null) {
            this.mNetworkAgent.sendLinkProperties(this.makeLinkProperties());
        }
        return success;
    }

    private native int jniCreate(int var1);

    private native String jniGetName(int var1);

    private native int jniSetAddresses(String var1, String var2);

    private native void jniReset(String var1);

    private native int jniCheck(String var1);

    private native boolean jniAddAddress(String var1, String var2, int var3);

    private native boolean jniDelAddress(String var1, String var2, int var3);

    private static RouteInfo findIPv4DefaultRoute(LinkProperties prop) {
        for (RouteInfo route : prop.getAllRoutes()) {
            if (!route.isDefaultRoute() || !(route.getGateway() instanceof Inet4Address)) continue;
            return route;
        }
        throw new IllegalStateException("Unable to find IPv4 default gateway");
    }

    public void startLegacyVpn(VpnProfile profile, KeyStore keyStore, LinkProperties egress) {
        byte[] value;
        this.enforceControlPermission();
        if (!keyStore.isUnlocked()) {
            throw new IllegalStateException("KeyStore isn't unlocked");
        }
        UserManager mgr = UserManager.get(this.mContext);
        UserInfo user = mgr.getUserInfo(this.mUserHandle);
        if (user.isRestricted() || mgr.hasUserRestriction("no_config_vpn")) {
            throw new SecurityException("Restricted users cannot establish VPNs");
        }
        RouteInfo ipv4DefaultRoute = Vpn.findIPv4DefaultRoute(egress);
        String gateway = ipv4DefaultRoute.getGateway().getHostAddress();
        String iface = ipv4DefaultRoute.getInterface();
        String privateKey = "";
        String userCert = "";
        String caCert = "";
        String serverCert = "";
        if (!profile.ipsecUserCert.isEmpty()) {
            privateKey = "USRPKEY_" + profile.ipsecUserCert;
            value = keyStore.get("USRCERT_" + profile.ipsecUserCert);
            String string2 = userCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (!profile.ipsecCaCert.isEmpty()) {
            value = keyStore.get("CACERT_" + profile.ipsecCaCert);
            String string3 = caCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (!profile.ipsecServerCert.isEmpty()) {
            value = keyStore.get("USRCERT_" + profile.ipsecServerCert);
            String string4 = serverCert = value == null ? null : new String(value, StandardCharsets.UTF_8);
        }
        if (privateKey == null || userCert == null || caCert == null || serverCert == null) {
            throw new IllegalStateException("Cannot load credentials");
        }
        String[] racoon = null;
        switch (profile.type) {
            case 1: {
                racoon = new String[]{iface, profile.server, "udppsk", profile.ipsecIdentifier, profile.ipsecSecret, "1701"};
                break;
            }
            case 2: {
                racoon = new String[]{iface, profile.server, "udprsa", privateKey, userCert, caCert, serverCert, "1701"};
                break;
            }
            case 3: {
                racoon = new String[]{iface, profile.server, "xauthpsk", profile.ipsecIdentifier, profile.ipsecSecret, profile.username, profile.password, "", gateway};
                break;
            }
            case 4: {
                racoon = new String[]{iface, profile.server, "xauthrsa", privateKey, userCert, caCert, serverCert, profile.username, profile.password, "", gateway};
                break;
            }
            case 5: {
                racoon = new String[]{iface, profile.server, "hybridrsa", caCert, serverCert, profile.username, profile.password, "", gateway};
            }
        }
        String[] mtpd = null;
        switch (profile.type) {
            case 0: {
                mtpd = new String[]{iface, "pptp", profile.server, "1723", "name", profile.username, "password", profile.password, "linkname", "vpn", "refuse-eap", "nodefaultroute", "usepeerdns", "idle", "1800", "mtu", "1400", "mru", "1400", profile.mppe ? "+mppe" : "nomppe"};
                break;
            }
            case 1: 
            case 2: {
                mtpd = new String[]{iface, "l2tp", profile.server, "1701", profile.l2tpSecret, "name", profile.username, "password", profile.password, "linkname", "vpn", "refuse-eap", "nodefaultroute", "usepeerdns", "idle", "1800", "mtu", "1400", "mru", "1400"};
            }
        }
        VpnConfig config = new VpnConfig();
        config.legacy = true;
        config.user = profile.key;
        config.interfaze = iface;
        config.session = profile.name;
        config.addLegacyRoutes(profile.routes);
        if (!profile.dnsServers.isEmpty()) {
            config.dnsServers = Arrays.asList(profile.dnsServers.split(" +"));
        }
        if (!profile.searchDomains.isEmpty()) {
            config.searchDomains = Arrays.asList(profile.searchDomains.split(" +"));
        }
        this.startLegacyVpn(config, racoon, mtpd);
    }

    private synchronized void startLegacyVpn(VpnConfig config, String[] racoon, String[] mtpd) {
        this.stopLegacyVpn();
        this.prepare(null, "[Legacy VPN]");
        this.updateState(NetworkInfo.DetailedState.CONNECTING, "startLegacyVpn");
        this.mLegacyVpnRunner = new LegacyVpnRunner(config, racoon, mtpd);
        this.mLegacyVpnRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void stopLegacyVpn() {
        if (this.mLegacyVpnRunner == null) return;
        this.mLegacyVpnRunner.exit();
        this.mLegacyVpnRunner = null;
        String string2 = "LegacyVpnRunner";
        synchronized ("LegacyVpnRunner") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized LegacyVpnInfo getLegacyVpnInfo() {
        this.enforceControlPermission();
        if (this.mLegacyVpnRunner == null) {
            return null;
        }
        LegacyVpnInfo info = new LegacyVpnInfo();
        info.key = this.mConfig.user;
        info.state = LegacyVpnInfo.stateFromNetworkInfo(this.mNetworkInfo);
        if (this.mNetworkInfo.isConnected()) {
            info.intent = this.mStatusIntent;
        }
        return info;
    }

    public VpnConfig getLegacyVpnConfig() {
        if (this.mLegacyVpnRunner != null) {
            return this.mConfig;
        }
        return null;
    }

    private class LegacyVpnRunner
    extends Thread {
        private static final String TAG = "LegacyVpnRunner";
        private final String[] mDaemons;
        private final String[][] mArguments;
        private final LocalSocket[] mSockets;
        private final String mOuterInterface;
        private final AtomicInteger mOuterConnection;
        private long mTimer;
        private final BroadcastReceiver mBroadcastReceiver;

        public LegacyVpnRunner(VpnConfig config, String[] racoon, String[] mtpd) {
            super(TAG);
            this.mOuterConnection = new AtomicInteger(-1);
            this.mTimer = -1L;
            this.mBroadcastReceiver = new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    NetworkInfo info;
                    if (!Vpn.this.mEnableTeardown) {
                        return;
                    }
                    if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE") && intent.getIntExtra("networkType", -1) == LegacyVpnRunner.this.mOuterConnection.get() && (info = (NetworkInfo)intent.getExtra("networkInfo")) != null && !info.isConnectedOrConnecting()) {
                        try {
                            Vpn.this.mObserver.interfaceStatusChanged(LegacyVpnRunner.this.mOuterInterface, false);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            };
            Vpn.this.mConfig = config;
            this.mDaemons = new String[]{"racoon", "mtpd"};
            this.mArguments = new String[][]{racoon, mtpd};
            this.mSockets = new LocalSocket[this.mDaemons.length];
            this.mOuterInterface = ((Vpn)Vpn.this).mConfig.interfaze;
            try {
                this.mOuterConnection.set(Vpn.this.mConnService.findConnectionTypeForIface(this.mOuterInterface));
            }
            catch (Exception e) {
                this.mOuterConnection.set(-1);
            }
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            Vpn.this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        }

        public void check(String interfaze) {
            if (interfaze.equals(this.mOuterInterface)) {
                Log.i(TAG, "Legacy VPN is going down with " + interfaze);
                this.exit();
            }
        }

        public void exit() {
            this.interrupt();
            for (LocalSocket socket : this.mSockets) {
                IoUtils.closeQuietly(socket);
            }
            Vpn.this.agentDisconnect();
            try {
                Vpn.this.mContext.unregisterReceiver(this.mBroadcastReceiver);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.v(TAG, "Waiting");
            String string2 = TAG;
            synchronized (TAG) {
                Log.v(TAG, "Executing");
                this.execute();
                this.monitorDaemons();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void checkpoint(boolean yield) throws InterruptedException {
            long now = SystemClock.elapsedRealtime();
            if (this.mTimer == -1L) {
                this.mTimer = now;
                Thread.sleep(1L);
            } else if (now - this.mTimer <= 60000L) {
                Thread.sleep(yield ? 200L : 1L);
            } else {
                Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, "checkpoint");
                throw new IllegalStateException("Time is up");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void execute() {
            boolean initFinished = false;
            try {
                String endpoint;
                String searchDomains;
                String dnsServers;
                int i;
                this.checkpoint(false);
                for (String daemon : this.mDaemons) {
                    while (!SystemService.isStopped(daemon)) {
                        this.checkpoint(true);
                    }
                }
                File state = new File("/data/misc/vpn/state");
                state.delete();
                if (state.exists()) {
                    throw new IllegalStateException("Cannot delete the state");
                }
                new File("/data/misc/vpn/abort").delete();
                initFinished = true;
                boolean restart = false;
                for (String[] arguments : this.mArguments) {
                    restart = restart || arguments != null;
                }
                if (!restart) {
                    Vpn.this.agentDisconnect();
                    return;
                }
                Vpn.this.updateState(NetworkInfo.DetailedState.CONNECTING, "execute");
                block18: for (i = 0; i < this.mDaemons.length; ++i) {
                    String[] arguments = this.mArguments[i];
                    if (arguments == null) continue;
                    String daemon = this.mDaemons[i];
                    SystemService.start(daemon);
                    while (!SystemService.isRunning(daemon)) {
                        this.checkpoint(true);
                    }
                    this.mSockets[i] = new LocalSocket();
                    LocalSocketAddress address = new LocalSocketAddress(daemon, LocalSocketAddress.Namespace.RESERVED);
                    while (true) {
                        try {
                            this.mSockets[i].connect(address);
                        }
                        catch (Exception exception) {
                            this.checkpoint(true);
                            continue;
                        }
                        break;
                    }
                    this.mSockets[i].setSoTimeout(500);
                    OutputStream out = this.mSockets[i].getOutputStream();
                    for (String argument : arguments) {
                        byte[] bytes = argument.getBytes(StandardCharsets.UTF_8);
                        if (bytes.length >= 65535) {
                            throw new IllegalArgumentException("Argument is too large");
                        }
                        out.write(bytes.length >> 8);
                        out.write(bytes.length);
                        out.write(bytes);
                        this.checkpoint(false);
                    }
                    out.write(255);
                    out.write(255);
                    out.flush();
                    InputStream in = this.mSockets[i].getInputStream();
                    while (true) {
                        try {
                            if (in.read() == -1) {
                                continue block18;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.checkpoint(true);
                    }
                }
                while (!state.exists()) {
                    for (i = 0; i < this.mDaemons.length; ++i) {
                        String daemon = this.mDaemons[i];
                        if (this.mArguments[i] == null || SystemService.isRunning(daemon)) continue;
                        throw new IllegalStateException(daemon + " is dead");
                    }
                    this.checkpoint(true);
                }
                String[] parameters = FileUtils.readTextFile(state, 0, null).split("\n", -1);
                if (parameters.length != 7) {
                    throw new IllegalStateException("Cannot parse the state");
                }
                ((Vpn)Vpn.this).mConfig.interfaze = parameters[0].trim();
                Vpn.this.mConfig.addLegacyAddresses(parameters[1]);
                if (((Vpn)Vpn.this).mConfig.routes == null || ((Vpn)Vpn.this).mConfig.routes.isEmpty()) {
                    Vpn.this.mConfig.addLegacyRoutes(parameters[2]);
                }
                if (!(((Vpn)Vpn.this).mConfig.dnsServers != null && ((Vpn)Vpn.this).mConfig.dnsServers.size() != 0 || (dnsServers = parameters[3].trim()).isEmpty())) {
                    ((Vpn)Vpn.this).mConfig.dnsServers = Arrays.asList(dnsServers.split(" "));
                }
                if (!(((Vpn)Vpn.this).mConfig.searchDomains != null && ((Vpn)Vpn.this).mConfig.searchDomains.size() != 0 || (searchDomains = parameters[4].trim()).isEmpty())) {
                    ((Vpn)Vpn.this).mConfig.searchDomains = Arrays.asList(searchDomains.split(" "));
                }
                if (!(endpoint = parameters[5]).isEmpty()) {
                    try {
                        InetAddress addr = InetAddress.parseNumericAddress(endpoint);
                        if (addr instanceof Inet4Address) {
                            ((Vpn)Vpn.this).mConfig.routes.add(new RouteInfo(new IpPrefix(addr, 32), 9));
                        } else if (addr instanceof Inet6Address) {
                            ((Vpn)Vpn.this).mConfig.routes.add(new RouteInfo(new IpPrefix(addr, 128), 9));
                        } else {
                            Log.e(TAG, "Unknown IP address family for VPN endpoint: " + endpoint);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Log.e(TAG, "Exception constructing throw route to " + endpoint + ": " + e);
                    }
                }
                Vpn vpn = Vpn.this;
                synchronized (vpn) {
                    ((Vpn)Vpn.this).mConfig.startTime = SystemClock.elapsedRealtime();
                    this.checkpoint(false);
                    if (Vpn.this.jniCheck(((Vpn)Vpn.this).mConfig.interfaze) == 0) {
                        throw new IllegalStateException(((Vpn)Vpn.this).mConfig.interfaze + " is gone");
                    }
                    Vpn.this.mInterface = ((Vpn)Vpn.this).mConfig.interfaze;
                    Vpn.this.mVpnUsers = new ArrayList();
                    Vpn.this.agentConnect();
                    Log.i(TAG, "Connected!");
                }
            }
            catch (Exception e) {
                Log.i(TAG, "Aborting", e);
                Vpn.this.updateState(NetworkInfo.DetailedState.FAILED, e.getMessage());
                this.exit();
            }
            finally {
                if (!initFinished) {
                    for (String daemon : this.mDaemons) {
                        SystemService.stop(daemon);
                    }
                }
                if (!initFinished || Vpn.this.mNetworkInfo.getDetailedState() == NetworkInfo.DetailedState.CONNECTING) {
                    Vpn.this.agentDisconnect();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void monitorDaemons() {
            if (!Vpn.this.mNetworkInfo.isConnected()) {
                return;
            }
            try {
                block6: while (true) {
                    Thread.sleep(2000L);
                    int i = 0;
                    while (true) {
                        if (i >= this.mDaemons.length) continue block6;
                        if (this.mArguments[i] != null && SystemService.isStopped(this.mDaemons[i])) {
                            return;
                        }
                        ++i;
                        continue;
                        break;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Log.d(TAG, "interrupted during monitorDaemons(); stopping services");
                return;
            }
            finally {
                String[] arr$ = this.mDaemons;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) {
                        Vpn.this.agentDisconnect();
                    }
                    String daemon = arr$[i$];
                    SystemService.stop(daemon);
                    ++i$;
                }
            }
        }
    }

    private class Connection
    implements ServiceConnection {
        private IBinder mService;

        private Connection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mService = service;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            this.mService = null;
        }
    }
}

