/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.content.SyncAdapterType;
import android.content.SyncAdaptersCache;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCache;
import android.os.Bundle;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.util.Log;
import android.util.Pair;
import com.android.server.content.SyncManager;
import com.android.server.content.SyncOperation;
import com.android.server.content.SyncStorageEngine;
import com.google.android.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SyncQueue {
    private static final String TAG = "SyncManager";
    private final SyncStorageEngine mSyncStorageEngine;
    private final SyncAdaptersCache mSyncAdapters;
    private final PackageManager mPackageManager;
    private final HashMap<String, SyncOperation> mOperationsMap = Maps.newHashMap();

    public SyncQueue(PackageManager packageManager, SyncStorageEngine syncStorageEngine, SyncAdaptersCache syncAdapters) {
        this.mPackageManager = packageManager;
        this.mSyncStorageEngine = syncStorageEngine;
        this.mSyncAdapters = syncAdapters;
    }

    public void addPendingOperations(int userId) {
        for (SyncStorageEngine.PendingOperation op : this.mSyncStorageEngine.getPendingOperations()) {
            SyncOperation operationToAdd;
            SyncStorageEngine.EndPoint info = op.target;
            if (info.userId != userId) continue;
            Pair<Long, Long> backoff = this.mSyncStorageEngine.getBackoff(info);
            if (info.target_provider) {
                RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(info.provider, info.account.type), info.userId);
                if (syncAdapterInfo == null) {
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Missing sync adapter info for authority " + op.target);
                    continue;
                }
                operationToAdd = new SyncOperation(info.account, info.userId, op.reason, op.syncSource, info.provider, op.extras, op.expedited ? -1L : 0L, 0L, backoff != null ? (Long)backoff.first : 0L, this.mSyncStorageEngine.getDelayUntilTime(info), ((SyncAdapterType)syncAdapterInfo.type).allowParallelSyncs());
                operationToAdd.pendingOperation = op;
                this.add(operationToAdd, op);
                continue;
            }
            if (!info.target_service) continue;
            try {
                this.mPackageManager.getServiceInfo(info.service, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.w(TAG, "Missing sync service for authority " + op.target);
                continue;
            }
            operationToAdd = new SyncOperation(info.service, info.userId, op.reason, op.syncSource, op.extras, op.expedited ? -1L : 0L, 0L, backoff != null ? (Long)backoff.first : 0L, this.mSyncStorageEngine.getDelayUntilTime(info));
            operationToAdd.pendingOperation = op;
            this.add(operationToAdd, op);
        }
    }

    public boolean add(SyncOperation operation) {
        return this.add(operation, null);
    }

    private boolean add(SyncOperation operation, SyncStorageEngine.PendingOperation pop) {
        String operationKey = operation.key;
        SyncOperation existingOperation = this.mOperationsMap.get(operationKey);
        if (existingOperation != null) {
            boolean changed = false;
            if (operation.compareTo(existingOperation) <= 0) {
                long newRunTime;
                existingOperation.latestRunTime = newRunTime = Math.min(existingOperation.latestRunTime, operation.latestRunTime);
                existingOperation.flexTime = operation.flexTime;
                changed = true;
            }
            return changed;
        }
        operation.pendingOperation = pop;
        if (operation.pendingOperation == null) {
            pop = this.mSyncStorageEngine.insertIntoPending(operation);
            if (pop == null) {
                throw new IllegalStateException("error adding pending sync operation " + operation);
            }
            operation.pendingOperation = pop;
        }
        this.mOperationsMap.put(operationKey, operation);
        return true;
    }

    public void removeUserLocked(int userId) {
        ArrayList<SyncOperation> opsToRemove = new ArrayList<SyncOperation>();
        for (SyncOperation op : this.mOperationsMap.values()) {
            if (op.target.userId != userId) continue;
            opsToRemove.add(op);
        }
        for (SyncOperation op : opsToRemove) {
            this.remove(op);
        }
    }

    public void remove(SyncOperation operation) {
        boolean isLoggable = Log.isLoggable(TAG, 2);
        SyncOperation operationToRemove = this.mOperationsMap.remove(operation.key);
        if (isLoggable) {
            Log.v(TAG, "Attempting to remove: " + operation.key);
        }
        if (operationToRemove == null) {
            if (isLoggable) {
                Log.v(TAG, "Could not find: " + operation.key);
            }
            return;
        }
        if (!this.mSyncStorageEngine.deleteFromPending(operationToRemove.pendingOperation)) {
            String errorMessage = "unable to find pending row for " + operationToRemove;
            Log.e(TAG, errorMessage, new IllegalStateException(errorMessage));
        }
    }

    public void clearBackoffs() {
        for (SyncOperation op : this.mOperationsMap.values()) {
            op.backoff = 0L;
            op.updateEffectiveRunTime();
        }
    }

    public void onBackoffChanged(SyncStorageEngine.EndPoint target, long backoff) {
        for (SyncOperation op : this.mOperationsMap.values()) {
            if (!op.target.matchesSpec(target)) continue;
            op.backoff = backoff;
            op.updateEffectiveRunTime();
        }
    }

    public void onDelayUntilTimeChanged(SyncStorageEngine.EndPoint target, long delayUntil) {
        for (SyncOperation op : this.mOperationsMap.values()) {
            if (!op.target.matchesSpec(target)) continue;
            op.delayUntil = delayUntil;
            op.updateEffectiveRunTime();
        }
    }

    public void remove(SyncStorageEngine.EndPoint info, Bundle extras) {
        Iterator<Map.Entry<String, SyncOperation>> entries = this.mOperationsMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, SyncOperation> entry = entries.next();
            SyncOperation syncOperation = entry.getValue();
            SyncStorageEngine.EndPoint opInfo = syncOperation.target;
            if (!opInfo.matchesSpec(info) || extras != null && !SyncManager.syncExtrasEquals(syncOperation.extras, extras, false)) continue;
            entries.remove();
            if (this.mSyncStorageEngine.deleteFromPending(syncOperation.pendingOperation)) continue;
            String errorMessage = "unable to find pending row for " + syncOperation;
            Log.e(TAG, errorMessage, new IllegalStateException(errorMessage));
        }
    }

    public Collection<SyncOperation> getOperations() {
        return this.mOperationsMap.values();
    }

    public void dump(StringBuilder sb) {
        long now = SystemClock.elapsedRealtime();
        sb.append("SyncQueue: ").append(this.mOperationsMap.size()).append(" operation(s)\n");
        for (SyncOperation operation : this.mOperationsMap.values()) {
            sb.append("  ");
            if (operation.effectiveRunTime <= now) {
                sb.append("READY");
            } else {
                sb.append(DateUtils.formatElapsedTime((operation.effectiveRunTime - now) / 1000L));
            }
            sb.append(" - ");
            sb.append(operation.dump(this.mPackageManager, false)).append("\n");
        }
    }
}

