/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.util.SparseArray;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;

public final class HdmiCecMessageValidator {
    private static final String TAG = "HdmiCecMessageValidator";
    static final int OK = 0;
    static final int ERROR_SOURCE = 1;
    static final int ERROR_DESTINATION = 2;
    static final int ERROR_PARAMETER = 3;
    private final HdmiControlService mService;
    private static final int DEST_DIRECT = 1;
    private static final int DEST_BROADCAST = 2;
    private static final int DEST_ALL = 3;
    private static final int SRC_UNREGISTERED = 4;
    final SparseArray<ValidationInfo> mValidationInfo = new SparseArray();

    public HdmiCecMessageValidator(HdmiControlService service) {
        this.mService = service;
        PhysicalAddressValidator physicalAddressValidator = new PhysicalAddressValidator();
        this.addValidationInfo(130, physicalAddressValidator, 6);
        this.addValidationInfo(157, physicalAddressValidator, 1);
        this.addValidationInfo(132, new ReportPhysicalAddressValidator(), 6);
        this.addValidationInfo(128, new RoutingChangeValidator(), 6);
        this.addValidationInfo(129, physicalAddressValidator, 6);
        this.addValidationInfo(134, physicalAddressValidator, 2);
        this.addValidationInfo(112, physicalAddressValidator, 1);
        FixedLengthValidator noneValidator = new FixedLengthValidator(0);
        this.addValidationInfo(255, noneValidator, 1);
        this.addValidationInfo(159, noneValidator, 1);
        this.addValidationInfo(145, noneValidator, 5);
        this.addValidationInfo(113, noneValidator, 1);
        this.addValidationInfo(143, noneValidator, 1);
        this.addValidationInfo(140, noneValidator, 5);
        this.addValidationInfo(70, noneValidator, 1);
        this.addValidationInfo(131, noneValidator, 5);
        this.addValidationInfo(125, noneValidator, 1);
        this.addValidationInfo(4, noneValidator, 1);
        this.addValidationInfo(192, noneValidator, 1);
        this.addValidationInfo(11, noneValidator, 1);
        this.addValidationInfo(15, noneValidator, 1);
        this.addValidationInfo(193, noneValidator, 1);
        this.addValidationInfo(194, noneValidator, 1);
        this.addValidationInfo(195, noneValidator, 1);
        this.addValidationInfo(196, noneValidator, 1);
        this.addValidationInfo(133, noneValidator, 6);
        this.addValidationInfo(54, noneValidator, 7);
        this.addValidationInfo(197, noneValidator, 1);
        this.addValidationInfo(13, noneValidator, 1);
        this.addValidationInfo(6, noneValidator, 1);
        this.addValidationInfo(5, noneValidator, 1);
        this.addValidationInfo(69, noneValidator, 1);
        this.addValidationInfo(139, noneValidator, 3);
        FixedLengthValidator oneByteValidator = new FixedLengthValidator(1);
        this.addValidationInfo(9, new VariableLengthValidator(1, 8), 1);
        this.addValidationInfo(10, oneByteValidator, 1);
        this.addValidationInfo(158, oneByteValidator, 1);
        this.addValidationInfo(50, new FixedLengthValidator(3), 2);
        VariableLengthValidator maxLengthValidator = new VariableLengthValidator(0, 14);
        this.addValidationInfo(135, new FixedLengthValidator(3), 2);
        this.addValidationInfo(137, maxLengthValidator, 5);
        this.addValidationInfo(160, maxLengthValidator, 7);
        this.addValidationInfo(138, maxLengthValidator, 7);
        this.addValidationInfo(100, maxLengthValidator, 1);
        this.addValidationInfo(71, maxLengthValidator, 1);
        this.addValidationInfo(141, oneByteValidator, 1);
        this.addValidationInfo(142, oneByteValidator, 1);
        this.addValidationInfo(68, new VariableLengthValidator(1, 2), 1);
        this.addValidationInfo(144, oneByteValidator, 1);
        this.addValidationInfo(0, new FixedLengthValidator(2), 1);
        this.addValidationInfo(122, oneByteValidator, 1);
        this.addValidationInfo(163, new FixedLengthValidator(3), 1);
        this.addValidationInfo(164, oneByteValidator, 1);
        this.addValidationInfo(114, oneByteValidator, 3);
        this.addValidationInfo(126, oneByteValidator, 1);
        this.addValidationInfo(154, oneByteValidator, 1);
        this.addValidationInfo(248, maxLengthValidator, 6);
    }

    private void addValidationInfo(int opcode, ParameterValidator validator, int addrType) {
        this.mValidationInfo.append(opcode, new ValidationInfo(validator, addrType));
    }

    int isValid(HdmiCecMessage message) {
        int opcode = message.getOpcode();
        ValidationInfo info = this.mValidationInfo.get(opcode);
        if (info == null) {
            HdmiLogger.warning("No validation information for the message: " + message, new Object[0]);
            return 0;
        }
        if (message.getSource() == 15 && (info.addressType & 4) == 0) {
            HdmiLogger.warning("Unexpected source: " + message, new Object[0]);
            return 1;
        }
        if (message.getDestination() == 15) {
            if ((info.addressType & 2) == 0) {
                HdmiLogger.warning("Unexpected broadcast message: " + message, new Object[0]);
                return 2;
            }
        } else if ((info.addressType & 1) == 0) {
            HdmiLogger.warning("Unexpected direct message: " + message, new Object[0]);
            return 2;
        }
        if (!info.parameterValidator.isValid(message.getParams())) {
            HdmiLogger.warning("Unexpected parameters: " + message, new Object[0]);
            return 3;
        }
        return 0;
    }

    private boolean isValidPhysicalAddress(byte[] params, int offset) {
        if (!this.mService.isTvDevice()) {
            return true;
        }
        int path = HdmiUtils.twoBytesToInt(params, offset);
        if (path != 65535 && path == this.mService.getPhysicalAddress()) {
            return true;
        }
        int portId = this.mService.pathToPortId(path);
        return portId != -1;
    }

    static boolean isValidType(int type) {
        return 0 <= type && type <= 7 && type != 2;
    }

    private class RoutingChangeValidator
    implements ParameterValidator {
        private RoutingChangeValidator() {
        }

        @Override
        public boolean isValid(byte[] params) {
            if (params.length != 4) {
                return false;
            }
            return HdmiCecMessageValidator.this.isValidPhysicalAddress(params, 0) && HdmiCecMessageValidator.this.isValidPhysicalAddress(params, 2);
        }
    }

    private class ReportPhysicalAddressValidator
    implements ParameterValidator {
        private ReportPhysicalAddressValidator() {
        }

        @Override
        public boolean isValid(byte[] params) {
            if (params.length != 3) {
                return false;
            }
            return HdmiCecMessageValidator.this.isValidPhysicalAddress(params, 0) && HdmiCecMessageValidator.isValidType(params[2]);
        }
    }

    private class PhysicalAddressValidator
    implements ParameterValidator {
        private PhysicalAddressValidator() {
        }

        @Override
        public boolean isValid(byte[] params) {
            if (params.length != 2) {
                return false;
            }
            return HdmiCecMessageValidator.this.isValidPhysicalAddress(params, 0);
        }
    }

    private static class VariableLengthValidator
    implements ParameterValidator {
        private final int mMinLength;
        private final int mMaxLength;

        public VariableLengthValidator(int minLength, int maxLength) {
            this.mMinLength = minLength;
            this.mMaxLength = maxLength;
        }

        @Override
        public boolean isValid(byte[] params) {
            return params.length >= this.mMinLength && params.length <= this.mMaxLength;
        }
    }

    private static class FixedLengthValidator
    implements ParameterValidator {
        private final int mLength;

        public FixedLengthValidator(int length) {
            this.mLength = length;
        }

        @Override
        public boolean isValid(byte[] params) {
            return params.length == this.mLength;
        }
    }

    private static class ValidationInfo {
        public final ParameterValidator parameterValidator;
        public final int addressType;

        public ValidationInfo(ParameterValidator validator, int type) {
            this.parameterValidator = validator;
            this.addressType = type;
        }
    }

    static interface ParameterValidator {
        public boolean isValid(byte[] var1);
    }
}

