/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecKeycode;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;

final class SendKeyAction
extends HdmiCecFeatureAction {
    private static final String TAG = "SendKeyAction";
    private static final int STATE_PROCESSING_KEYCODE = 1;
    private final int mTargetAddress;
    private int mLastKeycode;

    SendKeyAction(HdmiCecLocalDevice source, int targetAddress, int keycode) {
        super(source);
        this.mTargetAddress = targetAddress;
        this.mLastKeycode = keycode;
    }

    @Override
    public boolean start() {
        this.sendKeyDown(this.mLastKeycode);
        if (!HdmiCecKeycode.isRepeatableKey(this.mLastKeycode)) {
            this.sendKeyUp();
            this.finish();
            return true;
        }
        this.mState = 1;
        this.addTimer(this.mState, 300);
        return true;
    }

    void processKeyEvent(int keycode, boolean isPressed) {
        if (this.mState != 1) {
            Slog.w(TAG, "Not in a valid state");
            return;
        }
        if (isPressed) {
            if (keycode != this.mLastKeycode) {
                this.sendKeyDown(keycode);
                if (!HdmiCecKeycode.isRepeatableKey(keycode)) {
                    this.sendKeyUp();
                    this.finish();
                    return;
                }
                this.mActionTimer.clearTimerMessage();
                this.addTimer(this.mState, 300);
                this.mLastKeycode = keycode;
            }
        } else if (keycode == this.mLastKeycode) {
            this.sendKeyUp();
            this.finish();
        }
    }

    private void sendKeyDown(int keycode) {
        int cecKeycode = HdmiCecKeycode.androidKeyToCecKey(keycode);
        if (cecKeycode == -1) {
            return;
        }
        this.sendCommand(HdmiCecMessageBuilder.buildUserControlPressed(this.getSourceAddress(), this.mTargetAddress, new byte[]{(byte)(cecKeycode & 0xFF)}));
    }

    private void sendKeyUp() {
        this.sendCommand(HdmiCecMessageBuilder.buildUserControlReleased(this.getSourceAddress(), this.mTargetAddress));
    }

    @Override
    public boolean processCommand(HdmiCecMessage cmd) {
        return false;
    }

    @Override
    public void handleTimerEvent(int state) {
        if (this.mState != 1) {
            Slog.w(TAG, "Not in a valid state");
            return;
        }
        this.sendKeyDown(this.mLastKeycode);
        this.addTimer(this.mState, 300);
    }
}

