/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import java.util.Arrays;

public class TimerRecordingAction
extends HdmiCecFeatureAction {
    private static final String TAG = "TimerRecordingAction";
    private static final int TIMER_STATUS_TIMEOUT_MS = 120000;
    private static final int STATE_WAITING_FOR_TIMER_STATUS = 1;
    private final int mRecorderAddress;
    private final int mSourceType;
    private final byte[] mRecordSource;

    TimerRecordingAction(HdmiCecLocalDevice source, int recorderAddress, int sourceType, byte[] recordSource) {
        super(source);
        this.mRecorderAddress = recorderAddress;
        this.mSourceType = sourceType;
        this.mRecordSource = recordSource;
    }

    @Override
    boolean start() {
        this.sendTimerMessage();
        return true;
    }

    private void sendTimerMessage() {
        HdmiCecMessage message = null;
        switch (this.mSourceType) {
            case 1: {
                message = HdmiCecMessageBuilder.buildSetDigitalTimer(this.getSourceAddress(), this.mRecorderAddress, this.mRecordSource);
                break;
            }
            case 2: {
                message = HdmiCecMessageBuilder.buildSetAnalogueTimer(this.getSourceAddress(), this.mRecorderAddress, this.mRecordSource);
                break;
            }
            case 3: {
                message = HdmiCecMessageBuilder.buildSetExternalTimer(this.getSourceAddress(), this.mRecorderAddress, this.mRecordSource);
                break;
            }
            default: {
                this.tv().announceTimerRecordingResult(2);
                this.finish();
                return;
            }
        }
        this.sendCommand(message, new HdmiControlService.SendMessageCallback(){

            @Override
            public void onSendCompleted(int error) {
                if (error != 0) {
                    TimerRecordingAction.this.tv().announceTimerRecordingResult(1);
                    TimerRecordingAction.this.finish();
                    return;
                }
                TimerRecordingAction.this.mState = 1;
                TimerRecordingAction.this.addTimer(TimerRecordingAction.this.mState, 120000);
            }
        });
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1) {
            return false;
        }
        if (cmd.getSource() != this.mRecorderAddress) {
            return false;
        }
        switch (cmd.getOpcode()) {
            case 53: {
                return this.handleTimerStatus(cmd);
            }
            case 0: {
                return this.handleFeatureAbort(cmd);
            }
        }
        return false;
    }

    private boolean handleTimerStatus(HdmiCecMessage cmd) {
        byte[] timerStatusData = cmd.getParams();
        if (timerStatusData.length == 1 || timerStatusData.length == 3) {
            this.tv().announceTimerRecordingResult(TimerRecordingAction.bytesToInt(timerStatusData));
            Slog.i(TAG, "Received [Timer Status Data]:" + Arrays.toString(timerStatusData));
        } else {
            Slog.w(TAG, "Invalid [Timer Status Data]:" + Arrays.toString(timerStatusData));
        }
        this.finish();
        return true;
    }

    private boolean handleFeatureAbort(HdmiCecMessage cmd) {
        byte[] params = cmd.getParams();
        int messageType = params[0] & 0xFF;
        switch (messageType) {
            case 52: 
            case 151: 
            case 162: {
                break;
            }
            default: {
                return false;
            }
        }
        int reason = params[1] & 0xFF;
        Slog.i(TAG, "[Feature Abort] for " + messageType + " reason:" + reason);
        this.tv().announceTimerRecordingResult(1);
        this.finish();
        return true;
    }

    private static int bytesToInt(byte[] data) {
        if (data.length > 4) {
            throw new IllegalArgumentException("Invalid data size:" + Arrays.toString(data));
        }
        int result = 0;
        for (int i = 0; i < data.length; ++i) {
            int shift = (3 - i) * 8;
            result |= (data[i] & 0xFF) << shift;
        }
        return result;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            Slog.w(TAG, "Timeout in invalid state:[Expected:" + this.mState + ", Actual:" + state + "]");
            return;
        }
        this.tv().announceTimerRecordingResult(1);
        this.finish();
    }
}

