/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.AppGlobals;
import android.app.job.IJobScheduler;
import android.app.job.JobInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.IPackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.app.IBatteryStats;
import com.android.server.SystemService;
import com.android.server.job.JobCompletedListener;
import com.android.server.job.JobServiceContext;
import com.android.server.job.JobStore;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.BatteryController;
import com.android.server.job.controllers.ConnectivityController;
import com.android.server.job.controllers.IdleController;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import com.android.server.job.controllers.TimeController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JobSchedulerService
extends SystemService
implements StateChangedListener,
JobCompletedListener {
    static final boolean DEBUG = false;
    private static final int MAX_JOB_CONTEXTS_COUNT = 3;
    static final String TAG = "JobSchedulerService";
    final JobStore mJobs;
    static final int MSG_JOB_EXPIRED = 0;
    static final int MSG_CHECK_JOB = 1;
    static final int MIN_IDLE_COUNT = 1;
    static final int MIN_CHARGING_COUNT = 1;
    static final int MIN_CONNECTIVITY_COUNT = 2;
    static final int MIN_READY_JOBS_COUNT = 2;
    final List<JobServiceContext> mActiveServices = new ArrayList<JobServiceContext>();
    List<StateController> mControllers;
    final ArrayList<JobStatus> mPendingJobs = new ArrayList();
    final ArrayList<Integer> mStartedUsers = new ArrayList();
    final JobHandler mHandler;
    final JobSchedulerStub mJobSchedulerStub;
    IBatteryStats mBatteryStats;
    boolean mReadyToRock;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Slog.d(JobSchedulerService.TAG, "Receieved: " + intent.getAction());
            if ("android.intent.action.PACKAGE_REMOVED".equals(intent.getAction())) {
                int uidRemoved = intent.getIntExtra("android.intent.extra.UID", -1);
                JobSchedulerService.this.cancelJobsForUid(uidRemoved);
            } else if ("android.intent.action.USER_REMOVED".equals(intent.getAction())) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", 0);
                JobSchedulerService.this.cancelJobsForUser(userId);
            }
        }
    };

    @Override
    public void onStartUser(int userHandle) {
        this.mStartedUsers.add(userHandle);
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    @Override
    public void onStopUser(int userHandle) {
        this.mStartedUsers.remove((Object)userHandle);
    }

    public int schedule(JobInfo job, int uId) {
        JobStatus jobStatus = new JobStatus(job, uId);
        this.cancelJob(uId, job.getId());
        this.startTrackingJob(jobStatus);
        this.mHandler.obtainMessage(1).sendToTarget();
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JobInfo> getPendingJobs(int uid) {
        ArrayList<JobInfo> outList = new ArrayList<JobInfo>();
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            ArraySet<JobStatus> jobs = this.mJobs.getJobs();
            for (int i = 0; i < jobs.size(); ++i) {
                JobStatus job = jobs.valueAt(i);
                if (job.getUid() != uid) continue;
                outList.add(job.getJob());
            }
        }
        return outList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelJobsForUser(int userHandle) {
        List<JobStatus> jobsForUser;
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            jobsForUser = this.mJobs.getJobsByUser(userHandle);
        }
        for (int i = 0; i < jobsForUser.size(); ++i) {
            JobStatus toRemove = jobsForUser.get(i);
            this.cancelJobImpl(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobsForUid(int uid) {
        List<JobStatus> jobsForUid;
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            jobsForUid = this.mJobs.getJobsByUid(uid);
        }
        for (int i = 0; i < jobsForUid.size(); ++i) {
            JobStatus toRemove = jobsForUid.get(i);
            this.cancelJobImpl(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJob(int uid, int jobId) {
        JobStatus toCancel;
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            toCancel = this.mJobs.getJobByUidAndJobId(uid, jobId);
        }
        if (toCancel != null) {
            this.cancelJobImpl(toCancel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelJobImpl(JobStatus cancelled) {
        this.stopTrackingJob(cancelled);
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            this.mPendingJobs.remove(cancelled);
            this.stopJobOnServiceContextLocked(cancelled);
        }
    }

    public JobSchedulerService(Context context) {
        super(context);
        this.mControllers = new ArrayList<StateController>();
        this.mControllers.add(ConnectivityController.get(this));
        this.mControllers.add(TimeController.get(this));
        this.mControllers.add(IdleController.get(this));
        this.mControllers.add(BatteryController.get(this));
        this.mHandler = new JobHandler(context.getMainLooper());
        this.mJobSchedulerStub = new JobSchedulerStub();
        this.mJobs = JobStore.initAndGet(this);
    }

    @Override
    public void onStart() {
        this.publishBinderService("jobscheduler", this.mJobSchedulerStub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (500 == phase) {
            IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_REMOVED");
            filter.addDataScheme("package");
            this.getContext().registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
            IntentFilter userFilter = new IntentFilter("android.intent.action.USER_REMOVED");
            this.getContext().registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, userFilter, null, null);
        } else if (phase == 600) {
            JobStore jobStore = this.mJobs;
            synchronized (jobStore) {
                this.mReadyToRock = true;
                this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
                for (int i = 0; i < 3; ++i) {
                    this.mActiveServices.add(new JobServiceContext(this, this.mBatteryStats, this.getContext().getMainLooper()));
                }
                ArraySet<JobStatus> jobs = this.mJobs.getJobs();
                for (int i = 0; i < jobs.size(); ++i) {
                    JobStatus job = jobs.valueAt(i);
                    for (int controller = 0; controller < this.mControllers.size(); ++controller) {
                        this.mControllers.get(controller).maybeStartTrackingJob(job);
                    }
                }
                this.mHandler.obtainMessage(1).sendToTarget();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTrackingJob(JobStatus jobStatus) {
        boolean rocking;
        boolean update;
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            update = this.mJobs.add(jobStatus);
            rocking = this.mReadyToRock;
        }
        if (rocking) {
            for (int i = 0; i < this.mControllers.size(); ++i) {
                StateController controller = this.mControllers.get(i);
                if (update) {
                    controller.maybeStopTrackingJob(jobStatus);
                }
                controller.maybeStartTrackingJob(jobStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stopTrackingJob(JobStatus jobStatus) {
        boolean rocking;
        boolean removed;
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            removed = this.mJobs.remove(jobStatus);
            rocking = this.mReadyToRock;
        }
        if (removed && rocking) {
            for (int i = 0; i < this.mControllers.size(); ++i) {
                StateController controller = this.mControllers.get(i);
                controller.maybeStopTrackingJob(jobStatus);
            }
        }
        return removed;
    }

    private boolean stopJobOnServiceContextLocked(JobStatus job) {
        for (int i = 0; i < this.mActiveServices.size(); ++i) {
            JobServiceContext jsc = this.mActiveServices.get(i);
            JobStatus executing = jsc.getRunningJob();
            if (executing == null || !executing.matches(job.getUid(), job.getJobId())) continue;
            jsc.cancelExecutingJob();
            return true;
        }
        return false;
    }

    private boolean isCurrentlyActiveLocked(JobStatus job) {
        for (int i = 0; i < this.mActiveServices.size(); ++i) {
            JobServiceContext serviceContext = this.mActiveServices.get(i);
            JobStatus running = serviceContext.getRunningJob();
            if (running == null || !running.matches(job.getUid(), job.getJobId())) continue;
            return true;
        }
        return false;
    }

    private JobStatus getRescheduleJobForFailure(JobStatus failureToReschedule) {
        long delayMillis;
        long elapsedNowMillis = SystemClock.elapsedRealtime();
        JobInfo job = failureToReschedule.getJob();
        long initialBackoffMillis = job.getInitialBackoffMillis();
        int backoffAttempts = failureToReschedule.getNumFailures() + 1;
        switch (job.getBackoffPolicy()) {
            case 0: {
                delayMillis = initialBackoffMillis * (long)backoffAttempts;
                break;
            }
            default: {
                delayMillis = (long)Math.scalb(initialBackoffMillis, backoffAttempts - 1);
            }
        }
        delayMillis = Math.min(delayMillis, 18000000L);
        return new JobStatus(failureToReschedule, elapsedNowMillis + delayMillis, Long.MAX_VALUE, backoffAttempts);
    }

    private JobStatus getRescheduleJobForPeriodic(JobStatus periodicToReschedule) {
        long elapsedNow = SystemClock.elapsedRealtime();
        long runEarly = Math.max(periodicToReschedule.getLatestRunTimeElapsed() - elapsedNow, 0L);
        long newEarliestRunTimeElapsed = elapsedNow + runEarly;
        long period = periodicToReschedule.getJob().getIntervalMillis();
        long newLatestRuntimeElapsed = newEarliestRunTimeElapsed + period;
        return new JobStatus(periodicToReschedule, newEarliestRunTimeElapsed, newLatestRuntimeElapsed, 0);
    }

    @Override
    public void onJobCompleted(JobStatus jobStatus, boolean needsReschedule) {
        if (!this.stopTrackingJob(jobStatus)) {
            return;
        }
        if (needsReschedule) {
            JobStatus rescheduled = this.getRescheduleJobForFailure(jobStatus);
            this.startTrackingJob(rescheduled);
        } else if (jobStatus.getJob().isPeriodic()) {
            JobStatus rescheduledPeriodic = this.getRescheduleJobForPeriodic(jobStatus);
            this.startTrackingJob(rescheduledPeriodic);
        }
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    @Override
    public void onControllerStateChanged() {
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    @Override
    public void onRunJobNow(JobStatus jobStatus) {
        this.mHandler.obtainMessage(0, jobStatus).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpInternal(PrintWriter pw) {
        long now = SystemClock.elapsedRealtime();
        JobStore jobStore = this.mJobs;
        synchronized (jobStore) {
            int i;
            pw.print("Started users: ");
            for (int i2 = 0; i2 < this.mStartedUsers.size(); ++i2) {
                pw.print("u" + this.mStartedUsers.get(i2) + " ");
            }
            pw.println();
            pw.println("Registered jobs:");
            if (this.mJobs.size() > 0) {
                ArraySet<JobStatus> jobs = this.mJobs.getJobs();
                for (int i3 = 0; i3 < jobs.size(); ++i3) {
                    JobStatus job = jobs.valueAt(i3);
                    job.dump(pw, "  ");
                }
            } else {
                pw.println("  None.");
            }
            for (i = 0; i < this.mControllers.size(); ++i) {
                pw.println();
                this.mControllers.get(i).dumpControllerState(pw);
            }
            pw.println();
            pw.println("Pending:");
            for (i = 0; i < this.mPendingJobs.size(); ++i) {
                pw.println(this.mPendingJobs.get(i).hashCode());
            }
            pw.println();
            pw.println("Active jobs:");
            for (i = 0; i < this.mActiveServices.size(); ++i) {
                JobServiceContext jsc = this.mActiveServices.get(i);
                if (jsc.isAvailable()) continue;
                long timeout = jsc.getTimeoutElapsed();
                pw.print("Running for: ");
                pw.print((now - jsc.getExecutionStartTimeElapsed()) / 1000L);
                pw.print("s timeout=");
                pw.print(timeout);
                pw.print(" fromnow=");
                pw.println(timeout - now);
                jsc.getRunningJob().dump(pw, "  ");
            }
            pw.println();
            pw.print("mReadyToRock=");
            pw.println(this.mReadyToRock);
        }
        pw.println();
    }

    final class JobSchedulerStub
    extends IJobScheduler.Stub {
        private final SparseArray<Boolean> mPersistCache = new SparseArray();

        JobSchedulerStub() {
        }

        private void enforceValidJobRequest(int uid, JobInfo job) {
            IPackageManager pm = AppGlobals.getPackageManager();
            ComponentName service = job.getService();
            try {
                ServiceInfo si = pm.getServiceInfo(service, 0, UserHandle.getUserId(uid));
                if (si == null) {
                    throw new IllegalArgumentException("No such service " + service);
                }
                if (si.applicationInfo.uid != uid) {
                    throw new IllegalArgumentException("uid " + uid + " cannot schedule job in " + service.getPackageName());
                }
                if (!"android.permission.BIND_JOB_SERVICE".equals(si.permission)) {
                    throw new IllegalArgumentException("Scheduled service " + service + " does not require android.permission.BIND_JOB_SERVICE permission");
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canPersistJobs(int pid, int uid) {
            boolean canPersist;
            SparseArray<Boolean> sparseArray = this.mPersistCache;
            synchronized (sparseArray) {
                Boolean cached = this.mPersistCache.get(uid);
                if (cached != null) {
                    canPersist = cached;
                } else {
                    int result = JobSchedulerService.this.getContext().checkPermission("android.permission.RECEIVE_BOOT_COMPLETED", pid, uid);
                    canPersist = result == 0;
                    this.mPersistCache.put(uid, canPersist);
                }
            }
            return canPersist;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int schedule(JobInfo job) throws RemoteException {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            this.enforceValidJobRequest(uid, job);
            if (job.isPersisted() && !this.canPersistJobs(pid, uid)) {
                throw new IllegalArgumentException("Error: requested job be persisted without holding RECEIVE_BOOT_COMPLETED permission.");
            }
            long ident = Binder.clearCallingIdentity();
            try {
                int n = JobSchedulerService.this.schedule(job, uid);
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<JobInfo> getAllPendingJobs() throws RemoteException {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                List<JobInfo> list = JobSchedulerService.this.getPendingJobs(uid);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelAll() throws RemoteException {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                JobSchedulerService.this.cancelJobsForUid(uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel(int jobId) throws RemoteException {
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                JobSchedulerService.this.cancelJob(uid, jobId);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            JobSchedulerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DUMP", JobSchedulerService.TAG);
            long identityToken = Binder.clearCallingIdentity();
            try {
                JobSchedulerService.this.dumpInternal(pw);
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
        }
    }

    private class JobHandler
    extends Handler {
        public JobHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            JobStore jobStore = JobSchedulerService.this.mJobs;
            synchronized (jobStore) {
                if (!JobSchedulerService.this.mReadyToRock) {
                    return;
                }
            }
            switch (message.what) {
                case 0: {
                    jobStore = JobSchedulerService.this.mJobs;
                    synchronized (jobStore) {
                        JobStatus runNow = (JobStatus)message.obj;
                        if (runNow != null && !JobSchedulerService.this.mPendingJobs.contains(runNow) && JobSchedulerService.this.mJobs.containsJob(runNow)) {
                            JobSchedulerService.this.mPendingJobs.add(runNow);
                        }
                        this.queueReadyJobsForExecutionLockedH();
                        break;
                    }
                }
                case 1: {
                    jobStore = JobSchedulerService.this.mJobs;
                    synchronized (jobStore) {
                        this.maybeQueueReadyJobsForExecutionLockedH();
                        break;
                    }
                }
            }
            this.maybeRunPendingJobsH();
            this.removeMessages(1);
        }

        private void queueReadyJobsForExecutionLockedH() {
            ArraySet<JobStatus> jobs = JobSchedulerService.this.mJobs.getJobs();
            for (int i = 0; i < jobs.size(); ++i) {
                JobStatus job = jobs.valueAt(i);
                if (this.isReadyToBeExecutedLocked(job)) {
                    JobSchedulerService.this.mPendingJobs.add(job);
                    continue;
                }
                if (!this.isReadyToBeCancelledLocked(job)) continue;
                JobSchedulerService.this.stopJobOnServiceContextLocked(job);
            }
        }

        private void maybeQueueReadyJobsForExecutionLockedH() {
            int i;
            int chargingCount = 0;
            int idleCount = 0;
            int backoffCount = 0;
            int connectivityCount = 0;
            ArrayList<JobStatus> runnableJobs = new ArrayList<JobStatus>();
            ArraySet<JobStatus> jobs = JobSchedulerService.this.mJobs.getJobs();
            for (i = 0; i < jobs.size(); ++i) {
                JobStatus job = jobs.valueAt(i);
                if (this.isReadyToBeExecutedLocked(job)) {
                    if (job.getNumFailures() > 0) {
                        ++backoffCount;
                    }
                    if (job.hasIdleConstraint()) {
                        ++idleCount;
                    }
                    if (job.hasConnectivityConstraint() || job.hasUnmeteredConstraint()) {
                        ++connectivityCount;
                    }
                    if (job.hasChargingConstraint()) {
                        ++chargingCount;
                    }
                    runnableJobs.add(job);
                    continue;
                }
                if (!this.isReadyToBeCancelledLocked(job)) continue;
                JobSchedulerService.this.stopJobOnServiceContextLocked(job);
            }
            if (backoffCount > 0 || idleCount >= 1 || connectivityCount >= 2 || chargingCount >= 1 || runnableJobs.size() >= 2) {
                for (i = 0; i < runnableJobs.size(); ++i) {
                    JobSchedulerService.this.mPendingJobs.add((JobStatus)runnableJobs.get(i));
                }
            }
        }

        private boolean isReadyToBeExecutedLocked(JobStatus job) {
            boolean jobReady = job.isReady();
            boolean jobPending = JobSchedulerService.this.mPendingJobs.contains(job);
            boolean jobActive = JobSchedulerService.this.isCurrentlyActiveLocked(job);
            boolean userRunning = JobSchedulerService.this.mStartedUsers.contains(job.getUserId());
            return userRunning && jobReady && !jobPending && !jobActive;
        }

        private boolean isReadyToBeCancelledLocked(JobStatus job) {
            return !job.isReady() && JobSchedulerService.this.isCurrentlyActiveLocked(job);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeRunPendingJobsH() {
            JobStore jobStore = JobSchedulerService.this.mJobs;
            synchronized (jobStore) {
                Iterator<JobStatus> it = JobSchedulerService.this.mPendingJobs.iterator();
                while (it.hasNext()) {
                    JobStatus nextPending = it.next();
                    JobServiceContext availableContext = null;
                    for (int i = 0; i < JobSchedulerService.this.mActiveServices.size(); ++i) {
                        JobServiceContext jsc = JobSchedulerService.this.mActiveServices.get(i);
                        JobStatus running = jsc.getRunningJob();
                        if (running != null && running.matches(nextPending.getUid(), nextPending.getJobId())) {
                            availableContext = null;
                            break;
                        }
                        if (!jsc.isAvailable()) continue;
                        availableContext = jsc;
                    }
                    if (availableContext == null) continue;
                    if (!availableContext.executeRunnableJob(nextPending)) {
                        JobSchedulerService.this.mJobs.remove(nextPending);
                    }
                    it.remove();
                }
            }
        }
    }
}

