/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.net.Proxy;
import android.net.http.AndroidHttpClient;
import android.text.TextUtils;
import android.util.Log;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.params.ConnRouteParams;

public class GpsXtraDownloader {
    private static final String TAG = "GpsXtraDownloader";
    private static final boolean DEBUG = Log.isLoggable("GpsXtraDownloader", 3);
    private static final String DEFAULT_USER_AGENT = "Android";
    private final Context mContext;
    private final String[] mXtraServers;
    private int mNextServerIndex;
    private final String mUserAgent;

    GpsXtraDownloader(Context context, Properties properties) {
        String agent;
        this.mContext = context;
        int count = 0;
        String server1 = properties.getProperty("XTRA_SERVER_1");
        String server2 = properties.getProperty("XTRA_SERVER_2");
        String server3 = properties.getProperty("XTRA_SERVER_3");
        if (server1 != null) {
            ++count;
        }
        if (server2 != null) {
            ++count;
        }
        if (server3 != null) {
            ++count;
        }
        this.mUserAgent = TextUtils.isEmpty(agent = properties.getProperty("XTRA_USER_AGENT")) ? DEFAULT_USER_AGENT : agent;
        if (count == 0) {
            Log.e(TAG, "No XTRA servers were specified in the GPS configuration");
            this.mXtraServers = null;
            return;
        }
        this.mXtraServers = new String[count];
        count = 0;
        if (server1 != null) {
            this.mXtraServers[count++] = server1;
        }
        if (server2 != null) {
            this.mXtraServers[count++] = server2;
        }
        if (server3 != null) {
            this.mXtraServers[count++] = server3;
        }
        Random random = new Random();
        this.mNextServerIndex = random.nextInt(count);
    }

    byte[] downloadXtraData() {
        String proxyHost = Proxy.getHost(this.mContext);
        int proxyPort = Proxy.getPort(this.mContext);
        boolean useProxy = proxyHost != null && proxyPort != -1;
        byte[] result = null;
        int startIndex = this.mNextServerIndex;
        if (this.mXtraServers == null) {
            return null;
        }
        while (result == null) {
            result = this.doDownload(this.mXtraServers[this.mNextServerIndex], useProxy, proxyHost, proxyPort);
            ++this.mNextServerIndex;
            if (this.mNextServerIndex == this.mXtraServers.length) {
                this.mNextServerIndex = 0;
            }
            if (this.mNextServerIndex != startIndex) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doDownload(String url, boolean isProxySet, String proxyHost, int proxyPort) {
        if (DEBUG) {
            Log.d(TAG, "Downloading XTRA data from " + url);
        }
        try (AndroidHttpClient client = null;){
            byte[] body;
            block25: {
                if (DEBUG) {
                    Log.d(TAG, "XTRA user agent: " + this.mUserAgent);
                }
                client = AndroidHttpClient.newInstance(this.mUserAgent);
                HttpGet req = new HttpGet(url);
                if (isProxySet) {
                    HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                    ConnRouteParams.setDefaultProxy(req.getParams(), proxy);
                }
                req.addHeader("Accept", "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic");
                req.addHeader("x-wap-profile", "http://www.openmobilealliance.org/tech/profiles/UAPROF/ccppschema-20021212#");
                HttpResponse response = client.execute(req);
                StatusLine status = response.getStatusLine();
                if (status.getStatusCode() != 200) {
                    if (DEBUG) {
                        Log.d(TAG, "HTTP error: " + status.getReasonPhrase());
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                HttpEntity entity = response.getEntity();
                body = null;
                if (entity != null) {
                    try {
                        if (entity.getContentLength() <= 0L) break block25;
                        body = new byte[(int)entity.getContentLength()];
                        DataInputStream dis = new DataInputStream(entity.getContent());
                        try {
                            dis.readFully(body);
                        }
                        finally {
                            try {
                                dis.close();
                            }
                            catch (IOException e) {
                                Log.e(TAG, "Unexpected IOException.", e);
                            }
                        }
                    }
                    finally {
                        if (entity != null) {
                            entity.consumeContent();
                        }
                    }
                }
            }
            byte[] byArray = body;
            return byArray;
        }
        return null;
    }
}

