/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.service.notification.Condition;
import android.service.notification.ConditionProviderService;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.text.format.DateUtils;
import android.util.Log;
import android.util.Slog;
import com.android.server.notification.NotificationManagerService;
import java.io.PrintWriter;
import java.util.Date;

public class CountdownConditionProvider
extends ConditionProviderService {
    private static final String TAG = "CountdownConditions";
    private static final boolean DEBUG = Log.isLoggable("CountdownConditions", 3);
    public static final ComponentName COMPONENT = new ComponentName("android", CountdownConditionProvider.class.getName());
    private static final String ACTION = CountdownConditionProvider.class.getName();
    private static final int REQUEST_CODE = 100;
    private static final String EXTRA_CONDITION_ID = "condition_id";
    private final Context mContext = this;
    private final Receiver mReceiver = new Receiver();
    private boolean mConnected;
    private long mTime;

    public CountdownConditionProvider() {
        if (DEBUG) {
            Slog.d(TAG, "new CountdownConditionProvider()");
        }
    }

    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.println("    CountdownConditionProvider:");
        pw.print("      mConnected=");
        pw.println(this.mConnected);
        pw.print("      mTime=");
        pw.println(this.mTime);
    }

    @Override
    public void onConnected() {
        if (DEBUG) {
            Slog.d(TAG, "onConnected");
        }
        this.mContext.registerReceiver(this.mReceiver, new IntentFilter(ACTION));
        this.mConnected = true;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (DEBUG) {
            Slog.d(TAG, "onDestroy");
        }
        if (this.mConnected) {
            this.mContext.unregisterReceiver(this.mReceiver);
        }
        this.mConnected = false;
    }

    @Override
    public void onRequestConditions(int relevance) {
    }

    @Override
    public void onSubscribe(Uri conditionId) {
        if (DEBUG) {
            Slog.d(TAG, "onSubscribe " + conditionId);
        }
        this.mTime = ZenModeConfig.tryParseCountdownConditionId(conditionId);
        AlarmManager alarms = (AlarmManager)this.mContext.getSystemService("alarm");
        Intent intent = new Intent(ACTION).putExtra(EXTRA_CONDITION_ID, conditionId).setFlags(0x40000000);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 100, intent, 0x8000000);
        alarms.cancel(pendingIntent);
        if (this.mTime > 0L) {
            long now = System.currentTimeMillis();
            CharSequence span = DateUtils.getRelativeTimeSpanString(this.mTime, now, 60000L);
            if (this.mTime <= now) {
                this.notifyCondition(CountdownConditionProvider.newCondition(this.mTime, 0));
            } else {
                alarms.setExact(0, this.mTime, pendingIntent);
            }
            if (DEBUG) {
                Slog.d(TAG, String.format("%s %s for %s, %s in the future (%s), now=%s", this.mTime <= now ? "Not scheduling" : "Scheduling", ACTION, CountdownConditionProvider.ts(this.mTime), this.mTime - now, span, CountdownConditionProvider.ts(now)));
            }
        }
    }

    @Override
    public void onUnsubscribe(Uri conditionId) {
    }

    private static final Condition newCondition(long time, int state) {
        return new Condition(ZenModeConfig.toCountdownConditionId(time), "", "", "", 0, state, 1);
    }

    public static String tryParseDescription(Uri conditionUri) {
        long time = ZenModeConfig.tryParseCountdownConditionId(conditionUri);
        if (time == 0L) {
            return null;
        }
        long now = System.currentTimeMillis();
        CharSequence span = DateUtils.getRelativeTimeSpanString(time, now, 60000L);
        return String.format("Scheduled for %s, %s in the future (%s), now=%s", CountdownConditionProvider.ts(time), time - now, span, CountdownConditionProvider.ts(now));
    }

    private static String ts(long time) {
        return new Date(time) + " (" + time + ")";
    }

    public void attachBase(Context base) {
        this.attachBaseContext(base);
    }

    public IConditionProvider asInterface() {
        return (IConditionProvider)((Object)this.onBind(null));
    }

    private final class Receiver
    extends BroadcastReceiver {
        private Receiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (ACTION.equals(intent.getAction())) {
                Uri conditionId = (Uri)intent.getParcelableExtra(CountdownConditionProvider.EXTRA_CONDITION_ID);
                long time = ZenModeConfig.tryParseCountdownConditionId(conditionId);
                if (DEBUG) {
                    Slog.d(CountdownConditionProvider.TAG, "Countdown condition fired: " + conditionId);
                }
                if (time > 0L) {
                    CountdownConditionProvider.this.notifyCondition(CountdownConditionProvider.newCondition(time, 0));
                }
            }
        }
    }
}

