/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.Context;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.UserHandle;
import android.provider.ContactsContract;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LruCache;
import android.util.Slog;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingReconsideration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ValidateNotificationPeople
implements NotificationSignalExtractor {
    private static final String TAG = "ValidateNoPeople";
    private static final boolean INFO = true;
    private static final boolean DEBUG = Log.isLoggable("ValidateNoPeople", 3);
    private static final boolean ENABLE_PEOPLE_VALIDATOR = true;
    private static final String SETTING_ENABLE_PEOPLE_VALIDATOR = "validate_notification_people_enabled";
    private static final String[] LOOKUP_PROJECTION = new String[]{"_id", "starred"};
    private static final int MAX_PEOPLE = 10;
    private static final int PEOPLE_CACHE_SIZE = 200;
    static final float NONE = 0.0f;
    static final float VALID_CONTACT = 0.5f;
    static final float STARRED_CONTACT = 1.0f;
    protected boolean mEnabled;
    private Context mBaseContext;
    private LruCache<String, LookupResult> mPeopleCache;
    private Map<Integer, Context> mUserToContextMap;
    private Handler mHandler;
    private ContentObserver mObserver;
    private int mEvictionCount;

    @Override
    public void initialize(Context context) {
        if (DEBUG) {
            Slog.d(TAG, "Initializing  " + this.getClass().getSimpleName() + ".");
        }
        this.mUserToContextMap = new ArrayMap<Integer, Context>();
        this.mBaseContext = context;
        this.mPeopleCache = new LruCache(200);
        boolean bl = this.mEnabled = 1 == Settings.Global.getInt(this.mBaseContext.getContentResolver(), SETTING_ENABLE_PEOPLE_VALIDATOR, 1);
        if (this.mEnabled) {
            this.mHandler = new Handler();
            this.mObserver = new ContentObserver(this.mHandler){

                @Override
                public void onChange(boolean selfChange, Uri uri, int userId) {
                    super.onChange(selfChange, uri, userId);
                    if (DEBUG || ValidateNotificationPeople.this.mEvictionCount % 100 == 0) {
                        Slog.i(ValidateNotificationPeople.TAG, "mEvictionCount: " + ValidateNotificationPeople.this.mEvictionCount);
                    }
                    ValidateNotificationPeople.this.mPeopleCache.evictAll();
                    ValidateNotificationPeople.this.mEvictionCount++;
                }
            };
            this.mBaseContext.getContentResolver().registerContentObserver(ContactsContract.Contacts.CONTENT_URI, true, this.mObserver, -1);
        }
    }

    @Override
    public RankingReconsideration process(NotificationRecord record) {
        if (!this.mEnabled) {
            Slog.i(TAG, "disabled");
            return null;
        }
        if (record == null || record.getNotification() == null) {
            Slog.i(TAG, "skipping empty notification");
            return null;
        }
        if (record.getUserId() == -1) {
            Slog.i(TAG, "skipping global notification");
            return null;
        }
        Context context = this.getContextAsUser(record.getUser());
        if (context == null) {
            Slog.i(TAG, "skipping notification that lacks a context");
            return null;
        }
        return this.validatePeople(context, record);
    }

    @Override
    public void setConfig(RankingConfig config) {
    }

    public float getContactAffinity(UserHandle userHandle, Bundle extras, int timeoutMs, float timeoutAffinity) {
        if (DEBUG) {
            Slog.d(TAG, "checking affinity for " + userHandle);
        }
        if (extras == null) {
            return 0.0f;
        }
        String key = Long.toString(System.nanoTime());
        float[] affinityOut = new float[1];
        Context context = this.getContextAsUser(userHandle);
        if (context == null) {
            return 0.0f;
        }
        final PeopleRankingReconsideration prr = this.validatePeople(context, key, extras, affinityOut);
        float affinity = affinityOut[0];
        if (prr != null) {
            final Semaphore s = new Semaphore(0);
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    prr.work();
                    s.release();
                }
            });
            try {
                if (!s.tryAcquire(timeoutMs, TimeUnit.MILLISECONDS)) {
                    Slog.w(TAG, "Timeout while waiting for affinity: " + key + ". " + "Returning timeoutAffinity=" + timeoutAffinity);
                    return timeoutAffinity;
                }
            }
            catch (InterruptedException e) {
                Slog.w(TAG, "InterruptedException while waiting for affinity: " + key + ". " + "Returning affinity=" + affinity, e);
                return affinity;
            }
            affinity = Math.max(prr.getContactAffinity(), affinity);
        }
        return affinity;
    }

    private Context getContextAsUser(UserHandle userHandle) {
        Context context = this.mUserToContextMap.get(userHandle.getIdentifier());
        if (context == null) {
            try {
                context = this.mBaseContext.createPackageContextAsUser("android", 0, userHandle);
                this.mUserToContextMap.put(userHandle.getIdentifier(), context);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(TAG, "failed to create package context for lookups", e);
            }
        }
        return context;
    }

    private RankingReconsideration validatePeople(Context context, NotificationRecord record) {
        String key = record.getKey();
        Bundle extras = record.getNotification().extras;
        float[] affinityOut = new float[1];
        PeopleRankingReconsideration rr = this.validatePeople(context, key, extras, affinityOut);
        record.setContactAffinity(affinityOut[0]);
        return rr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeopleRankingReconsideration validatePeople(Context context, String key, Bundle extras, float[] affinityOut) {
        float affinity = 0.0f;
        if (extras == null) {
            return null;
        }
        String[] people = ValidateNotificationPeople.getExtraPeople(extras);
        if (people == null || people.length == 0) {
            return null;
        }
        Slog.i(TAG, "Validating: " + key);
        LinkedList<String> pendingLookups = new LinkedList<String>();
        for (int personIdx = 0; personIdx < people.length && personIdx < 10; ++personIdx) {
            String handle = people[personIdx];
            if (TextUtils.isEmpty(handle)) continue;
            LruCache<String, LookupResult> lruCache = this.mPeopleCache;
            synchronized (lruCache) {
                String cacheKey = this.getCacheKey(context.getUserId(), handle);
                LookupResult lookupResult = this.mPeopleCache.get(cacheKey);
                if (lookupResult == null || lookupResult.isExpired()) {
                    pendingLookups.add(handle);
                } else if (DEBUG) {
                    Slog.d(TAG, "using cached lookupResult");
                }
                if (lookupResult != null) {
                    affinity = Math.max(affinity, lookupResult.getAffinity());
                }
                continue;
            }
        }
        affinityOut[0] = affinity;
        if (pendingLookups.isEmpty()) {
            Slog.i(TAG, "final affinity: " + affinity);
            return null;
        }
        if (DEBUG) {
            Slog.d(TAG, "Pending: future work scheduled for: " + key);
        }
        return new PeopleRankingReconsideration(context, key, pendingLookups);
    }

    private String getCacheKey(int userId, String handle) {
        return Integer.toString(userId) + ":" + handle;
    }

    public static String[] getExtraPeople(Bundle extras) {
        Object people = extras.get("android.people");
        if (people instanceof String[]) {
            return (String[])people;
        }
        if (people instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)people;
            if (arrayList.isEmpty()) {
                return null;
            }
            if (arrayList.get(0) instanceof String) {
                ArrayList stringArray = arrayList;
                return stringArray.toArray(new String[stringArray.size()]);
            }
            if (arrayList.get(0) instanceof CharSequence) {
                ArrayList charSeqList = arrayList;
                int N = charSeqList.size();
                String[] array2 = new String[N];
                for (int i = 0; i < N; ++i) {
                    array2[i] = ((CharSequence)charSeqList.get(i)).toString();
                }
                return array2;
            }
            return null;
        }
        if (people instanceof String) {
            String[] array3 = new String[]{(String)people};
            return array3;
        }
        if (people instanceof char[]) {
            String[] array4 = new String[]{new String((char[])people)};
            return array4;
        }
        if (people instanceof CharSequence) {
            String[] array5 = new String[]{((CharSequence)people).toString()};
            return array5;
        }
        if (people instanceof CharSequence[]) {
            CharSequence[] charSeqArray = (CharSequence[])people;
            int N = charSeqArray.length;
            String[] array6 = new String[N];
            for (int i = 0; i < N; ++i) {
                array6[i] = charSeqArray[i].toString();
            }
            return array6;
        }
        return null;
    }

    private LookupResult resolvePhoneContact(Context context, String number) {
        Uri phoneUri = Uri.withAppendedPath(ContactsContract.PhoneLookup.CONTENT_FILTER_URI, Uri.encode(number));
        return this.searchContacts(context, phoneUri);
    }

    private LookupResult resolveEmailContact(Context context, String email) {
        Uri numberUri = Uri.withAppendedPath(ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, Uri.encode(email));
        return this.searchContacts(context, numberUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LookupResult searchContacts(Context context, Uri lookupUri) {
        LookupResult lookupResult = new LookupResult();
        try (Cursor c = null;){
            c = context.getContentResolver().query(lookupUri, LOOKUP_PROJECTION, null, null, null);
            if (c == null) {
                Slog.w(TAG, "Null cursor from contacts query.");
                LookupResult lookupResult2 = lookupResult;
                return lookupResult2;
            }
            while (c.moveToNext()) {
                lookupResult.mergeContact(c);
            }
        }
        return lookupResult;
    }

    private class PeopleRankingReconsideration
    extends RankingReconsideration {
        private final LinkedList<String> mPendingLookups;
        private final Context mContext;
        private float mContactAffinity;

        private PeopleRankingReconsideration(Context context, String key, LinkedList<String> pendingLookups) {
            super(key);
            this.mContactAffinity = 0.0f;
            this.mContext = context;
            this.mPendingLookups = pendingLookups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void work() {
            Slog.i(ValidateNotificationPeople.TAG, "Executing: validation for: " + this.mKey);
            long timeStartMs = System.currentTimeMillis();
            for (String handle : this.mPendingLookups) {
                LookupResult lookupResult = null;
                Uri uri = Uri.parse(handle);
                if ("tel".equals(uri.getScheme())) {
                    if (DEBUG) {
                        Slog.d(ValidateNotificationPeople.TAG, "checking telephone URI: " + handle);
                    }
                    lookupResult = ValidateNotificationPeople.this.resolvePhoneContact(this.mContext, uri.getSchemeSpecificPart());
                } else if ("mailto".equals(uri.getScheme())) {
                    if (DEBUG) {
                        Slog.d(ValidateNotificationPeople.TAG, "checking mailto URI: " + handle);
                    }
                    lookupResult = ValidateNotificationPeople.this.resolveEmailContact(this.mContext, uri.getSchemeSpecificPart());
                } else if (handle.startsWith(ContactsContract.Contacts.CONTENT_LOOKUP_URI.toString())) {
                    if (DEBUG) {
                        Slog.d(ValidateNotificationPeople.TAG, "checking lookup URI: " + handle);
                    }
                    lookupResult = ValidateNotificationPeople.this.searchContacts(this.mContext, uri);
                } else {
                    lookupResult = new LookupResult();
                    Slog.w(ValidateNotificationPeople.TAG, "unsupported URI " + handle);
                }
                if (lookupResult == null) continue;
                LruCache lruCache = ValidateNotificationPeople.this.mPeopleCache;
                synchronized (lruCache) {
                    String cacheKey = ValidateNotificationPeople.this.getCacheKey(this.mContext.getUserId(), handle);
                    ValidateNotificationPeople.this.mPeopleCache.put(cacheKey, lookupResult);
                }
                this.mContactAffinity = Math.max(this.mContactAffinity, lookupResult.getAffinity());
            }
            if (DEBUG) {
                Slog.d(ValidateNotificationPeople.TAG, "Validation finished in " + (System.currentTimeMillis() - timeStartMs) + "ms");
            }
        }

        @Override
        public void applyChangesLocked(NotificationRecord operand) {
            float affinityBound = operand.getContactAffinity();
            operand.setContactAffinity(Math.max(this.mContactAffinity, affinityBound));
            Slog.i(ValidateNotificationPeople.TAG, "final affinity: " + operand.getContactAffinity());
        }

        public float getContactAffinity() {
            return this.mContactAffinity;
        }
    }

    private static class LookupResult {
        private static final long CONTACT_REFRESH_MILLIS = 3600000L;
        private final long mExpireMillis = System.currentTimeMillis() + 3600000L;
        private float mAffinity = 0.0f;

        public void mergeContact(Cursor cursor) {
            int starIdx;
            this.mAffinity = Math.max(this.mAffinity, 0.5f);
            int idIdx = cursor.getColumnIndex("_id");
            if (idIdx >= 0) {
                int id2 = cursor.getInt(idIdx);
                if (DEBUG) {
                    Slog.d(ValidateNotificationPeople.TAG, "contact _ID is: " + id2);
                }
            } else {
                int id3 = -1;
                Slog.i(ValidateNotificationPeople.TAG, "invalid cursor: no _ID");
            }
            if ((starIdx = cursor.getColumnIndex("starred")) >= 0) {
                boolean isStarred;
                boolean bl = isStarred = cursor.getInt(starIdx) != 0;
                if (isStarred) {
                    this.mAffinity = Math.max(this.mAffinity, 1.0f);
                }
                if (DEBUG) {
                    Slog.d(ValidateNotificationPeople.TAG, "contact STARRED is: " + isStarred);
                }
            } else if (DEBUG) {
                Slog.d(ValidateNotificationPeople.TAG, "invalid cursor: no STARRED");
            }
        }

        private boolean isExpired() {
            return this.mExpireMillis < System.currentTimeMillis();
        }

        private boolean isInvalid() {
            return this.mAffinity == 0.0f || this.isExpired();
        }

        public float getAffinity() {
            if (this.isInvalid()) {
                return 0.0f;
            }
            return this.mAffinity;
        }
    }
}

