/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.IntentFilter;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.PackageManagerService;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class CrossProfileIntentFilter
extends IntentFilter {
    private static final String ATTR_TARGET_USER_ID = "targetUserId";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_OWNER_USER_ID = "ownerUserId";
    private static final String ATTR_OWNER_PACKAGE = "ownerPackage";
    private static final String ATTR_FILTER = "filter";
    private static final String TAG = "CrossProfileIntentFilter";
    final int mTargetUserId;
    final int mOwnerUserId;
    final String mOwnerPackage;
    final int mFlags;

    CrossProfileIntentFilter(IntentFilter filter, String ownerPackage, int ownerUserId, int targetUserId, int flags) {
        super(filter);
        this.mTargetUserId = targetUserId;
        this.mOwnerUserId = ownerUserId;
        this.mOwnerPackage = ownerPackage;
        this.mFlags = flags;
    }

    public int getTargetUserId() {
        return this.mTargetUserId;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public int getOwnerUserId() {
        return this.mOwnerUserId;
    }

    public String getOwnerPackage() {
        return this.mOwnerPackage;
    }

    CrossProfileIntentFilter(XmlPullParser parser) throws XmlPullParserException, IOException {
        String msg;
        int type;
        this.mTargetUserId = this.getIntFromXml(parser, ATTR_TARGET_USER_ID, -10000);
        this.mOwnerUserId = this.getIntFromXml(parser, ATTR_OWNER_USER_ID, -10000);
        this.mOwnerPackage = this.getStringFromXml(parser, ATTR_OWNER_PACKAGE, "");
        this.mFlags = this.getIntFromXml(parser, ATTR_FLAGS, 0);
        int outerDepth = parser.getDepth();
        String tagName = parser.getName();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            tagName = parser.getName();
            if (type == 3 || type == 4 || type != 2) continue;
            if (tagName.equals(ATTR_FILTER)) break;
            msg = "Unknown element under crossProfile-intent-filters: " + tagName + " at " + parser.getPositionDescription();
            PackageManagerService.reportSettingsProblem(5, msg);
            XmlUtils.skipCurrentTag(parser);
        }
        if (tagName.equals(ATTR_FILTER)) {
            this.readFromXml(parser);
        } else {
            msg = "Missing element under CrossProfileIntentFilter: filter at " + parser.getPositionDescription();
            PackageManagerService.reportSettingsProblem(5, msg);
            XmlUtils.skipCurrentTag(parser);
        }
    }

    String getStringFromXml(XmlPullParser parser, String attribute, String defaultValue) {
        String value = parser.getAttributeValue(null, attribute);
        if (value == null) {
            String msg = "Missing element under CrossProfileIntentFilter: " + attribute + " at " + parser.getPositionDescription();
            PackageManagerService.reportSettingsProblem(5, msg);
            return defaultValue;
        }
        return value;
    }

    int getIntFromXml(XmlPullParser parser, String attribute, int defaultValue) {
        String stringValue = this.getStringFromXml(parser, attribute, null);
        if (stringValue != null) {
            return Integer.parseInt(stringValue);
        }
        return defaultValue;
    }

    @Override
    public void writeToXml(XmlSerializer serializer) throws IOException {
        serializer.attribute(null, ATTR_TARGET_USER_ID, Integer.toString(this.mTargetUserId));
        serializer.attribute(null, ATTR_FLAGS, Integer.toString(this.mFlags));
        serializer.attribute(null, ATTR_OWNER_USER_ID, Integer.toString(this.mOwnerUserId));
        serializer.attribute(null, ATTR_OWNER_PACKAGE, this.mOwnerPackage);
        serializer.startTag(null, ATTR_FILTER);
        super.writeToXml(serializer);
        serializer.endTag(null, ATTR_FILTER);
    }

    public String toString() {
        return "CrossProfileIntentFilter{0x" + Integer.toHexString(System.identityHashCode(this)) + " " + Integer.toString(this.mTargetUserId) + "}";
    }
}

