/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.admin.IDevicePolicyManager;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageDeleteObserver2;
import android.content.pm.IPackageInstallObserver2;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.KeySet;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageCleanItem;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInfoLite;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PackageUserState;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.content.pm.VerificationParams;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VerifierInfo;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.BaseBundle;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.security.SystemKeyStore;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.LogPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.os.IParcelFileDescriptorFactory;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.EventLogTags;
import com.android.server.IntentResolver;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.Watchdog;
import com.android.server.pm.BasePermission;
import com.android.server.pm.CrossProfileIntentFilter;
import com.android.server.pm.CrossProfileIntentResolver;
import com.android.server.pm.GrantedPermissions;
import com.android.server.pm.Installer;
import com.android.server.pm.KeySetHandle;
import com.android.server.pm.KeySetManagerService;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.PackageVerificationResponse;
import com.android.server.pm.PackageVerificationState;
import com.android.server.pm.PersistentPreferredActivity;
import com.android.server.pm.PersistentPreferredIntentResolver;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.PreferredIntentResolver;
import com.android.server.pm.SELinuxMMAC;
import com.android.server.pm.Settings;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserManagerService;
import com.android.server.storage.DeviceStorageMonitorInternal;
import dalvik.system.DexFile;
import dalvik.system.StaleDexCacheError;
import dalvik.system.VMRuntime;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;

public class PackageManagerService
extends IPackageManager.Stub {
    static final String TAG = "PackageManager";
    static final boolean DEBUG_SETTINGS = false;
    static final boolean DEBUG_PREFERRED = false;
    static final boolean DEBUG_UPGRADE = false;
    private static final boolean DEBUG_INSTALL = false;
    private static final boolean DEBUG_REMOVE = false;
    private static final boolean DEBUG_BROADCASTS = false;
    private static final boolean DEBUG_SHOW_INFO = false;
    private static final boolean DEBUG_PACKAGE_INFO = false;
    private static final boolean DEBUG_INTENT_MATCHING = false;
    private static final boolean DEBUG_PACKAGE_SCANNING = false;
    private static final boolean DEBUG_VERIFY = false;
    private static final boolean DEBUG_DEXOPT = false;
    private static final boolean DEBUG_ABI_SELECTION = false;
    private static final int RADIO_UID = 1001;
    private static final int LOG_UID = 1007;
    private static final int NFC_UID = 1027;
    private static final int BLUETOOTH_UID = 1002;
    private static final int SHELL_UID = 2000;
    private static final int MAX_PERMISSION_TREE_FOOTPRINT = 32768;
    private static final String INSTALL_PACKAGE_SUFFIX = "-";
    static final int SCAN_NO_DEX = 2;
    static final int SCAN_FORCE_DEX = 4;
    static final int SCAN_UPDATE_SIGNATURE = 8;
    static final int SCAN_NEW_INSTALL = 16;
    static final int SCAN_NO_PATHS = 32;
    static final int SCAN_UPDATE_TIME = 64;
    static final int SCAN_DEFER_DEX = 128;
    static final int SCAN_BOOTING = 256;
    static final int SCAN_TRUSTED_OVERLAY = 512;
    static final int SCAN_DELETE_DATA_ON_FAILURES = 1024;
    static final int SCAN_REPLACING = 2048;
    static final int REMOVE_CHATTY = 65536;
    private static final long WATCHDOG_TIMEOUT = 600000L;
    private static final long DEFAULT_MANDATORY_FSTRIM_INTERVAL = 259200000L;
    private static final boolean DEFAULT_VERIFY_ENABLE = true;
    private static final long DEFAULT_VERIFICATION_TIMEOUT = 10000L;
    private static final int DEFAULT_VERIFICATION_RESPONSE = 1;
    static final String DEFAULT_CONTAINER_PACKAGE = "com.android.defcontainer";
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String VENDOR_OVERLAY_DIR = "/vendor/overlay";
    private static String sPreferredInstructionSet;
    final ServiceThread mHandlerThread;
    private static final String IDMAP_PREFIX = "/data/resource-cache/";
    private static final String IDMAP_SUFFIX = "@idmap";
    final PackageHandler mHandler;
    private ArrayList<Message> mPostSystemReadyMessages;
    final int mSdkVersion = Build.VERSION.SDK_INT;
    final Context mContext;
    final boolean mFactoryTest;
    final boolean mOnlyCore;
    final boolean mLazyDexOpt;
    final DisplayMetrics mMetrics;
    final int mDefParseFlags;
    final String[] mSeparateProcesses;
    final File mAppDataDir;
    final File mUserAppDataDir;
    final String mAsecInternalPath;
    final Installer mInstaller;
    final File mAppInstallDir;
    private File mAppLib32InstallDir;
    final File mDrmAppPrivateInstallDir;
    final Object mInstallLock = new Object();
    final HashMap<String, PackageParser.Package> mPackages = new HashMap();
    final HashMap<String, HashMap<String, PackageParser.Package>> mOverlays = new HashMap();
    final Settings mSettings;
    boolean mRestoredSettings;
    final int[] mGlobalGids;
    final SparseArray<HashSet<String>> mSystemPermissions;
    final HashMap<String, FeatureInfo> mAvailableFeatures;
    boolean mFoundPolicyFile;
    private boolean mShouldRestoreconData = SELinuxMMAC.shouldRestorecon();
    final HashMap<String, SharedLibraryEntry> mSharedLibraries = new HashMap();
    final ActivityIntentResolver mActivities = new ActivityIntentResolver();
    final ActivityIntentResolver mReceivers = new ActivityIntentResolver();
    final ServiceIntentResolver mServices = new ServiceIntentResolver();
    final ProviderIntentResolver mProviders = new ProviderIntentResolver();
    final HashMap<String, PackageParser.Provider> mProvidersByAuthority = new HashMap();
    final HashMap<ComponentName, PackageParser.Instrumentation> mInstrumentation = new HashMap();
    final HashMap<String, PackageParser.PermissionGroup> mPermissionGroups = new HashMap();
    final HashSet<String> mTransferedPackages = new HashSet();
    final HashSet<String> mProtectedBroadcasts = new HashSet();
    final SparseArray<PackageVerificationState> mPendingVerification = new SparseArray();
    final ArrayMap<String, ArraySet<String>> mAppOpPermissionPackages = new ArrayMap();
    final PackageInstallerService mInstallerService;
    HashSet<PackageParser.Package> mDeferredDexOpt = null;
    SparseBooleanArray mUserNeedsBadging = new SparseBooleanArray();
    private int mPendingVerificationToken = 0;
    volatile boolean mSystemReady;
    volatile boolean mSafeMode;
    volatile boolean mHasSystemUidErrors;
    ApplicationInfo mAndroidApplication;
    final ActivityInfo mResolveActivity = new ActivityInfo();
    final ResolveInfo mResolveInfo = new ResolveInfo();
    ComponentName mResolveComponentName;
    PackageParser.Package mPlatformPackage;
    ComponentName mCustomResolverComponentName;
    boolean mResolverReplaced = false;
    final PendingPackageBroadcasts mPendingBroadcasts = new PendingPackageBroadcasts();
    private IMediaContainerService mContainerService = null;
    static final int SEND_PENDING_BROADCAST = 1;
    static final int MCS_BOUND = 3;
    static final int END_COPY = 4;
    static final int INIT_COPY = 5;
    static final int MCS_UNBIND = 6;
    static final int START_CLEANING_PACKAGE = 7;
    static final int FIND_INSTALL_LOC = 8;
    static final int POST_INSTALL = 9;
    static final int MCS_RECONNECT = 10;
    static final int MCS_GIVE_UP = 11;
    static final int UPDATED_MEDIA_STATUS = 12;
    static final int WRITE_SETTINGS = 13;
    static final int WRITE_PACKAGE_RESTRICTIONS = 14;
    static final int PACKAGE_VERIFIED = 15;
    static final int CHECK_PENDING_VERIFICATION = 16;
    static final int WRITE_SETTINGS_DELAY = 10000;
    static final int BROADCAST_DELAY = 10000;
    static UserManagerService sUserManager;
    private HashSet<Integer> mDirtyUsers = new HashSet();
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    final SparseArray<PostInstallData> mRunningInstalls = new SparseArray();
    int mNextInstallToken = 1;
    private final String mRequiredVerifierPackage;
    private final PackageUsage mPackageUsage = new PackageUsage();
    static final int DEX_OPT_SKIPPED = 0;
    static final int DEX_OPT_PERFORMED = 1;
    static final int DEX_OPT_DEFERRED = 2;
    static final int DEX_OPT_FAILED = -1;
    static final int UPDATE_PERMISSIONS_ALL = 1;
    static final int UPDATE_PERMISSIONS_REPLACE_PKG = 2;
    static final int UPDATE_PERMISSIONS_REPLACE_ALL = 4;
    private static final Comparator<ResolveInfo> mResolvePrioritySorter;
    private static final Comparator<ProviderInfo> mProviderInitOrderSorter;
    static final boolean DEBUG_SD_INSTALL = false;
    private static final String SD_ENCRYPTION_KEYSTORE_NAME = "AppsOnSD";
    private static final String SD_ENCRYPTION_ALGORITHM = "AES";
    private boolean mMediaMounted = false;

    Bundle extrasForInstallResult(PackageInstalledInfo res) {
        Bundle extras = null;
        switch (res.returnCode) {
            case -112: {
                extras = new Bundle();
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PERMISSION", res.origPermission);
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PACKAGE", res.origPackage);
            }
        }
        return extras;
    }

    void scheduleWriteSettingsLocked() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessageDelayed(13, 10000L);
        }
    }

    void scheduleWritePackageRestrictionsLocked(int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.mDirtyUsers.add(userId);
        if (!this.mHandler.hasMessages(14)) {
            this.mHandler.sendEmptyMessageDelayed(14, 10000L);
        }
    }

    public static final PackageManagerService main(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        PackageManagerService m = new PackageManagerService(context, installer, factoryTest, onlyCore);
        ServiceManager.addService("package", m);
        return m;
    }

    static String[] splitString(String str, char sep) {
        int count = 1;
        int i = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            ++count;
            ++i;
        }
        String[] res = new String[count];
        i = 0;
        count = 0;
        int lastI = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            res[count] = str.substring(lastI, i);
            ++count;
            lastI = ++i;
        }
        res[count] = str.substring(lastI, str.length());
        return res;
    }

    private static void getDefaultDisplayMetrics(Context context, DisplayMetrics metrics) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        displayManager.getDisplay(0).getMetrics(metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageManagerService(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        EventLog.writeEvent(3060, SystemClock.uptimeMillis());
        if (this.mSdkVersion <= 0) {
            Slog.w(TAG, "**** ro.build.version.sdk not set!");
        }
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        this.mOnlyCore = onlyCore;
        this.mLazyDexOpt = "eng".equals(SystemProperties.get("ro.build.type"));
        this.mMetrics = new DisplayMetrics();
        this.mSettings = new Settings(context);
        this.mSettings.addSharedUserLPw("android.uid.system", 1000, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.phone", 1001, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.log", 1007, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.nfc", 1027, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.bluetooth", 1002, 0x40000001);
        this.mSettings.addSharedUserLPw("android.uid.shell", 2000, 0x40000001);
        String separateProcesses = SystemProperties.get("debug.separate_processes");
        if (separateProcesses != null && separateProcesses.length() > 0) {
            if ("*".equals(separateProcesses)) {
                this.mDefParseFlags = 8;
                this.mSeparateProcesses = null;
                Slog.w(TAG, "Running with debug.separate_processes: * (ALL)");
            } else {
                this.mDefParseFlags = 0;
                this.mSeparateProcesses = separateProcesses.split(",");
                Slog.w(TAG, "Running with debug.separate_processes: " + separateProcesses);
            }
        } else {
            this.mDefParseFlags = 0;
            this.mSeparateProcesses = null;
        }
        this.mInstaller = installer;
        PackageManagerService.getDefaultDisplayMetrics(context, this.mMetrics);
        SystemConfig systemConfig = SystemConfig.getInstance();
        this.mGlobalGids = systemConfig.getGlobalGids();
        this.mSystemPermissions = systemConfig.getSystemPermissions();
        this.mAvailableFeatures = systemConfig.getAvailableFeatures();
        Object object = this.mInstallLock;
        synchronized (object) {
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                boolean regrantPermissions;
                int i;
                this.mHandlerThread = new ServiceThread(TAG, 10, true);
                this.mHandlerThread.start();
                this.mHandler = new PackageHandler(this.mHandlerThread.getLooper());
                Watchdog.getInstance().addThread(this.mHandler, 600000L);
                File dataDir = Environment.getDataDirectory();
                this.mAppDataDir = new File(dataDir, "data");
                this.mAppInstallDir = new File(dataDir, "app");
                this.mAppLib32InstallDir = new File(dataDir, "app-lib");
                this.mAsecInternalPath = new File(dataDir, "app-asec").getPath();
                this.mUserAppDataDir = new File(dataDir, "user");
                this.mDrmAppPrivateInstallDir = new File(dataDir, "app-private");
                sUserManager = new UserManagerService(context, this, this.mInstallLock, this.mPackages);
                ArrayMap<String, SystemConfig.PermissionEntry> permConfig = systemConfig.getPermissions();
                for (int i2 = 0; i2 < permConfig.size(); ++i2) {
                    SystemConfig.PermissionEntry perm = permConfig.valueAt(i2);
                    BasePermission bp = this.mSettings.mPermissions.get(perm.name);
                    if (bp == null) {
                        bp = new BasePermission(perm.name, "android", 1);
                        this.mSettings.mPermissions.put(perm.name, bp);
                    }
                    if (perm.gids == null) continue;
                    bp.gids = PackageManagerService.appendInts(bp.gids, perm.gids);
                }
                ArrayMap<String, String> libConfig = systemConfig.getSharedLibraries();
                for (int i3 = 0; i3 < libConfig.size(); ++i3) {
                    this.mSharedLibraries.put(libConfig.keyAt(i3), new SharedLibraryEntry(libConfig.valueAt(i3), null));
                }
                this.mFoundPolicyFile = SELinuxMMAC.readInstallPolicy();
                this.mRestoredSettings = this.mSettings.readLPw(this, sUserManager.getUsers(false), this.mSdkVersion, this.mOnlyCore);
                String customResolverActivity = Resources.getSystem().getString(0x1040040);
                if (TextUtils.isEmpty(customResolverActivity)) {
                    customResolverActivity = null;
                } else {
                    this.mCustomResolverComponentName = ComponentName.unflattenFromString(customResolverActivity);
                }
                long startTime = SystemClock.uptimeMillis();
                EventLog.writeEvent(3070, startTime);
                int scanFlags = 416;
                HashSet<String> alreadyDexOpted = new HashSet<String>();
                String bootClassPath = System.getenv("BOOTCLASSPATH");
                String systemServerClassPath = System.getenv("SYSTEMSERVERCLASSPATH");
                if (bootClassPath != null) {
                    String[] bootClassPathElements;
                    for (String element : bootClassPathElements = PackageManagerService.splitString(bootClassPath, ':')) {
                        alreadyDexOpted.add(element);
                    }
                } else {
                    Slog.w(TAG, "No BOOTCLASSPATH found!");
                }
                if (systemServerClassPath != null) {
                    String[] systemServerClassPathElements;
                    for (String element : systemServerClassPathElements = PackageManagerService.splitString(systemServerClassPath, ':')) {
                        alreadyDexOpted.add(element);
                    }
                } else {
                    Slog.w(TAG, "No SYSTEMSERVERCLASSPATH found!");
                }
                boolean didDexOptLibraryOrTool = false;
                List<String> allInstructionSets = PackageManagerService.getAllInstructionSets();
                String[] dexCodeInstructionSets = PackageManagerService.getDexCodeInstructionSets(allInstructionSets.toArray(new String[allInstructionSets.size()]));
                if (this.mSharedLibraries.size() > 0) {
                    for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                        for (SharedLibraryEntry libEntry : this.mSharedLibraries.values()) {
                            String lib = libEntry.path;
                            if (lib == null) continue;
                            try {
                                byte dexoptRequired = DexFile.isDexOptNeededInternal(lib, null, dexCodeInstructionSet, false);
                                if (dexoptRequired == 0) continue;
                                alreadyDexOpted.add(lib);
                                if (dexoptRequired == 2) {
                                    this.mInstaller.dexopt(lib, 1000, true, dexCodeInstructionSet);
                                } else {
                                    this.mInstaller.patchoat(lib, 1000, true, dexCodeInstructionSet);
                                }
                                didDexOptLibraryOrTool = true;
                            }
                            catch (FileNotFoundException e) {
                                Slog.w(TAG, "Library not found: " + lib);
                            }
                            catch (IOException e) {
                                Slog.w(TAG, "Cannot dexopt " + lib + "; is it an APK or JAR? " + e.getMessage());
                            }
                        }
                    }
                }
                File frameworkDir = new File(Environment.getRootDirectory(), "framework");
                alreadyDexOpted.add(frameworkDir.getPath() + "/framework-res.apk");
                alreadyDexOpted.add(frameworkDir.getPath() + "/core-libart.jar");
                String[] frameworkFiles = frameworkDir.list();
                if (frameworkFiles != null) {
                    for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                        for (int i4 = 0; i4 < frameworkFiles.length; ++i4) {
                            File libPath = new File(frameworkDir, frameworkFiles[i4]);
                            String path = libPath.getPath();
                            if (alreadyDexOpted.contains(path) || !path.endsWith(".apk") && !path.endsWith(".jar")) continue;
                            try {
                                byte dexoptRequired = DexFile.isDexOptNeededInternal(path, null, dexCodeInstructionSet, false);
                                if (dexoptRequired == 2) {
                                    this.mInstaller.dexopt(path, 1000, true, dexCodeInstructionSet);
                                    didDexOptLibraryOrTool = true;
                                    continue;
                                }
                                if (dexoptRequired != 1) continue;
                                this.mInstaller.patchoat(path, 1000, true, dexCodeInstructionSet);
                                didDexOptLibraryOrTool = true;
                                continue;
                            }
                            catch (FileNotFoundException e) {
                                Slog.w(TAG, "Jar not found: " + path);
                                continue;
                            }
                            catch (IOException e) {
                                Slog.w(TAG, "Exception reading jar: " + path, e);
                            }
                        }
                    }
                }
                File vendorOverlayDir = new File(VENDOR_OVERLAY_DIR);
                this.scanDirLI(vendorOverlayDir, 65, 928, 0L);
                this.scanDirLI(frameworkDir, 193, 418, 0L);
                File privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app");
                this.scanDirLI(privilegedAppDir, 193, 416, 0L);
                File systemAppDir = new File(Environment.getRootDirectory(), "app");
                this.scanDirLI(systemAppDir, 65, 416, 0L);
                File vendorAppDir = new File("/vendor/app");
                try {
                    vendorAppDir = vendorAppDir.getCanonicalFile();
                }
                catch (IOException i4) {
                    // empty catch block
                }
                this.scanDirLI(vendorAppDir, 65, 416, 0L);
                File oemAppDir = new File(Environment.getOemDirectory(), "app");
                this.scanDirLI(oemAppDir, 65, 416, 0L);
                this.mInstaller.moveFiles();
                ArrayList<String> possiblyDeletedUpdatedSystemApps = new ArrayList<String>();
                ArrayMap<String, File> expectingBetter = new ArrayMap<String, File>();
                if (!this.mOnlyCore) {
                    Iterator<PackageSetting> psit = this.mSettings.mPackages.values().iterator();
                    while (psit.hasNext()) {
                        PackageSetting ps = psit.next();
                        if ((ps.pkgFlags & 1) == 0) continue;
                        PackageParser.Package scannedPkg = this.mPackages.get(ps.name);
                        if (scannedPkg != null) {
                            if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) continue;
                            PackageManagerService.logCriticalInfo(5, "Expecting better updated system app for " + ps.name + "; removing system app.  Last known codePath=" + ps.codePathString + ", installStatus=" + ps.installStatus + ", versionCode=" + ps.versionCode + "; scanned versionCode=" + scannedPkg.mVersionCode);
                            this.removePackageLI(ps, true);
                            expectingBetter.put(ps.name, ps.codePath);
                            continue;
                        }
                        if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) {
                            psit.remove();
                            PackageManagerService.logCriticalInfo(5, "System package " + ps.name + " no longer exists; wiping its data");
                            this.removeDataDirsLI(ps.name);
                            continue;
                        }
                        PackageSetting disabledPs = this.mSettings.getDisabledSystemPkgLPr(ps.name);
                        if (disabledPs.codePath != null && disabledPs.codePath.exists()) continue;
                        possiblyDeletedUpdatedSystemApps.add(ps.name);
                    }
                }
                ArrayList<PackageSetting> deletePkgsList = this.mSettings.getListOfIncompleteInstallPackagesLPr();
                for (i = 0; i < deletePkgsList.size(); ++i) {
                    this.cleanupInstallFailedPackage(deletePkgsList.get(i));
                }
                this.deleteTempPackageFiles();
                this.mSettings.pruneSharedUsersLPw();
                if (!this.mOnlyCore) {
                    EventLog.writeEvent(3080, SystemClock.uptimeMillis());
                    this.scanDirLI(this.mAppInstallDir, 0, 416, 0L);
                    this.scanDirLI(this.mDrmAppPrivateInstallDir, 16, 416, 0L);
                    for (String deletedAppName : possiblyDeletedUpdatedSystemApps) {
                        String msg;
                        PackageParser.Package deletedPkg = this.mPackages.get(deletedAppName);
                        this.mSettings.removeDisabledSystemPackageLPw(deletedAppName);
                        if (deletedPkg == null) {
                            msg = "Updated system package " + deletedAppName + " no longer exists; wiping its data";
                            this.removeDataDirsLI(deletedAppName);
                        } else {
                            msg = "Updated system app + " + deletedAppName + " no longer present; removing system privileges for " + deletedAppName;
                            deletedPkg.applicationInfo.flags &= 0xFFFFFFFE;
                            PackageSetting deletedPs = this.mSettings.mPackages.get(deletedAppName);
                            deletedPs.pkgFlags &= 0xFFFFFFFE;
                        }
                        PackageManagerService.logCriticalInfo(5, msg);
                    }
                    for (i = 0; i < expectingBetter.size(); ++i) {
                        int reparseFlags;
                        String packageName = (String)expectingBetter.keyAt(i);
                        if (this.mPackages.containsKey(packageName)) continue;
                        File scanFile = (File)expectingBetter.valueAt(i);
                        PackageManagerService.logCriticalInfo(5, "Expected better " + packageName + " but never showed up; reverting to system");
                        if (FileUtils.contains(privilegedAppDir, scanFile)) {
                            reparseFlags = 193;
                        } else if (FileUtils.contains(systemAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else if (FileUtils.contains(vendorAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else if (FileUtils.contains(oemAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else {
                            Slog.e(TAG, "Ignoring unexpected fallback path " + scanFile);
                            continue;
                        }
                        this.mSettings.enableSystemPackageLPw(packageName);
                        try {
                            this.scanPackageLI(scanFile, reparseFlags, 416, 0L, null);
                            continue;
                        }
                        catch (PackageManagerException e) {
                            Slog.e(TAG, "Failed to parse original system package: " + e.getMessage());
                        }
                    }
                }
                this.updateAllSharedLibrariesLPw();
                for (SharedUserSetting setting : this.mSettings.getAllSharedUsersLPw()) {
                    this.adjustCpuAbisForSharedUserLPw(setting.packages, null, false, false);
                }
                this.mPackageUsage.readLP();
                EventLog.writeEvent(3090, SystemClock.uptimeMillis());
                Slog.i(TAG, "Time to scan packages: " + (float)(SystemClock.uptimeMillis() - startTime) / 1000.0f + " seconds");
                boolean bl = regrantPermissions = this.mSettings.mInternalSdkPlatform != this.mSdkVersion;
                if (regrantPermissions) {
                    Slog.i(TAG, "Platform changed from " + this.mSettings.mInternalSdkPlatform + " to " + this.mSdkVersion + "; regranting permissions for internal storage");
                }
                this.mSettings.mInternalSdkPlatform = this.mSdkVersion;
                this.updatePermissionsLPw(null, null, 1 | (regrantPermissions ? 6 : 0));
                if (!this.mRestoredSettings && !onlyCore) {
                    this.mSettings.readDefaultPreferredAppsLPw(this, 0);
                }
                if (!Build.FINGERPRINT.equals(this.mSettings.mFingerprint) && !onlyCore) {
                    Slog.i(TAG, "Build fingerprint changed; clearing code caches");
                    for (String pkgName : this.mSettings.mPackages.keySet()) {
                        this.deleteCodeCacheDirsLI(pkgName);
                    }
                    this.mSettings.mFingerprint = Build.FINGERPRINT;
                }
                this.mSettings.updateInternalDatabaseVersion();
                this.mSettings.writeLPr();
                EventLog.writeEvent(3100, SystemClock.uptimeMillis());
                this.mRequiredVerifierPackage = this.getRequiredVerifierLPr();
            }
        }
        this.mInstallerService = new PackageInstallerService(context, this, this.mAppInstallDir);
        Runtime.getRuntime().gc();
    }

    @Override
    public boolean isFirstBoot() {
        return !this.mRestoredSettings;
    }

    @Override
    public boolean isOnlyCoreApps() {
        return this.mOnlyCore;
    }

    private String getRequiredVerifierLPr() {
        Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> receivers = this.queryIntentReceivers(verification, PACKAGE_MIME_TYPE, 512, 0);
        String requiredVerifier = null;
        int N = receivers.size();
        for (int i = 0; i < N; ++i) {
            GrantedPermissions gp;
            String packageName;
            PackageSetting ps;
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || (ps = this.mSettings.mPackages.get(packageName = info.activityInfo.packageName)) == null) continue;
            GrantedPermissions grantedPermissions = gp = ps.sharedUser != null ? ps.sharedUser : ps;
            if (!gp.grantedPermissions.contains("android.permission.PACKAGE_VERIFICATION_AGENT")) continue;
            if (requiredVerifier != null) {
                throw new RuntimeException("There can be only one required verifier");
            }
            requiredVerifier = packageName;
        }
        return requiredVerifier;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException) && !(e instanceof IllegalArgumentException)) {
                Slog.wtf(TAG, "Package Manager Crash", e);
            }
            throw e;
        }
    }

    void cleanupInstallFailedPackage(PackageSetting ps) {
        PackageManagerService.logCriticalInfo(5, "Cleaning up incompletely installed app: " + ps.name);
        this.removeDataDirsLI(ps.name);
        if (ps.codePath != null) {
            if (ps.codePath.isDirectory()) {
                FileUtils.deleteContents(ps.codePath);
            }
            ps.codePath.delete();
        }
        if (ps.resourcePath != null && !ps.resourcePath.equals(ps.codePath)) {
            if (ps.resourcePath.isDirectory()) {
                FileUtils.deleteContents(ps.resourcePath);
            }
            ps.resourcePath.delete();
        }
        this.mSettings.removePackageLPw(ps.name);
    }

    static int[] appendInts(int[] cur, int[] add) {
        if (add == null) {
            return cur;
        }
        if (cur == null) {
            return add;
        }
        int N = add.length;
        for (int i = 0; i < N; ++i) {
            cur = ArrayUtils.appendInt(cur, add[i]);
        }
        return cur;
    }

    static int[] removeInts(int[] cur, int[] rem) {
        if (rem == null) {
            return cur;
        }
        if (cur == null) {
            return cur;
        }
        int N = rem.length;
        for (int i = 0; i < N; ++i) {
            cur = ArrayUtils.removeInt(cur, rem[i]);
        }
        return cur;
    }

    PackageInfo generatePackageInfo(PackageParser.Package p, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = (PackageSetting)p.mExtras;
        if (ps == null) {
            return null;
        }
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        PackageUserState state = ps.readUserState(userId);
        return PackageParser.generatePackageInfo(p, gp.gids, flags, ps.firstInstallTime, ps.lastUpdateTime, gp.grantedPermissions, state, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageAvailable(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return false;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "is package available");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageUserState state;
            PackageSetting ps;
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null && (ps = (PackageSetting)p.mExtras) != null && (state = ps.readUserState(userId)) != null) {
                return PackageParser.isAvailable(state);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageInfo getPackageInfo(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get package info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return this.generatePackageInfo(p, flags, userId);
            }
            if ((flags & 0x2000) != 0) {
                return this.generatePackageInfoFromSettingsLPw(packageName, flags, userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                out[i] = ps != null && ps.realName != null ? ps.realName : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] canonicalToCurrentPackageNames(String[] names) {
        String[] out = new String[names.length];
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                String cur = this.mSettings.mRenamedPackages.get(names[i]);
                out[i] = cur != null ? cur : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageUid(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get package uid");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return UserHandle.getUid(userId, p.applicationInfo.uid);
            }
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || ps.pkg == null || ps.pkg.applicationInfo == null) {
                return -1;
            }
            p = ps.pkg;
            int n = p != null ? UserHandle.getUid(userId, p.applicationInfo.uid) : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPackageGids(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                return ps.getGids();
            }
        }
        return new int[0];
    }

    static final PermissionInfo generatePermissionInfo(BasePermission bp, int flags) {
        if (bp.perm != null) {
            return PackageParser.generatePermissionInfo(bp.perm, flags);
        }
        PermissionInfo pi = new PermissionInfo();
        pi.name = bp.name;
        pi.packageName = bp.sourcePackage;
        pi.nonLocalizedLabel = bp.name;
        pi.protectionLevel = bp.protectionLevel;
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo getPermissionInfo(String name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            BasePermission p = this.mSettings.mPermissions.get(name);
            if (p != null) {
                return PackageManagerService.generatePermissionInfo(p, flags);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PermissionInfo> out = new ArrayList<PermissionInfo>(10);
            for (BasePermission p : this.mSettings.mPermissions.values()) {
                if (group == null) {
                    if (p.perm != null && p.perm.info.group != null) continue;
                    out.add(PackageManagerService.generatePermissionInfo(p, flags));
                    continue;
                }
                if (p.perm == null || !group.equals(p.perm.info.group)) continue;
                out.add(PackageParser.generatePermissionInfo(p.perm, flags));
            }
            if (out.size() > 0) {
                return out;
            }
            return this.mPermissionGroups.containsKey(group) ? out : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return PackageParser.generatePermissionGroupInfo(this.mPermissionGroups.get(name), flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int N = this.mPermissionGroups.size();
            ArrayList<PermissionGroupInfo> out = new ArrayList<PermissionGroupInfo>(N);
            for (PackageParser.PermissionGroup pg : this.mPermissionGroups.values()) {
                out.add(PackageParser.generatePermissionGroupInfo(pg, flags));
            }
            return out;
        }
    }

    private ApplicationInfo generateApplicationInfoFromSettingsLPw(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            if (ps.pkg == null) {
                PackageInfo pInfo = this.generatePackageInfoFromSettingsLPw(packageName, flags, userId);
                if (pInfo != null) {
                    return pInfo.applicationInfo;
                }
                return null;
            }
            return PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId);
        }
        return null;
    }

    private PackageInfo generatePackageInfoFromSettingsLPw(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            PackageParser.Package pkg = ps.pkg;
            if (pkg == null) {
                if ((flags & 0x2000) == 0) {
                    return null;
                }
                pkg = new PackageParser.Package(packageName);
                pkg.applicationInfo.packageName = packageName;
                pkg.applicationInfo.flags = ps.pkgFlags | 0x1000000;
                pkg.applicationInfo.dataDir = this.getDataPathForPackage(packageName, 0).getPath();
                pkg.applicationInfo.primaryCpuAbi = ps.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = ps.secondaryCpuAbiString;
            }
            return this.generatePackageInfo(pkg, flags, userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get application info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId);
            }
            if ("android".equals(packageName) || "system".equals(packageName)) {
                return this.mAndroidApplication;
            }
            if ((flags & 0x2000) != 0) {
                return this.generateApplicationInfoFromSettingsLPw(packageName, flags, userId);
            }
        }
        return null;
    }

    @Override
    public void freeStorageAndNotify(final long freeStorageSize, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    retCode = PackageManagerService.this.mInstaller.freeCache(freeStorageSize);
                    if (retCode < 0) {
                        Slog.w(PackageManagerService.TAG, "Couldn't clear application caches");
                    }
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(null, retCode >= 0);
                    }
                    catch (RemoteException e) {
                        Slog.w(PackageManagerService.TAG, "RemoveException when invoking call back");
                    }
                }
            }
        });
    }

    @Override
    public void freeStorage(final long freeStorageSize, final IntentSender pi) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    retCode = PackageManagerService.this.mInstaller.freeCache(freeStorageSize);
                    if (retCode < 0) {
                        Slog.w(PackageManagerService.TAG, "Couldn't clear application caches");
                    }
                }
                if (pi != null) {
                    try {
                        int code = retCode >= 0 ? 1 : 0;
                        pi.sendIntent(null, code, null, null, null);
                    }
                    catch (IntentSender.SendIntentException e1) {
                        Slog.i(PackageManagerService.TAG, "Failed to send pending intent");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeStorage(long freeStorageSize) throws IOException {
        Object object = this.mInstallLock;
        synchronized (object) {
            if (this.mInstaller.freeCache(freeStorageSize) < 0) {
                throw new IOException("Failed to free enough space");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getActivityInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get activity info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
            if (this.mResolveComponentName.equals(component)) {
                return PackageParser.generateActivityInfo(this.mResolveActivity, flags, new PackageUserState(), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activitySupportsIntent(ComponentName component, Intent intent, String resolvedType) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a == null) {
                return false;
            }
            for (int i = 0; i < a.intents.size(); ++i) {
                if (((PackageParser.ActivityIntentInfo)a.intents.get(i)).match(intent.getAction(), resolvedType, intent.getScheme(), intent.getData(), intent.getCategories(), TAG) < 0) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getReceiverInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get receiver info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mReceivers.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo getServiceInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get service info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Service s = (PackageParser.Service)this.mServices.mServices.get(component);
            if (s != null && this.mSettings.isEnabledLPr(s.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateServiceInfo(s, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo getProviderInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get provider info");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Provider p = (PackageParser.Provider)this.mProviders.mProviders.get(component);
            if (p != null && this.mSettings.isEnabledLPr(p.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSystemSharedLibraryNames() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Set<String> libSet = this.mSharedLibraries.keySet();
            int size = libSet.size();
            if (size > 0) {
                String[] libs = new String[size];
                libSet.toArray(libs);
                return libs;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureInfo[] getSystemAvailableFeatures() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Collection<FeatureInfo> featSet = this.mAvailableFeatures.values();
            int size = featSet.size();
            if (size > 0) {
                FeatureInfo[] features = new FeatureInfo[size + 1];
                featSet.toArray(features);
                FeatureInfo fi = new FeatureInfo();
                fi.reqGlEsVersion = SystemProperties.getInt("ro.opengles.version", 0);
                features[size] = fi;
                return features;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSystemFeature(String name) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mAvailableFeatures.containsKey(name);
        }
    }

    private void checkValidCaller(int uid, int userId) {
        if (UserHandle.getUserId(uid) == userId || uid == 1000 || uid == 0) {
            return;
        }
        throw new SecurityException("Caller uid=" + uid + " is not privileged to communicate with user=" + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPermission(String permName, String pkgName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p = this.mPackages.get(pkgName);
            if (p != null && p.mExtras != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                if (ps.sharedUser != null) {
                    if (ps.sharedUser.grantedPermissions.contains(permName)) {
                        return 0;
                    }
                } else if (ps.grantedPermissions.contains(permName)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUidPermission(String permName, int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj != null) {
                GrantedPermissions gp = (GrantedPermissions)obj;
                if (gp.grantedPermissions.contains(permName)) {
                    return 0;
                }
            } else {
                HashSet<String> perms = this.mSystemPermissions.get(uid);
                if (perms != null && perms.contains(permName)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    void enforceCrossUserPermission(int callingUid, int userId, boolean requireFullPermission, boolean checkShell, String message) {
        if (userId < 0) {
            throw new IllegalArgumentException("Invalid userId " + userId);
        }
        if (checkShell) {
            this.enforceShellRestriction("no_debugging_features", callingUid, userId);
        }
        if (userId == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            if (requireFullPermission) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
            } else {
                try {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
                }
                catch (SecurityException se) {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", message);
                }
            }
        }
    }

    void enforceShellRestriction(String restriction, int callingUid, int userHandle) {
        if (callingUid == 2000) {
            if (userHandle >= 0 && sUserManager.hasUserRestriction(restriction, userHandle)) {
                throw new SecurityException("Shell does not have permission to access user " + userHandle);
            }
            if (userHandle < 0) {
                Slog.e(TAG, "Unable to check shell permission for user " + userHandle + "\n\t" + Debug.getCallers(3));
            }
        }
    }

    private BasePermission findPermissionTreeLP(String permName) {
        for (BasePermission bp : this.mSettings.mPermissionTrees.values()) {
            if (!permName.startsWith(bp.name) || permName.length() <= bp.name.length() || permName.charAt(bp.name.length()) != '.') continue;
            return bp;
        }
        return null;
    }

    private BasePermission checkPermissionTreeLP(String permName) {
        BasePermission bp;
        if (permName != null && (bp = this.findPermissionTreeLP(permName)) != null) {
            if (bp.uid == UserHandle.getAppId(Binder.getCallingUid())) {
                return bp;
            }
            throw new SecurityException("Calling uid " + Binder.getCallingUid() + " is not allowed to add to permission tree " + bp.name + " owned by uid " + bp.uid);
        }
        throw new SecurityException("No permission tree found for " + permName);
    }

    static boolean compareStrings(CharSequence s1, CharSequence s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.getClass() != s2.getClass()) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean comparePermissionInfos(PermissionInfo pi1, PermissionInfo pi2) {
        if (pi1.icon != pi2.icon) {
            return false;
        }
        if (pi1.logo != pi2.logo) {
            return false;
        }
        if (pi1.protectionLevel != pi2.protectionLevel) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.name, pi2.name)) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.nonLocalizedLabel, pi2.nonLocalizedLabel)) {
            return false;
        }
        return PackageManagerService.compareStrings(pi1.packageName, pi2.packageName);
    }

    int permissionInfoFootprint(PermissionInfo info) {
        int size = info.name.length();
        if (info.nonLocalizedLabel != null) {
            size += info.nonLocalizedLabel.length();
        }
        if (info.nonLocalizedDescription != null) {
            size += info.nonLocalizedDescription.length();
        }
        return size;
    }

    int calculateCurrentPermissionFootprintLocked(BasePermission tree) {
        int size = 0;
        for (BasePermission perm : this.mSettings.mPermissions.values()) {
            if (perm.uid != tree.uid) continue;
            size += perm.name.length() + this.permissionInfoFootprint(perm.perm.info);
        }
        return size;
    }

    void enforcePermissionCapLocked(PermissionInfo info, BasePermission tree) {
        int curTreeSize;
        if (tree.uid != 1000 && (curTreeSize = this.calculateCurrentPermissionFootprintLocked(tree)) + this.permissionInfoFootprint(info) > 32768) {
            throw new SecurityException("Permission tree size cap exceeded");
        }
    }

    boolean addPermissionLocked(PermissionInfo info, boolean async) {
        if (info.labelRes == 0 && info.nonLocalizedLabel == null) {
            throw new SecurityException("Label must be specified in permission");
        }
        BasePermission tree = this.checkPermissionTreeLP(info.name);
        BasePermission bp = this.mSettings.mPermissions.get(info.name);
        boolean added = bp == null;
        boolean changed = true;
        int fixedLevel = PermissionInfo.fixProtectionLevel(info.protectionLevel);
        if (added) {
            this.enforcePermissionCapLocked(info, tree);
            bp = new BasePermission(info.name, tree.sourcePackage, 2);
        } else {
            if (bp.type != 2) {
                throw new SecurityException("Not allowed to modify non-dynamic permission " + info.name);
            }
            if (bp.protectionLevel == fixedLevel && bp.perm.owner.equals(tree.perm.owner) && bp.uid == tree.uid && PackageManagerService.comparePermissionInfos(bp.perm.info, info)) {
                changed = false;
            }
        }
        bp.protectionLevel = fixedLevel;
        info = new PermissionInfo(info);
        info.protectionLevel = fixedLevel;
        bp.perm = new PackageParser.Permission(tree.perm.owner, info);
        bp.perm.info.packageName = tree.perm.info.packageName;
        bp.uid = tree.uid;
        if (added) {
            this.mSettings.mPermissions.put(info.name, bp);
        }
        if (changed) {
            if (!async) {
                this.mSettings.writeLPr();
            } else {
                this.scheduleWriteSettingsLocked();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermission(PermissionInfo info) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.addPermissionLocked(info, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionAsync(PermissionInfo info) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.addPermissionLocked(info, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(String name) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.checkPermissionTreeLP(name);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp != null) {
                if (bp.type != 2) {
                    throw new SecurityException("Not allowed to modify non-dynamic permission " + name);
                }
                this.mSettings.mPermissions.remove(name);
                this.mSettings.writeLPr();
            }
        }
    }

    private static void checkGrantRevokePermissions(PackageParser.Package pkg, BasePermission bp) {
        boolean isDevelopment;
        int index = pkg.requestedPermissions.indexOf(bp.name);
        if (index == -1) {
            throw new SecurityException("Package " + pkg.packageName + " has not requested permission " + bp.name);
        }
        boolean isNormal = (bp.protectionLevel & 0xF) == 0;
        boolean isDangerous = (bp.protectionLevel & 0xF) == 1;
        boolean bl = isDevelopment = (bp.protectionLevel & 0x20) != 0;
        if (!(isNormal || isDangerous || isDevelopment)) {
            throw new SecurityException("Permission " + bp.name + " is not a changeable permission type");
        }
        if ((isNormal || isDangerous) && pkg.requestedPermissionsRequired.get(index).booleanValue()) {
            throw new SecurityException("Can't change " + bp.name + ". It is required by the application");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantPermission(String packageName, String permissionName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_REVOKE_PERMISSIONS", null);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            GrantedPermissions gp;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(permissionName);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + permissionName);
            }
            PackageManagerService.checkGrantRevokePermissions(pkg, bp);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null) {
                return;
            }
            GrantedPermissions grantedPermissions = gp = ps.sharedUser != null ? ps.sharedUser : ps;
            if (gp.grantedPermissions.add(permissionName)) {
                if (ps.haveGids) {
                    gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                }
                this.mSettings.writeLPr();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokePermission(String packageName, String permissionName) {
        IActivityManager am;
        int changedAppId = -1;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            GrantedPermissions gp;
            BasePermission bp;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            if (pkg.applicationInfo.uid != Binder.getCallingUid()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_REVOKE_PERMISSIONS", null);
            }
            if ((bp = this.mSettings.mPermissions.get(permissionName)) == null) {
                throw new IllegalArgumentException("Unknown permission: " + permissionName);
            }
            PackageManagerService.checkGrantRevokePermissions(pkg, bp);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            if (ps == null) {
                return;
            }
            GrantedPermissions grantedPermissions = gp = ps.sharedUser != null ? ps.sharedUser : ps;
            if (gp.grantedPermissions.remove(permissionName)) {
                gp.grantedPermissions.remove(permissionName);
                if (ps.haveGids) {
                    gp.gids = PackageManagerService.removeInts(gp.gids, bp.gids);
                }
                this.mSettings.writeLPr();
                changedAppId = ps.appId;
            }
        }
        if (changedAppId >= 0 && (am = ActivityManagerNative.getDefault()) != null) {
            int callingUserId = UserHandle.getCallingUserId();
            long ident = Binder.clearCallingIdentity();
            try {
                int[] users;
                for (int user : users = sUserManager.getUserIds()) {
                    am.killUid(UserHandle.getUid(user, changedAppId), "revoke " + permissionName);
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtectedBroadcast(String actionName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mProtectedBroadcasts.contains(actionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkSignatures(String pkg1, String pkg2) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package p1 = this.mPackages.get(pkg1);
            PackageParser.Package p2 = this.mPackages.get(pkg2);
            if (p1 == null || p1.mExtras == null || p2 == null || p2.mExtras == null) {
                return -4;
            }
            return PackageManagerService.compareSignatures(p1.mSignatures, p2.mSignatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkUidSignatures(int uid1, int uid2) {
        uid1 = UserHandle.getAppId(uid1);
        uid2 = UserHandle.getAppId(uid2);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Signature[] s2;
            Signature[] s1;
            Object obj = this.mSettings.getUserIdLPr(uid1);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s1 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s1 = ((PackageSetting)obj).signatures.mSignatures;
            }
            obj = this.mSettings.getUserIdLPr(uid2);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s2 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s2 = ((PackageSetting)obj).signatures.mSignatures;
            }
            return PackageManagerService.compareSignatures(s1, s2);
        }
    }

    static int compareSignatures(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null ? 1 : -1;
        }
        if (s2 == null) {
            return -2;
        }
        if (s1.length != s2.length) {
            return -3;
        }
        if (s1.length == 1) {
            return s1[0].equals(s2[0]) ? 0 : -3;
        }
        HashSet<Signature> set1 = new HashSet<Signature>();
        for (Signature sig : s1) {
            set1.add(sig);
        }
        HashSet<Signature> set2 = new HashSet<Signature>();
        for (Signature sig : s2) {
            set2.add(sig);
        }
        if (set1.equals(set2)) {
            return 0;
        }
        return -3;
    }

    private boolean isCompatSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        return PackageManagerService.isExternal(scannedPkg) && this.mSettings.isExternalDatabaseVersionOlderThan(2) || !PackageManagerService.isExternal(scannedPkg) && this.mSettings.isInternalDatabaseVersionOlderThan(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compareSignaturesCompat(PackageSignatures existingSigs, PackageParser.Package scannedPkg) {
        if (!this.isCompatSignatureUpdateNeeded(scannedPkg)) {
            return -3;
        }
        HashSet<Signature> existingSet = new HashSet<Signature>();
        for (Signature sig : existingSigs.mSignatures) {
            existingSet.add(sig);
        }
        HashSet<Signature> scannedCompatSet = new HashSet<Signature>();
        for (Signature sig : scannedPkg.mSignatures) {
            try {
                Signature[] chainSignatures;
                for (Signature chainSig : chainSignatures = sig.getChainSignatures()) {
                    scannedCompatSet.add(chainSig);
                }
            }
            catch (CertificateEncodingException e) {
                scannedCompatSet.add(sig);
            }
        }
        if (scannedCompatSet.equals(existingSet)) {
            existingSigs.assignSignatures(scannedPkg.mSignatures);
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                this.mSettings.mKeySetManagerService.removeAppKeySetDataLPw(scannedPkg.packageName);
            }
            return 0;
        }
        return -3;
    }

    private boolean isRecoverSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        if (PackageManagerService.isExternal(scannedPkg)) {
            return this.mSettings.isExternalDatabaseVersionOlderThan(3);
        }
        return this.mSettings.isInternalDatabaseVersionOlderThan(3);
    }

    private int compareSignaturesRecover(PackageSignatures existingSigs, PackageParser.Package scannedPkg) {
        if (!this.isRecoverSignatureUpdateNeeded(scannedPkg)) {
            return -3;
        }
        String msg = null;
        try {
            if (Signature.areEffectiveMatch(existingSigs.mSignatures, scannedPkg.mSignatures)) {
                PackageManagerService.logCriticalInfo(4, "Recovered effectively matching certificates for " + scannedPkg.packageName);
                return 0;
            }
        }
        catch (CertificateException e) {
            msg = e.getMessage();
        }
        PackageManagerService.logCriticalInfo(4, "Failed to recover certificates for " + scannedPkg.packageName + ": " + msg);
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPackagesForUid(int uid) {
        uid = UserHandle.getAppId(uid);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                int N = sus.packages.size();
                String[] res = new String[N];
                Iterator<PackageSetting> it = sus.packages.iterator();
                int i = 0;
                while (it.hasNext()) {
                    res[i++] = it.next().name;
                }
                return res;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return new String[]{ps.name};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameForUid(int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.name + ":" + sus.userId;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.name;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidForSharedUser(String sharedUserName) {
        if (sharedUserName == null) {
            return -1;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            SharedUserSetting suid = this.mSettings.getSharedUserLPw(sharedUserName, 0, false);
            if (suid == null) {
                return -1;
            }
            return suid.userId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFlagsForUid(int uid) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.pkgFlags;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUidPrivileged(int uid) {
        uid = UserHandle.getAppId(uid);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                Iterator<PackageSetting> it = sus.packages.iterator();
                while (it.hasNext()) {
                    if (!it.next().isPrivileged()) continue;
                    return true;
                }
            } else if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.isPrivileged();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAppOpPermissionPackages(String permissionName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArraySet<String> pkgs = this.mAppOpPermissionPackages.get(permissionName);
            if (pkgs == null) {
                return null;
            }
            return pkgs.toArray(new String[pkgs.size()]);
        }
    }

    @Override
    public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "resolve intent");
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        return this.chooseBestActivity(intent, resolvedType, flags, query, userId);
    }

    @Override
    public void setLastChosenActivity(Intent intent, String resolvedType, int flags, IntentFilter filter, int match, ComponentName activity) {
        int userId = UserHandle.getCallingUserId();
        intent.setComponent(null);
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, true, false, userId);
        this.addPreferredActivityInternal(filter, match, null, activity, false, userId, "Setting last chosen");
    }

    @Override
    public ResolveInfo getLastChosenActivity(Intent intent, String resolvedType, int flags) {
        int userId = UserHandle.getCallingUserId();
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        return this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, false, false, userId);
    }

    private ResolveInfo chooseBestActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int userId) {
        if (query != null) {
            int N = query.size();
            if (N == 1) {
                return query.get(0);
            }
            if (N > 1) {
                boolean debug = (intent.getFlags() & 8) != 0;
                ResolveInfo r0 = query.get(0);
                ResolveInfo r1 = query.get(1);
                if (debug) {
                    Slog.v(TAG, r0.activityInfo.name + "=" + r0.priority + " vs " + r1.activityInfo.name + "=" + r1.priority);
                }
                if (r0.priority != r1.priority || r0.preferredOrder != r1.preferredOrder || r0.isDefault != r1.isDefault) {
                    return query.get(0);
                }
                ResolveInfo ri = this.findPreferredActivity(intent, resolvedType, flags, query, r0.priority, true, false, debug, userId);
                if (ri != null) {
                    return ri;
                }
                if (userId != 0) {
                    ri = new ResolveInfo(this.mResolveInfo);
                    ri.activityInfo = new ActivityInfo(ri.activityInfo);
                    ri.activityInfo.applicationInfo = new ApplicationInfo(ri.activityInfo.applicationInfo);
                    ri.activityInfo.applicationInfo.uid = UserHandle.getUid(userId, UserHandle.getAppId(ri.activityInfo.applicationInfo.uid));
                    return ri;
                }
                return this.mResolveInfo;
            }
        }
        return null;
    }

    private ResolveInfo findPersistentPreferredActivityLP(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, boolean debug, int userId) {
        List pprefs;
        int N = query.size();
        PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.get(userId);
        if (debug) {
            Slog.v(TAG, "Looking for presistent preferred activities...");
        }
        List list = ppir != null ? ppir.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId) : (pprefs = null);
        if (pprefs != null && pprefs.size() > 0) {
            int M = pprefs.size();
            for (int i = 0; i < M; ++i) {
                PersistentPreferredActivity ppa = (PersistentPreferredActivity)pprefs.get(i);
                if (debug) {
                    Slog.v(TAG, "Checking PersistentPreferredActivity ds=" + (ppa.countDataSchemes() > 0 ? ppa.getDataScheme(0) : "<none>") + "\n  component=" + ppa.mComponent);
                    ppa.dump(new LogPrinter(2, TAG, 3), "  ");
                }
                ActivityInfo ai = this.getActivityInfo(ppa.mComponent, flags | 0x200, userId);
                if (debug) {
                    Slog.v(TAG, "Found persistent preferred activity:");
                    if (ai != null) {
                        ai.dump(new LogPrinter(2, TAG, 3), "  ");
                    } else {
                        Slog.v(TAG, "  null");
                    }
                }
                if (ai == null) continue;
                for (int j = 0; j < N; ++j) {
                    ResolveInfo ri = query.get(j);
                    if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                    if (debug) {
                        Slog.v(TAG, "Returning persistent preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                    }
                    return ri;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResolveInfo findPreferredActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int priority, boolean always, boolean removeMatches, boolean debug, int userId) {
        if (!PackageManagerService.sUserManager.exists(userId)) {
            return null;
        }
        var10_10 = this.mPackages;
        synchronized (var10_10) {
            if (intent.getSelector() != null) {
                intent = intent.getSelector();
            }
            if ((pri = this.findPersistentPreferredActivityLP(intent, resolvedType, flags, query, debug, userId)) != null) {
                return pri;
            }
            pir = this.mSettings.mPreferredActivities.get(userId);
            if (debug) {
                Slog.v("PackageManager", "Looking for preferred activities...");
            }
            v0 = pir != null ? pir.queryIntent(intent, resolvedType, (flags & 65536) != 0, userId) : (prefs = null);
            if (prefs != null && prefs.size() > 0) {
                changed = false;
                try {
                    match = 0;
                    if (debug) {
                        Slog.v("PackageManager", "Figuring out best match...");
                    }
                    N = query.size();
                    for (j = 0; j < N; ++j) {
                        ri = query.get(j);
                        if (debug) {
                            Slog.v("PackageManager", "Match for " + ri.activityInfo + ": 0x" + Integer.toHexString(match));
                        }
                        if (ri.match <= match) continue;
                        match = ri.match;
                    }
                    if (debug) {
                        Slog.v("PackageManager", "Best match: 0x" + Integer.toHexString(match));
                    }
                    match &= 0xFFF0000;
                    M = prefs.size();
                    block8: for (i = 0; i < M; ++i) {
                        pa = (PreferredActivity)prefs.get(i);
                        if (debug) {
                            Slog.v("PackageManager", "Checking PreferredActivity ds=" + (pa.countDataSchemes() > 0 ? pa.getDataScheme(0) : "<none>") + "\n  component=" + pa.mPref.mComponent);
                            pa.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                        }
                        if (pa.mPref.mMatch != match) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping bad match " + Integer.toHexString(pa.mPref.mMatch));
                            continue;
                        }
                        if (always && !pa.mPref.mAlways) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping mAlways=false entry");
                            continue;
                        }
                        ai = this.getActivityInfo(pa.mPref.mComponent, flags | 512, userId);
                        if (debug) {
                            Slog.v("PackageManager", "Found preferred activity:");
                            if (ai != null) {
                                ai.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                            } else {
                                Slog.v("PackageManager", "  null");
                            }
                        }
                        if (ai == null) {
                            Slog.w("PackageManager", "Removing dangling preferred activity: " + pa.mPref.mComponent);
                            pir.removeFilter(pa);
                            changed = true;
                            continue;
                        }
                        for (j = 0; j < N; ++j) {
                            ri = query.get(j);
                            if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                            if (removeMatches) {
                                pir.removeFilter(pa);
                                changed = true;
                                continue block8;
                            }
                            if (always && !pa.mPref.sameSet(query, priority)) {
                                Slog.i("PackageManager", "Result set changed, dropping preferred activity for " + intent + " type " + resolvedType);
                                pir.removeFilter(pa);
                                lastChosen = new PreferredActivity(pa, pa.mPref.mMatch, null, pa.mPref.mComponent, false);
                                pir.addFilter(lastChosen);
                                changed = true;
                                var24_26 = null;
                                return var24_26;
                            }
                            if (debug) {
                                Slog.v("PackageManager", "Returning preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                            }
                            var23_25 = ri;
                            return var23_25;
                        }
                    }
                }
                finally {
                    if (changed) {
                        this.mSettings.writePackageRestrictionsLPr(userId);
                    }
                }
            }
            ** if (!debug) goto lbl97
        }
lbl-1000:
        // 1 sources

        {
            Slog.v("PackageManager", "No preferred activity to return");
        }
lbl97:
        // 2 sources

        return null;
    }

    @Override
    public boolean canForwardTo(Intent intent, String resolvedType, int sourceUserId, int targetUserId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        List<CrossProfileIntentFilter> matches = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, sourceUserId);
        if (matches != null) {
            int size = matches.size();
            for (int i = 0; i < size; ++i) {
                if (matches.get(i).getTargetUserId() != targetUserId) continue;
                return true;
            }
        }
        return false;
    }

    private List<CrossProfileIntentFilter> getMatchingCrossProfileIntentFilters(Intent intent, String resolvedType, int userId) {
        CrossProfileIntentResolver resolver = this.mSettings.mCrossProfileIntentResolvers.get(userId);
        if (resolver != null) {
            return resolver.queryIntent(intent, resolvedType, false, userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "query intent activities");
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getActivityInfo(comp, flags, userId);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                List<CrossProfileIntentFilter> matchingFilters = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, userId);
                ResolveInfo resolveInfo = this.querySkipCurrentProfileIntents(matchingFilters, intent, resolvedType, flags, userId);
                if (resolveInfo != null) {
                    ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>(1);
                    result.add(resolveInfo);
                    return result;
                }
                resolveInfo = this.queryCrossProfileIntents(matchingFilters, intent, resolvedType, flags, userId);
                List<ResolveInfo> result = this.mActivities.queryIntent(intent, resolvedType, flags, userId);
                if (resolveInfo != null) {
                    result.add(resolveInfo);
                    Collections.sort(result, mResolvePrioritySorter);
                }
                return result;
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mActivities.queryIntentForPackage(intent, resolvedType, flags, pkg.activities, userId);
            }
            return new ArrayList<ResolveInfo>();
        }
    }

    private ResolveInfo querySkipCurrentProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId) {
        if (matchingFilters != null) {
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                ResolveInfo resolveInfo;
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                if ((filter.getFlags() & 2) == 0 || (resolveInfo = this.checkTargetCanHandle(filter, intent, resolvedType, flags, sourceUserId)) == null) continue;
                return resolveInfo;
            }
        }
        return null;
    }

    private ResolveInfo queryCrossProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId) {
        if (matchingFilters != null) {
            SparseBooleanArray alreadyTriedUserIds = new SparseBooleanArray();
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                int targetUserId = filter.getTargetUserId();
                if ((filter.getFlags() & 2) != 0 || alreadyTriedUserIds.get(targetUserId)) continue;
                ResolveInfo resolveInfo = this.checkTargetCanHandle(filter, intent, resolvedType, flags, sourceUserId);
                if (resolveInfo != null) {
                    return resolveInfo;
                }
                alreadyTriedUserIds.put(targetUserId, true);
            }
        }
        return null;
    }

    private ResolveInfo checkTargetCanHandle(CrossProfileIntentFilter filter, Intent intent, String resolvedType, int flags, int sourceUserId) {
        List<ResolveInfo> resultTargetUser = this.mActivities.queryIntent(intent, resolvedType, flags, filter.getTargetUserId());
        if (resultTargetUser != null && !resultTargetUser.isEmpty()) {
            return this.createForwardingResolveInfo(filter, sourceUserId, filter.getTargetUserId());
        }
        return null;
    }

    private ResolveInfo createForwardingResolveInfo(IntentFilter filter, int sourceUserId, int targetUserId) {
        ResolveInfo forwardingResolveInfo = new ResolveInfo();
        String className = targetUserId == 0 ? IntentForwarderActivity.FORWARD_INTENT_TO_USER_OWNER : IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE;
        ComponentName forwardingActivityComponentName = new ComponentName(this.mAndroidApplication.packageName, className);
        ActivityInfo forwardingActivityInfo = this.getActivityInfo(forwardingActivityComponentName, 0, sourceUserId);
        if (targetUserId == 0) {
            forwardingActivityInfo.showUserIcon = 0;
            forwardingResolveInfo.noResourceId = true;
        }
        forwardingResolveInfo.activityInfo = forwardingActivityInfo;
        forwardingResolveInfo.priority = 0;
        forwardingResolveInfo.preferredOrder = 0;
        forwardingResolveInfo.match = 0;
        forwardingResolveInfo.isDefault = true;
        forwardingResolveInfo.filter = filter;
        forwardingResolveInfo.targetUserId = targetUserId;
        return forwardingResolveInfo;
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) {
        int N;
        int i;
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "query intent activity options");
        String resultsAction = intent.getAction();
        List<ResolveInfo> results = this.queryIntentActivities(intent, resolvedType, flags | 0x40, userId);
        int specificsPos = 0;
        if (specifics != null) {
            for (i = 0; i < specifics.length; ++i) {
                Intent sintent = specifics[i];
                if (sintent == null) continue;
                String action = sintent.getAction();
                if (resultsAction != null && resultsAction.equals(action)) {
                    action = null;
                }
                ResolveInfo ri = null;
                ActivityInfo ai = null;
                ComponentName comp = sintent.getComponent();
                if (comp == null) {
                    ri = this.resolveIntent(sintent, specificTypes != null ? specificTypes[i] : null, flags, userId);
                    if (ri == null) continue;
                    if (ri == this.mResolveInfo) {
                        // empty if block
                    }
                    ai = ri.activityInfo;
                    comp = new ComponentName(ai.applicationInfo.packageName, ai.name);
                } else {
                    ai = this.getActivityInfo(comp, flags, userId);
                    if (ai == null) continue;
                }
                N = results.size();
                for (int j = specificsPos; j < N; ++j) {
                    ResolveInfo sri = results.get(j);
                    if ((!sri.activityInfo.name.equals(comp.getClassName()) || !sri.activityInfo.applicationInfo.packageName.equals(comp.getPackageName())) && (action == null || !sri.filter.matchAction(action))) continue;
                    results.remove(j);
                    if (ri == null) {
                        ri = sri;
                    }
                    --j;
                    --N;
                }
                if (ri == null) {
                    ri = new ResolveInfo();
                    ri.activityInfo = ai;
                }
                results.add(specificsPos, ri);
                ri.specificIndex = i;
                ++specificsPos;
            }
        }
        N = results.size();
        for (i = specificsPos; i < N - 1; ++i) {
            Iterator<String> it;
            ResolveInfo rii = results.get(i);
            if (rii.filter == null || (it = rii.filter.actionsIterator()) == null) continue;
            while (it.hasNext()) {
                String action = it.next();
                if (resultsAction != null && resultsAction.equals(action)) continue;
                for (int j = i + 1; j < N; ++j) {
                    ResolveInfo rij = results.get(j);
                    if (rij.filter == null || !rij.filter.hasAction(action)) continue;
                    results.remove(j);
                    --j;
                    --N;
                }
            }
            if ((flags & 0x40) != 0) continue;
            rii.filter = null;
        }
        if (caller != null) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                ActivityInfo ainfo = results.get((int)i).activityInfo;
                if (!caller.getPackageName().equals(ainfo.applicationInfo.packageName) || !caller.getClassName().equals(ainfo.name)) continue;
                results.remove(i);
                break;
            }
        }
        if ((flags & 0x40) == 0) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                results.get((int)i).filter = null;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentReceivers(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getReceiverInfo(comp, flags, userId);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mReceivers.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mReceivers.queryIntentForPackage(intent, resolvedType, flags, pkg.receivers, userId);
            }
            return null;
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId) {
        List<ResolveInfo> query = this.queryIntentServices(intent, resolvedType, flags, userId);
        if (!sUserManager.exists(userId)) {
            return null;
        }
        if (query != null && query.size() >= 1) {
            return query.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ServiceInfo si = this.getServiceInfo(comp, flags, userId);
            if (si != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.serviceInfo = si;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mServices.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mServices.queryIntentForPackage(intent, resolvedType, flags, pkg.services, userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ProviderInfo pi = this.getProviderInfo(comp, flags, userId);
            if (pi != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.providerInfo = pi;
                list.add(ri);
            }
            return list;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mProviders.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mProviders.queryIntentForPackage(intent, resolvedType, flags, pkg.providers, userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getInstalledPackages(int flags, int userId) {
        boolean listUninstalled = (flags & 0x2000) != 0;
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "get installed packages");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PackageInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    PackageInfo pi = ps.pkg != null ? this.generatePackageInfo(ps.pkg, flags, userId) : this.generatePackageInfoFromSettingsLPw(ps.name, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            } else {
                list = new ArrayList<PackageInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    PackageInfo pi = this.generatePackageInfo(p, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    private void addPackageHoldingPermissions(ArrayList<PackageInfo> list, PackageSetting ps, String[] permissions, boolean[] tmp, int flags, int userId) {
        int numMatch = 0;
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        for (int i = 0; i < permissions.length; ++i) {
            if (gp.grantedPermissions.contains(permissions[i])) {
                tmp[i] = true;
                ++numMatch;
                continue;
            }
            tmp[i] = false;
        }
        if (numMatch == 0) {
            return;
        }
        PackageInfo pi = ps.pkg != null ? this.generatePackageInfo(ps.pkg, flags, userId) : this.generatePackageInfoFromSettingsLPw(ps.name, flags, userId);
        if (pi != null) {
            if ((flags & 0x1000) == 0) {
                if (numMatch == permissions.length) {
                    pi.requestedPermissions = permissions;
                } else {
                    pi.requestedPermissions = new String[numMatch];
                    numMatch = 0;
                    for (int i = 0; i < permissions.length; ++i) {
                        if (!tmp[i]) continue;
                        pi.requestedPermissions[numMatch] = permissions[i];
                        ++numMatch;
                    }
                }
            }
            list.add(pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        boolean listUninstalled = (flags & 0x2000) != 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
            boolean[] tmpBools = new boolean[permissions.length];
            if (listUninstalled) {
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            } else {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    if (ps == null) continue;
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ApplicationInfo> getInstalledApplications(int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        boolean listUninstalled = (flags & 0x2000) != 0;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<ApplicationInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    ApplicationInfo ai = ps.pkg != null ? PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId) : this.generateApplicationInfoFromSettingsLPw(ps.name, flags, userId);
                    if (ai == null) continue;
                    list.add(ai);
                }
            } else {
                list = new ArrayList<ApplicationInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    ApplicationInfo ai;
                    if (p.mExtras == null || (ai = PackageParser.generateApplicationInfo(p, flags, ((PackageSetting)p.mExtras).readUserState(userId), userId)) == null) continue;
                    list.add(ai);
                }
            }
            return new ParceledListSlice<ApplicationInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationInfo> getPersistentApplications(int flags) {
        ArrayList<ApplicationInfo> finalList = new ArrayList<ApplicationInfo>();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Iterator<PackageParser.Package> i = this.mPackages.values().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ApplicationInfo ai;
                PackageSetting ps;
                PackageParser.Package p = i.next();
                if (p.applicationInfo == null || (p.applicationInfo.flags & 8) == 0 || this.mSafeMode && !PackageManagerService.isSystemApp(p) || (ps = this.mSettings.mPackages.get(p.packageName)) == null || (ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(ai);
            }
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo resolveContentProvider(String name, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Provider provider = this.mProvidersByAuthority.get(name);
            PackageSetting ps = provider != null ? this.mSettings.mPackages.get(provider.owner.packageName) : null;
            return ps != null && this.mSettings.isEnabledLPr(provider.info, flags, userId) && (!this.mSafeMode || (provider.info.applicationInfo.flags & 1) != 0) ? PackageParser.generateProviderInfo(provider, flags, ps.readUserState(userId), userId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, PackageParser.Provider>> i = this.mProvidersByAuthority.entrySet().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ProviderInfo info;
                Map.Entry<String, PackageParser.Provider> entry = i.next();
                PackageParser.Provider p = entry.getValue();
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || !p.syncable || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0 || (info = PackageParser.generateProviderInfo(p, 0, ps.readUserState(userId), userId)) == null) continue;
                outNames.add(entry.getKey());
                outInfo.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        ArrayList<ProviderInfo> finalList = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int userId;
            Iterator i = this.mProviders.mProviders.values().iterator();
            int n = userId = processName != null ? UserHandle.getUserId(uid) : UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ProviderInfo info;
                PackageParser.Provider p = (PackageParser.Provider)i.next();
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || p.info.authority == null || processName != null && (!p.info.processName.equals(processName) || !UserHandle.isSameApp(p.info.applicationInfo.uid, uid)) || !this.mSettings.isEnabledLPr(p.info, flags, userId) || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0) continue;
                if (finalList == null) {
                    finalList = new ArrayList<ProviderInfo>(3);
                }
                if ((info = PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(info);
            }
        }
        if (finalList != null) {
            Collections.sort(finalList, mProviderInitOrderSorter);
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName name, int flags) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Instrumentation i = this.mInstrumentation.get(name);
            return PackageParser.generateInstrumentationInfo(i, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        ArrayList<InstrumentationInfo> finalList = new ArrayList<InstrumentationInfo>();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (PackageParser.Instrumentation p : this.mInstrumentation.values()) {
                InstrumentationInfo ii;
                if (targetPackage != null && !targetPackage.equals(p.info.targetPackage) || (ii = PackageParser.generateInstrumentationInfo(p, flags)) == null) continue;
                finalList.add(ii);
            }
        }
        return finalList;
    }

    private void createIdmapsForPackageLI(PackageParser.Package pkg) {
        HashMap<String, PackageParser.Package> overlays = this.mOverlays.get(pkg.packageName);
        if (overlays == null) {
            Slog.w(TAG, "Unable to create idmap for " + pkg.packageName + ": no overlay packages");
            return;
        }
        for (PackageParser.Package opkg : overlays.values()) {
            this.createIdmapForPackagePairLI(pkg, opkg);
        }
    }

    private boolean createIdmapForPackagePairLI(PackageParser.Package pkg, PackageParser.Package opkg) {
        if (!opkg.mTrustedOverlay) {
            Slog.w(TAG, "Skipping target and overlay pair " + pkg.baseCodePath + " and " + opkg.baseCodePath + ": overlay not trusted");
            return false;
        }
        HashMap<String, PackageParser.Package> overlaySet = this.mOverlays.get(pkg.packageName);
        if (overlaySet == null) {
            Slog.e(TAG, "was about to create idmap for " + pkg.baseCodePath + " and " + opkg.baseCodePath + " but target package has no known overlays");
            return false;
        }
        int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
        if (this.mInstaller.idmap(pkg.baseCodePath, opkg.baseCodePath, sharedGid) != 0) {
            Slog.e(TAG, "Failed to generate idmap for " + pkg.baseCodePath + " and " + opkg.baseCodePath);
            return false;
        }
        PackageParser.Package[] overlayArray = overlaySet.values().toArray(new PackageParser.Package[0]);
        Comparator<PackageParser.Package> cmp = new Comparator<PackageParser.Package>(){

            @Override
            public int compare(PackageParser.Package p1, PackageParser.Package p2) {
                return p1.mOverlayPriority - p2.mOverlayPriority;
            }
        };
        Arrays.sort(overlayArray, cmp);
        pkg.applicationInfo.resourceDirs = new String[overlayArray.length];
        int i = 0;
        for (PackageParser.Package p : overlayArray) {
            pkg.applicationInfo.resourceDirs[i++] = p.baseCodePath;
        }
        return true;
    }

    private void scanDirLI(File dir, int parseFlags, int scanFlags, long currentTime) {
        File[] files = dir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            Log.d(TAG, "No files in app dir " + dir);
            return;
        }
        for (File file : files) {
            boolean isPackage;
            boolean bl = isPackage = (PackageParser.isApkFile(file) || file.isDirectory()) && !PackageInstallerService.isStageName(file.getName());
            if (!isPackage) continue;
            try {
                this.scanPackageLI(file, parseFlags | 4, scanFlags, currentTime, null);
            }
            catch (PackageManagerException e) {
                Slog.w(TAG, "Failed to parse " + file + ": " + e.getMessage());
                if ((parseFlags & 1) != 0 || e.error != -2) continue;
                PackageManagerService.logCriticalInfo(5, "Deleting invalid package at " + file);
                if (file.isDirectory()) {
                    FileUtils.deleteContents(file);
                }
                file.delete();
            }
        }
    }

    private static File getSettingsProblemFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "uiderrors.txt");
        return fname;
    }

    static void reportSettingsProblem(int priority, String msg) {
        PackageManagerService.logCriticalInfo(priority, msg);
    }

    static void logCriticalInfo(int priority, String msg) {
        Slog.println(priority, TAG, msg);
        EventLogTags.writePmCriticalInfo(msg);
        try {
            File fname = PackageManagerService.getSettingsProblemFile();
            FileOutputStream out = new FileOutputStream(fname, true);
            FastPrintWriter pw = new FastPrintWriter(out);
            SimpleDateFormat formatter = new SimpleDateFormat();
            String dateString = formatter.format(new Date(System.currentTimeMillis()));
            pw.println(dateString + ": " + msg);
            ((PrintWriter)pw).close();
            FileUtils.setPermissions(fname.toString(), 508, -1, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCertificatesLI(PackageParser pp, PackageSetting ps, PackageParser.Package pkg, File srcFile, int parseFlags) throws PackageManagerException {
        if (ps != null && ps.codePath.equals(srcFile) && ps.timeStamp == srcFile.lastModified() && !this.isCompatSignatureUpdateNeeded(pkg) && !this.isRecoverSignatureUpdateNeeded(pkg)) {
            long mSigningKeySetId = ps.keySetData.getProperSigningKeySet();
            if (ps.signatures.mSignatures != null && ps.signatures.mSignatures.length != 0 && mSigningKeySetId != -1L) {
                pkg.mSignatures = ps.signatures.mSignatures;
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                synchronized (hashMap) {
                    pkg.mSigningKeys = ksms.getPublicKeysFromKeySetLPr(mSigningKeySetId);
                }
                return;
            }
            Slog.w(TAG, "PackageSetting for " + ps.name + " is missing signatures.  Collecting certs again to recover them.");
        } else {
            Log.i(TAG, srcFile.toString() + " changed; collecting certs");
        }
        try {
            pp.collectCertificates(pkg, parseFlags);
            pp.collectManifestDigest(pkg);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(File scanFile, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        PackageSetting updatedPkg;
        Object oldName;
        PackageParser.Package pkg;
        parseFlags |= this.mDefParseFlags;
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setOnlyCoreApps(this.mOnlyCore);
        pp.setDisplayMetrics(this.mMetrics);
        if ((scanFlags & 0x200) != 0) {
            parseFlags |= 0x200;
        }
        try {
            pkg = pp.parsePackage(scanFile, parseFlags);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        PackageSetting ps = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldName = this.mSettings.mRenamedPackages.get(pkg.packageName);
            if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName)) {
                ps = this.mSettings.peekPackageLPr((String)oldName);
            }
            if (ps == null) {
                ps = this.mSettings.peekPackageLPr(pkg.packageName);
            }
            updatedPkg = this.mSettings.getDisabledSystemPkgLPr(ps != null ? ps.name : pkg.packageName);
        }
        boolean updatedPkgBetter = false;
        if (updatedPkg != null && (parseFlags & 1) != 0 && ps != null && !ps.codePath.equals(scanFile)) {
            if (pkg.mVersionCode < ps.versionCode) {
                PackageManagerService.logCriticalInfo(4, "Package " + ps.name + " at " + scanFile + " ignored: updated version " + ps.versionCode + " better than this " + pkg.mVersionCode);
                if (!updatedPkg.codePath.equals(scanFile)) {
                    Slog.w(TAG, "Code path for hidden system pkg : " + ps.name + " changing from " + updatedPkg.codePathString + " to " + scanFile);
                    updatedPkg.codePath = scanFile;
                    updatedPkg.codePathString = scanFile.toString();
                    if (PackageManagerService.locationIsPrivileged(scanFile)) {
                        updatedPkg.pkgFlags |= 0x40000000;
                    }
                }
                updatedPkg.pkg = pkg;
                throw new PackageManagerException(-5, null);
            }
            oldName = this.mPackages;
            synchronized (oldName) {
                this.mPackages.remove(ps.name);
            }
            PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " at " + scanFile + " reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
            InstallArgs args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, ps.legacyNativeLibraryPathString, PackageManagerService.getAppDexInstructionSets(ps));
            HashMap<String, PackageParser.Package> hashMap2 = this.mInstallLock;
            synchronized (hashMap2) {
                args.cleanUpResourcesLI();
            }
            hashMap2 = this.mPackages;
            synchronized (hashMap2) {
                this.mSettings.enableSystemPackageLPw(ps.name);
            }
            updatedPkgBetter = true;
        }
        if (updatedPkg != null) {
            parseFlags |= 1;
            if ((updatedPkg.pkgFlags & 0x40000000) != 0) {
                parseFlags |= 0x80;
            }
        }
        this.collectCertificatesLI(pp, ps, pkg, scanFile, parseFlags);
        boolean shouldHideSystemApp = false;
        if (updatedPkg == null && ps != null && (parseFlags & 0x40) != 0 && !PackageManagerService.isSystemApp(ps)) {
            if (PackageManagerService.compareSignatures(ps.signatures.mSignatures, pkg.mSignatures) != 0) {
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " appeared on system, but" + " signatures don't match existing userdata copy; removing");
                this.deletePackageLI(pkg.packageName, null, true, null, null, 0, null, false);
                ps = null;
            } else if (pkg.mVersionCode < ps.versionCode) {
                shouldHideSystemApp = true;
                PackageManagerService.logCriticalInfo(4, "Package " + ps.name + " appeared at " + scanFile + " but new version " + pkg.mVersionCode + " better than installed " + ps.versionCode + "; hiding system");
            } else {
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " at " + scanFile + " reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
                InstallArgs args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, ps.legacyNativeLibraryPathString, PackageManagerService.getAppDexInstructionSets(ps));
                Object object = this.mInstallLock;
                synchronized (object) {
                    args.cleanUpResourcesLI();
                }
            }
        }
        if ((parseFlags & 0x40) == 0 && ps != null && !ps.codePath.equals(ps.resourcePath)) {
            parseFlags |= 0x10;
        }
        String resourcePath = null;
        String baseResourcePath = null;
        if ((parseFlags & 0x10) != 0 && !updatedPkgBetter) {
            if (ps != null && ps.resourcePathString != null) {
                resourcePath = ps.resourcePathString;
                baseResourcePath = ps.resourcePathString;
            } else {
                Slog.e(TAG, "Resource path not set for pkg : " + pkg.packageName);
            }
        } else {
            resourcePath = pkg.codePath;
            baseResourcePath = pkg.baseCodePath;
        }
        pkg.applicationInfo.setCodePath(pkg.codePath);
        pkg.applicationInfo.setBaseCodePath(pkg.baseCodePath);
        pkg.applicationInfo.setSplitCodePaths(pkg.splitCodePaths);
        pkg.applicationInfo.setResourcePath(resourcePath);
        pkg.applicationInfo.setBaseResourcePath(baseResourcePath);
        pkg.applicationInfo.setSplitResourcePaths(pkg.splitCodePaths);
        PackageParser.Package scannedPkg = this.scanPackageLI(pkg, parseFlags, scanFlags | 8, currentTime, user);
        if (shouldHideSystemApp) {
            HashMap<String, PackageParser.Package> hashMap3 = this.mPackages;
            synchronized (hashMap3) {
                this.grantPermissionsLPw(pkg, true, pkg.packageName);
                this.mSettings.disableSystemPackageLPw(pkg.packageName);
            }
        }
        return scannedPkg;
    }

    private static String fixProcessName(String defProcessName, String processName, int uid) {
        if (processName == null) {
            return defProcessName;
        }
        return processName;
    }

    private void verifySignaturesLP(PackageSetting pkgSetting, PackageParser.Package pkg) throws PackageManagerException {
        boolean match;
        if (pkgSetting.signatures.mSignatures != null) {
            boolean bl = match = PackageManagerService.compareSignatures(pkgSetting.signatures.mSignatures, pkg.mSignatures) == 0;
            if (!match) {
                boolean bl2 = match = this.compareSignaturesCompat(pkgSetting.signatures, pkg) == 0;
            }
            if (!match) {
                boolean bl3 = match = this.compareSignaturesRecover(pkgSetting.signatures, pkg) == 0;
            }
            if (!match) {
                throw new PackageManagerException(-7, "Package " + pkg.packageName + " signatures do not match the " + "previously installed version; ignoring!");
            }
        }
        if (pkgSetting.sharedUser != null && pkgSetting.sharedUser.signatures.mSignatures != null) {
            boolean bl = match = PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) == 0;
            if (!match) {
                boolean bl4 = match = this.compareSignaturesCompat(pkgSetting.sharedUser.signatures, pkg) == 0;
            }
            if (!match) {
                boolean bl5 = match = this.compareSignaturesRecover(pkgSetting.sharedUser.signatures, pkg) == 0;
            }
            if (!match) {
                throw new PackageManagerException(-8, "Package " + pkg.packageName + " has no signatures that match those in shared user " + pkgSetting.sharedUser.name + "; ignoring!");
            }
        }
    }

    private static final void enforceSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0) {
            throw new SecurityException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBootDexOpt() {
        HashSet<PackageParser.Package> pkgs;
        block19: {
            PackageManagerService.enforceSystemOrRoot("Only the system can request dexopt be performed");
            try {
                IMountService ms = PackageHelper.getMountService();
                if (ms != null) {
                    long timeSinceLast;
                    long interval = Settings.Global.getLong(this.mContext.getContentResolver(), "fstrim_mandatory_interval", 259200000L);
                    if (interval <= 0L || (timeSinceLast = System.currentTimeMillis() - ms.lastMaintenance()) <= interval) break block19;
                    Slog.w(TAG, "No disk maintenance in " + timeSinceLast + "; running immediately");
                    if (!this.isFirstBoot()) {
                        try {
                            ActivityManagerNative.getDefault().showBootMessage(this.mContext.getResources().getString(17040517), true);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    ms.runMaintenance();
                    break block19;
                }
                Slog.e(TAG, "Mount service unavailable!");
            }
            catch (RemoteException ms) {
                // empty catch block
            }
        }
        HashMap<String, PackageParser.Package> interval = this.mPackages;
        synchronized (interval) {
            pkgs = this.mDeferredDexOpt;
            this.mDeferredDexOpt = null;
        }
        if (pkgs != null) {
            PackageParser.Package pkg3;
            ArrayList<PackageParser.Package> sortedPkgs = new ArrayList<PackageParser.Package>();
            Iterator<PackageParser.Package> it = pkgs.iterator();
            while (it.hasNext()) {
                PackageParser.Package pkg2 = it.next();
                if (!pkg2.coreApp) continue;
                sortedPkgs.add(pkg2);
                it.remove();
            }
            Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
            HashSet<String> pkgNames = this.getPackageNamesForIntent(intent);
            Iterator<PackageParser.Package> it2 = pkgs.iterator();
            while (it2.hasNext()) {
                pkg3 = it2.next();
                if (!pkgNames.contains(pkg3.packageName)) continue;
                sortedPkgs.add(pkg3);
                it2.remove();
            }
            it2 = pkgs.iterator();
            while (it2.hasNext()) {
                pkg3 = it2.next();
                if (!PackageManagerService.isSystemApp(pkg3) || PackageManagerService.isUpdatedSystemApp(pkg3)) continue;
                sortedPkgs.add(pkg3);
                it2.remove();
            }
            it2 = pkgs.iterator();
            while (it2.hasNext()) {
                pkg3 = it2.next();
                if (!PackageManagerService.isUpdatedSystemApp(pkg3)) continue;
                sortedPkgs.add(pkg3);
                it2.remove();
            }
            intent = new Intent("android.intent.action.BOOT_COMPLETED");
            pkgNames = this.getPackageNamesForIntent(intent);
            it2 = pkgs.iterator();
            while (it2.hasNext()) {
                pkg3 = it2.next();
                if (!pkgNames.contains(pkg3.packageName)) continue;
                sortedPkgs.add(pkg3);
                it2.remove();
            }
            this.filterRecentlyUsedApps(pkgs);
            for (PackageParser.Package pkg3 : pkgs) {
                sortedPkgs.add(pkg3);
            }
            int i = 0;
            int total = sortedPkgs.size();
            File dataDir = Environment.getDataDirectory();
            long lowThreshold = StorageManager.from(this.mContext).getStorageLowBytes(dataDir);
            if (lowThreshold == 0L) {
                throw new IllegalStateException("Invalid low memory threshold");
            }
            for (PackageParser.Package pkg4 : sortedPkgs) {
                long usableSpace = dataDir.getUsableSpace();
                if (usableSpace < lowThreshold) {
                    Log.w(TAG, "Not running dexopt on remaining apps due to low memory: " + usableSpace);
                    break;
                }
                this.performBootDexOpt(pkg4, ++i, total);
            }
        }
    }

    private void filterRecentlyUsedApps(HashSet<PackageParser.Package> pkgs) {
        if (this.mLazyDexOpt || !this.isFirstBoot() && this.mPackageUsage.isHistoricalPackageUsageAvailable()) {
            long dexOptLRUThresholdInMinutes = this.mLazyDexOpt ? 30L : 10080L;
            long dexOptLRUThresholdInMills = dexOptLRUThresholdInMinutes * 60L * 1000L;
            int total = pkgs.size();
            int skipped = 0;
            long now = System.currentTimeMillis();
            Iterator<PackageParser.Package> i = pkgs.iterator();
            while (i.hasNext()) {
                PackageParser.Package pkg = i.next();
                long then = pkg.mLastPackageUsageTimeInMills;
                if (then + dexOptLRUThresholdInMills >= now) continue;
                i.remove();
                ++skipped;
            }
        }
    }

    private HashSet<String> getPackageNamesForIntent(Intent intent) {
        List<ResolveInfo> ris = null;
        try {
            ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        HashSet<String> pkgNames = new HashSet<String>();
        if (ris != null) {
            for (ResolveInfo ri : ris) {
                pkgNames.add(ri.activityInfo.packageName);
            }
        }
        return pkgNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performBootDexOpt(PackageParser.Package pkg, int curr, int total) {
        if (!this.isFirstBoot()) {
            try {
                ActivityManagerNative.getDefault().showBootMessage(this.mContext.getResources().getString(17040518, curr, total), true);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        PackageParser.Package p = pkg;
        Object object = this.mInstallLock;
        synchronized (object) {
            this.performDexOptLI(p, null, false, false, true);
        }
    }

    @Override
    public boolean performDexOptIfNeeded(String packageName, String instructionSet) {
        return this.performDexOpt(packageName, instructionSet, false);
    }

    private static String getPrimaryInstructionSet(ApplicationInfo info) {
        if (info.primaryCpuAbi == null) {
            return PackageManagerService.getPreferredInstructionSet();
        }
        return VMRuntime.getInstructionSet(info.primaryCpuAbi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performDexOpt(String packageName, String instructionSet, boolean backgroundDexopt) {
        String targetInstructionSet;
        PackageParser.Package p;
        boolean updateUsage;
        boolean dexopt = this.mLazyDexOpt || backgroundDexopt;
        boolean bl = updateUsage = !backgroundDexopt;
        if (!dexopt && !updateUsage) {
            return false;
        }
        Object object = this.mPackages;
        synchronized (object) {
            p = this.mPackages.get(packageName);
            if (p == null) {
                return false;
            }
            if (updateUsage) {
                p.mLastPackageUsageTimeInMills = System.currentTimeMillis();
            }
            this.mPackageUsage.write(false);
            if (!dexopt) {
                return false;
            }
            String string2 = targetInstructionSet = instructionSet != null ? instructionSet : PackageManagerService.getPrimaryInstructionSet(p.applicationInfo);
            if (p.mDexOptPerformed.contains(targetInstructionSet)) {
                return false;
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            String[] instructionSets = new String[]{targetInstructionSet};
            return this.performDexOptLI(p, instructionSets, false, false, true) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> getPackagesThatNeedDexOpt() {
        HashSet<String> pkgs = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (PackageParser.Package p : this.mPackages.values()) {
                if (!p.mDexOptPerformed.isEmpty()) continue;
                if (pkgs == null) {
                    pkgs = new HashSet<String>();
                }
                pkgs.add(p.packageName);
            }
        }
        return pkgs;
    }

    public void shutdown() {
        this.mPackageUsage.write(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDexOptLibsLI(ArrayList<String> libs, String[] instructionSets, boolean forceDex, boolean defer, HashSet<String> done) {
        for (int i = 0; i < libs.size(); ++i) {
            PackageParser.Package libPkg;
            String libName;
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                libName = libs.get(i);
                SharedLibraryEntry lib = this.mSharedLibraries.get(libName);
                libPkg = lib != null && lib.apk != null ? this.mPackages.get(lib.apk) : null;
            }
            if (libPkg == null || done.contains(libName)) continue;
            this.performDexOptLI(libPkg, instructionSets, forceDex, defer, done);
        }
    }

    private int performDexOptLI(PackageParser.Package pkg, String[] targetInstructionSets, boolean forceDex, boolean defer, HashSet<String> done) {
        String[] dexCodeInstructionSets;
        String[] instructionSets;
        String[] stringArray = instructionSets = targetInstructionSets != null ? targetInstructionSets : PackageManagerService.getAppDexInstructionSets(pkg.applicationInfo);
        if (done != null) {
            done.add(pkg.packageName);
            if (pkg.usesLibraries != null) {
                this.performDexOptLibsLI(pkg.usesLibraries, instructionSets, forceDex, defer, done);
            }
            if (pkg.usesOptionalLibraries != null) {
                this.performDexOptLibsLI(pkg.usesOptionalLibraries, instructionSets, forceDex, defer, done);
            }
        }
        if ((pkg.applicationInfo.flags & 4) == 0) {
            return 0;
        }
        boolean vmSafeMode = (pkg.applicationInfo.flags & 0x4000) != 0;
        List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
        boolean performedDexOpt = false;
        for (String dexCodeInstructionSet : dexCodeInstructionSets = PackageManagerService.getDexCodeInstructionSets(instructionSets)) {
            if (!forceDex && pkg.mDexOptPerformed.contains(dexCodeInstructionSet)) continue;
            for (String path : paths) {
                try {
                    int ret;
                    int sharedGid;
                    byte isDexOptNeeded = DexFile.isDexOptNeededInternal(path, pkg.packageName, dexCodeInstructionSet, defer);
                    if (forceDex || !defer && isDexOptNeeded == 2) {
                        Log.i(TAG, "Running dexopt on: " + path + " pkg=" + pkg.applicationInfo.packageName + " isa=" + dexCodeInstructionSet + " vmSafeMode=" + vmSafeMode);
                        sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
                        ret = this.mInstaller.dexopt(path, sharedGid, !PackageManagerService.isForwardLocked(pkg), pkg.packageName, dexCodeInstructionSet, vmSafeMode);
                        if (ret < 0) {
                            return -1;
                        }
                        performedDexOpt = true;
                    } else if (!defer && isDexOptNeeded == 1) {
                        Log.i(TAG, "Running patchoat on: " + pkg.applicationInfo.packageName);
                        sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
                        ret = this.mInstaller.patchoat(path, sharedGid, !PackageManagerService.isForwardLocked(pkg), pkg.packageName, dexCodeInstructionSet);
                        if (ret < 0) {
                            return -1;
                        }
                        performedDexOpt = true;
                    }
                    if (!defer || isDexOptNeeded == 0) continue;
                    if (this.mDeferredDexOpt == null) {
                        this.mDeferredDexOpt = new HashSet();
                    }
                    this.mDeferredDexOpt.add(pkg);
                    return 2;
                }
                catch (FileNotFoundException e) {
                    Slog.w(TAG, "Apk not found for dexopt: " + path);
                    return -1;
                }
                catch (IOException e) {
                    Slog.w(TAG, "IOException reading apk: " + path, e);
                    return -1;
                }
                catch (StaleDexCacheError e) {
                    Slog.w(TAG, "StaleDexCacheError when reading apk: " + path, e);
                    return -1;
                }
                catch (Exception e) {
                    Slog.w(TAG, "Exception when doing dexopt : ", e);
                    return -1;
                }
            }
            pkg.mDexOptPerformed.add(dexCodeInstructionSet);
        }
        return performedDexOpt ? 1 : 0;
    }

    private static String[] getAppDexInstructionSets(ApplicationInfo info) {
        if (info.primaryCpuAbi != null) {
            if (info.secondaryCpuAbi != null) {
                return new String[]{VMRuntime.getInstructionSet(info.primaryCpuAbi), VMRuntime.getInstructionSet(info.secondaryCpuAbi)};
            }
            return new String[]{VMRuntime.getInstructionSet(info.primaryCpuAbi)};
        }
        return new String[]{PackageManagerService.getPreferredInstructionSet()};
    }

    private static String[] getAppDexInstructionSets(PackageSetting ps) {
        if (ps.primaryCpuAbiString != null) {
            if (ps.secondaryCpuAbiString != null) {
                return new String[]{VMRuntime.getInstructionSet(ps.primaryCpuAbiString), VMRuntime.getInstructionSet(ps.secondaryCpuAbiString)};
            }
            return new String[]{VMRuntime.getInstructionSet(ps.primaryCpuAbiString)};
        }
        return new String[]{PackageManagerService.getPreferredInstructionSet()};
    }

    private static String getPreferredInstructionSet() {
        if (sPreferredInstructionSet == null) {
            sPreferredInstructionSet = VMRuntime.getInstructionSet(Build.SUPPORTED_ABIS[0]);
        }
        return sPreferredInstructionSet;
    }

    private static List<String> getAllInstructionSets() {
        String[] allAbis = Build.SUPPORTED_ABIS;
        ArrayList<String> allInstructionSets = new ArrayList<String>(allAbis.length);
        for (String abi : allAbis) {
            String instructionSet = VMRuntime.getInstructionSet(abi);
            if (allInstructionSets.contains(instructionSet)) continue;
            allInstructionSets.add(instructionSet);
        }
        return allInstructionSets;
    }

    private static String getDexCodeInstructionSet(String sharedLibraryIsa) {
        String dexCodeIsa = SystemProperties.get("ro.dalvik.vm.isa." + sharedLibraryIsa);
        return dexCodeIsa.isEmpty() ? sharedLibraryIsa : dexCodeIsa;
    }

    private static String[] getDexCodeInstructionSets(String[] instructionSets) {
        HashSet<String> dexCodeInstructionSets = new HashSet<String>(instructionSets.length);
        for (String instructionSet : instructionSets) {
            dexCodeInstructionSets.add(PackageManagerService.getDexCodeInstructionSet(instructionSet));
        }
        return dexCodeInstructionSets.toArray(new String[dexCodeInstructionSets.size()]);
    }

    public static String[] getAllDexCodeInstructionSets() {
        String[] supportedInstructionSets = new String[Build.SUPPORTED_ABIS.length];
        for (int i = 0; i < supportedInstructionSets.length; ++i) {
            String abi = Build.SUPPORTED_ABIS[i];
            supportedInstructionSets[i] = VMRuntime.getInstructionSet(abi);
        }
        return PackageManagerService.getDexCodeInstructionSets(supportedInstructionSets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceDexOpt(String packageName) {
        PackageParser.Package pkg;
        PackageManagerService.enforceSystemOrRoot("forceDexOpt");
        Object object = this.mPackages;
        synchronized (object) {
            pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Missing package: " + packageName);
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            String[] instructionSets = new String[]{PackageManagerService.getPrimaryInstructionSet(pkg.applicationInfo)};
            int res = this.performDexOptLI(pkg, instructionSets, true, false, true);
            if (res != 1) {
                throw new IllegalStateException("Failed to dexopt: " + res);
            }
        }
    }

    private int performDexOptLI(PackageParser.Package pkg, String[] instructionSets, boolean forceDex, boolean defer, boolean inclDependencies) {
        HashSet<String> done;
        if (inclDependencies && (pkg.usesLibraries != null || pkg.usesOptionalLibraries != null)) {
            done = new HashSet<String>();
            done.add(pkg.packageName);
        } else {
            done = null;
        }
        return this.performDexOptLI(pkg, instructionSets, forceDex, defer, done);
    }

    private boolean verifyPackageUpdateLPr(PackageSetting oldPkg, PackageParser.Package newPkg) {
        if ((oldPkg.pkgFlags & 1) == 0) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package not in system partition");
            return false;
        }
        if (this.mPackages.get(oldPkg.name) != null) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package still exists");
            return false;
        }
        return true;
    }

    File getDataPathForUser(int userId) {
        return new File(this.mUserAppDataDir.getAbsolutePath() + File.separator + userId);
    }

    private File getDataPathForPackage(String packageName, int userId) {
        if (userId == 0) {
            return new File(this.mAppDataDir, packageName);
        }
        return new File(this.mUserAppDataDir.getAbsolutePath() + File.separator + userId + File.separator + packageName);
    }

    private int createDataDirsLI(String packageName, int uid, String seinfo) {
        int[] users = sUserManager.getUserIds();
        int res = this.mInstaller.install(packageName, uid, uid, seinfo);
        if (res < 0) {
            return res;
        }
        for (int user : users) {
            if (user == 0 || (res = this.mInstaller.createUserData(packageName, UserHandle.getUid(user, uid), user, seinfo)) >= 0) continue;
            return res;
        }
        return res;
    }

    private int removeDataDirsLI(String packageName) {
        int[] users = sUserManager.getUserIds();
        int res = 0;
        for (int user : users) {
            int resInner = this.mInstaller.remove(packageName, user);
            if (resInner >= 0) continue;
            res = resInner;
        }
        return res;
    }

    private int deleteCodeCacheDirsLI(String packageName) {
        int[] users = sUserManager.getUserIds();
        int res = 0;
        for (int user : users) {
            int resInner = this.mInstaller.deleteCodeCacheFiles(packageName, user);
            if (resInner >= 0) continue;
            res = resInner;
        }
        return res;
    }

    private void addSharedLibraryLPw(ArraySet<String> usesLibraryFiles, SharedLibraryEntry file, PackageParser.Package changingLib) {
        if (file.path != null) {
            usesLibraryFiles.add(file.path);
            return;
        }
        PackageParser.Package p = this.mPackages.get(file.apk);
        if (changingLib != null && changingLib.packageName.equals(file.apk) && (p == null || p.packageName.equals(changingLib.packageName))) {
            p = changingLib;
        }
        if (p != null) {
            usesLibraryFiles.addAll(p.getAllCodePaths());
        }
    }

    private void updateSharedLibrariesLPw(PackageParser.Package pkg, PackageParser.Package changingLib) throws PackageManagerException {
        if (pkg.usesLibraries != null || pkg.usesOptionalLibraries != null) {
            SharedLibraryEntry file;
            int i;
            ArraySet<String> usesLibraryFiles = new ArraySet<String>();
            int N = pkg.usesLibraries != null ? pkg.usesLibraries.size() : 0;
            for (i = 0; i < N; ++i) {
                file = this.mSharedLibraries.get(pkg.usesLibraries.get(i));
                if (file == null) {
                    throw new PackageManagerException(-9, "Package " + pkg.packageName + " requires unavailable shared library " + pkg.usesLibraries.get(i) + "; failing!");
                }
                this.addSharedLibraryLPw(usesLibraryFiles, file, changingLib);
            }
            N = pkg.usesOptionalLibraries != null ? pkg.usesOptionalLibraries.size() : 0;
            for (i = 0; i < N; ++i) {
                file = this.mSharedLibraries.get(pkg.usesOptionalLibraries.get(i));
                if (file == null) {
                    Slog.w(TAG, "Package " + pkg.packageName + " desires unavailable shared library " + pkg.usesOptionalLibraries.get(i) + "; ignoring!");
                    continue;
                }
                this.addSharedLibraryLPw(usesLibraryFiles, file, changingLib);
            }
            N = usesLibraryFiles.size();
            pkg.usesLibraryFiles = N > 0 ? usesLibraryFiles.toArray(new String[N]) : null;
        }
    }

    private static boolean hasString(List<String> list, List<String> which) {
        if (list == null) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            for (int j = which.size() - 1; j >= 0; --j) {
                if (!which.get(j).equals(list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateAllSharedLibrariesLPw() {
        for (PackageParser.Package pkg : this.mPackages.values()) {
            try {
                this.updateSharedLibrariesLPw(pkg, null);
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
            }
        }
    }

    private ArrayList<PackageParser.Package> updateAllSharedLibrariesLPw(PackageParser.Package changingPkg) {
        ArrayList<PackageParser.Package> res = null;
        for (PackageParser.Package pkg : this.mPackages.values()) {
            if (!PackageManagerService.hasString(pkg.usesLibraries, changingPkg.libraryNames) && !PackageManagerService.hasString(pkg.usesOptionalLibraries, changingPkg.libraryNames)) continue;
            if (res == null) {
                res = new ArrayList<PackageParser.Package>();
            }
            res.add(pkg);
            try {
                this.updateSharedLibrariesLPw(pkg, changingPkg);
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
            }
        }
        return res;
    }

    private static String deriveAbiOverride(String abiOverride, PackageSetting settings) {
        String cpuAbiOverride = null;
        if (INSTALL_PACKAGE_SUFFIX.equals(abiOverride)) {
            cpuAbiOverride = null;
        } else if (abiOverride != null) {
            cpuAbiOverride = abiOverride;
        } else if (settings != null) {
            cpuAbiOverride = settings.cpuAbiOverrideString;
        }
        return cpuAbiOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        boolean success = false;
        try {
            PackageParser.Package res = this.scanPackageDirtyLI(pkg, parseFlags, scanFlags, currentTime, user);
            success = true;
            PackageParser.Package package_ = res;
            return package_;
        }
        finally {
            if (!success && (scanFlags & 0x400) != 0) {
                this.removeDataDirsLI(pkg.packageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageDirtyLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        Object nativeLibraryRootStr;
        File dataPath;
        File scanFile = new File(pkg.codePath);
        if (pkg.applicationInfo.getCodePath() == null || pkg.applicationInfo.getResourcePath() == null) {
            throw new PackageManagerException(-2, "Code and resource paths haven't been set correctly");
        }
        if ((parseFlags & 1) != 0) {
            pkg.applicationInfo.flags |= 1;
        } else {
            pkg.coreApp = false;
        }
        if ((parseFlags & 0x80) != 0) {
            pkg.applicationInfo.flags |= 0x40000000;
        }
        if (this.mCustomResolverComponentName != null && this.mCustomResolverComponentName.getPackageName().equals(pkg.packageName)) {
            this.setUpCustomResolverActivity(pkg);
        }
        if (pkg.packageName.equals("android")) {
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                if (this.mAndroidApplication != null) {
                    Slog.w(TAG, "*************************************************");
                    Slog.w(TAG, "Core android package being redefined.  Skipping.");
                    Slog.w(TAG, " file=" + scanFile);
                    Slog.w(TAG, "*************************************************");
                    throw new PackageManagerException(-5, "Core android package being redefined.  Skipping.");
                }
                this.mPlatformPackage = pkg;
                pkg.mVersionCode = this.mSdkVersion;
                this.mAndroidApplication = pkg.applicationInfo;
                if (!this.mResolverReplaced) {
                    this.mResolveActivity.applicationInfo = this.mAndroidApplication;
                    this.mResolveActivity.name = ResolverActivity.class.getName();
                    this.mResolveActivity.packageName = this.mAndroidApplication.packageName;
                    this.mResolveActivity.processName = "system:ui";
                    this.mResolveActivity.launchMode = 0;
                    this.mResolveActivity.documentLaunchMode = 3;
                    this.mResolveActivity.flags = 32;
                    this.mResolveActivity.theme = 16974975;
                    this.mResolveActivity.exported = true;
                    this.mResolveActivity.enabled = true;
                    this.mResolveInfo.activityInfo = this.mResolveActivity;
                    this.mResolveInfo.priority = 0;
                    this.mResolveInfo.preferredOrder = 0;
                    this.mResolveInfo.match = 0;
                    this.mResolveComponentName = new ComponentName(this.mAndroidApplication.packageName, this.mResolveActivity.name);
                }
            }
        }
        if (this.mPackages.containsKey(pkg.packageName) || this.mSharedLibraries.containsKey(pkg.packageName)) {
            throw new PackageManagerException(-5, "Application package " + pkg.packageName + " already installed.  Skipping duplicate.");
        }
        File destCodeFile = new File(pkg.applicationInfo.getCodePath());
        File destResourceFile = new File(pkg.applicationInfo.getResourcePath());
        SharedUserSetting suid = null;
        PackageSetting pkgSetting = null;
        if (!PackageManagerService.isSystemApp(pkg)) {
            pkg.mOriginalPackages = null;
            pkg.mRealPackage = null;
            pkg.mAdoptPermissions = null;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (pkg.mSharedUserId != null && (suid = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, true)) == null) {
                throw new PackageManagerException(-4, "Creating application package " + pkg.packageName + " for shared user failed");
            }
            PackageSetting origPackage = null;
            String realName = null;
            if (pkg.mOriginalPackages != null) {
                String renamed = this.mSettings.mRenamedPackages.get(pkg.mRealPackage);
                if (pkg.mOriginalPackages.contains(renamed)) {
                    realName = pkg.mRealPackage;
                    if (!pkg.packageName.equals(renamed)) {
                        pkg.setPackageName(renamed);
                    }
                } else {
                    for (int i = pkg.mOriginalPackages.size() - 1; i >= 0; --i) {
                        origPackage = this.mSettings.peekPackageLPr(pkg.mOriginalPackages.get(i));
                        if (origPackage == null) continue;
                        if (!this.verifyPackageUpdateLPr(origPackage, pkg)) {
                            origPackage = null;
                            continue;
                        }
                        if (origPackage.sharedUser == null || origPackage.sharedUser.name.equals(pkg.mSharedUserId)) break;
                        Slog.w(TAG, "Unable to migrate data from " + origPackage.name + " to " + pkg.packageName + ": old uid " + origPackage.sharedUser.name + " differs from " + pkg.mSharedUserId);
                        origPackage = null;
                    }
                }
            }
            if (this.mTransferedPackages.contains(pkg.packageName)) {
                Slog.w(TAG, "Package " + pkg.packageName + " was transferred to another, but its .apk remains");
            }
            if ((pkgSetting = this.mSettings.getPackageLPw(pkg, origPackage, realName, suid, destCodeFile, destResourceFile, pkg.applicationInfo.nativeLibraryRootDir, pkg.applicationInfo.primaryCpuAbi, pkg.applicationInfo.secondaryCpuAbi, pkg.applicationInfo.flags, user, false)) == null) {
                throw new PackageManagerException(-4, "Creating application package " + pkg.packageName + " failed");
            }
            if (pkgSetting.origPackage != null) {
                pkg.setPackageName(origPackage.name);
                String msg = "New package " + pkgSetting.realName + " renamed to replace old package " + pkgSetting.name;
                PackageManagerService.reportSettingsProblem(5, msg);
                this.mTransferedPackages.add(origPackage.name);
                pkgSetting.origPackage = null;
            }
            if (realName != null) {
                this.mTransferedPackages.add(pkg.packageName);
            }
            if (this.mSettings.isDisabledSystemPackageLPr(pkg.packageName)) {
                pkg.applicationInfo.flags |= 0x80;
            }
            if ((parseFlags & 0x40) == 0) {
                this.updateSharedLibrariesLPw(pkg, null);
            }
            if (this.mFoundPolicyFile) {
                SELinuxMMAC.assignSeinfoValue(pkg);
            }
            pkg.applicationInfo.uid = pkgSetting.appId;
            pkg.mExtras = pkgSetting;
            if (!pkgSetting.keySetData.isUsingUpgradeKeySets() || pkgSetting.sharedUser != null) {
                try {
                    this.verifySignaturesLP(pkgSetting, pkg);
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                }
                catch (PackageManagerException e) {
                    if ((parseFlags & 0x40) == 0) {
                        throw e;
                    }
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                    if (pkgSetting.sharedUser != null && PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) != 0) {
                        throw new PackageManagerException(-104, "Signature mismatch for shared user : " + pkgSetting.sharedUser);
                    }
                    String msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
            } else {
                if (!this.checkUpgradeKeySetLP(pkgSetting, pkg)) {
                    throw new PackageManagerException(-7, "Package " + pkg.packageName + " upgrade keys do not match the " + "previously installed version");
                }
                pkgSetting.signatures.mSignatures = pkg.mSignatures;
            }
            if ((scanFlags & 0x10) != 0) {
                int N = pkg.providers.size();
                for (int i = 0; i < N; ++i) {
                    PackageParser.Provider p = pkg.providers.get(i);
                    if (p.info.authority == null) continue;
                    String[] names = p.info.authority.split(";");
                    for (int j = 0; j < names.length; ++j) {
                        if (!this.mProvidersByAuthority.containsKey(names[j])) continue;
                        PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                        String otherPackageName = other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?";
                        throw new PackageManagerException(-13, "Can't install because provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + ") is already used by " + otherPackageName);
                    }
                }
            }
            if (pkg.mAdoptPermissions != null) {
                for (int i = pkg.mAdoptPermissions.size() - 1; i >= 0; --i) {
                    String origName = pkg.mAdoptPermissions.get(i);
                    PackageSetting orig = this.mSettings.peekPackageLPr(origName);
                    if (orig == null || !this.verifyPackageUpdateLPr(orig, pkg)) continue;
                    Slog.i(TAG, "Adopting permissions from " + origName + " to " + pkg.packageName);
                    this.mSettings.transferPermissionsLPw(origName, pkg.packageName);
                }
            }
        }
        String pkgName = pkg.packageName;
        long scanFileTime = scanFile.lastModified();
        boolean forceDex = (scanFlags & 4) != 0;
        pkg.applicationInfo.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.packageName, pkg.applicationInfo.processName, pkg.applicationInfo.uid);
        if (this.mPlatformPackage == pkg) {
            dataPath = new File(Environment.getDataDirectory(), "system");
            pkg.applicationInfo.dataDir = dataPath.getPath();
        } else {
            dataPath = this.getDataPathForPackage(pkg.packageName, 0);
            boolean uidError = false;
            if (dataPath.exists()) {
                int currentUid = 0;
                try {
                    StructStat stat = Os.stat(dataPath.getPath());
                    currentUid = stat.st_uid;
                }
                catch (ErrnoException e) {
                    Slog.e(TAG, "Couldn't stat path " + dataPath.getPath(), e);
                }
                if (currentUid != pkg.applicationInfo.uid) {
                    Object prefix;
                    int ret;
                    boolean recovered = false;
                    if (currentUid == 0 && (ret = this.mInstaller.fixUid(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.uid)) >= 0) {
                        recovered = true;
                        String msg = "Package " + pkg.packageName + " unexpectedly changed to uid 0; recovered to " + pkg.applicationInfo.uid;
                        PackageManagerService.reportSettingsProblem(5, msg);
                    }
                    if (!(recovered || (parseFlags & 1) == 0 && (scanFlags & 0x100) == 0)) {
                        ret = this.removeDataDirsLI(pkgName);
                        if (ret >= 0) {
                            prefix = (parseFlags & 1) != 0 ? "System package " : "Third party package ";
                            String msg = (String)prefix + pkg.packageName + " has changed from uid: " + currentUid + " to " + pkg.applicationInfo.uid + "; old data erased";
                            PackageManagerService.reportSettingsProblem(5, msg);
                            recovered = true;
                            ret = this.createDataDirsLI(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.seinfo);
                            if (ret == -1) {
                                msg = (String)prefix + pkg.packageName + " could not have data directory re-created after delete.";
                                PackageManagerService.reportSettingsProblem(5, msg);
                                throw new PackageManagerException(-4, msg);
                            }
                        }
                        if (!recovered) {
                            this.mHasSystemUidErrors = true;
                        }
                    } else if (!recovered) {
                        throw new PackageManagerException(-24, "scanPackageLI");
                    }
                    if (!recovered) {
                        pkg.applicationInfo.nativeLibraryDir = pkg.applicationInfo.dataDir = "/mismatched_uid/settings_" + pkg.applicationInfo.uid + "/fs_" + currentUid;
                        pkg.applicationInfo.nativeLibraryRootDir = pkg.applicationInfo.dataDir;
                        String msg = "Package " + pkg.packageName + " has mismatched uid: " + currentUid + " on disk, " + pkg.applicationInfo.uid + " in settings";
                        prefix = this.mPackages;
                        synchronized (prefix) {
                            this.mSettings.mReadMessages.append(msg);
                            this.mSettings.mReadMessages.append('\n');
                            uidError = true;
                            if (!pkgSetting.uidError) {
                                PackageManagerService.reportSettingsProblem(6, msg);
                            }
                        }
                    }
                }
                pkg.applicationInfo.dataDir = dataPath.getPath();
                if (this.mShouldRestoreconData) {
                    Slog.i(TAG, "SELinux relabeling of " + pkg.packageName + " issued.");
                    this.mInstaller.restoreconData(pkg.packageName, pkg.applicationInfo.seinfo, pkg.applicationInfo.uid);
                }
            } else {
                int ret = this.createDataDirsLI(pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.seinfo);
                if (ret < 0) {
                    throw new PackageManagerException(-4, "Unable to create data dirs [errorCode=" + ret + "]");
                }
                if (dataPath.exists()) {
                    pkg.applicationInfo.dataDir = dataPath.getPath();
                } else {
                    Slog.w(TAG, "Unable to create data directory: " + dataPath);
                    pkg.applicationInfo.dataDir = null;
                }
            }
            pkgSetting.uidError = uidError;
        }
        String path = scanFile.getPath();
        String codePath = pkg.applicationInfo.getCodePath();
        String cpuAbiOverride = PackageManagerService.deriveAbiOverride(pkg.cpuAbiOverride, pkgSetting);
        if (PackageManagerService.isSystemApp(pkg) && !PackageManagerService.isUpdatedSystemApp(pkg)) {
            this.setBundledAppAbisAndRoots(pkg, pkgSetting);
            if (pkg.applicationInfo.primaryCpuAbi == null && pkg.applicationInfo.secondaryCpuAbi == null && Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                NativeLibraryHelper.Handle handle = null;
                try {
                    handle = NativeLibraryHelper.Handle.create(scanFile);
                    if (NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                        pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
                    }
                }
                catch (IOException ioe) {
                    Slog.w(TAG, "Error scanning system app : " + ioe);
                }
                finally {
                    IoUtils.closeQuietly(handle);
                }
            }
            this.setNativeLibraryPaths(pkg);
        } else {
            this.setNativeLibraryPaths(pkg);
            boolean isAsec = PackageManagerService.isForwardLocked(pkg) || PackageManagerService.isExternal(pkg);
            nativeLibraryRootStr = pkg.applicationInfo.nativeLibraryRootDir;
            boolean useIsaSpecificSubdirs = pkg.applicationInfo.nativeLibraryRootRequiresIsa;
            NativeLibraryHelper.Handle handle = null;
            try {
                handle = NativeLibraryHelper.Handle.create(scanFile);
                File nativeLibraryRoot = new File((String)nativeLibraryRootStr);
                pkg.applicationInfo.primaryCpuAbi = null;
                pkg.applicationInfo.secondaryCpuAbi = null;
                if (PackageManagerService.isMultiArch(pkg.applicationInfo)) {
                    if (pkg.cpuAbiOverride != null && !INSTALL_PACKAGE_SUFFIX.equals(pkg.cpuAbiOverride)) {
                        Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
                    }
                    int abi32 = -114;
                    int abi64 = -114;
                    if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                        abi32 = isAsec ? NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_32_BIT_ABIS) : NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_32_BIT_ABIS, useIsaSpecificSubdirs);
                    }
                    PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 32 bit native libs for multiarch app.", abi32);
                    if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                        abi64 = isAsec ? NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_64_BIT_ABIS) : NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_64_BIT_ABIS, useIsaSpecificSubdirs);
                    }
                    PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 64 bit native libs for multiarch app.", abi64);
                    if (abi64 >= 0) {
                        pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[abi64];
                    }
                    if (abi32 >= 0) {
                        String abi = Build.SUPPORTED_32_BIT_ABIS[abi32];
                        if (abi64 >= 0) {
                            pkg.applicationInfo.secondaryCpuAbi = abi;
                        } else {
                            pkg.applicationInfo.primaryCpuAbi = abi;
                        }
                    }
                } else {
                    int copyRet;
                    String[] stringArray;
                    if (cpuAbiOverride != null) {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = cpuAbiOverride;
                    } else {
                        stringArray = Build.SUPPORTED_ABIS;
                    }
                    String[] abiList = stringArray;
                    boolean needsRenderScriptOverride = false;
                    if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                        abiList = Build.SUPPORTED_32_BIT_ABIS;
                        needsRenderScriptOverride = true;
                    }
                    if ((copyRet = isAsec ? NativeLibraryHelper.findSupportedAbi(handle, abiList) : NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, abiList, useIsaSpecificSubdirs)) < 0 && copyRet != -114) {
                        throw new PackageManagerException(-110, "Error unpackaging native libs for app, errorCode=" + copyRet);
                    }
                    if (copyRet >= 0) {
                        pkg.applicationInfo.primaryCpuAbi = abiList[copyRet];
                    } else if (copyRet == -114 && cpuAbiOverride != null) {
                        pkg.applicationInfo.primaryCpuAbi = cpuAbiOverride;
                    } else if (needsRenderScriptOverride) {
                        pkg.applicationInfo.primaryCpuAbi = abiList[0];
                    }
                }
            }
            catch (IOException ioe) {
                Slog.e(TAG, "Unable to get canonical file " + ioe.toString());
            }
            finally {
                IoUtils.closeQuietly(handle);
            }
            this.setNativeLibraryPaths(pkg);
            int[] userIds = sUserManager.getUserIds();
            Object abiList = this.mInstallLock;
            synchronized (abiList) {
                if (pkg.applicationInfo.primaryCpuAbi != null && !VMRuntime.is64BitAbi(pkg.applicationInfo.primaryCpuAbi)) {
                    String nativeLibPath = pkg.applicationInfo.nativeLibraryDir;
                    for (int userId : userIds) {
                        if (this.mInstaller.linkNativeLibraryDirectory(pkg.packageName, nativeLibPath, userId) >= 0) continue;
                        throw new PackageManagerException(-110, "Failed linking native library dir (user=" + userId + ")");
                    }
                }
            }
        }
        if (this.mPlatformPackage == pkg) {
            pkg.applicationInfo.primaryCpuAbi = VMRuntime.getRuntime().is64Bit() ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        }
        pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
        pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        pkgSetting.cpuAbiOverrideString = cpuAbiOverride;
        pkg.cpuAbiOverride = cpuAbiOverride;
        pkgSetting.legacyNativeLibraryPathString = pkg.applicationInfo.nativeLibraryRootDir;
        if ((scanFlags & 0x100) == 0 && pkgSetting.sharedUser != null) {
            this.adjustCpuAbisForSharedUserLPw(pkgSetting.sharedUser.packages, pkg, forceDex, (scanFlags & 0x80) != 0);
        }
        if ((scanFlags & 2) == 0 && this.performDexOptLI(pkg, null, forceDex, (scanFlags & 0x80) != 0, false) == -1) {
            throw new PackageManagerException(-11, "scanPackageLI");
        }
        if (this.mFactoryTest && pkg.requestedPermissions.contains("android.permission.FACTORY_TEST")) {
            pkg.applicationInfo.flags |= 0x10;
        }
        ArrayList<PackageParser.Package> clientLibPkgs = null;
        nativeLibraryRootStr = this.mPackages;
        synchronized (nativeLibraryRootStr) {
            if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
                for (int i = 0; i < pkg.libraryNames.size(); ++i) {
                    String name = pkg.libraryNames.get(i);
                    boolean allowed = false;
                    if (PackageManagerService.isUpdatedSystemApp(pkg)) {
                        PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                        if (sysPs.pkg != null && sysPs.pkg.libraryNames != null) {
                            for (int j = 0; j < sysPs.pkg.libraryNames.size(); ++j) {
                                if (!name.equals(sysPs.pkg.libraryNames.get(j))) continue;
                                allowed = true;
                                allowed = true;
                                break;
                            }
                        }
                    } else {
                        allowed = true;
                    }
                    if (allowed) {
                        if (!this.mSharedLibraries.containsKey(name)) {
                            this.mSharedLibraries.put(name, new SharedLibraryEntry(null, pkg.packageName));
                            continue;
                        }
                        if (name.equals(pkg.packageName)) continue;
                        Slog.w(TAG, "Package " + pkg.packageName + " library " + name + " already exists; skipping");
                        continue;
                    }
                    Slog.w(TAG, "Package " + pkg.packageName + " declares lib " + name + " that is not declared on system image; skipping");
                }
                if ((scanFlags & 0x100) == 0) {
                    clientLibPkgs = this.updateAllSharedLibrariesLPw(pkg);
                }
            }
        }
        if (clientLibPkgs != null && (scanFlags & 2) == 0) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = clientLibPkgs.get(i);
                if (this.performDexOptLI(clientPkg, null, forceDex, (scanFlags & 0x80) != 0, false) != -1) continue;
                throw new PackageManagerException(-11, "scanPackageLI failed to dexopt clientLibPkgs");
            }
        }
        if ((scanFlags & 0x800) != 0) {
            this.killApplication(pkg.applicationInfo.packageName, pkg.applicationInfo.uid, "update pkg");
        }
        if (clientLibPkgs != null) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = clientLibPkgs.get(i);
                this.killApplication(clientPkg.applicationInfo.packageName, clientPkg.applicationInfo.uid, "update lib");
            }
        }
        HashMap<String, PackageParser.Package> hashMap2 = this.mPackages;
        synchronized (hashMap2) {
            PackageParser.Component a;
            PackageParser.Component p;
            int i;
            this.mSettings.insertPackageSettingLPw(pkgSetting, pkg);
            this.mPackages.put(pkg.applicationInfo.packageName, pkg);
            Iterator<PackageCleanItem> iter = this.mSettings.mPackagesToBeCleaned.iterator();
            while (iter.hasNext()) {
                PackageCleanItem item = iter.next();
                if (!pkgName.equals(item.packageName)) continue;
                iter.remove();
            }
            if (currentTime != 0L) {
                if (pkgSetting.firstInstallTime == 0L) {
                    pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = currentTime;
                } else if ((scanFlags & 0x40) != 0) {
                    pkgSetting.lastUpdateTime = currentTime;
                }
            } else if (pkgSetting.firstInstallTime == 0L) {
                pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = scanFileTime;
            } else if ((parseFlags & 0x40) != 0 && scanFileTime != pkgSetting.timeStamp) {
                pkgSetting.lastUpdateTime = scanFileTime;
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            try {
                ksms.removeAppKeySetDataLPw(pkg.packageName);
                ksms.addSigningKeySetToPackageLPw(pkg.packageName, pkg.mSigningKeys);
                if (pkg.mKeySetMapping != null) {
                    for (Map.Entry<String, ArraySet<PublicKey>> entry : pkg.mKeySetMapping.entrySet()) {
                        if (entry.getValue() == null) continue;
                        ksms.addDefinedKeySetToPackageLPw(pkg.packageName, entry.getValue(), entry.getKey());
                    }
                    if (pkg.mUpgradeKeySets != null) {
                        for (String upgradeAlias : pkg.mUpgradeKeySets) {
                            ksms.addUpgradeKeySetToPackageLPw(pkg.packageName, upgradeAlias);
                        }
                    }
                }
            }
            catch (NullPointerException e) {
                Slog.e(TAG, "Could not add KeySet to " + pkg.packageName, e);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Could not add KeySet to malformed package" + pkg.packageName, e);
            }
            int N = pkg.providers.size();
            StringBuilder r = null;
            for (i = 0; i < N; ++i) {
                p = pkg.providers.get(i);
                p.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, p.info.processName, pkg.applicationInfo.uid);
                this.mProviders.addProvider((PackageParser.Provider)p);
                p.syncable = p.info.isSyncable;
                if (p.info.authority != null) {
                    String[] names = p.info.authority.split(";");
                    p.info.authority = null;
                    for (int j = 0; j < names.length; ++j) {
                        if (j == 1 && p.syncable) {
                            p = new PackageParser.Provider((PackageParser.Provider)p);
                            p.syncable = false;
                        }
                        if (!this.mProvidersByAuthority.containsKey(names[j])) {
                            this.mProvidersByAuthority.put(names[j], (PackageParser.Provider)p);
                            if (p.info.authority == null) {
                                p.info.authority = names[j];
                                continue;
                            }
                            p.info.authority = p.info.authority + ";" + names[j];
                            continue;
                        }
                        PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                        Slog.w(TAG, "Skipping provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + "): name already used by " + (other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?"));
                    }
                }
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(p.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.services.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Service s = pkg.services.get(i);
                s.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, s.info.processName, pkg.applicationInfo.uid);
                this.mServices.addService(s);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(s.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.receivers.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = pkg.receivers.get(i);
                ((PackageParser.Activity)a).info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, ((PackageParser.Activity)a).info.processName, pkg.applicationInfo.uid);
                this.mReceivers.addActivity((PackageParser.Activity)a, "receiver");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(((PackageParser.Activity)a).info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.activities.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = pkg.activities.get(i);
                ((PackageParser.Activity)a).info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, ((PackageParser.Activity)a).info.processName, pkg.applicationInfo.uid);
                this.mActivities.addActivity((PackageParser.Activity)a, "activity");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(((PackageParser.Activity)a).info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissionGroups.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.PermissionGroup pg = pkg.permissionGroups.get(i);
                PackageParser.PermissionGroup cur = this.mPermissionGroups.get(pg.info.name);
                if (cur == null) {
                    this.mPermissionGroups.put(pg.info.name, pg);
                    if ((parseFlags & 2) == 0) continue;
                    if (r == null) {
                        r = new StringBuilder(256);
                    } else {
                        r.append(' ');
                    }
                    r.append(pg.info.name);
                    continue;
                }
                Slog.w(TAG, "Permission group " + pg.info.name + " from package " + pg.info.packageName + " ignored: original from " + cur.info.packageName);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append("DUP:");
                r.append(pg.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissions.size();
            r = null;
            for (i = 0; i < N; ++i) {
                p = pkg.permissions.get(i);
                HashMap<String, BasePermission> permissionMap = ((PackageParser.Permission)p).tree ? this.mSettings.mPermissionTrees : this.mSettings.mPermissions;
                ((PackageParser.Permission)p).group = this.mPermissionGroups.get(((PackageParser.Permission)p).info.group);
                if (((PackageParser.Permission)p).info.group == null || ((PackageParser.Permission)p).group != null) {
                    BasePermission bp = permissionMap.get(((PackageParser.Permission)p).info.name);
                    if (bp != null && !Objects.equals(bp.sourcePackage, ((PackageParser.Permission)p).info.packageName)) {
                        boolean currentOwnerIsSystem;
                        boolean bl = currentOwnerIsSystem = bp.perm != null && PackageManagerService.isSystemApp(bp.perm.owner);
                        if (PackageManagerService.isSystemApp(((PackageParser.Permission)p).owner)) {
                            if (bp.type == 1 && bp.perm == null) {
                                bp.packageSetting = pkgSetting;
                                bp.perm = p;
                                bp.uid = pkg.applicationInfo.uid;
                                bp.sourcePackage = ((PackageParser.Permission)p).info.packageName;
                            } else if (!currentOwnerIsSystem) {
                                String msg = "New decl " + ((PackageParser.Permission)p).owner + " of permission  " + ((PackageParser.Permission)p).info.name + " is system; overriding " + bp.sourcePackage;
                                PackageManagerService.reportSettingsProblem(5, msg);
                                bp = null;
                            }
                        }
                    }
                    if (bp == null) {
                        bp = new BasePermission(((PackageParser.Permission)p).info.name, ((PackageParser.Permission)p).info.packageName, 0);
                        permissionMap.put(((PackageParser.Permission)p).info.name, bp);
                    }
                    if (bp.perm == null) {
                        if (bp.sourcePackage == null || bp.sourcePackage.equals(((PackageParser.Permission)p).info.packageName)) {
                            BasePermission tree = this.findPermissionTreeLP(((PackageParser.Permission)p).info.name);
                            if (tree == null || tree.sourcePackage.equals(((PackageParser.Permission)p).info.packageName)) {
                                bp.packageSetting = pkgSetting;
                                bp.perm = p;
                                bp.uid = pkg.applicationInfo.uid;
                                bp.sourcePackage = ((PackageParser.Permission)p).info.packageName;
                                if ((parseFlags & 2) != 0) {
                                    if (r == null) {
                                        r = new StringBuilder(256);
                                    } else {
                                        r.append(' ');
                                    }
                                    r.append(((PackageParser.Permission)p).info.name);
                                }
                            } else {
                                Slog.w(TAG, "Permission " + ((PackageParser.Permission)p).info.name + " from package " + ((PackageParser.Permission)p).info.packageName + " ignored: base tree " + tree.name + " is from package " + tree.sourcePackage);
                            }
                        } else {
                            Slog.w(TAG, "Permission " + ((PackageParser.Permission)p).info.name + " from package " + ((PackageParser.Permission)p).info.packageName + " ignored: original from " + bp.sourcePackage);
                        }
                    } else if ((parseFlags & 2) != 0) {
                        if (r == null) {
                            r = new StringBuilder(256);
                        } else {
                            r.append(' ');
                        }
                        r.append("DUP:");
                        r.append(((PackageParser.Permission)p).info.name);
                    }
                    if (bp.perm != p) continue;
                    bp.protectionLevel = ((PackageParser.Permission)p).info.protectionLevel;
                    continue;
                }
                Slog.w(TAG, "Permission " + ((PackageParser.Permission)p).info.name + " from package " + ((PackageParser.Permission)p).info.packageName + " ignored: no group " + ((PackageParser.Permission)p).group);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.instrumentation.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = pkg.instrumentation.get(i);
                ((PackageParser.Instrumentation)a).info.packageName = pkg.applicationInfo.packageName;
                ((PackageParser.Instrumentation)a).info.sourceDir = pkg.applicationInfo.sourceDir;
                ((PackageParser.Instrumentation)a).info.publicSourceDir = pkg.applicationInfo.publicSourceDir;
                ((PackageParser.Instrumentation)a).info.splitSourceDirs = pkg.applicationInfo.splitSourceDirs;
                ((PackageParser.Instrumentation)a).info.splitPublicSourceDirs = pkg.applicationInfo.splitPublicSourceDirs;
                ((PackageParser.Instrumentation)a).info.dataDir = pkg.applicationInfo.dataDir;
                ((PackageParser.Instrumentation)a).info.nativeLibraryDir = pkg.applicationInfo.nativeLibraryDir;
                this.mInstrumentation.put(a.getComponentName(), (PackageParser.Instrumentation)a);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(((PackageParser.Instrumentation)a).info.name);
            }
            if (r != null) {
                // empty if block
            }
            if (pkg.protectedBroadcasts != null) {
                N = pkg.protectedBroadcasts.size();
                for (i = 0; i < N; ++i) {
                    this.mProtectedBroadcasts.add(pkg.protectedBroadcasts.get(i));
                }
            }
            pkgSetting.setTimeStamp(scanFileTime);
            if (pkg.mOverlayTarget != null) {
                if (pkg.mOverlayTarget != null && !pkg.mOverlayTarget.equals("android")) {
                    if (!this.mOverlays.containsKey(pkg.mOverlayTarget)) {
                        this.mOverlays.put(pkg.mOverlayTarget, new HashMap());
                    }
                    HashMap<String, PackageParser.Package> map = this.mOverlays.get(pkg.mOverlayTarget);
                    map.put(pkg.packageName, pkg);
                    PackageParser.Package orig = this.mPackages.get(pkg.mOverlayTarget);
                    if (orig != null && !this.createIdmapForPackagePairLI(orig, pkg)) {
                        throw new PackageManagerException(-7, "scanPackageLI failed to createIdmap");
                    }
                }
            } else if (this.mOverlays.containsKey(pkg.packageName) && !pkg.packageName.equals("android")) {
                this.createIdmapsForPackageLI(pkg);
            }
        }
        return pkg;
    }

    private void adjustCpuAbisForSharedUserLPw(Set<PackageSetting> packagesForUser, PackageParser.Package scannedPackage, boolean forceDexOpt, boolean deferDexOpt) {
        String requiredInstructionSet = null;
        if (scannedPackage != null && scannedPackage.applicationInfo.primaryCpuAbi != null) {
            requiredInstructionSet = VMRuntime.getInstructionSet(scannedPackage.applicationInfo.primaryCpuAbi);
        }
        PackageSetting requirer = null;
        for (PackageSetting ps : packagesForUser) {
            if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString == null) continue;
            String instructionSet = VMRuntime.getInstructionSet(ps.primaryCpuAbiString);
            if (requiredInstructionSet != null && !instructionSet.equals(requiredInstructionSet)) {
                String errorMessage = "Instruction set mismatch, " + (requirer == null ? "[caller]" : requirer) + " requires " + requiredInstructionSet + " whereas " + ps + " requires " + instructionSet;
                Slog.w(TAG, errorMessage);
            }
            if (requiredInstructionSet != null) continue;
            requiredInstructionSet = instructionSet;
            requirer = ps;
        }
        if (requiredInstructionSet != null) {
            String adjustedAbi;
            if (requirer != null) {
                adjustedAbi = requirer.primaryCpuAbiString;
                if (scannedPackage != null) {
                    scannedPackage.applicationInfo.primaryCpuAbi = adjustedAbi;
                }
            } else {
                adjustedAbi = scannedPackage.applicationInfo.primaryCpuAbi;
            }
            for (PackageSetting ps : packagesForUser) {
                if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString != null) continue;
                ps.primaryCpuAbiString = adjustedAbi;
                if (ps.pkg == null || ps.pkg.applicationInfo == null) continue;
                ps.pkg.applicationInfo.primaryCpuAbi = adjustedAbi;
                Slog.i(TAG, "Adjusting ABI for : " + ps.name + " to " + adjustedAbi);
                if (this.performDexOptLI(ps.pkg, null, forceDexOpt, deferDexOpt, true) == -1) {
                    ps.primaryCpuAbiString = null;
                    ps.pkg.applicationInfo.primaryCpuAbi = null;
                    return;
                }
                this.mInstaller.rmdex(ps.codePathString, PackageManagerService.getDexCodeInstructionSet(PackageManagerService.getPreferredInstructionSet()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpCustomResolverActivity(PackageParser.Package pkg) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mResolverReplaced = true;
            this.mResolveActivity.applicationInfo = pkg.applicationInfo;
            this.mResolveActivity.name = this.mCustomResolverComponentName.getClassName();
            this.mResolveActivity.packageName = pkg.applicationInfo.packageName;
            this.mResolveActivity.processName = null;
            this.mResolveActivity.launchMode = 0;
            this.mResolveActivity.flags = 288;
            this.mResolveActivity.theme = 0;
            this.mResolveActivity.exported = true;
            this.mResolveActivity.enabled = true;
            this.mResolveInfo.activityInfo = this.mResolveActivity;
            this.mResolveInfo.priority = 0;
            this.mResolveInfo.preferredOrder = 0;
            this.mResolveInfo.match = 0;
            this.mResolveComponentName = this.mCustomResolverComponentName;
            Slog.i(TAG, "Replacing default ResolverActivity with custom activity: " + this.mResolveComponentName);
        }
    }

    private static String calculateBundledApkRoot(String codePathString) {
        File codeRoot;
        File codePath = new File(codePathString);
        if (FileUtils.contains(Environment.getRootDirectory(), codePath)) {
            codeRoot = Environment.getRootDirectory();
        } else if (FileUtils.contains(Environment.getOemDirectory(), codePath)) {
            codeRoot = Environment.getOemDirectory();
        } else if (FileUtils.contains(Environment.getVendorDirectory(), codePath)) {
            codeRoot = Environment.getVendorDirectory();
        } else {
            try {
                File tmp;
                File f = codePath.getCanonicalFile();
                File parent = f.getParentFile();
                while ((tmp = parent.getParentFile()) != null) {
                    f = parent;
                    parent = tmp;
                }
                codeRoot = f;
                Slog.w(TAG, "Unrecognized code path " + codePath + " - using " + codeRoot);
            }
            catch (IOException e) {
                Slog.w(TAG, "Can't canonicalize code path " + codePath);
                return Environment.getRootDirectory().getPath();
            }
        }
        return codeRoot.getPath();
    }

    private void setNativeLibraryPaths(PackageParser.Package pkg) {
        ApplicationInfo info = pkg.applicationInfo;
        String codePath = pkg.codePath;
        File codeFile = new File(codePath);
        boolean bundledApp = PackageManagerService.isSystemApp(info) && !PackageManagerService.isUpdatedSystemApp(info);
        boolean asecApp = PackageManagerService.isForwardLocked(info) || PackageManagerService.isExternal(info);
        info.nativeLibraryRootDir = null;
        info.nativeLibraryRootRequiresIsa = false;
        info.nativeLibraryDir = null;
        info.secondaryNativeLibraryDir = null;
        if (PackageParser.isApkFile(codeFile)) {
            if (bundledApp) {
                String apkRoot = PackageManagerService.calculateBundledApkRoot(info.sourceDir);
                boolean is64Bit = VMRuntime.is64BitInstructionSet(PackageManagerService.getPrimaryInstructionSet(info));
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                String libDir = is64Bit ? "lib64" : "lib";
                info.nativeLibraryRootDir = Environment.buildPath(new File(apkRoot), libDir, apkName).getAbsolutePath();
                if (info.secondaryCpuAbi != null) {
                    String secondaryLibDir = is64Bit ? "lib" : "lib64";
                    info.secondaryNativeLibraryDir = Environment.buildPath(new File(apkRoot), secondaryLibDir, apkName).getAbsolutePath();
                }
            } else if (asecApp) {
                info.nativeLibraryRootDir = new File(codeFile.getParentFile(), "lib").getAbsolutePath();
            } else {
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                info.nativeLibraryRootDir = new File(this.mAppLib32InstallDir, apkName).getAbsolutePath();
            }
            info.nativeLibraryRootRequiresIsa = false;
            info.nativeLibraryDir = info.nativeLibraryRootDir;
        } else {
            info.nativeLibraryRootDir = new File(codeFile, "lib").getAbsolutePath();
            info.nativeLibraryRootRequiresIsa = true;
            info.nativeLibraryDir = new File(info.nativeLibraryRootDir, PackageManagerService.getPrimaryInstructionSet(info)).getAbsolutePath();
            if (info.secondaryCpuAbi != null) {
                info.secondaryNativeLibraryDir = new File(info.nativeLibraryRootDir, VMRuntime.getInstructionSet(info.secondaryCpuAbi)).getAbsolutePath();
            }
        }
    }

    private void setBundledAppAbisAndRoots(PackageParser.Package pkg, PackageSetting pkgSetting) {
        String apkName = PackageManagerService.deriveCodePathName(pkg.applicationInfo.getCodePath());
        String apkRoot = PackageManagerService.calculateBundledApkRoot(pkg.applicationInfo.sourceDir);
        PackageManagerService.setBundledAppAbi(pkg, apkRoot, apkName);
        if (pkgSetting != null) {
            pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
            pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        }
    }

    private static void setBundledAppAbi(PackageParser.Package pkg, String apkRoot, String apkName) {
        boolean has32BitLibs;
        boolean has64BitLibs;
        File codeFile = new File(pkg.codePath);
        if (PackageParser.isApkFile(codeFile)) {
            has64BitLibs = new File(apkRoot, new File("lib64", apkName).getPath()).exists();
            has32BitLibs = new File(apkRoot, new File("lib", apkName).getPath()).exists();
        } else {
            String isa;
            File rootDir = new File(codeFile, "lib");
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_64_BIT_ABIS[0]);
                has64BitLibs = new File(rootDir, isa).exists();
            } else {
                has64BitLibs = false;
            }
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_32_BIT_ABIS[0]);
                has32BitLibs = new File(rootDir, isa).exists();
            } else {
                has32BitLibs = false;
            }
        }
        if (has64BitLibs && !has32BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && !has64BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && has64BitLibs) {
            if ((pkg.applicationInfo.flags & Integer.MIN_VALUE) == 0) {
                Slog.e(TAG, "Package: " + pkg + " has multiple bundled libs, but is not multiarch.");
            }
            if (VMRuntime.is64BitInstructionSet(PackageManagerService.getPreferredInstructionSet())) {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            } else {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            }
        } else {
            pkg.applicationInfo.primaryCpuAbi = null;
            pkg.applicationInfo.secondaryCpuAbi = null;
        }
    }

    private void killApplication(String pkgName, int appId, String reason) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.killApplicationWithAppId(pkgName, appId, reason);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePackageLI(PackageSetting ps, boolean chatty) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mPackages.remove(ps.name);
            PackageParser.Package pkg = ps.pkg;
            if (pkg != null) {
                this.cleanPackageDataStructuresLILPw(pkg, chatty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstalledPackageLI(PackageParser.Package pkg, boolean chatty) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mPackages.remove(pkg.applicationInfo.packageName);
            this.cleanPackageDataStructuresLILPw(pkg, chatty);
        }
    }

    void cleanPackageDataStructuresLILPw(PackageParser.Package pkg, boolean chatty) {
        BasePermission bp;
        PackageParser.Component a;
        PackageParser.Component p;
        int i;
        int N = pkg.providers.size();
        StringBuilder r = null;
        for (i = 0; i < N; ++i) {
            p = pkg.providers.get(i);
            this.mProviders.removeProvider((PackageParser.Provider)p);
            if (p.info.authority == null) continue;
            String[] names = p.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                if (this.mProvidersByAuthority.get(names[j]) != p) continue;
                this.mProvidersByAuthority.remove(names[j]);
            }
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.services.size();
        r = null;
        for (i = 0; i < N; ++i) {
            PackageParser.Service s = pkg.services.get(i);
            this.mServices.removeService(s);
            if (!chatty) continue;
            if (r == null) {
                r = new StringBuilder(256);
            } else {
                r.append(' ');
            }
            r.append(s.info.name);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.receivers.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.receivers.get(i);
            this.mReceivers.removeActivity((PackageParser.Activity)a, "receiver");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.activities.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.activities.get(i);
            this.mActivities.removeActivity((PackageParser.Activity)a, "activity");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.permissions.size();
        r = null;
        for (i = 0; i < N; ++i) {
            ArraySet<String> appOpPerms;
            p = pkg.permissions.get(i);
            bp = this.mSettings.mPermissions.get(((PackageParser.Permission)p).info.name);
            if (bp == null) {
                bp = this.mSettings.mPermissionTrees.get(((PackageParser.Permission)p).info.name);
            }
            if (bp != null && bp.perm == p) {
                bp.perm = null;
            }
            if ((((PackageParser.Permission)p).info.protectionLevel & 0x40) == 0 || (appOpPerms = this.mAppOpPermissionPackages.get(((PackageParser.Permission)p).info.name)) == null) continue;
            appOpPerms.remove(pkg.packageName);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.requestedPermissions.size();
        r = null;
        for (i = 0; i < N; ++i) {
            ArraySet<String> appOpPerms;
            String perm = pkg.requestedPermissions.get(i);
            bp = this.mSettings.mPermissions.get(perm);
            if (bp == null || (bp.protectionLevel & 0x40) == 0 || (appOpPerms = this.mAppOpPermissionPackages.get(perm)) == null) continue;
            appOpPerms.remove(pkg.packageName);
            if (!appOpPerms.isEmpty()) continue;
            this.mAppOpPermissionPackages.remove(perm);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.instrumentation.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.instrumentation.get(i);
            this.mInstrumentation.remove(a.getComponentName());
        }
        if (r != null) {
            // empty if block
        }
        r = null;
        if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
            for (i = 0; i < pkg.libraryNames.size(); ++i) {
                String name = pkg.libraryNames.get(i);
                SharedLibraryEntry cur = this.mSharedLibraries.get(name);
                if (cur == null || cur.apk == null || !cur.apk.equals(pkg.packageName)) continue;
                this.mSharedLibraries.remove(name);
            }
        }
        if (r != null) {
            // empty if block
        }
    }

    private static boolean hasPermission(PackageParser.Package pkgInfo, String perm) {
        for (int i = pkgInfo.permissions.size() - 1; i >= 0; --i) {
            if (!pkgInfo.permissions.get((int)i).info.name.equals(perm)) continue;
            return true;
        }
        return false;
    }

    private void updatePermissionsLPw(String changingPkg, PackageParser.Package pkgInfo, int flags) {
        BasePermission bp;
        Iterator<BasePermission> it = this.mSettings.mPermissionTrees.values().iterator();
        while (it.hasNext()) {
            bp = it.next();
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission tree: " + bp.name + " from package " + bp.sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i(TAG, "Removing old permission tree: " + bp.name + " from package " + bp.sourcePackage);
            flags |= 1;
            it.remove();
        }
        it = this.mSettings.mPermissions.values().iterator();
        while (it.hasNext()) {
            BasePermission tree;
            bp = it.next();
            if (bp.type == 2 && bp.packageSetting == null && bp.pendingInfo != null && (tree = this.findPermissionTreeLP(bp.name)) != null && tree.perm != null) {
                bp.packageSetting = tree.packageSetting;
                bp.perm = new PackageParser.Permission(tree.perm.owner, new PermissionInfo(bp.pendingInfo));
                bp.perm.info.packageName = tree.perm.info.packageName;
                bp.perm.info.name = bp.name;
                bp.uid = tree.uid;
            }
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission: " + bp.name + " from package " + bp.sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i(TAG, "Removing old permission: " + bp.name + " from package " + bp.sourcePackage);
            flags |= 1;
            it.remove();
        }
        if ((flags & 1) != 0) {
            for (PackageParser.Package pkg : this.mPackages.values()) {
                if (pkg == pkgInfo) continue;
                this.grantPermissionsLPw(pkg, (flags & 4) != 0, changingPkg);
            }
        }
        if (pkgInfo != null) {
            this.grantPermissionsLPw(pkgInfo, (flags & 2) != 0, changingPkg);
        }
    }

    private void grantPermissionsLPw(PackageParser.Package pkg, boolean replace, String packageOfInterest) {
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        GrantedPermissions gp = ps.sharedUser != null ? ps.sharedUser : ps;
        HashSet<String> origPermissions = gp.grantedPermissions;
        boolean changedPermission = false;
        if (replace) {
            ps.permissionsFixed = false;
            if (gp == ps) {
                origPermissions = new HashSet<String>(gp.grantedPermissions);
                gp.grantedPermissions.clear();
                gp.gids = this.mGlobalGids;
            }
        }
        if (gp.gids == null) {
            gp.gids = this.mGlobalGids;
        }
        int N = pkg.requestedPermissions.size();
        for (int i = 0; i < N; ++i) {
            boolean allowed;
            int level;
            String name = pkg.requestedPermissions.get(i);
            boolean required = pkg.requestedPermissionsRequired.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null || bp.packageSetting == null) {
                if (packageOfInterest != null && !packageOfInterest.equals(pkg.packageName)) continue;
                Slog.w(TAG, "Unknown permission " + name + " in package " + pkg.packageName);
                continue;
            }
            String perm = bp.name;
            boolean allowedSig = false;
            if ((bp.protectionLevel & 0x40) != 0) {
                ArraySet<String> pkgs = this.mAppOpPermissionPackages.get(bp.name);
                if (pkgs == null) {
                    pkgs = new ArraySet();
                    this.mAppOpPermissionPackages.put(bp.name, pkgs);
                }
                pkgs.add(pkg.packageName);
            }
            if ((level = bp.protectionLevel & 0xF) == 0 || level == 1) {
                allowed = required || origPermissions.contains(perm) || PackageManagerService.isSystemApp(ps) && !PackageManagerService.isUpdatedSystemApp(ps);
            } else if (bp.packageSetting == null) {
                allowed = false;
            } else if (level == 2) {
                allowed = this.grantSignaturePermission(perm, pkg, bp, origPermissions);
                if (allowed) {
                    allowedSig = true;
                }
            } else {
                allowed = false;
            }
            if (allowed) {
                if (!PackageManagerService.isSystemApp(ps) && ps.permissionsFixed && !allowedSig && !gp.grantedPermissions.contains(perm)) {
                    allowed = this.isNewPlatformPermissionForPackage(perm, pkg);
                }
                if (allowed) {
                    if (!gp.grantedPermissions.contains(perm)) {
                        changedPermission = true;
                        gp.grantedPermissions.add(perm);
                        gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                        continue;
                    }
                    if (ps.haveGids) continue;
                    gp.gids = PackageManagerService.appendInts(gp.gids, bp.gids);
                    continue;
                }
                if (packageOfInterest != null && !packageOfInterest.equals(pkg.packageName)) continue;
                Slog.w(TAG, "Not granting permission " + perm + " to package " + pkg.packageName + " because it was previously installed without");
                continue;
            }
            if (gp.grantedPermissions.remove(perm)) {
                changedPermission = true;
                gp.gids = PackageManagerService.removeInts(gp.gids, bp.gids);
                Slog.i(TAG, "Un-granting permission " + perm + " from package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
                continue;
            }
            if ((bp.protectionLevel & 0x40) != 0 || packageOfInterest != null && !packageOfInterest.equals(pkg.packageName)) continue;
            Slog.w(TAG, "Not granting permission " + perm + " to package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
        }
        if ((changedPermission || replace) && !ps.permissionsFixed && !PackageManagerService.isSystemApp(ps) || PackageManagerService.isUpdatedSystemApp(ps)) {
            ps.permissionsFixed = true;
        }
        ps.haveGids = true;
    }

    private boolean isNewPlatformPermissionForPackage(String perm, PackageParser.Package pkg) {
        boolean allowed = false;
        for (PackageParser.NewPermissionInfo npi : PackageParser.NEW_PERMISSIONS) {
            if (!npi.name.equals(perm) || pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) continue;
            allowed = true;
            Log.i(TAG, "Auto-granting " + perm + " to old pkg " + pkg.packageName);
            break;
        }
        return allowed;
    }

    private boolean grantSignaturePermission(String perm, PackageParser.Package pkg, BasePermission bp, HashSet<String> origPermissions) {
        boolean allowed;
        boolean bl = allowed = PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0 || PackageManagerService.compareSignatures(this.mPlatformPackage.mSignatures, pkg.mSignatures) == 0;
        if (!allowed && (bp.protectionLevel & 0x10) != 0 && PackageManagerService.isSystemApp(pkg)) {
            if (PackageManagerService.isUpdatedSystemApp(pkg)) {
                GrantedPermissions origGp;
                PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                GrantedPermissions grantedPermissions = origGp = sysPs.sharedUser != null ? sysPs.sharedUser : sysPs;
                if (origGp.grantedPermissions.contains(perm)) {
                    allowed = true;
                } else if (sysPs.pkg != null && sysPs.isPrivileged()) {
                    for (int j = 0; j < sysPs.pkg.requestedPermissions.size(); ++j) {
                        if (!perm.equals(sysPs.pkg.requestedPermissions.get(j))) continue;
                        allowed = true;
                        break;
                    }
                }
            } else {
                allowed = PackageManagerService.isPrivilegedApp(pkg);
            }
        }
        if (!allowed && (bp.protectionLevel & 0x20) != 0) {
            allowed = origPermissions.contains(perm);
        }
        return allowed;
    }

    static final void sendPackageBroadcast(String action, String pkg, Bundle extras, String targetPkg, IIntentReceiver finishedReceiver, int[] userIds) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                if (userIds == null) {
                    userIds = am.getRunningUserIds();
                }
                for (int id2 : userIds) {
                    int uid;
                    Intent intent = new Intent(action, pkg != null ? Uri.fromParts("package", pkg, null) : null);
                    if (extras != null) {
                        intent.putExtras(extras);
                    }
                    if (targetPkg != null) {
                        intent.setPackage(targetPkg);
                    }
                    if ((uid = intent.getIntExtra("android.intent.extra.UID", -1)) > 0 && UserHandle.getUserId(uid) != id2) {
                        uid = UserHandle.getUid(id2, UserHandle.getAppId(uid));
                        intent.putExtra("android.intent.extra.UID", uid);
                    }
                    intent.putExtra("android.intent.extra.user_handle", id2);
                    intent.addFlags(0x4000000);
                    am.broadcastIntent(null, intent, null, finishedReceiver, 0, null, null, null, -1, finishedReceiver != null, false, id2);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private boolean isExternalMediaAvailable() {
        return this.mMediaMounted || Environment.isExternalStorageEmulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageCleanItem nextPackageToClean(PackageCleanItem lastPackage) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (!this.isExternalMediaAvailable()) {
                return null;
            }
            ArrayList<PackageCleanItem> pkgs = this.mSettings.mPackagesToBeCleaned;
            if (lastPackage != null) {
                pkgs.remove(lastPackage);
            }
            if (pkgs.size() > 0) {
                return pkgs.get(0);
            }
        }
        return null;
    }

    void schedulePackageCleaning(String packageName, int userId, boolean andCode) {
        Message msg = this.mHandler.obtainMessage(7, userId, andCode ? 1 : 0, packageName);
        if (this.mSystemReady) {
            msg.sendToTarget();
        } else {
            if (this.mPostSystemReadyMessages == null) {
                this.mPostSystemReadyMessages = new ArrayList();
            }
            this.mPostSystemReadyMessages.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleaningPackages() {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (!this.isExternalMediaAvailable()) {
                return;
            }
            if (this.mSettings.mPackagesToBeCleaned.isEmpty()) {
                return;
            }
        }
        Intent intent = new Intent("android.content.pm.CLEAN_EXTERNAL_STORAGE");
        intent.setComponent(DEFAULT_CONTAINER_COMPONENT);
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.startService(null, intent, null, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void installPackage(String originPath, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, VerificationParams verificationParams, String packageAbiOverride) {
        this.installPackageAsUser(originPath, observer, installFlags, installerPackageName, verificationParams, packageAbiOverride, UserHandle.getCallingUserId());
    }

    @Override
    public void installPackageAsUser(String originPath, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, VerificationParams verificationParams, String packageAbiOverride, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, true, "installPackageAsUser");
        if (this.isUserRestricted(userId, "no_install_apps")) {
            try {
                if (observer != null) {
                    observer.onPackageInstalled("", -111, null, null);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        if (callingUid == 2000 || callingUid == 0) {
            installFlags |= 0x20;
        } else {
            installFlags &= 0xFFFFFFDF;
            installFlags &= 0xFFFFFFBF;
        }
        UserHandle user = (installFlags & 0x40) != 0 ? UserHandle.ALL : new UserHandle(userId);
        verificationParams.setInstallerUid(callingUid);
        File originFile = new File(originPath);
        OriginInfo origin = OriginInfo.fromUntrustedFile(originFile);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new InstallParams(origin, observer, installFlags, installerPackageName, verificationParams, user, packageAbiOverride);
        this.mHandler.sendMessage(msg);
    }

    void installStage(String packageName, File stagedDir, String stagedCid, IPackageInstallObserver2 observer, PackageInstaller.SessionParams params, String installerPackageName, int installerUid, UserHandle user) {
        VerificationParams verifParams = new VerificationParams(null, params.originatingUri, params.referrerUri, installerUid, null);
        OriginInfo origin = stagedDir != null ? OriginInfo.fromStagedFile(stagedDir) : OriginInfo.fromStagedContainer(stagedCid);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new InstallParams(origin, observer, params.installFlags, installerPackageName, verifParams, user, params.abiOverride);
        this.mHandler.sendMessage(msg);
    }

    private void sendPackageAddedForUser(String packageName, PackageSetting pkgSetting, int userId) {
        Bundle extras = new Bundle(1);
        extras.putInt("android.intent.extra.UID", UserHandle.getUid(userId, pkgSetting.appId));
        PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, null, null, new int[]{userId});
        try {
            boolean isSystem;
            IActivityManager am = ActivityManagerNative.getDefault();
            boolean bl = isSystem = PackageManagerService.isSystemApp(pkgSetting) || PackageManagerService.isUpdatedSystemApp(pkgSetting);
            if (isSystem && am.isUserRunning(userId, false)) {
                Intent bcIntent = new Intent("android.intent.action.BOOT_COMPLETED").addFlags(32).setPackage(packageName);
                am.broadcastIntent(null, bcIntent, null, null, 0, null, null, null, -1, false, false, userId);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Unable to bootstrap installed package", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, true, true, "setApplicationHiddenSetting for user " + userId);
        if (hidden && this.isPackageDeviceAdmin(packageName, userId)) {
            Slog.w(TAG, "Not hiding package " + packageName + ": has active device admin");
            return false;
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            PackageSetting pkgSetting;
            boolean sendAdded = false;
            boolean sendRemoved = false;
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                block15: {
                    pkgSetting = this.mSettings.mPackages.get(packageName);
                    if (pkgSetting != null) break block15;
                    boolean bl = false;
                    return bl;
                }
                if (pkgSetting.getHidden(userId) != hidden) {
                    pkgSetting.setHidden(hidden, userId);
                    this.mSettings.writePackageRestrictionsLPr(userId);
                    if (hidden) {
                        sendRemoved = true;
                    } else {
                        sendAdded = true;
                    }
                }
            }
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
                boolean bl = true;
                return bl;
            }
            if (sendRemoved) {
                this.killApplication(packageName, UserHandle.getUid(userId, pkgSetting.appId), "hiding pkg");
                this.sendApplicationHiddenForUser(packageName, pkgSetting, userId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        return false;
    }

    private void sendApplicationHiddenForUser(String packageName, PackageSetting pkgSetting, int userId) {
        PackageRemovedInfo info = new PackageRemovedInfo();
        info.removedPackage = packageName;
        info.removedUsers = new int[]{userId};
        info.uid = UserHandle.getUid(userId, pkgSetting.appId);
        info.sendBroadcast(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean getApplicationHiddenSettingAsUser(String packageName, int userId) {
        PackageSetting pkgSetting;
        long callingId;
        block6: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
            this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getApplicationHidden for user " + userId);
            callingId = Binder.clearCallingIdentity();
            try {
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                // MONITORENTER : hashMap
                pkgSetting = this.mSettings.mPackages.get(packageName);
                if (pkgSetting != null) break block6;
                bl = true;
                // MONITOREXIT : hashMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(callingId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        boolean bl = pkgSetting.getHidden(userId);
        // MONITOREXIT : hashMap
        Binder.restoreCallingIdentity(callingId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int installExistingPackageAsUser(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, true, true, "installExistingPackage for user " + userId);
        if (this.isUserRestricted(userId, "no_install_apps")) {
            return -111;
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            PackageSetting pkgSetting;
            boolean sendAdded = false;
            Bundle extras = new Bundle(1);
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                block11: {
                    pkgSetting = this.mSettings.mPackages.get(packageName);
                    if (pkgSetting != null) break block11;
                    int n = -3;
                    return n;
                }
                if (!pkgSetting.getInstalled(userId)) {
                    pkgSetting.setInstalled(true, userId);
                    pkgSetting.setHidden(false, userId);
                    this.mSettings.writePackageRestrictionsLPr(userId);
                    sendAdded = true;
                }
            }
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        return 1;
    }

    boolean isUserRestricted(int userId, String restrictionKey) {
        Bundle restrictions = sUserManager.getUserRestrictions(userId);
        if (restrictions.getBoolean(restrictionKey, false)) {
            Log.w(TAG, "User is restricted: " + restrictionKey);
            return true;
        }
        return false;
    }

    @Override
    public void verifyPendingInstall(int id2, int verificationCode) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(15);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCode, Binder.getCallingUid());
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can extend verification timeouts");
        PackageVerificationState state = this.mPendingVerification.get(id2);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCodeAtTimeout, Binder.getCallingUid());
        if (millisecondsToDelay > 3600000L) {
            millisecondsToDelay = 3600000L;
        }
        if (millisecondsToDelay < 0L) {
            millisecondsToDelay = 0L;
        }
        if (verificationCodeAtTimeout != 1 && verificationCodeAtTimeout != -1) {
            verificationCodeAtTimeout = -1;
        }
        if (state != null && !state.timeoutExtended()) {
            state.extendTimeout();
            Message msg = this.mHandler.obtainMessage(15);
            msg.arg1 = id2;
            msg.obj = response;
            this.mHandler.sendMessageDelayed(msg, millisecondsToDelay);
        }
    }

    private void broadcastPackageVerified(int verificationId, Uri packageUri, int verificationCode, UserHandle user) {
        Intent intent = new Intent("android.intent.action.PACKAGE_VERIFIED");
        intent.setDataAndType(packageUri, PACKAGE_MIME_TYPE);
        intent.addFlags(1);
        intent.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
        intent.putExtra("android.content.pm.extra.VERIFICATION_RESULT", verificationCode);
        this.mContext.sendBroadcastAsUser(intent, user, "android.permission.PACKAGE_VERIFICATION_AGENT");
    }

    private ComponentName matchComponentForVerifier(String packageName, List<ResolveInfo> receivers) {
        ActivityInfo targetReceiver = null;
        int NR = receivers.size();
        for (int i = 0; i < NR; ++i) {
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || !packageName.equals(info.activityInfo.packageName)) continue;
            targetReceiver = info.activityInfo;
            break;
        }
        if (targetReceiver == null) {
            return null;
        }
        return new ComponentName(targetReceiver.packageName, targetReceiver.name);
    }

    private List<ComponentName> matchVerifiers(PackageInfoLite pkgInfo, List<ResolveInfo> receivers, PackageVerificationState verificationState) {
        if (pkgInfo.verifiers.length == 0) {
            return null;
        }
        int N = pkgInfo.verifiers.length;
        ArrayList<ComponentName> sufficientVerifiers = new ArrayList<ComponentName>(N + 1);
        for (int i = 0; i < N; ++i) {
            int verifierUid;
            VerifierInfo verifierInfo = pkgInfo.verifiers[i];
            ComponentName comp = this.matchComponentForVerifier(verifierInfo.packageName, receivers);
            if (comp == null || (verifierUid = this.getUidForVerifier(verifierInfo)) == -1) continue;
            sufficientVerifiers.add(comp);
            verificationState.addSufficientVerifier(verifierUid);
        }
        return sufficientVerifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForVerifier(VerifierInfo verifierInfo) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            byte[] expectedPublicKey;
            PackageParser.Package pkg = this.mPackages.get(verifierInfo.packageName);
            if (pkg == null) {
                return -1;
            }
            if (pkg.mSignatures.length != 1) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " has more than one signature; ignoring");
                return -1;
            }
            try {
                Signature verifierSig = pkg.mSignatures[0];
                PublicKey publicKey = verifierSig.getPublicKey();
                expectedPublicKey = publicKey.getEncoded();
            }
            catch (CertificateException e) {
                return -1;
            }
            byte[] actualPublicKey = verifierInfo.publicKey.getEncoded();
            if (!Arrays.equals(actualPublicKey, expectedPublicKey)) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " does not have the expected public key; ignoring");
                return -1;
            }
            return pkg.applicationInfo.uid;
        }
    }

    @Override
    public void finishPackageInstall(int token) {
        PackageManagerService.enforceSystemOrRoot("Only the system is allowed to finish installs");
        Message msg = this.mHandler.obtainMessage(9, token, 0);
        this.mHandler.sendMessage(msg);
    }

    private long getVerificationTimeout() {
        return Settings.Global.getLong(this.mContext.getContentResolver(), "verifier_timeout", 10000L);
    }

    private int getDefaultVerificationResponse() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_default_response", 1);
    }

    private boolean isVerificationEnabled(int userId, int installFlags) {
        boolean ensureVerifyAppsEnabled = this.isUserRestricted(userId, "ensure_verify_apps");
        if ((installFlags & 0x20) != 0) {
            if (ActivityManager.isRunningInTestHarness()) {
                return false;
            }
            if (ensureVerifyAppsEnabled) {
                return true;
            }
            if (Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_verify_adb_installs", 1) == 0) {
                return false;
            }
        }
        if (ensureVerifyAppsEnabled) {
            return true;
        }
        return Settings.Global.getInt(this.mContext.getContentResolver(), "package_verifier_enable", 1) == 1;
    }

    private int getUnknownSourcesSettings() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "install_non_market_apps", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        int uid = Binder.getCallingUid();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting setting;
            Signature[] callerSignature;
            Object obj;
            PackageSetting installerPackageSetting;
            PackageSetting targetPackageSetting = this.mSettings.mPackages.get(targetPackage);
            if (targetPackageSetting == null) {
                throw new IllegalArgumentException("Unknown target package: " + targetPackage);
            }
            if (installerPackageName != null) {
                installerPackageSetting = this.mSettings.mPackages.get(installerPackageName);
                if (installerPackageSetting == null) {
                    throw new IllegalArgumentException("Unknown installer package: " + installerPackageName);
                }
            } else {
                installerPackageSetting = null;
            }
            if ((obj = this.mSettings.getUserIdLPr(uid)) == null) throw new SecurityException("Unknown calling uid " + uid);
            if (obj instanceof SharedUserSetting) {
                callerSignature = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) throw new SecurityException("Bad object " + obj + " for uid " + uid);
                callerSignature = ((PackageSetting)obj).signatures.mSignatures;
            }
            if (installerPackageSetting != null && PackageManagerService.compareSignatures(callerSignature, installerPackageSetting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as new installer package " + installerPackageName);
            }
            if (targetPackageSetting.installerPackageName != null && (setting = this.mSettings.mPackages.get(targetPackageSetting.installerPackageName)) != null && PackageManagerService.compareSignatures(callerSignature, setting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as old installer package " + targetPackageSetting.installerPackageName);
            }
            targetPackageSetting.installerPackageName = installerPackageName;
            this.scheduleWriteSettingsLocked();
            return;
        }
    }

    private void processPendingInstall(final InstallArgs args, final int currentStatus) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean doRestore;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                PackageInstalledInfo res = new PackageInstalledInfo();
                res.returnCode = currentStatus;
                res.uid = -1;
                res.pkg = null;
                res.removedInfo = new PackageRemovedInfo();
                if (res.returnCode == 1) {
                    args.doPreInstall(res.returnCode);
                    Object object = PackageManagerService.this.mInstallLock;
                    synchronized (object) {
                        PackageManagerService.this.installPackageLI(args, res);
                    }
                    args.doPostInstall(res.returnCode, res.uid);
                }
                boolean update = res.removedInfo.removedPackage != null;
                int flags = res.pkg == null ? 0 : res.pkg.applicationInfo.flags;
                boolean bl = doRestore = !update && (flags & 0x8000) != 0;
                if (PackageManagerService.this.mNextInstallToken < 0) {
                    PackageManagerService.this.mNextInstallToken = 1;
                }
                int token = PackageManagerService.this.mNextInstallToken++;
                PostInstallData data = new PostInstallData(args, res);
                PackageManagerService.this.mRunningInstalls.put(token, data);
                if (res.returnCode == 1 && doRestore) {
                    IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                    if (bm != null) {
                        try {
                            bm.restoreAtInstall(res.pkg.applicationInfo.packageName, token);
                        }
                        catch (RemoteException remoteException) {
                        }
                        catch (Exception e) {
                            Slog.e(PackageManagerService.TAG, "Exception trying to enqueue restore", e);
                            doRestore = false;
                        }
                    } else {
                        Slog.e(PackageManagerService.TAG, "Backup Manager not found!");
                        doRestore = false;
                    }
                }
                if (!doRestore) {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(9, token, 0);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            }
        });
    }

    private static long calculateDirectorySize(IMediaContainerService mcs, File[] paths) throws RemoteException {
        long result = 0L;
        for (File path : paths) {
            result += mcs.calculateDirectorySize(path.getAbsolutePath());
        }
        return result;
    }

    private static void clearDirectory(IMediaContainerService mcs, File[] paths) {
        for (File path : paths) {
            try {
                mcs.clearDirectory(path.getAbsolutePath());
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private static boolean installOnSd(int installFlags) {
        if ((installFlags & 0x10) != 0) {
            return false;
        }
        return (installFlags & 8) != 0;
    }

    private static boolean installForwardLocked(int installFlags) {
        return (installFlags & 1) != 0;
    }

    private InstallArgs createInstallArgs(InstallParams params) {
        if (PackageManagerService.installOnSd(params.installFlags) || params.isForwardLocked()) {
            return new AsecInstallArgs(params);
        }
        return new FileInstallArgs(params);
    }

    private InstallArgs createInstallArgsForExisting(int installFlags, String codePath, String resourcePath, String nativeLibraryRoot, String[] instructionSets) {
        boolean isInAsec = PackageManagerService.installOnSd(installFlags) ? true : PackageManagerService.installForwardLocked(installFlags) && !codePath.startsWith(this.mDrmAppPrivateInstallDir.getAbsolutePath());
        if (isInAsec) {
            return new AsecInstallArgs(codePath, instructionSets, PackageManagerService.installOnSd(installFlags), PackageManagerService.installForwardLocked(installFlags));
        }
        return new FileInstallArgs(codePath, resourcePath, nativeLibraryRoot, instructionSets);
    }

    private boolean isAsecExternal(String cid) {
        String asecPath = PackageHelper.getSdFilesystem(cid);
        return !asecPath.startsWith(this.mAsecInternalPath);
    }

    private static void maybeThrowExceptionForMultiArchCopy(String message, int copyRet) throws PackageManagerException {
        if (copyRet < 0 && copyRet != -114 && copyRet != -113) {
            throw new PackageManagerException(copyRet, message);
        }
    }

    static String cidFromCodePath(String fullCodePath) {
        int eidx = fullCodePath.lastIndexOf("/");
        String subStr1 = fullCodePath.substring(0, eidx);
        int sidx = subStr1.lastIndexOf("/");
        return subStr1.substring(sidx + 1, eidx);
    }

    static String getAsecPackageName(String packageCid) {
        int idx = packageCid.lastIndexOf(INSTALL_PACKAGE_SUFFIX);
        if (idx == -1) {
            return packageCid;
        }
        return packageCid.substring(0, idx);
    }

    private static String getNextCodePath(String oldCodePath, String prefix, String suffix) {
        String idxStr = "";
        int idx = 1;
        if (oldCodePath != null) {
            int sidx;
            String subStr = oldCodePath;
            if (suffix != null && subStr.endsWith(suffix)) {
                subStr = subStr.substring(0, subStr.length() - suffix.length());
            }
            if ((sidx = subStr.lastIndexOf(prefix)) != -1 && (subStr = subStr.substring(sidx + prefix.length())) != null) {
                if (subStr.startsWith(INSTALL_PACKAGE_SUFFIX)) {
                    subStr = subStr.substring(INSTALL_PACKAGE_SUFFIX.length());
                }
                try {
                    idx = Integer.parseInt(subStr);
                    idx = idx <= 1 ? ++idx : --idx;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        idxStr = INSTALL_PACKAGE_SUFFIX + Integer.toString(idx);
        return prefix + idxStr;
    }

    private File getNextCodePath(String packageName) {
        File result;
        int suffix = 1;
        do {
            result = new File(this.mAppInstallDir, packageName + INSTALL_PACKAGE_SUFFIX + suffix);
            ++suffix;
        } while (result.exists());
        return result;
    }

    private static boolean ignoreCodePath(String fullPathStr) {
        String apkName = PackageManagerService.deriveCodePathName(fullPathStr);
        int idx = apkName.lastIndexOf(INSTALL_PACKAGE_SUFFIX);
        if (idx != -1 && idx + 1 < apkName.length()) {
            String version = apkName.substring(idx + 1);
            try {
                Integer.parseInt(version);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static String deriveCodePathName(String codePath) {
        if (codePath == null) {
            return null;
        }
        File codeFile = new File(codePath);
        String name = codeFile.getName();
        if (codeFile.isDirectory()) {
            return name;
        }
        if (name.endsWith(".apk") || name.endsWith(".tmp")) {
            int lastDot = name.lastIndexOf(46);
            return name.substring(0, lastDot);
        }
        Slog.w(TAG, "Odd, " + codePath + " doesn't look like an APK");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNewPackageLI(PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, String installerPackageName, PackageInstalledInfo res) {
        String pkgName = pkg.packageName;
        boolean dataDirExists = this.getDataPathForPackage(pkg.packageName, 0).exists();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mSettings.mRenamedPackages.containsKey(pkgName)) {
                res.setError(-1, "Attempt to re-install " + pkgName + " without first uninstalling package running as " + this.mSettings.mRenamedPackages.get(pkgName));
                return;
            }
            if (this.mPackages.containsKey(pkgName)) {
                res.setError(-1, "Attempt to re-install " + pkgName + " without first uninstalling.");
                return;
            }
        }
        try {
            PackageParser.Package newPackage = this.scanPackageLI(pkg, parseFlags, scanFlags, System.currentTimeMillis(), user);
            this.updateSettingsLI(newPackage, installerPackageName, null, null, res);
            if (res.returnCode != 1) {
                this.deletePackageLI(pkgName, UserHandle.ALL, false, null, null, dataDirExists ? 1 : 0, res.removedInfo, true);
            }
        }
        catch (PackageManagerException e) {
            res.setError("Package couldn't be installed in " + pkg.codePath, e);
        }
    }

    private boolean checkUpgradeKeySetLP(PackageSetting oldPS, PackageParser.Package newPkg) {
        long[] upgradeKeySets = oldPS.keySetData.getUpgradeKeySets();
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        for (int i = 0; i < upgradeKeySets.length; ++i) {
            ArraySet<PublicKey> upgradeSet = ksms.getPublicKeysFromKeySetLPr(upgradeKeySets[i]);
            if (!newPkg.mSigningKeys.containsAll(upgradeSet)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replacePackageLI(PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, String installerPackageName, PackageInstalledInfo res) {
        boolean[] perUserInstalled;
        int[] allUsers;
        PackageParser.Package oldPackage;
        String pkgName = pkg.packageName;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldPackage = this.mPackages.get(pkgName);
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            if (ps == null || !ps.keySetData.isUsingUpgradeKeySets() || ps.sharedUser != null) {
                if (PackageManagerService.compareSignatures(oldPackage.mSignatures, pkg.mSignatures) != 0) {
                    res.setError(-104, "New package has a different signature: " + pkgName);
                    return;
                }
            } else if (!this.checkUpgradeKeySetLP(ps, pkg)) {
                res.setError(-104, "New package not signed by keys specified by upgrade-keysets: " + pkgName);
                return;
            }
            allUsers = sUserManager.getUserIds();
            perUserInstalled = new boolean[allUsers.length];
            for (int i = 0; i < allUsers.length; ++i) {
                perUserInstalled[i] = ps != null ? ps.getInstalled(allUsers[i]) : false;
            }
        }
        boolean sysPkg = PackageManagerService.isSystemApp(oldPackage);
        if (sysPkg) {
            this.replaceSystemPackageLI(oldPackage, pkg, parseFlags, scanFlags, user, allUsers, perUserInstalled, installerPackageName, res);
        } else {
            this.replaceNonSystemPackageLI(oldPackage, pkg, parseFlags, scanFlags, user, allUsers, perUserInstalled, installerPackageName, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceNonSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, int[] allUsers, boolean[] perUserInstalled, String installerPackageName, PackageInstalledInfo res) {
        String pkgName = deletedPackage.packageName;
        boolean deletedPkg = true;
        boolean updatedSettings = false;
        long origUpdateTime = pkg.mExtras != null ? ((PackageSetting)pkg.mExtras).lastUpdateTime : 0L;
        if (!this.deletePackageLI(pkgName, null, true, null, null, 1, res.removedInfo, true)) {
            res.setError(-10, "replaceNonSystemPackageLI");
            deletedPkg = false;
        } else {
            if (PackageManagerService.isForwardLocked(deletedPackage) || PackageManagerService.isExternal(deletedPackage)) {
                int[] uidArray = new int[]{deletedPackage.applicationInfo.uid};
                ArrayList<String> pkgList = new ArrayList<String>(1);
                pkgList.add(deletedPackage.applicationInfo.packageName);
                this.sendResourcesChangedBroadcast(false, true, pkgList, uidArray, null);
            }
            this.deleteCodeCacheDirsLI(pkgName);
            try {
                PackageParser.Package newPackage = this.scanPackageLI(pkg, parseFlags, scanFlags | 0x40, System.currentTimeMillis(), user);
                this.updateSettingsLI(newPackage, installerPackageName, allUsers, perUserInstalled, res);
                updatedSettings = true;
            }
            catch (PackageManagerException e) {
                res.setError("Package couldn't be installed in " + pkg.codePath, e);
            }
        }
        if (res.returnCode != 1) {
            if (updatedSettings) {
                this.deletePackageLI(pkgName, null, true, allUsers, perUserInstalled, 1, res.removedInfo, true);
            }
            if (deletedPkg) {
                File restoreFile = new File(deletedPackage.codePath);
                boolean oldOnSd = PackageManagerService.isExternal(deletedPackage);
                int oldParseFlags = this.mDefParseFlags | 2 | (PackageManagerService.isForwardLocked(deletedPackage) ? 16 : 0) | (oldOnSd ? 32 : 0);
                int oldScanFlags = 72;
                try {
                    this.scanPackageLI(restoreFile, oldParseFlags, oldScanFlags, origUpdateTime, null);
                }
                catch (PackageManagerException e) {
                    Slog.e(TAG, "Failed to restore package : " + pkgName + " after failed upgrade: " + e.getMessage());
                    return;
                }
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                synchronized (hashMap) {
                    this.updatePermissionsLPw(deletedPackage.packageName, deletedPackage, 1);
                    this.mSettings.writeLPr();
                }
                Slog.i(TAG, "Successfully restored package : " + pkgName + " after failed upgrade");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, int[] allUsers, boolean[] perUserInstalled, String installerPackageName, PackageInstalledInfo res) {
        PackageSetting oldPkgSetting;
        PackageParser.Package oldPkg;
        String packageName;
        boolean disabledSystem = false;
        boolean updatedSettings = false;
        parseFlags |= 1;
        if ((deletedPackage.applicationInfo.flags & 0x40000000) != 0) {
            parseFlags |= 0x80;
        }
        if ((packageName = deletedPackage.packageName) == null) {
            res.setError(-10, "Attempt to delete null packageName.");
            return;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            oldPkg = this.mPackages.get(packageName);
            oldPkgSetting = this.mSettings.mPackages.get(packageName);
            if (oldPkg == null || oldPkg.applicationInfo == null || oldPkgSetting == null) {
                res.setError(-10, "Couldn't find package:" + packageName + " information");
                return;
            }
        }
        this.killApplication(packageName, oldPkg.applicationInfo.uid, "replace sys pkg");
        res.removedInfo.uid = oldPkg.applicationInfo.uid;
        res.removedInfo.removedPackage = packageName;
        this.removePackageLI(oldPkgSetting, true);
        hashMap = this.mPackages;
        synchronized (hashMap) {
            disabledSystem = this.mSettings.disableSystemPackageLPw(packageName);
            res.removedInfo.args = !disabledSystem && deletedPackage != null ? this.createInstallArgsForExisting(0, deletedPackage.applicationInfo.getCodePath(), deletedPackage.applicationInfo.getResourcePath(), deletedPackage.applicationInfo.nativeLibraryRootDir, PackageManagerService.getAppDexInstructionSets(deletedPackage.applicationInfo)) : null;
        }
        this.deleteCodeCacheDirsLI(packageName);
        res.returnCode = 1;
        pkg.applicationInfo.flags |= 0x80;
        PackageParser.Package newPackage = null;
        try {
            newPackage = this.scanPackageLI(pkg, parseFlags, scanFlags, 0L, user);
            if (newPackage.mExtras != null) {
                PackageSetting newPkgSetting = (PackageSetting)newPackage.mExtras;
                newPkgSetting.firstInstallTime = oldPkgSetting.firstInstallTime;
                newPkgSetting.lastUpdateTime = System.currentTimeMillis();
                if (oldPkgSetting.sharedUser != newPkgSetting.sharedUser) {
                    res.setError(-8, "Forbidding shared user change from " + oldPkgSetting.sharedUser + " to " + newPkgSetting.sharedUser);
                    updatedSettings = true;
                }
            }
            if (res.returnCode == 1) {
                this.updateSettingsLI(newPackage, installerPackageName, allUsers, perUserInstalled, res);
                updatedSettings = true;
            }
        }
        catch (PackageManagerException e) {
            res.setError("Package couldn't be installed in " + pkg.codePath, e);
        }
        if (res.returnCode != 1) {
            if (newPackage != null) {
                this.removeInstalledPackageLI(newPackage, true);
            }
            try {
                this.scanPackageLI(oldPkg, parseFlags, 8, 0L, user);
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "Failed to restore original package: " + e.getMessage());
            }
            HashMap<String, PackageParser.Package> hashMap2 = this.mPackages;
            synchronized (hashMap2) {
                if (disabledSystem) {
                    this.mSettings.enableSystemPackageLPw(packageName);
                }
                if (updatedSettings) {
                    this.mSettings.setInstallerPackageName(packageName, oldPkgSetting.installerPackageName);
                }
                this.mSettings.writeLPr();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettingsLI(PackageParser.Package newPackage, String installerPackageName, int[] allUsers, boolean[] perUserInstalled, PackageInstalledInfo res) {
        String pkgName = newPackage.packageName;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            this.mSettings.setInstallStatus(pkgName, 0);
            this.mSettings.writeLPr();
        }
        hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps;
            this.updatePermissionsLPw(newPackage.packageName, newPackage, 2 | (newPackage.permissions.size() > 0 ? 1 : 0));
            if (PackageManagerService.isSystemApp(newPackage) && (ps = this.mSettings.mPackages.get(pkgName)) != null) {
                if (res.origUsers != null) {
                    for (int userHandle : res.origUsers) {
                        ps.setEnabled(0, userHandle, installerPackageName);
                    }
                }
                if (allUsers != null && perUserInstalled != null) {
                    for (int i = 0; i < allUsers.length; ++i) {
                        ps.setInstalled(perUserInstalled[i], allUsers[i]);
                    }
                }
            }
            res.name = pkgName;
            res.uid = newPackage.applicationInfo.uid;
            res.pkg = newPackage;
            this.mSettings.setInstallStatus(pkgName, 1);
            this.mSettings.setInstallerPackageName(pkgName, installerPackageName);
            res.returnCode = 1;
            this.mSettings.writeLPr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPackageLI(InstallArgs args, PackageInstalledInfo res) {
        PackageParser.Package pkg;
        int installFlags = args.installFlags;
        String installerPackageName = args.installerPackageName;
        File tmpPackageFile = new File(args.getCodePath());
        boolean forwardLocked = (installFlags & 1) != 0;
        boolean onSd = (installFlags & 8) != 0;
        boolean replace = false;
        int scanFlags = 28;
        res.returnCode = 1;
        int parseFlags = this.mDefParseFlags | 2 | (forwardLocked ? 16 : 0) | (onSd ? 32 : 0);
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setDisplayMetrics(this.mMetrics);
        try {
            pkg = pp.parsePackage(tmpPackageFile, parseFlags);
        }
        catch (PackageParser.PackageParserException e) {
            res.setError("Failed parse during installPackageLI", e);
            return;
        }
        pkg.cpuAbiOverride = args.abiOverride;
        String pkgName = res.name = pkg.packageName;
        if ((pkg.applicationInfo.flags & 0x100) != 0 && (installFlags & 4) == 0) {
            res.setError(-15, "installPackageLI");
            return;
        }
        try {
            pp.collectCertificates(pkg, parseFlags);
            pp.collectManifestDigest(pkg);
        }
        catch (PackageParser.PackageParserException e) {
            res.setError("Failed collect during installPackageLI", e);
            return;
        }
        if (args.manifestDigest != null && !args.manifestDigest.equals(pkg.manifestDigest)) {
            res.setError(-23, "Manifest digest changed");
            return;
        }
        pp = null;
        String oldCodePath = null;
        boolean systemApp = false;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps;
            int N = pkg.permissions.size();
            for (int i = N - 1; i >= 0; --i) {
                boolean sigsOk;
                PackageParser.Permission perm = pkg.permissions.get(i);
                BasePermission bp = this.mSettings.mPermissions.get(perm.info.name);
                if (bp == null || (sigsOk = !bp.sourcePackage.equals(pkg.packageName) || !(bp.packageSetting instanceof PackageSetting) || !bp.packageSetting.keySetData.isUsingUpgradeKeySets() || ((PackageSetting)bp.packageSetting).sharedUser != null ? PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0 : this.checkUpgradeKeySetLP((PackageSetting)bp.packageSetting, pkg))) continue;
                if (!bp.sourcePackage.equals("android")) {
                    res.setError(-112, "Package " + pkg.packageName + " attempting to redeclare permission " + perm.info.name + " already owned by " + bp.sourcePackage);
                    res.origPermission = perm.info.name;
                    res.origPackage = bp.sourcePackage;
                    return;
                }
                Slog.w(TAG, "Package " + pkg.packageName + " attempting to redeclare system permission " + perm.info.name + "; ignoring new declaration");
                pkg.permissions.remove(i);
            }
            if ((installFlags & 2) != 0) {
                String oldName = this.mSettings.mRenamedPackages.get(pkgName);
                if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName) && this.mPackages.containsKey(oldName)) {
                    pkg.setPackageName(oldName);
                    pkgName = pkg.packageName;
                    replace = true;
                } else if (this.mPackages.containsKey(pkgName)) {
                    replace = true;
                }
            }
            if ((ps = this.mSettings.mPackages.get(pkgName)) != null) {
                oldCodePath = this.mSettings.mPackages.get((Object)pkgName).codePathString;
                if (ps.pkg != null && ps.pkg.applicationInfo != null) {
                    systemApp = (ps.pkg.applicationInfo.flags & 1) != 0;
                }
                res.origUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
        }
        if (systemApp && onSd) {
            res.setError(-19, "Cannot install updates to system apps on sdcard");
            return;
        }
        if (!args.doRename(res.returnCode, pkg, oldCodePath)) {
            res.setError(-4, "Failed rename");
            return;
        }
        if (replace) {
            this.replacePackageLI(pkg, parseFlags, 2076, args.user, installerPackageName, res);
        } else {
            this.installNewPackageLI(pkg, parseFlags, 1052, args.user, installerPackageName, res);
        }
        hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            if (ps != null) {
                res.newUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
        }
    }

    private static boolean isForwardLocked(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x20000000) != 0;
    }

    private static boolean isForwardLocked(ApplicationInfo info) {
        return (info.flags & 0x20000000) != 0;
    }

    private boolean isForwardLocked(PackageSetting ps) {
        return (ps.pkgFlags & 0x20000000) != 0;
    }

    private static boolean isMultiArch(PackageSetting ps) {
        return (ps.pkgFlags & Integer.MIN_VALUE) != 0;
    }

    private static boolean isMultiArch(ApplicationInfo info) {
        return (info.flags & Integer.MIN_VALUE) != 0;
    }

    private static boolean isExternal(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000) != 0;
    }

    private static boolean isExternal(PackageSetting ps) {
        return (ps.pkgFlags & 0x40000) != 0;
    }

    private static boolean isExternal(ApplicationInfo info) {
        return (info.flags & 0x40000) != 0;
    }

    private static boolean isSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 1) != 0;
    }

    private static boolean isPrivilegedApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000000) != 0;
    }

    private static boolean isSystemApp(ApplicationInfo info) {
        return (info.flags & 1) != 0;
    }

    private static boolean isSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 1) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 0x80) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x80) != 0;
    }

    private static boolean isUpdatedSystemApp(ApplicationInfo info) {
        return (info.flags & 0x80) != 0;
    }

    private int packageFlagsToInstallFlags(PackageSetting ps) {
        int installFlags = 0;
        if (PackageManagerService.isExternal(ps)) {
            installFlags |= 8;
        }
        if (this.isForwardLocked(ps)) {
            installFlags |= 1;
        }
        return installFlags;
    }

    private void deleteTempPackageFiles() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("vmdl") && name.endsWith(".tmp");
            }
        };
        for (File file : this.mDrmAppPrivateInstallDir.listFiles(filter)) {
            file.delete();
        }
    }

    @Override
    public void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int userId, int flags) {
        this.deletePackage(packageName, new PackageManager.LegacyPackageDeleteObserver(observer).getBinder(), userId, flags);
    }

    @Override
    public void deletePackage(final String packageName, final IPackageDeleteObserver2 observer, final int userId, final int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        int uid = Binder.getCallingUid();
        if (UserHandle.getUserId(uid) != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "deletePackage for user " + userId);
        }
        if (this.isUserRestricted(userId, "no_uninstall_apps")) {
            try {
                observer.onPackageDeleted(packageName, -3, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        boolean uninstallBlocked = false;
        if ((flags & 2) != 0) {
            int[] users = sUserManager.getUserIds();
            for (int i = 0; i < users.length; ++i) {
                if (!this.getBlockUninstallForUser(packageName, users[i])) continue;
                uninstallBlocked = true;
                break;
            }
        } else {
            uninstallBlocked = this.getBlockUninstallForUser(packageName, userId);
        }
        if (uninstallBlocked) {
            try {
                observer.onPackageDeleted(packageName, -4, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int returnCode = PackageManagerService.this.deletePackageX(packageName, userId, flags);
                if (observer != null) {
                    try {
                        observer.onPackageDeleted(packageName, returnCode, null);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    private boolean isPackageDeviceAdmin(String packageName, int userId) {
        IDevicePolicyManager dpm = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
        try {
            if (dpm != null) {
                if (dpm.isDeviceOwner(packageName)) {
                    return true;
                }
                int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
                for (int i = 0; i < users.length; ++i) {
                    if (!dpm.packageHasActiveAdmins(packageName, users[i])) continue;
                    return true;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deletePackageX(String packageName, int userId, int flags) {
        boolean res;
        boolean[] perUserInstalled;
        int[] allUsers;
        UserHandle removeForUser;
        PackageRemovedInfo info = new PackageRemovedInfo();
        UserHandle userHandle = removeForUser = (flags & 2) != 0 ? UserHandle.ALL : new UserHandle(userId);
        if (this.isPackageDeviceAdmin(packageName, removeForUser.getIdentifier())) {
            Slog.w(TAG, "Not removing package " + packageName + ": has active device admin");
            return -2;
        }
        boolean removedForAllUsers = false;
        boolean systemUpdate = false;
        Object object = this.mPackages;
        synchronized (object) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            allUsers = sUserManager.getUserIds();
            perUserInstalled = new boolean[allUsers.length];
            for (int i = 0; i < allUsers.length; ++i) {
                perUserInstalled[i] = ps != null ? ps.getInstalled(allUsers[i]) : false;
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            res = this.deletePackageLI(packageName, removeForUser, true, allUsers, perUserInstalled, flags | 0x10000, info, true);
            systemUpdate = info.isRemovedPackageSystemUpdate;
            if (res && !systemUpdate && this.mPackages.get(packageName) == null) {
                removedForAllUsers = true;
            }
        }
        if (res) {
            info.sendBroadcast(true, systemUpdate, removedForAllUsers);
            if (systemUpdate) {
                Bundle extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", info.removedAppId >= 0 ? info.removedAppId : info.uid);
                extras.putBoolean("android.intent.extra.REPLACING", true);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, null, null, null);
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, null, null, null);
                PackageManagerService.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, packageName, null, null);
            }
        }
        Runtime.getRuntime().gc();
        if (info.args != null) {
            object = this.mInstallLock;
            synchronized (object) {
                info.args.doPostDeleteLI(true);
            }
        }
        return res ? 1 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageDataLI(PackageSetting ps, int[] allUserHandles, boolean[] perUserInstalled, PackageRemovedInfo outInfo, int flags, boolean writeSettings) {
        PackageSetting deletedPs;
        String packageName = ps.name;
        this.removePackageLI(ps, (flags & 0x10000) != 0);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            deletedPs = this.mSettings.mPackages.get(packageName);
            if (outInfo != null) {
                outInfo.removedPackage = packageName;
                outInfo.removedUsers = deletedPs != null ? deletedPs.queryInstalledUsers(sUserManager.getUserIds(), true) : null;
            }
        }
        if ((flags & 1) == 0) {
            this.removeDataDirsLI(packageName);
            this.schedulePackageCleaning(packageName, -1, true);
        }
        hashMap = this.mPackages;
        synchronized (hashMap) {
            if (deletedPs != null) {
                if ((flags & 1) == 0) {
                    if (outInfo != null) {
                        this.mSettings.mKeySetManagerService.removeAppKeySetDataLPw(packageName);
                        outInfo.removedAppId = this.mSettings.removePackageLPw(packageName);
                    }
                    if (deletedPs != null) {
                        this.updatePermissionsLPw(deletedPs.name, null, 0);
                        if (deletedPs.sharedUser != null) {
                            this.mSettings.updateSharedUserPermsLPw(deletedPs, this.mGlobalGids);
                        }
                    }
                    this.clearPackagePreferredActivitiesLPw(deletedPs.name, -1);
                }
                if (allUserHandles != null && perUserInstalled != null) {
                    for (int i = 0; i < allUserHandles.length; ++i) {
                        ps.setInstalled(perUserInstalled[i], allUserHandles[i]);
                    }
                }
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        if (outInfo != null) {
            PackageManagerService.removeKeystoreDataIfNeeded(-1, outInfo.removedAppId);
        }
    }

    static boolean locationIsPrivileged(File path) {
        try {
            String privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app").getCanonicalPath();
            return path.getCanonicalPath().startsWith(privilegedAppDir);
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSystemPackageLI(PackageSetting newPs, int[] allUserHandles, boolean[] perUserInstalled, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageParser.Package newPkg;
        boolean applyUserRestrictions = allUserHandles != null && perUserInstalled != null;
        PackageSetting disabledPs = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            disabledPs = this.mSettings.getDisabledSystemPkgLPr(newPs.name);
        }
        if (disabledPs == null) {
            Slog.w(TAG, "Attempt to delete unknown system package " + newPs.name);
            return false;
        }
        outInfo.isRemovedPackageSystemUpdate = true;
        flags = disabledPs.versionCode < newPs.versionCode ? (flags &= 0xFFFFFFFE) : (flags |= 1);
        boolean ret = this.deleteInstalledPackageLI(newPs, true, flags, allUserHandles, perUserInstalled, outInfo, writeSettings);
        if (!ret) {
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap2 = this.mPackages;
        synchronized (hashMap2) {
            this.mSettings.enableSystemPackageLPw(newPs.name);
            NativeLibraryHelper.removeNativeBinariesLI(newPs.legacyNativeLibraryPathString);
        }
        int parseFlags = 5;
        if (PackageManagerService.locationIsPrivileged(disabledPs.codePath)) {
            parseFlags |= 0x80;
        }
        try {
            newPkg = this.scanPackageLI(disabledPs.codePath, parseFlags, 32, 0L, null);
        }
        catch (PackageManagerException e) {
            Slog.w(TAG, "Failed to restore system package:" + newPs.name + ": " + e.getMessage());
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap3 = this.mPackages;
        synchronized (hashMap3) {
            PackageSetting ps = this.mSettings.mPackages.get(newPkg.packageName);
            this.updatePermissionsLPw(newPkg.packageName, newPkg, 3);
            if (applyUserRestrictions) {
                for (int i = 0; i < allUserHandles.length; ++i) {
                    ps.setInstalled(perUserInstalled[i], allUserHandles[i]);
                }
                this.mSettings.writeAllUsersPackageRestrictionsLPr();
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        return true;
    }

    private boolean deleteInstalledPackageLI(PackageSetting ps, boolean deleteCodeAndResources, int flags, int[] allUserHandles, boolean[] perUserInstalled, PackageRemovedInfo outInfo, boolean writeSettings) {
        if (outInfo != null) {
            outInfo.uid = ps.appId;
        }
        this.removePackageDataLI(ps, allUserHandles, perUserInstalled, outInfo, flags, writeSettings);
        if (deleteCodeAndResources && outInfo != null) {
            outInfo.args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, ps.legacyNativeLibraryPathString, PackageManagerService.getAppDexInstructionSets(ps));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockUninstallForUser(String packageName, boolean blockUninstall, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Log.i(TAG, "Package doesn't exist in set block uninstall " + packageName);
                return false;
            }
            if (!ps.getInstalled(userId)) {
                Log.i(TAG, "Package not installed in set block uninstall " + packageName);
                return false;
            }
            ps.setBlockUninstall(blockUninstall, userId);
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBlockUninstallForUser(String packageName, int userId) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Log.i(TAG, "Package doesn't exist in get block uninstall " + packageName);
                return false;
            }
            return ps.getBlockUninstall(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePackageLI(String packageName, UserHandle user, boolean deleteCodeAndResources, int[] allUserHandles, boolean[] perUserInstalled, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageSetting ps;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        boolean dataOnly = false;
        int removeUser = -1;
        int appId = -1;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                return false;
            }
            if (!(PackageManagerService.isSystemApp(ps) && (flags & 4) == 0 || user == null || user.getIdentifier() == -1)) {
                ps.setUserState(user.getIdentifier(), 0, false, true, true, false, null, null, null, false);
                if (!PackageManagerService.isSystemApp(ps)) {
                    if (ps.isAnyInstalled(sUserManager.getUserIds())) {
                        removeUser = user.getIdentifier();
                        appId = ps.appId;
                        this.mSettings.writePackageRestrictionsLPr(removeUser);
                    } else {
                        ps.setInstalled(true, user.getIdentifier());
                    }
                } else {
                    removeUser = user.getIdentifier();
                    appId = ps.appId;
                    this.mSettings.writePackageRestrictionsLPr(removeUser);
                }
            }
        }
        if (removeUser >= 0) {
            if (outInfo != null) {
                outInfo.removedPackage = packageName;
                outInfo.removedAppId = appId;
                outInfo.removedUsers = new int[]{removeUser};
            }
            this.mInstaller.clearUserData(packageName, removeUser);
            PackageManagerService.removeKeystoreDataIfNeeded(removeUser, appId);
            this.schedulePackageCleaning(packageName, removeUser, false);
            return true;
        }
        if (dataOnly) {
            this.removePackageDataLI(ps, null, null, outInfo, flags, writeSettings);
            return true;
        }
        boolean ret = false;
        if (PackageManagerService.isSystemApp(ps)) {
            ret = this.deleteSystemPackageLI(ps, allUserHandles, perUserInstalled, flags, outInfo, writeSettings);
        } else {
            this.killApplication(packageName, ps.appId, "uninstall pkg");
            ret = this.deleteInstalledPackageLI(ps, deleteCodeAndResources, flags, allUserHandles, perUserInstalled, outInfo, writeSettings);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExternalStorageDataSync(String packageName, int userId, boolean allData) {
        boolean mounted;
        if (Environment.isExternalStorageEmulated()) {
            mounted = true;
        } else {
            String status = Environment.getExternalStorageState();
            boolean bl = mounted = status.equals("mounted") || status.equals("mounted_ro");
        }
        if (!mounted) {
            return;
        }
        Intent containerIntent = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
        int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
        ClearStorageConnection conn = new ClearStorageConnection();
        if (this.mContext.bindServiceAsUser(containerIntent, conn, 1, UserHandle.OWNER)) {
            try {
                for (int curUser : users) {
                    long timeout = SystemClock.uptimeMillis() + 5000L;
                    ClearStorageConnection clearStorageConnection = conn;
                    synchronized (clearStorageConnection) {
                        long now = SystemClock.uptimeMillis();
                        while (conn.mContainerService == null && now < timeout) {
                            try {
                                conn.wait(timeout - now);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if (conn.mContainerService == null) {
                        return;
                    }
                    Environment.UserEnvironment userEnv = new Environment.UserEnvironment(curUser);
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppCacheDirs(packageName));
                    if (!allData) continue;
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppDataDirs(packageName));
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppMediaDirs(packageName));
                }
            }
            finally {
                this.mContext.unbindService(conn);
            }
        }
    }

    @Override
    public void clearApplicationUserData(final String packageName, final IPackageDataObserver observer, final int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_USER_DATA", null);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "clear application data");
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DeviceStorageMonitorInternal dsm;
                boolean succeeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeeded = PackageManagerService.this.clearApplicationUserDataLI(packageName, userId);
                }
                PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, true);
                if (succeeded && (dsm = LocalServices.getService(DeviceStorageMonitorInternal.class)) != null) {
                    dsm.checkMemory();
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearApplicationUserDataLI(String packageName, int userId) {
        String nativeLibPath;
        int retCode;
        PackageParser.Package pkg;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageSetting ps;
            pkg = this.mPackages.get(packageName);
            if (pkg == null && (ps = this.mSettings.mPackages.get(packageName)) != null) {
                pkg = ps.pkg;
            }
        }
        if (pkg == null) {
            Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
        }
        if ((retCode = this.mInstaller.clearUserData(packageName, userId)) < 0) {
            Slog.w(TAG, "Couldn't remove cache files for package: " + packageName);
            return false;
        }
        if (pkg == null) {
            return false;
        }
        if (pkg != null && pkg.applicationInfo != null) {
            int appId = pkg.applicationInfo.uid;
            PackageManagerService.removeKeystoreDataIfNeeded(userId, appId);
        }
        if (pkg != null && pkg.applicationInfo.primaryCpuAbi != null && !VMRuntime.is64BitAbi(pkg.applicationInfo.primaryCpuAbi) && this.mInstaller.linkNativeLibraryDirectory(pkg.packageName, nativeLibPath = pkg.applicationInfo.nativeLibraryDir, userId) < 0) {
            Slog.w(TAG, "Failed linking native library dir");
            return false;
        }
        return true;
    }

    private static void removeKeystoreDataIfNeeded(int userId, int appId) {
        if (appId < 0) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance();
        if (keyStore != null) {
            if (userId == -1) {
                for (int individual : sUserManager.getUserIds()) {
                    keyStore.clearUid(UserHandle.getUid(individual, appId));
                }
            } else {
                keyStore.clearUid(UserHandle.getUid(userId, appId));
            }
        } else {
            Slog.w(TAG, "Could not contact keystore to clear entries for app id " + appId);
        }
    }

    @Override
    public void deleteApplicationCacheFiles(final String packageName, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_CACHE_FILES", null);
        final int userId = UserHandle.getCallingUserId();
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean succeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeded = PackageManagerService.this.deleteApplicationCacheFilesLI(packageName, userId);
                }
                PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, false);
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteApplicationCacheFilesLI(String packageName, int userId) {
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            p = this.mPackages.get(packageName);
        }
        if (p == null) {
            Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
            return false;
        }
        ApplicationInfo applicationInfo = p.applicationInfo;
        if (applicationInfo == null) {
            Slog.w(TAG, "Package " + packageName + " has no applicationInfo.");
            return false;
        }
        int retCode = this.mInstaller.deleteCacheFiles(packageName, userId);
        if (retCode < 0) {
            Slog.w(TAG, "Couldn't remove cache files for package: " + packageName + " u" + userId);
            return false;
        }
        return true;
    }

    @Override
    public void getPackageSizeInfo(String packageName, int userHandle, IPackageStatsObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GET_PACKAGE_SIZE", null);
        if (packageName == null) {
            throw new IllegalArgumentException("Attempt to get size of null packageName");
        }
        PackageStats stats = new PackageStats(packageName, userHandle);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new MeasureParams(stats, observer);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPackageSizeInfoLI(String packageName, int userHandle, PackageStats pStats) {
        String[] dexCodeInstructionSets;
        int res;
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to get size of null packageName.");
            return false;
        }
        boolean dataOnly = false;
        String libDirRoot = null;
        String asecPath = null;
        PackageSetting ps = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            String secureContainerId;
            p = this.mPackages.get(packageName);
            ps = this.mSettings.mPackages.get(packageName);
            if (p == null) {
                dataOnly = true;
                if (ps == null || ps.pkg == null) {
                    Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                    return false;
                }
                p = ps.pkg;
            }
            if (ps != null) {
                libDirRoot = ps.legacyNativeLibraryPathString;
            }
            if (p != null && (PackageManagerService.isExternal(p) || PackageManagerService.isForwardLocked(p)) && (secureContainerId = PackageManagerService.cidFromCodePath(p.applicationInfo.getBaseCodePath())) != null) {
                asecPath = PackageHelper.getSdFilesystem(secureContainerId);
            }
        }
        String publicSrcDir = null;
        if (!dataOnly) {
            ApplicationInfo applicationInfo = p.applicationInfo;
            if (applicationInfo == null) {
                Slog.w(TAG, "Package " + packageName + " has no applicationInfo.");
                return false;
            }
            if (PackageManagerService.isForwardLocked(p)) {
                publicSrcDir = applicationInfo.getBaseResourcePath();
            }
        }
        if ((res = this.mInstaller.getSizeInfo(packageName, userHandle, p.baseCodePath, libDirRoot, publicSrcDir, asecPath, dexCodeInstructionSets = PackageManagerService.getDexCodeInstructionSets(PackageManagerService.getAppDexInstructionSets(ps)), pStats)) < 0) {
            return false;
        }
        if (!PackageManagerService.isExternal(p)) {
            pStats.codeSize += pStats.externalCodeSize;
            pStats.externalCodeSize = 0L;
        }
        return true;
    }

    @Override
    public void addPackageToPreferred(String packageName) {
        Slog.w(TAG, "addPackageToPreferred: this is now a no-op");
    }

    @Override
    public void removePackageFromPreferred(String packageName) {
        Slog.w(TAG, "removePackageFromPreferred: this is now a no-op");
    }

    @Override
    public List<PackageInfo> getPreferredPackages(int flags) {
        return new ArrayList<PackageInfo>();
    }

    private int getUidTargetSdkVersionLockedLPr(int uid) {
        Object obj = this.mSettings.getUserIdLPr(uid);
        if (obj instanceof SharedUserSetting) {
            SharedUserSetting sus = (SharedUserSetting)obj;
            int vers = 10000;
            for (PackageSetting ps : sus.packages) {
                int v;
                if (ps.pkg == null || (v = ps.pkg.applicationInfo.targetSdkVersion) >= vers) continue;
                vers = v;
            }
            return vers;
        }
        if (obj instanceof PackageSetting) {
            PackageSetting ps = (PackageSetting)obj;
            if (ps.pkg != null) {
                return ps.pkg.applicationInfo.targetSdkVersion;
            }
        }
        return 10000;
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Adding preferred");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreferredActivityInternal(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, boolean always, int userId, String opname) {
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "add preferred activity");
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring addPreferredActivity() from uid " + callingUid);
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            PreferredIntentResolver pir = this.mSettings.editPreferredActivitiesLPw(userId);
            Slog.i(TAG, opname + " activity " + activity.flattenToShortString() + " for user " + userId + ":");
            filter.dump(new LogPrinter(4, TAG), "  ");
            pir.addFilter(new PreferredActivity(filter, match, set, activity, always));
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        if (filter.countActions() != 1) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have only 1 action.");
        }
        if (filter.countDataAuthorities() != 0 || filter.countDataPaths() != 0 || filter.countDataSchemes() > 1 || filter.countDataTypes() != 0) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have no data authorities, paths, or types; and at most one scheme.");
        }
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "replace preferred activity");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PreferredIntentResolver pir;
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring replacePreferredActivity() from uid " + Binder.getCallingUid());
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if ((pir = this.mSettings.mPreferredActivities.get(userId)) != null) {
                ArrayList existing = pir.findFilters(filter);
                if (existing != null && existing.size() == 1) {
                    PreferredActivity cur = (PreferredActivity)existing.get(0);
                    if (cur.mPref.mAlways && cur.mPref.mComponent.equals(activity) && cur.mPref.mMatch == (match & 0xFFF0000) && cur.mPref.sameSet(set)) {
                        return;
                    }
                }
                if (existing != null) {
                    for (int i = 0; i < existing.size(); ++i) {
                        PreferredActivity pa = (PreferredActivity)existing.get(i);
                        pir.removeFilter(pa);
                    }
                }
            }
            this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Replacing preferred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePreferredActivities(String packageName) {
        int uid = Binder.getCallingUid();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int user;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if ((pkg == null || pkg.applicationInfo.uid != uid) && this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(Binder.getCallingUid()) < 8) {
                    Slog.w(TAG, "Ignoring clearPackagePreferredActivities() from uid " + Binder.getCallingUid());
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if (this.clearPackagePreferredActivitiesLPw(packageName, user = UserHandle.getCallingUserId())) {
                this.mSettings.writePackageRestrictionsLPr(user);
                this.scheduleWriteSettingsLocked();
            }
        }
    }

    boolean clearPackagePreferredActivitiesLPw(String packageName, int userId) {
        ArrayList<PreferredActivity> removed = null;
        boolean changed = false;
        for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
            int thisUserId = this.mSettings.mPreferredActivities.keyAt(i);
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
            if (userId != -1 && userId != thisUserId) continue;
            Iterator it = pir.filterIterator();
            while (it.hasNext()) {
                PreferredActivity pa = (PreferredActivity)it.next();
                if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                if (removed == null) {
                    removed = new ArrayList<PreferredActivity>();
                }
                removed.add(pa);
            }
            if (removed == null) continue;
            for (int j = 0; j < removed.size(); ++j) {
                PreferredActivity pa = (PreferredActivity)removed.get(j);
                pir.removeFilter(pa);
            }
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPreferredActivities(int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            int user = UserHandle.getCallingUserId();
            this.clearPackagePreferredActivitiesLPw(null, user);
            this.mSettings.readDefaultPreferredAppsLPw(this, user);
            this.mSettings.writePackageRestrictionsLPr(user);
            this.scheduleWriteSettingsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        int num = 0;
        int userId = UserHandle.getCallingUserId();
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(userId);
            if (pir != null) {
                Iterator it = pir.filterIterator();
                while (it.hasNext()) {
                    PreferredActivity pa = (PreferredActivity)it.next();
                    if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                    if (outFilters != null) {
                        outFilters.add(new IntentFilter(pa));
                    }
                    if (outActivities == null) continue;
                    outActivities.add(pa.mPref.mComponent);
                }
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistentPreferredActivity(IntentFilter filter, ComponentName activity, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("addPersistentPreferredActivity can only be run by the system");
        }
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Slog.i(TAG, "Adding persistent preferred activity " + activity + " for user " + userId + " :");
            filter.dump(new LogPrinter(4, TAG), "  ");
            this.mSettings.editPersistentPreferredActivitiesLPw(userId).addFilter(new PersistentPreferredActivity(filter, activity));
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePersistentPreferredActivities(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("clearPackagePersistentPreferredActivities can only be run by the system");
        }
        ArrayList<PersistentPreferredActivity> removed = null;
        boolean changed = false;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            for (int i = 0; i < this.mSettings.mPersistentPreferredActivities.size(); ++i) {
                int thisUserId = this.mSettings.mPersistentPreferredActivities.keyAt(i);
                PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.valueAt(i);
                if (userId != thisUserId) continue;
                Iterator it = ppir.filterIterator();
                while (it.hasNext()) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)it.next();
                    if (!ppa.mComponent.getPackageName().equals(packageName)) continue;
                    if (removed == null) {
                        removed = new ArrayList<PersistentPreferredActivity>();
                    }
                    removed.add(ppa);
                }
                if (removed == null) continue;
                for (int j = 0; j < removed.size(); ++j) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)removed.get(j);
                    ppir.removeFilter(ppa);
                }
                changed = true;
            }
            if (changed) {
                this.mSettings.writePackageRestrictionsLPr(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrossProfileIntentFilter(IntentFilter intentFilter, String ownerPackage, int ownerUserId, int sourceUserId, int targetUserId, int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, ownerUserId, callingUid);
        this.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        if (intentFilter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a crossProfile intent filter with no filter actions");
            return;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            CrossProfileIntentFilter filter = new CrossProfileIntentFilter(intentFilter, ownerPackage, UserHandle.getUserId(callingUid), targetUserId, flags);
            this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId).addFilter(filter);
            this.mSettings.writePackageRestrictionsLPr(sourceUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCrossProfileIntentFilters(int sourceUserId, String ownerPackage, int ownerUserId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, ownerUserId, callingUid);
        this.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        int callingUserId = UserHandle.getUserId(callingUid);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            CrossProfileIntentResolver resolver = this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId);
            HashSet set = new HashSet(resolver.filterSet());
            for (CrossProfileIntentFilter filter : set) {
                if (!filter.getOwnerPackage().equals(ownerPackage) || filter.getOwnerUserId() != callingUserId) continue;
                resolver.removeFilter(filter);
            }
            this.mSettings.writePackageRestrictionsLPr(sourceUserId);
        }
    }

    private void enforceOwnerRights(String pkg, int userId, int callingUid) {
        if (UserHandle.getAppId(callingUid) == 1000) {
            return;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUserId != userId) {
            throw new SecurityException("calling uid " + callingUid + " pretends to own " + pkg + " on user " + userId + " but belongs to user " + callingUserId);
        }
        PackageInfo pi = this.getPackageInfo(pkg, 0, callingUserId);
        if (pi == null) {
            throw new IllegalArgumentException("Unknown package " + pkg + " on user " + callingUserId);
        }
        if (!UserHandle.isSameApp(pi.applicationInfo.uid, callingUid)) {
            throw new SecurityException("Calling uid " + callingUid + " does not own package " + pkg);
        }
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> allHomeCandidates) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        int callingUserId = UserHandle.getCallingUserId();
        List<ResolveInfo> list = this.queryIntentActivities(intent, null, 128, callingUserId);
        ResolveInfo preferred = this.findPreferredActivity(intent, null, 0, list, 0, true, false, false, callingUserId);
        allHomeCandidates.clear();
        if (list != null) {
            for (ResolveInfo ri : list) {
                allHomeCandidates.add(ri);
            }
        }
        return preferred == null || preferred.activityInfo == null ? null : new ComponentName(preferred.activityInfo.packageName, preferred.activityInfo.name);
    }

    @Override
    public void setApplicationEnabledSetting(String appPackageName, int newState, int flags, int userId, String callingPackage) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        if (callingPackage == null) {
            callingPackage = Integer.toString(Binder.getCallingUid());
        }
        this.setEnabledSetting(appPackageName, null, newState, flags, userId, callingPackage);
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.setEnabledSetting(componentName.getPackageName(), componentName.getClassName(), newState, flags, userId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledSetting(String packageName, String className, int newState, int flags, int userId, String callingPackage) {
        ArrayList<String> components;
        PackageSetting pkgSetting;
        if (newState != 0 && newState != 1 && newState != 2 && newState != 3 && newState != 4) {
            throw new IllegalArgumentException("Invalid new component state: " + newState);
        }
        int uid = Binder.getCallingUid();
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        this.enforceCrossUserPermission(uid, userId, false, true, "set enabled");
        boolean allowedByPermission = permission2 == 0;
        boolean sendNow = false;
        boolean isApp = className == null;
        String componentName = isApp ? packageName : className;
        int packageUid = -1;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            boolean newPackage;
            pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                if (className == null) {
                    throw new IllegalArgumentException("Unknown package: " + packageName);
                }
                throw new IllegalArgumentException("Unknown component: " + packageName + "/" + className);
            }
            if (!allowedByPermission && !UserHandle.isSameApp(uid, pkgSetting.appId)) {
                throw new SecurityException("Permission Denial: attempt to change component state from pid=" + Binder.getCallingPid() + ", uid=" + uid + ", package uid=" + pkgSetting.appId);
            }
            if (className == null) {
                if (pkgSetting.getEnabled(userId) == newState) {
                    return;
                }
                if (newState == 0 || newState == 1) {
                    callingPackage = null;
                }
                pkgSetting.setEnabled(newState, userId, callingPackage);
            } else {
                PackageParser.Package pkg = pkgSetting.pkg;
                if (pkg == null || !pkg.hasComponentClassName(className)) {
                    if (pkg.applicationInfo.targetSdkVersion >= 16) {
                        throw new IllegalArgumentException("Component class " + className + " does not exist in " + packageName);
                    }
                    Slog.w(TAG, "Failed setComponentEnabledSetting: component class " + className + " does not exist in " + packageName);
                }
                switch (newState) {
                    case 1: {
                        if (pkgSetting.enableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 2: {
                        if (pkgSetting.disableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 0: {
                        if (pkgSetting.restoreComponentLPw(className, userId)) break;
                        return;
                    }
                    default: {
                        Slog.e(TAG, "Invalid new component state: " + newState);
                        return;
                    }
                }
            }
            this.mSettings.writePackageRestrictionsLPr(userId);
            components = this.mPendingBroadcasts.get(userId, packageName);
            boolean bl = newPackage = components == null;
            if (newPackage) {
                components = new ArrayList();
            }
            if (!components.contains(componentName)) {
                components.add(componentName);
            }
            if ((flags & 1) == 0) {
                sendNow = true;
                this.mPendingBroadcasts.remove(userId, packageName);
            } else {
                if (newPackage) {
                    this.mPendingBroadcasts.put(userId, packageName, components);
                }
                if (!this.mHandler.hasMessages(1)) {
                    this.mHandler.sendEmptyMessageDelayed(1, 10000L);
                }
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            if (sendNow) {
                packageUid = UserHandle.getUid(userId, pkgSetting.appId);
                this.sendPackageChangedBroadcast(packageName, (flags & 1) != 0, components, packageUid);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private void sendPackageChangedBroadcast(String packageName, boolean killFlag, ArrayList<String> componentNames, int packageUid) {
        Bundle extras = new Bundle(4);
        extras.putString("android.intent.extra.changed_component_name", componentNames.get(0));
        String[] nameList = new String[componentNames.size()];
        componentNames.toArray(nameList);
        extras.putStringArray("android.intent.extra.changed_component_name_list", nameList);
        extras.putBoolean("android.intent.extra.DONT_KILL_APP", killFlag);
        extras.putInt("android.intent.extra.UID", packageUid);
        PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_CHANGED", packageName, extras, null, null, new int[]{UserHandle.getUserId(packageUid)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageStoppedState(String packageName, boolean stopped, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        int uid = Binder.getCallingUid();
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        boolean allowedByPermission = permission2 == 0;
        this.enforceCrossUserPermission(uid, userId, true, true, "stop package");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (this.mSettings.setPackageStoppedStateLPw(packageName, stopped, allowedByPermission, uid, userId)) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstallerPackageName(String packageName) {
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getInstallerPackageNameLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getApplicationEnabledSetting(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, false, false, "get enabled");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getApplicationEnabledSettingLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getComponentEnabledSetting(ComponentName componentName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, false, false, "get component enabled");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getComponentEnabledSettingLPr(componentName, userId);
        }
    }

    @Override
    public void enterSafeMode() {
        PackageManagerService.enforceSystemOrRoot("Only the system can request entering safe mode");
        if (!this.mSystemReady) {
            this.mSafeMode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        this.mSystemReady = true;
        boolean compatibilityModeEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "compatibility_mode", 1) == 1;
        PackageParser.setCompatibilityModeEnabled(compatibilityModeEnabled);
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            ArrayList<PreferredActivity> removed = new ArrayList<PreferredActivity>();
            for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                removed.clear();
                for (PreferredActivity pa : pir.filterSet()) {
                    if (this.mActivities.mActivities.get(pa.mPref.mComponent) != null) continue;
                    removed.add(pa);
                }
                if (removed.size() <= 0) continue;
                for (int r = 0; r < removed.size(); ++r) {
                    PreferredActivity pa;
                    pa = (PreferredActivity)removed.get(r);
                    Slog.w(TAG, "Removing dangling preferred activity: " + pa.mPref.mComponent);
                    pir.removeFilter(pa);
                }
                this.mSettings.writePackageRestrictionsLPr(this.mSettings.mPreferredActivities.keyAt(i));
            }
        }
        sUserManager.systemReady();
        if (this.mPostSystemReadyMessages != null) {
            for (Message msg : this.mPostSystemReadyMessages) {
                msg.sendToTarget();
            }
            this.mPostSystemReadyMessages = null;
        }
    }

    @Override
    public boolean isSafeMode() {
        return this.mSafeMode;
    }

    @Override
    public boolean hasSystemUidErrors() {
        return this.mHasSystemUidErrors;
    }

    static String arrayToString(int[] array2) {
        StringBuffer buf = new StringBuffer(128);
        buf.append('[');
        if (array2 != null) {
            for (int i = 0; i < array2.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(array2[i]);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        DumpState dumpState = new DumpState();
        boolean fullPreferred = false;
        boolean checkin = false;
        String packageName = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) continue;
            if ("-h".equals(opt)) {
                pw.println("Package manager dump options:");
                pw.println("  [-h] [-f] [--checkin] [cmd] ...");
                pw.println("    --checkin: dump for a checkin");
                pw.println("    -f: print details of intent filters");
                pw.println("    -h: print this help");
                pw.println("  cmd may be one of:");
                pw.println("    l[ibraries]: list known shared libraries");
                pw.println("    f[ibraries]: list device features");
                pw.println("    k[eysets]: print known keysets");
                pw.println("    r[esolvers]: dump intent resolvers");
                pw.println("    perm[issions]: dump permissions");
                pw.println("    pref[erred]: print preferred package settings");
                pw.println("    preferred-xml [--full]: print preferred package settings as xml");
                pw.println("    prov[iders]: dump content providers");
                pw.println("    p[ackages]: dump installed packages");
                pw.println("    s[hared-users]: dump shared user IDs");
                pw.println("    m[essages]: print collected runtime messages");
                pw.println("    v[erifiers]: print package verifier info");
                pw.println("    version: print database version info");
                pw.println("    write: write current settings now");
                pw.println("    <package.name>: info about given package");
                pw.println("    installs: details about install sessions");
                return;
            }
            if ("--checkin".equals(opt)) {
                checkin = true;
                continue;
            }
            if ("-f".equals(opt)) {
                dumpState.setOptionEnabled(1);
                continue;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("android".equals(cmd) || cmd.contains(".")) {
                packageName = cmd;
                dumpState.setOptionEnabled(1);
            } else if ("l".equals(cmd) || "libraries".equals(cmd)) {
                dumpState.setDump(1);
            } else if ("f".equals(cmd) || "features".equals(cmd)) {
                dumpState.setDump(2);
            } else if ("r".equals(cmd) || "resolvers".equals(cmd)) {
                dumpState.setDump(4);
            } else if ("perm".equals(cmd) || "permissions".equals(cmd)) {
                dumpState.setDump(8);
            } else if ("pref".equals(cmd) || "preferred".equals(cmd)) {
                dumpState.setDump(512);
            } else if ("preferred-xml".equals(cmd)) {
                dumpState.setDump(1024);
                if (opti < args.length && "--full".equals(args[opti])) {
                    fullPreferred = true;
                    ++opti;
                }
            } else if ("p".equals(cmd) || "packages".equals(cmd)) {
                dumpState.setDump(16);
            } else if ("s".equals(cmd) || "shared-users".equals(cmd)) {
                dumpState.setDump(32);
            } else if ("prov".equals(cmd) || "providers".equals(cmd)) {
                dumpState.setDump(128);
            } else if ("m".equals(cmd) || "messages".equals(cmd)) {
                dumpState.setDump(64);
            } else if ("v".equals(cmd) || "verifiers".equals(cmd)) {
                dumpState.setDump(256);
            } else if ("version".equals(cmd)) {
                dumpState.setDump(4096);
            } else if ("k".equals(cmd) || "keysets".equals(cmd)) {
                dumpState.setDump(2048);
            } else if ("installs".equals(cmd)) {
                dumpState.setDump(8192);
            } else if ("write".equals(cmd)) {
                HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                synchronized (hashMap) {
                    this.mSettings.writeLPr();
                    pw.println("Settings written.");
                    return;
                }
            }
        }
        if (checkin) {
            pw.println("vers,1");
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            if (dumpState.isDumping(4096) && packageName == null && !checkin) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Database versions:");
                pw.print("  SDK Version:");
                pw.print(" internal=");
                pw.print(this.mSettings.mInternalSdkPlatform);
                pw.print(" external=");
                pw.println(this.mSettings.mExternalSdkPlatform);
                pw.print("  DB Version:");
                pw.print(" internal=");
                pw.print(this.mSettings.mInternalDatabaseVersion);
                pw.print(" external=");
                pw.println(this.mSettings.mExternalDatabaseVersion);
            }
            if (dumpState.isDumping(256) && packageName == null) {
                if (!checkin) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Verifiers:");
                    pw.print("  Required: ");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(" (uid=");
                    pw.print(this.getPackageUid(this.mRequiredVerifierPackage, 0));
                    pw.println(")");
                } else if (this.mRequiredVerifierPackage != null) {
                    pw.print("vrfy,");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(",");
                    pw.println(this.getPackageUid(this.mRequiredVerifierPackage, 0));
                }
            }
            if (dumpState.isDumping(1) && packageName == null) {
                boolean printedHeader = false;
                for (String name : this.mSharedLibraries.keySet()) {
                    SharedLibraryEntry ent = this.mSharedLibraries.get(name);
                    if (!checkin) {
                        if (!printedHeader) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("Libraries:");
                            printedHeader = true;
                        }
                        pw.print("  ");
                    } else {
                        pw.print("lib,");
                    }
                    pw.print(name);
                    if (!checkin) {
                        pw.print(" -> ");
                    }
                    if (ent.path != null) {
                        if (!checkin) {
                            pw.print("(jar) ");
                            pw.print(ent.path);
                        } else {
                            pw.print(",jar,");
                            pw.print(ent.path);
                        }
                    } else if (!checkin) {
                        pw.print("(apk) ");
                        pw.print(ent.apk);
                    } else {
                        pw.print(",apk,");
                        pw.print(ent.apk);
                    }
                    pw.println();
                }
            }
            if (dumpState.isDumping(2) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                if (!checkin) {
                    pw.println("Features:");
                }
                for (String name : this.mAvailableFeatures.keySet()) {
                    if (!checkin) {
                        pw.print("  ");
                    } else {
                        pw.print("feat,");
                    }
                    pw.println(name);
                }
            }
            if (!checkin && dumpState.isDumping(4)) {
                if (this.mActivities.dump(pw, dumpState.getTitlePrinted() ? "\nActivity Resolver Table:" : "Activity Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                    dumpState.setTitlePrinted(true);
                }
                if (this.mReceivers.dump(pw, dumpState.getTitlePrinted() ? "\nReceiver Resolver Table:" : "Receiver Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                    dumpState.setTitlePrinted(true);
                }
                if (this.mServices.dump(pw, dumpState.getTitlePrinted() ? "\nService Resolver Table:" : "Service Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                    dumpState.setTitlePrinted(true);
                }
                if (this.mProviders.dump(pw, dumpState.getTitlePrinted() ? "\nProvider Resolver Table:" : "Provider Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1))) {
                    dumpState.setTitlePrinted(true);
                }
            }
            if (!checkin && dumpState.isDumping(512)) {
                for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                    PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                    int user = this.mSettings.mPreferredActivities.keyAt(i);
                    if (!pir.dump(pw, dumpState.getTitlePrinted() ? "\nPreferred Activities User " + user + ":" : "Preferred Activities User " + user + ":", "  ", packageName, true)) continue;
                    dumpState.setTitlePrinted(true);
                }
            }
            if (!checkin && dumpState.isDumping(1024)) {
                pw.flush();
                FileOutputStream fout = new FileOutputStream(fd);
                BufferedOutputStream str = new BufferedOutputStream(fout);
                FastXmlSerializer serializer = new FastXmlSerializer();
                try {
                    serializer.setOutput(str, "utf-8");
                    serializer.startDocument(null, true);
                    serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    this.mSettings.writePreferredActivitiesLPr(serializer, 0, fullPreferred);
                    serializer.endDocument();
                    serializer.flush();
                }
                catch (IllegalArgumentException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IllegalStateException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IOException e) {
                    pw.println("Failed writing: " + e);
                }
            }
            if (!checkin && dumpState.isDumping(8)) {
                this.mSettings.dumpPermissionsLPr(pw, packageName, dumpState);
                if (packageName == null) {
                    for (int iperm = 0; iperm < this.mAppOpPermissionPackages.size(); ++iperm) {
                        if (iperm == 0) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("AppOp Permissions:");
                        }
                        pw.print("  AppOp Permission ");
                        pw.print(this.mAppOpPermissionPackages.keyAt(iperm));
                        pw.println(":");
                        ArraySet<String> pkgs = this.mAppOpPermissionPackages.valueAt(iperm);
                        for (int ipkg = 0; ipkg < pkgs.size(); ++ipkg) {
                            pw.print("    ");
                            pw.println(pkgs.valueAt(ipkg));
                        }
                    }
                }
            }
            if (!checkin && dumpState.isDumping(128)) {
                boolean printedSomething = false;
                for (PackageParser.Provider p : this.mProviders.mProviders.values()) {
                    if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Registered ContentProviders:");
                        printedSomething = true;
                    }
                    pw.print("  ");
                    p.printComponentShortName(pw);
                    pw.println(":");
                    pw.print("    ");
                    pw.println(p.toString());
                }
                printedSomething = false;
                for (Map.Entry entry : this.mProvidersByAuthority.entrySet()) {
                    PackageParser.Provider p = (PackageParser.Provider)entry.getValue();
                    if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("ContentProvider Authorities:");
                        printedSomething = true;
                    }
                    pw.print("  [");
                    pw.print((String)entry.getKey());
                    pw.println("]:");
                    pw.print("    ");
                    pw.println(p.toString());
                    if (p.info == null || p.info.applicationInfo == null) continue;
                    String appInfo = p.info.applicationInfo.toString();
                    pw.print("      applicationInfo=");
                    pw.println(appInfo);
                }
            }
            if (!checkin && dumpState.isDumping(2048)) {
                this.mSettings.mKeySetManagerService.dumpLPr(pw, packageName, dumpState);
            }
            if (dumpState.isDumping(16)) {
                this.mSettings.dumpPackagesLPr(pw, packageName, dumpState, checkin);
            }
            if (!checkin && dumpState.isDumping(32)) {
                this.mSettings.dumpSharedUsersLPr(pw, packageName, dumpState);
            }
            if (!checkin && dumpState.isDumping(8192) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.mInstallerService.dump(new IndentingPrintWriter(pw, "  ", 120));
            }
            if (!checkin && dumpState.isDumping(64) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.mSettings.dumpReadMessagesLPr(pw, dumpState);
                pw.println();
                pw.println("Package warning messages:");
                File fname = PackageManagerService.getSettingsProblemFile();
                FileInputStream in = null;
                try {
                    in = new FileInputStream(fname);
                    int avail = in.available();
                    byte[] data = new byte[avail];
                    in.read(data);
                    pw.print(new String(data));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (checkin && dumpState.isDumping(64)) {
                BufferedReader in = null;
                String line = null;
                try {
                    in = new BufferedReader(new FileReader(PackageManagerService.getSettingsProblemFile()));
                    while ((line = in.readLine()) != null) {
                        pw.print("msg,");
                        pw.println(line);
                    }
                }
                catch (IOException iOException) {
                    IoUtils.closeQuietly(in);
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(in);
            }
        }
    }

    static String getEncryptKey() {
        try {
            String sdEncKey = SystemKeyStore.getInstance().retrieveKeyHexString(SD_ENCRYPTION_KEYSTORE_NAME);
            if (sdEncKey == null && (sdEncKey = SystemKeyStore.getInstance().generateNewKeyHexString(128, SD_ENCRYPTION_ALGORITHM, SD_ENCRYPTION_KEYSTORE_NAME)) == null) {
                Slog.e(TAG, "Failed to create encryption keys");
                return null;
            }
            return sdEncKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            Slog.e(TAG, "Failed to create encryption keys with exception: " + nsae);
            return null;
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Failed to retrieve encryption keys with exception: " + ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExternalMediaStatus(final boolean mediaStatus, final boolean reportStatus) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("Media status can only be updated by the system");
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            Log.i(TAG, "Updating external media status from " + (this.mMediaMounted ? "mounted" : "unmounted") + " to " + (mediaStatus ? "mounted" : "unmounted"));
            if (mediaStatus == this.mMediaMounted) {
                Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1);
                this.mHandler.sendMessage(msg);
                return;
            }
            this.mMediaMounted = mediaStatus;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageManagerService.this.updateExternalMediaStatusInner(mediaStatus, reportStatus, true);
            }
        });
    }

    public void scanAvailableAsecs() {
        this.updateExternalMediaStatusInner(true, false, false);
        if (this.mShouldRestoreconData) {
            SELinuxMMAC.setRestoreconDone();
            this.mShouldRestoreconData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalMediaStatusInner(boolean isMounted, boolean reportStatus, boolean externalStorage) {
        ArrayMap<AsecInstallArgs, String> processCids = new ArrayMap<AsecInstallArgs, String>();
        int[] uidArr = EmptyArray.INT;
        String[] list = PackageHelper.getSecureContainerList();
        if (ArrayUtils.isEmpty(list)) {
            Log.i(TAG, "No secure containers found");
        } else {
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                for (String cid : list) {
                    if (PackageInstallerService.isStageName(cid)) continue;
                    String pkgName = PackageManagerService.getAsecPackageName(cid);
                    if (pkgName == null) {
                        Slog.i(TAG, "Found stale container " + cid + " with no package name");
                        continue;
                    }
                    PackageSetting ps = this.mSettings.mPackages.get(pkgName);
                    if (ps == null) {
                        Slog.i(TAG, "Found stale container " + cid + " with no matching settings");
                        continue;
                    }
                    if (externalStorage && !isMounted && !PackageManagerService.isExternal(ps)) continue;
                    AsecInstallArgs args = new AsecInstallArgs(cid, PackageManagerService.getAppDexInstructionSets(ps), this.isForwardLocked(ps));
                    if (ps.codePathString != null && ps.codePathString.startsWith(args.getCodePath())) {
                        processCids.put(args, ps.codePathString);
                        int uid = ps.appId;
                        if (uid == -1) continue;
                        uidArr = ArrayUtils.appendInt(uidArr, uid);
                        continue;
                    }
                    Slog.i(TAG, "Found stale container " + cid + ": expected codePath=" + ps.codePathString);
                }
            }
            Arrays.sort(uidArr);
        }
        if (isMounted) {
            this.loadMediaPackages(processCids, uidArr);
            this.startCleaningPackages();
            this.mInstallerService.onSecureContainersAvailable();
        } else {
            this.unloadMediaPackages(processCids, uidArr, reportStatus);
        }
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<String> pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        int size = pkgList.size();
        if (size > 0) {
            Bundle extras = new Bundle();
            extras.putStringArray("android.intent.extra.changed_package_list", pkgList.toArray(new String[size]));
            if (uidArr != null) {
                extras.putIntArray("android.intent.extra.changed_uid_list", uidArr);
            }
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", replacing);
            }
            String action = mediaStatus ? "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE" : "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
            PackageManagerService.sendPackageBroadcast(action, null, extras, null, finishedReceiver, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMediaPackages(ArrayMap<AsecInstallArgs, String> processCids, int[] uidArr) {
        ArrayList<String> pkgList = new ArrayList<String>();
        Set<AsecInstallArgs> keys = processCids.keySet();
        for (AsecInstallArgs args : keys) {
            String codePath = processCids.get(args);
            int retCode = -18;
            try {
                if (args.doPreInstall(1) != 1) {
                    Slog.e(TAG, "Failed to mount cid : " + args.cid + " when installing from sdcard");
                    continue;
                }
                if (codePath == null || !codePath.startsWith(args.getCodePath())) {
                    Slog.e(TAG, "Container " + args.cid + " cachepath " + args.getCodePath() + " does not match one in settings " + codePath);
                    continue;
                }
                int parseFlags = this.mDefParseFlags;
                if (args.isExternal()) {
                    parseFlags |= 0x20;
                }
                if (args.isFwdLocked()) {
                    parseFlags |= 0x10;
                }
                Object object = this.mInstallLock;
                synchronized (object) {
                    PackageParser.Package pkg = null;
                    try {
                        pkg = this.scanPackageLI(new File(codePath), parseFlags, 0, 0L, null);
                    }
                    catch (PackageManagerException e) {
                        Slog.w(TAG, "Failed to scan " + codePath + ": " + e.getMessage());
                    }
                    if (pkg != null) {
                        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
                        synchronized (hashMap) {
                            retCode = 1;
                            pkgList.add(pkg.packageName);
                            args.doPostInstall(1, pkg.applicationInfo.uid);
                        }
                    } else {
                        Slog.i(TAG, "Failed to install pkg from  " + codePath + " from sdcard");
                    }
                }
            }
            finally {
                if (retCode == 1) continue;
                Log.w(TAG, "Container " + args.cid + " is stale, retCode=" + retCode);
            }
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            boolean regrantPermissions;
            boolean bl = regrantPermissions = this.mSettings.mExternalSdkPlatform != this.mSdkVersion;
            if (regrantPermissions) {
                Slog.i(TAG, "Platform changed from " + this.mSettings.mExternalSdkPlatform + " to " + this.mSdkVersion + "; regranting permissions for external storage");
            }
            this.mSettings.mExternalSdkPlatform = this.mSdkVersion;
            this.updatePermissionsLPw(null, null, 1 | (regrantPermissions ? 6 : 0));
            this.mSettings.updateExternalDatabaseVersion();
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(true, false, pkgList, uidArr, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllContainers(Set<AsecInstallArgs> cidArgs) {
        for (AsecInstallArgs arg : cidArgs) {
            Object object = this.mInstallLock;
            synchronized (object) {
                arg.doPostDeleteLI(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadMediaPackages(ArrayMap<AsecInstallArgs, String> processCids, int[] uidArr, final boolean reportStatus) {
        ArrayList<String> pkgList = new ArrayList<String>();
        ArrayList<AsecInstallArgs> failedList = new ArrayList<AsecInstallArgs>();
        final Set<AsecInstallArgs> keys = processCids.keySet();
        for (AsecInstallArgs args : keys) {
            String pkgName = args.getPackageName();
            PackageRemovedInfo outInfo = new PackageRemovedInfo();
            Object object = this.mInstallLock;
            synchronized (object) {
                boolean res = this.deletePackageLI(pkgName, null, false, null, null, 1, outInfo, false);
                if (res) {
                    pkgList.add(pkgName);
                } else {
                    Slog.e(TAG, "Failed to delete pkg from sdcard : " + pkgName);
                    failedList.add(args);
                }
            }
        }
        HashMap<String, PackageParser.Package> i$ = this.mPackages;
        synchronized (i$) {
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(false, false, pkgList, uidArr, new IIntentReceiver.Stub(){

                @Override
                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, 1, keys);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            });
        } else {
            Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1, keys);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void movePackage(final String packageName, final IPackageMoveObserver observer, int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        UserHandle user = new UserHandle(UserHandle.getCallingUserId());
        int returnCode = 1;
        int currInstallFlags = 0;
        int newInstallFlags = 0;
        File codeFile = null;
        String installerPackageName = null;
        String packageAbiOverride = null;
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (pkg == null || ps == null) {
                returnCode = -2;
            } else {
                if (pkg.applicationInfo != null && PackageManagerService.isSystemApp(pkg)) {
                    Slog.w(TAG, "Cannot move system application");
                    returnCode = -3;
                } else if (pkg.mOperationPending) {
                    Slog.w(TAG, "Attempt to move package which has pending operations");
                    returnCode = -7;
                } else {
                    if ((flags & 2) != 0 && (flags & 1) != 0) {
                        Slog.w(TAG, "Ambigous flags specified for move location.");
                        returnCode = -5;
                    } else {
                        newInstallFlags = (flags & 2) != 0 ? 8 : 16;
                        int n = currInstallFlags = PackageManagerService.isExternal(pkg) ? 8 : 16;
                        if (newInstallFlags == currInstallFlags) {
                            Slog.w(TAG, "No move required. Trying to move to same location");
                            returnCode = -5;
                        } else if (PackageManagerService.isForwardLocked(pkg)) {
                            currInstallFlags |= 1;
                            newInstallFlags |= 1;
                        }
                    }
                    if (returnCode == 1) {
                        pkg.mOperationPending = true;
                    }
                }
                codeFile = new File(pkg.codePath);
                installerPackageName = ps.installerPackageName;
                packageAbiOverride = ps.cpuAbiOverrideString;
            }
        }
        if (returnCode != 1) {
            try {
                observer.packageMoved(packageName, returnCode);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return;
        }
        IPackageInstallObserver2.Stub installObserver = new IPackageInstallObserver2.Stub(){

            @Override
            public void onUserActionRequired(Intent intent) throws RemoteException {
                throw new IllegalStateException();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageInstalled(String basePackageName, int returnCode, String msg, Bundle extras) throws RemoteException {
                Slog.d(PackageManagerService.TAG, "Install result for move: " + PackageManager.installStatusToString(returnCode, msg));
                HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                synchronized (hashMap) {
                    PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                    if (pkg != null) {
                        pkg.mOperationPending = false;
                    }
                }
                int status = PackageManager.installStatusToPublicStatus(returnCode);
                switch (status) {
                    case 0: {
                        observer.packageMoved(packageName, 1);
                        break;
                    }
                    case 6: {
                        observer.packageMoved(packageName, -1);
                        break;
                    }
                    default: {
                        observer.packageMoved(packageName, -6);
                    }
                }
            }
        };
        Message msg = this.mHandler.obtainMessage(5);
        OriginInfo origin = OriginInfo.fromExistingFile(codeFile);
        msg.obj = new InstallParams(origin, installObserver, newInstallFlags |= 2, installerPackageName, null, user, packageAbiOverride);
        this.mHandler.sendMessage(msg);
    }

    @Override
    public boolean setInstallLocation(int loc) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
        if (this.getInstallLocation() == loc) {
            return true;
        }
        if (loc == 0 || loc == 1 || loc == 2) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "default_install_location", loc);
            return true;
        }
        return false;
    }

    @Override
    public int getInstallLocation() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "default_install_location", 0);
    }

    void cleanUpUserLILPw(UserManagerService userManager, int userHandle) {
        this.mDirtyUsers.remove(userHandle);
        this.mSettings.removeUserLPw(userHandle);
        this.mPendingBroadcasts.remove(userHandle);
        if (this.mInstaller != null) {
            this.mInstaller.removeUserDataDirs(userHandle);
        }
        this.mUserNeedsBadging.delete(userHandle);
        this.removeUnusedPackagesLILPw(userManager, userHandle);
    }

    private void removeUnusedPackagesLILPw(UserManagerService userManager, final int userHandle) {
        boolean DEBUG_CLEAN_APKS = false;
        int[] users = userManager.getUserIdsLPr();
        for (PackageSetting ps : this.mSettings.mPackages.values()) {
            if (ps.pkg == null) continue;
            final String packageName = ps.pkg.packageName;
            if ((ps.pkgFlags & 1) != 0) continue;
            boolean keep = false;
            for (int i = 0; i < users.length; ++i) {
                if (users[i] == userHandle || !ps.getInstalled(users[i])) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PackageManagerService.this.deletePackageX(packageName, userHandle, 0);
                }
            });
        }
    }

    void createNewUserLILPw(int userHandle, File path) {
        if (this.mInstaller != null) {
            this.mInstaller.createUserConfig(userHandle);
            this.mSettings.createNewUserLILPw(this, this.mInstaller, userHandle, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can read the verifier device identity");
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            return this.mSettings.getVerifierDeviceIdentityLPw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionEnforced(String permission2, boolean enforced) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_REVOKE_PERMISSIONS", null);
        if ("android.permission.READ_EXTERNAL_STORAGE".equals(permission2)) {
            HashMap<String, PackageParser.Package> hashMap = this.mPackages;
            synchronized (hashMap) {
                if (this.mSettings.mReadExternalStorageEnforced == null || this.mSettings.mReadExternalStorageEnforced != enforced) {
                    this.mSettings.mReadExternalStorageEnforced = enforced;
                    this.mSettings.writeLPr();
                }
            }
            IActivityManager am = ActivityManagerNative.getDefault();
            if (am != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    am.killProcessesBelowForeground("setPermissionEnforcement");
                }
                catch (RemoteException remoteException) {
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        } else {
            throw new IllegalArgumentException("No selective enforcement for " + permission2);
        }
    }

    @Override
    @Deprecated
    public boolean isPermissionEnforced(String permission2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStorageLow() {
        long token = Binder.clearCallingIdentity();
        try {
            DeviceStorageMonitorInternal dsm = LocalServices.getService(DeviceStorageMonitorInternal.class);
            if (dsm != null) {
                boolean bl = dsm.isMemoryLow();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public IPackageInstaller getPackageInstaller() {
        return this.mInstallerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userNeedsBadging(int userId) {
        int index = this.mUserNeedsBadging.indexOfKey(userId);
        if (index < 0) {
            UserInfo userInfo;
            long token = Binder.clearCallingIdentity();
            try {
                userInfo = sUserManager.getUserInfo(userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            boolean b = userInfo != null && userInfo.isManagedProfile();
            this.mUserNeedsBadging.put(userId, b);
            return b;
        }
        return this.mUserNeedsBadging.valueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getKeySetByAlias(String packageName, String alias) {
        if (packageName == null || alias == null) {
            return null;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getKeySetByAliasAndPackageNameLPr(packageName, alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getSigningKeySet(String packageName) {
        if (packageName == null) {
            return null;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            if (pkg.applicationInfo.uid != Binder.getCallingUid() && 1000 != Binder.getCallingUid()) {
                throw new SecurityException("May not access signing KeySet of other apps.");
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getSigningKeySetByPackageNameLPr(packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySet(String packageName, KeySet ks) {
        if (packageName == null || ks == null) {
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySetExactly(String packageName, KeySet ks) {
        if (packageName == null || ks == null) {
            return false;
        }
        HashMap<String, PackageParser.Package> hashMap = this.mPackages;
        synchronized (hashMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByExactlyLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    static {
        mResolvePrioritySorter = new Comparator<ResolveInfo>(){

            @Override
            public int compare(ResolveInfo r1, ResolveInfo r2) {
                int v1 = r1.priority;
                int v2 = r2.priority;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                v1 = r1.preferredOrder;
                v2 = r2.preferredOrder;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.isDefault != r2.isDefault) {
                    return r1.isDefault ? -1 : 1;
                }
                v1 = r1.match;
                v2 = r2.match;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.system != r2.system) {
                    return r1.system ? -1 : 1;
                }
                return 0;
            }
        };
        mProviderInitOrderSorter = new Comparator<ProviderInfo>(){

            @Override
            public int compare(ProviderInfo p1, ProviderInfo p2) {
                int v1 = p1.initOrder;
                int v2 = p2.initOrder;
                return v1 > v2 ? -1 : (v1 < v2 ? 1 : 0);
            }
        };
    }

    static class DumpState {
        public static final int DUMP_LIBS = 1;
        public static final int DUMP_FEATURES = 2;
        public static final int DUMP_RESOLVERS = 4;
        public static final int DUMP_PERMISSIONS = 8;
        public static final int DUMP_PACKAGES = 16;
        public static final int DUMP_SHARED_USERS = 32;
        public static final int DUMP_MESSAGES = 64;
        public static final int DUMP_PROVIDERS = 128;
        public static final int DUMP_VERIFIERS = 256;
        public static final int DUMP_PREFERRED = 512;
        public static final int DUMP_PREFERRED_XML = 1024;
        public static final int DUMP_KEYSETS = 2048;
        public static final int DUMP_VERSION = 4096;
        public static final int DUMP_INSTALLS = 8192;
        public static final int OPTION_SHOW_FILTERS = 1;
        private int mTypes;
        private int mOptions;
        private boolean mTitlePrinted;
        private SharedUserSetting mSharedUser;

        DumpState() {
        }

        public boolean isDumping(int type) {
            if (this.mTypes == 0 && type != 1024) {
                return true;
            }
            return (this.mTypes & type) != 0;
        }

        public void setDump(int type) {
            this.mTypes |= type;
        }

        public boolean isOptionEnabled(int option) {
            return (this.mOptions & option) != 0;
        }

        public void setOptionEnabled(int option) {
            this.mOptions |= option;
        }

        public boolean onTitlePrinted() {
            boolean printed = this.mTitlePrinted;
            this.mTitlePrinted = true;
            return printed;
        }

        public boolean getTitlePrinted() {
            return this.mTitlePrinted;
        }

        public void setTitlePrinted(boolean enabled) {
            this.mTitlePrinted = enabled;
        }

        public SharedUserSetting getSharedUser() {
            return this.mSharedUser;
        }

        public void setSharedUser(SharedUserSetting user) {
            this.mSharedUser = user;
        }
    }

    private final class ClearStorageConnection
    implements ServiceConnection {
        IMediaContainerService mContainerService;

        private ClearStorageConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            ClearStorageConnection clearStorageConnection = this;
            synchronized (clearStorageConnection) {
                this.mContainerService = IMediaContainerService.Stub.asInterface(service);
                this.notifyAll();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    static class PackageRemovedInfo {
        String removedPackage;
        int uid = -1;
        int removedAppId = -1;
        int[] removedUsers = null;
        boolean isRemovedPackageSystemUpdate = false;
        InstallArgs args = null;

        PackageRemovedInfo() {
        }

        void sendBroadcast(boolean fullRemove, boolean replacing, boolean removedForAllUsers) {
            Bundle extras = new Bundle(1);
            extras.putInt("android.intent.extra.UID", this.removedAppId >= 0 ? this.removedAppId : this.uid);
            extras.putBoolean("android.intent.extra.DATA_REMOVED", fullRemove);
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", true);
            }
            extras.putBoolean("android.intent.extra.REMOVED_FOR_ALL_USERS", removedForAllUsers);
            if (this.removedPackage != null) {
                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, null, null, this.removedUsers);
                if (fullRemove && !replacing) {
                    PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_FULLY_REMOVED", this.removedPackage, extras, null, null, this.removedUsers);
                }
            }
            if (this.removedAppId >= 0) {
                PackageManagerService.sendPackageBroadcast("android.intent.action.UID_REMOVED", null, extras, null, null, this.removedUsers);
            }
        }
    }

    class PackageInstalledInfo {
        String name;
        int uid;
        int[] origUsers;
        int[] newUsers;
        PackageParser.Package pkg;
        int returnCode;
        String returnMsg;
        PackageRemovedInfo removedInfo;
        String origPackage;
        String origPermission;

        PackageInstalledInfo() {
        }

        public void setError(int code, String msg) {
            this.returnCode = code;
            this.returnMsg = msg;
            Slog.w(PackageManagerService.TAG, msg);
        }

        public void setError(String msg, PackageParser.PackageParserException e) {
            this.returnCode = e.error;
            this.returnMsg = ExceptionUtils.getCompleteMessage(msg, e);
            Slog.w(PackageManagerService.TAG, msg, e);
        }

        public void setError(String msg, PackageManagerException e) {
            this.returnCode = e.error;
            this.returnMsg = ExceptionUtils.getCompleteMessage(msg, e);
            Slog.w(PackageManagerService.TAG, msg, e);
        }
    }

    class AsecInstallArgs
    extends InstallArgs {
        static final String RES_FILE_NAME = "pkg.apk";
        static final String PUBLIC_RES_FILE_NAME = "res.zip";
        String cid;
        String packagePath;
        String resourcePath;
        String legacyNativeLibraryDir;

        AsecInstallArgs(InstallParams params) {
            super(params.origin, params.observer, params.installFlags, params.installerPackageName, params.getManifestDigest(), params.getUser(), null, params.packageAbiOverride);
        }

        AsecInstallArgs(String fullCodePath, String[] instructionSets, boolean isExternal, boolean isForwardLocked) {
            super(OriginInfo.fromNothing(), null, (isExternal ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null, instructionSets, null);
            if (!fullCodePath.endsWith(RES_FILE_NAME)) {
                fullCodePath = new File(fullCodePath, RES_FILE_NAME).getAbsolutePath();
            }
            int eidx = fullCodePath.lastIndexOf("/");
            String subStr1 = fullCodePath.substring(0, eidx);
            int sidx = subStr1.lastIndexOf("/");
            this.cid = subStr1.substring(sidx + 1, eidx);
            this.setMountPath(subStr1);
        }

        AsecInstallArgs(String cid, String[] instructionSets, boolean isForwardLocked) {
            super(OriginInfo.fromNothing(), null, (PackageManagerService.this.isAsecExternal(cid) ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null, instructionSets, null);
            this.cid = cid;
            this.setMountPath(PackageHelper.getSdDir(cid));
        }

        void createCopyFile() {
            this.cid = PackageManagerService.this.mInstallerService.allocateExternalStageCidLegacy();
        }

        @Override
        boolean checkFreeStorage(IMediaContainerService imcs) throws RemoteException {
            long sizeBytes = imcs.calculateInstalledSize(this.packagePath, this.isFwdLocked(), this.abiOverride);
            File target = this.isExternal() ? new Environment.UserEnvironment(0).getExternalStorageDirectory() : Environment.getDataDirectory();
            StorageManager storage = StorageManager.from(PackageManagerService.this.mContext);
            return sizeBytes <= storage.getStorageBytesUntilLow(target);
        }

        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            if (this.origin.staged) {
                Slog.d(PackageManagerService.TAG, this.origin.cid + " already staged; skipping copy");
                this.cid = this.origin.cid;
                this.setMountPath(PackageHelper.getSdDir(this.cid));
                return 1;
            }
            if (temp) {
                this.createCopyFile();
            } else {
                PackageHelper.destroySdDir(this.cid);
            }
            String newMountPath = imcs.copyPackageToContainer(this.origin.file.getAbsolutePath(), this.cid, PackageManagerService.getEncryptKey(), this.isExternal(), this.isFwdLocked(), PackageManagerService.deriveAbiOverride(this.abiOverride, null));
            if (newMountPath != null) {
                this.setMountPath(newMountPath);
                return 1;
            }
            return -18;
        }

        @Override
        String getCodePath() {
            return this.packagePath;
        }

        @Override
        String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        String getLegacyNativeLibraryPath() {
            return this.legacyNativeLibraryDir;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                PackageHelper.destroySdDir(this.cid);
            } else {
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    String newMountPath = PackageHelper.mountSdDir(this.cid, PackageManagerService.getEncryptKey(), 1000);
                    if (newMountPath != null) {
                        this.setMountPath(newMountPath);
                    } else {
                        return -18;
                    }
                }
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            String newCacheId = PackageManagerService.getNextCodePath(oldCodePath, pkg.packageName, "/pkg.apk");
            String newMountPath = null;
            if (PackageHelper.isContainerMounted(this.cid) && !PackageHelper.unMountSdDir(this.cid)) {
                Slog.i(PackageManagerService.TAG, "Failed to unmount " + this.cid + " before renaming");
                return false;
            }
            if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " which might be stale. Will try to clean up.");
                if (!PackageHelper.destroySdDir(newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Very strange. Cannot clean up stale container " + newCacheId);
                    return false;
                }
                if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " inspite of cleaning it up.");
                    return false;
                }
            }
            if (!PackageHelper.isContainerMounted(newCacheId)) {
                Slog.w(PackageManagerService.TAG, "Mounting container " + newCacheId);
                newMountPath = PackageHelper.mountSdDir(newCacheId, PackageManagerService.getEncryptKey(), 1000);
            } else {
                newMountPath = PackageHelper.getSdDir(newCacheId);
            }
            if (newMountPath == null) {
                Slog.w(PackageManagerService.TAG, "Failed to get cache path for  " + newCacheId);
                return false;
            }
            Log.i(PackageManagerService.TAG, "Succesfully renamed " + this.cid + " to " + newCacheId + " at new path: " + newMountPath);
            this.cid = newCacheId;
            File beforeCodeFile = new File(this.packagePath);
            this.setMountPath(newMountPath);
            File afterCodeFile = new File(this.packagePath);
            pkg.codePath = afterCodeFile.getAbsolutePath();
            pkg.baseCodePath = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.baseCodePath);
            pkg.splitCodePaths = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.splitCodePaths);
            pkg.applicationInfo.setCodePath(pkg.codePath);
            pkg.applicationInfo.setBaseCodePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitCodePaths(pkg.splitCodePaths);
            pkg.applicationInfo.setResourcePath(pkg.codePath);
            pkg.applicationInfo.setBaseResourcePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        private void setMountPath(String mountPath) {
            File mountFile = new File(mountPath);
            File monolithicFile = new File(mountFile, RES_FILE_NAME);
            if (monolithicFile.exists()) {
                this.packagePath = monolithicFile.getAbsolutePath();
                this.resourcePath = this.isFwdLocked() ? new File(mountFile, PUBLIC_RES_FILE_NAME).getAbsolutePath() : this.packagePath;
            } else {
                this.resourcePath = this.packagePath = mountFile.getAbsolutePath();
            }
            this.legacyNativeLibraryDir = new File(mountFile, "lib").getAbsolutePath();
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            } else {
                String protectedFile;
                int groupOwner;
                if (this.isFwdLocked()) {
                    groupOwner = UserHandle.getSharedAppGid(uid);
                    protectedFile = RES_FILE_NAME;
                } else {
                    groupOwner = -1;
                    protectedFile = null;
                }
                if (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, groupOwner, protectedFile)) {
                    Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                    PackageHelper.destroySdDir(this.cid);
                    return -18;
                }
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    PackageHelper.mountSdDir(this.cid, PackageManagerService.getEncryptKey(), Process.myUid());
                }
            }
            return status;
        }

        private void cleanUp() {
            PackageHelper.destroySdDir(this.cid);
        }

        private List<String> getAllCodePaths() {
            File codeFile = new File(this.getCodePath());
            if (codeFile != null && codeFile.exists()) {
                try {
                    PackageParser.PackageLite pkg = PackageParser.parsePackageLite(codeFile, 0);
                    return pkg.getAllCodePaths();
                }
                catch (PackageParser.PackageParserException packageParserException) {
                    // empty catch block
                }
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        void cleanUpResourcesLI() {
            this.cleanUpResourcesLI(this.getAllCodePaths());
        }

        private void cleanUpResourcesLI(List<String> allCodePaths) {
            this.cleanUp();
            if (!allCodePaths.isEmpty()) {
                if (this.instructionSets == null) {
                    throw new IllegalStateException("instructionSet == null");
                }
                String[] dexCodeInstructionSets = PackageManagerService.getDexCodeInstructionSets(this.instructionSets);
                for (String codePath : allCodePaths) {
                    for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                        int retCode = PackageManagerService.this.mInstaller.rmdex(codePath, dexCodeInstructionSet);
                        if (retCode >= 0) continue;
                        Slog.w(PackageManagerService.TAG, "Couldn't remove dex file for package:  at location " + codePath + ", retcode=" + retCode);
                    }
                }
            }
        }

        boolean matchContainer(String app) {
            return this.cid.startsWith(app);
        }

        String getPackageName() {
            return PackageManagerService.getAsecPackageName(this.cid);
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            List<String> allCodePaths = this.getAllCodePaths();
            boolean mounted = PackageHelper.isContainerMounted(this.cid);
            if (mounted && PackageHelper.unMountSdDir(this.cid)) {
                mounted = false;
            }
            if (!mounted && delete) {
                this.cleanUpResourcesLI(allCodePaths);
            }
            return !mounted;
        }

        @Override
        int doPreCopy() {
            if (this.isFwdLocked() && !PackageHelper.fixSdPermissions(this.cid, PackageManagerService.this.getPackageUid(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, 0), RES_FILE_NAME)) {
                return -18;
            }
            return 1;
        }

        @Override
        int doPostCopy(int uid) {
            if (this.isFwdLocked() && (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, UserHandle.getSharedAppGid(uid), RES_FILE_NAME))) {
                Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                PackageHelper.destroySdDir(this.cid);
                return -18;
            }
            return 1;
        }
    }

    class FileInstallArgs
    extends InstallArgs {
        private File codeFile;
        private File resourceFile;
        private File legacyNativeLibraryPath;

        FileInstallArgs(InstallParams params) {
            super(params.origin, params.observer, params.installFlags, params.installerPackageName, params.getManifestDigest(), params.getUser(), null, params.packageAbiOverride);
            if (this.isFwdLocked()) {
                throw new IllegalArgumentException("Forward locking only supported in ASEC");
            }
        }

        FileInstallArgs(String codePath, String resourcePath, String legacyNativeLibraryPath, String[] instructionSets) {
            super(OriginInfo.fromNothing(), null, 0, null, null, null, instructionSets, null);
            this.codeFile = codePath != null ? new File(codePath) : null;
            this.resourceFile = resourcePath != null ? new File(resourcePath) : null;
            this.legacyNativeLibraryPath = legacyNativeLibraryPath != null ? new File(legacyNativeLibraryPath) : null;
        }

        @Override
        boolean checkFreeStorage(IMediaContainerService imcs) throws RemoteException {
            StorageManager storage;
            long sizeBytes = imcs.calculateInstalledSize(this.origin.file.getAbsolutePath(), this.isFwdLocked(), this.abiOverride);
            return sizeBytes <= (storage = StorageManager.from(PackageManagerService.this.mContext)).getStorageBytesUntilLow(Environment.getDataDirectory());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            if (this.origin.staged) {
                Slog.d(PackageManagerService.TAG, this.origin.file + " already staged; skipping copy");
                this.codeFile = this.origin.file;
                this.resourceFile = this.origin.file;
                return 1;
            }
            try {
                File tempDir;
                this.codeFile = tempDir = PackageManagerService.this.mInstallerService.allocateInternalStageDirLegacy();
                this.resourceFile = tempDir;
            }
            catch (IOException e) {
                Slog.w(PackageManagerService.TAG, "Failed to create copy file: " + e);
                return -4;
            }
            IParcelFileDescriptorFactory.Stub target = new IParcelFileDescriptorFactory.Stub(){

                @Override
                public ParcelFileDescriptor open(String name, int mode) throws RemoteException {
                    if (!FileUtils.isValidExtFilename(name)) {
                        throw new IllegalArgumentException("Invalid filename: " + name);
                    }
                    try {
                        File file = new File(FileInstallArgs.this.codeFile, name);
                        FileDescriptor fd = Os.open(file.getAbsolutePath(), OsConstants.O_RDWR | OsConstants.O_CREAT, 420);
                        Os.chmod(file.getAbsolutePath(), 420);
                        return new ParcelFileDescriptor(fd);
                    }
                    catch (ErrnoException e) {
                        throw new RemoteException("Failed to open: " + e.getMessage());
                    }
                }
            };
            int ret = 1;
            ret = imcs.copyPackage(this.origin.file.getAbsolutePath(), target);
            if (ret != 1) {
                Slog.e(PackageManagerService.TAG, "Failed to copy package");
                return ret;
            }
            File libraryRoot = new File(this.codeFile, "lib");
            NativeLibraryHelper.Handle handle = null;
            try {
                handle = NativeLibraryHelper.Handle.create(this.codeFile);
                ret = NativeLibraryHelper.copyNativeBinariesWithOverride(handle, libraryRoot, this.abiOverride);
            }
            catch (IOException e) {
                Slog.e(PackageManagerService.TAG, "Copying native libraries failed", e);
                ret = -110;
            }
            finally {
                IoUtils.closeQuietly(handle);
            }
            return ret;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            if (status != 1) {
                this.cleanUp();
                return false;
            }
            File beforeCodeFile = this.codeFile;
            File afterCodeFile = PackageManagerService.this.getNextCodePath(pkg.packageName);
            Slog.d(PackageManagerService.TAG, "Renaming " + beforeCodeFile + " to " + afterCodeFile);
            try {
                Os.rename(beforeCodeFile.getAbsolutePath(), afterCodeFile.getAbsolutePath());
            }
            catch (ErrnoException e) {
                Slog.d(PackageManagerService.TAG, "Failed to rename", e);
                return false;
            }
            if (!SELinux.restoreconRecursive(afterCodeFile)) {
                Slog.d(PackageManagerService.TAG, "Failed to restorecon");
                return false;
            }
            this.codeFile = afterCodeFile;
            this.resourceFile = afterCodeFile;
            pkg.codePath = afterCodeFile.getAbsolutePath();
            pkg.baseCodePath = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.baseCodePath);
            pkg.splitCodePaths = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.splitCodePaths);
            pkg.applicationInfo.setCodePath(pkg.codePath);
            pkg.applicationInfo.setBaseCodePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitCodePaths(pkg.splitCodePaths);
            pkg.applicationInfo.setResourcePath(pkg.codePath);
            pkg.applicationInfo.setBaseResourcePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        String getCodePath() {
            return this.codeFile != null ? this.codeFile.getAbsolutePath() : null;
        }

        @Override
        String getResourcePath() {
            return this.resourceFile != null ? this.resourceFile.getAbsolutePath() : null;
        }

        @Override
        String getLegacyNativeLibraryPath() {
            return this.legacyNativeLibraryPath != null ? this.legacyNativeLibraryPath.getAbsolutePath() : null;
        }

        private boolean cleanUp() {
            if (this.codeFile == null || !this.codeFile.exists()) {
                return false;
            }
            if (this.codeFile.isDirectory()) {
                FileUtils.deleteContents(this.codeFile);
            }
            this.codeFile.delete();
            if (this.resourceFile != null && !FileUtils.contains(this.codeFile, this.resourceFile)) {
                this.resourceFile.delete();
            }
            if (this.legacyNativeLibraryPath != null && !FileUtils.contains(this.codeFile, this.legacyNativeLibraryPath)) {
                if (!FileUtils.deleteContents(this.legacyNativeLibraryPath)) {
                    Slog.w(PackageManagerService.TAG, "Couldn't delete native library directory " + this.legacyNativeLibraryPath);
                }
                this.legacyNativeLibraryPath.delete();
            }
            return true;
        }

        @Override
        void cleanUpResourcesLI() {
            List<String> allCodePaths = Collections.EMPTY_LIST;
            if (this.codeFile != null && this.codeFile.exists()) {
                try {
                    PackageParser.PackageLite pkg = PackageParser.parsePackageLite(this.codeFile, 0);
                    allCodePaths = pkg.getAllCodePaths();
                }
                catch (PackageParser.PackageParserException pkg) {
                    // empty catch block
                }
            }
            this.cleanUp();
            if (!allCodePaths.isEmpty()) {
                if (this.instructionSets == null) {
                    throw new IllegalStateException("instructionSet == null");
                }
                String[] dexCodeInstructionSets = PackageManagerService.getDexCodeInstructionSets(this.instructionSets);
                for (String codePath : allCodePaths) {
                    for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                        int retCode = PackageManagerService.this.mInstaller.rmdex(codePath, dexCodeInstructionSet);
                        if (retCode >= 0) continue;
                        Slog.w(PackageManagerService.TAG, "Couldn't remove dex file for package:  at location " + codePath + ", retcode=" + retCode);
                    }
                }
            }
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            this.cleanUpResourcesLI();
            return true;
        }
    }

    static abstract class InstallArgs {
        final OriginInfo origin;
        final IPackageInstallObserver2 observer;
        final int installFlags;
        final String installerPackageName;
        final ManifestDigest manifestDigest;
        final UserHandle user;
        final String abiOverride;
        String[] instructionSets;

        InstallArgs(OriginInfo origin, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, ManifestDigest manifestDigest, UserHandle user, String[] instructionSets, String abiOverride) {
            this.origin = origin;
            this.installFlags = installFlags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.manifestDigest = manifestDigest;
            this.user = user;
            this.instructionSets = instructionSets;
            this.abiOverride = abiOverride;
        }

        abstract int copyApk(IMediaContainerService var1, boolean var2) throws RemoteException;

        abstract int doPreInstall(int var1);

        abstract boolean doRename(int var1, PackageParser.Package var2, String var3);

        abstract int doPostInstall(int var1, int var2);

        abstract String getCodePath();

        abstract String getResourcePath();

        abstract String getLegacyNativeLibraryPath();

        abstract void cleanUpResourcesLI();

        abstract boolean doPostDeleteLI(boolean var1);

        abstract boolean checkFreeStorage(IMediaContainerService var1) throws RemoteException;

        int doPreCopy() {
            return 1;
        }

        int doPostCopy(int uid) {
            return 1;
        }

        protected boolean isFwdLocked() {
            return (this.installFlags & 1) != 0;
        }

        protected boolean isExternal() {
            return (this.installFlags & 8) != 0;
        }

        UserHandle getUser() {
            return this.user;
        }
    }

    class InstallParams
    extends HandlerParams {
        final OriginInfo origin;
        final IPackageInstallObserver2 observer;
        int installFlags;
        final String installerPackageName;
        final VerificationParams verificationParams;
        private InstallArgs mArgs;
        private int mRet;
        final String packageAbiOverride;

        InstallParams(OriginInfo origin, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, VerificationParams verificationParams, UserHandle user, String packageAbiOverride) {
            super(user);
            this.origin = origin;
            this.observer = observer;
            this.installFlags = installFlags;
            this.installerPackageName = installerPackageName;
            this.verificationParams = verificationParams;
            this.packageAbiOverride = packageAbiOverride;
        }

        public String toString() {
            return "InstallParams{" + Integer.toHexString(System.identityHashCode(this)) + " file=" + this.origin.file + " cid=" + this.origin.cid + "}";
        }

        public ManifestDigest getManifestDigest() {
            if (this.verificationParams == null) {
                return null;
            }
            return this.verificationParams.getManifestDigest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int installLocationPolicy(PackageInfoLite pkgLite) {
            String packageName = pkgLite.packageName;
            int installLocation = pkgLite.installLocation;
            boolean onSd = (this.installFlags & 8) != 0;
            HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
            synchronized (hashMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                if (pkg != null) {
                    if ((this.installFlags & 2) != 0) {
                        if ((this.installFlags & 0x80) == 0 && pkgLite.versionCode < pkg.mVersionCode) {
                            Slog.w(PackageManagerService.TAG, "Can't install update of " + packageName + " update version " + pkgLite.versionCode + " is older than installed version " + pkg.mVersionCode);
                            return -7;
                        }
                        if ((pkg.applicationInfo.flags & 1) != 0) {
                            if (onSd) {
                                Slog.w(PackageManagerService.TAG, "Cannot install update to system app on sdcard");
                                return -3;
                            }
                            return 1;
                        }
                        if (onSd) {
                            return 2;
                        }
                        if (installLocation == 1) {
                            return 1;
                        }
                        if (installLocation != 2) {
                            if (PackageManagerService.isExternal(pkg)) {
                                return 2;
                            }
                            return 1;
                        }
                    } else {
                        return -4;
                    }
                }
            }
            if (onSd) {
                return 2;
            }
            return pkgLite.recommendedInstallLocation;
        }

        @Override
        public void handleStartCopy() throws RemoteException {
            InstallArgs args;
            int ret = 1;
            if (this.origin.staged) {
                if (this.origin.file != null) {
                    this.installFlags |= 0x10;
                    this.installFlags &= 0xFFFFFFF7;
                } else if (this.origin.cid != null) {
                    this.installFlags |= 8;
                    this.installFlags &= 0xFFFFFFEF;
                } else {
                    throw new IllegalStateException("Invalid stage location");
                }
            }
            boolean onSd = (this.installFlags & 8) != 0;
            boolean onInt = (this.installFlags & 0x10) != 0;
            PackageInfoLite pkgLite = null;
            if (onInt && onSd) {
                Slog.w(PackageManagerService.TAG, "Conflicting flags specified for installing on both internal and external");
                ret = -19;
            } else {
                pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
                if (!this.origin.staged && pkgLite.recommendedInstallLocation == -1) {
                    StorageManager storage = StorageManager.from(PackageManagerService.this.mContext);
                    long lowThreshold = storage.getStorageLowBytes(Environment.getDataDirectory());
                    long sizeBytes = PackageManagerService.this.mContainerService.calculateInstalledSize(this.origin.resolvedPath, this.isForwardLocked(), this.packageAbiOverride);
                    if (PackageManagerService.this.mInstaller.freeCache(sizeBytes + lowThreshold) >= 0) {
                        pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
                    }
                    if (pkgLite.recommendedInstallLocation == -6) {
                        pkgLite.recommendedInstallLocation = -1;
                    }
                }
            }
            if (ret == 1) {
                int loc = pkgLite.recommendedInstallLocation;
                if (loc == -3) {
                    ret = -19;
                } else if (loc == -4) {
                    ret = -1;
                } else if (loc == -1) {
                    ret = -4;
                } else if (loc == -2) {
                    ret = -2;
                } else if (loc == -6) {
                    ret = -3;
                } else if (loc == -5) {
                    ret = -20;
                } else {
                    loc = this.installLocationPolicy(pkgLite);
                    if (loc == -7) {
                        ret = -25;
                    } else if (!onSd && !onInt) {
                        if (loc == 2) {
                            this.installFlags |= 8;
                            this.installFlags &= 0xFFFFFFEF;
                        } else {
                            this.installFlags |= 0x10;
                            this.installFlags &= 0xFFFFFFF7;
                        }
                    }
                }
            }
            this.mArgs = args = PackageManagerService.this.createInstallArgs(this);
            if (ret == 1) {
                int requiredUid;
                int userIdentifier = this.getUser().getIdentifier();
                if (userIdentifier == -1 && (this.installFlags & 0x20) != 0) {
                    userIdentifier = 0;
                }
                int n = requiredUid = PackageManagerService.this.mRequiredVerifierPackage == null ? -1 : PackageManagerService.this.getPackageUid(PackageManagerService.this.mRequiredVerifierPackage, userIdentifier);
                if (!this.origin.existing && requiredUid != -1 && PackageManagerService.this.isVerificationEnabled(userIdentifier, this.installFlags)) {
                    Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
                    verification.setDataAndType(Uri.fromFile(new File(this.origin.resolvedPath)), PackageManagerService.PACKAGE_MIME_TYPE);
                    verification.addFlags(1);
                    List<ResolveInfo> receivers = PackageManagerService.this.queryIntentReceivers(verification, PackageManagerService.PACKAGE_MIME_TYPE, 512, 0);
                    final int verificationId = PackageManagerService.this.mPendingVerificationToken++;
                    verification.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_PACKAGE", this.installerPackageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALL_FLAGS", this.installFlags);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_PACKAGE_NAME", pkgLite.packageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_VERSION_CODE", pkgLite.versionCode);
                    if (this.verificationParams != null) {
                        if (this.verificationParams.getVerificationURI() != null) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_URI", this.verificationParams.getVerificationURI());
                        }
                        if (this.verificationParams.getOriginatingURI() != null) {
                            verification.putExtra("android.intent.extra.ORIGINATING_URI", this.verificationParams.getOriginatingURI());
                        }
                        if (this.verificationParams.getReferrer() != null) {
                            verification.putExtra("android.intent.extra.REFERRER", this.verificationParams.getReferrer());
                        }
                        if (this.verificationParams.getOriginatingUid() >= 0) {
                            verification.putExtra("android.intent.extra.ORIGINATING_UID", this.verificationParams.getOriginatingUid());
                        }
                        if (this.verificationParams.getInstallerUid() >= 0) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_UID", this.verificationParams.getInstallerUid());
                        }
                    }
                    PackageVerificationState verificationState = new PackageVerificationState(requiredUid, args);
                    PackageManagerService.this.mPendingVerification.append(verificationId, verificationState);
                    List sufficientVerifiers = PackageManagerService.this.matchVerifiers(pkgLite, receivers, verificationState);
                    if (sufficientVerifiers != null) {
                        int N = sufficientVerifiers.size();
                        if (N == 0) {
                            Slog.i(PackageManagerService.TAG, "Additional verifiers required, but none installed.");
                            ret = -22;
                        } else {
                            for (int i = 0; i < N; ++i) {
                                ComponentName verifierComponent = (ComponentName)sufficientVerifiers.get(i);
                                Intent sufficientIntent = new Intent(verification);
                                sufficientIntent.setComponent(verifierComponent);
                                PackageManagerService.this.mContext.sendBroadcastAsUser(sufficientIntent, this.getUser());
                            }
                        }
                    }
                    ComponentName requiredVerifierComponent = PackageManagerService.this.matchComponentForVerifier(PackageManagerService.this.mRequiredVerifierPackage, receivers);
                    if (ret == 1 && PackageManagerService.this.mRequiredVerifierPackage != null) {
                        verification.setComponent(requiredVerifierComponent);
                        PackageManagerService.this.mContext.sendOrderedBroadcastAsUser(verification, this.getUser(), "android.permission.PACKAGE_VERIFICATION_AGENT", new BroadcastReceiver(){

                            @Override
                            public void onReceive(Context context, Intent intent) {
                                Message msg = PackageManagerService.this.mHandler.obtainMessage(16);
                                msg.arg1 = verificationId;
                                PackageManagerService.this.mHandler.sendMessageDelayed(msg, PackageManagerService.this.getVerificationTimeout());
                            }
                        }, null, 0, null, null);
                        this.mArgs = null;
                    }
                } else {
                    ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                }
            }
            this.mRet = ret;
        }

        @Override
        void handleReturnCode() {
            if (this.mArgs != null) {
                PackageManagerService.this.processPendingInstall(this.mArgs, this.mRet);
            }
        }

        @Override
        void handleServiceError() {
            this.mArgs = PackageManagerService.this.createInstallArgs(this);
            this.mRet = -110;
        }

        public boolean isForwardLocked() {
            return (this.installFlags & 1) != 0;
        }
    }

    static class OriginInfo {
        final File file;
        final String cid;
        final boolean staged;
        final boolean existing;
        final String resolvedPath;
        final File resolvedFile;

        static OriginInfo fromNothing() {
            return new OriginInfo(null, null, false, false);
        }

        static OriginInfo fromUntrustedFile(File file) {
            return new OriginInfo(file, null, false, false);
        }

        static OriginInfo fromExistingFile(File file) {
            return new OriginInfo(file, null, false, true);
        }

        static OriginInfo fromStagedFile(File file) {
            return new OriginInfo(file, null, true, false);
        }

        static OriginInfo fromStagedContainer(String cid) {
            return new OriginInfo(null, cid, true, false);
        }

        private OriginInfo(File file, String cid, boolean staged, boolean existing) {
            this.file = file;
            this.cid = cid;
            this.staged = staged;
            this.existing = existing;
            if (cid != null) {
                this.resolvedPath = PackageHelper.getSdDir(cid);
                this.resolvedFile = new File(this.resolvedPath);
            } else if (file != null) {
                this.resolvedPath = file.getAbsolutePath();
                this.resolvedFile = file;
            } else {
                this.resolvedPath = null;
                this.resolvedFile = null;
            }
        }
    }

    class MeasureParams
    extends HandlerParams {
        private final PackageStats mStats;
        private boolean mSuccess;
        private final IPackageStatsObserver mObserver;

        public MeasureParams(PackageStats stats, IPackageStatsObserver observer) {
            super(new UserHandle(stats.userHandle));
            this.mObserver = observer;
            this.mStats = stats;
        }

        public String toString() {
            return "MeasureParams{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mStats.packageName + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleStartCopy() throws RemoteException {
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                this.mSuccess = PackageManagerService.this.getPackageSizeInfoLI(this.mStats.packageName, this.mStats.userHandle, this.mStats);
            }
            if (this.mSuccess) {
                boolean mounted;
                if (Environment.isExternalStorageEmulated()) {
                    mounted = true;
                } else {
                    String status = Environment.getExternalStorageState();
                    boolean bl = mounted = "mounted".equals(status) || "mounted_ro".equals(status);
                }
                if (mounted) {
                    Environment.UserEnvironment userEnv = new Environment.UserEnvironment(this.mStats.userHandle);
                    this.mStats.externalCacheSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppCacheDirs(this.mStats.packageName));
                    this.mStats.externalDataSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppDataDirs(this.mStats.packageName));
                    this.mStats.externalDataSize -= this.mStats.externalCacheSize;
                    this.mStats.externalMediaSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppMediaDirs(this.mStats.packageName));
                    this.mStats.externalObbSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppObbDirs(this.mStats.packageName));
                }
            }
        }

        @Override
        void handleReturnCode() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onGetStatsCompleted(this.mStats, this.mSuccess);
                }
                catch (RemoteException e) {
                    Slog.i(PackageManagerService.TAG, "Observer no longer exists.");
                }
            }
        }

        @Override
        void handleServiceError() {
            Slog.e(PackageManagerService.TAG, "Could not measure application " + this.mStats.packageName + " external storage");
        }
    }

    private abstract class HandlerParams {
        private static final int MAX_RETRIES = 4;
        private int mRetries = 0;
        private final UserHandle mUser;

        HandlerParams(UserHandle user) {
            this.mUser = user;
        }

        UserHandle getUser() {
            return this.mUser;
        }

        final boolean startCopy() {
            boolean res;
            try {
                if (++this.mRetries > 4) {
                    Slog.w(PackageManagerService.TAG, "Failed to invoke remote methods on default container service. Giving up");
                    PackageManagerService.this.mHandler.sendEmptyMessage(11);
                    this.handleServiceError();
                    return false;
                }
                this.handleStartCopy();
                res = true;
            }
            catch (RemoteException e) {
                PackageManagerService.this.mHandler.sendEmptyMessage(10);
                res = false;
            }
            this.handleReturnCode();
            return res;
        }

        final void serviceError() {
            this.handleServiceError();
            this.handleReturnCode();
        }

        abstract void handleStartCopy() throws RemoteException;

        abstract void handleServiceError();

        abstract void handleReturnCode();
    }

    private final class ProviderIntentResolver
    extends IntentResolver<PackageParser.ProviderIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Provider> mProviders = new HashMap();
        private int mFlags;

        private ProviderIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Provider> packageProviders, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageProviders == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageProviders.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageProviders.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ProviderIntentInfo[] array2 = new PackageParser.ProviderIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addProvider(PackageParser.Provider p) {
            if (this.mProviders.containsKey(p.getComponentName())) {
                Slog.w(PackageManagerService.TAG, "Provider " + p.getComponentName() + " already defined; ignoring");
                return;
            }
            this.mProviders.put(p.getComponentName(), p);
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Provider " + p.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeProvider(PackageParser.Provider p) {
            this.mProviders.remove(p.getComponentName());
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ProviderIntentInfo filter, List<ResolveInfo> dest) {
            ProviderInfo filterPi = filter.provider.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ProviderInfo destPi = dest.get((int)i).providerInfo;
                if (destPi.name != filterPi.name || destPi.packageName != filterPi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ProviderIntentInfo[] newArray(int size) {
            return new PackageParser.ProviderIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ProviderIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.provider.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ProviderIntentInfo info) {
            return packageName.equals(info.provider.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ProviderIntentInfo filter, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ProviderIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.provider.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Provider provider = info.provider;
            if (PackageManagerService.this.mSafeMode && (provider.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)provider.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ProviderInfo pi = PackageParser.generateProviderInfo(provider, this.mFlags, ps.readUserState(userId), userId);
            if (pi == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.providerInfo = pi;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = provider.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = PackageManagerService.isSystemApp(res.providerInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ProviderIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.provider)));
            out.print(' ');
            filter.provider.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    private final class ServiceIntentResolver
    extends IntentResolver<PackageParser.ServiceIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Service> mServices = new HashMap();
        private int mFlags;

        private ServiceIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Service> packageServices, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageServices == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageServices.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageServices.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ServiceIntentInfo[] array2 = new PackageParser.ServiceIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addService(PackageParser.Service s) {
            this.mServices.put(s.getComponentName(), s);
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Service " + s.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeService(PackageParser.Service s) {
            this.mServices.remove(s.getComponentName());
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ServiceIntentInfo filter, List<ResolveInfo> dest) {
            ServiceInfo filterSi = filter.service.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ServiceInfo destAi = dest.get((int)i).serviceInfo;
                if (destAi.name != filterSi.name || destAi.packageName != filterSi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ServiceIntentInfo[] newArray(int size) {
            return new PackageParser.ServiceIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ServiceIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.service.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ServiceIntentInfo info) {
            return packageName.equals(info.service.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ServiceIntentInfo filter, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ServiceIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.service.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Service service = info.service;
            if (PackageManagerService.this.mSafeMode && (service.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)service.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ServiceInfo si = PackageParser.generateServiceInfo(service, this.mFlags, ps.readUserState(userId), userId);
            if (si == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.serviceInfo = si;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = service.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = PackageManagerService.isSystemApp(res.serviceInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ServiceIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.service)));
            out.print(' ');
            filter.service.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    final class ActivityIntentResolver
    extends IntentResolver<PackageParser.ActivityIntentInfo, ResolveInfo> {
        private final HashMap<ComponentName, PackageParser.Activity> mActivities = new HashMap();
        private int mFlags;

        ActivityIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Activity> packageActivities, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageActivities == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageActivities.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageActivities.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ActivityIntentInfo[] array2 = new PackageParser.ActivityIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addActivity(PackageParser.Activity a, String type) {
            boolean systemApp = PackageManagerService.isSystemApp(a.info.applicationInfo);
            this.mActivities.put(a.getComponentName(), a);
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                if (!systemApp && intent.getPriority() > 0 && "activity".equals(type)) {
                    intent.setPriority(0);
                    Log.w(PackageManagerService.TAG, "Package " + a.info.applicationInfo.packageName + " has activity " + a.className + " with priority > 0, forcing to 0");
                }
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Activity " + a.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeActivity(PackageParser.Activity a, String type) {
            this.mActivities.remove(a.getComponentName());
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ActivityIntentInfo filter, List<ResolveInfo> dest) {
            ActivityInfo filterAi = filter.activity.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ActivityInfo destAi = dest.get((int)i).activityInfo;
                if (destAi.name != filterAi.name || destAi.packageName != filterAi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ActivityIntentInfo[] newArray(int size) {
            return new PackageParser.ActivityIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ActivityIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.activity.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ActivityIntentInfo info) {
            return packageName.equals(info.activity.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ActivityIntentInfo info, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.activity.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Activity activity = info.activity;
            if (PackageManagerService.this.mSafeMode && (activity.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)activity.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ActivityInfo ai = PackageParser.generateActivityInfo(activity, this.mFlags, ps.readUserState(userId), userId);
            if (ai == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.activityInfo = ai;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = info;
            }
            res.priority = info.getPriority();
            res.preferredOrder = activity.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            if (PackageManagerService.this.userNeedsBadging(userId)) {
                res.noResourceId = true;
            } else {
                res.icon = info.icon;
            }
            res.system = PackageManagerService.isSystemApp(res.activityInfo.applicationInfo);
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ActivityIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.activity)));
            out.print(' ');
            filter.activity.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }
    }

    class PackageHandler
    extends Handler {
        private boolean mBound;
        final ArrayList<HandlerParams> mPendingInstalls;

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            Process.setThreadPriority(0);
            if (PackageManagerService.this.mContext.bindServiceAsUser(service, PackageManagerService.this.mDefContainerConn, 1, UserHandle.OWNER)) {
                Process.setThreadPriority(10);
                this.mBound = true;
                return true;
            }
            Process.setThreadPriority(10);
            return false;
        }

        private void disconnectService() {
            PackageManagerService.this.mContainerService = null;
            this.mBound = false;
            Process.setThreadPriority(0);
            PackageManagerService.this.mContext.unbindService(PackageManagerService.this.mDefContainerConn);
            Process.setThreadPriority(10);
        }

        PackageHandler(Looper looper) {
            super(looper);
            this.mBound = false;
            this.mPendingInstalls = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            try {
                this.doHandleMessage(msg);
            }
            finally {
                Process.setThreadPriority(10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doHandleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    HandlerParams params = (HandlerParams)msg.obj;
                    int idx = this.mPendingInstalls.size();
                    if (!this.mBound) {
                        if (!this.connectToService()) {
                            Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                            params.serviceError();
                            return;
                        }
                        this.mPendingInstalls.add(idx, params);
                        break;
                    }
                    this.mPendingInstalls.add(idx, params);
                    if (idx != 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 3: {
                    if (msg.obj != null) {
                        PackageManagerService.this.mContainerService = (IMediaContainerService)msg.obj;
                    }
                    if (PackageManagerService.this.mContainerService == null) {
                        Slog.e(PackageManagerService.TAG, "Cannot bind to media container service");
                        for (HandlerParams params : this.mPendingInstalls) {
                            params.serviceError();
                        }
                        this.mPendingInstalls.clear();
                        break;
                    }
                    if (this.mPendingInstalls.size() > 0) {
                        HandlerParams params = this.mPendingInstalls.get(0);
                        if (params == null || !params.startCopy()) break;
                        if (this.mPendingInstalls.size() > 0) {
                            this.mPendingInstalls.remove(0);
                        }
                        if (this.mPendingInstalls.size() == 0) {
                            if (!this.mBound) break;
                            this.removeMessages(6);
                            Message ubmsg = this.obtainMessage(6);
                            this.sendMessageDelayed(ubmsg, 10000L);
                            break;
                        }
                        PackageManagerService.this.mHandler.sendEmptyMessage(3);
                        break;
                    }
                    Slog.w(PackageManagerService.TAG, "Empty queue");
                    break;
                }
                case 10: {
                    if (this.mPendingInstalls.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                    for (HandlerParams params : this.mPendingInstalls) {
                        params.serviceError();
                    }
                    this.mPendingInstalls.clear();
                    break;
                }
                case 6: {
                    if (this.mPendingInstalls.size() == 0 && PackageManagerService.this.mPendingVerification.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    if (this.mPendingInstalls.size() <= 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 11: {
                    this.mPendingInstalls.remove(0);
                    break;
                }
                case 1: {
                    int[] uids;
                    ArrayList[] components;
                    String[] packages;
                    int size = 0;
                    Process.setThreadPriority(0);
                    HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
                    synchronized (hashMap) {
                        if (PackageManagerService.this.mPendingBroadcasts == null) {
                            return;
                        }
                        size = PackageManagerService.this.mPendingBroadcasts.size();
                        if (size <= 0) {
                            return;
                        }
                        packages = new String[size];
                        components = new ArrayList[size];
                        uids = new int[size];
                        int i = 0;
                        for (int n = 0; n < PackageManagerService.this.mPendingBroadcasts.userIdCount(); ++n) {
                            int packageUserId = PackageManagerService.this.mPendingBroadcasts.userIdAt(n);
                            Iterator<Map.Entry<String, ArrayList<String>>> it = PackageManagerService.this.mPendingBroadcasts.packagesForUserId(packageUserId).entrySet().iterator();
                            while (it.hasNext() && i < size) {
                                Map.Entry<String, ArrayList<String>> ent = it.next();
                                packages[i] = ent.getKey();
                                components[i] = ent.getValue();
                                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(ent.getKey());
                                uids[i] = ps != null ? UserHandle.getUid(packageUserId, ps.appId) : -1;
                                ++i;
                            }
                        }
                        size = i;
                        PackageManagerService.this.mPendingBroadcasts.clear();
                    }
                    for (int i = 0; i < size; ++i) {
                        PackageManagerService.this.sendPackageChangedBroadcast(packages[i], true, components[i], uids[i]);
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 7: {
                    Process.setThreadPriority(0);
                    String packageName = (String)msg.obj;
                    int userId = msg.arg1;
                    boolean andCode = msg.arg2 != 0;
                    HashMap<String, PackageParser.Package> uids = PackageManagerService.this.mPackages;
                    synchronized (uids) {
                        if (userId == -1) {
                            int[] users;
                            for (int user : users = sUserManager.getUserIds()) {
                                PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(user, packageName, andCode));
                            }
                        } else {
                            PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(userId, packageName, andCode));
                        }
                    }
                    Process.setThreadPriority(10);
                    PackageManagerService.this.startCleaningPackages();
                    break;
                }
                case 9: {
                    PostInstallData data = PackageManagerService.this.mRunningInstalls.get(msg.arg1);
                    PackageManagerService.this.mRunningInstalls.delete(msg.arg1);
                    boolean deleteOld = false;
                    if (data != null) {
                        Object extras;
                        InstallArgs args = data.args;
                        PackageInstalledInfo res = data.res;
                        if (res.returnCode == 1) {
                            boolean update;
                            int[] firstUsers;
                            res.removedInfo.sendBroadcast(false, true, false);
                            extras = new Bundle(1);
                            ((BaseBundle)extras).putInt("android.intent.extra.UID", res.uid);
                            int[] updateUsers = new int[]{};
                            if (res.origUsers == null || res.origUsers.length == 0) {
                                firstUsers = res.newUsers;
                            } else {
                                firstUsers = new int[]{};
                                for (int i = 0; i < res.newUsers.length; ++i) {
                                    int user = res.newUsers[i];
                                    boolean isNew = true;
                                    for (int j = 0; j < res.origUsers.length; ++j) {
                                        if (res.origUsers[j] != user) continue;
                                        isNew = false;
                                        break;
                                    }
                                    if (isNew) {
                                        int[] newFirst = new int[firstUsers.length + 1];
                                        System.arraycopy((int[])firstUsers, (int)0, (int[])newFirst, (int)0, (int)firstUsers.length);
                                        newFirst[firstUsers.length] = user;
                                        firstUsers = newFirst;
                                        continue;
                                    }
                                    int[] newUpdate = new int[updateUsers.length + 1];
                                    System.arraycopy((int[])updateUsers, (int)0, (int[])newUpdate, (int)0, (int)updateUsers.length);
                                    newUpdate[updateUsers.length] = user;
                                    updateUsers = newUpdate;
                                }
                            }
                            PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null, firstUsers);
                            boolean bl = update = res.removedInfo.removedPackage != null;
                            if (update) {
                                ((Bundle)extras).putBoolean("android.intent.extra.REPLACING", true);
                            }
                            PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null, updateUsers);
                            if (update) {
                                PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", res.pkg.applicationInfo.packageName, (Bundle)extras, null, null, updateUsers);
                                PackageManagerService.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, res.pkg.applicationInfo.packageName, null, updateUsers);
                                if (PackageManagerService.isForwardLocked(res.pkg) || PackageManagerService.isExternal(res.pkg)) {
                                    int[] uidArray = new int[]{res.pkg.applicationInfo.uid};
                                    ArrayList<String> pkgList = new ArrayList<String>(1);
                                    pkgList.add(res.pkg.applicationInfo.packageName);
                                    PackageManagerService.this.sendResourcesChangedBroadcast(true, true, pkgList, uidArray, null);
                                }
                            }
                            if (res.removedInfo.args != null) {
                                deleteOld = true;
                            }
                            EventLog.writeEvent(3110, PackageManagerService.this.getUnknownSourcesSettings());
                        }
                        Runtime.getRuntime().gc();
                        if (deleteOld) {
                            extras = PackageManagerService.this.mInstallLock;
                            synchronized (extras) {
                                res.removedInfo.args.doPostDeleteLI(true);
                            }
                        }
                        if (args.observer == null) break;
                        try {
                            extras = PackageManagerService.this.extrasForInstallResult(res);
                            args.observer.onPackageInstalled(res.name, res.returnCode, res.returnMsg, (Bundle)extras);
                        }
                        catch (RemoteException e) {
                            Slog.i(PackageManagerService.TAG, "Observer no longer exists.");
                        }
                        break;
                    }
                    Slog.e(PackageManagerService.TAG, "Bogus post-install token " + msg.arg1);
                    break;
                }
                case 12: {
                    boolean doGc;
                    boolean reportStatus = msg.arg1 == 1;
                    boolean bl = doGc = msg.arg2 == 1;
                    if (doGc) {
                        Runtime.getRuntime().gc();
                    }
                    if (msg.obj != null) {
                        Set args = (Set)msg.obj;
                        PackageManagerService.this.unloadAllContainers(args);
                    }
                    if (!reportStatus) break;
                    try {
                        PackageHelper.getMountService().finishMediaUpdate();
                    }
                    catch (RemoteException e) {
                        Log.e(PackageManagerService.TAG, "MountService not running?");
                    }
                    break;
                }
                case 13: {
                    Process.setThreadPriority(0);
                    HashMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(13);
                        this.removeMessages(14);
                        PackageManagerService.this.mSettings.writeLPr();
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 14: {
                    Process.setThreadPriority(0);
                    HashMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(14);
                        Iterator i$ = PackageManagerService.this.mDirtyUsers.iterator();
                        while (i$.hasNext()) {
                            int userId = (Integer)i$.next();
                            PackageManagerService.this.mSettings.writePackageRestrictionsLPr(userId);
                        }
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 16: {
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null || state.timeoutExtended()) break;
                    InstallArgs args = state.getInstallArgs();
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    Slog.i(PackageManagerService.TAG, "Verification timed out for " + originUri);
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    int ret = -22;
                    if (PackageManagerService.this.getDefaultVerificationResponse() == 1) {
                        Slog.i(PackageManagerService.TAG, "Continuing with installation of " + originUri);
                        state.setVerifierResponse(Binder.getCallingUid(), 2);
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, 1, state.getInstallArgs().getUser());
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, -1, state.getInstallArgs().getUser());
                    }
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
                case 15: {
                    int ret;
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid verification token " + verificationId + " received");
                        break;
                    }
                    PackageVerificationResponse response = (PackageVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    InstallArgs args = state.getInstallArgs();
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    if (state.isInstallAllowed()) {
                        ret = -110;
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, response.code, state.getInstallArgs().getUser());
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        ret = -22;
                    }
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
            }
        }
    }

    private class PackageUsage {
        private static final int WRITE_INTERVAL = 1800000;
        private final Object mFileLock = new Object();
        private final AtomicLong mLastWritten = new AtomicLong(0L);
        private final AtomicBoolean mBackgroundWriteRunning = new AtomicBoolean(false);
        private boolean mIsHistoricalPackageUsageAvailable = true;

        private PackageUsage() {
        }

        boolean isHistoricalPackageUsageAvailable() {
            return this.mIsHistoricalPackageUsageAvailable;
        }

        void write(boolean force) {
            if (force) {
                this.writeInternal();
                return;
            }
            if (SystemClock.elapsedRealtime() - this.mLastWritten.get() < 1800000L) {
                return;
            }
            if (this.mBackgroundWriteRunning.compareAndSet(false, true)) {
                new Thread("PackageUsage_DiskWriter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            PackageUsage.this.writeInternal();
                        }
                        finally {
                            PackageUsage.this.mBackgroundWriteRunning.set(false);
                        }
                    }
                }.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeInternal() {
            HashMap<String, PackageParser.Package> hashMap = PackageManagerService.this.mPackages;
            synchronized (hashMap) {
                Object object = this.mFileLock;
                synchronized (object) {
                    AtomicFile file = this.getFile();
                    FileOutputStream f = null;
                    try {
                        f = file.startWrite();
                        BufferedOutputStream out = new BufferedOutputStream(f);
                        FileUtils.setPermissions(file.getBaseFile().getPath(), 432, 1000, 1032);
                        StringBuilder sb = new StringBuilder();
                        for (PackageParser.Package pkg : PackageManagerService.this.mPackages.values()) {
                            if (pkg.mLastPackageUsageTimeInMills == 0L) continue;
                            sb.setLength(0);
                            sb.append(pkg.packageName);
                            sb.append(' ');
                            sb.append(pkg.mLastPackageUsageTimeInMills);
                            sb.append('\n');
                            out.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
                        }
                        out.flush();
                        file.finishWrite(f);
                    }
                    catch (IOException e) {
                        if (f != null) {
                            file.failWrite(f);
                        }
                        Log.e(PackageManagerService.TAG, "Failed to write package usage times", e);
                    }
                }
            }
            this.mLastWritten.set(SystemClock.elapsedRealtime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        void readLP() {
            Object object = this.mFileLock;
            synchronized (object) {
                AtomicFile file = this.getFile();
                BufferedInputStream in = null;
                try {
                    String packageName;
                    in = new BufferedInputStream(file.openRead());
                    StringBuffer sb = new StringBuffer();
                    while ((packageName = this.readToken(in, sb, ' ')) != null) {
                        long timeInMillis;
                        String timeInMillisString = this.readToken(in, sb, '\n');
                        if (timeInMillisString == null) {
                            throw new IOException("Failed to find last usage time for package " + packageName);
                        }
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                        if (pkg == null) continue;
                        try {
                            timeInMillis = Long.parseLong(timeInMillisString.toString());
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Failed to parse " + timeInMillisString + " as a long.", e);
                        }
                        pkg.mLastPackageUsageTimeInMills = timeInMillis;
                    }
                }
                catch (FileNotFoundException expected) {
                    this.mIsHistoricalPackageUsageAvailable = false;
                    IoUtils.closeQuietly(in);
                }
                catch (IOException e) {
                    Log.w(PackageManagerService.TAG, "Failed to read package usage times", e);
                    {
                        catch (Throwable throwable) {
                            IoUtils.closeQuietly(in);
                            throw throwable;
                        }
                    }
                    IoUtils.closeQuietly(in);
                }
                IoUtils.closeQuietly(in);
            }
            this.mLastWritten.set(SystemClock.elapsedRealtime());
        }

        private String readToken(InputStream in, StringBuffer sb, char endOfToken) throws IOException {
            sb.setLength(0);
            while (true) {
                int ch;
                if ((ch = in.read()) == -1) {
                    if (sb.length() == 0) {
                        return null;
                    }
                    throw new IOException("Unexpected EOF");
                }
                if (ch == endOfToken) {
                    return sb.toString();
                }
                sb.append((char)ch);
            }
        }

        private AtomicFile getFile() {
            File dataDir = Environment.getDataDirectory();
            File systemDir = new File(dataDir, "system");
            File fname = new File(systemDir, "package-usage.list");
            return new AtomicFile(fname);
        }
    }

    class PostInstallData {
        public InstallArgs args;
        public PackageInstalledInfo res;

        PostInstallData(InstallArgs _a, PackageInstalledInfo _r) {
            this.args = _a;
            this.res = _r;
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface(service);
            PackageManagerService.this.mHandler.sendMessage(PackageManagerService.this.mHandler.obtainMessage(3, imcs));
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    static class PendingPackageBroadcasts {
        final SparseArray<HashMap<String, ArrayList<String>>> mUidMap = new SparseArray(2);

        public ArrayList<String> get(int userId, String packageName) {
            HashMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            return packages.get(packageName);
        }

        public void put(int userId, String packageName, ArrayList<String> components) {
            HashMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            packages.put(packageName, components);
        }

        public void remove(int userId, String packageName) {
            HashMap<String, ArrayList<String>> packages = this.mUidMap.get(userId);
            if (packages != null) {
                packages.remove(packageName);
            }
        }

        public void remove(int userId) {
            this.mUidMap.remove(userId);
        }

        public int userIdCount() {
            return this.mUidMap.size();
        }

        public int userIdAt(int n) {
            return this.mUidMap.keyAt(n);
        }

        public HashMap<String, ArrayList<String>> packagesForUserId(int userId) {
            return this.mUidMap.get(userId);
        }

        public int size() {
            int num = 0;
            for (int i = 0; i < this.mUidMap.size(); ++i) {
                num += this.mUidMap.valueAt(i).size();
            }
            return num;
        }

        public void clear() {
            this.mUidMap.clear();
        }

        private HashMap<String, ArrayList<String>> getOrAllocate(int userId) {
            HashMap<String, ArrayList<String>> map = this.mUidMap.get(userId);
            if (map == null) {
                map = new HashMap();
                this.mUidMap.put(userId, map);
            }
            return map;
        }
    }

    public static final class SharedLibraryEntry {
        public final String path;
        public final String apk;

        SharedLibraryEntry(String _path, String _apk) {
            this.path = _path;
            this.apk = _apk;
        }
    }
}

