/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.os.Environment;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SELinuxMMAC {
    private static final String TAG = "SELinuxMMAC";
    private static final boolean DEBUG_POLICY = false;
    private static final boolean DEBUG_POLICY_INSTALL = false;
    private static HashMap<Signature, Policy> sSigSeinfo = new HashMap();
    private static String sDefaultSeinfo = null;
    private static final String DATA_VERSION_FILE = Environment.getDataDirectory() + "/security/current/selinux_version";
    private static final String BASE_VERSION_FILE = "/selinux_version";
    private static final boolean USE_OVERRIDE_POLICY = SELinuxMMAC.useOverridePolicy();
    private static final String DATA_MAC_PERMISSIONS = Environment.getDataDirectory() + "/security/current/mac_permissions.xml";
    private static final String BASE_MAC_PERMISSIONS = Environment.getRootDirectory() + "/etc/security/mac_permissions.xml";
    private static final String MAC_PERMISSIONS = USE_OVERRIDE_POLICY ? DATA_MAC_PERMISSIONS : BASE_MAC_PERMISSIONS;
    private static final String DATA_SEAPP_CONTEXTS = Environment.getDataDirectory() + "/security/current/seapp_contexts";
    private static final String BASE_SEAPP_CONTEXTS = "/seapp_contexts";
    private static final String SEAPP_CONTEXTS = USE_OVERRIDE_POLICY ? DATA_SEAPP_CONTEXTS : "/seapp_contexts";
    private static final String SEAPP_HASH_FILE = Environment.getDataDirectory().toString() + "/system/seapp_hash";

    private static void flushInstallPolicy() {
        sSigSeinfo.clear();
        sDefaultSeinfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean readInstallPolicy() {
        HashMap<Signature, Policy> sigSeinfo = new HashMap<Signature, Policy>();
        String defaultSeinfo = null;
        FileReader policyFile = null;
        try {
            policyFile = new FileReader(MAC_PERMISSIONS);
            Slog.d(TAG, "Using policy file " + MAC_PERMISSIONS);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(policyFile);
            XmlUtils.beginDocument(parser, "policy");
            while (true) {
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1) break;
                String tagName = parser.getName();
                if ("signer".equals(tagName)) {
                    Signature signature;
                    String cert = parser.getAttributeValue(null, "signature");
                    if (cert == null) {
                        Slog.w(TAG, "<signer> without signature at " + parser.getPositionDescription());
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    try {
                        signature = new Signature(cert);
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w(TAG, "<signer> with bad signature at " + parser.getPositionDescription(), e);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    Policy policy = SELinuxMMAC.readPolicyTags(parser);
                    if (!policy.isValid()) continue;
                    sigSeinfo.put(signature, policy);
                    continue;
                }
                if ("default".equals(tagName)) {
                    defaultSeinfo = SELinuxMMAC.readSeinfoTag(parser);
                    continue;
                }
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (XmlPullParserException xpe) {
            Slog.w(TAG, "Got exception parsing " + MAC_PERMISSIONS, xpe);
            boolean bl = false;
            IoUtils.closeQuietly(policyFile);
            return bl;
        }
        catch (IOException ioe) {
            Slog.w(TAG, "Got exception parsing " + MAC_PERMISSIONS, ioe);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(policyFile);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(policyFile);
            return bl;
        }
        IoUtils.closeQuietly(policyFile);
        SELinuxMMAC.flushInstallPolicy();
        sSigSeinfo = sigSeinfo;
        sDefaultSeinfo = defaultSeinfo;
        return true;
    }

    private static Policy readPolicyTags(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        Policy policy = new Policy();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = SELinuxMMAC.parseSeinfo(parser);
                if (seinfo != null) {
                    policy.putSeinfo(seinfo);
                }
                XmlUtils.skipCurrentTag(parser);
                continue;
            }
            if ("package".equals(tagName)) {
                String pkg = parser.getAttributeValue(null, "name");
                if (!SELinuxMMAC.validatePackageName(pkg)) {
                    Slog.w(TAG, "<package> without valid name at " + parser.getPositionDescription());
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                String seinfo = SELinuxMMAC.readSeinfoTag(parser);
                if (seinfo == null) continue;
                policy.putPkg(pkg, seinfo);
                continue;
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return policy;
    }

    private static String readSeinfoTag(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        String seinfo = null;
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                seinfo = SELinuxMMAC.parseSeinfo(parser);
            }
            XmlUtils.skipCurrentTag(parser);
        }
        return seinfo;
    }

    private static String parseSeinfo(XmlPullParser parser) {
        String seinfoValue = parser.getAttributeValue(null, "value");
        if (!SELinuxMMAC.validateValue(seinfoValue)) {
            Slog.w(TAG, "<seinfo> without valid value at " + parser.getPositionDescription());
            seinfoValue = null;
        }
        return seinfoValue;
    }

    private static boolean validatePackageName(String name) {
        if (name == null) {
            return false;
        }
        int N = name.length();
        boolean hasSep = false;
        boolean front = true;
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                front = false;
                continue;
            }
            if (!front && (c >= '0' && c <= '9' || c == '_')) continue;
            if (c == '.') {
                hasSep = true;
                front = true;
                continue;
            }
            return false;
        }
        return hasSep;
    }

    private static boolean validateValue(String name) {
        if (name == null) {
            return false;
        }
        int N = name.length();
        if (N == 0) {
            return false;
        }
        for (int i = 0; i < N; ++i) {
            char c = name.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static boolean assignSeinfoValue(PackageParser.Package pkg) {
        for (Signature s : pkg.mSignatures) {
            String seinfo;
            Policy policy;
            if (s == null || (policy = sSigSeinfo.get(s)) == null || (seinfo = policy.checkPolicy(pkg.packageName)) == null) continue;
            pkg.applicationInfo.seinfo = seinfo;
            return true;
        }
        pkg.applicationInfo.seinfo = sDefaultSeinfo;
        return sDefaultSeinfo != null;
    }

    public static boolean shouldRestorecon() {
        byte[] currentHash = null;
        try {
            currentHash = SELinuxMMAC.returnHash(SEAPP_CONTEXTS);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Error with hashing seapp_contexts.", ioe);
            return false;
        }
        byte[] storedHash = null;
        try {
            storedHash = IoUtils.readFileAsByteArray(SEAPP_HASH_FILE);
        }
        catch (IOException ioe) {
            Slog.w(TAG, "Error opening " + SEAPP_HASH_FILE + ". Assuming first boot.");
        }
        return storedHash == null || !MessageDigest.isEqual(storedHash, currentHash);
    }

    public static void setRestoreconDone() {
        try {
            byte[] currentHash = SELinuxMMAC.returnHash(SEAPP_CONTEXTS);
            SELinuxMMAC.dumpHash(new File(SEAPP_HASH_FILE), currentHash);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Error with saving hash to " + SEAPP_HASH_FILE, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpHash(File file, byte[] content) throws IOException {
        FileOutputStream fos;
        block4: {
            fos = null;
            File tmp = null;
            try {
                tmp = File.createTempFile("seapp_hash", ".journal", file.getParentFile());
                tmp.setReadable(true);
                fos = new FileOutputStream(tmp);
                fos.write(content);
                fos.getFD().sync();
                if (!tmp.renameTo(file)) {
                    throw new IOException("Failure renaming " + file.getCanonicalPath());
                }
                if (tmp == null) break block4;
                tmp.delete();
            }
            catch (Throwable throwable) {
                if (tmp != null) {
                    tmp.delete();
                }
                IoUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(fos);
    }

    private static byte[] returnHash(String file) throws IOException {
        try {
            byte[] contents = IoUtils.readFileAsByteArray(file);
            return MessageDigest.getInstance("SHA-1").digest(contents);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    private static boolean useOverridePolicy() {
        try {
            String overrideVersion = IoUtils.readFileAsString(DATA_VERSION_FILE);
            String baseVersion = IoUtils.readFileAsString(BASE_VERSION_FILE);
            if (overrideVersion.equals(baseVersion)) {
                return true;
            }
            Slog.e(TAG, "Override policy version '" + overrideVersion + "' doesn't match " + "base version '" + baseVersion + "'. Skipping override policy files.");
        }
        catch (FileNotFoundException overrideVersion) {
        }
        catch (IOException ioe) {
            Slog.w(TAG, "Skipping override policy files.", ioe);
        }
        return false;
    }

    static class Policy {
        private String seinfo = null;
        private final HashMap<String, String> pkgMap = new HashMap();

        Policy() {
        }

        void putSeinfo(String seinfoValue) {
            this.seinfo = seinfoValue;
        }

        void putPkg(String pkg, String seinfoValue) {
            this.pkgMap.put(pkg, seinfoValue);
        }

        boolean isValid() {
            return this.seinfo != null || !this.pkgMap.isEmpty();
        }

        String checkPolicy(String pkgName) {
            String seinfoValue = this.pkgMap.get(pkgName);
            if (seinfoValue != null) {
                return seinfoValue;
            }
            return this.seinfo;
        }
    }
}

