/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageCleanItem;
import android.content.pm.PackageParser;
import android.content.pm.PackageUserState;
import android.content.pm.PermissionInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Environment;
import android.os.FileUtils;
import android.os.PatternMatcher;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.BasePermission;
import com.android.server.pm.CrossProfileIntentFilter;
import com.android.server.pm.CrossProfileIntentResolver;
import com.android.server.pm.Installer;
import com.android.server.pm.KeySetManagerService;
import com.android.server.pm.PackageKeySetData;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSettingBase;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.PendingPackage;
import com.android.server.pm.PersistentPreferredActivity;
import com.android.server.pm.PersistentPreferredIntentResolver;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.PreferredIntentResolver;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserManagerService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class Settings {
    private static final String TAG = "PackageSettings";
    private static final int CURRENT_DATABASE_VERSION = 3;
    private static final boolean DEBUG_STOPPED = false;
    private static final boolean DEBUG_MU = false;
    private static final String TAG_READ_EXTERNAL_STORAGE = "read-external-storage";
    private static final String ATTR_ENFORCEMENT = "enforcement";
    private static final String TAG_ITEM = "item";
    private static final String TAG_DISABLED_COMPONENTS = "disabled-components";
    private static final String TAG_ENABLED_COMPONENTS = "enabled-components";
    private static final String TAG_PACKAGE_RESTRICTIONS = "package-restrictions";
    private static final String TAG_PACKAGE = "pkg";
    private static final String TAG_PERSISTENT_PREFERRED_ACTIVITIES = "persistent-preferred-activities";
    static final String TAG_CROSS_PROFILE_INTENT_FILTERS = "crossProfile-intent-filters";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_USER = "user";
    private static final String ATTR_CODE = "code";
    private static final String ATTR_NOT_LAUNCHED = "nl";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_ENABLED_CALLER = "enabledCaller";
    private static final String ATTR_STOPPED = "stopped";
    private static final String ATTR_BLOCKED = "blocked";
    private static final String ATTR_HIDDEN = "hidden";
    private static final String ATTR_INSTALLED = "inst";
    private static final String ATTR_BLOCK_UNINSTALL = "blockUninstall";
    private final File mSettingsFilename;
    private final File mBackupSettingsFilename;
    private final File mPackageListFilename;
    private final File mStoppedPackagesFilename;
    private final File mBackupStoppedPackagesFilename;
    final HashMap<String, PackageSetting> mPackages = new HashMap();
    private final HashMap<String, PackageSetting> mDisabledSysPackages = new HashMap();
    private static int mFirstAvailableUid = 0;
    int mInternalSdkPlatform;
    int mExternalSdkPlatform;
    int mInternalDatabaseVersion;
    int mExternalDatabaseVersion;
    String mFingerprint;
    Boolean mReadExternalStorageEnforced;
    private VerifierDeviceIdentity mVerifierDeviceIdentity;
    final SparseArray<PreferredIntentResolver> mPreferredActivities = new SparseArray();
    final SparseArray<PersistentPreferredIntentResolver> mPersistentPreferredActivities = new SparseArray();
    final SparseArray<CrossProfileIntentResolver> mCrossProfileIntentResolvers = new SparseArray();
    final HashMap<String, SharedUserSetting> mSharedUsers = new HashMap();
    private final ArrayList<Object> mUserIds = new ArrayList();
    private final SparseArray<Object> mOtherUserIds = new SparseArray();
    private final ArrayList<Signature> mPastSignatures = new ArrayList();
    final HashMap<String, BasePermission> mPermissions = new HashMap();
    final HashMap<String, BasePermission> mPermissionTrees = new HashMap();
    final ArrayList<PackageCleanItem> mPackagesToBeCleaned = new ArrayList();
    final HashMap<String, String> mRenamedPackages = new HashMap();
    final StringBuilder mReadMessages = new StringBuilder();
    private final ArrayList<PendingPackage> mPendingPackages = new ArrayList();
    private final File mSystemDir;
    public final KeySetManagerService mKeySetManagerService = new KeySetManagerService(this.mPackages);
    static final Object[] FLAG_DUMP_SPEC = new Object[]{1, "SYSTEM", 2, "DEBUGGABLE", 4, "HAS_CODE", 8, "PERSISTENT", 16, "FACTORY_TEST", 32, "ALLOW_TASK_REPARENTING", 64, "ALLOW_CLEAR_USER_DATA", 128, "UPDATED_SYSTEM_APP", 256, "TEST_ONLY", 16384, "VM_SAFE_MODE", 32768, "ALLOW_BACKUP", 65536, "KILL_AFTER_RESTORE", 131072, "RESTORE_ANY_VERSION", 262144, "EXTERNAL_STORAGE", 0x100000, "LARGE_HEAP", 0x40000000, "PRIVILEGED", 0x20000000, "FORWARD_LOCK", 0x10000000, "CANT_SAVE_STATE"};

    Settings(Context context) {
        this(context, Environment.getDataDirectory());
    }

    Settings(Context context, File dataDir) {
        this.mSystemDir = new File(dataDir, "system");
        this.mSystemDir.mkdirs();
        FileUtils.setPermissions(this.mSystemDir.toString(), 509, -1, -1);
        this.mSettingsFilename = new File(this.mSystemDir, "packages.xml");
        this.mBackupSettingsFilename = new File(this.mSystemDir, "packages-backup.xml");
        this.mPackageListFilename = new File(this.mSystemDir, "packages.list");
        FileUtils.setPermissions(this.mPackageListFilename, 432, 1000, 1032);
        this.mStoppedPackagesFilename = new File(this.mSystemDir, "packages-stopped.xml");
        this.mBackupStoppedPackagesFilename = new File(this.mSystemDir, "packages-stopped-backup.xml");
    }

    PackageSetting getPackageLPw(PackageParser.Package pkg, PackageSetting origPackage, String realName, SharedUserSetting sharedUser, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbi, String secondaryCpuAbi, int pkgFlags, UserHandle user, boolean add) {
        String name = pkg.packageName;
        PackageSetting p = this.getPackageLPw(name, origPackage, realName, sharedUser, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbi, secondaryCpuAbi, pkg.mVersionCode, pkgFlags, user, add, true);
        return p;
    }

    PackageSetting peekPackageLPr(String name) {
        return this.mPackages.get(name);
    }

    void setInstallStatus(String pkgName, int status) {
        PackageSetting p = this.mPackages.get(pkgName);
        if (p != null && p.getInstallStatus() != status) {
            p.setInstallStatus(status);
        }
    }

    void setInstallerPackageName(String pkgName, String installerPkgName) {
        PackageSetting p = this.mPackages.get(pkgName);
        if (p != null) {
            p.setInstallerPackageName(installerPkgName);
        }
    }

    SharedUserSetting getSharedUserLPw(String name, int pkgFlags, boolean create) {
        SharedUserSetting s = this.mSharedUsers.get(name);
        if (s == null) {
            if (!create) {
                return null;
            }
            s = new SharedUserSetting(name, pkgFlags);
            s.userId = this.newUserIdLPw(s);
            Log.i("PackageManager", "New shared user " + name + ": id=" + s.userId);
            if (s.userId >= 0) {
                this.mSharedUsers.put(name, s);
            }
        }
        return s;
    }

    Collection<SharedUserSetting> getAllSharedUsersLPw() {
        return this.mSharedUsers.values();
    }

    boolean disableSystemPackageLPw(String name) {
        PackageSetting p = this.mPackages.get(name);
        if (p == null) {
            Log.w("PackageManager", "Package:" + name + " is not an installed package");
            return false;
        }
        PackageSetting dp = this.mDisabledSysPackages.get(name);
        if (dp == null) {
            if (p.pkg != null && p.pkg.applicationInfo != null) {
                p.pkg.applicationInfo.flags |= 0x80;
            }
            this.mDisabledSysPackages.put(name, p);
            PackageSetting newp = new PackageSetting(p);
            this.replacePackageLPw(name, newp);
            return true;
        }
        return false;
    }

    PackageSetting enableSystemPackageLPw(String name) {
        PackageSetting p = this.mDisabledSysPackages.get(name);
        if (p == null) {
            Log.w("PackageManager", "Package:" + name + " is not disabled");
            return null;
        }
        if (p.pkg != null && p.pkg.applicationInfo != null) {
            p.pkg.applicationInfo.flags &= 0xFFFFFF7F;
        }
        PackageSetting ret = this.addPackageLPw(name, p.realName, p.codePath, p.resourcePath, p.legacyNativeLibraryPathString, p.primaryCpuAbiString, p.secondaryCpuAbiString, p.secondaryCpuAbiString, p.appId, p.versionCode, p.pkgFlags);
        this.mDisabledSysPackages.remove(name);
        return ret;
    }

    boolean isDisabledSystemPackageLPr(String name) {
        return this.mDisabledSysPackages.containsKey(name);
    }

    void removeDisabledSystemPackageLPw(String name) {
        this.mDisabledSysPackages.remove(name);
    }

    PackageSetting addPackageLPw(String name, String realName, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbiString, String secondaryCpuAbiString, String cpuAbiOverrideString, int uid, int vc, int pkgFlags) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            if (p.appId == uid) {
                return p;
            }
            PackageManagerService.reportSettingsProblem(6, "Adding duplicate package, keeping first: " + name);
            return null;
        }
        p = new PackageSetting(name, realName, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, vc, pkgFlags);
        p.appId = uid;
        if (this.addUserIdLPw(uid, p, name)) {
            this.mPackages.put(name, p);
            return p;
        }
        return null;
    }

    SharedUserSetting addSharedUserLPw(String name, int uid, int pkgFlags) {
        SharedUserSetting s = this.mSharedUsers.get(name);
        if (s != null) {
            if (s.userId == uid) {
                return s;
            }
            PackageManagerService.reportSettingsProblem(6, "Adding duplicate shared user, keeping first: " + name);
            return null;
        }
        s = new SharedUserSetting(name, pkgFlags);
        s.userId = uid;
        if (this.addUserIdLPw(uid, s, name)) {
            this.mSharedUsers.put(name, s);
            return s;
        }
        return null;
    }

    void pruneSharedUsersLPw() {
        ArrayList<String> removeStage = new ArrayList<String>();
        for (Map.Entry<String, SharedUserSetting> entry : this.mSharedUsers.entrySet()) {
            SharedUserSetting sus = entry.getValue();
            if (sus != null && sus.packages.size() != 0) continue;
            removeStage.add(entry.getKey());
        }
        for (int i = 0; i < removeStage.size(); ++i) {
            this.mSharedUsers.remove(removeStage.get(i));
        }
    }

    void transferPermissionsLPw(String origPkg, String newPkg) {
        for (int i = 0; i < 2; ++i) {
            HashMap<String, BasePermission> permissions = i == 0 ? this.mPermissionTrees : this.mPermissions;
            for (BasePermission bp : permissions.values()) {
                if (!origPkg.equals(bp.sourcePackage)) continue;
                bp.sourcePackage = newPkg;
                bp.packageSetting = null;
                bp.perm = null;
                if (bp.pendingInfo != null) {
                    bp.pendingInfo.packageName = newPkg;
                }
                bp.uid = 0;
                bp.gids = null;
            }
        }
    }

    private PackageSetting getPackageLPw(String name, PackageSetting origPackage, String realName, SharedUserSetting sharedUser, File codePath, File resourcePath, String legacyNativeLibraryPathString, String primaryCpuAbiString, String secondaryCpuAbiString, int vc, int pkgFlags, UserHandle installUser, boolean add, boolean allowInstall) {
        List<UserInfo> users;
        PackageSetting p = this.mPackages.get(name);
        UserManagerService userManager = UserManagerService.getInstance();
        if (p != null) {
            p.primaryCpuAbiString = primaryCpuAbiString;
            p.secondaryCpuAbiString = secondaryCpuAbiString;
            if (!p.codePath.equals(codePath)) {
                if ((p.pkgFlags & 1) != 0) {
                    Slog.w("PackageManager", "Trying to update system app code path from " + p.codePathString + " to " + codePath.toString());
                } else {
                    Slog.i("PackageManager", "Package " + name + " codePath changed from " + p.codePath + " to " + codePath + "; Retaining data and using new");
                    p.legacyNativeLibraryPathString = legacyNativeLibraryPathString;
                }
            }
            if (p.sharedUser != sharedUser) {
                PackageManagerService.reportSettingsProblem(5, "Package " + name + " shared user changed from " + (p.sharedUser != null ? p.sharedUser.name : "<nothing>") + " to " + (sharedUser != null ? sharedUser.name : "<nothing>") + "; replacing with new");
                p = null;
            } else {
                int sysPrivFlags = pkgFlags & 0x40000001;
                p.pkgFlags |= sysPrivFlags;
            }
        }
        if (p == null) {
            if (origPackage != null) {
                p = new PackageSetting(origPackage.name, name, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, null, vc, pkgFlags);
                PackageSignatures s = p.signatures;
                p.copyFrom(origPackage);
                p.signatures = s;
                p.sharedUser = origPackage.sharedUser;
                p.appId = origPackage.appId;
                p.origPackage = origPackage;
                this.mRenamedPackages.put(name, origPackage.name);
                name = origPackage.name;
                p.setTimeStamp(codePath.lastModified());
            } else {
                p = new PackageSetting(name, realName, codePath, resourcePath, legacyNativeLibraryPathString, primaryCpuAbiString, secondaryCpuAbiString, null, vc, pkgFlags);
                p.setTimeStamp(codePath.lastModified());
                p.sharedUser = sharedUser;
                if ((pkgFlags & 1) == 0) {
                    int installUserId;
                    List<UserInfo> users2 = this.getAllUsers();
                    int n = installUserId = installUser != null ? installUser.getIdentifier() : 0;
                    if (users2 != null && allowInstall) {
                        for (UserInfo user : users2) {
                            boolean installed = installUser == null || installUserId == -1 && !this.isAdbInstallDisallowed(userManager, user.id) || installUserId == user.id;
                            p.setUserState(user.id, 0, installed, true, true, false, null, null, null, false);
                            this.writePackageRestrictionsLPr(user.id);
                        }
                    }
                }
                if (sharedUser != null) {
                    p.appId = sharedUser.userId;
                } else {
                    PackageSetting dis = this.mDisabledSysPackages.get(name);
                    if (dis != null) {
                        if (dis.signatures.mSignatures != null) {
                            p.signatures.mSignatures = (Signature[])dis.signatures.mSignatures.clone();
                        }
                        p.appId = dis.appId;
                        p.grantedPermissions = new HashSet(dis.grantedPermissions);
                        List<UserInfo> users3 = this.getAllUsers();
                        if (users3 != null) {
                            for (UserInfo user : users3) {
                                int userId = user.id;
                                p.setDisabledComponentsCopy(dis.getDisabledComponents(userId), userId);
                                p.setEnabledComponentsCopy(dis.getEnabledComponents(userId), userId);
                            }
                        }
                        this.addUserIdLPw(p.appId, p, name);
                    } else {
                        p.appId = this.newUserIdLPw(p);
                    }
                }
            }
            if (p.appId < 0) {
                PackageManagerService.reportSettingsProblem(5, "Package " + name + " could not be assigned a valid uid");
                return null;
            }
            if (add) {
                this.addPackageSettingLPw(p, name, sharedUser);
            }
        } else if (installUser != null && allowInstall && (users = this.getAllUsers()) != null) {
            for (UserInfo user : users) {
                boolean installed;
                if ((installUser.getIdentifier() != -1 || this.isAdbInstallDisallowed(userManager, user.id)) && installUser.getIdentifier() != user.id || (installed = p.getInstalled(user.id))) continue;
                p.setInstalled(true, user.id);
                this.writePackageRestrictionsLPr(user.id);
            }
        }
        return p;
    }

    boolean isAdbInstallDisallowed(UserManagerService userManager, int userId) {
        return userManager.hasUserRestriction("no_debugging_features", userId);
    }

    void insertPackageSettingLPw(PackageSetting p, PackageParser.Package pkg) {
        p.pkg = pkg;
        String codePath = pkg.applicationInfo.getCodePath();
        String resourcePath = pkg.applicationInfo.getResourcePath();
        String legacyNativeLibraryPath = pkg.applicationInfo.nativeLibraryRootDir;
        if (!Objects.equals(codePath, p.codePathString)) {
            Slog.w("PackageManager", "Code path for pkg : " + p.pkg.packageName + " changing from " + p.codePathString + " to " + codePath);
            p.codePath = new File(codePath);
            p.codePathString = codePath;
        }
        if (!Objects.equals(resourcePath, p.resourcePathString)) {
            Slog.w("PackageManager", "Resource path for pkg : " + p.pkg.packageName + " changing from " + p.resourcePathString + " to " + resourcePath);
            p.resourcePath = new File(resourcePath);
            p.resourcePathString = resourcePath;
        }
        if (!Objects.equals(legacyNativeLibraryPath, p.legacyNativeLibraryPathString)) {
            p.legacyNativeLibraryPathString = legacyNativeLibraryPath;
        }
        p.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
        p.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        p.cpuAbiOverrideString = pkg.cpuAbiOverride;
        if (pkg.mVersionCode != p.versionCode) {
            p.versionCode = pkg.mVersionCode;
        }
        if (p.signatures.mSignatures == null) {
            p.signatures.assignSignatures(pkg.mSignatures);
        }
        if (pkg.applicationInfo.flags != p.pkgFlags) {
            p.pkgFlags = pkg.applicationInfo.flags;
        }
        if (p.sharedUser != null && p.sharedUser.signatures.mSignatures == null) {
            p.sharedUser.signatures.assignSignatures(pkg.mSignatures);
        }
        this.addPackageSettingLPw(p, pkg.packageName, p.sharedUser);
    }

    private void addPackageSettingLPw(PackageSetting p, String name, SharedUserSetting sharedUser) {
        this.mPackages.put(name, p);
        if (sharedUser != null) {
            if (p.sharedUser != null && p.sharedUser != sharedUser) {
                PackageManagerService.reportSettingsProblem(6, "Package " + p.name + " was user " + p.sharedUser + " but is now " + sharedUser + "; I am not changing its files so it will probably fail!");
                p.sharedUser.removePackage(p);
            } else if (p.appId != sharedUser.userId) {
                PackageManagerService.reportSettingsProblem(6, "Package " + p.name + " was user id " + p.appId + " but is now user " + sharedUser + " with id " + sharedUser.userId + "; I am not changing its files so it will probably fail!");
            }
            sharedUser.addPackage(p);
            p.sharedUser = sharedUser;
            p.appId = sharedUser.userId;
        }
    }

    void updateSharedUserPermsLPw(PackageSetting deletedPs, int[] globalGids) {
        if (deletedPs == null || deletedPs.pkg == null) {
            Slog.i("PackageManager", "Trying to update info for null package. Just ignoring");
            return;
        }
        if (deletedPs.sharedUser == null) {
            return;
        }
        SharedUserSetting sus = deletedPs.sharedUser;
        for (String eachPerm : deletedPs.pkg.requestedPermissions) {
            boolean used = false;
            if (!sus.grantedPermissions.contains(eachPerm)) continue;
            for (PackageSetting pkg : sus.packages) {
                if (pkg.pkg == null || pkg.pkg.packageName.equals(deletedPs.pkg.packageName) || !pkg.pkg.requestedPermissions.contains(eachPerm)) continue;
                used = true;
                break;
            }
            if (used) continue;
            sus.grantedPermissions.remove(eachPerm);
        }
        int[] newGids = globalGids;
        for (String eachPerm : sus.grantedPermissions) {
            BasePermission bp = this.mPermissions.get(eachPerm);
            if (bp == null) continue;
            newGids = PackageManagerService.appendInts(newGids, bp.gids);
        }
        sus.gids = newGids;
    }

    int removePackageLPw(String name) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            this.mPackages.remove(name);
            if (p.sharedUser != null) {
                p.sharedUser.removePackage(p);
                if (p.sharedUser.packages.size() == 0) {
                    this.mSharedUsers.remove(p.sharedUser.name);
                    this.removeUserIdLPw(p.sharedUser.userId);
                    return p.sharedUser.userId;
                }
            } else {
                this.removeUserIdLPw(p.appId);
                return p.appId;
            }
        }
        return -1;
    }

    private void replacePackageLPw(String name, PackageSetting newp) {
        PackageSetting p = this.mPackages.get(name);
        if (p != null) {
            if (p.sharedUser != null) {
                p.sharedUser.removePackage(p);
                p.sharedUser.addPackage(newp);
            } else {
                this.replaceUserIdLPw(p.appId, newp);
            }
        }
        this.mPackages.put(name, newp);
    }

    private boolean addUserIdLPw(int uid, Object obj, Object name) {
        if (uid > 19999) {
            return false;
        }
        if (uid >= 10000) {
            int index = uid - 10000;
            for (int N = this.mUserIds.size(); index >= N; ++N) {
                this.mUserIds.add(null);
            }
            if (this.mUserIds.get(index) != null) {
                PackageManagerService.reportSettingsProblem(6, "Adding duplicate user id: " + uid + " name=" + name);
                return false;
            }
            this.mUserIds.set(index, obj);
        } else {
            if (this.mOtherUserIds.get(uid) != null) {
                PackageManagerService.reportSettingsProblem(6, "Adding duplicate shared id: " + uid + " name=" + name);
                return false;
            }
            this.mOtherUserIds.put(uid, obj);
        }
        return true;
    }

    public Object getUserIdLPr(int uid) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            return index < N ? this.mUserIds.get(index) : null;
        }
        return this.mOtherUserIds.get(uid);
    }

    private void removeUserIdLPw(int uid) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            if (index < N) {
                this.mUserIds.set(index, null);
            }
        } else {
            this.mOtherUserIds.remove(uid);
        }
        this.setFirstAvailableUid(uid + 1);
    }

    private void replaceUserIdLPw(int uid, Object obj) {
        if (uid >= 10000) {
            int index = uid - 10000;
            int N = this.mUserIds.size();
            if (index < N) {
                this.mUserIds.set(index, obj);
            }
        } else {
            this.mOtherUserIds.put(uid, obj);
        }
    }

    PreferredIntentResolver editPreferredActivitiesLPw(int userId) {
        PreferredIntentResolver pir = this.mPreferredActivities.get(userId);
        if (pir == null) {
            pir = new PreferredIntentResolver();
            this.mPreferredActivities.put(userId, pir);
        }
        return pir;
    }

    PersistentPreferredIntentResolver editPersistentPreferredActivitiesLPw(int userId) {
        PersistentPreferredIntentResolver ppir = this.mPersistentPreferredActivities.get(userId);
        if (ppir == null) {
            ppir = new PersistentPreferredIntentResolver();
            this.mPersistentPreferredActivities.put(userId, ppir);
        }
        return ppir;
    }

    CrossProfileIntentResolver editCrossProfileIntentResolverLPw(int userId) {
        CrossProfileIntentResolver cpir = this.mCrossProfileIntentResolvers.get(userId);
        if (cpir == null) {
            cpir = new CrossProfileIntentResolver();
            this.mCrossProfileIntentResolvers.put(userId, cpir);
        }
        return cpir;
    }

    private File getUserPackagesStateFile(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), "package-restrictions.xml");
    }

    private File getUserPackagesStateBackupFile(int userId) {
        return new File(Environment.getUserSystemDirectory(userId), "package-restrictions-backup.xml");
    }

    void writeAllUsersPackageRestrictionsLPr() {
        List<UserInfo> users = this.getAllUsers();
        if (users == null) {
            return;
        }
        for (UserInfo user : users) {
            this.writePackageRestrictionsLPr(user.id);
        }
    }

    void readAllUsersPackageRestrictionsLPr() {
        List<UserInfo> users = this.getAllUsers();
        if (users == null) {
            this.readPackageRestrictionsLPr(0);
            return;
        }
        for (UserInfo user : users) {
            this.readPackageRestrictionsLPr(user.id);
        }
    }

    public boolean isInternalDatabaseVersionOlderThan(int version) {
        return this.mInternalDatabaseVersion < version;
    }

    public boolean isExternalDatabaseVersionOlderThan(int version) {
        return this.mExternalDatabaseVersion < version;
    }

    public void updateInternalDatabaseVersion() {
        this.mInternalDatabaseVersion = 3;
    }

    public void updateExternalDatabaseVersion() {
        this.mExternalDatabaseVersion = 3;
    }

    private void readPreferredActivitiesLPw(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                PreferredActivity pa = new PreferredActivity(parser);
                if (pa.mPref.getParseError() == null) {
                    this.editPreferredActivitiesLPw(userId).addFilter(pa);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <preferred-activity> " + pa.mPref.getParseError() + " at " + parser.getPositionDescription());
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <preferred-activities>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readPersistentPreferredActivitiesLPw(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                PersistentPreferredActivity ppa = new PersistentPreferredActivity(parser);
                this.editPersistentPreferredActivitiesLPw(userId).addFilter(ppa);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <persistent-preferred-activities>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readCrossProfileIntentFiltersLPw(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                CrossProfileIntentFilter cpif = new CrossProfileIntentFilter(parser);
                this.editCrossProfileIntentResolverLPw(userId).addFilter(cpif);
                continue;
            }
            String msg = "Unknown element under crossProfile-intent-filters: " + parser.getName();
            PackageManagerService.reportSettingsProblem(5, msg);
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void readPackageRestrictionsLPr(int userId) {
        FileInputStream str = null;
        File userPackagesStateFile = this.getUserPackagesStateFile(userId);
        File backupFile = this.getUserPackagesStateBackupFile(userId);
        if (backupFile.exists()) {
            try {
                str = new FileInputStream(backupFile);
                this.mReadMessages.append("Reading from backup stopped packages file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup stopped packages file");
                if (userPackagesStateFile.exists()) {
                    Slog.w("PackageManager", "Cleaning up stopped packages file " + userPackagesStateFile);
                    userPackagesStateFile.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            int type;
            if (str == null) {
                if (!userPackagesStateFile.exists()) {
                    this.mReadMessages.append("No stopped packages file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No stopped packages file; assuming all started");
                    for (PackageSetting pkg : this.mPackages.values()) {
                        pkg.setUserState(userId, 0, true, false, false, false, null, null, null, false);
                    }
                    return;
                }
                str = new FileInputStream(userPackagesStateFile);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(str, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in package restrictions file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager stopped packages");
                return;
            }
            int outerDepth = parser.getDepth();
            PackageSetting ps = null;
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals(TAG_PACKAGE)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    ps = this.mPackages.get(name);
                    if (ps == null) {
                        Slog.w("PackageManager", "No package known for stopped package: " + name);
                        XmlUtils.skipCurrentTag(parser);
                        continue;
                    }
                    String enabledStr = parser.getAttributeValue(null, ATTR_ENABLED);
                    int enabled = enabledStr == null ? 0 : Integer.parseInt(enabledStr);
                    String enabledCaller = parser.getAttributeValue(null, ATTR_ENABLED_CALLER);
                    String installedStr = parser.getAttributeValue(null, ATTR_INSTALLED);
                    boolean installed = installedStr == null ? true : Boolean.parseBoolean(installedStr);
                    String stoppedStr = parser.getAttributeValue(null, ATTR_STOPPED);
                    boolean stopped = stoppedStr == null ? false : Boolean.parseBoolean(stoppedStr);
                    String blockedStr = parser.getAttributeValue(null, ATTR_BLOCKED);
                    boolean hidden = blockedStr == null ? false : Boolean.parseBoolean(blockedStr);
                    String hiddenStr = parser.getAttributeValue(null, ATTR_HIDDEN);
                    hidden = hiddenStr == null ? hidden : Boolean.parseBoolean(hiddenStr);
                    String notLaunchedStr = parser.getAttributeValue(null, ATTR_NOT_LAUNCHED);
                    boolean notLaunched = stoppedStr == null ? false : Boolean.parseBoolean(notLaunchedStr);
                    String blockUninstallStr = parser.getAttributeValue(null, ATTR_BLOCK_UNINSTALL);
                    boolean blockUninstall = blockUninstallStr == null ? false : Boolean.parseBoolean(blockUninstallStr);
                    HashSet<String> enabledComponents = null;
                    HashSet<String> disabledComponents = null;
                    int packageDepth = parser.getDepth();
                    while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > packageDepth)) {
                        if (type == 3 || type == 4) continue;
                        tagName = parser.getName();
                        if (tagName.equals(TAG_ENABLED_COMPONENTS)) {
                            enabledComponents = this.readComponentsLPr(parser);
                            continue;
                        }
                        if (!tagName.equals(TAG_DISABLED_COMPONENTS)) continue;
                        disabledComponents = this.readComponentsLPr(parser);
                    }
                    ps.setUserState(userId, enabled, installed, stopped, notLaunched, hidden, enabledCaller, enabledComponents, disabledComponents, blockUninstall);
                    continue;
                }
                if (tagName.equals("preferred-activities")) {
                    this.readPreferredActivitiesLPw(parser, userId);
                    continue;
                }
                if (tagName.equals(TAG_PERSISTENT_PREFERRED_ACTIVITIES)) {
                    this.readPersistentPreferredActivitiesLPw(parser, userId);
                    continue;
                }
                if (tagName.equals(TAG_CROSS_PROFILE_INTENT_FILTERS)) {
                    this.readCrossProfileIntentFiltersLPw(parser, userId);
                    continue;
                }
                Slog.w("PackageManager", "Unknown element under <stopped-packages>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            str.close();
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading stopped packages: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
    }

    private HashSet<String> readComponentsLPr(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        HashSet<String> components = null;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String componentName;
            String tagName;
            if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(TAG_ITEM) || (componentName = parser.getAttributeValue(null, ATTR_NAME)) == null) continue;
            if (components == null) {
                components = new HashSet<String>();
            }
            components.add(componentName);
        }
        return components;
    }

    void writePreferredActivitiesLPr(XmlSerializer serializer, int userId, boolean full) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, "preferred-activities");
        PreferredIntentResolver pir = this.mPreferredActivities.get(userId);
        if (pir != null) {
            for (PreferredActivity pa : pir.filterSet()) {
                serializer.startTag(null, TAG_ITEM);
                pa.writeToXml(serializer, full);
                serializer.endTag(null, TAG_ITEM);
            }
        }
        serializer.endTag(null, "preferred-activities");
    }

    void writePersistentPreferredActivitiesLPr(XmlSerializer serializer, int userId) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, TAG_PERSISTENT_PREFERRED_ACTIVITIES);
        PersistentPreferredIntentResolver ppir = this.mPersistentPreferredActivities.get(userId);
        if (ppir != null) {
            for (PersistentPreferredActivity ppa : ppir.filterSet()) {
                serializer.startTag(null, TAG_ITEM);
                ppa.writeToXml(serializer);
                serializer.endTag(null, TAG_ITEM);
            }
        }
        serializer.endTag(null, TAG_PERSISTENT_PREFERRED_ACTIVITIES);
    }

    void writeCrossProfileIntentFiltersLPr(XmlSerializer serializer, int userId) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(null, TAG_CROSS_PROFILE_INTENT_FILTERS);
        CrossProfileIntentResolver cpir = this.mCrossProfileIntentResolvers.get(userId);
        if (cpir != null) {
            for (CrossProfileIntentFilter cpif : cpir.filterSet()) {
                serializer.startTag(null, TAG_ITEM);
                cpif.writeToXml(serializer);
                serializer.endTag(null, TAG_ITEM);
            }
        }
        serializer.endTag(null, TAG_CROSS_PROFILE_INTENT_FILTERS);
    }

    void writePackageRestrictionsLPr(int userId) {
        File userPackagesStateFile = this.getUserPackagesStateFile(userId);
        File backupFile = this.getUserPackagesStateBackupFile(userId);
        new File(userPackagesStateFile.getParent()).mkdirs();
        if (userPackagesStateFile.exists()) {
            if (!backupFile.exists()) {
                if (!userPackagesStateFile.renameTo(backupFile)) {
                    Slog.wtf("PackageManager", "Unable to backup user packages state file, current changes will be lost at reboot");
                    return;
                }
            } else {
                userPackagesStateFile.delete();
                Slog.w("PackageManager", "Preserving older stopped packages backup");
            }
        }
        try {
            FileOutputStream fstr = new FileOutputStream(userPackagesStateFile);
            BufferedOutputStream str = new BufferedOutputStream(fstr);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(str, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_PACKAGE_RESTRICTIONS);
            for (PackageSetting pkg : this.mPackages.values()) {
                PackageUserState ustate = pkg.readUserState(userId);
                if (!(ustate.stopped || ustate.notLaunched || !ustate.installed || ustate.enabled != 0 || ustate.hidden || ustate.enabledComponents != null && ustate.enabledComponents.size() > 0 || ustate.disabledComponents != null && ustate.disabledComponents.size() > 0) && !ustate.blockUninstall) continue;
                serializer.startTag(null, TAG_PACKAGE);
                serializer.attribute(null, ATTR_NAME, pkg.name);
                if (!ustate.installed) {
                    serializer.attribute(null, ATTR_INSTALLED, "false");
                }
                if (ustate.stopped) {
                    serializer.attribute(null, ATTR_STOPPED, "true");
                }
                if (ustate.notLaunched) {
                    serializer.attribute(null, ATTR_NOT_LAUNCHED, "true");
                }
                if (ustate.hidden) {
                    serializer.attribute(null, ATTR_HIDDEN, "true");
                }
                if (ustate.blockUninstall) {
                    serializer.attribute(null, ATTR_BLOCK_UNINSTALL, "true");
                }
                if (ustate.enabled != 0) {
                    serializer.attribute(null, ATTR_ENABLED, Integer.toString(ustate.enabled));
                    if (ustate.lastDisableAppCaller != null) {
                        serializer.attribute(null, ATTR_ENABLED_CALLER, ustate.lastDisableAppCaller);
                    }
                }
                if (ustate.enabledComponents != null && ustate.enabledComponents.size() > 0) {
                    serializer.startTag(null, TAG_ENABLED_COMPONENTS);
                    for (String name : ustate.enabledComponents) {
                        serializer.startTag(null, TAG_ITEM);
                        serializer.attribute(null, ATTR_NAME, name);
                        serializer.endTag(null, TAG_ITEM);
                    }
                    serializer.endTag(null, TAG_ENABLED_COMPONENTS);
                }
                if (ustate.disabledComponents != null && ustate.disabledComponents.size() > 0) {
                    serializer.startTag(null, TAG_DISABLED_COMPONENTS);
                    for (String name : ustate.disabledComponents) {
                        serializer.startTag(null, TAG_ITEM);
                        serializer.attribute(null, ATTR_NAME, name);
                        serializer.endTag(null, TAG_ITEM);
                    }
                    serializer.endTag(null, TAG_DISABLED_COMPONENTS);
                }
                serializer.endTag(null, TAG_PACKAGE);
            }
            this.writePreferredActivitiesLPr(serializer, userId, true);
            this.writePersistentPreferredActivitiesLPr(serializer, userId);
            this.writeCrossProfileIntentFiltersLPr(serializer, userId);
            serializer.endTag(null, TAG_PACKAGE_RESTRICTIONS);
            serializer.endDocument();
            str.flush();
            FileUtils.sync(fstr);
            str.close();
            backupFile.delete();
            FileUtils.setPermissions(userPackagesStateFile.toString(), 432, -1, -1);
            return;
        }
        catch (IOException e) {
            Slog.wtf("PackageManager", "Unable to write package manager user packages state,  current changes will be lost at reboot", e);
            if (userPackagesStateFile.exists() && !userPackagesStateFile.delete()) {
                Log.i("PackageManager", "Failed to clean up mangled file: " + this.mStoppedPackagesFilename);
            }
            return;
        }
    }

    void readStoppedLPw() {
        FileInputStream str = null;
        if (this.mBackupStoppedPackagesFilename.exists()) {
            try {
                str = new FileInputStream(this.mBackupStoppedPackagesFilename);
                this.mReadMessages.append("Reading from backup stopped packages file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup stopped packages file");
                if (this.mSettingsFilename.exists()) {
                    Slog.w("PackageManager", "Cleaning up stopped packages file " + this.mStoppedPackagesFilename);
                    this.mStoppedPackagesFilename.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            int type;
            if (str == null) {
                if (!this.mStoppedPackagesFilename.exists()) {
                    this.mReadMessages.append("No stopped packages file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No stopped packages file file; assuming all started");
                    for (PackageSetting pkg : this.mPackages.values()) {
                        pkg.setStopped(false, 0);
                        pkg.setNotLaunched(false, 0);
                    }
                    return;
                }
                str = new FileInputStream(this.mStoppedPackagesFilename);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(str, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in stopped packages file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager stopped packages");
                return;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals(TAG_PACKAGE)) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    PackageSetting ps = this.mPackages.get(name);
                    if (ps != null) {
                        ps.setStopped(true, 0);
                        if ("1".equals(parser.getAttributeValue(null, ATTR_NOT_LAUNCHED))) {
                            ps.setNotLaunched(true, 0);
                        }
                    } else {
                        Slog.w("PackageManager", "No package known for stopped package: " + name);
                    }
                    XmlUtils.skipCurrentTag(parser);
                    continue;
                }
                Slog.w("PackageManager", "Unknown element under <stopped-packages>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            str.close();
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading stopped packages: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager stopped packages", e);
        }
    }

    void writeLPr() {
        if (this.mSettingsFilename.exists()) {
            if (!this.mBackupSettingsFilename.exists()) {
                if (!this.mSettingsFilename.renameTo(this.mBackupSettingsFilename)) {
                    Slog.wtf("PackageManager", "Unable to backup package manager settings,  current changes will be lost at reboot");
                    return;
                }
            } else {
                this.mSettingsFilename.delete();
                Slog.w("PackageManager", "Preserving older settings backup");
            }
        }
        this.mPastSignatures.clear();
        try {
            FileOutputStream fstr = new FileOutputStream(this.mSettingsFilename);
            BufferedOutputStream str = new BufferedOutputStream(fstr);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(str, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, "packages");
            serializer.startTag(null, "last-platform-version");
            serializer.attribute(null, "internal", Integer.toString(this.mInternalSdkPlatform));
            serializer.attribute(null, "external", Integer.toString(this.mExternalSdkPlatform));
            serializer.attribute(null, "fingerprint", this.mFingerprint);
            serializer.endTag(null, "last-platform-version");
            serializer.startTag(null, "database-version");
            serializer.attribute(null, "internal", Integer.toString(this.mInternalDatabaseVersion));
            serializer.attribute(null, "external", Integer.toString(this.mExternalDatabaseVersion));
            serializer.endTag(null, "database-version");
            if (this.mVerifierDeviceIdentity != null) {
                serializer.startTag(null, "verifier");
                serializer.attribute(null, "device", this.mVerifierDeviceIdentity.toString());
                serializer.endTag(null, "verifier");
            }
            if (this.mReadExternalStorageEnforced != null) {
                serializer.startTag(null, TAG_READ_EXTERNAL_STORAGE);
                serializer.attribute(null, ATTR_ENFORCEMENT, this.mReadExternalStorageEnforced != false ? "1" : "0");
                serializer.endTag(null, TAG_READ_EXTERNAL_STORAGE);
            }
            serializer.startTag(null, "permission-trees");
            for (BasePermission basePermission : this.mPermissionTrees.values()) {
                this.writePermissionLPr(serializer, basePermission);
            }
            serializer.endTag(null, "permission-trees");
            serializer.startTag(null, "permissions");
            for (BasePermission basePermission : this.mPermissions.values()) {
                this.writePermissionLPr(serializer, basePermission);
            }
            serializer.endTag(null, "permissions");
            for (PackageSetting packageSetting : this.mPackages.values()) {
                this.writePackageLPr(serializer, packageSetting);
            }
            for (PackageSetting packageSetting : this.mDisabledSysPackages.values()) {
                this.writeDisabledSysPackageLPr(serializer, packageSetting);
            }
            for (SharedUserSetting sharedUserSetting : this.mSharedUsers.values()) {
                serializer.startTag(null, "shared-user");
                serializer.attribute(null, ATTR_NAME, sharedUserSetting.name);
                serializer.attribute(null, "userId", Integer.toString(sharedUserSetting.userId));
                sharedUserSetting.signatures.writeXml(serializer, "sigs", this.mPastSignatures);
                serializer.startTag(null, "perms");
                for (String name : sharedUserSetting.grantedPermissions) {
                    serializer.startTag(null, TAG_ITEM);
                    serializer.attribute(null, ATTR_NAME, name);
                    serializer.endTag(null, TAG_ITEM);
                }
                serializer.endTag(null, "perms");
                serializer.endTag(null, "shared-user");
            }
            if (this.mPackagesToBeCleaned.size() > 0) {
                for (PackageCleanItem packageCleanItem : this.mPackagesToBeCleaned) {
                    String userStr = Integer.toString(packageCleanItem.userId);
                    serializer.startTag(null, "cleaning-package");
                    serializer.attribute(null, ATTR_NAME, packageCleanItem.packageName);
                    serializer.attribute(null, ATTR_CODE, packageCleanItem.andCode ? "true" : "false");
                    serializer.attribute(null, ATTR_USER, userStr);
                    serializer.endTag(null, "cleaning-package");
                }
            }
            if (this.mRenamedPackages.size() > 0) {
                for (Map.Entry entry : this.mRenamedPackages.entrySet()) {
                    serializer.startTag(null, "renamed-package");
                    serializer.attribute(null, "new", (String)entry.getKey());
                    serializer.attribute(null, "old", (String)entry.getValue());
                    serializer.endTag(null, "renamed-package");
                }
            }
            this.mKeySetManagerService.writeKeySetManagerServiceLPr(serializer);
            serializer.endTag(null, "packages");
            serializer.endDocument();
            str.flush();
            FileUtils.sync(fstr);
            str.close();
            this.mBackupSettingsFilename.delete();
            FileUtils.setPermissions(this.mSettingsFilename.toString(), 432, -1, -1);
            File tempFile = new File(this.mPackageListFilename.getAbsolutePath() + ".tmp");
            JournaledFile journaledFile = new JournaledFile(this.mPackageListFilename, tempFile);
            File writeTarget = journaledFile.chooseForWrite();
            fstr = new FileOutputStream(writeTarget);
            str = new BufferedOutputStream(fstr);
            try {
                FileUtils.setPermissions(fstr.getFD(), 432, 1000, 1032);
                StringBuilder sb = new StringBuilder();
                for (PackageSetting pkg : this.mPackages.values()) {
                    if (pkg.pkg == null || pkg.pkg.applicationInfo == null) {
                        Slog.w(TAG, "Skipping " + pkg + " due to missing metadata");
                        continue;
                    }
                    ApplicationInfo ai = pkg.pkg.applicationInfo;
                    String dataPath = ai.dataDir;
                    boolean isDebug = (ai.flags & 2) != 0;
                    int[] gids = pkg.getGids();
                    if (dataPath.indexOf(" ") >= 0) continue;
                    sb.setLength(0);
                    sb.append(ai.packageName);
                    sb.append(" ");
                    sb.append(ai.uid);
                    sb.append(isDebug ? " 1 " : " 0 ");
                    sb.append(dataPath);
                    sb.append(" ");
                    sb.append(ai.seinfo);
                    sb.append(" ");
                    if (gids != null && gids.length > 0) {
                        sb.append(gids[0]);
                        for (int i = 1; i < gids.length; ++i) {
                            sb.append(",");
                            sb.append(gids[i]);
                        }
                    } else {
                        sb.append("none");
                    }
                    sb.append("\n");
                    str.write(sb.toString().getBytes());
                }
                str.flush();
                FileUtils.sync(fstr);
                str.close();
                journaledFile.commit();
            }
            catch (Exception e) {
                Slog.wtf(TAG, "Failed to write packages.list", e);
                IoUtils.closeQuietly(str);
                journaledFile.rollback();
            }
            this.writeAllUsersPackageRestrictionsLPr();
            return;
        }
        catch (XmlPullParserException e) {
            Slog.wtf("PackageManager", "Unable to write package manager settings, current changes will be lost at reboot", e);
        }
        catch (IOException e) {
            Slog.wtf("PackageManager", "Unable to write package manager settings, current changes will be lost at reboot", e);
        }
        if (this.mSettingsFilename.exists() && !this.mSettingsFilename.delete()) {
            Slog.wtf("PackageManager", "Failed to clean up mangled file: " + this.mSettingsFilename);
        }
    }

    void writeDisabledSysPackageLPr(XmlSerializer serializer, PackageSetting pkg) throws IOException {
        serializer.startTag(null, "updated-package");
        serializer.attribute(null, ATTR_NAME, pkg.name);
        if (pkg.realName != null) {
            serializer.attribute(null, "realName", pkg.realName);
        }
        serializer.attribute(null, "codePath", pkg.codePathString);
        serializer.attribute(null, "ft", Long.toHexString(pkg.timeStamp));
        serializer.attribute(null, "it", Long.toHexString(pkg.firstInstallTime));
        serializer.attribute(null, "ut", Long.toHexString(pkg.lastUpdateTime));
        serializer.attribute(null, "version", String.valueOf(pkg.versionCode));
        if (!pkg.resourcePathString.equals(pkg.codePathString)) {
            serializer.attribute(null, "resourcePath", pkg.resourcePathString);
        }
        if (pkg.legacyNativeLibraryPathString != null) {
            serializer.attribute(null, "nativeLibraryPath", pkg.legacyNativeLibraryPathString);
        }
        if (pkg.primaryCpuAbiString != null) {
            serializer.attribute(null, "primaryCpuAbi", pkg.primaryCpuAbiString);
        }
        if (pkg.secondaryCpuAbiString != null) {
            serializer.attribute(null, "secondaryCpuAbi", pkg.secondaryCpuAbiString);
        }
        if (pkg.cpuAbiOverrideString != null) {
            serializer.attribute(null, "cpuAbiOverride", pkg.cpuAbiOverrideString);
        }
        if (pkg.sharedUser == null) {
            serializer.attribute(null, "userId", Integer.toString(pkg.appId));
        } else {
            serializer.attribute(null, "sharedUserId", Integer.toString(pkg.appId));
        }
        serializer.startTag(null, "perms");
        if (pkg.sharedUser == null) {
            for (String name : pkg.grantedPermissions) {
                BasePermission bp = this.mPermissions.get(name);
                if (bp == null) continue;
                serializer.startTag(null, TAG_ITEM);
                serializer.attribute(null, ATTR_NAME, name);
                serializer.endTag(null, TAG_ITEM);
            }
        }
        serializer.endTag(null, "perms");
        serializer.endTag(null, "updated-package");
    }

    void writePackageLPr(XmlSerializer serializer, PackageSetting pkg) throws IOException {
        serializer.startTag(null, "package");
        serializer.attribute(null, ATTR_NAME, pkg.name);
        if (pkg.realName != null) {
            serializer.attribute(null, "realName", pkg.realName);
        }
        serializer.attribute(null, "codePath", pkg.codePathString);
        if (!pkg.resourcePathString.equals(pkg.codePathString)) {
            serializer.attribute(null, "resourcePath", pkg.resourcePathString);
        }
        if (pkg.legacyNativeLibraryPathString != null) {
            serializer.attribute(null, "nativeLibraryPath", pkg.legacyNativeLibraryPathString);
        }
        if (pkg.primaryCpuAbiString != null) {
            serializer.attribute(null, "primaryCpuAbi", pkg.primaryCpuAbiString);
        }
        if (pkg.secondaryCpuAbiString != null) {
            serializer.attribute(null, "secondaryCpuAbi", pkg.secondaryCpuAbiString);
        }
        if (pkg.cpuAbiOverrideString != null) {
            serializer.attribute(null, "cpuAbiOverride", pkg.cpuAbiOverrideString);
        }
        serializer.attribute(null, "flags", Integer.toString(pkg.pkgFlags));
        serializer.attribute(null, "ft", Long.toHexString(pkg.timeStamp));
        serializer.attribute(null, "it", Long.toHexString(pkg.firstInstallTime));
        serializer.attribute(null, "ut", Long.toHexString(pkg.lastUpdateTime));
        serializer.attribute(null, "version", String.valueOf(pkg.versionCode));
        if (pkg.sharedUser == null) {
            serializer.attribute(null, "userId", Integer.toString(pkg.appId));
        } else {
            serializer.attribute(null, "sharedUserId", Integer.toString(pkg.appId));
        }
        if (pkg.uidError) {
            serializer.attribute(null, "uidError", "true");
        }
        if (pkg.installStatus == 0) {
            serializer.attribute(null, "installStatus", "false");
        }
        if (pkg.installerPackageName != null) {
            serializer.attribute(null, "installer", pkg.installerPackageName);
        }
        pkg.signatures.writeXml(serializer, "sigs", this.mPastSignatures);
        if ((pkg.pkgFlags & 1) == 0) {
            serializer.startTag(null, "perms");
            if (pkg.sharedUser == null) {
                for (String name : pkg.grantedPermissions) {
                    serializer.startTag(null, TAG_ITEM);
                    serializer.attribute(null, ATTR_NAME, name);
                    serializer.endTag(null, TAG_ITEM);
                }
            }
            serializer.endTag(null, "perms");
        }
        this.writeSigningKeySetsLPr(serializer, pkg.keySetData);
        this.writeUpgradeKeySetsLPr(serializer, pkg.keySetData);
        this.writeKeySetAliasesLPr(serializer, pkg.keySetData);
        serializer.endTag(null, "package");
    }

    void writeSigningKeySetsLPr(XmlSerializer serializer, PackageKeySetData data) throws IOException {
        if (data.getSigningKeySets() != null) {
            long properSigningKeySet = data.getProperSigningKeySet();
            serializer.startTag(null, "proper-signing-keyset");
            serializer.attribute(null, "identifier", Long.toString(properSigningKeySet));
            serializer.endTag(null, "proper-signing-keyset");
            for (long id2 : data.getSigningKeySets()) {
                serializer.startTag(null, "signing-keyset");
                serializer.attribute(null, "identifier", Long.toString(id2));
                serializer.endTag(null, "signing-keyset");
            }
        }
    }

    void writeUpgradeKeySetsLPr(XmlSerializer serializer, PackageKeySetData data) throws IOException {
        if (data.isUsingUpgradeKeySets()) {
            for (long id2 : data.getUpgradeKeySets()) {
                serializer.startTag(null, "upgrade-keyset");
                serializer.attribute(null, "identifier", Long.toString(id2));
                serializer.endTag(null, "upgrade-keyset");
            }
        }
    }

    void writeKeySetAliasesLPr(XmlSerializer serializer, PackageKeySetData data) throws IOException {
        for (Map.Entry<String, Long> e : data.getAliases().entrySet()) {
            serializer.startTag(null, "defined-keyset");
            serializer.attribute(null, "alias", e.getKey());
            serializer.attribute(null, "identifier", Long.toString(e.getValue()));
            serializer.endTag(null, "defined-keyset");
        }
    }

    void writePermissionLPr(XmlSerializer serializer, BasePermission bp) throws XmlPullParserException, IOException {
        if (bp.type != 1 && bp.sourcePackage != null) {
            serializer.startTag(null, TAG_ITEM);
            serializer.attribute(null, ATTR_NAME, bp.name);
            serializer.attribute(null, "package", bp.sourcePackage);
            if (bp.protectionLevel != 0) {
                serializer.attribute(null, "protection", Integer.toString(bp.protectionLevel));
            }
            if (bp.type == 2) {
                PermissionInfo pi;
                PermissionInfo permissionInfo = pi = bp.perm != null ? bp.perm.info : bp.pendingInfo;
                if (pi != null) {
                    serializer.attribute(null, "type", "dynamic");
                    if (pi.icon != 0) {
                        serializer.attribute(null, "icon", Integer.toString(pi.icon));
                    }
                    if (pi.nonLocalizedLabel != null) {
                        serializer.attribute(null, "label", pi.nonLocalizedLabel.toString());
                    }
                }
            }
            serializer.endTag(null, TAG_ITEM);
        }
    }

    ArrayList<PackageSetting> getListOfIncompleteInstallPackagesLPr() {
        HashSet<String> kList = new HashSet<String>(this.mPackages.keySet());
        Iterator<String> its = kList.iterator();
        ArrayList<PackageSetting> ret = new ArrayList<PackageSetting>();
        while (its.hasNext()) {
            String key = its.next();
            PackageSetting ps = this.mPackages.get(key);
            if (ps.getInstallStatus() != 0) continue;
            ret.add(ps);
        }
        return ret;
    }

    void addPackageToCleanLPw(PackageCleanItem pkg) {
        if (!this.mPackagesToBeCleaned.contains(pkg)) {
            this.mPackagesToBeCleaned.add(pkg);
        }
    }

    boolean readLPw(PackageManagerService service, List<UserInfo> users, int sdkVersion, boolean onlyCore) {
        FileInputStream str = null;
        if (this.mBackupSettingsFilename.exists()) {
            try {
                str = new FileInputStream(this.mBackupSettingsFilename);
                this.mReadMessages.append("Reading from backup settings file\n");
                PackageManagerService.reportSettingsProblem(4, "Need to read from backup settings file");
                if (this.mSettingsFilename.exists()) {
                    Slog.w("PackageManager", "Cleaning up settings file " + this.mSettingsFilename);
                    this.mSettingsFilename.delete();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mPendingPackages.clear();
        this.mPastSignatures.clear();
        try {
            int type;
            if (str == null) {
                if (!this.mSettingsFilename.exists()) {
                    this.mReadMessages.append("No settings file found\n");
                    PackageManagerService.reportSettingsProblem(4, "No settings file; creating initial state");
                    this.mInternalSdkPlatform = this.mExternalSdkPlatform = sdkVersion;
                    this.mFingerprint = Build.FINGERPRINT;
                    return false;
                }
                str = new FileInputStream(this.mSettingsFilename);
            }
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(str, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                this.mReadMessages.append("No start tag found in settings file\n");
                PackageManagerService.reportSettingsProblem(5, "No start tag found in package manager settings");
                Slog.wtf("PackageManager", "No start tag found in package manager settings");
                return false;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("package")) {
                    this.readPackageLPw(parser);
                    continue;
                }
                if (tagName.equals("permissions")) {
                    this.readPermissionsLPw(this.mPermissions, parser);
                    continue;
                }
                if (tagName.equals("permission-trees")) {
                    this.readPermissionsLPw(this.mPermissionTrees, parser);
                    continue;
                }
                if (tagName.equals("shared-user")) {
                    this.readSharedUserLPw(parser);
                    continue;
                }
                if (tagName.equals("preferred-packages")) continue;
                if (tagName.equals("preferred-activities")) {
                    this.readPreferredActivitiesLPw(parser, 0);
                    continue;
                }
                if (tagName.equals(TAG_PERSISTENT_PREFERRED_ACTIVITIES)) {
                    this.readPersistentPreferredActivitiesLPw(parser, 0);
                    continue;
                }
                if (tagName.equals(TAG_CROSS_PROFILE_INTENT_FILTERS)) {
                    this.readCrossProfileIntentFiltersLPw(parser, 0);
                    continue;
                }
                if (tagName.equals("updated-package")) {
                    this.readDisabledSysPackageLPw(parser);
                    continue;
                }
                if (tagName.equals("cleaning-package")) {
                    String name = parser.getAttributeValue(null, ATTR_NAME);
                    String userStr = parser.getAttributeValue(null, ATTR_USER);
                    String codeStr = parser.getAttributeValue(null, ATTR_CODE);
                    if (name == null) continue;
                    int userId = 0;
                    boolean andCode = true;
                    try {
                        if (userStr != null) {
                            userId = Integer.parseInt(userStr);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (codeStr != null) {
                        andCode = Boolean.parseBoolean(codeStr);
                    }
                    this.addPackageToCleanLPw(new PackageCleanItem(userId, name, andCode));
                    continue;
                }
                if (tagName.equals("renamed-package")) {
                    String nname = parser.getAttributeValue(null, "new");
                    String oname = parser.getAttributeValue(null, "old");
                    if (nname == null || oname == null) continue;
                    this.mRenamedPackages.put(nname, oname);
                    continue;
                }
                if (tagName.equals("last-platform-version")) {
                    this.mExternalSdkPlatform = 0;
                    this.mInternalSdkPlatform = 0;
                    try {
                        String external;
                        String internal = parser.getAttributeValue(null, "internal");
                        if (internal != null) {
                            this.mInternalSdkPlatform = Integer.parseInt(internal);
                        }
                        if ((external = parser.getAttributeValue(null, "external")) != null) {
                            this.mExternalSdkPlatform = Integer.parseInt(external);
                        }
                    }
                    catch (NumberFormatException internal) {
                        // empty catch block
                    }
                    this.mFingerprint = parser.getAttributeValue(null, "fingerprint");
                    continue;
                }
                if (tagName.equals("database-version")) {
                    this.mExternalDatabaseVersion = 0;
                    this.mInternalDatabaseVersion = 0;
                    try {
                        String externalDbVersionString;
                        String internalDbVersionString = parser.getAttributeValue(null, "internal");
                        if (internalDbVersionString != null) {
                            this.mInternalDatabaseVersion = Integer.parseInt(internalDbVersionString);
                        }
                        if ((externalDbVersionString = parser.getAttributeValue(null, "external")) == null) continue;
                        this.mExternalDatabaseVersion = Integer.parseInt(externalDbVersionString);
                    }
                    catch (NumberFormatException internalDbVersionString) {}
                    continue;
                }
                if (tagName.equals("verifier")) {
                    String deviceIdentity = parser.getAttributeValue(null, "device");
                    try {
                        this.mVerifierDeviceIdentity = VerifierDeviceIdentity.parse(deviceIdentity);
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w("PackageManager", "Discard invalid verifier device id: " + e.getMessage());
                    }
                    continue;
                }
                if (TAG_READ_EXTERNAL_STORAGE.equals(tagName)) {
                    String enforcement = parser.getAttributeValue(null, ATTR_ENFORCEMENT);
                    this.mReadExternalStorageEnforced = "1".equals(enforcement);
                    continue;
                }
                if (tagName.equals("keyset-settings")) {
                    this.mKeySetManagerService.readKeySetsLPw(parser);
                    continue;
                }
                Slog.w("PackageManager", "Unknown element under <packages>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            str.close();
        }
        catch (XmlPullParserException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager settings", e);
        }
        catch (IOException e) {
            this.mReadMessages.append("Error reading: " + e.toString());
            PackageManagerService.reportSettingsProblem(6, "Error reading settings: " + e);
            Slog.wtf("PackageManager", "Error reading package manager settings", e);
        }
        int N = this.mPendingPackages.size();
        for (int i = 0; i < N; ++i) {
            String msg;
            PendingPackage pp = this.mPendingPackages.get(i);
            Object idObj = this.getUserIdLPr(pp.sharedId);
            if (idObj != null && idObj instanceof SharedUserSetting) {
                PackageSetting p = this.getPackageLPw(pp.name, null, pp.realName, (SharedUserSetting)idObj, pp.codePath, pp.resourcePath, pp.legacyNativeLibraryPathString, pp.primaryCpuAbiString, pp.secondaryCpuAbiString, pp.versionCode, pp.pkgFlags, null, true, false);
                if (p == null) {
                    PackageManagerService.reportSettingsProblem(5, "Unable to create application package for " + pp.name);
                    continue;
                }
                p.copyFrom(pp);
                continue;
            }
            if (idObj != null) {
                msg = "Bad package setting: package " + pp.name + " has shared uid " + pp.sharedId + " that is not a shared uid\n";
                this.mReadMessages.append(msg);
                PackageManagerService.reportSettingsProblem(6, msg);
                continue;
            }
            msg = "Bad package setting: package " + pp.name + " has shared uid " + pp.sharedId + " that is not defined\n";
            this.mReadMessages.append(msg);
            PackageManagerService.reportSettingsProblem(6, msg);
        }
        this.mPendingPackages.clear();
        if (this.mBackupStoppedPackagesFilename.exists() || this.mStoppedPackagesFilename.exists()) {
            this.readStoppedLPw();
            this.mBackupStoppedPackagesFilename.delete();
            this.mStoppedPackagesFilename.delete();
            this.writePackageRestrictionsLPr(0);
        } else if (users == null) {
            this.readPackageRestrictionsLPr(0);
        } else {
            for (UserInfo user : users) {
                this.readPackageRestrictionsLPr(user.id);
            }
        }
        for (PackageSetting disabledPs : this.mDisabledSysPackages.values()) {
            Object id2 = this.getUserIdLPr(disabledPs.appId);
            if (id2 == null || !(id2 instanceof SharedUserSetting)) continue;
            disabledPs.sharedUser = (SharedUserSetting)id2;
        }
        this.mReadMessages.append("Read completed successfully: " + this.mPackages.size() + " packages, " + this.mSharedUsers.size() + " shared uids\n");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readDefaultPreferredAppsLPw(PackageManagerService service, int userId) {
        for (PackageSetting ps : this.mPackages.values()) {
            if ((ps.pkgFlags & 1) == 0 || ps.pkg == null || ps.pkg.preferredActivityFilters == null) continue;
            ArrayList<PackageParser.ActivityIntentInfo> intents = ps.pkg.preferredActivityFilters;
            for (int i = 0; i < intents.size(); ++i) {
                PackageParser.ActivityIntentInfo aii = intents.get(i);
                this.applyDefaultPreferredActivityLPw(service, aii, new ComponentName(ps.name, aii.activity.className), userId);
            }
        }
        File preferredDir = new File(Environment.getRootDirectory(), "etc/preferred-apps");
        if (!preferredDir.exists() || !preferredDir.isDirectory()) {
            return;
        }
        if (!preferredDir.canRead()) {
            Slog.w(TAG, "Directory " + preferredDir + " cannot be read");
            return;
        }
        for (File f : preferredDir.listFiles()) {
            if (!f.getPath().endsWith(".xml")) {
                Slog.i(TAG, "Non-xml file " + f + " in " + preferredDir + " directory, ignoring");
                continue;
            }
            if (!f.canRead()) {
                Slog.w(TAG, "Preferred apps file " + f + " cannot be read");
                continue;
            }
            FileInputStream str = null;
            try {
                int type;
                str = new FileInputStream(f);
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(str, null);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    Slog.w(TAG, "Preferred apps file " + f + " does not have start tag");
                    continue;
                }
                if (!"preferred-activities".equals(parser.getName())) {
                    Slog.w(TAG, "Preferred apps file " + f + " does not start with 'preferred-activities'");
                    continue;
                }
                this.readDefaultPreferredActivitiesLPw(service, parser, userId);
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Error reading apps file " + f, e);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error reading apps file " + f, e);
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
    }

    private void applyDefaultPreferredActivityLPw(PackageManagerService service, IntentFilter tmpPa, ComponentName cn, int userId) {
        Intent intent = new Intent();
        int flags = 0;
        intent.setAction(tmpPa.getAction(0));
        for (int i = 0; i < tmpPa.countCategories(); ++i) {
            String cat = tmpPa.getCategory(i);
            if (cat.equals("android.intent.category.DEFAULT")) {
                flags |= 0x10000;
                continue;
            }
            intent.addCategory(cat);
        }
        boolean doNonData = true;
        boolean hasSchemes = false;
        for (int ischeme = 0; ischeme < tmpPa.countDataSchemes(); ++ischeme) {
            boolean doScheme = true;
            String scheme = tmpPa.getDataScheme(ischeme);
            if (scheme != null && !scheme.isEmpty()) {
                hasSchemes = true;
            }
            for (int issp = 0; issp < tmpPa.countDataSchemeSpecificParts(); ++issp) {
                Uri.Builder builder = new Uri.Builder();
                builder.scheme(scheme);
                PatternMatcher ssp = tmpPa.getDataSchemeSpecificPart(issp);
                builder.opaquePart(ssp.getPath());
                Intent finalIntent = new Intent(intent);
                finalIntent.setData(builder.build());
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, ssp, null, null, userId);
                doScheme = false;
            }
            for (int iauth = 0; iauth < tmpPa.countDataAuthorities(); ++iauth) {
                boolean doAuth = true;
                IntentFilter.AuthorityEntry auth = tmpPa.getDataAuthority(iauth);
                for (int ipath = 0; ipath < tmpPa.countDataPaths(); ++ipath) {
                    Uri.Builder builder = new Uri.Builder();
                    builder.scheme(scheme);
                    if (auth.getHost() != null) {
                        builder.authority(auth.getHost());
                    }
                    PatternMatcher path = tmpPa.getDataPath(ipath);
                    builder.path(path.getPath());
                    Intent finalIntent = new Intent(intent);
                    finalIntent.setData(builder.build());
                    this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, auth, path, userId);
                    doScheme = false;
                    doAuth = false;
                }
                if (!doAuth) continue;
                Uri.Builder builder = new Uri.Builder();
                builder.scheme(scheme);
                if (auth.getHost() != null) {
                    builder.authority(auth.getHost());
                }
                Intent finalIntent = new Intent(intent);
                finalIntent.setData(builder.build());
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, auth, null, userId);
                doScheme = false;
            }
            if (doScheme) {
                Uri.Builder builder = new Uri.Builder();
                builder.scheme(scheme);
                Intent finalIntent = new Intent(intent);
                finalIntent.setData(builder.build());
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, null, null, userId);
            }
            doNonData = false;
        }
        for (int idata = 0; idata < tmpPa.countDataTypes(); ++idata) {
            String mimeType = tmpPa.getDataType(idata);
            if (hasSchemes) {
                Uri.Builder builder = new Uri.Builder();
                for (int ischeme = 0; ischeme < tmpPa.countDataSchemes(); ++ischeme) {
                    String scheme = tmpPa.getDataScheme(ischeme);
                    if (scheme == null || scheme.isEmpty()) continue;
                    Intent finalIntent = new Intent(intent);
                    builder.scheme(scheme);
                    finalIntent.setDataAndType(builder.build(), mimeType);
                    this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, scheme, null, null, null, userId);
                }
            } else {
                Intent finalIntent = new Intent(intent);
                finalIntent.setType(mimeType);
                this.applyDefaultPreferredActivityLPw(service, finalIntent, flags, cn, null, null, null, null, userId);
            }
            doNonData = false;
        }
        if (doNonData) {
            this.applyDefaultPreferredActivityLPw(service, intent, flags, cn, null, null, null, null, userId);
        }
    }

    private void applyDefaultPreferredActivityLPw(PackageManagerService service, Intent intent, int flags, ComponentName cn, String scheme, PatternMatcher ssp, IntentFilter.AuthorityEntry auth, PatternMatcher path, int userId) {
        List<ResolveInfo> ri = service.mActivities.queryIntent(intent, intent.getType(), flags, 0);
        int systemMatch = 0;
        int thirdPartyMatch = 0;
        if (ri != null && ri.size() > 1) {
            boolean haveAct = false;
            ComponentName haveNonSys = null;
            ComponentName[] set = new ComponentName[ri.size()];
            for (int i = 0; i < ri.size(); ++i) {
                ActivityInfo ai = ri.get((int)i).activityInfo;
                set[i] = new ComponentName(ai.packageName, ai.name);
                if ((ai.applicationInfo.flags & 1) == 0) {
                    if (ri.get((int)i).match < thirdPartyMatch) continue;
                    haveNonSys = set[i];
                    break;
                }
                if (!cn.getPackageName().equals(ai.packageName) || !cn.getClassName().equals(ai.name)) continue;
                haveAct = true;
                systemMatch = ri.get((int)i).match;
            }
            if (haveNonSys != null && thirdPartyMatch < systemMatch) {
                haveNonSys = null;
            }
            if (haveAct && haveNonSys == null) {
                IntentFilter filter = new IntentFilter();
                if (intent.getAction() != null) {
                    filter.addAction(intent.getAction());
                }
                if (intent.getCategories() != null) {
                    for (String cat : intent.getCategories()) {
                        filter.addCategory(cat);
                    }
                }
                if ((flags & 0x10000) != 0) {
                    filter.addCategory("android.intent.category.DEFAULT");
                }
                if (scheme != null) {
                    filter.addDataScheme(scheme);
                }
                if (ssp != null) {
                    filter.addDataSchemeSpecificPart(ssp.getPath(), ssp.getType());
                }
                if (auth != null) {
                    filter.addDataAuthority(auth);
                }
                if (path != null) {
                    filter.addDataPath(path);
                }
                if (intent.getType() != null) {
                    try {
                        filter.addDataType(intent.getType());
                    }
                    catch (IntentFilter.MalformedMimeTypeException ex) {
                        Slog.w(TAG, "Malformed mimetype " + intent.getType() + " for " + cn);
                    }
                }
                PreferredActivity pa = new PreferredActivity(filter, systemMatch, set, cn, true);
                this.editPreferredActivitiesLPw(userId).addFilter(pa);
            } else if (haveNonSys == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("No component ");
                sb.append(cn.flattenToShortString());
                sb.append(" found setting preferred ");
                sb.append(intent);
                sb.append("; possible matches are ");
                for (int i = 0; i < set.length; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(set[i].flattenToShortString());
                }
                Slog.w(TAG, sb.toString());
            } else {
                Slog.i(TAG, "Not setting preferred " + intent + "; found third party match " + haveNonSys.flattenToShortString());
            }
        } else {
            Slog.w(TAG, "No potential matches found for " + intent + " while setting preferred " + cn.flattenToShortString());
        }
    }

    private void readDefaultPreferredActivitiesLPw(PackageManagerService service, XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                PreferredActivity tmpPa = new PreferredActivity(parser);
                if (tmpPa.mPref.getParseError() == null) {
                    this.applyDefaultPreferredActivityLPw(service, tmpPa, tmpPa.mPref.mComponent, userId);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <preferred-activity> " + tmpPa.mPref.getParseError() + " at " + parser.getPositionDescription());
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <preferred-activities>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private int readInt(XmlPullParser parser, String ns, String name, int defValue) {
        String v = parser.getAttributeValue(ns, name);
        try {
            if (v == null) {
                return defValue;
            }
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: attribute " + name + " has bad integer value " + v + " at " + parser.getPositionDescription());
            return defValue;
        }
    }

    private void readPermissionsLPw(HashMap<String, BasePermission> out, XmlPullParser parser) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                String sourcePackage = parser.getAttributeValue(null, "package");
                String ptype = parser.getAttributeValue(null, "type");
                if (name != null && sourcePackage != null) {
                    boolean dynamic = "dynamic".equals(ptype);
                    BasePermission bp = new BasePermission(name, sourcePackage, dynamic ? 2 : 0);
                    bp.protectionLevel = this.readInt(parser, null, "protection", 0);
                    bp.protectionLevel = PermissionInfo.fixProtectionLevel(bp.protectionLevel);
                    if (dynamic) {
                        PermissionInfo pi = new PermissionInfo();
                        pi.packageName = sourcePackage.intern();
                        pi.name = name.intern();
                        pi.icon = this.readInt(parser, null, "icon", 0);
                        pi.nonLocalizedLabel = parser.getAttributeValue(null, "label");
                        pi.protectionLevel = bp.protectionLevel;
                        bp.pendingInfo = pi;
                    }
                    out.put(bp.name, bp);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: permissions has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element reading permissions: " + parser.getName() + " at " + parser.getPositionDescription());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readDisabledSysPackageLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        String idStr;
        String name = parser.getAttributeValue(null, ATTR_NAME);
        String realName = parser.getAttributeValue(null, "realName");
        String codePathStr = parser.getAttributeValue(null, "codePath");
        String resourcePathStr = parser.getAttributeValue(null, "resourcePath");
        String legacyCpuAbiStr = parser.getAttributeValue(null, "requiredCpuAbi");
        String legacyNativeLibraryPathStr = parser.getAttributeValue(null, "nativeLibraryPath");
        String primaryCpuAbiStr = parser.getAttributeValue(null, "primaryCpuAbi");
        String secondaryCpuAbiStr = parser.getAttributeValue(null, "secondaryCpuAbi");
        String cpuAbiOverrideStr = parser.getAttributeValue(null, "cpuAbiOverride");
        if (primaryCpuAbiStr == null && legacyCpuAbiStr != null) {
            primaryCpuAbiStr = legacyCpuAbiStr;
        }
        if (resourcePathStr == null) {
            resourcePathStr = codePathStr;
        }
        String version = parser.getAttributeValue(null, "version");
        int versionCode = 0;
        if (version != null) {
            try {
                versionCode = Integer.parseInt(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int pkgFlags = 0;
        pkgFlags |= 1;
        File codePathFile = new File(codePathStr);
        if (PackageManagerService.locationIsPrivileged(codePathFile)) {
            pkgFlags |= 0x40000000;
        }
        PackageSetting ps = new PackageSetting(name, realName, codePathFile, new File(resourcePathStr), legacyNativeLibraryPathStr, primaryCpuAbiStr, secondaryCpuAbiStr, cpuAbiOverrideStr, versionCode, pkgFlags);
        String timeStampStr = parser.getAttributeValue(null, "ft");
        if (timeStampStr != null) {
            try {
                long timeStamp = Long.parseLong(timeStampStr, 16);
                ps.setTimeStamp(timeStamp);
            }
            catch (NumberFormatException timeStamp) {}
        } else {
            timeStampStr = parser.getAttributeValue(null, "ts");
            if (timeStampStr != null) {
                try {
                    long timeStamp = Long.parseLong(timeStampStr);
                    ps.setTimeStamp(timeStamp);
                }
                catch (NumberFormatException timeStamp) {
                    // empty catch block
                }
            }
        }
        if ((timeStampStr = parser.getAttributeValue(null, "it")) != null) {
            try {
                ps.firstInstallTime = Long.parseLong(timeStampStr, 16);
            }
            catch (NumberFormatException timeStamp) {
                // empty catch block
            }
        }
        if ((timeStampStr = parser.getAttributeValue(null, "ut")) != null) {
            try {
                ps.lastUpdateTime = Long.parseLong(timeStampStr, 16);
            }
            catch (NumberFormatException timeStamp) {
                // empty catch block
            }
        }
        int n = ps.appId = (idStr = parser.getAttributeValue(null, "userId")) != null ? Integer.parseInt(idStr) : 0;
        if (ps.appId <= 0) {
            String sharedIdStr = parser.getAttributeValue(null, "sharedUserId");
            ps.appId = sharedIdStr != null ? Integer.parseInt(sharedIdStr) : 0;
        }
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals("perms")) {
                this.readGrantedPermissionsLPw(parser, ps.grantedPermissions);
                continue;
            }
            PackageManagerService.reportSettingsProblem(5, "Unknown element under <updated-package>: " + parser.getName());
            XmlUtils.skipCurrentTag(parser);
        }
        this.mDisabledSysPackages.put(name, ps);
    }

    private void readPackageLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = null;
        String realName = null;
        String idStr = null;
        String sharedIdStr = null;
        String codePathStr = null;
        String resourcePathStr = null;
        String legacyCpuAbiString = null;
        String legacyNativeLibraryPathStr = null;
        String primaryCpuAbiString = null;
        String secondaryCpuAbiString = null;
        String cpuAbiOverrideString = null;
        String systemStr = null;
        String installerPackageName = null;
        String uidError = null;
        int pkgFlags = 0;
        long timeStamp = 0L;
        long firstInstallTime = 0L;
        long lastUpdateTime = 0L;
        PackageSettingBase packageSetting = null;
        String version = null;
        int versionCode = 0;
        try {
            int userId;
            name = parser.getAttributeValue(null, ATTR_NAME);
            realName = parser.getAttributeValue(null, "realName");
            idStr = parser.getAttributeValue(null, "userId");
            uidError = parser.getAttributeValue(null, "uidError");
            sharedIdStr = parser.getAttributeValue(null, "sharedUserId");
            codePathStr = parser.getAttributeValue(null, "codePath");
            resourcePathStr = parser.getAttributeValue(null, "resourcePath");
            legacyCpuAbiString = parser.getAttributeValue(null, "requiredCpuAbi");
            legacyNativeLibraryPathStr = parser.getAttributeValue(null, "nativeLibraryPath");
            primaryCpuAbiString = parser.getAttributeValue(null, "primaryCpuAbi");
            secondaryCpuAbiString = parser.getAttributeValue(null, "secondaryCpuAbi");
            cpuAbiOverrideString = parser.getAttributeValue(null, "cpuAbiOverride");
            if (primaryCpuAbiString == null && legacyCpuAbiString != null) {
                primaryCpuAbiString = legacyCpuAbiString;
            }
            if ((version = parser.getAttributeValue(null, "version")) != null) {
                try {
                    versionCode = Integer.parseInt(version);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            installerPackageName = parser.getAttributeValue(null, "installer");
            systemStr = parser.getAttributeValue(null, "flags");
            if (systemStr != null) {
                try {
                    pkgFlags = Integer.parseInt(systemStr);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                systemStr = parser.getAttributeValue(null, "system");
                pkgFlags = systemStr != null ? (pkgFlags |= "true".equalsIgnoreCase(systemStr) ? 1 : 0) : (pkgFlags |= 1);
            }
            String timeStampStr = parser.getAttributeValue(null, "ft");
            if (timeStampStr != null) {
                try {
                    timeStamp = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                timeStampStr = parser.getAttributeValue(null, "ts");
                if (timeStampStr != null) {
                    try {
                        timeStamp = Long.parseLong(timeStampStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if ((timeStampStr = parser.getAttributeValue(null, "it")) != null) {
                try {
                    firstInstallTime = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((timeStampStr = parser.getAttributeValue(null, "ut")) != null) {
                try {
                    lastUpdateTime = Long.parseLong(timeStampStr, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int n = userId = idStr != null ? Integer.parseInt(idStr) : 0;
            if (resourcePathStr == null) {
                resourcePathStr = codePathStr;
            }
            if (realName != null) {
                realName = realName.intern();
            }
            if (name == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <package> has no name at " + parser.getPositionDescription());
            } else if (codePathStr == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <package> has no codePath at " + parser.getPositionDescription());
            } else if (userId > 0) {
                packageSetting = this.addPackageLPw(name.intern(), realName, new File(codePathStr), new File(resourcePathStr), legacyNativeLibraryPathStr, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, userId, versionCode, pkgFlags);
                if (packageSetting == null) {
                    PackageManagerService.reportSettingsProblem(6, "Failure adding uid " + userId + " while parsing settings at " + parser.getPositionDescription());
                } else {
                    packageSetting.setTimeStamp(timeStamp);
                    packageSetting.firstInstallTime = firstInstallTime;
                    packageSetting.lastUpdateTime = lastUpdateTime;
                }
            } else if (sharedIdStr != null) {
                int n2 = userId = sharedIdStr != null ? Integer.parseInt(sharedIdStr) : 0;
                if (userId > 0) {
                    packageSetting = new PendingPackage(name.intern(), realName, new File(codePathStr), new File(resourcePathStr), legacyNativeLibraryPathStr, primaryCpuAbiString, secondaryCpuAbiString, cpuAbiOverrideString, userId, versionCode, pkgFlags);
                    packageSetting.setTimeStamp(timeStamp);
                    packageSetting.firstInstallTime = firstInstallTime;
                    packageSetting.lastUpdateTime = lastUpdateTime;
                    this.mPendingPackages.add((PendingPackage)packageSetting);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad sharedId " + sharedIdStr + " at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
            }
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
        }
        if (packageSetting != null) {
            int type;
            block56: {
                packageSetting.uidError = "true".equals(uidError);
                packageSetting.installerPackageName = installerPackageName;
                packageSetting.legacyNativeLibraryPathString = legacyNativeLibraryPathStr;
                packageSetting.primaryCpuAbiString = primaryCpuAbiString;
                packageSetting.secondaryCpuAbiString = secondaryCpuAbiString;
                String enabledStr = parser.getAttributeValue(null, ATTR_ENABLED);
                if (enabledStr != null) {
                    try {
                        packageSetting.setEnabled(Integer.parseInt(enabledStr), 0, null);
                    }
                    catch (NumberFormatException e) {
                        if (enabledStr.equalsIgnoreCase("true")) {
                            packageSetting.setEnabled(1, 0, null);
                            break block56;
                        }
                        if (enabledStr.equalsIgnoreCase("false")) {
                            packageSetting.setEnabled(2, 0, null);
                            break block56;
                        }
                        if (enabledStr.equalsIgnoreCase("default")) {
                            packageSetting.setEnabled(0, 0, null);
                            break block56;
                        }
                        PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad enabled value: " + idStr + " at " + parser.getPositionDescription());
                    }
                } else {
                    packageSetting.setEnabled(0, 0, null);
                }
            }
            String installStatusStr = parser.getAttributeValue(null, "installStatus");
            if (installStatusStr != null) {
                packageSetting.installStatus = installStatusStr.equalsIgnoreCase("false") ? 0 : 1;
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                long id2;
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals(TAG_DISABLED_COMPONENTS)) {
                    this.readDisabledComponentsLPw(packageSetting, parser, 0);
                    continue;
                }
                if (tagName.equals(TAG_ENABLED_COMPONENTS)) {
                    this.readEnabledComponentsLPw(packageSetting, parser, 0);
                    continue;
                }
                if (tagName.equals("sigs")) {
                    packageSetting.signatures.readXml(parser, this.mPastSignatures);
                    continue;
                }
                if (tagName.equals("perms")) {
                    this.readGrantedPermissionsLPw(parser, packageSetting.grantedPermissions);
                    packageSetting.permissionsFixed = true;
                    continue;
                }
                if (tagName.equals("proper-signing-keyset")) {
                    id2 = Long.parseLong(parser.getAttributeValue(null, "identifier"));
                    packageSetting.keySetData.setProperSigningKeySet(id2);
                    continue;
                }
                if (tagName.equals("signing-keyset")) {
                    id2 = Long.parseLong(parser.getAttributeValue(null, "identifier"));
                    packageSetting.keySetData.addSigningKeySet(id2);
                    continue;
                }
                if (tagName.equals("upgrade-keyset")) {
                    id2 = Long.parseLong(parser.getAttributeValue(null, "identifier"));
                    packageSetting.keySetData.addUpgradeKeySetById(id2);
                    continue;
                }
                if (tagName.equals("defined-keyset")) {
                    id2 = Long.parseLong(parser.getAttributeValue(null, "identifier"));
                    String alias = parser.getAttributeValue(null, "alias");
                    packageSetting.keySetData.addDefinedKeySet(id2, alias);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <package>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        } else {
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readDisabledComponentsLPw(PackageSettingBase packageSetting, XmlPullParser parser, int userId) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name != null) {
                    packageSetting.addDisabledComponent(name.intern(), userId);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <disabled-components> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <disabled-components>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readEnabledComponentsLPw(PackageSettingBase packageSetting, XmlPullParser parser, int userId) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name != null) {
                    packageSetting.addEnabledComponent(name.intern(), userId);
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <enabled-components> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <enabled-components>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readSharedUserLPw(XmlPullParser parser) throws XmlPullParserException, IOException {
        String name = null;
        String idStr = null;
        int pkgFlags = 0;
        SharedUserSetting su = null;
        try {
            int userId;
            name = parser.getAttributeValue(null, ATTR_NAME);
            idStr = parser.getAttributeValue(null, "userId");
            int n = userId = idStr != null ? Integer.parseInt(idStr) : 0;
            if ("true".equals(parser.getAttributeValue(null, "system"))) {
                pkgFlags |= 1;
            }
            if (name == null) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <shared-user> has no name at " + parser.getPositionDescription());
            } else if (userId == 0) {
                PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: shared-user " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
            } else {
                su = this.addSharedUserLPw(name.intern(), userId, pkgFlags);
                if (su == null) {
                    PackageManagerService.reportSettingsProblem(6, "Occurred while parsing settings at " + parser.getPositionDescription());
                }
            }
        }
        catch (NumberFormatException e) {
            PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: package " + name + " has bad userId " + idStr + " at " + parser.getPositionDescription());
        }
        if (su != null) {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("sigs")) {
                    su.signatures.readXml(parser, this.mPastSignatures);
                    continue;
                }
                if (tagName.equals("perms")) {
                    this.readGrantedPermissionsLPw(parser, su.grantedPermissions);
                    continue;
                }
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <shared-user>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        } else {
            XmlUtils.skipCurrentTag(parser);
        }
    }

    private void readGrantedPermissionsLPw(XmlPullParser parser, HashSet<String> outPerms) throws IOException, XmlPullParserException {
        int type;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4) continue;
            String tagName = parser.getName();
            if (tagName.equals(TAG_ITEM)) {
                String name = parser.getAttributeValue(null, ATTR_NAME);
                if (name != null) {
                    outPerms.add(name.intern());
                } else {
                    PackageManagerService.reportSettingsProblem(5, "Error in package manager settings: <perms> has no name at " + parser.getPositionDescription());
                }
            } else {
                PackageManagerService.reportSettingsProblem(5, "Unknown element under <perms>: " + parser.getName());
            }
            XmlUtils.skipCurrentTag(parser);
        }
    }

    void createNewUserLILPw(PackageManagerService service, Installer installer, int userHandle, File path) {
        path.mkdir();
        FileUtils.setPermissions(path.toString(), 505, -1, -1);
        for (PackageSetting ps : this.mPackages.values()) {
            if (ps.pkg == null || ps.pkg.applicationInfo == null) continue;
            ps.setInstalled((ps.pkgFlags & 1) != 0, userHandle);
            installer.createUserData(ps.name, UserHandle.getUid(userHandle, ps.appId), userHandle, ps.pkg.applicationInfo.seinfo);
        }
        this.readDefaultPreferredAppsLPw(service, userHandle);
        this.writePackageRestrictionsLPr(userHandle);
    }

    void removeUserLPw(int userId) {
        Set<Map.Entry<String, PackageSetting>> entries = this.mPackages.entrySet();
        for (Map.Entry<String, PackageSetting> entry : entries) {
            entry.getValue().removeUser(userId);
        }
        this.mPreferredActivities.remove(userId);
        File file = this.getUserPackagesStateFile(userId);
        file.delete();
        file = this.getUserPackagesStateBackupFile(userId);
        file.delete();
        this.removeCrossProfileIntentFiltersLPw(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCrossProfileIntentFiltersLPw(int userId) {
        SparseArray<CrossProfileIntentResolver> sparseArray = this.mCrossProfileIntentResolvers;
        synchronized (sparseArray) {
            if (this.mCrossProfileIntentResolvers.get(userId) != null) {
                this.mCrossProfileIntentResolvers.remove(userId);
                this.writePackageRestrictionsLPr(userId);
            }
            int count = this.mCrossProfileIntentResolvers.size();
            for (int i = 0; i < count; ++i) {
                int sourceUserId = this.mCrossProfileIntentResolvers.keyAt(i);
                CrossProfileIntentResolver cpir = this.mCrossProfileIntentResolvers.get(sourceUserId);
                boolean needsWriting = false;
                HashSet cpifs = new HashSet(cpir.filterSet());
                for (CrossProfileIntentFilter cpif : cpifs) {
                    if (cpif.getTargetUserId() != userId) continue;
                    needsWriting = true;
                    cpir.removeFilter(cpif);
                }
                if (!needsWriting) continue;
                this.writePackageRestrictionsLPr(sourceUserId);
            }
        }
    }

    private void setFirstAvailableUid(int uid) {
        if (uid > mFirstAvailableUid) {
            mFirstAvailableUid = uid;
        }
    }

    private int newUserIdLPw(Object obj) {
        int N = this.mUserIds.size();
        for (int i = mFirstAvailableUid; i < N; ++i) {
            if (this.mUserIds.get(i) != null) continue;
            this.mUserIds.set(i, obj);
            return 10000 + i;
        }
        if (N > 9999) {
            return -1;
        }
        this.mUserIds.add(obj);
        return 10000 + N;
    }

    public VerifierDeviceIdentity getVerifierDeviceIdentityLPw() {
        if (this.mVerifierDeviceIdentity == null) {
            this.mVerifierDeviceIdentity = VerifierDeviceIdentity.generate();
            this.writeLPr();
        }
        return this.mVerifierDeviceIdentity;
    }

    public PackageSetting getDisabledSystemPkgLPr(String name) {
        PackageSetting ps = this.mDisabledSysPackages.get(name);
        return ps;
    }

    private String compToString(HashSet<String> cmp) {
        return cmp != null ? Arrays.toString(cmp.toArray()) : "[]";
    }

    boolean isEnabledLPr(ComponentInfo componentInfo, int flags, int userId) {
        if ((flags & 0x200) != 0) {
            return true;
        }
        String pkgName = componentInfo.packageName;
        PackageSetting packageSettings = this.mPackages.get(pkgName);
        if (packageSettings == null) {
            return false;
        }
        PackageUserState ustate = packageSettings.readUserState(userId);
        if ((flags & 0x8000) != 0 && ustate.enabled == 4) {
            return true;
        }
        if (ustate.enabled == 2 || ustate.enabled == 3 || ustate.enabled == 4 || packageSettings.pkg != null && !packageSettings.pkg.applicationInfo.enabled && ustate.enabled == 0) {
            return false;
        }
        if (ustate.enabledComponents != null && ustate.enabledComponents.contains(componentInfo.name)) {
            return true;
        }
        if (ustate.disabledComponents != null && ustate.disabledComponents.contains(componentInfo.name)) {
            return false;
        }
        return componentInfo.enabled;
    }

    String getInstallerPackageNameLPr(String packageName) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        return pkg.installerPackageName;
    }

    int getApplicationEnabledSettingLPr(String packageName, int userId) {
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        return pkg.getEnabled(userId);
    }

    int getComponentEnabledSettingLPr(ComponentName componentName, int userId) {
        String packageName = componentName.getPackageName();
        PackageSetting pkg = this.mPackages.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown component: " + componentName);
        }
        String classNameStr = componentName.getClassName();
        return pkg.getCurrentEnabledStateLPr(classNameStr, userId);
    }

    boolean setPackageStoppedStateLPw(String packageName, boolean stopped, boolean allowedByPermission, int uid, int userId) {
        int appId = UserHandle.getAppId(uid);
        PackageSetting pkgSetting = this.mPackages.get(packageName);
        if (pkgSetting == null) {
            throw new IllegalArgumentException("Unknown package: " + packageName);
        }
        if (!allowedByPermission && appId != pkgSetting.appId) {
            throw new SecurityException("Permission Denial: attempt to change stopped state from pid=" + Binder.getCallingPid() + ", uid=" + uid + ", package uid=" + pkgSetting.appId);
        }
        if (pkgSetting.getStopped(userId) != stopped) {
            pkgSetting.setStopped(stopped, userId);
            if (pkgSetting.getNotLaunched(userId)) {
                if (pkgSetting.installerPackageName != null) {
                    PackageManagerService.sendPackageBroadcast("android.intent.action.PACKAGE_FIRST_LAUNCH", pkgSetting.name, null, pkgSetting.installerPackageName, null, new int[]{userId});
                }
                pkgSetting.setNotLaunched(false, userId);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UserInfo> getAllUsers() {
        long id2 = Binder.clearCallingIdentity();
        try {
            List<UserInfo> list = UserManagerService.getInstance().getUsers(false);
            return list;
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return null;
    }

    static final void printFlags(PrintWriter pw, int val, Object[] spec) {
        pw.print("[ ");
        for (int i = 0; i < spec.length; i += 2) {
            int mask = (Integer)spec[i];
            if ((val & mask) == 0) continue;
            pw.print(spec[i + 1]);
            pw.print(" ");
        }
        pw.print("]");
    }

    void dumpPackageLPr(PrintWriter pw, String prefix, String checkinTag, PackageSetting ps, SimpleDateFormat sdf, Date date, List<UserInfo> users) {
        if (checkinTag != null) {
            pw.print(checkinTag);
            pw.print(",");
            pw.print(ps.realName != null ? ps.realName : ps.name);
            pw.print(",");
            pw.print(ps.appId);
            pw.print(",");
            pw.print(ps.versionCode);
            pw.print(",");
            pw.print(ps.firstInstallTime);
            pw.print(",");
            pw.print(ps.lastUpdateTime);
            pw.print(",");
            pw.print(ps.installerPackageName != null ? ps.installerPackageName : "?");
            pw.println();
            for (UserInfo user : users) {
                pw.print(checkinTag);
                pw.print("-");
                pw.print("usr");
                pw.print(",");
                pw.print(user.id);
                pw.print(",");
                pw.print(ps.getInstalled(user.id) ? "I" : "i");
                pw.print(ps.getHidden(user.id) ? "B" : "b");
                pw.print(ps.getStopped(user.id) ? "S" : "s");
                pw.print(ps.getNotLaunched(user.id) ? "l" : "L");
                pw.print(",");
                pw.print(ps.getEnabled(user.id));
                String lastDisabledAppCaller = ps.getLastDisabledAppCaller(user.id);
                pw.print(",");
                pw.print(lastDisabledAppCaller != null ? lastDisabledAppCaller : "?");
                pw.println();
            }
            return;
        }
        pw.print(prefix);
        pw.print("Package [");
        pw.print(ps.realName != null ? ps.realName : ps.name);
        pw.print("] (");
        pw.print(Integer.toHexString(System.identityHashCode(ps)));
        pw.println("):");
        if (ps.realName != null) {
            pw.print(prefix);
            pw.print("  compat name=");
            pw.println(ps.name);
        }
        pw.print(prefix);
        pw.print("  userId=");
        pw.print(ps.appId);
        pw.print(" gids=");
        pw.println(PackageManagerService.arrayToString(ps.gids));
        if (ps.sharedUser != null) {
            pw.print(prefix);
            pw.print("  sharedUser=");
            pw.println(ps.sharedUser);
        }
        pw.print(prefix);
        pw.print("  pkg=");
        pw.println(ps.pkg);
        pw.print(prefix);
        pw.print("  codePath=");
        pw.println(ps.codePathString);
        pw.print(prefix);
        pw.print("  resourcePath=");
        pw.println(ps.resourcePathString);
        pw.print(prefix);
        pw.print("  legacyNativeLibraryDir=");
        pw.println(ps.legacyNativeLibraryPathString);
        pw.print(prefix);
        pw.print("  primaryCpuAbi=");
        pw.println(ps.primaryCpuAbiString);
        pw.print(prefix);
        pw.print("  secondaryCpuAbi=");
        pw.println(ps.secondaryCpuAbiString);
        pw.print(prefix);
        pw.print("  versionCode=");
        pw.print(ps.versionCode);
        if (ps.pkg != null) {
            pw.print(" targetSdk=");
            pw.print(ps.pkg.applicationInfo.targetSdkVersion);
        }
        pw.println();
        if (ps.pkg != null) {
            int i;
            pw.print(prefix);
            pw.print("  versionName=");
            pw.println(ps.pkg.mVersionName);
            pw.print(prefix);
            pw.print("  applicationInfo=");
            pw.println(ps.pkg.applicationInfo.toString());
            pw.print(prefix);
            pw.print("  flags=");
            Settings.printFlags(pw, ps.pkg.applicationInfo.flags, FLAG_DUMP_SPEC);
            pw.println();
            pw.print(prefix);
            pw.print("  dataDir=");
            pw.println(ps.pkg.applicationInfo.dataDir);
            if (ps.pkg.mOperationPending) {
                pw.print(prefix);
                pw.println("  mOperationPending=true");
            }
            pw.print(prefix);
            pw.print("  supportsScreens=[");
            boolean first = true;
            if ((ps.pkg.applicationInfo.flags & 0x200) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("small");
            }
            if ((ps.pkg.applicationInfo.flags & 0x400) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("medium");
            }
            if ((ps.pkg.applicationInfo.flags & 0x800) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("large");
            }
            if ((ps.pkg.applicationInfo.flags & 0x80000) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("xlarge");
            }
            if ((ps.pkg.applicationInfo.flags & 0x1000) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("resizeable");
            }
            if ((ps.pkg.applicationInfo.flags & 0x2000) != 0) {
                if (!first) {
                    pw.print(", ");
                }
                first = false;
                pw.print("anyDensity");
            }
            pw.println("]");
            if (ps.pkg.libraryNames != null && ps.pkg.libraryNames.size() > 0) {
                pw.print(prefix);
                pw.println("  libraries:");
                for (i = 0; i < ps.pkg.libraryNames.size(); ++i) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.libraryNames.get(i));
                }
            }
            if (ps.pkg.usesLibraries != null && ps.pkg.usesLibraries.size() > 0) {
                pw.print(prefix);
                pw.println("  usesLibraries:");
                for (i = 0; i < ps.pkg.usesLibraries.size(); ++i) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.usesLibraries.get(i));
                }
            }
            if (ps.pkg.usesOptionalLibraries != null && ps.pkg.usesOptionalLibraries.size() > 0) {
                pw.print(prefix);
                pw.println("  usesOptionalLibraries:");
                for (i = 0; i < ps.pkg.usesOptionalLibraries.size(); ++i) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.usesOptionalLibraries.get(i));
                }
            }
            if (ps.pkg.usesLibraryFiles != null && ps.pkg.usesLibraryFiles.length > 0) {
                pw.print(prefix);
                pw.println("  usesLibraryFiles:");
                for (i = 0; i < ps.pkg.usesLibraryFiles.length; ++i) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(ps.pkg.usesLibraryFiles[i]);
                }
            }
        }
        pw.print(prefix);
        pw.print("  timeStamp=");
        date.setTime(ps.timeStamp);
        pw.println(sdf.format(date));
        pw.print(prefix);
        pw.print("  firstInstallTime=");
        date.setTime(ps.firstInstallTime);
        pw.println(sdf.format(date));
        pw.print(prefix);
        pw.print("  lastUpdateTime=");
        date.setTime(ps.lastUpdateTime);
        pw.println(sdf.format(date));
        if (ps.installerPackageName != null) {
            pw.print(prefix);
            pw.print("  installerPackageName=");
            pw.println(ps.installerPackageName);
        }
        pw.print(prefix);
        pw.print("  signatures=");
        pw.println(ps.signatures);
        pw.print(prefix);
        pw.print("  permissionsFixed=");
        pw.print(ps.permissionsFixed);
        pw.print(" haveGids=");
        pw.print(ps.haveGids);
        pw.print(" installStatus=");
        pw.println(ps.installStatus);
        pw.print(prefix);
        pw.print("  pkgFlags=");
        Settings.printFlags(pw, ps.pkgFlags, FLAG_DUMP_SPEC);
        pw.println();
        for (UserInfo user : users) {
            HashSet<String> cmp;
            pw.print(prefix);
            pw.print("  User ");
            pw.print(user.id);
            pw.print(": ");
            pw.print(" installed=");
            pw.print(ps.getInstalled(user.id));
            pw.print(" hidden=");
            pw.print(ps.getHidden(user.id));
            pw.print(" stopped=");
            pw.print(ps.getStopped(user.id));
            pw.print(" notLaunched=");
            pw.print(ps.getNotLaunched(user.id));
            pw.print(" enabled=");
            pw.println(ps.getEnabled(user.id));
            String lastDisabledAppCaller = ps.getLastDisabledAppCaller(user.id);
            if (lastDisabledAppCaller != null) {
                pw.print(prefix);
                pw.print("    lastDisabledCaller: ");
                pw.println(lastDisabledAppCaller);
            }
            if ((cmp = ps.getDisabledComponents(user.id)) != null && cmp.size() > 0) {
                pw.print(prefix);
                pw.println("    disabledComponents:");
                for (String s : cmp) {
                    pw.print(prefix);
                    pw.print("    ");
                    pw.println(s);
                }
            }
            if ((cmp = ps.getEnabledComponents(user.id)) == null || cmp.size() <= 0) continue;
            pw.print(prefix);
            pw.println("    enabledComponents:");
            for (String s : cmp) {
                pw.print(prefix);
                pw.print("    ");
                pw.println(s);
            }
        }
        if (ps.grantedPermissions.size() > 0) {
            pw.print(prefix);
            pw.println("  grantedPermissions:");
            for (String s : ps.grantedPermissions) {
                pw.print(prefix);
                pw.print("    ");
                pw.println(s);
            }
        }
    }

    void dumpPackagesLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState, boolean checkin) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        boolean printedSomething = false;
        List<UserInfo> users = this.getAllUsers();
        for (PackageSetting packageSetting : this.mPackages.values()) {
            if (packageName != null && !packageName.equals(packageSetting.realName) && !packageName.equals(packageSetting.name)) continue;
            if (!checkin && packageName != null) {
                dumpState.setSharedUser(packageSetting.sharedUser);
            }
            if (!checkin && !printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Packages:");
                printedSomething = true;
            }
            this.dumpPackageLPr(pw, "  ", checkin ? TAG_PACKAGE : null, packageSetting, sdf, date, users);
        }
        printedSomething = false;
        if (!checkin && this.mRenamedPackages.size() > 0) {
            for (Map.Entry entry : this.mRenamedPackages.entrySet()) {
                if (packageName != null && !packageName.equals(entry.getKey()) && !packageName.equals(entry.getValue())) continue;
                if (!checkin) {
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Renamed packages:");
                        printedSomething = true;
                    }
                    pw.print("  ");
                } else {
                    pw.print("ren,");
                }
                pw.print((String)entry.getKey());
                pw.print(checkin ? " -> " : ",");
                pw.println((String)entry.getValue());
            }
        }
        printedSomething = false;
        if (this.mDisabledSysPackages.size() > 0) {
            for (PackageSetting packageSetting : this.mDisabledSysPackages.values()) {
                if (packageName != null && !packageName.equals(packageSetting.realName) && !packageName.equals(packageSetting.name)) continue;
                if (!checkin && !printedSomething) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Hidden system packages:");
                    printedSomething = true;
                }
                this.dumpPackageLPr(pw, "  ", checkin ? "dis" : null, packageSetting, sdf, date, users);
            }
        }
    }

    void dumpPermissionsLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        boolean printedSomething = false;
        for (BasePermission p : this.mPermissions.values()) {
            if (packageName != null && !packageName.equals(p.sourcePackage)) continue;
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Permissions:");
                printedSomething = true;
            }
            pw.print("  Permission [");
            pw.print(p.name);
            pw.print("] (");
            pw.print(Integer.toHexString(System.identityHashCode(p)));
            pw.println("):");
            pw.print("    sourcePackage=");
            pw.println(p.sourcePackage);
            pw.print("    uid=");
            pw.print(p.uid);
            pw.print(" gids=");
            pw.print(PackageManagerService.arrayToString(p.gids));
            pw.print(" type=");
            pw.print(p.type);
            pw.print(" prot=");
            pw.println(PermissionInfo.protectionToString(p.protectionLevel));
            if (p.packageSetting != null) {
                pw.print("    packageSetting=");
                pw.println(p.packageSetting);
            }
            if (p.perm != null) {
                pw.print("    perm=");
                pw.println(p.perm);
            }
            if (!"android.permission.READ_EXTERNAL_STORAGE".equals(p.name)) continue;
            pw.print("    enforced=");
            pw.println(this.mReadExternalStorageEnforced);
        }
    }

    void dumpSharedUsersLPr(PrintWriter pw, String packageName, PackageManagerService.DumpState dumpState) {
        boolean printedSomething = false;
        for (SharedUserSetting su : this.mSharedUsers.values()) {
            if (packageName != null && su != dumpState.getSharedUser()) continue;
            if (!printedSomething) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Shared users:");
                printedSomething = true;
            }
            pw.print("  SharedUser [");
            pw.print(su.name);
            pw.print("] (");
            pw.print(Integer.toHexString(System.identityHashCode(su)));
            pw.println("):");
            pw.print("    userId=");
            pw.print(su.userId);
            pw.print(" gids=");
            pw.println(PackageManagerService.arrayToString(su.gids));
            pw.println("    grantedPermissions:");
            for (String s : su.grantedPermissions) {
                pw.print("      ");
                pw.println(s);
            }
        }
    }

    void dumpReadMessagesLPr(PrintWriter pw, PackageManagerService.DumpState dumpState) {
        pw.println("Settings parse messages:");
        pw.print(this.mReadMessages.toString());
    }

    public static class DatabaseVersion {
        public static final int FIRST_VERSION = 1;
        public static final int SIGNATURE_END_ENTITY = 2;
        public static final int SIGNATURE_MALFORMED_RECOVER = 3;
    }
}

