/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IStopUserCallback;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IUserManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.app.IAppOpsService;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.server.pm.PackageManagerService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class UserManagerService
extends IUserManager.Stub {
    private static final String LOG_TAG = "UserManagerService";
    private static final boolean DBG = false;
    private static final String TAG_NAME = "name";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_ICON_PATH = "icon";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CREATION_TIME = "created";
    private static final String ATTR_LAST_LOGGED_IN_TIME = "lastLoggedIn";
    private static final String ATTR_SALT = "salt";
    private static final String ATTR_PIN_HASH = "pinHash";
    private static final String ATTR_FAILED_ATTEMPTS = "failedAttempts";
    private static final String ATTR_LAST_RETRY_MS = "lastAttemptMs";
    private static final String ATTR_SERIAL_NO = "serialNumber";
    private static final String ATTR_NEXT_SERIAL_NO = "nextSerialNumber";
    private static final String ATTR_PARTIAL = "partial";
    private static final String ATTR_GUEST_TO_REMOVE = "guestToRemove";
    private static final String ATTR_USER_VERSION = "version";
    private static final String ATTR_PROFILE_GROUP_ID = "profileGroupId";
    private static final String TAG_GUEST_RESTRICTIONS = "guestRestrictions";
    private static final String TAG_USERS = "users";
    private static final String TAG_USER = "user";
    private static final String TAG_RESTRICTIONS = "restrictions";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_VALUE = "value";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE_TYPE = "type";
    private static final String ATTR_MULTIPLE = "m";
    private static final String ATTR_TYPE_STRING_ARRAY = "sa";
    private static final String ATTR_TYPE_STRING = "s";
    private static final String ATTR_TYPE_BOOLEAN = "b";
    private static final String ATTR_TYPE_INTEGER = "i";
    private static final String USER_INFO_DIR = "system" + File.separator + "users";
    private static final String USER_LIST_FILENAME = "userlist.xml";
    private static final String USER_PHOTO_FILENAME = "photo.png";
    private static final String RESTRICTIONS_FILE_PREFIX = "res_";
    private static final String XML_SUFFIX = ".xml";
    private static final int MIN_USER_ID = 10;
    private static final int USER_VERSION = 5;
    private static final long EPOCH_PLUS_30_YEARS = 946080000000L;
    private static final int BACKOFF_INC_INTERVAL = 5;
    private static final int MAX_MANAGED_PROFILES = 1;
    private static final int[] BACKOFF_TIMES = new int[]{0, 30000, 60000, 300000, 1800000};
    private final Context mContext;
    private final PackageManagerService mPm;
    private final Object mInstallLock;
    private final Object mPackagesLock;
    private final Handler mHandler;
    private final File mUsersDir;
    private final File mUserListFile;
    private final File mBaseUserPath;
    private final SparseArray<UserInfo> mUsers = new SparseArray();
    private final SparseArray<Bundle> mUserRestrictions = new SparseArray();
    private final Bundle mGuestRestrictions = new Bundle();
    private final SparseArray<RestrictionsPinState> mRestrictionsPinStates = new SparseArray();
    private final SparseBooleanArray mRemovingUserIds = new SparseBooleanArray();
    private int[] mUserIds;
    private int mNextSerialNumber;
    private int mUserVersion = 0;
    private IAppOpsService mAppOpsService;
    private static UserManagerService sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserManagerService getInstance() {
        Class<UserManagerService> clazz = UserManagerService.class;
        synchronized (UserManagerService.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    UserManagerService(File dataDir, File baseUserPath) {
        this(null, null, new Object(), new Object(), dataDir, baseUserPath);
    }

    UserManagerService(Context context, PackageManagerService pm, Object installLock, Object packagesLock) {
        this(context, pm, installLock, packagesLock, Environment.getDataDirectory(), new File(Environment.getDataDirectory(), TAG_USER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserManagerService(Context context, PackageManagerService pm, Object installLock, Object packagesLock, File dataDir, File baseUserPath) {
        this.mContext = context;
        this.mPm = pm;
        this.mInstallLock = installLock;
        this.mPackagesLock = packagesLock;
        this.mHandler = new Handler();
        Object object = this.mInstallLock;
        synchronized (object) {
            Object object2 = this.mPackagesLock;
            synchronized (object2) {
                UserInfo ui;
                int i;
                this.mUsersDir = new File(dataDir, USER_INFO_DIR);
                this.mUsersDir.mkdirs();
                File userZeroDir = new File(this.mUsersDir, "0");
                userZeroDir.mkdirs();
                this.mBaseUserPath = baseUserPath;
                FileUtils.setPermissions(this.mUsersDir.toString(), 509, -1, -1);
                this.mUserListFile = new File(this.mUsersDir, USER_LIST_FILENAME);
                this.readUserListLocked();
                ArrayList<UserInfo> partials = new ArrayList<UserInfo>();
                for (i = 0; i < this.mUsers.size(); ++i) {
                    ui = this.mUsers.valueAt(i);
                    if (!ui.partial && !ui.guestToRemove || i == 0) continue;
                    partials.add(ui);
                }
                for (i = 0; i < partials.size(); ++i) {
                    ui = (UserInfo)partials.get(i);
                    Slog.w(LOG_TAG, "Removing partially created user #" + i + " (name=" + ui.name + ")");
                    this.removeUserStateLocked(ui.id);
                }
                sInstance = this;
            }
        }
    }

    void systemReady() {
        this.userForeground(0);
        this.mAppOpsService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        for (int i = 0; i < this.mUserIds.length; ++i) {
            try {
                this.mAppOpsService.setUserRestrictions(this.mUserRestrictions.get(this.mUserIds[i]), this.mUserIds[i]);
                continue;
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "Unable to notify AppOpsService of UserRestrictions");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfo> getUsers(boolean excludeDying) {
        UserManagerService.checkManageUsersPermission("query users");
        Object object = this.mPackagesLock;
        synchronized (object) {
            ArrayList<UserInfo> users = new ArrayList<UserInfo>(this.mUsers.size());
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo ui = this.mUsers.valueAt(i);
                if (ui.partial || excludeDying && this.mRemovingUserIds.get(ui.id)) continue;
                users.add(ui);
            }
            return users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfo> getProfiles(int userId, boolean enabledOnly) {
        if (userId != UserHandle.getCallingUserId()) {
            UserManagerService.checkManageUsersPermission("getting profiles related to user " + userId);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mPackagesLock;
            synchronized (object) {
                List<UserInfo> list = this.getProfilesLocked(userId, enabledOnly);
                return list;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private List<UserInfo> getProfilesLocked(int userId, boolean enabledOnly) {
        UserInfo user = this.getUserInfoLocked(userId);
        ArrayList<UserInfo> users = new ArrayList<UserInfo>(this.mUsers.size());
        if (user == null) {
            return users;
        }
        for (int i = 0; i < this.mUsers.size(); ++i) {
            UserInfo profile = this.mUsers.valueAt(i);
            if (!this.isProfileOf(user, profile) || enabledOnly && !profile.isEnabled() || this.mRemovingUserIds.get(profile.id)) continue;
            users.add(profile);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getProfileParent(int userHandle) {
        UserManagerService.checkManageUsersPermission("get the profile parent");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo profile = this.getUserInfoLocked(userHandle);
            int parentUserId = profile.profileGroupId;
            if (parentUserId == -1) {
                return null;
            }
            return this.getUserInfoLocked(parentUserId);
        }
    }

    private boolean isProfileOf(UserInfo user, UserInfo profile) {
        return user.id == profile.id || user.profileGroupId != -1 && user.profileGroupId == profile.profileGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserEnabled(int userId) {
        UserManagerService.checkManageUsersPermission("enable user");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.getUserInfoLocked(userId);
            if (info != null && !info.isEnabled()) {
                info.flags ^= 0x40;
                this.writeUserLocked(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(int userId) {
        UserManagerService.checkManageUsersPermission("query user");
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.getUserInfoLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRestricted() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.getUserInfoLocked(UserHandle.getCallingUserId()).isRestricted();
        }
    }

    private UserInfo getUserInfoLocked(int userId) {
        UserInfo ui = this.mUsers.get(userId);
        if (ui != null && ui.partial && !this.mRemovingUserIds.get(userId)) {
            Slog.w(LOG_TAG, "getUserInfo: unknown user #" + userId);
            return null;
        }
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return ArrayUtils.contains(this.mUserIds, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserName(int userId, String name) {
        UserManagerService.checkManageUsersPermission("rename users");
        boolean changed = false;
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "setUserName: unknown user #" + userId);
                return;
            }
            if (name != null && !name.equals(info.name)) {
                info.name = name;
                this.writeUserLocked(info);
                changed = true;
            }
        }
        if (changed) {
            this.sendUserInfoChangedBroadcast(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIcon(int userId, Bitmap bitmap) {
        UserManagerService.checkManageUsersPermission("update users");
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mPackagesLock;
            synchronized (object) {
                UserInfo info;
                block8: {
                    info = this.mUsers.get(userId);
                    if (info != null && !info.partial) break block8;
                    Slog.w(LOG_TAG, "setUserIcon: unknown user #" + userId);
                    return;
                }
                this.writeBitmapLocked(info, bitmap);
                this.writeUserLocked(info);
            }
            this.sendUserInfoChangedBroadcast(userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void sendUserInfoChangedBroadcast(int userId) {
        Intent changedIntent = new Intent("android.intent.action.USER_INFO_CHANGED");
        changedIntent.putExtra("android.intent.extra.user_handle", userId);
        changedIntent.addFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(changedIntent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap getUserIcon(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "getUserIcon: unknown user #" + userId);
                return null;
            }
            int callingGroupId = this.mUsers.get((int)UserHandle.getCallingUserId()).profileGroupId;
            if (callingGroupId == -1 || callingGroupId != info.profileGroupId) {
                UserManagerService.checkManageUsersPermission("get the icon of a user who is not related");
            }
            if (info.iconPath == null) {
                return null;
            }
            return BitmapFactory.decodeFile(info.iconPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeInitialized(int userId) {
        UserManagerService.checkManageUsersPermission("makeInitialized");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "makeInitialized: unknown user #" + userId);
            }
            if ((info.flags & 0x10) == 0) {
                info.flags |= 0x10;
                this.writeUserLocked(info);
            }
        }
    }

    private void initDefaultGuestRestrictions() {
        if (this.mGuestRestrictions.isEmpty()) {
            this.mGuestRestrictions.putBoolean("no_outgoing_calls", true);
            this.writeUserListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getDefaultGuestRestrictions() {
        UserManagerService.checkManageUsersPermission("getDefaultGuestRestrictions");
        Object object = this.mPackagesLock;
        synchronized (object) {
            return new Bundle(this.mGuestRestrictions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultGuestRestrictions(Bundle restrictions) {
        UserManagerService.checkManageUsersPermission("setDefaultGuestRestrictions");
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.mGuestRestrictions.clear();
            this.mGuestRestrictions.putAll(restrictions);
            this.writeUserListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUserRestriction(String restrictionKey, int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            Bundle restrictions = this.mUserRestrictions.get(userId);
            return restrictions != null ? restrictions.getBoolean(restrictionKey) : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getUserRestrictions(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            Bundle restrictions = this.mUserRestrictions.get(userId);
            return restrictions != null ? new Bundle(restrictions) : new Bundle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestrictions(Bundle restrictions, int userId) {
        UserManagerService.checkManageUsersPermission("setUserRestrictions");
        if (restrictions == null) {
            return;
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.mUserRestrictions.get(userId).clear();
            this.mUserRestrictions.get(userId).putAll(restrictions);
            long token = Binder.clearCallingIdentity();
            try {
                this.mAppOpsService.setUserRestrictions(this.mUserRestrictions.get(userId), userId);
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "Unable to notify AppOpsService of UserRestrictions");
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            this.writeUserLocked(this.mUsers.get(userId));
        }
    }

    private boolean isUserLimitReachedLocked() {
        int aliveUserCount = 0;
        int totalUserCount = this.mUsers.size();
        for (int i = 0; i < totalUserCount; ++i) {
            UserInfo user = this.mUsers.valueAt(i);
            if (this.mRemovingUserIds.get(user.id) || user.isGuest() || user.partial) continue;
            ++aliveUserCount;
        }
        return aliveUserCount >= UserManager.getMaxSupportedUsers();
    }

    private static final void checkManageUsersPermission(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0 && ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", uid, -1, true) != 0) {
            throw new SecurityException("You need MANAGE_USERS permission to: " + message);
        }
    }

    private void writeBitmapLocked(UserInfo info, Bitmap bitmap) {
        try {
            FileOutputStream os;
            File dir = new File(this.mUsersDir, Integer.toString(info.id));
            File file = new File(dir, USER_PHOTO_FILENAME);
            if (!dir.exists()) {
                dir.mkdir();
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, os = new FileOutputStream(file))) {
                info.iconPath = file.getAbsolutePath();
            }
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        catch (FileNotFoundException e) {
            Slog.w(LOG_TAG, "Error setting photo for user ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUserIds() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.mUserIds;
        }
    }

    int[] getUserIdsLPr() {
        return this.mUserIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUserListLocked() {
        if (!this.mUserListFile.exists()) {
            this.fallbackToSingleUserLocked();
            return;
        }
        FileInputStream fis = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            int type;
            fis = userListFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user list");
                this.fallbackToSingleUserLocked();
                return;
            }
            this.mNextSerialNumber = -1;
            if (parser.getName().equals(TAG_USERS)) {
                String versionNumber;
                String lastSerialNumber = parser.getAttributeValue(null, ATTR_NEXT_SERIAL_NO);
                if (lastSerialNumber != null) {
                    this.mNextSerialNumber = Integer.parseInt(lastSerialNumber);
                }
                if ((versionNumber = parser.getAttributeValue(null, ATTR_USER_VERSION)) != null) {
                    this.mUserVersion = Integer.parseInt(versionNumber);
                }
            }
            while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                String name = parser.getName();
                if (name.equals(TAG_USER)) {
                    String id2 = parser.getAttributeValue(null, ATTR_ID);
                    UserInfo user = this.readUserLocked(Integer.parseInt(id2));
                    if (user == null) continue;
                    this.mUsers.put(user.id, user);
                    if (this.mNextSerialNumber >= 0 && this.mNextSerialNumber > user.id) continue;
                    this.mNextSerialNumber = user.id + 1;
                    continue;
                }
                if (!name.equals(TAG_GUEST_RESTRICTIONS)) continue;
                this.mGuestRestrictions.clear();
                this.readRestrictionsLocked(parser, this.mGuestRestrictions);
            }
            this.updateUserIdsLocked();
            this.upgradeIfNecessaryLocked();
        }
        catch (IOException ioe) {
            this.fallbackToSingleUserLocked();
        }
        catch (XmlPullParserException pe) {
            this.fallbackToSingleUserLocked();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private void upgradeIfNecessaryLocked() {
        UserInfo user;
        int userVersion = this.mUserVersion;
        if (userVersion < 1) {
            user = this.mUsers.get(0);
            if ("Primary".equals(user.name)) {
                user.name = this.mContext.getResources().getString(17040889);
                this.writeUserLocked(user);
            }
            userVersion = 1;
        }
        if (userVersion < 2) {
            user = this.mUsers.get(0);
            if ((user.flags & 0x10) == 0) {
                user.flags |= 0x10;
                this.writeUserLocked(user);
            }
            userVersion = 2;
        }
        if (userVersion < 4) {
            userVersion = 4;
        }
        if (userVersion < 5) {
            this.initDefaultGuestRestrictions();
            userVersion = 5;
        }
        if (userVersion < 5) {
            Slog.w(LOG_TAG, "User version " + this.mUserVersion + " didn't upgrade as expected to " + 5);
        } else {
            this.mUserVersion = userVersion;
            this.writeUserListLocked();
        }
    }

    private void fallbackToSingleUserLocked() {
        UserInfo primary = new UserInfo(0, this.mContext.getResources().getString(17040889), null, 19);
        this.mUsers.put(0, primary);
        this.mNextSerialNumber = 10;
        this.mUserVersion = 5;
        Bundle restrictions = new Bundle();
        this.mUserRestrictions.append(0, restrictions);
        this.updateUserIdsLocked();
        this.initDefaultGuestRestrictions();
        this.writeUserListLocked();
        this.writeUserLocked(primary);
    }

    private void writeUserLocked(UserInfo userInfo) {
        FileOutputStream fos = null;
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userInfo.id + XML_SUFFIX));
        try {
            fos = userFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USER);
            serializer.attribute(null, ATTR_ID, Integer.toString(userInfo.id));
            serializer.attribute(null, ATTR_SERIAL_NO, Integer.toString(userInfo.serialNumber));
            serializer.attribute(null, ATTR_FLAGS, Integer.toString(userInfo.flags));
            serializer.attribute(null, ATTR_CREATION_TIME, Long.toString(userInfo.creationTime));
            serializer.attribute(null, ATTR_LAST_LOGGED_IN_TIME, Long.toString(userInfo.lastLoggedInTime));
            RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userInfo.id);
            if (pinState != null) {
                if (pinState.salt != 0L) {
                    serializer.attribute(null, ATTR_SALT, Long.toString(pinState.salt));
                }
                if (pinState.pinHash != null) {
                    serializer.attribute(null, ATTR_PIN_HASH, pinState.pinHash);
                }
                if (pinState.failedAttempts != 0) {
                    serializer.attribute(null, ATTR_FAILED_ATTEMPTS, Integer.toString(pinState.failedAttempts));
                    serializer.attribute(null, ATTR_LAST_RETRY_MS, Long.toString(pinState.lastAttemptTime));
                }
            }
            if (userInfo.iconPath != null) {
                serializer.attribute(null, ATTR_ICON_PATH, userInfo.iconPath);
            }
            if (userInfo.partial) {
                serializer.attribute(null, ATTR_PARTIAL, "true");
            }
            if (userInfo.guestToRemove) {
                serializer.attribute(null, ATTR_GUEST_TO_REMOVE, "true");
            }
            if (userInfo.profileGroupId != -1) {
                serializer.attribute(null, ATTR_PROFILE_GROUP_ID, Integer.toString(userInfo.profileGroupId));
            }
            serializer.startTag(null, TAG_NAME);
            serializer.text(userInfo.name);
            serializer.endTag(null, TAG_NAME);
            Bundle restrictions = this.mUserRestrictions.get(userInfo.id);
            if (restrictions != null) {
                this.writeRestrictionsLocked(serializer, restrictions);
            }
            serializer.endTag(null, TAG_USER);
            serializer.endDocument();
            userFile.finishWrite(fos);
        }
        catch (Exception ioe) {
            Slog.e(LOG_TAG, "Error writing user info " + userInfo.id + "\n" + ioe);
            userFile.failWrite(fos);
        }
    }

    private void writeUserListLocked() {
        FileOutputStream fos = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            fos = userListFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USERS);
            serializer.attribute(null, ATTR_NEXT_SERIAL_NO, Integer.toString(this.mNextSerialNumber));
            serializer.attribute(null, ATTR_USER_VERSION, Integer.toString(this.mUserVersion));
            serializer.startTag(null, TAG_GUEST_RESTRICTIONS);
            this.writeRestrictionsLocked(serializer, this.mGuestRestrictions);
            serializer.endTag(null, TAG_GUEST_RESTRICTIONS);
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo user = this.mUsers.valueAt(i);
                serializer.startTag(null, TAG_USER);
                serializer.attribute(null, ATTR_ID, Integer.toString(user.id));
                serializer.endTag(null, TAG_USER);
            }
            serializer.endTag(null, TAG_USERS);
            serializer.endDocument();
            userListFile.finishWrite(fos);
        }
        catch (Exception e) {
            userListFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing user list");
        }
    }

    private void writeRestrictionsLocked(XmlSerializer serializer, Bundle restrictions) throws IOException {
        serializer.startTag(null, TAG_RESTRICTIONS);
        this.writeBoolean(serializer, restrictions, "no_config_wifi");
        this.writeBoolean(serializer, restrictions, "no_modify_accounts");
        this.writeBoolean(serializer, restrictions, "no_install_apps");
        this.writeBoolean(serializer, restrictions, "no_uninstall_apps");
        this.writeBoolean(serializer, restrictions, "no_share_location");
        this.writeBoolean(serializer, restrictions, "no_install_unknown_sources");
        this.writeBoolean(serializer, restrictions, "no_config_bluetooth");
        this.writeBoolean(serializer, restrictions, "no_usb_file_transfer");
        this.writeBoolean(serializer, restrictions, "no_config_credentials");
        this.writeBoolean(serializer, restrictions, "no_remove_user");
        this.writeBoolean(serializer, restrictions, "no_debugging_features");
        this.writeBoolean(serializer, restrictions, "no_config_vpn");
        this.writeBoolean(serializer, restrictions, "no_config_tethering");
        this.writeBoolean(serializer, restrictions, "no_factory_reset");
        this.writeBoolean(serializer, restrictions, "no_add_user");
        this.writeBoolean(serializer, restrictions, "ensure_verify_apps");
        this.writeBoolean(serializer, restrictions, "no_config_cell_broadcasts");
        this.writeBoolean(serializer, restrictions, "no_config_mobile_networks");
        this.writeBoolean(serializer, restrictions, "no_control_apps");
        this.writeBoolean(serializer, restrictions, "no_physical_media");
        this.writeBoolean(serializer, restrictions, "no_unmute_microphone");
        this.writeBoolean(serializer, restrictions, "no_adjust_volume");
        this.writeBoolean(serializer, restrictions, "no_outgoing_calls");
        this.writeBoolean(serializer, restrictions, "no_sms");
        this.writeBoolean(serializer, restrictions, "no_create_windows");
        this.writeBoolean(serializer, restrictions, "no_cross_profile_copy_paste");
        this.writeBoolean(serializer, restrictions, "no_outgoing_beam");
        serializer.endTag(null, TAG_RESTRICTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserInfo readUserLocked(int id2) {
        int flags = 0;
        int serialNumber = id2;
        String name = null;
        String iconPath = null;
        long creationTime = 0L;
        long lastLoggedInTime = 0L;
        long salt = 0L;
        String pinHash = null;
        int failedAttempts = 0;
        int profileGroupId = -1;
        long lastAttemptTime = 0L;
        boolean partial = false;
        boolean guestToRemove = false;
        Bundle restrictions = new Bundle();
        FileInputStream fis = null;
        try {
            int type;
            AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, Integer.toString(id2) + XML_SUFFIX));
            fis = userFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user " + id2);
                UserInfo userInfo = null;
                return userInfo;
            }
            if (type == 2 && parser.getName().equals(TAG_USER)) {
                String valueString;
                int storedId = this.readIntAttribute(parser, ATTR_ID, -1);
                if (storedId != id2) {
                    Slog.e(LOG_TAG, "User id does not match the file name");
                    UserInfo userInfo = null;
                    return userInfo;
                }
                serialNumber = this.readIntAttribute(parser, ATTR_SERIAL_NO, id2);
                flags = this.readIntAttribute(parser, ATTR_FLAGS, 0);
                iconPath = parser.getAttributeValue(null, ATTR_ICON_PATH);
                creationTime = this.readLongAttribute(parser, ATTR_CREATION_TIME, 0L);
                lastLoggedInTime = this.readLongAttribute(parser, ATTR_LAST_LOGGED_IN_TIME, 0L);
                salt = this.readLongAttribute(parser, ATTR_SALT, 0L);
                pinHash = parser.getAttributeValue(null, ATTR_PIN_HASH);
                failedAttempts = this.readIntAttribute(parser, ATTR_FAILED_ATTEMPTS, 0);
                lastAttemptTime = this.readLongAttribute(parser, ATTR_LAST_RETRY_MS, 0L);
                profileGroupId = this.readIntAttribute(parser, ATTR_PROFILE_GROUP_ID, -1);
                if (profileGroupId == -1) {
                    profileGroupId = this.readIntAttribute(parser, "relatedGroupId", -1);
                }
                if ("true".equals(valueString = parser.getAttributeValue(null, ATTR_PARTIAL))) {
                    partial = true;
                }
                if ("true".equals(valueString = parser.getAttributeValue(null, ATTR_GUEST_TO_REMOVE))) {
                    guestToRemove = true;
                }
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String tag = parser.getName();
                    if (TAG_NAME.equals(tag)) {
                        type = parser.next();
                        if (type != 4) continue;
                        name = parser.getText();
                        continue;
                    }
                    if (!TAG_RESTRICTIONS.equals(tag)) continue;
                    this.readRestrictionsLocked(parser, restrictions);
                }
            }
            UserInfo userInfo = new UserInfo(id2, name, iconPath, flags);
            userInfo.serialNumber = serialNumber;
            userInfo.creationTime = creationTime;
            userInfo.lastLoggedInTime = lastLoggedInTime;
            userInfo.partial = partial;
            userInfo.guestToRemove = guestToRemove;
            userInfo.profileGroupId = profileGroupId;
            this.mUserRestrictions.append(id2, restrictions);
            if (salt != 0L) {
                RestrictionsPinState pinState = this.mRestrictionsPinStates.get(id2);
                if (pinState == null) {
                    pinState = new RestrictionsPinState();
                    this.mRestrictionsPinStates.put(id2, pinState);
                }
                pinState.salt = salt;
                pinState.pinHash = pinHash;
                pinState.failedAttempts = failedAttempts;
                pinState.lastAttemptTime = lastAttemptTime;
            }
            UserInfo userInfo2 = userInfo;
            return userInfo2;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (XmlPullParserException xmlPullParserException) {
            return null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readRestrictionsLocked(XmlPullParser parser, Bundle restrictions) throws IOException {
        this.readBoolean(parser, restrictions, "no_config_wifi");
        this.readBoolean(parser, restrictions, "no_modify_accounts");
        this.readBoolean(parser, restrictions, "no_install_apps");
        this.readBoolean(parser, restrictions, "no_uninstall_apps");
        this.readBoolean(parser, restrictions, "no_share_location");
        this.readBoolean(parser, restrictions, "no_install_unknown_sources");
        this.readBoolean(parser, restrictions, "no_config_bluetooth");
        this.readBoolean(parser, restrictions, "no_usb_file_transfer");
        this.readBoolean(parser, restrictions, "no_config_credentials");
        this.readBoolean(parser, restrictions, "no_remove_user");
        this.readBoolean(parser, restrictions, "no_debugging_features");
        this.readBoolean(parser, restrictions, "no_config_vpn");
        this.readBoolean(parser, restrictions, "no_config_tethering");
        this.readBoolean(parser, restrictions, "no_factory_reset");
        this.readBoolean(parser, restrictions, "no_add_user");
        this.readBoolean(parser, restrictions, "ensure_verify_apps");
        this.readBoolean(parser, restrictions, "no_config_cell_broadcasts");
        this.readBoolean(parser, restrictions, "no_config_mobile_networks");
        this.readBoolean(parser, restrictions, "no_control_apps");
        this.readBoolean(parser, restrictions, "no_physical_media");
        this.readBoolean(parser, restrictions, "no_unmute_microphone");
        this.readBoolean(parser, restrictions, "no_adjust_volume");
        this.readBoolean(parser, restrictions, "no_outgoing_calls");
        this.readBoolean(parser, restrictions, "no_sms");
        this.readBoolean(parser, restrictions, "no_create_windows");
        this.readBoolean(parser, restrictions, "no_cross_profile_copy_paste");
        this.readBoolean(parser, restrictions, "no_outgoing_beam");
    }

    private void readBoolean(XmlPullParser parser, Bundle restrictions, String restrictionKey) {
        String value = parser.getAttributeValue(null, restrictionKey);
        if (value != null) {
            restrictions.putBoolean(restrictionKey, Boolean.parseBoolean(value));
        }
    }

    private void writeBoolean(XmlSerializer xml2, Bundle restrictions, String restrictionKey) throws IOException {
        if (restrictions.containsKey(restrictionKey)) {
            xml2.attribute(null, restrictionKey, Boolean.toString(restrictions.getBoolean(restrictionKey)));
        }
    }

    private int readIntAttribute(XmlPullParser parser, String attr2, int defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private long readLongAttribute(XmlPullParser parser, String attr2, long defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private boolean isPackageInstalled(String pkg, int userId) {
        ApplicationInfo info = this.mPm.getApplicationInfo(pkg, 8192, userId);
        return info != null && (info.flags & 0x800000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAppRestrictions(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            File dir = Environment.getUserSystemDirectory(userId);
            String[] files = dir.list();
            if (files == null) {
                return;
            }
            for (String fileName : files) {
                File resFile;
                if (!fileName.startsWith(RESTRICTIONS_FILE_PREFIX) || !(resFile = new File(dir, fileName)).exists()) continue;
                resFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAppRestrictionsForPackage(String pkg, int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            File dir = Environment.getUserSystemDirectory(userId);
            File resFile = new File(dir, this.packageToRestrictionsFileName(pkg));
            if (resFile.exists()) {
                resFile.delete();
            }
        }
    }

    @Override
    public UserInfo createProfileForUser(String name, int flags, int userId) {
        UserManagerService.checkManageUsersPermission("Only the system can create users");
        if (userId != 0) {
            Slog.w(LOG_TAG, "Only user owner can have profiles");
            return null;
        }
        return this.createUserInternal(name, flags, userId);
    }

    @Override
    public UserInfo createUser(String name, int flags) {
        UserManagerService.checkManageUsersPermission("Only the system can create users");
        return this.createUserInternal(name, flags, -10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private UserInfo createUserInternal(String name, int flags, int parentId) {
        UserInfo parent;
        UserInfo userInfo;
        long ident;
        boolean isGuest;
        block19: {
            if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_add_user", false)) {
                Log.w(LOG_TAG, "Cannot add user. DISALLOW_ADD_USER is enabled.");
                return null;
            }
            isGuest = (flags & 4) != 0;
            ident = Binder.clearCallingIdentity();
            userInfo = null;
            Object object = this.mInstallLock;
            // MONITORENTER : object
            Object object2 = this.mPackagesLock;
            // MONITORENTER : object2
            parent = null;
            if (parentId == -10000 || (parent = this.getUserInfoLocked(parentId)) != null) break block19;
            UserInfo userInfo2 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo2;
        }
        if (!isGuest && this.isUserLimitReachedLocked()) {
            UserInfo userInfo3 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo3;
        }
        if (isGuest && this.findCurrentGuestUserLocked() != null) {
            UserInfo userInfo4 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo4;
        }
        if ((flags & 0x20) != 0 && this.numberOfUsersOfTypeLocked(32, true) >= 1) {
            UserInfo userInfo5 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo5;
        }
        try {
            int userId = this.getNextAvailableIdLocked();
            userInfo = new UserInfo(userId, name, null, flags);
            File userPath = new File(this.mBaseUserPath, Integer.toString(userId));
            userInfo.serialNumber = this.mNextSerialNumber++;
            long now = System.currentTimeMillis();
            userInfo.creationTime = now > 946080000000L ? now : 0L;
            userInfo.partial = true;
            Environment.getUserSystemDirectory(userInfo.id).mkdirs();
            this.mUsers.put(userId, userInfo);
            this.writeUserListLocked();
            if (parent != null) {
                if (parent.profileGroupId == -1) {
                    parent.profileGroupId = parent.id;
                    this.writeUserLocked(parent);
                }
                userInfo.profileGroupId = parent.profileGroupId;
            }
            this.writeUserLocked(userInfo);
            this.mPm.createNewUserLILPw(userId, userPath);
            userInfo.partial = false;
            this.writeUserLocked(userInfo);
            this.updateUserIdsLocked();
            Bundle restrictions = new Bundle();
            this.mUserRestrictions.append(userId, restrictions);
            // MONITOREXIT : object2
            // MONITOREXIT : object
            if (userInfo == null) return userInfo;
            Intent addedIntent = new Intent("android.intent.action.USER_ADDED");
            addedIntent.putExtra("android.intent.extra.user_handle", userInfo.id);
            this.mContext.sendBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS");
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private int numberOfUsersOfTypeLocked(int flags, boolean excludeDying) {
        int count = 0;
        for (int i = this.mUsers.size() - 1; i >= 0; --i) {
            UserInfo user = this.mUsers.valueAt(i);
            if (excludeDying && this.mRemovingUserIds.get(user.id) || (user.flags & flags) == 0) continue;
            ++count;
        }
        return count;
    }

    private UserInfo findCurrentGuestUserLocked() {
        int size = this.mUsers.size();
        for (int i = 0; i < size; ++i) {
            UserInfo user = this.mUsers.valueAt(i);
            if (!user.isGuest() || user.guestToRemove || this.mRemovingUserIds.get(user.id)) continue;
            return user;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean markGuestForDeletion(int userHandle) {
        UserInfo user;
        long ident;
        block10: {
            UserManagerService.checkManageUsersPermission("Only the system can remove users");
            if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_remove_user", false)) {
                Log.w(LOG_TAG, "Cannot remove user. DISALLOW_REMOVE_USER is enabled.");
                return false;
            }
            ident = Binder.clearCallingIdentity();
            Object object = this.mPackagesLock;
            // MONITORENTER : object
            user = this.mUsers.get(userHandle);
            if (userHandle != 0 && user != null && !this.mRemovingUserIds.get(userHandle)) break block10;
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (!user.isGuest()) {
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            user.guestToRemove = true;
            user.flags |= 0x40;
            this.writeUserLocked(user);
            // MONITOREXIT : object
            return true;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(int userHandle) {
        UserManagerService.checkManageUsersPermission("Only the system can remove users");
        if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_remove_user", false)) {
            Log.w(LOG_TAG, "Cannot remove user. DISALLOW_REMOVE_USER is enabled.");
            return false;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            int res;
            UserInfo user;
            Object object = this.mPackagesLock;
            synchronized (object) {
                block15: {
                    user = this.mUsers.get(userHandle);
                    if (userHandle != 0 && user != null && !this.mRemovingUserIds.get(userHandle)) break block15;
                    boolean bl = false;
                    return bl;
                }
                this.mRemovingUserIds.put(userHandle, true);
                try {
                    this.mAppOpsService.removeUser(userHandle);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "Unable to notify AppOpsService of removing user", e);
                }
                user.partial = true;
                user.flags |= 0x40;
                this.writeUserLocked(user);
            }
            if (user.profileGroupId != -1 && user.isManagedProfile()) {
                this.sendProfileRemovedBroadcast(user.profileGroupId, user.id);
            }
            try {
                res = ActivityManagerNative.getDefault().stopUser(userHandle, new IStopUserCallback.Stub(){

                    @Override
                    public void userStopped(int userId) {
                        UserManagerService.this.finishRemoveUser(userId);
                    }

                    @Override
                    public void userStopAborted(int userId) {
                    }
                });
            }
            catch (RemoteException e) {
                boolean bl = false;
                Binder.restoreCallingIdentity(ident);
                return bl;
            }
            boolean bl = res == 0;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishRemoveUser(final int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent addedIntent = new Intent("android.intent.action.USER_REMOVED");
            addedIntent.putExtra("android.intent.extra.user_handle", userHandle);
            this.mContext.sendOrderedBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS", new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = UserManagerService.this.mInstallLock;
                            synchronized (object) {
                                Object object2 = UserManagerService.this.mPackagesLock;
                                synchronized (object2) {
                                    UserManagerService.this.removeUserStateLocked(userHandle);
                                }
                            }
                        }
                    }.start();
                }
            }, null, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void removeUserStateLocked(final int userHandle) {
        this.mPm.cleanUpUserLILPw(this, userHandle);
        this.mUsers.remove(userHandle);
        this.mHandler.postDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = UserManagerService.this.mPackagesLock;
                synchronized (object) {
                    UserManagerService.this.mRemovingUserIds.delete(userHandle);
                }
            }
        }, 60000L);
        this.mRestrictionsPinStates.remove(userHandle);
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userHandle + XML_SUFFIX));
        userFile.delete();
        this.writeUserListLocked();
        this.updateUserIdsLocked();
        this.removeDirectoryRecursive(Environment.getUserSystemDirectory(userHandle));
    }

    private void removeDirectoryRecursive(File parent) {
        if (parent.isDirectory()) {
            String[] files;
            for (String filename : files = parent.list()) {
                File child = new File(parent, filename);
                this.removeDirectoryRecursive(child);
            }
        }
        parent.delete();
    }

    private void sendProfileRemovedBroadcast(int parentUserId, int removedUserId) {
        Intent managedProfileIntent = new Intent("android.intent.action.MANAGED_PROFILE_REMOVED");
        managedProfileIntent.addFlags(0x50000000);
        managedProfileIntent.putExtra("android.intent.extra.USER", new UserHandle(removedUserId));
        this.mContext.sendBroadcastAsUser(managedProfileIntent, new UserHandle(parentUserId), null);
    }

    @Override
    public Bundle getApplicationRestrictions(String packageName) {
        return this.getApplicationRestrictionsForUser(packageName, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getApplicationRestrictionsForUser(String packageName, int userId) {
        if (UserHandle.getCallingUserId() != userId || !UserHandle.isSameApp(Binder.getCallingUid(), this.getUidForPackage(packageName))) {
            UserManagerService.checkManageUsersPermission("Only system can get restrictions for other users/apps");
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.readApplicationRestrictionsLocked(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationRestrictions(String packageName, Bundle restrictions, int userId) {
        if (UserHandle.getCallingUserId() != userId || !UserHandle.isSameApp(Binder.getCallingUid(), this.getUidForPackage(packageName))) {
            UserManagerService.checkManageUsersPermission("Only system can set restrictions for other users/apps");
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (restrictions == null || restrictions.isEmpty()) {
                this.cleanAppRestrictionsForPackage(packageName, userId);
            } else {
                this.writeApplicationRestrictionsLocked(packageName, restrictions, userId);
            }
        }
        if (this.isPackageInstalled(packageName, userId)) {
            Intent changeIntent = new Intent("android.intent.action.APPLICATION_RESTRICTIONS_CHANGED");
            changeIntent.setPackage(packageName);
            changeIntent.addFlags(0x40000000);
            this.mContext.sendBroadcastAsUser(changeIntent, new UserHandle(userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setRestrictionsChallenge(String newPin) {
        UserManagerService.checkManageUsersPermission("Only system can modify the restrictions pin");
        int userId = UserHandle.getCallingUserId();
        Object object = this.mPackagesLock;
        synchronized (object) {
            RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userId);
            if (pinState == null) {
                pinState = new RestrictionsPinState();
            }
            if (newPin == null) {
                pinState.salt = 0L;
                pinState.pinHash = null;
            } else {
                try {
                    pinState.salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                }
                catch (NoSuchAlgorithmException e) {
                    pinState.salt = (long)(Math.random() * 9.223372036854776E18);
                }
                pinState.pinHash = this.passwordToHash(newPin, pinState.salt);
                pinState.failedAttempts = 0;
            }
            this.mRestrictionsPinStates.put(userId, pinState);
            this.writeUserLocked(this.mUsers.get(userId));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkRestrictionsChallenge(String pin) {
        UserManagerService.checkManageUsersPermission("Only system can verify the restrictions pin");
        int userId = UserHandle.getCallingUserId();
        Object object = this.mPackagesLock;
        synchronized (object) {
            RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userId);
            if (pinState == null || pinState.salt == 0L || pinState.pinHash == null) {
                return -2;
            }
            if (pin == null) {
                int waitTime = this.getRemainingTimeForPinAttempt(pinState);
                Slog.d(LOG_TAG, "Remaining waittime peek=" + waitTime);
                return waitTime;
            }
            int waitTime = this.getRemainingTimeForPinAttempt(pinState);
            Slog.d(LOG_TAG, "Remaining waittime=" + waitTime);
            if (waitTime > 0) {
                return waitTime;
            }
            if (this.passwordToHash(pin, pinState.salt).equals(pinState.pinHash)) {
                pinState.failedAttempts = 0;
                this.writeUserLocked(this.mUsers.get(userId));
                return -1;
            }
            ++pinState.failedAttempts;
            pinState.lastAttemptTime = System.currentTimeMillis();
            this.writeUserLocked(this.mUsers.get(userId));
            return waitTime;
        }
    }

    private int getRemainingTimeForPinAttempt(RestrictionsPinState pinState) {
        int backoffIndex = Math.min(pinState.failedAttempts / 5, BACKOFF_TIMES.length - 1);
        int backoffTime = pinState.failedAttempts % 5 == 0 ? BACKOFF_TIMES[backoffIndex] : 0;
        return (int)Math.max((long)backoffTime + pinState.lastAttemptTime - System.currentTimeMillis(), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRestrictionsChallenge() {
        int userId = UserHandle.getCallingUserId();
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.hasRestrictionsPinLocked(userId);
        }
    }

    private boolean hasRestrictionsPinLocked(int userId) {
        RestrictionsPinState pinState = this.mRestrictionsPinStates.get(userId);
        return pinState != null && pinState.salt != 0L && pinState.pinHash != null;
    }

    @Override
    public void removeRestrictions() {
        UserManagerService.checkManageUsersPermission("Only system can remove restrictions");
        int userHandle = UserHandle.getCallingUserId();
        this.removeRestrictionsForUser(userHandle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRestrictionsForUser(int userHandle, boolean unhideApps) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.setUserRestrictions(new Bundle(), userHandle);
            this.setRestrictionsChallenge(null);
            this.cleanAppRestrictions(userHandle);
        }
        if (unhideApps) {
            this.unhideAllInstalledAppsForUser(userHandle);
        }
    }

    private void unhideAllInstalledAppsForUser(final int userHandle) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<ApplicationInfo> apps = UserManagerService.this.mPm.getInstalledApplications(8192, userHandle).getList();
                long ident = Binder.clearCallingIdentity();
                try {
                    for (ApplicationInfo appInfo : apps) {
                        if ((appInfo.flags & 0x800000) == 0 || (appInfo.flags & 0x8000000) == 0) continue;
                        UserManagerService.this.mPm.setApplicationHiddenSettingAsUser(appInfo.packageName, false, userHandle);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        });
    }

    private String passwordToHash(String password, long salt) {
        if (password == null) {
            return null;
        }
        String algo = null;
        String hashed = salt + password;
        try {
            byte[] saltedPassword = (password + salt).getBytes();
            algo = "SHA-1";
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            algo = "MD5";
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            hashed = UserManagerService.toHex(sha1) + UserManagerService.toHex(md5);
        }
        catch (NoSuchAlgorithmException e) {
            Log.w(LOG_TAG, "Failed to encode string because of missing algorithm: " + algo);
        }
        return hashed;
    }

    private static String toHex(byte[] ary) {
        String hex = "0123456789ABCDEF";
        String ret = "";
        for (int i = 0; i < ary.length; ++i) {
            ret = ret + "0123456789ABCDEF".charAt(ary[i] >> 4 & 0xF);
            ret = ret + "0123456789ABCDEF".charAt(ary[i] & 0xF);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForPackage(String packageName) {
        long ident = Binder.clearCallingIdentity();
        try {
            int n = this.mContext.getPackageManager().getApplicationInfo((String)packageName, (int)8192).uid;
            return n;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            int n = -1;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle readApplicationRestrictionsLocked(String packageName, int userId) {
        Bundle restrictions = new Bundle();
        ArrayList<String> values = new ArrayList<String>();
        FileInputStream fis = null;
        try {
            int type;
            AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
            fis = restrictionsFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, null);
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read restrictions file " + restrictionsFile.getBaseFile());
                Bundle bundle = restrictions;
                return bundle;
            }
            while ((type = parser.next()) != 1) {
                if (type != 2 || !parser.getName().equals(TAG_ENTRY)) continue;
                String key = parser.getAttributeValue(null, ATTR_KEY);
                String valType = parser.getAttributeValue(null, ATTR_VALUE_TYPE);
                String multiple = parser.getAttributeValue(null, ATTR_MULTIPLE);
                if (multiple != null) {
                    values.clear();
                    int count = Integer.parseInt(multiple);
                    while (count > 0 && (type = parser.next()) != 1) {
                        if (type != 2 || !parser.getName().equals(TAG_VALUE)) continue;
                        values.add(parser.nextText().trim());
                        --count;
                    }
                    String[] valueStrings = new String[values.size()];
                    values.toArray(valueStrings);
                    restrictions.putStringArray(key, valueStrings);
                    continue;
                }
                String value = parser.nextText().trim();
                if (ATTR_TYPE_BOOLEAN.equals(valType)) {
                    restrictions.putBoolean(key, Boolean.parseBoolean(value));
                    continue;
                }
                if (ATTR_TYPE_INTEGER.equals(valType)) {
                    restrictions.putInt(key, Integer.parseInt(value));
                    continue;
                }
                restrictions.putString(key, value);
            }
        }
        catch (IOException iOException) {
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return restrictions;
    }

    private void writeApplicationRestrictionsLocked(String packageName, Bundle restrictions, int userId) {
        FileOutputStream fos = null;
        AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
        try {
            fos = restrictionsFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, "utf-8");
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_RESTRICTIONS);
            for (String key : restrictions.keySet()) {
                Object value = restrictions.get(key);
                serializer.startTag(null, TAG_ENTRY);
                serializer.attribute(null, ATTR_KEY, key);
                if (value instanceof Boolean) {
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BOOLEAN);
                    serializer.text(value.toString());
                } else if (value instanceof Integer) {
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_INTEGER);
                    serializer.text(value.toString());
                } else if (value == null || value instanceof String) {
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING);
                    serializer.text(value != null ? (String)value : "");
                } else {
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING_ARRAY);
                    String[] values = (String[])value;
                    serializer.attribute(null, ATTR_MULTIPLE, Integer.toString(values.length));
                    for (String choice : values) {
                        serializer.startTag(null, TAG_VALUE);
                        serializer.text(choice != null ? choice : "");
                        serializer.endTag(null, TAG_VALUE);
                    }
                }
                serializer.endTag(null, TAG_ENTRY);
            }
            serializer.endTag(null, TAG_RESTRICTIONS);
            serializer.endDocument();
            restrictionsFile.finishWrite(fos);
        }
        catch (Exception e) {
            restrictionsFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing application restrictions list");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserSerialNumber(int userHandle) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (!this.exists(userHandle)) {
                return -1;
            }
            return this.getUserInfoLocked((int)userHandle).serialNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserHandle(int userSerialNumber) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            for (int userId : this.mUserIds) {
                if (this.getUserInfoLocked((int)userId).serialNumber != userSerialNumber) continue;
                return userId;
            }
            return -1;
        }
    }

    private void updateUserIdsLocked() {
        int num = 0;
        for (int i = 0; i < this.mUsers.size(); ++i) {
            if (this.mUsers.valueAt((int)i).partial) continue;
            ++num;
        }
        int[] newUsers = new int[num];
        int n = 0;
        for (int i = 0; i < this.mUsers.size(); ++i) {
            if (this.mUsers.valueAt((int)i).partial) continue;
            newUsers[n++] = this.mUsers.keyAt(i);
        }
        this.mUserIds = newUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userForeground(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo user = this.mUsers.get(userId);
            long now = System.currentTimeMillis();
            if (user == null || user.partial) {
                Slog.w(LOG_TAG, "userForeground: unknown user #" + userId);
                return;
            }
            if (now > 946080000000L) {
                user.lastLoggedInTime = now;
                this.writeUserLocked(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextAvailableIdLocked() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            int i;
            for (i = 10; i < Integer.MAX_VALUE && (this.mUsers.indexOfKey(i) >= 0 || this.mRemovingUserIds.get(i)); ++i) {
            }
            return i;
        }
    }

    private String packageToRestrictionsFileName(String packageName) {
        return RESTRICTIONS_FILE_PREFIX + packageName + XML_SUFFIX;
    }

    private String restrictionsFileNameToPackage(String fileName) {
        return fileName.substring(RESTRICTIONS_FILE_PREFIX.length(), fileName.length() - XML_SUFFIX.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UserManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Object object = this.mPackagesLock;
        synchronized (object) {
            pw.println("Users:");
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo user = this.mUsers.valueAt(i);
                if (user == null) continue;
                pw.print("  ");
                pw.print(user);
                pw.print(" serialNo=");
                pw.print(user.serialNumber);
                if (this.mRemovingUserIds.get(this.mUsers.keyAt(i))) {
                    pw.print(" <removing> ");
                }
                if (user.partial) {
                    pw.print(" <partial>");
                }
                pw.println();
                pw.print("    Created: ");
                if (user.creationTime == 0L) {
                    pw.println("<unknown>");
                } else {
                    sb.setLength(0);
                    TimeUtils.formatDuration(now - user.creationTime, sb);
                    sb.append(" ago");
                    pw.println(sb);
                }
                pw.print("    Last logged in: ");
                if (user.lastLoggedInTime == 0L) {
                    pw.println("<unknown>");
                    continue;
                }
                sb.setLength(0);
                TimeUtils.formatDuration(now - user.lastLoggedInTime, sb);
                sb.append(" ago");
                pw.println(sb);
            }
        }
    }

    class RestrictionsPinState {
        long salt;
        String pinHash;
        int failedAttempts;
        long lastAttemptTime;

        RestrictionsPinState() {
        }
    }
}

