/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.power;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.hardware.SystemSensorManager;
import android.hardware.display.DisplayManagerInternal;
import android.net.Uri;
import android.os.BatteryManagerInternal;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.WorkSource;
import android.provider.Settings;
import android.service.dreams.DreamManagerInternal;
import android.util.EventLog;
import android.util.Slog;
import android.util.TimeUtils;
import android.view.Display;
import android.view.WindowManagerPolicy;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BackgroundThread;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.Watchdog;
import com.android.server.am.BatteryStatsService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import com.android.server.power.Notifier;
import com.android.server.power.ShutdownThread;
import com.android.server.power.SuspendBlocker;
import com.android.server.power.WirelessChargerDetector;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import libcore.util.Objects;

public final class PowerManagerService
extends SystemService
implements Watchdog.Monitor {
    private static final String TAG = "PowerManagerService";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_SPEW = false;
    private static final int MSG_USER_ACTIVITY_TIMEOUT = 1;
    private static final int MSG_SANDMAN = 2;
    private static final int DIRTY_WAKE_LOCKS = 1;
    private static final int DIRTY_WAKEFULNESS = 2;
    private static final int DIRTY_USER_ACTIVITY = 4;
    private static final int DIRTY_ACTUAL_DISPLAY_POWER_STATE_UPDATED = 8;
    private static final int DIRTY_BOOT_COMPLETED = 16;
    private static final int DIRTY_SETTINGS = 32;
    private static final int DIRTY_IS_POWERED = 64;
    private static final int DIRTY_STAY_ON = 128;
    private static final int DIRTY_BATTERY_STATE = 256;
    private static final int DIRTY_PROXIMITY_POSITIVE = 512;
    private static final int DIRTY_DOCK_STATE = 1024;
    private static final int WAKEFULNESS_ASLEEP = 0;
    private static final int WAKEFULNESS_AWAKE = 1;
    private static final int WAKEFULNESS_DREAMING = 2;
    private static final int WAKEFULNESS_DOZING = 3;
    private static final int WAKE_LOCK_CPU = 1;
    private static final int WAKE_LOCK_SCREEN_BRIGHT = 2;
    private static final int WAKE_LOCK_SCREEN_DIM = 4;
    private static final int WAKE_LOCK_BUTTON_BRIGHT = 8;
    private static final int WAKE_LOCK_PROXIMITY_SCREEN_OFF = 16;
    private static final int WAKE_LOCK_STAY_AWAKE = 32;
    private static final int WAKE_LOCK_DOZE = 64;
    private static final int USER_ACTIVITY_SCREEN_BRIGHT = 1;
    private static final int USER_ACTIVITY_SCREEN_DIM = 2;
    private static final int USER_ACTIVITY_SCREEN_DREAM = 4;
    private static final int DEFAULT_SCREEN_OFF_TIMEOUT = 15000;
    private static final int DEFAULT_SLEEP_TIMEOUT = -1;
    private static final int POWER_HINT_INTERACTION = 2;
    private static final int POWER_HINT_LOW_POWER = 5;
    private final Context mContext;
    private final ServiceThread mHandlerThread;
    private final PowerManagerHandler mHandler;
    private LightsManager mLightsManager;
    private BatteryManagerInternal mBatteryManagerInternal;
    private DisplayManagerInternal mDisplayManagerInternal;
    private IBatteryStats mBatteryStats;
    private IAppOpsService mAppOps;
    private WindowManagerPolicy mPolicy;
    private Notifier mNotifier;
    private WirelessChargerDetector mWirelessChargerDetector;
    private SettingsObserver mSettingsObserver;
    private DreamManagerInternal mDreamManager;
    private Light mAttentionLight;
    private final Object mLock = new Object();
    private int mDirty;
    private int mWakefulness;
    private boolean mSandmanSummoned;
    private boolean mSandmanScheduled;
    private final ArrayList<SuspendBlocker> mSuspendBlockers = new ArrayList();
    private final ArrayList<WakeLock> mWakeLocks = new ArrayList();
    private int mWakeLockSummary;
    private boolean mInteractive;
    private boolean mInteractiveChanging;
    private boolean mRequestWaitForNegativeProximity;
    private long mLastWakeTime;
    private long mLastSleepTime;
    private long mLastUserActivityTime;
    private long mLastUserActivityTimeNoChangeLights;
    private long mLastInteractivePowerHintTime;
    private int mUserActivitySummary;
    private final DisplayManagerInternal.DisplayPowerRequest mDisplayPowerRequest = new DisplayManagerInternal.DisplayPowerRequest();
    private boolean mDisplayReady;
    private final SuspendBlocker mWakeLockSuspendBlocker;
    private boolean mHoldingWakeLockSuspendBlocker;
    private final SuspendBlocker mDisplaySuspendBlocker;
    private boolean mHoldingDisplaySuspendBlocker;
    private boolean mSystemReady;
    private boolean mBootCompleted;
    private boolean mHalAutoSuspendModeEnabled;
    private boolean mHalInteractiveModeEnabled;
    private boolean mIsPowered;
    private int mPlugType;
    private int mBatteryLevel;
    private int mBatteryLevelWhenDreamStarted;
    private int mDockState = 0;
    private boolean mDecoupleHalAutoSuspendModeFromDisplayConfig;
    private boolean mDecoupleHalInteractiveModeFromDisplayConfig;
    private boolean mWakeUpWhenPluggedOrUnpluggedConfig;
    private boolean mSuspendWhenScreenOffDueToProximityConfig;
    private boolean mDreamsSupportedConfig;
    private boolean mDreamsEnabledByDefaultConfig;
    private boolean mDreamsActivatedOnSleepByDefaultConfig;
    private boolean mDreamsActivatedOnDockByDefaultConfig;
    private boolean mDreamsEnabledOnBatteryConfig;
    private int mDreamsBatteryLevelMinimumWhenPoweredConfig;
    private int mDreamsBatteryLevelMinimumWhenNotPoweredConfig;
    private int mDreamsBatteryLevelDrainCutoffConfig;
    private boolean mDreamsEnabledSetting;
    private boolean mDreamsActivateOnSleepSetting;
    private boolean mDreamsActivateOnDockSetting;
    private boolean mDozeAfterScreenOffConfig;
    private int mMinimumScreenOffTimeoutConfig;
    private int mMaximumScreenDimDurationConfig;
    private float mMaximumScreenDimRatioConfig;
    private int mScreenOffTimeoutSetting;
    private int mSleepTimeoutSetting;
    private int mMaximumScreenOffTimeoutFromDeviceAdmin = Integer.MAX_VALUE;
    private int mStayOnWhilePluggedInSetting;
    private boolean mStayOn;
    private boolean mProximityPositive;
    private int mScreenBrightnessSettingMinimum;
    private int mScreenBrightnessSettingMaximum;
    private int mScreenBrightnessSettingDefault;
    private int mScreenBrightnessSetting;
    private float mScreenAutoBrightnessAdjustmentSetting;
    private int mScreenBrightnessModeSetting;
    private int mScreenBrightnessOverrideFromWindowManager = -1;
    private long mUserActivityTimeoutOverrideFromWindowManager = -1L;
    private int mTemporaryScreenBrightnessSettingOverride = -1;
    private float mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = Float.NaN;
    private int mDozeScreenStateOverrideFromDreamManager = 0;
    private int mDozeScreenBrightnessOverrideFromDreamManager = -1;
    private long mLastWarningAboutUserActivityPermission = Long.MIN_VALUE;
    private boolean mLowPowerModeEnabled;
    private boolean mLowPowerModeSetting;
    private boolean mAutoLowPowerModeConfigured;
    private boolean mAutoLowPowerModeSnoozing;
    private boolean mBatteryLevelLow;
    private final ArrayList<PowerManagerInternal.LowPowerModeListener> mLowPowerModeListeners = new ArrayList();
    private final DisplayManagerInternal.DisplayPowerCallbacks mDisplayPowerCallbacks = new DisplayManagerInternal.DisplayPowerCallbacks(){
        private int mDisplayState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStateChanged() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mDirty |= 8;
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProximityPositive() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mProximityPositive = true;
                PowerManagerService.this.mDirty |= 512;
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onProximityNegative() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mProximityPositive = false;
                PowerManagerService.this.mDirty |= 512;
                PowerManagerService.this.userActivityNoUpdateLocked(SystemClock.uptimeMillis(), 0, 0, 1000);
                PowerManagerService.this.updatePowerStateLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayStateChange(int state) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                if (this.mDisplayState != state) {
                    this.mDisplayState = state;
                    if (state == 1) {
                        if (!PowerManagerService.this.mDecoupleHalInteractiveModeFromDisplayConfig) {
                            PowerManagerService.this.setHalInteractiveModeLocked(false);
                        }
                        if (!PowerManagerService.this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
                            PowerManagerService.this.setHalAutoSuspendModeLocked(true);
                        }
                    } else {
                        if (!PowerManagerService.this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
                            PowerManagerService.this.setHalAutoSuspendModeLocked(false);
                        }
                        if (!PowerManagerService.this.mDecoupleHalInteractiveModeFromDisplayConfig) {
                            PowerManagerService.this.setHalInteractiveModeLocked(true);
                        }
                    }
                }
            }
        }

        @Override
        public void acquireSuspendBlocker() {
            PowerManagerService.this.mDisplaySuspendBlocker.acquire();
        }

        @Override
        public void releaseSuspendBlocker() {
            PowerManagerService.this.mDisplaySuspendBlocker.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            2 var1_1 = this;
            synchronized (var1_1) {
                return "state=" + Display.stateToString(this.mDisplayState);
            }
        }
    };

    private native void nativeInit();

    private static native void nativeAcquireSuspendBlocker(String var0);

    private static native void nativeReleaseSuspendBlocker(String var0);

    private static native void nativeSetInteractive(boolean var0);

    private static native void nativeSetAutoSuspend(boolean var0);

    private static native void nativeSendPowerHint(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mHandlerThread = new ServiceThread(TAG, -4, false);
        this.mHandlerThread.start();
        this.mHandler = new PowerManagerHandler(this.mHandlerThread.getLooper());
        Object object = this.mLock;
        synchronized (object) {
            this.mWakeLockSuspendBlocker = this.createSuspendBlockerLocked("PowerManagerService.WakeLocks");
            this.mDisplaySuspendBlocker = this.createSuspendBlockerLocked("PowerManagerService.Display");
            this.mDisplaySuspendBlocker.acquire();
            this.mHoldingDisplaySuspendBlocker = true;
            this.mHalAutoSuspendModeEnabled = false;
            this.mHalInteractiveModeEnabled = true;
            this.mWakefulness = 1;
            this.mInteractive = true;
            this.nativeInit();
            PowerManagerService.nativeSetAutoSuspend(false);
            PowerManagerService.nativeSetInteractive(true);
        }
    }

    @Override
    public void onStart() {
        this.publishBinderService("power", new BinderService());
        this.publishLocalService(PowerManagerInternal.class, new LocalService());
        Watchdog.getInstance().addMonitor(this);
        Watchdog.getInstance().addThread(this.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        Object object = this.mLock;
        synchronized (object) {
            if (phase == 1000) {
                long now = SystemClock.uptimeMillis();
                this.mBootCompleted = true;
                this.mDirty |= 0x10;
                this.userActivityNoUpdateLocked(now, 0, 0, 1000);
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(IAppOpsService appOps) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemReady = true;
            this.mAppOps = appOps;
            this.mDreamManager = this.getLocalService(DreamManagerInternal.class);
            this.mDisplayManagerInternal = this.getLocalService(DisplayManagerInternal.class);
            this.mPolicy = this.getLocalService(WindowManagerPolicy.class);
            this.mBatteryManagerInternal = this.getLocalService(BatteryManagerInternal.class);
            PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
            this.mScreenBrightnessSettingMinimum = pm.getMinimumScreenBrightnessSetting();
            this.mScreenBrightnessSettingMaximum = pm.getMaximumScreenBrightnessSetting();
            this.mScreenBrightnessSettingDefault = pm.getDefaultScreenBrightnessSetting();
            SystemSensorManager sensorManager = new SystemSensorManager(this.mContext, this.mHandler.getLooper());
            this.mBatteryStats = BatteryStatsService.getService();
            this.mNotifier = new Notifier(Looper.getMainLooper(), this.mContext, this.mBatteryStats, this.mAppOps, this.createSuspendBlockerLocked("PowerManagerService.Broadcasts"), this.mPolicy);
            this.mWirelessChargerDetector = new WirelessChargerDetector(sensorManager, this.createSuspendBlockerLocked("PowerManagerService.WirelessChargerDetector"), this.mHandler);
            this.mSettingsObserver = new SettingsObserver(this.mHandler);
            this.mLightsManager = this.getLocalService(LightsManager.class);
            this.mAttentionLight = this.mLightsManager.getLight(5);
            this.mDisplayManagerInternal.initPowerManagement(this.mDisplayPowerCallbacks, this.mHandler, sensorManager);
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.BATTERY_CHANGED");
            filter.setPriority(1000);
            this.mContext.registerReceiver(new BatteryReceiver(), filter, null, this.mHandler);
            filter = new IntentFilter();
            filter.addAction("android.intent.action.DREAMING_STARTED");
            filter.addAction("android.intent.action.DREAMING_STOPPED");
            this.mContext.registerReceiver(new DreamReceiver(), filter, null, this.mHandler);
            filter = new IntentFilter();
            filter.addAction("android.intent.action.USER_SWITCHED");
            this.mContext.registerReceiver(new UserSwitchedReceiver(), filter, null, this.mHandler);
            filter = new IntentFilter();
            filter.addAction("android.intent.action.DOCK_EVENT");
            this.mContext.registerReceiver(new DockReceiver(), filter, null, this.mHandler);
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_enabled"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_activate_on_sleep"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("screensaver_activate_on_dock"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_off_timeout"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Secure.getUriFor("sleep_timeout"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("stay_on_while_plugged_in"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_brightness_mode"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.System.getUriFor("screen_auto_brightness_adj"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("low_power"), false, this.mSettingsObserver, -1);
            resolver.registerContentObserver(Settings.Global.getUriFor("low_power_trigger_level"), false, this.mSettingsObserver, -1);
            this.readConfigurationLocked();
            this.updateSettingsLocked();
            this.mDirty |= 0x100;
            this.updatePowerStateLocked();
        }
    }

    private void readConfigurationLocked() {
        Resources resources = this.mContext.getResources();
        this.mDecoupleHalAutoSuspendModeFromDisplayConfig = resources.getBoolean(17956953);
        this.mDecoupleHalInteractiveModeFromDisplayConfig = resources.getBoolean(17956954);
        this.mWakeUpWhenPluggedOrUnpluggedConfig = resources.getBoolean(0x1120021);
        this.mSuspendWhenScreenOffDueToProximityConfig = resources.getBoolean(17956907);
        this.mDreamsSupportedConfig = resources.getBoolean(17956947);
        this.mDreamsEnabledByDefaultConfig = resources.getBoolean(17956948);
        this.mDreamsActivatedOnSleepByDefaultConfig = resources.getBoolean(17956950);
        this.mDreamsActivatedOnDockByDefaultConfig = resources.getBoolean(17956949);
        this.mDreamsEnabledOnBatteryConfig = resources.getBoolean(17956951);
        this.mDreamsBatteryLevelMinimumWhenPoweredConfig = resources.getInteger(17694823);
        this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig = resources.getInteger(17694824);
        this.mDreamsBatteryLevelDrainCutoffConfig = resources.getInteger(17694825);
        this.mDozeAfterScreenOffConfig = resources.getBoolean(17956952);
        this.mMinimumScreenOffTimeoutConfig = resources.getInteger(17694826);
        this.mMaximumScreenDimDurationConfig = resources.getInteger(17694827);
        this.mMaximumScreenDimRatioConfig = resources.getFraction(0x1130001, 1, 1);
    }

    private void updateSettingsLocked() {
        boolean autoLowPowerModeConfigured;
        ContentResolver resolver = this.mContext.getContentResolver();
        this.mDreamsEnabledSetting = Settings.Secure.getIntForUser(resolver, "screensaver_enabled", this.mDreamsEnabledByDefaultConfig ? 1 : 0, -2) != 0;
        this.mDreamsActivateOnSleepSetting = Settings.Secure.getIntForUser(resolver, "screensaver_activate_on_sleep", this.mDreamsActivatedOnSleepByDefaultConfig ? 1 : 0, -2) != 0;
        this.mDreamsActivateOnDockSetting = Settings.Secure.getIntForUser(resolver, "screensaver_activate_on_dock", this.mDreamsActivatedOnDockByDefaultConfig ? 1 : 0, -2) != 0;
        this.mScreenOffTimeoutSetting = Settings.System.getIntForUser(resolver, "screen_off_timeout", 15000, -2);
        this.mSleepTimeoutSetting = Settings.Secure.getIntForUser(resolver, "sleep_timeout", -1, -2);
        this.mStayOnWhilePluggedInSetting = Settings.Global.getInt(resolver, "stay_on_while_plugged_in", 1);
        int oldScreenBrightnessSetting = this.mScreenBrightnessSetting;
        this.mScreenBrightnessSetting = Settings.System.getIntForUser(resolver, "screen_brightness", this.mScreenBrightnessSettingDefault, -2);
        if (oldScreenBrightnessSetting != this.mScreenBrightnessSetting) {
            this.mTemporaryScreenBrightnessSettingOverride = -1;
        }
        float oldScreenAutoBrightnessAdjustmentSetting = this.mScreenAutoBrightnessAdjustmentSetting;
        this.mScreenAutoBrightnessAdjustmentSetting = Settings.System.getFloatForUser(resolver, "screen_auto_brightness_adj", 0.0f, -2);
        if (oldScreenAutoBrightnessAdjustmentSetting != this.mScreenAutoBrightnessAdjustmentSetting) {
            this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = Float.NaN;
        }
        this.mScreenBrightnessModeSetting = Settings.System.getIntForUser(resolver, "screen_brightness_mode", 0, -2);
        boolean lowPowerModeEnabled = Settings.Global.getInt(resolver, "low_power", 0) != 0;
        boolean bl = autoLowPowerModeConfigured = Settings.Global.getInt(resolver, "low_power_trigger_level", 0) != 0;
        if (lowPowerModeEnabled != this.mLowPowerModeSetting || autoLowPowerModeConfigured != this.mAutoLowPowerModeConfigured) {
            this.mLowPowerModeSetting = lowPowerModeEnabled;
            this.mAutoLowPowerModeConfigured = autoLowPowerModeConfigured;
            this.updateLowPowerModeLocked();
        }
        this.mDirty |= 0x20;
    }

    void updateLowPowerModeLocked() {
        boolean lowPowerModeEnabled;
        if (this.mIsPowered && this.mLowPowerModeSetting) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "low_power", 0);
            this.mLowPowerModeSetting = false;
        }
        boolean autoLowPowerModeEnabled = !this.mIsPowered && this.mAutoLowPowerModeConfigured && !this.mAutoLowPowerModeSnoozing && this.mBatteryLevelLow;
        boolean bl = lowPowerModeEnabled = this.mLowPowerModeSetting || autoLowPowerModeEnabled;
        if (this.mLowPowerModeEnabled != lowPowerModeEnabled) {
            this.mLowPowerModeEnabled = lowPowerModeEnabled;
            this.powerHintInternal(5, lowPowerModeEnabled ? 1 : 0);
            BackgroundThread.getHandler().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayList listeners;
                    Intent intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGING").putExtra("mode", PowerManagerService.this.mLowPowerModeEnabled).addFlags(0x40000000);
                    PowerManagerService.this.mContext.sendBroadcast(intent);
                    Object object = PowerManagerService.this.mLock;
                    synchronized (object) {
                        listeners = new ArrayList(PowerManagerService.this.mLowPowerModeListeners);
                    }
                    for (int i = 0; i < listeners.size(); ++i) {
                        ((PowerManagerInternal.LowPowerModeListener)listeners.get(i)).onLowPowerModeChanged(lowPowerModeEnabled);
                    }
                    intent = new Intent("android.os.action.POWER_SAVE_MODE_CHANGED");
                    intent.addFlags(0x40000000);
                    PowerManagerService.this.mContext.sendBroadcast(intent);
                }
            });
        }
    }

    private void handleSettingsChangedLocked() {
        this.updateSettingsLocked();
        this.updatePowerStateLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireWakeLockInternal(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag, int uid, int pid) {
        Object object = this.mLock;
        synchronized (object) {
            boolean notifyAcquire;
            WakeLock wakeLock;
            int index = this.findWakeLockIndexLocked(lock);
            if (index >= 0) {
                wakeLock = this.mWakeLocks.get(index);
                if (!wakeLock.hasSameProperties(flags, tag, ws, uid, pid)) {
                    this.notifyWakeLockChangingLocked(wakeLock, flags, tag, packageName, uid, pid, ws, historyTag);
                    wakeLock.updateProperties(flags, tag, packageName, ws, historyTag, uid, pid);
                }
                notifyAcquire = false;
            } else {
                wakeLock = new WakeLock(lock, flags, tag, packageName, ws, historyTag, uid, pid);
                try {
                    lock.linkToDeath(wakeLock, 0);
                }
                catch (RemoteException ex) {
                    throw new IllegalArgumentException("Wake lock is already dead.");
                }
                this.mWakeLocks.add(wakeLock);
                notifyAcquire = true;
            }
            this.applyWakeLockFlagsOnAcquireLocked(wakeLock, uid);
            this.mDirty |= 1;
            this.updatePowerStateLocked();
            if (notifyAcquire) {
                this.notifyWakeLockAcquiredLocked(wakeLock);
            }
        }
    }

    private static boolean isScreenLock(WakeLock wakeLock) {
        switch (wakeLock.mFlags & 0xFFFF) {
            case 6: 
            case 10: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    private void applyWakeLockFlagsOnAcquireLocked(WakeLock wakeLock, int uid) {
        if ((wakeLock.mFlags & 0x10000000) != 0 && PowerManagerService.isScreenLock(wakeLock)) {
            this.wakeUpNoUpdateLocked(SystemClock.uptimeMillis(), uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWakeLockInternal(IBinder lock, int flags) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findWakeLockIndexLocked(lock);
            if (index < 0) {
                return;
            }
            WakeLock wakeLock = this.mWakeLocks.get(index);
            if ((flags & 1) != 0) {
                this.mRequestWaitForNegativeProximity = true;
            }
            wakeLock.mLock.unlinkToDeath(wakeLock, 0);
            this.removeWakeLockLocked(wakeLock, index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleWakeLockDeath(WakeLock wakeLock) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.mWakeLocks.indexOf(wakeLock);
            if (index < 0) {
                return;
            }
            this.removeWakeLockLocked(wakeLock, index);
        }
    }

    private void removeWakeLockLocked(WakeLock wakeLock, int index) {
        this.mWakeLocks.remove(index);
        this.notifyWakeLockReleasedLocked(wakeLock);
        this.applyWakeLockFlagsOnReleaseLocked(wakeLock);
        this.mDirty |= 1;
        this.updatePowerStateLocked();
    }

    private void applyWakeLockFlagsOnReleaseLocked(WakeLock wakeLock) {
        if ((wakeLock.mFlags & 0x20000000) != 0 && PowerManagerService.isScreenLock(wakeLock)) {
            this.userActivityNoUpdateLocked(SystemClock.uptimeMillis(), 0, 1, wakeLock.mOwnerUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWakeLockWorkSourceInternal(IBinder lock, WorkSource ws, String historyTag, int callingUid) {
        Object object = this.mLock;
        synchronized (object) {
            int index = this.findWakeLockIndexLocked(lock);
            if (index < 0) {
                throw new IllegalArgumentException("Wake lock not active: " + lock + " from uid " + callingUid);
            }
            WakeLock wakeLock = this.mWakeLocks.get(index);
            if (!wakeLock.hasSameWorkSource(ws)) {
                this.notifyWakeLockChangingLocked(wakeLock, wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, ws, historyTag);
                wakeLock.mHistoryTag = historyTag;
                wakeLock.updateWorkSource(ws);
            }
        }
    }

    private int findWakeLockIndexLocked(IBinder lock) {
        int count = this.mWakeLocks.size();
        for (int i = 0; i < count; ++i) {
            if (this.mWakeLocks.get((int)i).mLock != lock) continue;
            return i;
        }
        return -1;
    }

    private void notifyWakeLockAcquiredLocked(WakeLock wakeLock) {
        if (this.mSystemReady) {
            wakeLock.mNotifiedAcquired = true;
            this.mNotifier.onWakeLockAcquired(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource, wakeLock.mHistoryTag);
        }
    }

    private void notifyWakeLockChangingLocked(WakeLock wakeLock, int flags, String tag, String packageName, int uid, int pid, WorkSource ws, String historyTag) {
        if (this.mSystemReady && wakeLock.mNotifiedAcquired) {
            this.mNotifier.onWakeLockChanging(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource, wakeLock.mHistoryTag, flags, tag, packageName, uid, pid, ws, historyTag);
        }
    }

    private void notifyWakeLockReleasedLocked(WakeLock wakeLock) {
        if (this.mSystemReady && wakeLock.mNotifiedAcquired) {
            wakeLock.mNotifiedAcquired = false;
            this.mNotifier.onWakeLockReleased(wakeLock.mFlags, wakeLock.mTag, wakeLock.mPackageName, wakeLock.mOwnerUid, wakeLock.mOwnerPid, wakeLock.mWorkSource, wakeLock.mHistoryTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWakeLockLevelSupportedInternal(int level) {
        Object object = this.mLock;
        synchronized (object) {
            switch (level) {
                case 1: 
                case 6: 
                case 10: 
                case 26: 
                case 64: {
                    return true;
                }
                case 32: {
                    return this.mSystemReady && this.mDisplayManagerInternal.isProximitySensorAvailable();
                }
            }
            return false;
        }
    }

    private void userActivityFromNative(long eventTime, int event, int flags) {
        this.userActivityInternal(eventTime, event, flags, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userActivityInternal(long eventTime, int event, int flags, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.userActivityNoUpdateLocked(eventTime, event, flags, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userActivityNoUpdateLocked(long eventTime, int event, int flags, int uid) {
        if (eventTime < this.mLastSleepTime || eventTime < this.mLastWakeTime || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "userActivity");
        try {
            if (eventTime > this.mLastInteractivePowerHintTime) {
                this.powerHintInternal(2, 0);
                this.mLastInteractivePowerHintTime = eventTime;
            }
            this.mNotifier.onUserActivity(event, uid);
            if (this.mWakefulness == 0 || this.mWakefulness == 3 || (flags & 2) != 0) {
                boolean bl = false;
                return bl;
            }
            if ((flags & 1) != 0) {
                if (eventTime > this.mLastUserActivityTimeNoChangeLights && eventTime > this.mLastUserActivityTime) {
                    this.mLastUserActivityTimeNoChangeLights = eventTime;
                    this.mDirty |= 4;
                    boolean bl = true;
                    return bl;
                }
            } else if (eventTime > this.mLastUserActivityTime) {
                this.mLastUserActivityTime = eventTime;
                this.mDirty |= 4;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpInternal(long eventTime, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.wakeUpNoUpdateLocked(eventTime, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean wakeUpNoUpdateLocked(long eventTime, int uid) {
        if (eventTime < this.mLastSleepTime || this.mWakefulness == 1 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "wakeUp");
        try {
            switch (this.mWakefulness) {
                case 0: {
                    Slog.i(TAG, "Waking up from sleep (uid " + uid + ")...");
                    break;
                }
                case 2: {
                    Slog.i(TAG, "Waking up from dream (uid " + uid + ")...");
                    break;
                }
                case 3: {
                    Slog.i(TAG, "Waking up from dozing (uid " + uid + ")...");
                }
            }
            this.mLastWakeTime = eventTime;
            this.mDirty |= 2;
            this.mWakefulness = 1;
            this.setInteractiveStateLocked(true, 0);
            this.userActivityNoUpdateLocked(eventTime, 0, 0, uid);
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void goToSleepInternal(long eventTime, int reason, int flags, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.goToSleepNoUpdateLocked(eventTime, reason, flags, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean goToSleepNoUpdateLocked(long eventTime, int reason, int flags, int uid) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness == 0 || this.mWakefulness == 3 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "goToSleep");
        try {
            switch (reason) {
                case 1: {
                    Slog.i(TAG, "Going to sleep due to device administration policy (uid " + uid + ")...");
                    break;
                }
                case 2: {
                    Slog.i(TAG, "Going to sleep due to screen timeout (uid " + uid + ")...");
                    break;
                }
                case 3: {
                    Slog.i(TAG, "Going to sleep due to lid switch (uid " + uid + ")...");
                    break;
                }
                case 4: {
                    Slog.i(TAG, "Going to sleep due to power button (uid " + uid + ")...");
                    break;
                }
                case 5: {
                    Slog.i(TAG, "Going to sleep due to HDMI standby (uid " + uid + ")...");
                    break;
                }
                default: {
                    Slog.i(TAG, "Going to sleep by application request (uid " + uid + ")...");
                    reason = 0;
                }
            }
            this.mLastSleepTime = eventTime;
            this.mDirty |= 2;
            this.mWakefulness = 3;
            this.mSandmanSummoned = true;
            this.setInteractiveStateLocked(false, reason);
            int numWakeLocksCleared = 0;
            int numWakeLocks = this.mWakeLocks.size();
            for (int i = 0; i < numWakeLocks; ++i) {
                WakeLock wakeLock = this.mWakeLocks.get(i);
                switch (wakeLock.mFlags & 0xFFFF) {
                    case 6: 
                    case 10: 
                    case 26: {
                        ++numWakeLocksCleared;
                    }
                }
            }
            EventLog.writeEvent(2724, numWakeLocksCleared);
            if ((flags & 1) != 0) {
                this.reallyGoToSleepNoUpdateLocked(eventTime, uid);
            }
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void napInternal(long eventTime, int uid) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.napNoUpdateLocked(eventTime, uid)) {
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean napNoUpdateLocked(long eventTime, int uid) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness != 1 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "nap");
        try {
            Slog.i(TAG, "Nap time (uid " + uid + ")...");
            this.mDirty |= 2;
            this.mWakefulness = 2;
            this.mSandmanSummoned = true;
            this.setInteractiveStateLocked(true, 0);
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reallyGoToSleepNoUpdateLocked(long eventTime, int uid) {
        if (eventTime < this.mLastWakeTime || this.mWakefulness == 0 || !this.mBootCompleted || !this.mSystemReady) {
            return false;
        }
        Trace.traceBegin(131072L, "reallyGoToSleep");
        try {
            Slog.i(TAG, "Sleeping (uid " + uid + ")...");
            this.mDirty |= 2;
            this.mWakefulness = 0;
            this.setInteractiveStateLocked(false, 2);
        }
        finally {
            Trace.traceEnd(131072L);
        }
        return true;
    }

    private void setInteractiveStateLocked(boolean interactive, int reason) {
        if (this.mInteractive != interactive) {
            this.finishInteractiveStateChangeLocked();
            this.mInteractive = interactive;
            this.mInteractiveChanging = true;
            this.mNotifier.onInteractiveStateChangeStarted(interactive, reason);
        }
    }

    private void finishInteractiveStateChangeLocked() {
        if (this.mInteractiveChanging) {
            this.mNotifier.onInteractiveStateChangeFinished(this.mInteractive);
            this.mInteractiveChanging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePowerStateLocked() {
        if (!this.mSystemReady || this.mDirty == 0) {
            return;
        }
        if (!Thread.holdsLock(this.mLock)) {
            Slog.wtf(TAG, "Power manager lock was not held when calling updatePowerStateLocked");
        }
        Trace.traceBegin(131072L, "updatePowerState");
        try {
            int dirtyPhase1;
            this.updateIsPoweredLocked(this.mDirty);
            this.updateStayOnLocked(this.mDirty);
            long now = SystemClock.uptimeMillis();
            int dirtyPhase2 = 0;
            do {
                dirtyPhase1 = this.mDirty;
                dirtyPhase2 |= dirtyPhase1;
                this.mDirty = 0;
                this.updateWakeLockSummaryLocked(dirtyPhase1);
                this.updateUserActivitySummaryLocked(now, dirtyPhase1);
            } while (this.updateWakefulnessLocked(dirtyPhase1));
            boolean displayBecameReady = this.updateDisplayPowerStateLocked(dirtyPhase2);
            this.updateDreamLocked(dirtyPhase2, displayBecameReady);
            if (this.mDisplayReady) {
                this.finishInteractiveStateChangeLocked();
            }
            this.updateSuspendBlockerLocked();
        }
        finally {
            Trace.traceEnd(131072L);
        }
    }

    private void updateIsPoweredLocked(int dirty) {
        if ((dirty & 0x100) != 0) {
            boolean wasPowered = this.mIsPowered;
            int oldPlugType = this.mPlugType;
            boolean oldLevelLow = this.mBatteryLevelLow;
            this.mIsPowered = this.mBatteryManagerInternal.isPowered(7);
            this.mPlugType = this.mBatteryManagerInternal.getPlugType();
            this.mBatteryLevel = this.mBatteryManagerInternal.getBatteryLevel();
            this.mBatteryLevelLow = this.mBatteryManagerInternal.getBatteryLevelLow();
            if (wasPowered != this.mIsPowered || oldPlugType != this.mPlugType) {
                this.mDirty |= 0x40;
                boolean dockedOnWirelessCharger = this.mWirelessChargerDetector.update(this.mIsPowered, this.mPlugType, this.mBatteryLevel);
                long now = SystemClock.uptimeMillis();
                if (this.shouldWakeUpWhenPluggedOrUnpluggedLocked(wasPowered, oldPlugType, dockedOnWirelessCharger)) {
                    this.wakeUpNoUpdateLocked(now, 1000);
                }
                this.userActivityNoUpdateLocked(now, 0, 0, 1000);
                if (dockedOnWirelessCharger) {
                    this.mNotifier.onWirelessChargingStarted();
                }
            }
            if (wasPowered != this.mIsPowered || oldLevelLow != this.mBatteryLevelLow) {
                if (oldLevelLow != this.mBatteryLevelLow && !this.mBatteryLevelLow) {
                    this.mAutoLowPowerModeSnoozing = false;
                }
                this.updateLowPowerModeLocked();
            }
        }
    }

    private boolean shouldWakeUpWhenPluggedOrUnpluggedLocked(boolean wasPowered, int oldPlugType, boolean dockedOnWirelessCharger) {
        if (!this.mWakeUpWhenPluggedOrUnpluggedConfig) {
            return false;
        }
        if (wasPowered && !this.mIsPowered && oldPlugType == 4) {
            return false;
        }
        if (!wasPowered && this.mIsPowered && this.mPlugType == 4 && !dockedOnWirelessCharger) {
            return false;
        }
        return !this.mIsPowered || this.mWakefulness != 2;
    }

    private void updateStayOnLocked(int dirty) {
        if ((dirty & 0x120) != 0) {
            boolean wasStayOn = this.mStayOn;
            this.mStayOn = this.mStayOnWhilePluggedInSetting != 0 && !this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() ? this.mBatteryManagerInternal.isPowered(this.mStayOnWhilePluggedInSetting) : false;
            if (this.mStayOn != wasStayOn) {
                this.mDirty |= 0x80;
            }
        }
    }

    private void updateWakeLockSummaryLocked(int dirty) {
        if ((dirty & 3) != 0) {
            this.mWakeLockSummary = 0;
            int numWakeLocks = this.mWakeLocks.size();
            block8: for (int i = 0; i < numWakeLocks; ++i) {
                WakeLock wakeLock = this.mWakeLocks.get(i);
                switch (wakeLock.mFlags & 0xFFFF) {
                    case 1: {
                        this.mWakeLockSummary |= 1;
                        continue block8;
                    }
                    case 26: {
                        this.mWakeLockSummary |= 0xA;
                        continue block8;
                    }
                    case 10: {
                        this.mWakeLockSummary |= 2;
                        continue block8;
                    }
                    case 6: {
                        this.mWakeLockSummary |= 4;
                        continue block8;
                    }
                    case 32: {
                        this.mWakeLockSummary |= 0x10;
                        continue block8;
                    }
                    case 64: {
                        this.mWakeLockSummary |= 0x40;
                    }
                }
            }
            if (this.mWakefulness != 3) {
                this.mWakeLockSummary &= 0xFFFFFFBF;
            }
            if (this.mWakefulness == 0 || (this.mWakeLockSummary & 0x40) != 0) {
                this.mWakeLockSummary &= 0xFFFFFFF1;
                if (this.mWakefulness == 0) {
                    this.mWakeLockSummary &= 0xFFFFFFEF;
                }
            }
            if ((this.mWakeLockSummary & 6) != 0) {
                if (this.mWakefulness == 1) {
                    this.mWakeLockSummary |= 0x21;
                } else if (this.mWakefulness == 2) {
                    this.mWakeLockSummary |= 1;
                }
            }
        }
    }

    private void updateUserActivitySummaryLocked(long now, int dirty) {
        if ((dirty & 0x27) != 0) {
            this.mHandler.removeMessages(1);
            long nextTimeout = 0L;
            if (this.mWakefulness == 1 || this.mWakefulness == 2 || this.mWakefulness == 3) {
                int sleepTimeout = this.getSleepTimeoutLocked();
                int screenOffTimeout = this.getScreenOffTimeoutLocked(sleepTimeout);
                int screenDimDuration = this.getScreenDimDurationLocked(screenOffTimeout);
                this.mUserActivitySummary = 0;
                if (this.mLastUserActivityTime >= this.mLastWakeTime) {
                    nextTimeout = this.mLastUserActivityTime + (long)screenOffTimeout - (long)screenDimDuration;
                    if (now < nextTimeout) {
                        this.mUserActivitySummary = 1;
                    } else {
                        nextTimeout = this.mLastUserActivityTime + (long)screenOffTimeout;
                        if (now < nextTimeout) {
                            this.mUserActivitySummary = 2;
                        }
                    }
                }
                if (this.mUserActivitySummary == 0 && this.mLastUserActivityTimeNoChangeLights >= this.mLastWakeTime && now < (nextTimeout = this.mLastUserActivityTimeNoChangeLights + (long)screenOffTimeout)) {
                    if (this.mDisplayPowerRequest.policy == 3) {
                        this.mUserActivitySummary = 1;
                    } else if (this.mDisplayPowerRequest.policy == 2) {
                        this.mUserActivitySummary = 2;
                    }
                }
                if (this.mUserActivitySummary == 0) {
                    if (sleepTimeout >= 0) {
                        long anyUserActivity = Math.max(this.mLastUserActivityTime, this.mLastUserActivityTimeNoChangeLights);
                        if (anyUserActivity >= this.mLastWakeTime && now < (nextTimeout = anyUserActivity + (long)sleepTimeout)) {
                            this.mUserActivitySummary = 4;
                        }
                    } else {
                        this.mUserActivitySummary = 4;
                        nextTimeout = -1L;
                    }
                }
                if (this.mUserActivitySummary != 0 && nextTimeout >= 0L) {
                    Message msg = this.mHandler.obtainMessage(1);
                    msg.setAsynchronous(true);
                    this.mHandler.sendMessageAtTime(msg, nextTimeout);
                }
            } else {
                this.mUserActivitySummary = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUserActivityTimeout() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDirty |= 4;
            this.updatePowerStateLocked();
        }
    }

    private int getSleepTimeoutLocked() {
        int timeout = this.mSleepTimeoutSetting;
        if (timeout <= 0) {
            return -1;
        }
        return Math.max(timeout, this.mMinimumScreenOffTimeoutConfig);
    }

    private int getScreenOffTimeoutLocked(int sleepTimeout) {
        int timeout = this.mScreenOffTimeoutSetting;
        if (this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked()) {
            timeout = Math.min(timeout, this.mMaximumScreenOffTimeoutFromDeviceAdmin);
        }
        if (this.mUserActivityTimeoutOverrideFromWindowManager >= 0L) {
            timeout = (int)Math.min((long)timeout, this.mUserActivityTimeoutOverrideFromWindowManager);
        }
        if (sleepTimeout >= 0) {
            timeout = Math.min(timeout, sleepTimeout);
        }
        return Math.max(timeout, this.mMinimumScreenOffTimeoutConfig);
    }

    private int getScreenDimDurationLocked(int screenOffTimeout) {
        return Math.min(this.mMaximumScreenDimDurationConfig, (int)((float)screenOffTimeout * this.mMaximumScreenDimRatioConfig));
    }

    private boolean updateWakefulnessLocked(int dirty) {
        boolean changed = false;
        if ((dirty & 0x697) != 0 && this.mWakefulness == 1 && this.isItBedTimeYetLocked()) {
            long time = SystemClock.uptimeMillis();
            changed = this.shouldNapAtBedTimeLocked() ? this.napNoUpdateLocked(time, 1000) : this.goToSleepNoUpdateLocked(time, 2, 0, 1000);
        }
        return changed;
    }

    private boolean shouldNapAtBedTimeLocked() {
        return this.mDreamsActivateOnSleepSetting || this.mDreamsActivateOnDockSetting && this.mDockState != 0;
    }

    private boolean isItBedTimeYetLocked() {
        return this.mBootCompleted && !this.isBeingKeptAwakeLocked();
    }

    private boolean isBeingKeptAwakeLocked() {
        return this.mStayOn || this.mProximityPositive || (this.mWakeLockSummary & 0x20) != 0 || (this.mUserActivitySummary & 3) != 0;
    }

    private void updateDreamLocked(int dirty, boolean displayBecameReady) {
        if (((dirty & 0x3F7) != 0 || displayBecameReady) && this.mDisplayReady) {
            this.scheduleSandmanLocked();
        }
    }

    private void scheduleSandmanLocked() {
        if (!this.mSandmanScheduled) {
            this.mSandmanScheduled = true;
            Message msg = this.mHandler.obtainMessage(2);
            msg.setAsynchronous(true);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSandman() {
        boolean isDreaming;
        boolean startDreaming;
        int wakefulness;
        Object object = this.mLock;
        synchronized (object) {
            this.mSandmanScheduled = false;
            wakefulness = this.mWakefulness;
            if (this.mSandmanSummoned && this.mDisplayReady) {
                startDreaming = this.canDreamLocked() || this.canDozeLocked();
                this.mSandmanSummoned = false;
            } else {
                startDreaming = false;
            }
        }
        if (this.mDreamManager != null) {
            if (startDreaming) {
                this.mDreamManager.stopDream(false);
                this.mDreamManager.startDream(wakefulness == 3);
            }
            isDreaming = this.mDreamManager.isDreaming();
        } else {
            isDreaming = false;
        }
        Object object2 = this.mLock;
        synchronized (object2) {
            if (startDreaming && isDreaming) {
                this.mBatteryLevelWhenDreamStarted = this.mBatteryLevel;
                if (wakefulness == 3) {
                    Slog.i(TAG, "Dozing...");
                } else {
                    Slog.i(TAG, "Dreaming...");
                }
            }
            if (this.mSandmanSummoned || this.mWakefulness != wakefulness) {
                return;
            }
            if (wakefulness == 2) {
                if (isDreaming && this.canDreamLocked()) {
                    if (this.mDreamsBatteryLevelDrainCutoffConfig >= 0 && this.mBatteryLevel < this.mBatteryLevelWhenDreamStarted - this.mDreamsBatteryLevelDrainCutoffConfig && !this.isBeingKeptAwakeLocked()) {
                        Slog.i(TAG, "Stopping dream because the battery appears to be draining faster than it is charging.  Battery level when dream started: " + this.mBatteryLevelWhenDreamStarted + "%.  " + "Battery level now: " + this.mBatteryLevel + "%.");
                    } else {
                        return;
                    }
                }
                if (this.isItBedTimeYetLocked()) {
                    this.goToSleepNoUpdateLocked(SystemClock.uptimeMillis(), 2, 0, 1000);
                    this.updatePowerStateLocked();
                } else {
                    this.wakeUpNoUpdateLocked(SystemClock.uptimeMillis(), 1000);
                    this.updatePowerStateLocked();
                }
            } else if (wakefulness == 3) {
                if (isDreaming) {
                    return;
                }
                this.reallyGoToSleepNoUpdateLocked(SystemClock.uptimeMillis(), 1000);
                this.updatePowerStateLocked();
            }
        }
        if (isDreaming) {
            this.mDreamManager.stopDream(false);
        }
    }

    private boolean canDreamLocked() {
        if (!(this.mWakefulness == 2 && this.mDreamsSupportedConfig && this.mDreamsEnabledSetting && this.mDisplayPowerRequest.isBrightOrDim() && (this.mUserActivitySummary & 7) != 0 && this.mBootCompleted)) {
            return false;
        }
        if (!this.isBeingKeptAwakeLocked()) {
            if (!this.mIsPowered && !this.mDreamsEnabledOnBatteryConfig) {
                return false;
            }
            if (!this.mIsPowered && this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig >= 0 && this.mBatteryLevel < this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig) {
                return false;
            }
            if (this.mIsPowered && this.mDreamsBatteryLevelMinimumWhenPoweredConfig >= 0 && this.mBatteryLevel < this.mDreamsBatteryLevelMinimumWhenPoweredConfig) {
                return false;
            }
        }
        return true;
    }

    private boolean canDozeLocked() {
        return this.mWakefulness == 3;
    }

    private boolean updateDisplayPowerStateLocked(int dirty) {
        boolean oldDisplayReady = this.mDisplayReady;
        if ((dirty & 0x3F) != 0) {
            boolean autoBrightness;
            this.mDisplayPowerRequest.policy = this.getDesiredScreenPolicyLocked();
            int screenBrightness = this.mScreenBrightnessSettingDefault;
            float screenAutoBrightnessAdjustment = 0.0f;
            boolean bl = autoBrightness = this.mScreenBrightnessModeSetting == 1;
            if (PowerManagerService.isValidBrightness(this.mScreenBrightnessOverrideFromWindowManager)) {
                screenBrightness = this.mScreenBrightnessOverrideFromWindowManager;
                autoBrightness = false;
            } else if (PowerManagerService.isValidBrightness(this.mTemporaryScreenBrightnessSettingOverride)) {
                screenBrightness = this.mTemporaryScreenBrightnessSettingOverride;
            } else if (PowerManagerService.isValidBrightness(this.mScreenBrightnessSetting)) {
                screenBrightness = this.mScreenBrightnessSetting;
            }
            if (autoBrightness) {
                screenBrightness = this.mScreenBrightnessSettingDefault;
                if (PowerManagerService.isValidAutoBrightnessAdjustment(this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride)) {
                    screenAutoBrightnessAdjustment = this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride;
                } else if (PowerManagerService.isValidAutoBrightnessAdjustment(this.mScreenAutoBrightnessAdjustmentSetting)) {
                    screenAutoBrightnessAdjustment = this.mScreenAutoBrightnessAdjustmentSetting;
                }
            }
            screenBrightness = Math.max(Math.min(screenBrightness, this.mScreenBrightnessSettingMaximum), this.mScreenBrightnessSettingMinimum);
            screenAutoBrightnessAdjustment = Math.max(Math.min(screenAutoBrightnessAdjustment, 1.0f), -1.0f);
            this.mDisplayPowerRequest.screenBrightness = screenBrightness;
            this.mDisplayPowerRequest.screenAutoBrightnessAdjustment = screenAutoBrightnessAdjustment;
            this.mDisplayPowerRequest.useAutoBrightness = autoBrightness;
            this.mDisplayPowerRequest.useProximitySensor = this.shouldUseProximitySensorLocked();
            this.mDisplayPowerRequest.lowPowerMode = this.mLowPowerModeEnabled;
            if (this.mDisplayPowerRequest.policy == 1) {
                this.mDisplayPowerRequest.dozeScreenState = this.mDozeScreenStateOverrideFromDreamManager;
                this.mDisplayPowerRequest.dozeScreenBrightness = this.mDozeScreenBrightnessOverrideFromDreamManager;
            } else {
                this.mDisplayPowerRequest.dozeScreenState = 0;
                this.mDisplayPowerRequest.dozeScreenBrightness = -1;
            }
            this.mDisplayReady = this.mDisplayManagerInternal.requestPowerState(this.mDisplayPowerRequest, this.mRequestWaitForNegativeProximity);
            this.mRequestWaitForNegativeProximity = false;
        }
        return this.mDisplayReady && !oldDisplayReady;
    }

    private static boolean isValidBrightness(int value) {
        return value >= 0 && value <= 255;
    }

    private static boolean isValidAutoBrightnessAdjustment(float value) {
        return value >= -1.0f && value <= 1.0f;
    }

    private int getDesiredScreenPolicyLocked() {
        if (this.mWakefulness == 0) {
            return 0;
        }
        if (this.mWakefulness == 3) {
            if ((this.mWakeLockSummary & 0x40) != 0) {
                return 1;
            }
            if (this.mDozeAfterScreenOffConfig) {
                return 0;
            }
        }
        if ((this.mWakeLockSummary & 2) != 0 || (this.mUserActivitySummary & 1) != 0 || !this.mBootCompleted) {
            return 3;
        }
        return 2;
    }

    private boolean shouldUseProximitySensorLocked() {
        return (this.mWakeLockSummary & 0x10) != 0;
    }

    private void updateSuspendBlockerLocked() {
        boolean autoSuspend;
        boolean needWakeLockSuspendBlocker = (this.mWakeLockSummary & 1) != 0;
        boolean needDisplaySuspendBlocker = this.needDisplaySuspendBlockerLocked();
        boolean bl = autoSuspend = !needDisplaySuspendBlocker;
        if (!autoSuspend) {
            if (this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
                this.setHalAutoSuspendModeLocked(false);
            }
            if (this.mDecoupleHalInteractiveModeFromDisplayConfig) {
                this.setHalInteractiveModeLocked(true);
            }
        }
        if (needWakeLockSuspendBlocker && !this.mHoldingWakeLockSuspendBlocker) {
            this.mWakeLockSuspendBlocker.acquire();
            this.mHoldingWakeLockSuspendBlocker = true;
        }
        if (needDisplaySuspendBlocker && !this.mHoldingDisplaySuspendBlocker) {
            this.mDisplaySuspendBlocker.acquire();
            this.mHoldingDisplaySuspendBlocker = true;
        }
        if (!needWakeLockSuspendBlocker && this.mHoldingWakeLockSuspendBlocker) {
            this.mWakeLockSuspendBlocker.release();
            this.mHoldingWakeLockSuspendBlocker = false;
        }
        if (!needDisplaySuspendBlocker && this.mHoldingDisplaySuspendBlocker) {
            this.mDisplaySuspendBlocker.release();
            this.mHoldingDisplaySuspendBlocker = false;
        }
        if (autoSuspend) {
            if (this.mDecoupleHalInteractiveModeFromDisplayConfig) {
                this.setHalInteractiveModeLocked(false);
            }
            if (this.mDecoupleHalAutoSuspendModeFromDisplayConfig) {
                this.setHalAutoSuspendModeLocked(true);
            }
        }
    }

    private boolean needDisplaySuspendBlockerLocked() {
        if (!this.mDisplayReady) {
            return true;
        }
        return this.mDisplayPowerRequest.isBrightOrDim() && (!this.mDisplayPowerRequest.useProximitySensor || !this.mProximityPositive || !this.mSuspendWhenScreenOffDueToProximityConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHalAutoSuspendModeLocked(boolean enable) {
        if (enable != this.mHalAutoSuspendModeEnabled) {
            this.mHalAutoSuspendModeEnabled = enable;
            Trace.traceBegin(131072L, "setHalAutoSuspend(" + enable + ")");
            try {
                PowerManagerService.nativeSetAutoSuspend(enable);
            }
            finally {
                Trace.traceEnd(131072L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHalInteractiveModeLocked(boolean enable) {
        if (enable != this.mHalInteractiveModeEnabled) {
            this.mHalInteractiveModeEnabled = enable;
            Trace.traceBegin(131072L, "setHalInteractive(" + enable + ")");
            try {
                PowerManagerService.nativeSetInteractive(enable);
            }
            finally {
                Trace.traceEnd(131072L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInteractiveInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInteractive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLowPowerModeInternal() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLowPowerModeEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setLowPowerModeInternal(boolean mode) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsPowered) {
                return false;
            }
            Settings.Global.putInt(this.mContext.getContentResolver(), "low_power", mode ? 1 : 0);
            this.mLowPowerModeSetting = mode;
            if (this.mAutoLowPowerModeConfigured && this.mBatteryLevelLow) {
                if (mode && this.mAutoLowPowerModeSnoozing) {
                    this.mAutoLowPowerModeSnoozing = false;
                } else if (!mode && !this.mAutoLowPowerModeSnoozing) {
                    this.mAutoLowPowerModeSnoozing = true;
                }
            }
            this.updateLowPowerModeLocked();
            return true;
        }
    }

    private void handleBatteryStateChangedLocked() {
        this.mDirty |= 0x100;
        this.updatePowerStateLocked();
    }

    private void shutdownOrRebootInternal(final boolean shutdown, final boolean confirm, final String reason, boolean wait) {
        if (this.mHandler == null || !this.mSystemReady) {
            throw new IllegalStateException("Too early to call shutdown() or reboot()");
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (shutdown) {
                        ShutdownThread.shutdown(PowerManagerService.this.mContext, confirm);
                    } else {
                        ShutdownThread.reboot(PowerManagerService.this.mContext, reason, confirm);
                    }
                }
            }
        };
        Message msg = Message.obtain((Handler)this.mHandler, runnable);
        msg.setAsynchronous(true);
        this.mHandler.sendMessage(msg);
        if (wait) {
            Runnable runnable2 = runnable;
            synchronized (runnable2) {
                while (true) {
                    try {
                        while (true) {
                            runnable.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private void crashInternal(final String message) {
        Thread t = new Thread("PowerManagerService.crash()"){

            @Override
            public void run() {
                throw new RuntimeException(message);
            }
        };
        try {
            t.start();
            t.join();
        }
        catch (InterruptedException e) {
            Slog.wtf(TAG, e);
        }
    }

    private void setStayOnSettingInternal(int val) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMaximumScreenOffTimeoutFromDeviceAdminInternal(int timeMs) {
        Object object = this.mLock;
        synchronized (object) {
            this.mMaximumScreenOffTimeoutFromDeviceAdmin = timeMs;
            this.mDirty |= 0x20;
            this.updatePowerStateLocked();
        }
    }

    private boolean isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() {
        return this.mMaximumScreenOffTimeoutFromDeviceAdmin >= 0 && this.mMaximumScreenOffTimeoutFromDeviceAdmin < Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttentionLightInternal(boolean on, int color2) {
        Light light;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mSystemReady) {
                return;
            }
            light = this.mAttentionLight;
        }
        light.setFlashing(color2, 2, on ? 3 : 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScreenBrightnessOverrideFromWindowManagerInternal(int brightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mScreenBrightnessOverrideFromWindowManager != brightness) {
                this.mScreenBrightnessOverrideFromWindowManager = brightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserActivityTimeoutOverrideFromWindowManagerInternal(long timeoutMillis) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUserActivityTimeoutOverrideFromWindowManager != timeoutMillis) {
                this.mUserActivityTimeoutOverrideFromWindowManager = timeoutMillis;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemporaryScreenBrightnessSettingOverrideInternal(int brightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTemporaryScreenBrightnessSettingOverride != brightness) {
                this.mTemporaryScreenBrightnessSettingOverride = brightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemporaryScreenAutoBrightnessAdjustmentSettingOverrideInternal(float adj) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride != adj) {
                this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride = adj;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDozeOverrideFromDreamManagerInternal(int screenState, int screenBrightness) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDozeScreenStateOverrideFromDreamManager != screenState || this.mDozeScreenBrightnessOverrideFromDreamManager != screenBrightness) {
                this.mDozeScreenStateOverrideFromDreamManager = screenState;
                this.mDozeScreenBrightnessOverrideFromDreamManager = screenBrightness;
                this.mDirty |= 0x20;
                this.updatePowerStateLocked();
            }
        }
    }

    private void powerHintInternal(int hintId, int data) {
        PowerManagerService.nativeSendPowerHint(hintId, data);
    }

    public static void lowLevelShutdown() {
        SystemProperties.set("sys.powerctl", "shutdown");
    }

    public static void lowLevelReboot(String reason) {
        long duration;
        if (reason == null) {
            reason = "";
        }
        if (reason.equals("recovery")) {
            SystemProperties.set("ctl.start", "pre-recovery");
            duration = 300000L;
        } else {
            SystemProperties.set("sys.powerctl", "reboot," + reason);
            duration = 20000L;
        }
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(PrintWriter pw) {
        WirelessChargerDetector wcd;
        pw.println("POWER MANAGER (dumpsys power)\n");
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Power Manager State:");
            pw.println("  mDirty=0x" + Integer.toHexString(this.mDirty));
            pw.println("  mWakefulness=" + PowerManagerService.wakefulnessToString(this.mWakefulness));
            pw.println("  mInteractive=" + this.mInteractive);
            pw.println("  mIsPowered=" + this.mIsPowered);
            pw.println("  mPlugType=" + this.mPlugType);
            pw.println("  mBatteryLevel=" + this.mBatteryLevel);
            pw.println("  mBatteryLevelWhenDreamStarted=" + this.mBatteryLevelWhenDreamStarted);
            pw.println("  mDockState=" + this.mDockState);
            pw.println("  mStayOn=" + this.mStayOn);
            pw.println("  mProximityPositive=" + this.mProximityPositive);
            pw.println("  mBootCompleted=" + this.mBootCompleted);
            pw.println("  mSystemReady=" + this.mSystemReady);
            pw.println("  mHalAutoSuspendModeEnabled=" + this.mHalAutoSuspendModeEnabled);
            pw.println("  mHalInteractiveModeEnabled=" + this.mHalInteractiveModeEnabled);
            pw.println("  mWakeLockSummary=0x" + Integer.toHexString(this.mWakeLockSummary));
            pw.println("  mUserActivitySummary=0x" + Integer.toHexString(this.mUserActivitySummary));
            pw.println("  mRequestWaitForNegativeProximity=" + this.mRequestWaitForNegativeProximity);
            pw.println("  mSandmanScheduled=" + this.mSandmanScheduled);
            pw.println("  mSandmanSummoned=" + this.mSandmanSummoned);
            pw.println("  mLowPowerModeEnabled=" + this.mLowPowerModeEnabled);
            pw.println("  mBatteryLevelLow=" + this.mBatteryLevelLow);
            pw.println("  mLastWakeTime=" + TimeUtils.formatUptime(this.mLastWakeTime));
            pw.println("  mLastSleepTime=" + TimeUtils.formatUptime(this.mLastSleepTime));
            pw.println("  mLastUserActivityTime=" + TimeUtils.formatUptime(this.mLastUserActivityTime));
            pw.println("  mLastUserActivityTimeNoChangeLights=" + TimeUtils.formatUptime(this.mLastUserActivityTimeNoChangeLights));
            pw.println("  mLastInteractivePowerHintTime=" + TimeUtils.formatUptime(this.mLastInteractivePowerHintTime));
            pw.println("  mDisplayReady=" + this.mDisplayReady);
            pw.println("  mHoldingWakeLockSuspendBlocker=" + this.mHoldingWakeLockSuspendBlocker);
            pw.println("  mHoldingDisplaySuspendBlocker=" + this.mHoldingDisplaySuspendBlocker);
            pw.println();
            pw.println("Settings and Configuration:");
            pw.println("  mDecoupleHalAutoSuspendModeFromDisplayConfig=" + this.mDecoupleHalAutoSuspendModeFromDisplayConfig);
            pw.println("  mDecoupleHalInteractiveModeFromDisplayConfig=" + this.mDecoupleHalInteractiveModeFromDisplayConfig);
            pw.println("  mWakeUpWhenPluggedOrUnpluggedConfig=" + this.mWakeUpWhenPluggedOrUnpluggedConfig);
            pw.println("  mSuspendWhenScreenOffDueToProximityConfig=" + this.mSuspendWhenScreenOffDueToProximityConfig);
            pw.println("  mDreamsSupportedConfig=" + this.mDreamsSupportedConfig);
            pw.println("  mDreamsEnabledByDefaultConfig=" + this.mDreamsEnabledByDefaultConfig);
            pw.println("  mDreamsActivatedOnSleepByDefaultConfig=" + this.mDreamsActivatedOnSleepByDefaultConfig);
            pw.println("  mDreamsActivatedOnDockByDefaultConfig=" + this.mDreamsActivatedOnDockByDefaultConfig);
            pw.println("  mDreamsEnabledOnBatteryConfig=" + this.mDreamsEnabledOnBatteryConfig);
            pw.println("  mDreamsBatteryLevelMinimumWhenPoweredConfig=" + this.mDreamsBatteryLevelMinimumWhenPoweredConfig);
            pw.println("  mDreamsBatteryLevelMinimumWhenNotPoweredConfig=" + this.mDreamsBatteryLevelMinimumWhenNotPoweredConfig);
            pw.println("  mDreamsBatteryLevelDrainCutoffConfig=" + this.mDreamsBatteryLevelDrainCutoffConfig);
            pw.println("  mDreamsEnabledSetting=" + this.mDreamsEnabledSetting);
            pw.println("  mDreamsActivateOnSleepSetting=" + this.mDreamsActivateOnSleepSetting);
            pw.println("  mDreamsActivateOnDockSetting=" + this.mDreamsActivateOnDockSetting);
            pw.println("  mDozeAfterScreenOffConfig=" + this.mDozeAfterScreenOffConfig);
            pw.println("  mLowPowerModeSetting=" + this.mLowPowerModeSetting);
            pw.println("  mAutoLowPowerModeConfigured=" + this.mAutoLowPowerModeConfigured);
            pw.println("  mAutoLowPowerModeSnoozing=" + this.mAutoLowPowerModeSnoozing);
            pw.println("  mMinimumScreenOffTimeoutConfig=" + this.mMinimumScreenOffTimeoutConfig);
            pw.println("  mMaximumScreenDimDurationConfig=" + this.mMaximumScreenDimDurationConfig);
            pw.println("  mMaximumScreenDimRatioConfig=" + this.mMaximumScreenDimRatioConfig);
            pw.println("  mScreenOffTimeoutSetting=" + this.mScreenOffTimeoutSetting);
            pw.println("  mSleepTimeoutSetting=" + this.mSleepTimeoutSetting);
            pw.println("  mMaximumScreenOffTimeoutFromDeviceAdmin=" + this.mMaximumScreenOffTimeoutFromDeviceAdmin + " (enforced=" + this.isMaximumScreenOffTimeoutFromDeviceAdminEnforcedLocked() + ")");
            pw.println("  mStayOnWhilePluggedInSetting=" + this.mStayOnWhilePluggedInSetting);
            pw.println("  mScreenBrightnessSetting=" + this.mScreenBrightnessSetting);
            pw.println("  mScreenAutoBrightnessAdjustmentSetting=" + this.mScreenAutoBrightnessAdjustmentSetting);
            pw.println("  mScreenBrightnessModeSetting=" + this.mScreenBrightnessModeSetting);
            pw.println("  mScreenBrightnessOverrideFromWindowManager=" + this.mScreenBrightnessOverrideFromWindowManager);
            pw.println("  mUserActivityTimeoutOverrideFromWindowManager=" + this.mUserActivityTimeoutOverrideFromWindowManager);
            pw.println("  mTemporaryScreenBrightnessSettingOverride=" + this.mTemporaryScreenBrightnessSettingOverride);
            pw.println("  mTemporaryScreenAutoBrightnessAdjustmentSettingOverride=" + this.mTemporaryScreenAutoBrightnessAdjustmentSettingOverride);
            pw.println("  mDozeScreenStateOverrideFromDreamManager=" + this.mDozeScreenStateOverrideFromDreamManager);
            pw.println("  mDozeScreenBrightnessOverrideFromDreamManager=" + this.mDozeScreenBrightnessOverrideFromDreamManager);
            pw.println("  mScreenBrightnessSettingMinimum=" + this.mScreenBrightnessSettingMinimum);
            pw.println("  mScreenBrightnessSettingMaximum=" + this.mScreenBrightnessSettingMaximum);
            pw.println("  mScreenBrightnessSettingDefault=" + this.mScreenBrightnessSettingDefault);
            int sleepTimeout = this.getSleepTimeoutLocked();
            int screenOffTimeout = this.getScreenOffTimeoutLocked(sleepTimeout);
            int screenDimDuration = this.getScreenDimDurationLocked(screenOffTimeout);
            pw.println();
            pw.println("Sleep timeout: " + sleepTimeout + " ms");
            pw.println("Screen off timeout: " + screenOffTimeout + " ms");
            pw.println("Screen dim duration: " + screenDimDuration + " ms");
            pw.println();
            pw.println("Wake Locks: size=" + this.mWakeLocks.size());
            for (WakeLock wl : this.mWakeLocks) {
                pw.println("  " + wl);
            }
            pw.println();
            pw.println("Suspend Blockers: size=" + this.mSuspendBlockers.size());
            for (SuspendBlocker sb : this.mSuspendBlockers) {
                pw.println("  " + sb);
            }
            pw.println();
            pw.println("Display Power: " + this.mDisplayPowerCallbacks);
            wcd = this.mWirelessChargerDetector;
        }
        if (wcd != null) {
            wcd.dump(pw);
        }
    }

    private SuspendBlocker createSuspendBlockerLocked(String name) {
        SuspendBlockerImpl suspendBlocker = new SuspendBlockerImpl(name);
        this.mSuspendBlockers.add(suspendBlocker);
        return suspendBlocker;
    }

    private static String wakefulnessToString(int wakefulness) {
        switch (wakefulness) {
            case 0: {
                return "Asleep";
            }
            case 1: {
                return "Awake";
            }
            case 2: {
                return "Dreaming";
            }
            case 3: {
                return "Dozing";
            }
        }
        return Integer.toString(wakefulness);
    }

    private static WorkSource copyWorkSource(WorkSource workSource) {
        return workSource != null ? new WorkSource(workSource) : null;
    }

    private final class LocalService
    extends PowerManagerInternal {
        private LocalService() {
        }

        @Override
        public void setScreenBrightnessOverrideFromWindowManager(int screenBrightness) {
            if (screenBrightness < -1 || screenBrightness > 255) {
                screenBrightness = -1;
            }
            PowerManagerService.this.setScreenBrightnessOverrideFromWindowManagerInternal(screenBrightness);
        }

        @Override
        public void setButtonBrightnessOverrideFromWindowManager(int screenBrightness) {
        }

        @Override
        public void setDozeOverrideFromDreamManager(int screenState, int screenBrightness) {
            switch (screenState) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    screenState = 0;
                }
            }
            if (screenBrightness < -1 || screenBrightness > 255) {
                screenBrightness = -1;
            }
            PowerManagerService.this.setDozeOverrideFromDreamManagerInternal(screenState, screenBrightness);
        }

        @Override
        public void setUserActivityTimeoutOverrideFromWindowManager(long timeoutMillis) {
            PowerManagerService.this.setUserActivityTimeoutOverrideFromWindowManagerInternal(timeoutMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getLowPowerModeEnabled() {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                return PowerManagerService.this.mLowPowerModeEnabled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerLowPowerModeObserver(PowerManagerInternal.LowPowerModeListener listener) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.mLowPowerModeListeners.add(listener);
            }
        }
    }

    private final class BinderService
    extends IPowerManager.Stub {
        private BinderService() {
        }

        @Override
        public void acquireWakeLockWithUid(IBinder lock, int flags, String tag, String packageName, int uid) {
            if (uid < 0) {
                uid = Binder.getCallingUid();
            }
            this.acquireWakeLock(lock, flags, tag, packageName, new WorkSource(uid), null);
        }

        @Override
        public void powerHint(int hintId, int data) {
            if (!PowerManagerService.this.mSystemReady) {
                return;
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            PowerManagerService.this.powerHintInternal(hintId, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acquireWakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource ws, String historyTag) {
            if (lock == null) {
                throw new IllegalArgumentException("lock must not be null");
            }
            if (packageName == null) {
                throw new IllegalArgumentException("packageName must not be null");
            }
            PowerManager.validateWakeLockParameters(flags, tag);
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
            if ((flags & 0x40) != 0) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            }
            if (ws != null && ws.size() != 0) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
            } else {
                ws = null;
            }
            int uid = Binder.getCallingUid();
            int pid = Binder.getCallingPid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.acquireWakeLockInternal(lock, flags, tag, packageName, ws, historyTag, uid, pid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseWakeLock(IBinder lock, int flags) {
            if (lock == null) {
                throw new IllegalArgumentException("lock must not be null");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.releaseWakeLockInternal(lock, flags);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        @Override
        public void updateWakeLockUids(IBinder lock, int[] uids) {
            WorkSource ws = null;
            if (uids != null) {
                ws = new WorkSource();
                for (int i = 0; i < uids.length; ++i) {
                    ws.add(uids[i]);
                }
            }
            this.updateWakeLockWorkSource(lock, ws, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateWakeLockWorkSource(IBinder lock, WorkSource ws, String historyTag) {
            if (lock == null) {
                throw new IllegalArgumentException("lock must not be null");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.WAKE_LOCK", null);
            if (ws != null && ws.size() != 0) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", null);
            } else {
                ws = null;
            }
            int callingUid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.updateWakeLockWorkSourceInternal(lock, ws, historyTag, callingUid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isWakeLockLevelSupported(int level) {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isWakeLockLevelSupportedInternal(level);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void userActivity(long eventTime, int event, int flags) {
            long now = SystemClock.uptimeMillis();
            if (PowerManagerService.this.mContext.checkCallingOrSelfPermission("android.permission.DEVICE_POWER") != 0 && PowerManagerService.this.mContext.checkCallingOrSelfPermission("android.permission.USER_ACTIVITY") != 0) {
                Object object = PowerManagerService.this.mLock;
                synchronized (object) {
                    if (now >= PowerManagerService.this.mLastWarningAboutUserActivityPermission + 300000L) {
                        PowerManagerService.this.mLastWarningAboutUserActivityPermission = now;
                        Slog.w(PowerManagerService.TAG, "Ignoring call to PowerManager.userActivity() because the caller does not have DEVICE_POWER or USER_ACTIVITY permission.  Please fix your app!   pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid());
                    }
                }
                return;
            }
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.userActivityInternal(eventTime, event, flags, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void wakeUp(long eventTime) {
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.wakeUpInternal(eventTime, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void goToSleep(long eventTime, int reason, int flags) {
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.goToSleepInternal(eventTime, reason, flags, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nap(long eventTime) {
            if (eventTime > SystemClock.uptimeMillis()) {
                throw new IllegalArgumentException("event time must not be in the future");
            }
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            int uid = Binder.getCallingUid();
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.napInternal(eventTime, uid);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isInteractive() {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isInteractiveInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isPowerSaveMode() {
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.isLowPowerModeInternal();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setPowerSaveMode(boolean mode) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                boolean bl = PowerManagerService.this.setLowPowerModeInternal(mode);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reboot(boolean confirm, String reason, boolean wait) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
            if ("recovery".equals(reason)) {
                PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.RECOVERY", null);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.shutdownOrRebootInternal(false, confirm, reason, wait);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown(boolean confirm, boolean wait) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.shutdownOrRebootInternal(true, confirm, null, wait);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void crash(String message) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.REBOOT", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.crashInternal(message);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStayOnSetting(int val) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SETTINGS", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setStayOnSettingInternal(val);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMaximumScreenOffTimeoutFromDeviceAdmin(int timeMs) {
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setMaximumScreenOffTimeoutFromDeviceAdminInternal(timeMs);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTemporaryScreenBrightnessSettingOverride(int brightness) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setTemporaryScreenBrightnessSettingOverrideInternal(brightness);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTemporaryScreenAutoBrightnessAdjustmentSettingOverride(float adj) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setTemporaryScreenAutoBrightnessAdjustmentSettingOverrideInternal(adj);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttentionLight(boolean on, int color2) {
            PowerManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.setAttentionLightInternal(on, color2);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (PowerManagerService.this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump PowerManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                PowerManagerService.this.dumpInternal(pw);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private final class SuspendBlockerImpl
    implements SuspendBlocker {
        private final String mName;
        private final String mTraceName;
        private int mReferenceCount;

        public SuspendBlockerImpl(String name) {
            this.mName = name;
            this.mTraceName = "SuspendBlocker (" + name + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.mReferenceCount != 0) {
                    Slog.wtf(PowerManagerService.TAG, "Suspend blocker \"" + this.mName + "\" was finalized without being released!");
                    this.mReferenceCount = 0;
                    PowerManagerService.nativeReleaseSuspendBlocker(this.mName);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                }
            }
            finally {
                super.finalize();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acquire() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                ++this.mReferenceCount;
                if (this.mReferenceCount == 1) {
                    Trace.asyncTraceBegin(131072L, this.mTraceName, 0);
                    PowerManagerService.nativeAcquireSuspendBlocker(this.mName);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                --this.mReferenceCount;
                if (this.mReferenceCount == 0) {
                    PowerManagerService.nativeReleaseSuspendBlocker(this.mName);
                    Trace.asyncTraceEnd(131072L, this.mTraceName, 0);
                } else if (this.mReferenceCount < 0) {
                    Slog.wtf(PowerManagerService.TAG, "Suspend blocker \"" + this.mName + "\" was released without being acquired!", new Throwable());
                    this.mReferenceCount = 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            SuspendBlockerImpl suspendBlockerImpl = this;
            synchronized (suspendBlockerImpl) {
                return this.mName + ": ref count=" + this.mReferenceCount;
            }
        }
    }

    private final class WakeLock
    implements IBinder.DeathRecipient {
        public final IBinder mLock;
        public int mFlags;
        public String mTag;
        public final String mPackageName;
        public WorkSource mWorkSource;
        public String mHistoryTag;
        public final int mOwnerUid;
        public final int mOwnerPid;
        public boolean mNotifiedAcquired;

        public WakeLock(IBinder lock, int flags, String tag, String packageName, WorkSource workSource, String historyTag, int ownerUid, int ownerPid) {
            this.mLock = lock;
            this.mFlags = flags;
            this.mTag = tag;
            this.mPackageName = packageName;
            this.mWorkSource = PowerManagerService.copyWorkSource(workSource);
            this.mHistoryTag = historyTag;
            this.mOwnerUid = ownerUid;
            this.mOwnerPid = ownerPid;
        }

        @Override
        public void binderDied() {
            PowerManagerService.this.handleWakeLockDeath(this);
        }

        public boolean hasSameProperties(int flags, String tag, WorkSource workSource, int ownerUid, int ownerPid) {
            return this.mFlags == flags && this.mTag.equals(tag) && this.hasSameWorkSource(workSource) && this.mOwnerUid == ownerUid && this.mOwnerPid == ownerPid;
        }

        public void updateProperties(int flags, String tag, String packageName, WorkSource workSource, String historyTag, int ownerUid, int ownerPid) {
            if (!this.mPackageName.equals(packageName)) {
                throw new IllegalStateException("Existing wake lock package name changed: " + this.mPackageName + " to " + packageName);
            }
            if (this.mOwnerUid != ownerUid) {
                throw new IllegalStateException("Existing wake lock uid changed: " + this.mOwnerUid + " to " + ownerUid);
            }
            if (this.mOwnerPid != ownerPid) {
                throw new IllegalStateException("Existing wake lock pid changed: " + this.mOwnerPid + " to " + ownerPid);
            }
            this.mFlags = flags;
            this.mTag = tag;
            this.updateWorkSource(workSource);
            this.mHistoryTag = historyTag;
        }

        public boolean hasSameWorkSource(WorkSource workSource) {
            return Objects.equal(this.mWorkSource, workSource);
        }

        public void updateWorkSource(WorkSource workSource) {
            this.mWorkSource = PowerManagerService.copyWorkSource(workSource);
        }

        public String toString() {
            return this.getLockLevelString() + " '" + this.mTag + "'" + this.getLockFlagsString() + " (uid=" + this.mOwnerUid + ", pid=" + this.mOwnerPid + ", ws=" + this.mWorkSource + ")";
        }

        private String getLockLevelString() {
            switch (this.mFlags & 0xFFFF) {
                case 26: {
                    return "FULL_WAKE_LOCK                ";
                }
                case 10: {
                    return "SCREEN_BRIGHT_WAKE_LOCK       ";
                }
                case 6: {
                    return "SCREEN_DIM_WAKE_LOCK          ";
                }
                case 1: {
                    return "PARTIAL_WAKE_LOCK             ";
                }
                case 32: {
                    return "PROXIMITY_SCREEN_OFF_WAKE_LOCK";
                }
                case 64: {
                    return "DOZE_WAKE_LOCK                ";
                }
            }
            return "???                           ";
        }

        private String getLockFlagsString() {
            String result = "";
            if ((this.mFlags & 0x10000000) != 0) {
                result = result + " ACQUIRE_CAUSES_WAKEUP";
            }
            if ((this.mFlags & 0x20000000) != 0) {
                result = result + " ON_AFTER_RELEASE";
            }
            return result;
        }
    }

    private final class PowerManagerHandler
    extends Handler {
        public PowerManagerHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PowerManagerService.this.handleUserActivityTimeout();
                    break;
                }
                case 2: {
                    PowerManagerService.this.handleSandman();
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleSettingsChangedLocked();
            }
        }
    }

    private final class DockReceiver
    extends BroadcastReceiver {
        private DockReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                int dockState = intent.getIntExtra("android.intent.extra.DOCK_STATE", 0);
                if (PowerManagerService.this.mDockState != dockState) {
                    PowerManagerService.this.mDockState = dockState;
                    PowerManagerService.this.mDirty |= 1024;
                    PowerManagerService.this.updatePowerStateLocked();
                }
            }
        }
    }

    private final class UserSwitchedReceiver
    extends BroadcastReceiver {
        private UserSwitchedReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleSettingsChangedLocked();
            }
        }
    }

    private final class DreamReceiver
    extends BroadcastReceiver {
        private DreamReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.scheduleSandmanLocked();
            }
        }
    }

    private final class BatteryReceiver
    extends BroadcastReceiver {
        private BatteryReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = PowerManagerService.this.mLock;
            synchronized (object) {
                PowerManagerService.this.handleBatteryStateChangedLocked();
            }
        }
    }
}

