/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.statusbar;

import android.content.Context;
import android.content.res.Resources;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.statusbar.IStatusBar;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.statusbar.StatusBarIcon;
import com.android.internal.statusbar.StatusBarIconList;
import com.android.server.LocalServices;
import com.android.server.notification.NotificationDelegate;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class StatusBarManagerService
extends IStatusBarService.Stub {
    private static final String TAG = "StatusBarManagerService";
    private static final boolean SPEW = false;
    private final Context mContext;
    private final WindowManagerService mWindowManager;
    private Handler mHandler = new Handler();
    private NotificationDelegate mNotificationDelegate;
    private volatile IStatusBar mBar;
    private StatusBarIconList mIcons = new StatusBarIconList();
    private final ArrayList<DisableRecord> mDisableRecords = new ArrayList();
    private IBinder mSysUiVisToken = new Binder();
    private int mDisabled = 0;
    private Object mLock = new Object();
    private int mSystemUiVisibility = 0;
    private boolean mMenuVisible = false;
    private int mImeWindowVis = 0;
    private int mImeBackDisposition;
    private boolean mShowImeSwitcher;
    private IBinder mImeToken = null;
    private int mCurrentUserId;
    private final StatusBarManagerInternal mInternalService = new StatusBarManagerInternal(){
        private boolean mNotificationLightOn;

        @Override
        public void setNotificationDelegate(NotificationDelegate delegate) {
            StatusBarManagerService.this.mNotificationDelegate = delegate;
        }

        @Override
        public void buzzBeepBlinked() {
            if (StatusBarManagerService.this.mBar != null) {
                try {
                    StatusBarManagerService.this.mBar.buzzBeepBlinked();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void notificationLightPulse(int argb, int onMillis, int offMillis) {
            this.mNotificationLightOn = true;
            if (StatusBarManagerService.this.mBar != null) {
                try {
                    StatusBarManagerService.this.mBar.notificationLightPulse(argb, onMillis, offMillis);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void notificationLightOff() {
            if (this.mNotificationLightOn) {
                this.mNotificationLightOn = false;
                if (StatusBarManagerService.this.mBar != null) {
                    try {
                        StatusBarManagerService.this.mBar.notificationLightOff();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    };

    public StatusBarManagerService(Context context, WindowManagerService windowManager) {
        this.mContext = context;
        this.mWindowManager = windowManager;
        Resources res = context.getResources();
        this.mIcons.defineSlots(res.getStringArray(17235978));
        LocalServices.addService(StatusBarManagerInternal.class, this.mInternalService);
    }

    @Override
    public void expandNotificationsPanel() {
        this.enforceExpandStatusBar();
        if (this.mBar != null) {
            try {
                this.mBar.animateExpandNotificationsPanel();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void collapsePanels() {
        this.enforceExpandStatusBar();
        if (this.mBar != null) {
            try {
                this.mBar.animateCollapsePanels();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void expandSettingsPanel() {
        this.enforceExpandStatusBar();
        if (this.mBar != null) {
            try {
                this.mBar.animateExpandSettingsPanel();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void disable(int what, IBinder token, String pkg) {
        this.disableInternal(this.mCurrentUserId, what, token, pkg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableInternal(int userId, int what, IBinder token, String pkg) {
        this.enforceStatusBar();
        Object object = this.mLock;
        synchronized (object) {
            this.disableLocked(userId, what, token, pkg);
        }
    }

    private void disableLocked(int userId, int what, IBinder token, String pkg) {
        this.manageDisableListLocked(userId, what, token, pkg);
        final int net = this.gatherDisableActionsLocked(this.mCurrentUserId);
        if (net != this.mDisabled) {
            this.mDisabled = net;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    StatusBarManagerService.this.mNotificationDelegate.onSetDisabled(net);
                }
            });
            if (this.mBar != null) {
                try {
                    this.mBar.disable(net);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIcon(String slot, String iconPackage, int iconId, int iconLevel, String contentDescription) {
        this.enforceStatusBar();
        StatusBarIconList statusBarIconList = this.mIcons;
        synchronized (statusBarIconList) {
            int index = this.mIcons.getSlotIndex(slot);
            if (index < 0) {
                throw new SecurityException("invalid status bar icon slot: " + slot);
            }
            StatusBarIcon icon = new StatusBarIcon(iconPackage, UserHandle.OWNER, iconId, iconLevel, 0, contentDescription);
            this.mIcons.setIcon(index, icon);
            if (this.mBar != null) {
                try {
                    this.mBar.setIcon(index, icon);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIconVisibility(String slot, boolean visible) {
        this.enforceStatusBar();
        StatusBarIconList statusBarIconList = this.mIcons;
        synchronized (statusBarIconList) {
            int index = this.mIcons.getSlotIndex(slot);
            if (index < 0) {
                throw new SecurityException("invalid status bar icon slot: " + slot);
            }
            StatusBarIcon icon = this.mIcons.getIcon(index);
            if (icon == null) {
                return;
            }
            if (icon.visible != visible) {
                icon.visible = visible;
                if (this.mBar != null) {
                    try {
                        this.mBar.setIcon(index, icon);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIcon(String slot) {
        this.enforceStatusBar();
        StatusBarIconList statusBarIconList = this.mIcons;
        synchronized (statusBarIconList) {
            int index = this.mIcons.getSlotIndex(slot);
            if (index < 0) {
                throw new SecurityException("invalid status bar icon slot: " + slot);
            }
            this.mIcons.removeIcon(index);
            if (this.mBar != null) {
                try {
                    this.mBar.removeIcon(index);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void topAppWindowChanged(final boolean menuVisible) {
        this.enforceStatusBar();
        Object object = this.mLock;
        synchronized (object) {
            this.mMenuVisible = menuVisible;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (StatusBarManagerService.this.mBar != null) {
                        try {
                            StatusBarManagerService.this.mBar.topAppWindowChanged(menuVisible);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImeWindowStatus(final IBinder token, final int vis, final int backDisposition, final boolean showImeSwitcher) {
        this.enforceStatusBar();
        Object object = this.mLock;
        synchronized (object) {
            this.mImeWindowVis = vis;
            this.mImeBackDisposition = backDisposition;
            this.mImeToken = token;
            this.mShowImeSwitcher = showImeSwitcher;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (StatusBarManagerService.this.mBar != null) {
                        try {
                            StatusBarManagerService.this.mBar.setImeWindowStatus(token, vis, backDisposition, showImeSwitcher);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemUiVisibility(int vis, int mask) {
        this.enforceStatusBarService();
        Object object = this.mLock;
        synchronized (object) {
            this.updateUiVisibilityLocked(vis, mask);
            this.disableLocked(this.mCurrentUserId, vis & 0x3FF0000, this.mSysUiVisToken, "WindowManager.LayoutParams");
        }
    }

    private void updateUiVisibilityLocked(final int vis, final int mask) {
        if (this.mSystemUiVisibility != vis) {
            this.mSystemUiVisibility = vis;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (StatusBarManagerService.this.mBar != null) {
                        try {
                            StatusBarManagerService.this.mBar.setSystemUiVisibility(vis, mask);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    @Override
    public void toggleRecentApps() {
        if (this.mBar != null) {
            try {
                this.mBar.toggleRecentApps();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void preloadRecentApps() {
        if (this.mBar != null) {
            try {
                this.mBar.preloadRecentApps();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void cancelPreloadRecentApps() {
        if (this.mBar != null) {
            try {
                this.mBar.cancelPreloadRecentApps();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void showRecentApps(boolean triggeredFromAltTab) {
        if (this.mBar != null) {
            try {
                this.mBar.showRecentApps(triggeredFromAltTab);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void hideRecentApps(boolean triggeredFromAltTab, boolean triggeredFromHomeKey) {
        if (this.mBar != null) {
            try {
                this.mBar.hideRecentApps(triggeredFromAltTab, triggeredFromHomeKey);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setCurrentUser(int newUserId) {
        this.mCurrentUserId = newUserId;
    }

    @Override
    public void setWindowState(int window, int state) {
        if (this.mBar != null) {
            try {
                this.mBar.setWindowState(window, state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void enforceStatusBar() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR", TAG);
    }

    private void enforceExpandStatusBar() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.EXPAND_STATUS_BAR", TAG);
    }

    private void enforceStatusBarService() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.STATUS_BAR_SERVICE", TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerStatusBar(IStatusBar bar, StatusBarIconList iconList, int[] switches, List<IBinder> binders) {
        this.enforceStatusBarService();
        Slog.i(TAG, "registerStatusBar bar=" + bar);
        this.mBar = bar;
        Object object = this.mIcons;
        synchronized (object) {
            iconList.copyFrom(this.mIcons);
        }
        object = this.mLock;
        synchronized (object) {
            switches[0] = this.gatherDisableActionsLocked(this.mCurrentUserId);
            switches[1] = this.mSystemUiVisibility;
            switches[2] = this.mMenuVisible ? 1 : 0;
            switches[3] = this.mImeWindowVis;
            switches[4] = this.mImeBackDisposition;
            switches[5] = this.mShowImeSwitcher ? 1 : 0;
            binders.add(this.mImeToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPanelRevealed() {
        this.enforceStatusBarService();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onPanelRevealed();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPanelHidden() throws RemoteException {
        this.enforceStatusBarService();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onPanelHidden();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotificationClick(String key) {
        this.enforceStatusBarService();
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onNotificationClick(callingUid, callingPid, key);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotificationError(String pkg, String tag, int id2, int uid, int initialPid, String message, int userId) {
        this.enforceStatusBarService();
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onNotificationError(callingUid, callingPid, pkg, tag, id2, uid, initialPid, message, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotificationClear(String pkg, String tag, int id2, int userId) {
        this.enforceStatusBarService();
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onNotificationClear(callingUid, callingPid, pkg, tag, id2, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotificationVisibilityChanged(String[] newlyVisibleKeys, String[] noLongerVisibleKeys) throws RemoteException {
        this.enforceStatusBarService();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onNotificationVisibilityChanged(newlyVisibleKeys, noLongerVisibleKeys);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded) throws RemoteException {
        this.enforceStatusBarService();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onNotificationExpansionChanged(key, userAction, expanded);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClearAllNotifications(int userId) {
        this.enforceStatusBarService();
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        long identity = Binder.clearCallingIdentity();
        try {
            this.mNotificationDelegate.onClearAll(callingUid, callingPid, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    void manageDisableListLocked(int userId, int what, IBinder token, String pkg) {
        int i;
        int N = this.mDisableRecords.size();
        DisableRecord tok = null;
        for (i = 0; i < N; ++i) {
            DisableRecord t = this.mDisableRecords.get(i);
            if (t.token != token || t.userId != userId) continue;
            tok = t;
            break;
        }
        if (what == 0 || !token.isBinderAlive()) {
            if (tok != null) {
                this.mDisableRecords.remove(i);
                tok.token.unlinkToDeath(tok, 0);
            }
        } else {
            if (tok == null) {
                tok = new DisableRecord();
                tok.userId = userId;
                try {
                    token.linkToDeath(tok, 0);
                }
                catch (RemoteException ex) {
                    return;
                }
                this.mDisableRecords.add(tok);
            }
            tok.what = what;
            tok.token = token;
            tok.pkg = pkg;
        }
    }

    int gatherDisableActionsLocked(int userId) {
        int N = this.mDisableRecords.size();
        int net = 0;
        for (int i = 0; i < N; ++i) {
            DisableRecord rec = this.mDisableRecords.get(i);
            if (rec.userId != userId) continue;
            net |= rec.what;
        }
        return net;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump StatusBar from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mIcons;
        synchronized (object) {
            this.mIcons.dump(pw);
        }
        object = this.mLock;
        synchronized (object) {
            pw.println("  mDisabled=0x" + Integer.toHexString(this.mDisabled));
            int N = this.mDisableRecords.size();
            pw.println("  mDisableRecords.size=" + N);
            for (int i = 0; i < N; ++i) {
                DisableRecord tok = this.mDisableRecords.get(i);
                pw.println("    [" + i + "] userId=" + tok.userId + " what=0x" + Integer.toHexString(tok.what) + " pkg=" + tok.pkg + " token=" + tok.token);
            }
        }
    }

    private class DisableRecord
    implements IBinder.DeathRecipient {
        int userId;
        String pkg;
        int what;
        IBinder token;

        private DisableRecord() {
        }

        @Override
        public void binderDied() {
            Slog.i(StatusBarManagerService.TAG, "binder died for pkg=" + this.pkg);
            StatusBarManagerService.this.disableInternal(this.userId, 0, this.token, this.pkg);
            this.token.unlinkToDeath(this, 0);
        }
    }
}

