/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.trust;

import android.app.ActivityManagerNative;
import android.app.admin.DevicePolicyManager;
import android.app.trust.ITrustListener;
import android.app.trust.ITrustManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.content.PackageMonitor;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.SystemService;
import com.android.server.trust.TrustAgentWrapper;
import com.android.server.trust.TrustArchive;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TrustManagerService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = "TrustManagerService";
    private static final Intent TRUST_AGENT_INTENT = new Intent("android.service.trust.TrustAgentService");
    private static final String PERMISSION_PROVIDE_AGENT = "android.permission.PROVIDE_TRUST_AGENT";
    private static final int MSG_REGISTER_LISTENER = 1;
    private static final int MSG_UNREGISTER_LISTENER = 2;
    private static final int MSG_DISPATCH_UNLOCK_ATTEMPT = 3;
    private static final int MSG_ENABLED_AGENTS_CHANGED = 4;
    private static final int MSG_REQUIRE_CREDENTIAL_ENTRY = 5;
    private final ArraySet<AgentInfo> mActiveAgents = new ArraySet();
    private final ArrayList<ITrustListener> mTrustListeners = new ArrayList();
    private final Receiver mReceiver = new Receiver();
    private final SparseBooleanArray mUserHasAuthenticatedSinceBoot = new SparseBooleanArray();
    final TrustArchive mArchive = new TrustArchive();
    private final Context mContext;
    private final LockPatternUtils mLockPatternUtils;
    private UserManager mUserManager;
    private final IBinder mService = new ITrustManager.Stub(){

        @Override
        public void reportUnlockAttempt(boolean authenticated, int userId) throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.obtainMessage(3, authenticated ? 1 : 0, userId).sendToTarget();
        }

        @Override
        public void reportEnabledTrustAgentsChanged(int userId) throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.removeMessages(4);
            TrustManagerService.this.mHandler.sendEmptyMessage(4);
        }

        @Override
        public void reportRequireCredentialEntry(int userId) throws RemoteException {
            this.enforceReportPermission();
            if (userId != -1 && userId < 0) {
                throw new IllegalArgumentException("userId must be an explicit user id or USER_ALL");
            }
            TrustManagerService.this.mHandler.obtainMessage(5, userId, 0).sendToTarget();
        }

        @Override
        public void registerTrustListener(ITrustListener trustListener) throws RemoteException {
            this.enforceListenerPermission();
            TrustManagerService.this.mHandler.obtainMessage(1, trustListener).sendToTarget();
        }

        @Override
        public void unregisterTrustListener(ITrustListener trustListener) throws RemoteException {
            this.enforceListenerPermission();
            TrustManagerService.this.mHandler.obtainMessage(2, trustListener).sendToTarget();
        }

        private void enforceReportPermission() {
            TrustManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_KEYGUARD_SECURE_STORAGE", "reporting trust events");
        }

        private void enforceListenerPermission() {
            TrustManagerService.this.mContext.enforceCallingPermission("android.permission.TRUST_LISTENER", "register trust listener");
        }

        @Override
        protected void dump(FileDescriptor fd, final PrintWriter fout, String[] args) {
            UserInfo currentUser;
            TrustManagerService.this.mContext.enforceCallingPermission("android.permission.DUMP", "dumping TrustManagerService");
            final List<UserInfo> userInfos = TrustManagerService.this.mUserManager.getUsers(true);
            try {
                currentUser = ActivityManagerNative.getDefault().getCurrentUser();
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            TrustManagerService.this.mHandler.runWithScissors(new Runnable(){

                @Override
                public void run() {
                    fout.println("Trust manager state:");
                    for (UserInfo user : userInfos) {
                        this.dumpUser(fout, user, user.id == currentUser.id);
                    }
                }
            }, 1500L);
        }

        private void dumpUser(PrintWriter fout, UserInfo user, boolean isCurrent) {
            fout.printf(" User \"%s\" (id=%d, flags=%#x)", user.name, user.id, user.flags);
            if (isCurrent) {
                fout.print(" (current)");
            }
            fout.print(": trusted=" + this.dumpBool(TrustManagerService.this.aggregateIsTrusted(user.id)));
            fout.print(", trustManaged=" + this.dumpBool(TrustManagerService.this.aggregateIsTrustManaged(user.id)));
            fout.println();
            fout.println("   Enabled agents:");
            boolean duplicateSimpleNames = false;
            ArraySet<String> simpleNames = new ArraySet<String>();
            for (AgentInfo info : TrustManagerService.this.mActiveAgents) {
                if (info.userId != user.id) continue;
                boolean trusted = info.agent.isTrusted();
                fout.print("    ");
                fout.println(info.component.flattenToShortString());
                fout.print("     bound=" + this.dumpBool(info.agent.isBound()));
                fout.print(", connected=" + this.dumpBool(info.agent.isConnected()));
                fout.print(", managingTrust=" + this.dumpBool(info.agent.isManagingTrust()));
                fout.print(", trusted=" + this.dumpBool(trusted));
                fout.println();
                if (trusted) {
                    fout.println("      message=\"" + info.agent.getMessage() + "\"");
                }
                if (!info.agent.isConnected()) {
                    String restartTime = TrustArchive.formatDuration(info.agent.getScheduledRestartUptimeMillis() - SystemClock.uptimeMillis());
                    fout.println("      restartScheduledAt=" + restartTime);
                }
                if (simpleNames.add(TrustArchive.getSimpleName(info.component))) continue;
                duplicateSimpleNames = true;
            }
            fout.println("   Events:");
            TrustManagerService.this.mArchive.dump(fout, 50, user.id, "    ", duplicateSimpleNames);
            fout.println();
        }

        private String dumpBool(boolean b) {
            return b ? "1" : "0";
        }
    };
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TrustManagerService.this.addListener((ITrustListener)msg.obj);
                    break;
                }
                case 2: {
                    TrustManagerService.this.removeListener((ITrustListener)msg.obj);
                    break;
                }
                case 3: {
                    TrustManagerService.this.dispatchUnlockAttempt(msg.arg1 != 0, msg.arg2);
                    break;
                }
                case 4: {
                    TrustManagerService.this.refreshAgentList(-1);
                    break;
                }
                case 5: {
                    TrustManagerService.this.requireCredentialEntry(msg.arg1);
                }
            }
        }
    };
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        @Override
        public void onSomePackagesChanged() {
            TrustManagerService.this.refreshAgentList(-1);
        }

        @Override
        public boolean onPackageChanged(String packageName, int uid, String[] components) {
            return true;
        }

        @Override
        public void onPackageDisappeared(String packageName, int reason) {
            TrustManagerService.this.removeAgentsOfPackage(packageName);
        }
    };

    public TrustManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mLockPatternUtils = new LockPatternUtils(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("trust", this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500 && !this.isSafeMode()) {
            this.mPackageMonitor.register(this.mContext, this.mHandler.getLooper(), UserHandle.ALL, true);
            this.mReceiver.register(this.mContext);
            this.refreshAgentList(-1);
        } else if (phase == 1000 && !this.isSafeMode()) {
            this.maybeEnableFactoryTrustAgents(this.mLockPatternUtils, 0);
        }
    }

    private void updateTrustAll() {
        List<UserInfo> userInfos = this.mUserManager.getUsers(true);
        for (UserInfo userInfo : userInfos) {
            this.updateTrust(userInfo.id, false);
        }
    }

    public void updateTrust(int userId, boolean initiatedByUser) {
        this.dispatchOnTrustManagedChanged(this.aggregateIsTrustManaged(userId), userId);
        this.dispatchOnTrustChanged(this.aggregateIsTrusted(userId), userId, initiatedByUser);
    }

    /*
     * WARNING - void declaration
     */
    void refreshAgentList(int userId) {
        void var7_10;
        List<Object> userInfos;
        if (userId != -1 && userId < 0) {
            Log.e(TAG, "refreshAgentList(userId=" + userId + "): Invalid user handle," + " must be USER_ALL or a specific user.", new Throwable("here"));
            userId = -1;
        }
        PackageManager pm = this.mContext.getPackageManager();
        if (userId == -1) {
            userInfos = this.mUserManager.getUsers(true);
        } else {
            userInfos = new ArrayList();
            userInfos.add(this.mUserManager.getUserInfo(userId));
        }
        LockPatternUtils lockPatternUtils = this.mLockPatternUtils;
        ArraySet<AgentInfo> obsoleteAgents = new ArraySet<AgentInfo>();
        obsoleteAgents.addAll(this.mActiveAgents);
        for (UserInfo userInfo : userInfos) {
            if (!userInfo.supportsSwitchTo() || lockPatternUtils.getKeyguardStoredPasswordQuality(userInfo.id) == 0 || !this.mUserHasAuthenticatedSinceBoot.get(userInfo.id)) continue;
            DevicePolicyManager dpm = lockPatternUtils.getDevicePolicyManager();
            int disabledFeatures = dpm.getKeyguardDisabledFeatures(null, userInfo.id);
            boolean disableTrustAgents = (disabledFeatures & 0x10) != 0;
            List<ComponentName> enabledAgents = lockPatternUtils.getEnabledTrustAgents(userInfo.id);
            if (enabledAgents == null) continue;
            List<ResolveInfo> resolveInfos = this.resolveAllowedTrustAgents(pm, userInfo.id);
            for (ResolveInfo resolveInfo : resolveInfos) {
                List<String> features;
                ComponentName name = this.getComponentName(resolveInfo);
                if (!enabledAgents.contains(name) || disableTrustAgents && ((features = dpm.getTrustAgentFeaturesEnabled(null, name)) == null || features.isEmpty())) continue;
                AgentInfo agentInfo = new AgentInfo();
                agentInfo.component = name;
                agentInfo.userId = userInfo.id;
                if (!this.mActiveAgents.contains(agentInfo)) {
                    agentInfo.label = resolveInfo.loadLabel(pm);
                    agentInfo.icon = resolveInfo.loadIcon(pm);
                    agentInfo.settings = this.getSettingsComponentName(pm, resolveInfo);
                    agentInfo.agent = new TrustAgentWrapper(this.mContext, this, new Intent().setComponent(name), userInfo.getUserHandle());
                    this.mActiveAgents.add(agentInfo);
                    continue;
                }
                obsoleteAgents.remove(agentInfo);
            }
        }
        boolean trustMayHaveChanged = false;
        boolean bl = false;
        while (var7_10 < obsoleteAgents.size()) {
            AgentInfo info = (AgentInfo)obsoleteAgents.valueAt((int)var7_10);
            if (userId == -1 || userId == info.userId) {
                if (info.agent.isManagingTrust()) {
                    trustMayHaveChanged = true;
                }
                info.agent.unbind();
                this.mActiveAgents.remove(info);
            }
            ++var7_10;
        }
        if (trustMayHaveChanged) {
            this.updateTrustAll();
        }
    }

    void updateDevicePolicyFeatures() {
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!info.agent.isConnected()) continue;
            info.agent.updateDevicePolicyFeatures();
        }
    }

    private void removeAgentsOfPackage(String packageName) {
        boolean trustMayHaveChanged = false;
        for (int i = this.mActiveAgents.size() - 1; i >= 0; --i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!packageName.equals(info.component.getPackageName())) continue;
            Log.i(TAG, "Resetting agent " + info.component.flattenToShortString());
            if (info.agent.isManagingTrust()) {
                trustMayHaveChanged = true;
            }
            info.agent.unbind();
            this.mActiveAgents.removeAt(i);
        }
        if (trustMayHaveChanged) {
            this.updateTrustAll();
        }
    }

    public void resetAgent(ComponentName name, int userId) {
        boolean trustMayHaveChanged = false;
        for (int i = this.mActiveAgents.size() - 1; i >= 0; --i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!name.equals(info.component) || userId != info.userId) continue;
            Log.i(TAG, "Resetting agent " + info.component.flattenToShortString());
            if (info.agent.isManagingTrust()) {
                trustMayHaveChanged = true;
            }
            info.agent.unbind();
            this.mActiveAgents.removeAt(i);
        }
        if (trustMayHaveChanged) {
            this.updateTrust(userId, false);
        }
        this.refreshAgentList(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentName getSettingsComponentName(PackageManager pm, ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.metaData == null) {
            return null;
        }
        String cn = null;
        Exception caughtException = null;
        try (XmlResourceParser parser = null;){
            int type;
            parser = resolveInfo.serviceInfo.loadXmlMetaData(pm, "android.service.trust.trustagent");
            if (parser == null) {
                Slog.w(TAG, "Can't find android.service.trust.trustagent meta-data");
                ComponentName componentName = null;
                return componentName;
            }
            Resources res = pm.getResourcesForApplication(resolveInfo.serviceInfo.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"trust-agent".equals(nodeName)) {
                Slog.w(TAG, "Meta-data does not start with trust-agent tag");
                ComponentName componentName = null;
                return componentName;
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.TrustAgent);
            cn = sa.getString(2);
            sa.recycle();
        }
        if (caughtException != null) {
            Slog.w(TAG, "Error parsing : " + resolveInfo.serviceInfo.packageName, caughtException);
            return null;
        }
        if (cn == null) {
            return null;
        }
        if (cn.indexOf(47) < 0) {
            cn = resolveInfo.serviceInfo.packageName + "/" + cn;
        }
        return ComponentName.unflattenFromString(cn);
    }

    private ComponentName getComponentName(ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            return null;
        }
        return new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
    }

    private void maybeEnableFactoryTrustAgents(LockPatternUtils utils, int userId) {
        if (0 != Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "trust_agents_initialized", 0, userId)) {
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> resolveInfos = this.resolveAllowedTrustAgents(pm, userId);
        ArraySet<ComponentName> discoveredAgents = new ArraySet<ComponentName>();
        for (ResolveInfo resolveInfo : resolveInfos) {
            ComponentName componentName = this.getComponentName(resolveInfo);
            int applicationInfoFlags = resolveInfo.serviceInfo.applicationInfo.flags;
            if ((applicationInfoFlags & 1) == 0) {
                Log.i(TAG, "Leaving agent " + componentName + " disabled because package " + "is not a system package.");
                continue;
            }
            discoveredAgents.add(componentName);
        }
        List<ComponentName> previouslyEnabledAgents = utils.getEnabledTrustAgents(userId);
        if (previouslyEnabledAgents != null) {
            discoveredAgents.addAll(previouslyEnabledAgents);
        }
        utils.setEnabledTrustAgents(discoveredAgents, userId);
        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "trust_agents_initialized", 1, userId);
    }

    private List<ResolveInfo> resolveAllowedTrustAgents(PackageManager pm, int userId) {
        List<ResolveInfo> resolveInfos = pm.queryIntentServicesAsUser(TRUST_AGENT_INTENT, 0, userId);
        ArrayList<ResolveInfo> allowedAgents = new ArrayList<ResolveInfo>(resolveInfos.size());
        for (ResolveInfo resolveInfo : resolveInfos) {
            if (resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null) continue;
            String packageName = resolveInfo.serviceInfo.packageName;
            if (pm.checkPermission(PERMISSION_PROVIDE_AGENT, packageName) != 0) {
                ComponentName name = this.getComponentName(resolveInfo);
                Log.w(TAG, "Skipping agent " + name + " because package does not have" + " permission " + PERMISSION_PROVIDE_AGENT + ".");
                continue;
            }
            allowedAgents.add(resolveInfo);
        }
        return allowedAgents;
    }

    private boolean aggregateIsTrusted(int userId) {
        if (!this.mUserHasAuthenticatedSinceBoot.get(userId)) {
            return false;
        }
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId || !info.agent.isTrusted()) continue;
            return true;
        }
        return false;
    }

    private boolean aggregateIsTrustManaged(int userId) {
        if (!this.mUserHasAuthenticatedSinceBoot.get(userId)) {
            return false;
        }
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId || !info.agent.isManagingTrust()) continue;
            return true;
        }
        return false;
    }

    private void dispatchUnlockAttempt(boolean successful, int userId) {
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId) continue;
            info.agent.onUnlockAttempt(successful);
        }
        if (successful) {
            this.updateUserHasAuthenticated(userId);
        }
    }

    private void updateUserHasAuthenticated(int userId) {
        if (!this.mUserHasAuthenticatedSinceBoot.get(userId)) {
            this.mUserHasAuthenticatedSinceBoot.put(userId, true);
            this.refreshAgentList(userId);
        }
    }

    private void requireCredentialEntry(int userId) {
        if (userId == -1) {
            this.mUserHasAuthenticatedSinceBoot.clear();
            this.refreshAgentList(-1);
        } else {
            this.mUserHasAuthenticatedSinceBoot.put(userId, false);
            this.refreshAgentList(userId);
        }
    }

    private void addListener(ITrustListener listener) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            if (this.mTrustListeners.get(i).asBinder() != listener.asBinder()) continue;
            return;
        }
        this.mTrustListeners.add(listener);
        this.updateTrustAll();
    }

    private void removeListener(ITrustListener listener) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            if (this.mTrustListeners.get(i).asBinder() != listener.asBinder()) continue;
            this.mTrustListeners.remove(i);
            return;
        }
    }

    private void dispatchOnTrustChanged(boolean enabled, int userId, boolean initiatedByUser) {
        if (!enabled) {
            initiatedByUser = false;
        }
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            try {
                this.mTrustListeners.get(i).onTrustChanged(enabled, userId, initiatedByUser);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead TrustListener.");
                this.mTrustListeners.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying TrustListener.", e);
            }
        }
    }

    private void dispatchOnTrustManagedChanged(boolean managed, int userId) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            try {
                this.mTrustListeners.get(i).onTrustManagedChanged(managed, userId);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead TrustListener.");
                this.mTrustListeners.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying TrustListener.", e);
            }
        }
    }

    private class Receiver
    extends BroadcastReceiver {
        private Receiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED".equals(action)) {
                TrustManagerService.this.refreshAgentList(this.getSendingUserId());
                TrustManagerService.this.updateDevicePolicyFeatures();
            } else if ("android.intent.action.USER_PRESENT".equals(action)) {
                TrustManagerService.this.updateUserHasAuthenticated(this.getSendingUserId());
            } else if ("android.intent.action.USER_ADDED".equals(action)) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -100);
                if (userId > 0) {
                    TrustManagerService.this.maybeEnableFactoryTrustAgents(TrustManagerService.this.mLockPatternUtils, userId);
                } else {
                    Log.wtf(TrustManagerService.TAG, "EXTRA_USER_HANDLE missing or invalid, value=" + userId);
                }
            }
        }

        public void register(Context context) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
            filter.addAction("android.intent.action.USER_PRESENT");
            filter.addAction("android.intent.action.USER_ADDED");
            context.registerReceiverAsUser(this, UserHandle.ALL, filter, null, null);
        }
    }

    private static final class AgentInfo {
        CharSequence label;
        Drawable icon;
        ComponentName component;
        ComponentName settings;
        TrustAgentWrapper agent;
        int userId;

        private AgentInfo() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof AgentInfo)) {
                return false;
            }
            AgentInfo o = (AgentInfo)other;
            return this.component.equals(o.component) && this.userId == o.userId;
        }

        public int hashCode() {
            return this.component.hashCode() * 31 + this.userId;
        }
    }
}

