/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.content.Context;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiHotplugEvent;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiDeviceEventListener;
import android.hardware.hdmi.IHdmiHotplugEventListener;
import android.hardware.hdmi.IHdmiSystemAudioModeChangeListener;
import android.media.AudioDevicePort;
import android.media.AudioGain;
import android.media.AudioGainConfig;
import android.media.AudioManager;
import android.media.AudioPatch;
import android.media.AudioPort;
import android.media.AudioPortConfig;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.Surface;
import com.android.internal.os.SomeArgs;
import com.android.server.tv.TvInputHal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class TvInputHardwareManager
implements TvInputHal.Callback {
    private static final String TAG = TvInputHardwareManager.class.getSimpleName();
    private final Listener mListener;
    private final TvInputHal mHal = new TvInputHal(this);
    private final SparseArray<Connection> mConnections = new SparseArray();
    private final List<TvInputHardwareInfo> mHardwareList = new ArrayList<TvInputHardwareInfo>();
    private final List<HdmiDeviceInfo> mHdmiDeviceList = new LinkedList<HdmiDeviceInfo>();
    private final SparseArray<String> mHardwareInputIdMap = new SparseArray();
    private final SparseArray<String> mHdmiInputIdMap = new SparseArray();
    private final Map<String, TvInputInfo> mInputMap = new ArrayMap<String, TvInputInfo>();
    private final AudioManager mAudioManager;
    private IHdmiControlService mHdmiControlService;
    private final IHdmiHotplugEventListener mHdmiHotplugEventListener = new HdmiHotplugEventListener();
    private final IHdmiDeviceEventListener mHdmiDeviceEventListener = new HdmiDeviceEventListener();
    private final IHdmiSystemAudioModeChangeListener mHdmiSystemAudioModeChangeListener = new HdmiSystemAudioModeChangeListener();
    private final SparseBooleanArray mHdmiStateMap = new SparseBooleanArray();
    private final List<Message> mPendingHdmiDeviceEvents = new LinkedList<Message>();
    private final Handler mHandler = new ListenerHandler();
    private final Object mLock = new Object();

    public TvInputHardwareManager(Context context, Listener listener) {
        this.mListener = listener;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mHal.init();
    }

    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mHdmiControlService = IHdmiControlService.Stub.asInterface(ServiceManager.getService("hdmi_control"));
            if (this.mHdmiControlService != null) {
                try {
                    this.mHdmiControlService.addHotplugEventListener(this.mHdmiHotplugEventListener);
                    this.mHdmiControlService.addDeviceEventListener(this.mHdmiDeviceEventListener);
                    this.mHdmiControlService.addSystemAudioModeChangeListener(this.mHdmiSystemAudioModeChangeListener);
                    this.mHdmiDeviceList.addAll(this.mHdmiControlService.getInputDevices());
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Error registering listeners to HdmiControlService:", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceAvailable(TvInputHardwareInfo info, TvStreamConfig[] configs) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = new Connection(info);
            connection.updateConfigsLocked(configs);
            this.mConnections.put(info.getDeviceId(), connection);
            this.buildHardwareListLocked();
            this.mHandler.obtainMessage(2, 0, 0, info).sendToTarget();
            if (info.getType() == 9) {
                this.processPendingHdmiDeviceEventsLocked();
            }
        }
    }

    private void buildHardwareListLocked() {
        this.mHardwareList.clear();
        for (int i = 0; i < this.mConnections.size(); ++i) {
            this.mHardwareList.add(this.mConnections.valueAt(i).getHardwareInfoLocked());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceUnavailable(int deviceId) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "onDeviceUnavailable: Cannot find a connection with " + deviceId);
                return;
            }
            connection.resetLocked(null, null, null, null, null);
            this.mConnections.remove(deviceId);
            this.buildHardwareListLocked();
            TvInputHardwareInfo info = connection.getHardwareInfoLocked();
            if (info.getType() == 9) {
                Iterator<HdmiDeviceInfo> it = this.mHdmiDeviceList.iterator();
                while (it.hasNext()) {
                    HdmiDeviceInfo deviceInfo = it.next();
                    if (deviceInfo.getPortId() != info.getHdmiPortId()) continue;
                    this.mHandler.obtainMessage(5, 0, 0, deviceInfo).sendToTarget();
                    it.remove();
                }
            }
            this.mHandler.obtainMessage(3, 0, 0, info).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStreamConfigurationChanged(int deviceId, TvStreamConfig[] configs) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "StreamConfigurationChanged: Cannot find a connection with " + deviceId);
                return;
            }
            connection.updateConfigsLocked(configs);
            try {
                connection.getCallbackLocked().onStreamConfigChanged(configs);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "error in onStreamConfigurationChanged", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFirstFrameCaptured(int deviceId, int streamId) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "FirstFrameCaptured: Cannot find a connection with " + deviceId);
                return;
            }
            Runnable runnable = connection.getOnFirstFrameCapturedLocked();
            if (runnable != null) {
                runnable.run();
                connection.setOnFirstFrameCapturedLocked(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TvInputHardwareInfo> getHardwareList() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mHardwareList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HdmiDeviceInfo> getHdmiDeviceList() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mHdmiDeviceList);
        }
    }

    private boolean checkUidChangedLocked(Connection connection, int callingUid, int resolvedUserId) {
        Integer connectionCallingUid = connection.getCallingUidLocked();
        Integer connectionResolvedUserId = connection.getResolvedUserIdLocked();
        if (connectionCallingUid == null || connectionResolvedUserId == null) {
            return true;
        }
        return connectionCallingUid != callingUid || connectionResolvedUserId != resolvedUserId;
    }

    private int convertConnectedToState(boolean connected) {
        if (connected) {
            return 0;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHardwareTvInput(int deviceId, TvInputInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            String oldInputId = this.mHardwareInputIdMap.get(deviceId);
            if (oldInputId != null) {
                Slog.w(TAG, "Trying to override previous registration: old = " + this.mInputMap.get(oldInputId) + ":" + deviceId + ", new = " + info + ":" + deviceId);
            }
            this.mHardwareInputIdMap.put(deviceId, info.getId());
            this.mInputMap.put(info.getId(), info);
            for (int i = 0; i < this.mHdmiStateMap.size(); ++i) {
                String inputId;
                TvInputHardwareInfo hardwareInfo = this.findHardwareInfoForHdmiPortLocked(this.mHdmiStateMap.keyAt(i));
                if (hardwareInfo == null || (inputId = this.mHardwareInputIdMap.get(hardwareInfo.getDeviceId())) == null || !inputId.equals(info.getId())) continue;
                this.mHandler.obtainMessage(1, this.convertConnectedToState(this.mHdmiStateMap.valueAt(i)), 0, inputId).sendToTarget();
            }
        }
    }

    private static <T> int indexOfEqualValue(SparseArray<T> map, T value) {
        for (int i = 0; i < map.size(); ++i) {
            if (!map.valueAt(i).equals(value)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHdmiTvInput(int id2, TvInputInfo info) {
        if (info.getType() != 1007) {
            throw new IllegalArgumentException("info (" + info + ") has non-HDMI type.");
        }
        Object object = this.mLock;
        synchronized (object) {
            String parentId = info.getParentId();
            int parentIndex = TvInputHardwareManager.indexOfEqualValue(this.mHardwareInputIdMap, parentId);
            if (parentIndex < 0) {
                throw new IllegalArgumentException("info (" + info + ") has invalid parentId.");
            }
            String oldInputId = this.mHdmiInputIdMap.get(id2);
            if (oldInputId != null) {
                Slog.w(TAG, "Trying to override previous registration: old = " + this.mInputMap.get(oldInputId) + ":" + id2 + ", new = " + info + ":" + id2);
            }
            this.mHdmiInputIdMap.put(id2, info.getId());
            this.mInputMap.put(info.getId(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTvInput(String inputId) {
        Object object = this.mLock;
        synchronized (object) {
            int deviceIndex;
            this.mInputMap.remove(inputId);
            int hardwareIndex = TvInputHardwareManager.indexOfEqualValue(this.mHardwareInputIdMap, inputId);
            if (hardwareIndex >= 0) {
                this.mHardwareInputIdMap.removeAt(hardwareIndex);
            }
            if ((deviceIndex = TvInputHardwareManager.indexOfEqualValue(this.mHdmiInputIdMap, inputId)) >= 0) {
                this.mHdmiInputIdMap.removeAt(deviceIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITvInputHardware acquireHardware(int deviceId, ITvInputHardwareCallback callback, TvInputInfo info, int callingUid, int resolvedUserId) {
        if (callback == null) {
            throw new NullPointerException();
        }
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "Invalid deviceId : " + deviceId);
                return null;
            }
            if (this.checkUidChangedLocked(connection, callingUid, resolvedUserId)) {
                TvInputHardwareImpl hardware = new TvInputHardwareImpl(connection.getHardwareInfoLocked());
                try {
                    callback.asBinder().linkToDeath(connection, 0);
                }
                catch (RemoteException e) {
                    hardware.release();
                    return null;
                }
                connection.resetLocked(hardware, callback, info, callingUid, resolvedUserId);
            }
            return connection.getHardwareLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseHardware(int deviceId, ITvInputHardware hardware, int callingUid, int resolvedUserId) {
        Object object = this.mLock;
        synchronized (object) {
            Connection connection = this.mConnections.get(deviceId);
            if (connection == null) {
                Slog.e(TAG, "Invalid deviceId : " + deviceId);
                return;
            }
            if (connection.getHardwareLocked() != hardware || this.checkUidChangedLocked(connection, callingUid, resolvedUserId)) {
                return;
            }
            connection.resetLocked(null, null, null, null, null);
        }
    }

    private TvInputHardwareInfo findHardwareInfoForHdmiPortLocked(int port) {
        for (TvInputHardwareInfo hardwareInfo : this.mHardwareList) {
            if (hardwareInfo.getType() != 9 || hardwareInfo.getHdmiPortId() != port) continue;
            return hardwareInfo;
        }
        return null;
    }

    private int findDeviceIdForInputIdLocked(String inputId) {
        for (int i = 0; i < this.mConnections.size(); ++i) {
            Connection connection = this.mConnections.get(i);
            if (!connection.getInfoLocked().getId().equals(inputId)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TvStreamConfig> getAvailableTvStreamConfigList(String inputId, int callingUid, int resolvedUserId) {
        ArrayList<TvStreamConfig> configsList = new ArrayList<TvStreamConfig>();
        Object object = this.mLock;
        synchronized (object) {
            int deviceId = this.findDeviceIdForInputIdLocked(inputId);
            if (deviceId < 0) {
                Slog.e(TAG, "Invalid inputId : " + inputId);
                return configsList;
            }
            Connection connection = this.mConnections.get(deviceId);
            for (TvStreamConfig config : connection.getConfigsLocked()) {
                if (config.getType() != 2) continue;
                configsList.add(config);
            }
        }
        return configsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean captureFrame(String inputId, Surface surface, final TvStreamConfig config, int callingUid, int resolvedUserId) {
        Object object = this.mLock;
        synchronized (object) {
            int deviceId = this.findDeviceIdForInputIdLocked(inputId);
            if (deviceId < 0) {
                Slog.e(TAG, "Invalid inputId : " + inputId);
                return false;
            }
            Connection connection = this.mConnections.get(deviceId);
            final TvInputHardwareImpl hardwareImpl = connection.getHardwareImplLocked();
            if (hardwareImpl != null) {
                boolean result;
                Runnable runnable = connection.getOnFirstFrameCapturedLocked();
                if (runnable != null) {
                    runnable.run();
                    connection.setOnFirstFrameCapturedLocked(null);
                }
                if (result = hardwareImpl.startCapture(surface, config)) {
                    connection.setOnFirstFrameCapturedLocked(new Runnable(){

                        @Override
                        public void run() {
                            hardwareImpl.stopCapture(config);
                        }
                    });
                }
                return result;
            }
        }
        return false;
    }

    private void processPendingHdmiDeviceEventsLocked() {
        Iterator<Message> it = this.mPendingHdmiDeviceEvents.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            HdmiDeviceInfo deviceInfo = (HdmiDeviceInfo)msg.obj;
            TvInputHardwareInfo hardwareInfo = this.findHardwareInfoForHdmiPortLocked(deviceInfo.getPortId());
            if (hardwareInfo == null) continue;
            msg.sendToTarget();
            it.remove();
        }
    }

    private final class HdmiSystemAudioModeChangeListener
    extends IHdmiSystemAudioModeChangeListener.Stub {
        private HdmiSystemAudioModeChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(boolean enabled) throws RemoteException {
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                for (int i = 0; i < TvInputHardwareManager.this.mConnections.size(); ++i) {
                    TvInputHardwareImpl impl = ((Connection)TvInputHardwareManager.this.mConnections.valueAt(i)).getHardwareImplLocked();
                    if (impl == null) continue;
                    impl.handleAudioSinkUpdated();
                }
            }
        }
    }

    private final class HdmiDeviceEventListener
    extends IHdmiDeviceEventListener.Stub {
        private HdmiDeviceEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(HdmiDeviceInfo deviceInfo, int status) {
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                int messageType = 0;
                Object obj = null;
                switch (status) {
                    case 1: {
                        if (this.findHdmiDeviceInfo(deviceInfo.getId()) != null) {
                            Slog.w(TAG, "The list already contains " + deviceInfo + "; ignoring.");
                            return;
                        }
                        TvInputHardwareManager.this.mHdmiDeviceList.add(deviceInfo);
                        messageType = 4;
                        obj = deviceInfo;
                        break;
                    }
                    case 2: {
                        HdmiDeviceInfo originalDeviceInfo = this.findHdmiDeviceInfo(deviceInfo.getId());
                        if (!TvInputHardwareManager.this.mHdmiDeviceList.remove(originalDeviceInfo)) {
                            Slog.w(TAG, "The list doesn't contain " + deviceInfo + "; ignoring.");
                            return;
                        }
                        messageType = 5;
                        obj = deviceInfo;
                        break;
                    }
                    case 3: {
                        HdmiDeviceInfo originalDeviceInfo = this.findHdmiDeviceInfo(deviceInfo.getId());
                        if (!TvInputHardwareManager.this.mHdmiDeviceList.remove(originalDeviceInfo)) {
                            Slog.w(TAG, "The list doesn't contain " + deviceInfo + "; ignoring.");
                            return;
                        }
                        TvInputHardwareManager.this.mHdmiDeviceList.add(deviceInfo);
                        messageType = 6;
                        String inputId = (String)TvInputHardwareManager.this.mHdmiInputIdMap.get(deviceInfo.getId());
                        SomeArgs args = SomeArgs.obtain();
                        args.arg1 = inputId;
                        args.arg2 = deviceInfo;
                        obj = args;
                        break;
                    }
                }
                Message msg = TvInputHardwareManager.this.mHandler.obtainMessage(messageType, 0, 0, obj);
                if (TvInputHardwareManager.this.findHardwareInfoForHdmiPortLocked(deviceInfo.getPortId()) != null) {
                    msg.sendToTarget();
                } else {
                    TvInputHardwareManager.this.mPendingHdmiDeviceEvents.add(msg);
                }
            }
        }

        private HdmiDeviceInfo findHdmiDeviceInfo(int id2) {
            for (HdmiDeviceInfo info : TvInputHardwareManager.this.mHdmiDeviceList) {
                if (info.getId() != id2) continue;
                return info;
            }
            return null;
        }
    }

    private final class HdmiHotplugEventListener
    extends IHdmiHotplugEventListener.Stub {
        private HdmiHotplugEventListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceived(HdmiHotplugEvent event) {
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                TvInputHardwareManager.this.mHdmiStateMap.put(event.getPort(), event.isConnected());
                TvInputHardwareInfo hardwareInfo = TvInputHardwareManager.this.findHardwareInfoForHdmiPortLocked(event.getPort());
                if (hardwareInfo == null) {
                    return;
                }
                String inputId = (String)TvInputHardwareManager.this.mHardwareInputIdMap.get(hardwareInfo.getDeviceId());
                if (inputId == null) {
                    return;
                }
                TvInputHardwareManager.this.mHandler.obtainMessage(1, TvInputHardwareManager.this.convertConnectedToState(event.isConnected()), 0, inputId).sendToTarget();
            }
        }
    }

    private class ListenerHandler
    extends Handler {
        private static final int STATE_CHANGED = 1;
        private static final int HARDWARE_DEVICE_ADDED = 2;
        private static final int HARDWARE_DEVICE_REMOVED = 3;
        private static final int HDMI_DEVICE_ADDED = 4;
        private static final int HDMI_DEVICE_REMOVED = 5;
        private static final int HDMI_DEVICE_UPDATED = 6;

        private ListenerHandler() {
        }

        @Override
        public final void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    String inputId = (String)msg.obj;
                    int state = msg.arg1;
                    TvInputHardwareManager.this.mListener.onStateChanged(inputId, state);
                    break;
                }
                case 2: {
                    TvInputHardwareInfo info = (TvInputHardwareInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHardwareDeviceAdded(info);
                    break;
                }
                case 3: {
                    TvInputHardwareInfo info = (TvInputHardwareInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHardwareDeviceRemoved(info);
                    break;
                }
                case 4: {
                    HdmiDeviceInfo info = (HdmiDeviceInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHdmiDeviceAdded(info);
                    break;
                }
                case 5: {
                    HdmiDeviceInfo info = (HdmiDeviceInfo)msg.obj;
                    TvInputHardwareManager.this.mListener.onHdmiDeviceRemoved(info);
                    break;
                }
                case 6: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String inputId = (String)args.arg1;
                    HdmiDeviceInfo info = (HdmiDeviceInfo)args.arg2;
                    args.recycle();
                    TvInputHardwareManager.this.mListener.onHdmiDeviceUpdated(inputId, info);
                }
                default: {
                    Slog.w(TAG, "Unhandled message: " + msg);
                }
            }
        }
    }

    static interface Listener {
        public void onStateChanged(String var1, int var2);

        public void onHardwareDeviceAdded(TvInputHardwareInfo var1);

        public void onHardwareDeviceRemoved(TvInputHardwareInfo var1);

        public void onHdmiDeviceAdded(HdmiDeviceInfo var1);

        public void onHdmiDeviceRemoved(HdmiDeviceInfo var1);

        public void onHdmiDeviceUpdated(String var1, HdmiDeviceInfo var2);
    }

    private class TvInputHardwareImpl
    extends ITvInputHardware.Stub {
        private final TvInputHardwareInfo mInfo;
        private boolean mReleased = false;
        private final Object mImplLock = new Object();
        private final AudioManager.OnAudioPortUpdateListener mAudioListener = new AudioManager.OnAudioPortUpdateListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioPortListUpdate(AudioPort[] portList) {
                Object object = TvInputHardwareImpl.this.mImplLock;
                synchronized (object) {
                    TvInputHardwareImpl.this.updateAudioConfigLocked();
                }
            }

            @Override
            public void onAudioPatchListUpdate(AudioPatch[] patchList) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onServiceDied() {
                Object object = TvInputHardwareImpl.this.mImplLock;
                synchronized (object) {
                    TvInputHardwareImpl.this.mAudioSource = null;
                    TvInputHardwareImpl.this.mAudioSink = null;
                    TvInputHardwareImpl.this.mAudioPatch = null;
                }
            }
        };
        private int mOverrideAudioType = 0;
        private String mOverrideAudioAddress = "";
        private AudioDevicePort mAudioSource;
        private AudioDevicePort mAudioSink;
        private AudioPatch mAudioPatch = null;
        private float mCommittedVolume = 0.0f;
        private float mVolume = 0.0f;
        private TvStreamConfig mActiveConfig = null;
        private int mDesiredSamplingRate = 0;
        private int mDesiredChannelMask = 1;
        private int mDesiredFormat = 1;

        public TvInputHardwareImpl(TvInputHardwareInfo info) {
            this.mInfo = info;
            TvInputHardwareManager.this.mAudioManager.registerAudioPortUpdateListener(this.mAudioListener);
            if (this.mInfo.getAudioType() != 0) {
                this.mAudioSource = this.findAudioDevicePort(this.mInfo.getAudioType(), this.mInfo.getAudioAddress());
                this.mAudioSink = this.findAudioSinkFromAudioPolicy();
            }
        }

        private AudioDevicePort findAudioSinkFromAudioPolicy() {
            ArrayList<AudioPort> devicePorts = new ArrayList<AudioPort>();
            if (TvInputHardwareManager.this.mAudioManager.listAudioDevicePorts(devicePorts) == 0) {
                int sinkDevice = TvInputHardwareManager.this.mAudioManager.getDevicesForStream(3);
                for (AudioPort port : devicePorts) {
                    AudioDevicePort devicePort = (AudioDevicePort)port;
                    if ((devicePort.type() & sinkDevice) == 0) continue;
                    return devicePort;
                }
            }
            return null;
        }

        private AudioDevicePort findAudioDevicePort(int type, String address) {
            if (type == 0) {
                return null;
            }
            ArrayList<AudioPort> devicePorts = new ArrayList<AudioPort>();
            if (TvInputHardwareManager.this.mAudioManager.listAudioDevicePorts(devicePorts) != 0) {
                return null;
            }
            for (AudioPort port : devicePorts) {
                AudioDevicePort devicePort = (AudioDevicePort)port;
                if (devicePort.type() != type || !devicePort.address().equals(address)) continue;
                return devicePort;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object object = this.mImplLock;
            synchronized (object) {
                TvInputHardwareManager.this.mAudioManager.unregisterAudioPortUpdateListener(this.mAudioListener);
                if (this.mAudioPatch != null) {
                    TvInputHardwareManager.this.mAudioManager.releaseAudioPatch(this.mAudioPatch);
                    this.mAudioPatch = null;
                }
                this.mReleased = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setSurface(Surface surface, TvStreamConfig config) throws RemoteException {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    throw new IllegalStateException("Device already released.");
                }
                if (surface != null && config == null) {
                    return false;
                }
                if (surface == null && this.mActiveConfig == null) {
                    return false;
                }
                int result = -3;
                if (surface == null) {
                    result = TvInputHardwareManager.this.mHal.removeStream(this.mInfo.getDeviceId(), this.mActiveConfig);
                    this.mActiveConfig = null;
                } else {
                    if (config != this.mActiveConfig && this.mActiveConfig != null && (result = TvInputHardwareManager.this.mHal.removeStream(this.mInfo.getDeviceId(), this.mActiveConfig)) != 0) {
                        this.mActiveConfig = null;
                        return false;
                    }
                    result = TvInputHardwareManager.this.mHal.addStream(this.mInfo.getDeviceId(), surface, config);
                    if (result == 0) {
                        this.mActiveConfig = config;
                    }
                }
                this.updateAudioConfigLocked();
                return result == 0;
            }
        }

        private void updateAudioConfigLocked() {
            boolean shouldRecreateAudioPatch;
            boolean sinkUpdated = this.updateAudioSinkLocked();
            boolean sourceUpdated = this.updateAudioSourceLocked();
            if (this.mAudioSource == null || this.mAudioSink == null || this.mActiveConfig == null) {
                if (this.mAudioPatch != null) {
                    TvInputHardwareManager.this.mAudioManager.releaseAudioPatch(this.mAudioPatch);
                    this.mAudioPatch = null;
                }
                return;
            }
            AudioGainConfig sourceGainConfig = null;
            if (this.mAudioSource.gains().length > 0 && this.mVolume != this.mCommittedVolume) {
                AudioGain sourceGain = null;
                for (AudioGain gain : this.mAudioSource.gains()) {
                    if ((gain.mode() & 1) == 0) continue;
                    sourceGain = gain;
                    break;
                }
                if (sourceGain != null) {
                    int steps = (sourceGain.maxValue() - sourceGain.minValue()) / sourceGain.stepValue();
                    int gainValue = sourceGain.minValue();
                    gainValue = this.mVolume < 1.0f ? (gainValue += sourceGain.stepValue() * (int)((double)(this.mVolume * (float)steps) + 0.5)) : sourceGain.maxValue();
                    int numChannels = 0;
                    for (int mask = sourceGain.channelMask(); mask > 0; mask >>= 1) {
                        numChannels += mask & 1;
                    }
                    int[] gainValues = new int[numChannels];
                    Arrays.fill(gainValues, gainValue);
                    sourceGainConfig = sourceGain.buildConfig(1, sourceGain.channelMask(), gainValues, 0);
                } else {
                    Slog.w(TAG, "No audio source gain with MODE_JOINT support exists.");
                }
            }
            AudioPortConfig sourceConfig = this.mAudioSource.activeConfig();
            AudioPortConfig sinkConfig = this.mAudioSink.activeConfig();
            AudioPatch[] audioPatchArray = new AudioPatch[]{this.mAudioPatch};
            boolean bl = shouldRecreateAudioPatch = sourceUpdated || sinkUpdated;
            if (sinkConfig == null || this.mDesiredSamplingRate != 0 && sinkConfig.samplingRate() != this.mDesiredSamplingRate || this.mDesiredChannelMask != 1 && sinkConfig.channelMask() != this.mDesiredChannelMask || this.mDesiredFormat != 1 && sinkConfig.format() != this.mDesiredFormat) {
                sinkConfig = this.mAudioSource.buildConfig(this.mDesiredSamplingRate, this.mDesiredChannelMask, this.mDesiredFormat, null);
                shouldRecreateAudioPatch = true;
            }
            if (sourceConfig == null || sourceGainConfig != null) {
                sourceConfig = this.mAudioSource.buildConfig(sinkConfig.samplingRate(), sinkConfig.channelMask(), sinkConfig.format(), sourceGainConfig);
                shouldRecreateAudioPatch = true;
            }
            if (shouldRecreateAudioPatch) {
                this.mCommittedVolume = this.mVolume;
                TvInputHardwareManager.this.mAudioManager.createAudioPatch(audioPatchArray, new AudioPortConfig[]{sourceConfig}, new AudioPortConfig[]{sinkConfig});
                this.mAudioPatch = audioPatchArray[0];
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setStreamVolume(float volume) throws RemoteException {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    throw new IllegalStateException("Device already released.");
                }
                this.mVolume = volume;
                this.updateAudioConfigLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean dispatchKeyEventToHdmi(KeyEvent event) throws RemoteException {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    throw new IllegalStateException("Device already released.");
                }
            }
            if (this.mInfo.getType() != 9) {
                return false;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean startCapture(Surface surface, TvStreamConfig config) {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    return false;
                }
                if (surface == null || config == null) {
                    return false;
                }
                if (config.getType() != 2) {
                    return false;
                }
                int result = TvInputHardwareManager.this.mHal.addStream(this.mInfo.getDeviceId(), surface, config);
                boolean bl = result == 0;
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stopCapture(TvStreamConfig config) {
            Object object = this.mImplLock;
            synchronized (object) {
                if (this.mReleased) {
                    return false;
                }
                if (config == null) {
                    return false;
                }
                int result = TvInputHardwareManager.this.mHal.removeStream(this.mInfo.getDeviceId(), config);
                boolean bl = result == 0;
                return bl;
            }
        }

        private boolean updateAudioSourceLocked() {
            if (this.mInfo.getAudioType() == 0) {
                return false;
            }
            AudioDevicePort previousSource = this.mAudioSource;
            this.mAudioSource = this.findAudioDevicePort(this.mInfo.getAudioType(), this.mInfo.getAudioAddress());
            return this.mAudioSource == null ? previousSource != null : !this.mAudioSource.equals(previousSource);
        }

        private boolean updateAudioSinkLocked() {
            if (this.mInfo.getAudioType() == 0) {
                return false;
            }
            AudioDevicePort previousSink = this.mAudioSink;
            if (this.mOverrideAudioType == 0) {
                this.mAudioSink = this.findAudioSinkFromAudioPolicy();
            } else {
                AudioDevicePort audioSink = this.findAudioDevicePort(this.mOverrideAudioType, this.mOverrideAudioAddress);
                if (audioSink != null) {
                    this.mAudioSink = audioSink;
                }
            }
            return this.mAudioSink == null ? previousSink != null : !this.mAudioSink.equals(previousSink);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAudioSinkUpdated() {
            Object object = this.mImplLock;
            synchronized (object) {
                this.updateAudioConfigLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void overrideAudioSink(int audioType, String audioAddress, int samplingRate, int channelMask, int format) {
            Object object = this.mImplLock;
            synchronized (object) {
                this.mOverrideAudioType = audioType;
                this.mOverrideAudioAddress = audioAddress;
                this.mDesiredSamplingRate = samplingRate;
                this.mDesiredChannelMask = channelMask;
                this.mDesiredFormat = format;
                this.updateAudioConfigLocked();
            }
        }
    }

    private class Connection
    implements IBinder.DeathRecipient {
        private final TvInputHardwareInfo mHardwareInfo;
        private TvInputInfo mInfo;
        private TvInputHardwareImpl mHardware = null;
        private ITvInputHardwareCallback mCallback;
        private TvStreamConfig[] mConfigs = null;
        private Integer mCallingUid = null;
        private Integer mResolvedUserId = null;
        private Runnable mOnFirstFrameCaptured;

        public Connection(TvInputHardwareInfo hardwareInfo) {
            this.mHardwareInfo = hardwareInfo;
        }

        public void resetLocked(TvInputHardwareImpl hardware, ITvInputHardwareCallback callback, TvInputInfo info, Integer callingUid, Integer resolvedUserId) {
            if (this.mHardware != null) {
                try {
                    this.mCallback.onReleased();
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "error in Connection::resetLocked", e);
                }
                this.mHardware.release();
            }
            this.mHardware = hardware;
            this.mCallback = callback;
            this.mInfo = info;
            this.mCallingUid = callingUid;
            this.mResolvedUserId = resolvedUserId;
            this.mOnFirstFrameCaptured = null;
            if (this.mHardware != null && this.mCallback != null) {
                try {
                    this.mCallback.onStreamConfigChanged(this.getConfigsLocked());
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "error in Connection::resetLocked", e);
                }
            }
        }

        public void updateConfigsLocked(TvStreamConfig[] configs) {
            this.mConfigs = configs;
        }

        public TvInputHardwareInfo getHardwareInfoLocked() {
            return this.mHardwareInfo;
        }

        public TvInputInfo getInfoLocked() {
            return this.mInfo;
        }

        public ITvInputHardware getHardwareLocked() {
            return this.mHardware;
        }

        public TvInputHardwareImpl getHardwareImplLocked() {
            return this.mHardware;
        }

        public ITvInputHardwareCallback getCallbackLocked() {
            return this.mCallback;
        }

        public TvStreamConfig[] getConfigsLocked() {
            return this.mConfigs;
        }

        public Integer getCallingUidLocked() {
            return this.mCallingUid;
        }

        public Integer getResolvedUserIdLocked() {
            return this.mResolvedUserId;
        }

        public void setOnFirstFrameCapturedLocked(Runnable runnable) {
            this.mOnFirstFrameCaptured = runnable;
        }

        public Runnable getOnFirstFrameCapturedLocked() {
            return this.mOnFirstFrameCaptured;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = TvInputHardwareManager.this.mLock;
            synchronized (object) {
                this.resetLocked(null, null, null, null, null);
            }
        }
    }
}

