/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.OperationApplicationException;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.graphics.Rect;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.media.tv.ITvInputClient;
import android.media.tv.ITvInputHardware;
import android.media.tv.ITvInputHardwareCallback;
import android.media.tv.ITvInputManager;
import android.media.tv.ITvInputManagerCallback;
import android.media.tv.ITvInputService;
import android.media.tv.ITvInputServiceCallback;
import android.media.tv.ITvInputSession;
import android.media.tv.ITvInputSessionCallback;
import android.media.tv.TvContentRating;
import android.media.tv.TvContentRatingSystemInfo;
import android.media.tv.TvContract;
import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvInputInfo;
import android.media.tv.TvStreamConfig;
import android.media.tv.TvTrackInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Slog;
import android.util.SparseArray;
import android.view.InputChannel;
import android.view.Surface;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.IoThread;
import com.android.server.SystemService;
import com.android.server.tv.PersistentDataStore;
import com.android.server.tv.TvInputHardwareManager;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;

public final class TvInputManagerService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = "TvInputManagerService";
    private final Context mContext;
    private final TvInputHardwareManager mTvInputHardwareManager;
    private final ContentResolver mContentResolver;
    private final Object mLock = new Object();
    private int mCurrentUserId = 0;
    private final SparseArray<UserState> mUserStates = new SparseArray();
    private final WatchLogHandler mWatchLogHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvInputManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
        this.mWatchLogHandler = new WatchLogHandler(this.mContentResolver, IoThread.get().getLooper());
        this.mTvInputHardwareManager = new TvInputHardwareManager(context, new HardwareListener());
        Object object = this.mLock;
        synchronized (object) {
            this.mUserStates.put(this.mCurrentUserId, new UserState(this.mContext, this.mCurrentUserId));
        }
    }

    @Override
    public void onStart() {
        this.publishBinderService("tv_input", new BinderService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.registerBroadcastReceivers();
        } else if (phase == 600) {
            Object object = this.mLock;
            synchronized (object) {
                this.buildTvInputListLocked(this.mCurrentUserId, null);
                this.buildTvContentRatingSystemListLocked(this.mCurrentUserId);
            }
        }
        this.mTvInputHardwareManager.onBootPhase(phase);
    }

    private void registerBroadcastReceivers() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void buildTvInputList(String[] packages) {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    TvInputManagerService.this.buildTvInputListLocked(this.getChangingUserId(), packages);
                    TvInputManagerService.this.buildTvContentRatingSystemListLocked(this.getChangingUserId());
                }
            }

            @Override
            public void onPackageUpdateFinished(String packageName, int uid) {
                this.buildTvInputList(new String[]{packageName});
            }

            @Override
            public void onPackagesAvailable(String[] packages) {
                if (this.isReplacing()) {
                    this.buildTvInputList(packages);
                }
            }

            @Override
            public void onPackagesUnavailable(String[] packages) {
                if (this.isReplacing()) {
                    this.buildTvInputList(packages);
                }
            }

            @Override
            public void onSomePackagesChanged() {
                if (this.isReplacing()) {
                    return;
                }
                this.buildTvInputList(null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(this.getChangingUserId());
                    if (!userState.packageSet.contains(packageName)) {
                        return;
                    }
                }
                ArrayList<ContentProviderOperation> operations = new ArrayList<ContentProviderOperation>();
                String selection = "package_name=?";
                String[] selectionArgs = new String[]{packageName};
                operations.add(ContentProviderOperation.newDelete(TvContract.Channels.CONTENT_URI).withSelection(selection, selectionArgs).build());
                operations.add(ContentProviderOperation.newDelete(TvContract.Programs.CONTENT_URI).withSelection(selection, selectionArgs).build());
                operations.add(ContentProviderOperation.newDelete(TvContract.WatchedPrograms.CONTENT_URI).withSelection(selection, selectionArgs).build());
                ContentProviderResult[] results = null;
                try {
                    results = TvInputManagerService.this.mContentResolver.applyBatch("android.media.tv", operations);
                }
                catch (OperationApplicationException | RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in applyBatch", e);
                }
            }
        };
        monitor.register(this.mContext, null, UserHandle.ALL, true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    TvInputManagerService.this.switchUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    TvInputManagerService.this.removeUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                }
            }
        }, UserHandle.ALL, intentFilter, null, null);
    }

    private static boolean hasHardwarePermission(PackageManager pm, ComponentName component) {
        return pm.checkPermission("android.permission.TV_INPUT_HARDWARE", component.getPackageName()) == 0;
    }

    private void buildTvInputListLocked(int userId, String[] updatedPackages) {
        ServiceState serviceState;
        ComponentName component;
        UserState userState = this.getUserStateLocked(userId);
        userState.packageSet.clear();
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> services = pm.queryIntentServices(new Intent("android.media.tv.TvInputService"), 132);
        ArrayList<TvInputInfo> inputList = new ArrayList<TvInputInfo>();
        for (ResolveInfo ri : services) {
            ServiceInfo si = ri.serviceInfo;
            if (!"android.permission.BIND_TV_INPUT".equals(si.permission)) {
                Slog.w(TAG, "Skipping TV input " + si.name + ": it does not require the permission " + "android.permission.BIND_TV_INPUT");
                continue;
            }
            component = new ComponentName(si.packageName, si.name);
            if (TvInputManagerService.hasHardwarePermission(pm, component)) {
                serviceState = (ServiceState)userState.serviceStateMap.get(component);
                if (serviceState == null) {
                    serviceState = new ServiceState(component, userId);
                    userState.serviceStateMap.put(component, serviceState);
                    this.updateServiceConnectionLocked(component, userId);
                } else {
                    inputList.addAll(serviceState.inputList);
                }
            } else {
                try {
                    inputList.add(TvInputInfo.createTvInputInfo(this.mContext, ri));
                }
                catch (IOException | XmlPullParserException e) {
                    Slog.e(TAG, "failed to load TV input " + si.name, e);
                    continue;
                }
            }
            userState.packageSet.add(si.packageName);
        }
        HashMap<String, TvInputState> inputMap = new HashMap<String, TvInputState>();
        for (TvInputInfo info : inputList) {
            TvInputState state = (TvInputState)userState.inputMap.get(info.getId());
            if (state == null) {
                state = new TvInputState();
            }
            state.info = info;
            inputMap.put(info.getId(), state);
        }
        block4: for (String inputId : inputMap.keySet()) {
            if (!userState.inputMap.containsKey(inputId)) {
                this.notifyInputAddedLocked(userState, inputId);
                continue;
            }
            if (updatedPackages == null) continue;
            component = ((TvInputState)inputMap.get(inputId)).info.getComponent();
            for (String updatedPackage : updatedPackages) {
                if (!component.getPackageName().equals(updatedPackage)) continue;
                this.updateServiceConnectionLocked(component, userId);
                this.notifyInputUpdatedLocked(userState, inputId);
                continue block4;
            }
        }
        for (String inputId : userState.inputMap.keySet()) {
            if (inputMap.containsKey(inputId)) continue;
            TvInputInfo info = ((TvInputState)userState.inputMap.get(inputId)).info;
            serviceState = (ServiceState)userState.serviceStateMap.get(info.getComponent());
            if (serviceState != null) {
                this.abortPendingCreateSessionRequestsLocked(serviceState, inputId, userId);
            }
            this.notifyInputRemovedLocked(userState, inputId);
        }
        userState.inputMap.clear();
        userState.inputMap = inputMap;
    }

    private void buildTvContentRatingSystemListLocked(int userId) {
        UserState userState = this.getUserStateLocked(userId);
        userState.contentRatingSystemList.clear();
        PackageManager pm = this.mContext.getPackageManager();
        Intent intent = new Intent("android.media.tv.action.QUERY_CONTENT_RATING_SYSTEMS");
        for (ResolveInfo resolveInfo : pm.queryBroadcastReceivers(intent, 128)) {
            ActivityInfo receiver = resolveInfo.activityInfo;
            Bundle metaData = receiver.metaData;
            if (metaData == null) continue;
            int xmlResId = metaData.getInt("android.media.tv.metadata.CONTENT_RATING_SYSTEMS");
            if (xmlResId == 0) {
                Slog.w(TAG, "Missing meta-data 'android.media.tv.metadata.CONTENT_RATING_SYSTEMS' on receiver " + receiver.packageName + "/" + receiver.name);
                continue;
            }
            userState.contentRatingSystemList.add(TvContentRatingSystemInfo.createTvContentRatingSystemInfo(xmlResId, receiver.applicationInfo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentUserId == userId) {
                return;
            }
            this.mCurrentUserId = userId;
            UserState userState = this.mUserStates.get(userId);
            if (userState == null) {
                userState = new UserState(this.mContext, userId);
            }
            this.mUserStates.put(userId, userState);
            this.buildTvInputListLocked(userId, null);
            this.buildTvContentRatingSystemListLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.mUserStates.get(userId);
            if (userState == null) {
                return;
            }
            for (SessionState state : userState.sessionStateMap.values()) {
                if (state.session == null) continue;
                try {
                    state.session.release();
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "error in release", e);
                }
            }
            userState.sessionStateMap.clear();
            for (ServiceState serviceState : userState.serviceStateMap.values()) {
                if (serviceState.callback != null) {
                    try {
                        serviceState.service.unregisterCallback(serviceState.callback);
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "error in unregisterCallback", e);
                    }
                }
                this.mContext.unbindService(serviceState.connection);
            }
            userState.serviceStateMap.clear();
            userState.inputMap.clear();
            userState.packageSet.clear();
            userState.contentRatingSystemList.clear();
            userState.clientStateMap.clear();
            userState.callbackSet.clear();
            userState.mainSessionToken = null;
            this.mUserStates.remove(userId);
        }
    }

    private UserState getUserStateLocked(int userId) {
        UserState userState = this.mUserStates.get(userId);
        if (userState == null) {
            throw new IllegalStateException("User state not found for user ID " + userId);
        }
        return userState;
    }

    private ServiceState getServiceStateLocked(ComponentName component, int userId) {
        UserState userState = this.getUserStateLocked(userId);
        ServiceState serviceState = (ServiceState)userState.serviceStateMap.get(component);
        if (serviceState == null) {
            throw new IllegalStateException("Service state not found for " + component + " (userId=" + userId + ")");
        }
        return serviceState;
    }

    private SessionState getSessionStateLocked(IBinder sessionToken, int callingUid, int userId) {
        UserState userState = this.getUserStateLocked(userId);
        SessionState sessionState = (SessionState)userState.sessionStateMap.get(sessionToken);
        if (sessionState == null) {
            throw new IllegalArgumentException("Session state not found for token " + sessionToken);
        }
        if (callingUid != 1000 && callingUid != sessionState.callingUid) {
            throw new SecurityException("Illegal access to the session with token " + sessionToken + " from uid " + callingUid);
        }
        return sessionState;
    }

    private ITvInputSession getSessionLocked(IBinder sessionToken, int callingUid, int userId) {
        return this.getSessionLocked(this.getSessionStateLocked(sessionToken, callingUid, userId));
    }

    private ITvInputSession getSessionLocked(SessionState sessionState) {
        ITvInputSession session = sessionState.session;
        if (session == null) {
            throw new IllegalStateException("Session not yet created for token " + sessionState.sessionToken);
        }
        return session;
    }

    private int resolveCallingUserId(int callingPid, int callingUid, int requestedUserId, String methodName) {
        return ActivityManager.handleIncomingUser(callingPid, callingUid, requestedUserId, false, false, methodName, null);
    }

    private static boolean shouldMaintainConnection(ServiceState serviceState) {
        return !serviceState.sessionTokens.isEmpty() || serviceState.isHardware;
    }

    private void updateServiceConnectionLocked(ComponentName component, int userId) {
        UserState userState = this.getUserStateLocked(userId);
        ServiceState serviceState = (ServiceState)userState.serviceStateMap.get(component);
        if (serviceState == null) {
            return;
        }
        if (serviceState.reconnecting) {
            if (!serviceState.sessionTokens.isEmpty()) {
                return;
            }
            serviceState.reconnecting = false;
        }
        boolean maintainConnection = TvInputManagerService.shouldMaintainConnection(serviceState);
        if (serviceState.service == null && maintainConnection && userId == this.mCurrentUserId) {
            if (serviceState.bound) {
                return;
            }
            Intent i = new Intent("android.media.tv.TvInputService").setComponent(component);
            serviceState.bound = this.mContext.bindServiceAsUser(i, serviceState.connection, 1, new UserHandle(userId));
        } else if (serviceState.service != null && !maintainConnection) {
            this.mContext.unbindService(serviceState.connection);
            userState.serviceStateMap.remove(component);
        }
    }

    private void abortPendingCreateSessionRequestsLocked(ServiceState serviceState, String inputId, int userId) {
        UserState userState = this.getUserStateLocked(userId);
        ArrayList<SessionState> sessionsToAbort = new ArrayList<SessionState>();
        for (IBinder sessionToken : serviceState.sessionTokens) {
            SessionState sessionState = (SessionState)userState.sessionStateMap.get(sessionToken);
            if (sessionState.session != null || inputId != null && !sessionState.info.getId().equals(inputId)) continue;
            sessionsToAbort.add(sessionState);
        }
        for (SessionState sessionState : sessionsToAbort) {
            this.removeSessionStateLocked(sessionState.sessionToken, sessionState.userId);
            this.sendSessionTokenToClientLocked(sessionState.client, sessionState.info.getId(), null, null, sessionState.seq);
        }
        this.updateServiceConnectionLocked(serviceState.component, userId);
    }

    private void createSessionInternalLocked(ITvInputService service, IBinder sessionToken, int userId) {
        UserState userState = this.getUserStateLocked(userId);
        SessionState sessionState = (SessionState)userState.sessionStateMap.get(sessionToken);
        InputChannel[] channels = InputChannel.openInputChannelPair(sessionToken.toString());
        SessionCallback callback = new SessionCallback(sessionState, channels);
        try {
            service.createSession(channels[1], callback, sessionState.info.getId());
        }
        catch (RemoteException e) {
            Slog.e(TAG, "error in createSession", e);
            this.removeSessionStateLocked(sessionToken, userId);
            this.sendSessionTokenToClientLocked(sessionState.client, sessionState.info.getId(), null, null, sessionState.seq);
        }
        channels[1].dispose();
    }

    private void sendSessionTokenToClientLocked(ITvInputClient client, String inputId, IBinder sessionToken, InputChannel channel, int seq) {
        try {
            client.onSessionCreated(inputId, sessionToken, channel, seq);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "error in onSessionCreated", e);
        }
    }

    private void releaseSessionLocked(IBinder sessionToken, int callingUid, int userId) {
        SessionState sessionState = this.getSessionStateLocked(sessionToken, callingUid, userId);
        if (sessionState.session != null) {
            UserState userState = this.getUserStateLocked(userId);
            if (sessionToken == userState.mainSessionToken) {
                this.setMainLocked(sessionToken, false, callingUid, userId);
            }
            try {
                sessionState.session.release();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "session process has already died", e);
            }
            sessionState.session = null;
        }
        this.removeSessionStateLocked(sessionToken, userId);
    }

    private void removeSessionStateLocked(IBinder sessionToken, int userId) {
        ServiceState serviceState;
        TvInputInfo info;
        SessionState sessionState;
        UserState userState = this.getUserStateLocked(userId);
        if (sessionToken == userState.mainSessionToken) {
            userState.mainSessionToken = null;
        }
        if ((sessionState = (SessionState)userState.sessionStateMap.remove(sessionToken)) == null) {
            return;
        }
        ClientState clientState = (ClientState)userState.clientStateMap.get(sessionState.client.asBinder());
        if (clientState != null) {
            clientState.sessionTokens.remove(sessionToken);
            if (clientState.isEmpty()) {
                userState.clientStateMap.remove(sessionState.client.asBinder());
            }
        }
        if ((info = sessionState.info) != null && (serviceState = (ServiceState)userState.serviceStateMap.get(info.getComponent())) != null) {
            serviceState.sessionTokens.remove(sessionToken);
        }
        this.updateServiceConnectionLocked(sessionState.info.getComponent(), userId);
        SomeArgs args = SomeArgs.obtain();
        args.arg1 = sessionToken;
        args.arg2 = System.currentTimeMillis();
        this.mWatchLogHandler.obtainMessage(2, args).sendToTarget();
    }

    private void setMainLocked(IBinder sessionToken, boolean isMain, int callingUid, int userId) {
        ServiceState serviceState;
        SessionState sessionState = this.getSessionStateLocked(sessionToken, callingUid, userId);
        if (sessionState.hardwareSessionToken != null) {
            sessionState = this.getSessionStateLocked(sessionState.hardwareSessionToken, 1000, userId);
        }
        if (!(serviceState = this.getServiceStateLocked(sessionState.info.getComponent(), userId)).isHardware) {
            return;
        }
        ITvInputSession session = this.getSessionLocked(sessionState);
        try {
            session.setMain(isMain);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "error in setMain", e);
        }
    }

    private void notifyInputAddedLocked(UserState userState, String inputId) {
        for (ITvInputManagerCallback callback : userState.callbackSet) {
            try {
                callback.onInputAdded(inputId);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "failed to report added input to callback", e);
            }
        }
    }

    private void notifyInputRemovedLocked(UserState userState, String inputId) {
        for (ITvInputManagerCallback callback : userState.callbackSet) {
            try {
                callback.onInputRemoved(inputId);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "failed to report removed input to callback", e);
            }
        }
    }

    private void notifyInputUpdatedLocked(UserState userState, String inputId) {
        for (ITvInputManagerCallback callback : userState.callbackSet) {
            try {
                callback.onInputUpdated(inputId);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "failed to report updated input to callback", e);
            }
        }
    }

    private void notifyInputStateChangedLocked(UserState userState, String inputId, int state, ITvInputManagerCallback targetCallback) {
        if (targetCallback == null) {
            for (ITvInputManagerCallback callback : userState.callbackSet) {
                try {
                    callback.onInputStateChanged(inputId, state);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "failed to report state change to callback", e);
                }
            }
        } else {
            try {
                targetCallback.onInputStateChanged(inputId, state);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "failed to report state change to callback", e);
            }
        }
    }

    private void setStateLocked(String inputId, int state, int userId) {
        UserState userState = this.getUserStateLocked(userId);
        TvInputState inputState = (TvInputState)userState.inputMap.get(inputId);
        ServiceState serviceState = (ServiceState)userState.serviceStateMap.get(inputState.info.getComponent());
        int oldState = inputState.state;
        inputState.state = state;
        if (serviceState != null && serviceState.service == null && TvInputManagerService.shouldMaintainConnection(serviceState)) {
            return;
        }
        if (oldState != state) {
            this.notifyInputStateChangedLocked(userState, inputId, state, null);
        }
    }

    private final class HardwareListener
    implements TvInputHardwareManager.Listener {
        private HardwareListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStateChanged(String inputId, int state) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                TvInputManagerService.this.setStateLocked(inputId, state, TvInputManagerService.this.mCurrentUserId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHardwareDeviceAdded(TvInputHardwareInfo info) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                UserState userState = TvInputManagerService.this.getUserStateLocked(TvInputManagerService.this.mCurrentUserId);
                for (ServiceState serviceState : userState.serviceStateMap.values()) {
                    if (!serviceState.isHardware || serviceState.service == null) continue;
                    try {
                        serviceState.service.notifyHardwareAdded(info);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in notifyHardwareAdded", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHardwareDeviceRemoved(TvInputHardwareInfo info) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                UserState userState = TvInputManagerService.this.getUserStateLocked(TvInputManagerService.this.mCurrentUserId);
                for (ServiceState serviceState : userState.serviceStateMap.values()) {
                    if (!serviceState.isHardware || serviceState.service == null) continue;
                    try {
                        serviceState.service.notifyHardwareRemoved(info);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in notifyHardwareRemoved", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHdmiDeviceAdded(HdmiDeviceInfo deviceInfo) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                UserState userState = TvInputManagerService.this.getUserStateLocked(TvInputManagerService.this.mCurrentUserId);
                for (ServiceState serviceState : userState.serviceStateMap.values()) {
                    if (!serviceState.isHardware || serviceState.service == null) continue;
                    try {
                        serviceState.service.notifyHdmiDeviceAdded(deviceInfo);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in notifyHdmiDeviceAdded", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHdmiDeviceRemoved(HdmiDeviceInfo deviceInfo) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                UserState userState = TvInputManagerService.this.getUserStateLocked(TvInputManagerService.this.mCurrentUserId);
                for (ServiceState serviceState : userState.serviceStateMap.values()) {
                    if (!serviceState.isHardware || serviceState.service == null) continue;
                    try {
                        serviceState.service.notifyHdmiDeviceRemoved(deviceInfo);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in notifyHdmiDeviceRemoved", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onHdmiDeviceUpdated(String inputId, HdmiDeviceInfo deviceInfo) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                Integer state = null;
                switch (deviceInfo.getDevicePowerStatus()) {
                    case 0: {
                        state = 0;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        state = 1;
                        break;
                    }
                    default: {
                        state = null;
                    }
                }
                if (state != null) {
                    TvInputManagerService.this.setStateLocked(inputId, state, TvInputManagerService.this.mCurrentUserId);
                }
            }
        }
    }

    private static final class WatchLogHandler
    extends Handler {
        private static final int MSG_LOG_WATCH_START = 1;
        private static final int MSG_LOG_WATCH_END = 2;
        private final ContentResolver mContentResolver;

        public WatchLogHandler(ContentResolver contentResolver, Looper looper) {
            super(looper);
            this.mContentResolver = contentResolver;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String packageName = (String)args.arg1;
                    long watchStartTime = (Long)args.arg2;
                    long channelId = (Long)args.arg3;
                    Bundle tuneParams = (Bundle)args.arg4;
                    IBinder sessionToken = (IBinder)args.arg5;
                    ContentValues values = new ContentValues();
                    values.put("package_name", packageName);
                    values.put("watch_start_time_utc_millis", watchStartTime);
                    values.put("channel_id", channelId);
                    if (tuneParams != null) {
                        values.put("tune_params", this.encodeTuneParams(tuneParams));
                    }
                    values.put("session_token", sessionToken.toString());
                    this.mContentResolver.insert(TvContract.WatchedPrograms.CONTENT_URI, values);
                    args.recycle();
                    return;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    IBinder sessionToken = (IBinder)args.arg1;
                    long watchEndTime = (Long)args.arg2;
                    ContentValues values = new ContentValues();
                    values.put("watch_end_time_utc_millis", watchEndTime);
                    values.put("session_token", sessionToken.toString());
                    this.mContentResolver.insert(TvContract.WatchedPrograms.CONTENT_URI, values);
                    args.recycle();
                    return;
                }
            }
            Slog.w(TvInputManagerService.TAG, "Unhandled message code: " + msg.what);
        }

        private String encodeTuneParams(Bundle tuneParams) {
            StringBuilder builder = new StringBuilder();
            Set<String> keySet = tuneParams.keySet();
            Iterator<String> it = keySet.iterator();
            while (it.hasNext()) {
                String key = it.next();
                Object value = tuneParams.get(key);
                if (value == null) continue;
                builder.append(this.replaceEscapeCharacters(key));
                builder.append("=");
                builder.append(this.replaceEscapeCharacters(value.toString()));
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
            return builder.toString();
        }

        private String replaceEscapeCharacters(String src) {
            int ESCAPE_CHARACTER = 37;
            String ENCODING_TARGET_CHARACTERS = "%=,";
            StringBuilder builder = new StringBuilder();
            for (char ch : src.toCharArray()) {
                if ("%=,".indexOf(ch) >= 0) {
                    builder.append('%');
                }
                builder.append(ch);
            }
            return builder.toString();
        }
    }

    private final class SessionCallback
    extends ITvInputSessionCallback.Stub {
        private final SessionState mSessionState;
        private final InputChannel[] mChannels;

        SessionCallback(SessionState sessionState, InputChannel[] channels) {
            this.mSessionState = sessionState;
            this.mChannels = channels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionCreated(ITvInputSession session, IBinder harewareSessionToken) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                this.mSessionState.session = session;
                this.mSessionState.hardwareSessionToken = harewareSessionToken;
                if (session != null && this.addSessionTokenToClientStateLocked(session)) {
                    TvInputManagerService.this.sendSessionTokenToClientLocked(this.mSessionState.client, this.mSessionState.info.getId(), this.mSessionState.sessionToken, this.mChannels[0], this.mSessionState.seq);
                } else {
                    TvInputManagerService.this.removeSessionStateLocked(this.mSessionState.sessionToken, this.mSessionState.userId);
                    TvInputManagerService.this.sendSessionTokenToClientLocked(this.mSessionState.client, this.mSessionState.info.getId(), null, null, this.mSessionState.seq);
                }
                this.mChannels[0].dispose();
            }
        }

        private boolean addSessionTokenToClientStateLocked(ITvInputSession session) {
            try {
                session.asBinder().linkToDeath(this.mSessionState, 0);
            }
            catch (RemoteException e) {
                Slog.e(TvInputManagerService.TAG, "session process has already died", e);
                return false;
            }
            IBinder clientToken = this.mSessionState.client.asBinder();
            UserState userState = TvInputManagerService.this.getUserStateLocked(this.mSessionState.userId);
            ClientState clientState = (ClientState)userState.clientStateMap.get(clientToken);
            if (clientState == null) {
                clientState = new ClientState(clientToken, this.mSessionState.userId);
                try {
                    clientToken.linkToDeath(clientState, 0);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "client process has already died", e);
                    return false;
                }
                userState.clientStateMap.put(clientToken, clientState);
            }
            clientState.sessionTokens.add(this.mSessionState.sessionToken);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChannelRetuned(Uri channelUri) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onChannelRetuned(channelUri, this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onChannelRetuned", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTracksChanged(List<TvTrackInfo> tracks) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onTracksChanged(tracks, this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onTracksChanged", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTrackSelected(int type, String trackId) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onTrackSelected(type, trackId, this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onTrackSelected", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVideoAvailable() {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onVideoAvailable(this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onVideoAvailable", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVideoUnavailable(int reason) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onVideoUnavailable(reason, this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onVideoUnavailable", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContentAllowed() {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onContentAllowed(this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onContentAllowed", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onContentBlocked(String rating) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onContentBlocked(rating, this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onContentBlocked", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLayoutSurface(int left, int top, int right, int bottom) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onLayoutSurface(left, top, right, bottom, this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onLayoutSurface", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSessionEvent(String eventType, Bundle eventArgs) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                if (this.mSessionState.session == null || this.mSessionState.client == null) {
                    return;
                }
                try {
                    this.mSessionState.client.onSessionEvent(eventType, eventArgs, this.mSessionState.seq);
                }
                catch (RemoteException e) {
                    Slog.e(TvInputManagerService.TAG, "error in onSessionEvent", e);
                }
            }
        }
    }

    private final class ServiceCallback
    extends ITvInputServiceCallback.Stub {
        private final ComponentName mComponent;
        private final int mUserId;

        ServiceCallback(ComponentName component, int userId) {
            this.mComponent = component;
            this.mUserId = userId;
        }

        private void ensureHardwarePermission() {
            if (TvInputManagerService.this.mContext.checkCallingPermission("android.permission.TV_INPUT_HARDWARE") != 0) {
                throw new SecurityException("The caller does not have hardware permission");
            }
        }

        private void ensureValidInput(TvInputInfo inputInfo) {
            if (inputInfo.getId() == null || !this.mComponent.equals(inputInfo.getComponent())) {
                throw new IllegalArgumentException("Invalid TvInputInfo");
            }
        }

        private void addTvInputLocked(TvInputInfo inputInfo) {
            ServiceState serviceState = TvInputManagerService.this.getServiceStateLocked(this.mComponent, this.mUserId);
            serviceState.inputList.add(inputInfo);
            TvInputManagerService.this.buildTvInputListLocked(this.mUserId, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addHardwareTvInput(int deviceId, TvInputInfo inputInfo) {
            this.ensureHardwarePermission();
            this.ensureValidInput(inputInfo);
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                TvInputManagerService.this.mTvInputHardwareManager.addHardwareTvInput(deviceId, inputInfo);
                this.addTvInputLocked(inputInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addHdmiTvInput(int id2, TvInputInfo inputInfo) {
            this.ensureHardwarePermission();
            this.ensureValidInput(inputInfo);
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                TvInputManagerService.this.mTvInputHardwareManager.addHdmiTvInput(id2, inputInfo);
                this.addTvInputLocked(inputInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeTvInput(String inputId) {
            this.ensureHardwarePermission();
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                ServiceState serviceState = TvInputManagerService.this.getServiceStateLocked(this.mComponent, this.mUserId);
                boolean removed = false;
                Iterator it = serviceState.inputList.iterator();
                while (it.hasNext()) {
                    if (!((TvInputInfo)it.next()).getId().equals(inputId)) continue;
                    it.remove();
                    removed = true;
                    break;
                }
                if (removed) {
                    TvInputManagerService.this.buildTvInputListLocked(this.mUserId, null);
                    TvInputManagerService.this.mTvInputHardwareManager.removeTvInput(inputId);
                } else {
                    Slog.e(TvInputManagerService.TAG, "failed to remove input " + inputId);
                }
            }
        }
    }

    private final class InputServiceConnection
    implements ServiceConnection {
        private final ComponentName mComponent;
        private final int mUserId;

        private InputServiceConnection(ComponentName component, int userId) {
            this.mComponent = component;
            this.mUserId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName component, IBinder service) {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                UserState userState = TvInputManagerService.this.getUserStateLocked(this.mUserId);
                ServiceState serviceState = (ServiceState)userState.serviceStateMap.get(this.mComponent);
                serviceState.service = ITvInputService.Stub.asInterface(service);
                if (serviceState.isHardware && serviceState.callback == null) {
                    serviceState.callback = new ServiceCallback(this.mComponent, this.mUserId);
                    try {
                        serviceState.service.registerCallback(serviceState.callback);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in registerCallback", e);
                    }
                }
                for (IBinder sessionToken : serviceState.sessionTokens) {
                    TvInputManagerService.this.createSessionInternalLocked(serviceState.service, sessionToken, this.mUserId);
                }
                for (TvInputState inputState : userState.inputMap.values()) {
                    if (!inputState.info.getComponent().equals(component) || inputState.state == 2) continue;
                    TvInputManagerService.this.notifyInputStateChangedLocked(userState, inputState.info.getId(), inputState.state, null);
                }
                if (serviceState.isHardware) {
                    List<TvInputHardwareInfo> hardwareInfoList = TvInputManagerService.this.mTvInputHardwareManager.getHardwareList();
                    for (TvInputHardwareInfo hardwareInfo : hardwareInfoList) {
                        try {
                            serviceState.service.notifyHardwareAdded(hardwareInfo);
                        }
                        catch (RemoteException e) {
                            Slog.e(TvInputManagerService.TAG, "error in notifyHardwareAdded", e);
                        }
                    }
                    List<HdmiDeviceInfo> deviceInfoList = TvInputManagerService.this.mTvInputHardwareManager.getHdmiDeviceList();
                    for (HdmiDeviceInfo deviceInfo : deviceInfoList) {
                        try {
                            serviceState.service.notifyHdmiDeviceAdded(deviceInfo);
                        }
                        catch (RemoteException e) {
                            Slog.e(TvInputManagerService.TAG, "error in notifyHdmiDeviceAdded", e);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName component) {
            if (!this.mComponent.equals(component)) {
                throw new IllegalArgumentException("Mismatched ComponentName: " + this.mComponent + " (expected), " + component + " (actual).");
            }
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                UserState userState = TvInputManagerService.this.getUserStateLocked(this.mUserId);
                ServiceState serviceState = (ServiceState)userState.serviceStateMap.get(this.mComponent);
                if (serviceState != null) {
                    serviceState.reconnecting = true;
                    serviceState.bound = false;
                    serviceState.service = null;
                    serviceState.callback = null;
                    TvInputManagerService.this.abortPendingCreateSessionRequestsLocked(serviceState, null, this.mUserId);
                    for (TvInputState inputState : userState.inputMap.values()) {
                        if (!inputState.info.getComponent().equals(component)) continue;
                        TvInputManagerService.this.notifyInputStateChangedLocked(userState, inputState.info.getId(), 2, null);
                    }
                }
            }
        }
    }

    private final class SessionState
    implements IBinder.DeathRecipient {
        private final TvInputInfo info;
        private final ITvInputClient client;
        private final int seq;
        private final int callingUid;
        private final int userId;
        private final IBinder sessionToken;
        private ITvInputSession session;
        private Uri logUri;
        private IBinder hardwareSessionToken;

        private SessionState(IBinder sessionToken, TvInputInfo info, ITvInputClient client, int seq, int callingUid, int userId) {
            this.sessionToken = sessionToken;
            this.info = info;
            this.client = client;
            this.seq = seq;
            this.callingUid = callingUid;
            this.userId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                this.session = null;
                if (this.client != null) {
                    try {
                        this.client.onSessionReleased(this.seq);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in onSessionReleased", e);
                    }
                }
                UserState userState = TvInputManagerService.this.getUserStateLocked(this.userId);
                for (SessionState sessionState : userState.sessionStateMap.values()) {
                    if (this.sessionToken != sessionState.hardwareSessionToken) continue;
                    TvInputManagerService.this.releaseSessionLocked(sessionState.sessionToken, 1000, this.userId);
                    try {
                        sessionState.client.onSessionReleased(sessionState.seq);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in onSessionReleased", e);
                    }
                }
                TvInputManagerService.this.removeSessionStateLocked(this.sessionToken, this.userId);
            }
        }
    }

    private static final class TvInputState {
        private TvInputInfo info;
        private int state = 0;

        private TvInputState() {
        }

        public String toString() {
            return "info: " + this.info + "; state: " + this.state;
        }
    }

    private final class ServiceState {
        private final List<IBinder> sessionTokens = new ArrayList<IBinder>();
        private final ServiceConnection connection;
        private final ComponentName component;
        private final boolean isHardware;
        private final List<TvInputInfo> inputList = new ArrayList<TvInputInfo>();
        private ITvInputService service;
        private ServiceCallback callback;
        private boolean bound;
        private boolean reconnecting;

        private ServiceState(ComponentName component, int userId) {
            this.component = component;
            this.connection = new InputServiceConnection(component, userId);
            this.isHardware = TvInputManagerService.hasHardwarePermission(TvInputManagerService.this.mContext.getPackageManager(), component);
        }
    }

    private final class ClientState
    implements IBinder.DeathRecipient {
        private final List<IBinder> sessionTokens = new ArrayList<IBinder>();
        private IBinder clientToken;
        private final int userId;

        ClientState(IBinder clientToken, int userId) {
            this.clientToken = clientToken;
            this.userId = userId;
        }

        public boolean isEmpty() {
            return this.sessionTokens.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                UserState userState = TvInputManagerService.this.getUserStateLocked(this.userId);
                ClientState clientState = (ClientState)userState.clientStateMap.get(this.clientToken);
                if (clientState != null) {
                    while (clientState.sessionTokens.size() > 0) {
                        TvInputManagerService.this.releaseSessionLocked(clientState.sessionTokens.get(0), 1000, this.userId);
                    }
                }
                this.clientToken = null;
            }
        }
    }

    private static final class UserState {
        private Map<String, TvInputState> inputMap = new HashMap<String, TvInputState>();
        private final Set<String> packageSet = new HashSet<String>();
        private final List<TvContentRatingSystemInfo> contentRatingSystemList = new ArrayList<TvContentRatingSystemInfo>();
        private final Map<IBinder, ClientState> clientStateMap = new HashMap<IBinder, ClientState>();
        private final Map<ComponentName, ServiceState> serviceStateMap = new HashMap<ComponentName, ServiceState>();
        private final Map<IBinder, SessionState> sessionStateMap = new HashMap<IBinder, SessionState>();
        private final Set<ITvInputManagerCallback> callbackSet = new HashSet<ITvInputManagerCallback>();
        private IBinder mainSessionToken = null;
        private final PersistentDataStore persistentDataStore;

        private UserState(Context context, int userId) {
            this.persistentDataStore = new PersistentDataStore(context, userId);
        }
    }

    private final class BinderService
    extends ITvInputManager.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TvInputInfo> getTvInputList(int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "getTvInputList");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    ArrayList<TvInputInfo> inputList = new ArrayList<TvInputInfo>();
                    for (TvInputState state : userState.inputMap.values()) {
                        inputList.add(state.info);
                    }
                    ArrayList<TvInputInfo> arrayList = inputList;
                    return arrayList;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TvInputInfo getTvInputInfo(String inputId, int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "getTvInputInfo");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    TvInputState state = (TvInputState)userState.inputMap.get(inputId);
                    TvInputInfo tvInputInfo = state == null ? null : state.info;
                    return tvInputInfo;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TvContentRatingSystemInfo> getTvContentRatingSystemList(int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "getTvContentRatingSystemList");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    List list = userState.contentRatingSystemList;
                    return list;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerCallback(final ITvInputManagerCallback callback, int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "registerCallback");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    final UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    userState.callbackSet.add(callback);
                    try {
                        callback.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void binderDied() {
                                Object object = TvInputManagerService.this.mLock;
                                synchronized (object) {
                                    if (userState.callbackSet != null) {
                                        userState.callbackSet.remove(callback);
                                    }
                                }
                            }
                        }, 0);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "client process has already died", e);
                    }
                    for (TvInputState state : userState.inputMap.values()) {
                        TvInputManagerService.this.notifyInputStateChangedLocked(userState, state.info.getId(), state.state, callback);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterCallback(ITvInputManagerCallback callback, int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "unregisterCallback");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    userState.callbackSet.remove(callback);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isParentalControlsEnabled(int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "isParentalControlsEnabled");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    boolean bl = userState.persistentDataStore.isParentalControlsEnabled();
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setParentalControlsEnabled(boolean enabled, int userId) {
            this.ensureParentalControlsPermission();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "setParentalControlsEnabled");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    userState.persistentDataStore.setParentalControlsEnabled(enabled);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isRatingBlocked(String rating, int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "isRatingBlocked");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    boolean bl = userState.persistentDataStore.isRatingBlocked(TvContentRating.unflattenFromString(rating));
                    return bl;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getBlockedRatings(int userId) {
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "getBlockedRatings");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    ArrayList<String> ratings = new ArrayList<String>();
                    for (TvContentRating rating : userState.persistentDataStore.getBlockedRatings()) {
                        ratings.add(rating.flattenToString());
                    }
                    ArrayList<String> arrayList = ratings;
                    return arrayList;
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addBlockedRating(String rating, int userId) {
            this.ensureParentalControlsPermission();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "addBlockedRating");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    userState.persistentDataStore.addBlockedRating(TvContentRating.unflattenFromString(rating));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeBlockedRating(String rating, int userId) {
            this.ensureParentalControlsPermission();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), Binder.getCallingUid(), userId, "removeBlockedRating");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    userState.persistentDataStore.removeBlockedRating(TvContentRating.unflattenFromString(rating));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private void ensureParentalControlsPermission() {
            if (TvInputManagerService.this.mContext.checkCallingPermission("android.permission.MODIFY_PARENTAL_CONTROLS") != 0) {
                throw new SecurityException("The caller does not have parental controls permission");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void createSession(ITvInputClient client, String inputId, int seq, int userId) {
            TvInputState inputState;
            UserState userState;
            long identity;
            int resolvedUserId;
            int callingUid;
            block11: {
                callingUid = Binder.getCallingUid();
                resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "createSession");
                identity = Binder.clearCallingIdentity();
                Object object = TvInputManagerService.this.mLock;
                // MONITORENTER : object
                userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                inputState = (TvInputState)userState.inputMap.get(inputId);
                if (inputState != null) break block11;
                Slog.w(TvInputManagerService.TAG, "Failed to find input state for inputId=" + inputId);
                TvInputManagerService.this.sendSessionTokenToClientLocked(client, inputId, null, null, seq);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(identity);
                return;
            }
            TvInputInfo info = inputState.info;
            ServiceState serviceState = (ServiceState)userState.serviceStateMap.get(info.getComponent());
            if (serviceState == null) {
                serviceState = new ServiceState(info.getComponent(), resolvedUserId);
                userState.serviceStateMap.put(info.getComponent(), serviceState);
            }
            if (serviceState.reconnecting) {
                TvInputManagerService.this.sendSessionTokenToClientLocked(client, inputId, null, null, seq);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(identity);
                return;
            }
            try {
                Binder sessionToken = new Binder();
                SessionState sessionState = new SessionState(sessionToken, info, client, seq, callingUid, resolvedUserId);
                userState.sessionStateMap.put(sessionToken, sessionState);
                serviceState.sessionTokens.add(sessionToken);
                if (serviceState.service != null) {
                    TvInputManagerService.this.createSessionInternalLocked(serviceState.service, sessionToken, resolvedUserId);
                    return;
                }
                TvInputManagerService.this.updateServiceConnectionLocked(info.getComponent(), resolvedUserId);
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseSession(IBinder sessionToken, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "releaseSession");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    TvInputManagerService.this.releaseSessionLocked(sessionToken, callingUid, resolvedUserId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMainSession(IBinder sessionToken, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "setMainSession");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState;
                    block10: {
                        userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                        if (userState.mainSessionToken != sessionToken) break block10;
                        return;
                    }
                    IBinder oldMainSessionToken = userState.mainSessionToken;
                    userState.mainSessionToken = sessionToken;
                    if (sessionToken != null) {
                        TvInputManagerService.this.setMainLocked(sessionToken, true, callingUid, userId);
                    }
                    if (oldMainSessionToken != null) {
                        TvInputManagerService.this.setMainLocked(oldMainSessionToken, false, 1000, userId);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSurface(IBinder sessionToken, Surface surface, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "setSurface");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        SessionState sessionState = TvInputManagerService.this.getSessionStateLocked(sessionToken, callingUid, resolvedUserId);
                        if (sessionState.hardwareSessionToken == null) {
                            TvInputManagerService.this.getSessionLocked(sessionState).setSurface(surface);
                        } else {
                            TvInputManagerService.this.getSessionLocked(sessionState.hardwareSessionToken, 1000, resolvedUserId).setSurface(surface);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in setSurface", e);
                    }
                }
            }
            finally {
                if (surface != null) {
                    surface.release();
                }
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchSurfaceChanged(IBinder sessionToken, int format, int width, int height, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "dispatchSurfaceChanged");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        SessionState sessionState = TvInputManagerService.this.getSessionStateLocked(sessionToken, callingUid, resolvedUserId);
                        TvInputManagerService.this.getSessionLocked(sessionState).dispatchSurfaceChanged(format, width, height);
                        if (sessionState.hardwareSessionToken != null) {
                            TvInputManagerService.this.getSessionLocked(sessionState.hardwareSessionToken, 1000, resolvedUserId).dispatchSurfaceChanged(format, width, height);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in dispatchSurfaceChanged", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVolume(IBinder sessionToken, float volume, int userId) {
            float REMOTE_VOLUME_ON = 1.0f;
            float REMOTE_VOLUME_OFF = 0.0f;
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "setVolume");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        SessionState sessionState = TvInputManagerService.this.getSessionStateLocked(sessionToken, callingUid, resolvedUserId);
                        TvInputManagerService.this.getSessionLocked(sessionState).setVolume(volume);
                        if (sessionState.hardwareSessionToken != null) {
                            TvInputManagerService.this.getSessionLocked(sessionState.hardwareSessionToken, 1000, resolvedUserId).setVolume(volume > 0.0f ? 1.0f : 0.0f);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in setVolume", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void tune(IBinder sessionToken, Uri channelUri, Bundle params, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "tune");
            long identity = Binder.clearCallingIdentity();
            try {
                block10: {
                    Object object = TvInputManagerService.this.mLock;
                    // MONITORENTER : object
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).tune(channelUri, params);
                        if (!TvContract.isChannelUriForPassthroughInput(channelUri)) break block10;
                        // MONITOREXIT : object
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in tune", e);
                        // MONITOREXIT : object
                        Binder.restoreCallingIdentity(identity);
                        return;
                    }
                    Binder.restoreCallingIdentity(identity);
                    return;
                }
                UserState userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                SessionState sessionState = (SessionState)userState.sessionStateMap.get(sessionToken);
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = sessionState.info.getComponent().getPackageName();
                args.arg2 = System.currentTimeMillis();
                args.arg3 = ContentUris.parseId(channelUri);
                args.arg4 = params;
                args.arg5 = sessionToken;
                TvInputManagerService.this.mWatchLogHandler.obtainMessage(1, args).sendToTarget();
                return;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestUnblockContent(IBinder sessionToken, String unblockedRating, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "unblockContent");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).requestUnblockContent(unblockedRating);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in requestUnblockContent", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setCaptionEnabled(IBinder sessionToken, boolean enabled, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "setCaptionEnabled");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).setCaptionEnabled(enabled);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in setCaptionEnabled", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectTrack(IBinder sessionToken, int type, String trackId, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "selectTrack");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).selectTrack(type, trackId);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in selectTrack", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendAppPrivateCommand(IBinder sessionToken, String command, Bundle data, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "sendAppPrivateCommand");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).appPrivateCommand(command, data);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in appPrivateCommand", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createOverlayView(IBinder sessionToken, IBinder windowToken, Rect frame, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "createOverlayView");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).createOverlayView(windowToken, frame);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in createOverlayView", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void relayoutOverlayView(IBinder sessionToken, Rect frame, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "relayoutOverlayView");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).relayoutOverlayView(frame);
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in relayoutOverlayView", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeOverlayView(IBinder sessionToken, int userId) {
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "removeOverlayView");
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    try {
                        TvInputManagerService.this.getSessionLocked(sessionToken, callingUid, resolvedUserId).removeOverlayView();
                    }
                    catch (RemoteException e) {
                        Slog.e(TvInputManagerService.TAG, "error in removeOverlayView", e);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TvInputHardwareInfo> getHardwareList() throws RemoteException {
            if (TvInputManagerService.this.mContext.checkCallingPermission("android.permission.TV_INPUT_HARDWARE") != 0) {
                return null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                List<TvInputHardwareInfo> list = TvInputManagerService.this.mTvInputHardwareManager.getHardwareList();
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ITvInputHardware acquireTvInputHardware(int deviceId, ITvInputHardwareCallback callback, TvInputInfo info, int userId) throws RemoteException {
            if (TvInputManagerService.this.mContext.checkCallingPermission("android.permission.TV_INPUT_HARDWARE") != 0) {
                return null;
            }
            long identity = Binder.clearCallingIdentity();
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "acquireTvInputHardware");
            try {
                ITvInputHardware iTvInputHardware = TvInputManagerService.this.mTvInputHardwareManager.acquireHardware(deviceId, callback, info, callingUid, resolvedUserId);
                return iTvInputHardware;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseTvInputHardware(int deviceId, ITvInputHardware hardware, int userId) throws RemoteException {
            if (TvInputManagerService.this.mContext.checkCallingPermission("android.permission.TV_INPUT_HARDWARE") != 0) {
                return;
            }
            long identity = Binder.clearCallingIdentity();
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "releaseTvInputHardware");
            try {
                TvInputManagerService.this.mTvInputHardwareManager.releaseHardware(deviceId, hardware, callingUid, resolvedUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TvStreamConfig> getAvailableTvStreamConfigList(String inputId, int userId) throws RemoteException {
            if (TvInputManagerService.this.mContext.checkCallingPermission("android.permission.CAPTURE_TV_INPUT") != 0) {
                throw new SecurityException("Requires CAPTURE_TV_INPUT permission");
            }
            long identity = Binder.clearCallingIdentity();
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "getAvailableTvStreamConfigList");
            try {
                List<TvStreamConfig> list = TvInputManagerService.this.mTvInputHardwareManager.getAvailableTvStreamConfigList(inputId, callingUid, resolvedUserId);
                return list;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean captureFrame(String inputId, Surface surface, TvStreamConfig config, int userId) throws RemoteException {
            if (TvInputManagerService.this.mContext.checkCallingPermission("android.permission.CAPTURE_TV_INPUT") != 0) {
                throw new SecurityException("Requires CAPTURE_TV_INPUT permission");
            }
            long identity = Binder.clearCallingIdentity();
            int callingUid = Binder.getCallingUid();
            int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "captureFrame");
            try {
                String hardwareInputId = null;
                Object object = TvInputManagerService.this.mLock;
                synchronized (object) {
                    UserState userState;
                    block10: {
                        userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                        if (userState.inputMap.get(inputId) != null) break block10;
                        Slog.e(TvInputManagerService.TAG, "input not found for " + inputId);
                        boolean bl = false;
                        return bl;
                    }
                    for (SessionState sessionState : userState.sessionStateMap.values()) {
                        if (!sessionState.info.getId().equals(inputId) || sessionState.hardwareSessionToken == null) continue;
                        hardwareInputId = ((SessionState)userState.sessionStateMap.get(sessionState.hardwareSessionToken)).info.getId();
                        break;
                    }
                }
                boolean bl = TvInputManagerService.this.mTvInputHardwareManager.captureFrame(hardwareInputId != null ? hardwareInputId : inputId, surface, config, callingUid, resolvedUserId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean isSingleSessionActive(int userId) throws RemoteException {
            SessionState[] sessionStates;
            UserState userState;
            long identity;
            block8: {
                boolean bl;
                identity = Binder.clearCallingIdentity();
                int callingUid = Binder.getCallingUid();
                int resolvedUserId = TvInputManagerService.this.resolveCallingUserId(Binder.getCallingPid(), callingUid, userId, "isSingleSessionActive");
                try {
                    Object object = TvInputManagerService.this.mLock;
                    // MONITORENTER : object
                    userState = TvInputManagerService.this.getUserStateLocked(resolvedUserId);
                    if (userState.sessionStateMap.size() != 1) break block8;
                    bl = true;
                    // MONITOREXIT : object
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(identity);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(identity);
                return bl;
            }
            if (userState.sessionStateMap.size() == 2 && ((sessionStates = userState.sessionStateMap.values().toArray(new SessionState[0]))[0].hardwareSessionToken != null || sessionStates[1].hardwareSessionToken != null)) {
                boolean bl = true;
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(identity);
                return bl;
            }
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(identity);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
            IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
            if (TvInputManagerService.this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump TvInputManager from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
                return;
            }
            Object object = TvInputManagerService.this.mLock;
            synchronized (object) {
                int userId;
                int i;
                pw.println("User Ids (Current user: " + TvInputManagerService.this.mCurrentUserId + "):");
                pw.increaseIndent();
                for (i = 0; i < TvInputManagerService.this.mUserStates.size(); ++i) {
                    userId = TvInputManagerService.this.mUserStates.keyAt(i);
                    pw.println((Object)userId);
                }
                pw.decreaseIndent();
                for (i = 0; i < TvInputManagerService.this.mUserStates.size(); ++i) {
                    userId = TvInputManagerService.this.mUserStates.keyAt(i);
                    UserState userState = TvInputManagerService.this.getUserStateLocked(userId);
                    pw.println("UserState (" + userId + "):");
                    pw.increaseIndent();
                    pw.println("inputMap: inputId -> TvInputState");
                    pw.increaseIndent();
                    for (Map.Entry entry : userState.inputMap.entrySet()) {
                        pw.println((String)entry.getKey() + ": " + entry.getValue());
                    }
                    pw.decreaseIndent();
                    pw.println("packageSet:");
                    pw.increaseIndent();
                    for (String packageName : userState.packageSet) {
                        pw.println(packageName);
                    }
                    pw.decreaseIndent();
                    pw.println("clientStateMap: ITvInputClient -> ClientState");
                    pw.increaseIndent();
                    for (Map.Entry entry : userState.clientStateMap.entrySet()) {
                        ClientState client = (ClientState)entry.getValue();
                        pw.println(entry.getKey() + ": " + client);
                        pw.increaseIndent();
                        pw.println("sessionTokens:");
                        pw.increaseIndent();
                        for (IBinder token : client.sessionTokens) {
                            pw.println("" + token);
                        }
                        pw.decreaseIndent();
                        pw.println("clientTokens: " + client.clientToken);
                        pw.println("userId: " + client.userId);
                        pw.decreaseIndent();
                    }
                    pw.decreaseIndent();
                    pw.println("serviceStateMap: ComponentName -> ServiceState");
                    pw.increaseIndent();
                    for (Map.Entry entry : userState.serviceStateMap.entrySet()) {
                        ServiceState service = (ServiceState)entry.getValue();
                        pw.println(entry.getKey() + ": " + service);
                        pw.increaseIndent();
                        pw.println("sessionTokens:");
                        pw.increaseIndent();
                        for (IBinder token : service.sessionTokens) {
                            pw.println("" + token);
                        }
                        pw.decreaseIndent();
                        pw.println("service: " + service.service);
                        pw.println("callback: " + service.callback);
                        pw.println("bound: " + service.bound);
                        pw.println("reconnecting: " + service.reconnecting);
                        pw.decreaseIndent();
                    }
                    pw.decreaseIndent();
                    pw.println("sessionStateMap: ITvInputSession -> SessionState");
                    pw.increaseIndent();
                    for (Map.Entry entry : userState.sessionStateMap.entrySet()) {
                        SessionState session = (SessionState)entry.getValue();
                        pw.println(entry.getKey() + ": " + session);
                        pw.increaseIndent();
                        pw.println("info: " + session.info);
                        pw.println("client: " + session.client);
                        pw.println("seq: " + session.seq);
                        pw.println("callingUid: " + session.callingUid);
                        pw.println("userId: " + session.userId);
                        pw.println("sessionToken: " + session.sessionToken);
                        pw.println("session: " + session.session);
                        pw.println("logUri: " + session.logUri);
                        pw.println("hardwareSessionToken: " + session.hardwareSessionToken);
                        pw.decreaseIndent();
                    }
                    pw.decreaseIndent();
                    pw.println("callbackSet:");
                    pw.increaseIndent();
                    for (ITvInputManagerCallback callback : userState.callbackSet) {
                        pw.println(callback.toString());
                    }
                    pw.decreaseIndent();
                    pw.println("mainSessionToken: " + userState.mainSessionToken);
                    pw.decreaseIndent();
                }
            }
        }
    }
}

