/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.TimeSparseArray;
import android.util.AtomicFile;
import android.util.Slog;
import com.android.server.usage.IntervalStats;
import com.android.server.usage.UnixCalendar;
import com.android.server.usage.UsageStatsXml;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class UsageStatsDatabase {
    private static final int CURRENT_VERSION = 2;
    private static final String TAG = "UsageStatsDatabase";
    private static final boolean DEBUG = false;
    private final Object mLock = new Object();
    private final File[] mIntervalDirs;
    private final TimeSparseArray<AtomicFile>[] mSortedStatFiles;
    private final UnixCalendar mCal;
    private final File mVersionFile;

    public UsageStatsDatabase(File dir) {
        this.mIntervalDirs = new File[]{new File(dir, "daily"), new File(dir, "weekly"), new File(dir, "monthly"), new File(dir, "yearly")};
        this.mVersionFile = new File(dir, "version");
        this.mSortedStatFiles = new TimeSparseArray[this.mIntervalDirs.length];
        this.mCal = new UnixCalendar(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(long currentTimeMillis) {
        Object object = this.mLock;
        synchronized (object) {
            for (File f : this.mIntervalDirs) {
                f.mkdirs();
                if (f.exists()) continue;
                throw new IllegalStateException("Failed to create directory " + f.getAbsolutePath());
            }
            this.checkVersionLocked();
            this.indexFilesLocked();
            for (TimeSparseArray<AtomicFile> files : this.mSortedStatFiles) {
                int i;
                int startIndex = files.closestIndexOnOrAfter(currentTimeMillis);
                if (startIndex < 0) continue;
                int fileCount = files.size();
                for (i = startIndex; i < fileCount; ++i) {
                    ((AtomicFile)files.valueAt(i)).delete();
                }
                for (i = startIndex; i < fileCount; ++i) {
                    files.removeAt(i);
                }
            }
        }
    }

    private void indexFilesLocked() {
        FilenameFilter backupFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return !name.endsWith(".bak");
            }
        };
        for (int i = 0; i < this.mSortedStatFiles.length; ++i) {
            if (this.mSortedStatFiles[i] == null) {
                this.mSortedStatFiles[i] = new TimeSparseArray();
            } else {
                this.mSortedStatFiles[i].clear();
            }
            File[] files = this.mIntervalDirs[i].listFiles(backupFileFilter);
            if (files == null) continue;
            for (File f : files) {
                AtomicFile af = new AtomicFile(f);
                this.mSortedStatFiles[i].put(UsageStatsXml.parseBeginTime(af), af);
            }
        }
    }

    private void checkVersionLocked() {
        int version;
        Throwable throwable;
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(this.mVersionFile));){
                version = Integer.parseInt(reader.readLine());
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        catch (IOException | NumberFormatException e) {
            version = 0;
        }
        if (version != 2) {
            Slog.i(TAG, "Upgrading from version " + version + " to " + 2);
            this.doUpgradeLocked(version);
            try {
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.mVersionFile));){
                    writer.write(Integer.toString(2));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to write new version");
                throw new RuntimeException(e);
            }
        }
    }

    private void doUpgradeLocked(int thisVersion) {
        if (thisVersion < 2) {
            Slog.i(TAG, "Deleting all usage stats files");
            for (int i = 0; i < this.mIntervalDirs.length; ++i) {
                File[] files = this.mIntervalDirs[i].listFiles();
                if (files == null) continue;
                for (File f : files) {
                    f.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeChanged(long timeDiffMillis) {
        Object object = this.mLock;
        synchronized (object) {
            for (TimeSparseArray<AtomicFile> files : this.mSortedStatFiles) {
                int fileCount = files.size();
                for (int i = 0; i < fileCount; ++i) {
                    AtomicFile file = (AtomicFile)files.valueAt(i);
                    long newTime = files.keyAt(i) + timeDiffMillis;
                    if (newTime < 0L) {
                        Slog.i(TAG, "Deleting file " + file.getBaseFile().getAbsolutePath() + " for it is in the future now.");
                        file.delete();
                        continue;
                    }
                    try {
                        file.openRead().close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    File newFile = new File(file.getBaseFile().getParentFile(), Long.toString(newTime));
                    Slog.i(TAG, "Moving file " + file.getBaseFile().getAbsolutePath() + " to " + newFile.getAbsolutePath());
                    file.getBaseFile().renameTo(newFile);
                }
                files.clear();
            }
            this.indexFilesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntervalStats getLatestUsageStats(int intervalType) {
        Object object = this.mLock;
        synchronized (object) {
            if (intervalType < 0 || intervalType >= this.mIntervalDirs.length) {
                throw new IllegalArgumentException("Bad interval type " + intervalType);
            }
            int fileCount = this.mSortedStatFiles[intervalType].size();
            if (fileCount == 0) {
                return null;
            }
            try {
                AtomicFile f = (AtomicFile)this.mSortedStatFiles[intervalType].valueAt(fileCount - 1);
                IntervalStats stats = new IntervalStats();
                UsageStatsXml.read(f, stats);
                return stats;
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to read usage stats file", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestUsageStatsBeginTime(int intervalType) {
        Object object = this.mLock;
        synchronized (object) {
            if (intervalType < 0 || intervalType >= this.mIntervalDirs.length) {
                throw new IllegalArgumentException("Bad interval type " + intervalType);
            }
            int statsFileCount = this.mSortedStatFiles[intervalType].size();
            if (statsFileCount > 0) {
                return this.mSortedStatFiles[intervalType].keyAt(statsFileCount - 1);
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> queryUsageStats(int intervalType, long beginTime, long endTime, StatCombiner<T> combiner) {
        Object object = this.mLock;
        synchronized (object) {
            int endIndex;
            if (intervalType < 0 || intervalType >= this.mIntervalDirs.length) {
                throw new IllegalArgumentException("Bad interval type " + intervalType);
            }
            TimeSparseArray<AtomicFile> intervalStats = this.mSortedStatFiles[intervalType];
            if (endTime <= beginTime) {
                return null;
            }
            int startIndex = intervalStats.closestIndexOnOrBefore(beginTime);
            if (startIndex < 0) {
                startIndex = 0;
            }
            if ((endIndex = intervalStats.closestIndexOnOrBefore(endTime)) < 0) {
                return null;
            }
            if (intervalStats.keyAt(endIndex) == endTime && --endIndex < 0) {
                return null;
            }
            try {
                IntervalStats stats = new IntervalStats();
                ArrayList results = new ArrayList();
                for (int i = startIndex; i <= endIndex; ++i) {
                    AtomicFile f = (AtomicFile)intervalStats.valueAt(i);
                    UsageStatsXml.read(f, stats);
                    if (beginTime >= stats.endTime) continue;
                    combiner.combine(stats, false, results);
                }
                return results;
            }
            catch (IOException e) {
                Slog.e(TAG, "Failed to read usage stats file", e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findBestFitBucket(long beginTimeStamp, long endTimeStamp) {
        Object object = this.mLock;
        synchronized (object) {
            int bestBucket = -1;
            long smallestDiff = Long.MAX_VALUE;
            for (int i = this.mSortedStatFiles.length - 1; i >= 0; --i) {
                long diff;
                int index = this.mSortedStatFiles[i].closestIndexOnOrBefore(beginTimeStamp);
                int size = this.mSortedStatFiles[i].size();
                if (index < 0 || index >= size || (diff = Math.abs(this.mSortedStatFiles[i].keyAt(index) - beginTimeStamp)) >= smallestDiff) continue;
                smallestDiff = diff;
                bestBucket = i;
            }
            return bestBucket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune(long currentTimeMillis) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addYears(-3);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[3], this.mCal.getTimeInMillis());
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addMonths(-6);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[2], this.mCal.getTimeInMillis());
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addWeeks(-4);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[1], this.mCal.getTimeInMillis());
            this.mCal.setTimeInMillis(currentTimeMillis);
            this.mCal.addDays(-7);
            UsageStatsDatabase.pruneFilesOlderThan(this.mIntervalDirs[0], this.mCal.getTimeInMillis());
        }
    }

    private static void pruneFilesOlderThan(File dir, long expiryTime) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                long beginTime;
                String path = f.getPath();
                if (path.endsWith(".bak")) {
                    f = new File(path.substring(0, path.length() - 4));
                }
                if ((beginTime = Long.parseLong(f.getName())) >= expiryTime) continue;
                new AtomicFile(f).delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putUsageStats(int intervalType, IntervalStats stats) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (intervalType < 0 || intervalType >= this.mIntervalDirs.length) {
                throw new IllegalArgumentException("Bad interval type " + intervalType);
            }
            AtomicFile f = (AtomicFile)this.mSortedStatFiles[intervalType].get(stats.beginTime);
            if (f == null) {
                f = new AtomicFile(new File(this.mIntervalDirs[intervalType], Long.toString(stats.beginTime)));
                this.mSortedStatFiles[intervalType].put(stats.beginTime, f);
            }
            UsageStatsXml.write(f, stats);
            stats.lastTimeSaved = f.getLastModifiedTime();
        }
    }

    static interface StatCombiner<T> {
        public void combine(IntervalStats var1, boolean var2, List<T> var3);
    }
}

