/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.AppOpsManager;
import android.app.usage.ConfigurationStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.os.BackgroundThread;
import com.android.server.SystemService;
import com.android.server.usage.UserUsageStatsService;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class UsageStatsService
extends SystemService
implements UserUsageStatsService.StatsUpdatedListener {
    static final String TAG = "UsageStatsService";
    static final boolean DEBUG = false;
    private static final long TEN_SECONDS = 10000L;
    private static final long TWENTY_MINUTES = 1200000L;
    private static final long FLUSH_INTERVAL = 1200000L;
    private static final long TIME_CHANGE_THRESHOLD_MILLIS = 2000L;
    static final int MSG_REPORT_EVENT = 0;
    static final int MSG_FLUSH_TO_DISK = 1;
    static final int MSG_REMOVE_USER = 2;
    private final Object mLock = new Object();
    Handler mHandler;
    AppOpsManager mAppOps;
    UserManager mUserManager;
    private final SparseArray<UserUsageStatsService> mUserState = new SparseArray();
    private File mUsageStatsDir;
    long mRealTimeSnapshot;
    long mSystemTimeSnapshot;

    public UsageStatsService(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
        this.mUserManager = (UserManager)this.getContext().getSystemService("user");
        this.mHandler = new H(BackgroundThread.get().getLooper());
        File systemDataDir = new File(Environment.getDataDirectory(), "system");
        this.mUsageStatsDir = new File(systemDataDir, "usagestats");
        this.mUsageStatsDir.mkdirs();
        if (!this.mUsageStatsDir.exists()) {
            throw new IllegalStateException("Usage stats directory does not exist: " + this.mUsageStatsDir.getAbsolutePath());
        }
        this.getContext().registerReceiver(new UserRemovedReceiver(), new IntentFilter("android.intent.action.USER_REMOVED"));
        Object object = this.mLock;
        synchronized (object) {
            this.cleanUpRemovedUsersLocked();
        }
        this.mRealTimeSnapshot = SystemClock.elapsedRealtime();
        this.mSystemTimeSnapshot = System.currentTimeMillis();
        this.publishLocalService(UsageStatsManagerInternal.class, new LocalService());
        this.publishBinderService("usagestats", new BinderService());
    }

    @Override
    public void onStatsUpdated() {
        this.mHandler.sendEmptyMessageDelayed(1, 1200000L);
    }

    private void cleanUpRemovedUsersLocked() {
        List<UserInfo> users = this.mUserManager.getUsers(true);
        if (users == null || users.size() == 0) {
            throw new IllegalStateException("There can't be no users");
        }
        ArraySet<String> toDelete = new ArraySet<String>();
        String[] fileNames = this.mUsageStatsDir.list();
        if (fileNames == null) {
            return;
        }
        toDelete.addAll(Arrays.asList(fileNames));
        int userCount = users.size();
        for (int i = 0; i < userCount; ++i) {
            UserInfo userInfo = users.get(i);
            toDelete.remove(Integer.toString(userInfo.id));
        }
        int deleteCount = toDelete.size();
        for (int i = 0; i < deleteCount; ++i) {
            UsageStatsService.deleteRecursively(new File(this.mUsageStatsDir, (String)toDelete.valueAt(i)));
        }
    }

    private static void deleteRecursively(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            for (File subFile : files) {
                UsageStatsService.deleteRecursively(subFile);
            }
        }
        if (!f.delete()) {
            Slog.e(TAG, "Failed to delete " + f);
        }
    }

    private UserUsageStatsService getUserDataAndInitializeIfNeededLocked(int userId, long currentTimeMillis) {
        UserUsageStatsService service = this.mUserState.get(userId);
        if (service == null) {
            service = new UserUsageStatsService(userId, new File(this.mUsageStatsDir, Integer.toString(userId)), this);
            service.init(currentTimeMillis);
            this.mUserState.put(userId, service);
        }
        return service;
    }

    private long checkAndGetTimeLocked() {
        long actualRealtime;
        long expectedSystemTime;
        long actualSystemTime = System.currentTimeMillis();
        if (Math.abs(actualSystemTime - (expectedSystemTime = (actualRealtime = SystemClock.elapsedRealtime()) - this.mRealTimeSnapshot + this.mSystemTimeSnapshot)) > 2000L) {
            int userCount = this.mUserState.size();
            for (int i = 0; i < userCount; ++i) {
                UserUsageStatsService service = this.mUserState.valueAt(i);
                service.onTimeChanged(expectedSystemTime, actualSystemTime);
            }
            this.mRealTimeSnapshot = actualRealtime;
            this.mSystemTimeSnapshot = actualSystemTime;
        }
        return actualSystemTime;
    }

    private void convertToSystemTimeLocked(UsageEvents.Event event) {
        event.mTimeStamp = Math.max(0L, event.mTimeStamp - this.mRealTimeSnapshot) + this.mSystemTimeSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeMessages(0);
            this.flushToDiskLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportEvent(UsageEvents.Event event, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            this.convertToSystemTimeLocked(event);
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            service.reportEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushToDisk() {
        Object object = this.mLock;
        synchronized (object) {
            this.flushToDiskLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.i(TAG, "Removing user " + userId + " and all data.");
            this.mUserState.remove(userId);
            this.cleanUpRemovedUsersLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UsageStats> queryUsageStats(int userId, int bucketType, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryUsageStats(bucketType, beginTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ConfigurationStats> queryConfigurationStats(int userId, int bucketType, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryConfigurationStats(bucketType, beginTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsageEvents queryEvents(int userId, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryEvents(beginTime, endTime);
        }
    }

    private static boolean validRange(long currentTime, long beginTime, long endTime) {
        return beginTime <= currentTime && beginTime < endTime;
    }

    private void flushToDiskLocked() {
        int userCount = this.mUserState.size();
        for (int i = 0; i < userCount; ++i) {
            UserUsageStatsService service = this.mUserState.valueAt(i);
            service.persistActiveStats();
        }
        this.mHandler.removeMessages(1);
    }

    private class LocalService
    extends UsageStatsManagerInternal {
        private LocalService() {
        }

        @Override
        public void reportEvent(ComponentName component, int userId, int eventType) {
            if (component == null) {
                Slog.w(UsageStatsService.TAG, "Event reported without a component name");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = component.getPackageName();
            event.mClass = component.getClassName();
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = eventType;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportConfigurationChange(Configuration config, int userId) {
            if (config == null) {
                Slog.w(UsageStatsService.TAG, "Configuration event reported with a null config");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = "android";
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = 5;
            event.mConfiguration = new Configuration(config);
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void prepareShutdown() {
            UsageStatsService.this.shutdown();
        }
    }

    private class BinderService
    extends IUsageStatsManager.Stub {
        private BinderService() {
        }

        private boolean hasPermission(String callingPackage) {
            int mode = UsageStatsService.this.mAppOps.checkOp(43, Binder.getCallingUid(), callingPackage);
            if (mode == 3) {
                return UsageStatsService.this.getContext().checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") == 0;
            }
            return mode == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<UsageStats> queryUsageStats(int bucketType, long beginTime, long endTime, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                List<UsageStats> results = UsageStatsService.this.queryUsageStats(userId, bucketType, beginTime, endTime);
                if (results != null) {
                    ParceledListSlice<UsageStats> parceledListSlice = new ParceledListSlice<UsageStats>(results);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<ConfigurationStats> queryConfigurationStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                List<ConfigurationStats> results = UsageStatsService.this.queryConfigurationStats(userId, bucketType, beginTime, endTime);
                if (results != null) {
                    ParceledListSlice<ConfigurationStats> parceledListSlice = new ParceledListSlice<ConfigurationStats>(results);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsageEvents queryEvents(long beginTime, long endTime, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                UsageEvents usageEvents = UsageStatsService.this.queryEvents(userId, beginTime, endTime);
                return usageEvents;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    UsageStatsService.this.reportEvent((UsageEvents.Event)msg.obj, msg.arg1);
                    break;
                }
                case 1: {
                    UsageStatsService.this.flushToDisk();
                    break;
                }
                case 2: {
                    UsageStatsService.this.removeUser(msg.arg1);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private class UserRemovedReceiver
    extends BroadcastReceiver {
        private UserRemovedReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            int userId;
            if (intent != null && intent.getAction().equals("android.intent.action.USER_REMOVED") && (userId = intent.getIntExtra("android.intent.extra.user_handle", -1)) >= 0) {
                UsageStatsService.this.mHandler.obtainMessage(2, userId, 0).sendToTarget();
            }
        }
    }
}

