/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.usage.IntervalStats;
import com.android.server.usage.UsageStatsXmlV1;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class UsageStatsXml {
    private static final String TAG = "UsageStatsXml";
    private static final int CURRENT_VERSION = 1;
    private static final String USAGESTATS_TAG = "usagestats";
    private static final String VERSION_ATTR = "version";

    public static long parseBeginTime(AtomicFile file) {
        return Long.parseLong(file.getBaseFile().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(AtomicFile file, IntervalStats statsOut) throws IOException {
        try {
            FileInputStream in = file.openRead();
            try {
                statsOut.beginTime = UsageStatsXml.parseBeginTime(file);
                UsageStatsXml.read(in, statsOut);
                statsOut.lastTimeSaved = file.getLastModifiedTime();
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            Slog.e(TAG, "UsageStats Xml", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(AtomicFile file, IntervalStats stats) throws IOException {
        FileOutputStream fos = file.startWrite();
        try {
            UsageStatsXml.write(fos, stats);
            file.finishWrite(fos);
            fos = null;
        }
        finally {
            file.failWrite(fos);
        }
    }

    private static void read(InputStream in, IntervalStats statsOut) throws IOException {
        XmlPullParser parser = Xml.newPullParser();
        try {
            parser.setInput(in, "utf-8");
            XmlUtils.beginDocument(parser, USAGESTATS_TAG);
            String versionStr = parser.getAttributeValue(null, VERSION_ATTR);
            try {
                switch (Integer.parseInt(versionStr)) {
                    case 1: {
                        UsageStatsXmlV1.read(parser, statsOut);
                        break;
                    }
                    default: {
                        Slog.e(TAG, "Unrecognized version " + versionStr);
                        throw new IOException("Unrecognized version " + versionStr);
                    }
                }
            }
            catch (NumberFormatException e) {
                Slog.e(TAG, "Bad version");
                throw new IOException(e);
            }
        }
        catch (XmlPullParserException e) {
            Slog.e(TAG, "Failed to parse Xml", e);
            throw new IOException(e);
        }
    }

    private static void write(OutputStream out, IntervalStats stats) throws IOException {
        FastXmlSerializer xml2 = new FastXmlSerializer();
        xml2.setOutput(out, "utf-8");
        xml2.startDocument("utf-8", true);
        xml2.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        xml2.startTag(null, USAGESTATS_TAG);
        xml2.attribute(null, VERSION_ATTR, Integer.toString(1));
        UsageStatsXmlV1.write(xml2, stats);
        xml2.endTag(null, USAGESTATS_TAG);
        xml2.endDocument();
    }
}

